# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'Domingo',
        1: 'Segunda-feira',
        2: 'Terça-feira',
        3: 'Quarta-feira',
        4: 'Quinta-feira',
        5: 'Sexta-feira',
        6: 'Sábado'
    },
    'days_abbrev': {
        0: 'Dom',
        1: 'Seg',
        2: 'Ter',
        3: 'Qua',
        4: 'Qui',
        5: 'Sex',
        6: 'Sab'
    },

    # Months
    'months': {
        1: 'Janeiro',
        2: 'Fevereiro',
        3: 'Março',
        4: 'Abril',
        5: 'Maio',
        6: 'Junho',
        7: 'Julho',
        8: 'Agosto',
        9: 'Setembro',
        10: 'Outubro',
        11: 'Novembro',
        12: 'Dezembro',
    },
    'months_abbrev': {
        1: 'Jan',
        2: 'Fev',
        3: 'Mar',
        4: 'Abr',
        5: 'Maio',
        6: 'Jun',
        7: 'Jul',
        8: 'Ago',
        9: 'Set',
        10: 'Out',
        11: 'Nov',
        12: 'Dez',
    },

    # Units of time
    'year': ['{count} ano', '{count} anos'],
    'month': ['{count} mês', '{count} meses'],
    'week': ['{count} semana', '{count} semanas'],
    'day': ['{count} dia', '{count} dias'],
    'hour': ['{count} hora', '{count} horas'],
    'minute': ['{count} minuto', '{count} minutos'],
    'second': ['{count} segundo', '{count} segundos'],

    # Relative time
    'ago': 'há {time}',
    'from_now': 'dentro de {time}',
    'after': 'após {time}',
    'before': '{time} atrás',

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd, D [de] MMMM [de] YYYY [às] HH:mm',
        'LLL': 'D [de] MMMM [de] YYYY [às] HH:mm',
        'LL': 'D [de] MMMM [de] YYYY',
        'L': 'DD/MM/YYYY',
    },
}
