# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'sunnuntai',
        1: 'maanantai',
        2: 'tiistai',
        3: 'keskiviikko',
        4: 'torstai',
        5: 'perjantai',
        6: 'lauantai'
    },
    'days_abbrev': {
        0: 'su',
        1: 'ma',
        2: 'ti',
        3: 'ke',
        4: 'to',
        5: 'pe',
        6: 'la'
    },

    # Months
    'months': {
        1: 'tammikuu',
        2: 'helmikuu',
        3: 'maaliskuu',
        4: 'huhtikuu',
        5: 'toukokuu',
        6: 'kesäkuu',
        7: 'heinäkuu',
        8: 'elokuu',
        9: 'syyskuu',
        10: 'lokakuu',
        11: 'marraskuu',
        12: 'joulukuu',
    },
    'months_abbrev': {
        1: 'tammi',
        2: 'helmi',
        3: 'maalis',
        4: 'huhti',
        5: 'touko',
        6: 'kesä',
        7: 'heinä',
        8: 'elo',
        9: 'syys',
        10: 'loka',
        11: 'marras',
        12: 'joulu',
    },

    # Units of time
    'year': ['{count} vuosi', '{count} vuotta'],
    'month': ['{count} kuukausi', '{count} kuukautta'],
    'week': ['{count} viikko', '{count} viikkoa'],
    'day': ['{count} päivä', '{count} päivää'],
    'hour': ['{count} tunti', '{count} tuntia'],
    'minute': ['{count} minuutti', '{count} minuuttia'],
    'second': ['{count} sekunti', '{count} sekuntia'],

    # Relative time
    'ago': '{time} sitten',
    'from_now': '{time} tästä hetkestä',
    'after': '{time} sen jälkeen',
    'before': '{time} ennen',

    # Date formats
    'date_formats': {
        'LTS': 'HH.mm.ss',
        'LT': 'HH.mm',
        'LLLL': 'dddd, Do MMMM[ta] YYYY, [klo] HH.mm',
        'LLL': 'Do MMMM[ta] YYYY, [klo] HH.mm',
        'LL': 'Do MMMM[ta] YYYY',
        'L': 'DD.MM.YYYY',
    },
}
