# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'neděle',
        1: 'pondělí',
        2: 'úterý',
        3: 'středa',
        4: 'čtvrtek',
        5: 'pátek',
        6: 'sobota'
    },
    'days_abbrev': {
        0: 'ne',
        1: 'po',
        2: 'út',
        3: 'st',
        4: 'čt',
        5: 'pá',
        6: 'so'
    },

    # Months
    'months': {
        1: 'leden',
        2: 'únor',
        3: 'březen',
        4: 'duben',
        5: 'květen',
        6: 'červen',
        7: 'červenec',
        8: 'srpen',
        9: 'září',
        10: 'říjen',
        11: 'listopad',
        12: 'prosinec',
    },
    'months_abbrev': {
        1: 'led',
        2: 'úno',
        3: 'bře',
        4: 'dub',
        5: 'kvě',
        6: 'čvn',
        7: 'čvc',
        8: 'srp',
        9: 'zář',
        10: 'říj',
        11: 'lis',
        12: 'pro',
    },

    # Units of time
    'year': ['{count} rok', '{count} roky', '{count} let'],
    'month': ['{count} měsíc', '{count} měsíce', '{count} měsíců'],
    'week': ['{count} týden', '{count} týdny', '{count} týdnů'],
    'day': ['{count} den', '{count} dny', '{count} dní'],
    'hour': ['{count} hodina', '{count} hodiny', '{count} hodin'],
    'minute': ['{count} minuta', '{count} minuty', '{count} minut'],
    'second': ['{count} sekunda', '{count} sekundy', '{count} sekund'],

    # Relative time
    'ago': '{time} nazpět',
    'from_now': 'za {time}',
    'after': '{time} později',
    'before': '{time} předtím',

    # Date formats
    'date_formats': {
        'LTS': 'H:mm:ss',
        'LT': 'H:mm',
        'LLLL': 'dddd D. MMMM YYYY H:mm',
        'LLL': 'D. MMMM YYYY H:mm',
        'LL': 'D. MMMM YYYY',
        'L': 'DD.MM.YYYY',
    },
}
