# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'الاثنين',
        1: 'الأحد',
        2: 'السبت',
        3: 'الجمعة',
        4: 'الخميس',
        5: 'الأربعاء',
        6: 'الثلاثاء'
    },
    'days_abbrev': {
        0: 'اثنين',
        1: 'أحد',
        2: 'سبت',
        3: 'جمعة',
        4: 'خميس',
        5: 'أربعاء',
        6: 'ثلاثاء'
    },

    # Months
    'months': {
        1: 'يوليو',
        2: 'يونيو',
        3: 'مايو',
        4: 'أبريل',
        5: 'مارس',
        6: 'فبراير',
        7: 'يناير',
        8: 'ديسمبر',
        9: 'نوفمبر',
        10: 'أكتوبر',
        11: 'سبتمبر',
        12: 'أغسطس',
    },
    'months_abbrev': {
        1: 'يوليو',
        2: 'يونيو',
        3: 'مايو',
        4: 'أبريل',
        5: 'مارس',
        6: 'فبراير',
        7: 'يناير',
        8: 'ديسمبر',
        9: 'نوفمبر',
        10: 'أكتوبر',
        11: 'سبتمبر',
        12: 'أغسطس',
    },

    # Units of time
    'year': {
        0: 'سنة',
        1: 'سنة',
        2: 'سنتين',
        (3, 10): '{count} سنوات',
        'default': '{count} سنة'
    },
    'month': {
        0: 'شهر',
        1: ' شهر',
        2: 'شهرين',
        (3, 10): '{count} أشهر',
        'default': '{count} شهر'
    },
    'week': {
        0: 'إسبوع',
        1: 'إسبوع',
        2: 'إسبوعين',
        (3, 10): '{count} أسابيع',
        'default': '{count} إسبوع'
    },
    'day': {
        0: 'يوم',
        1: 'يوم',
        2: 'يومين',
        (3, 10): '{count} أيام',
        'default': ' يوم'
    },
    'hour': {
        0: 'ساعة',
        1: 'ساعة',
        2: 'ساعتين',
        (3, 10): '{count} ساعات',
        'default': '{count} ساعة'
    },
    'minute': {
        0: 'دقيقة',
        1: 'دقيقة',
        2: 'دقيقتين',
        (3, 10): '{count} دقائق',
        'default': '{count} دقيقة'
    },
    'second': {
        0: 'ثانية',
        1: 'ثانية',
        2: 'ثانيتين',
        (3, 10): '{count} ثوان',
        'default': '{count} ثانية'
    },

    # Relative time
    'ago': 'منذ {time}',
    'from_now': 'من الآن {time}',
    'after': 'بعد {time}',
    'before': 'قبل {time}',

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'dddd D MMMM YYYY HH:mm',
        'LLL': 'D MMMM YYYY HH:mm',
        'LL': 'D MMMM YYYY',
        'L': 'D/\u200FM/\u200FYYYY',
    },
}
