# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'domingo',
        1: 'lunes',
        2: 'martes',
        3: 'miércoles',
        4: 'jueves',
        5: 'viernes',
        6: 'sábado',
    },
    'days_abbrev': {
        0: 'dom',
        1: 'lun',
        2: 'mar',
        3: 'mie',
        4: 'jue',
        5: 'vie',
        6: 'sab'
    },

    # Months
    'months': {
        1: 'enero',
        2: 'febrero',
        3: 'marzo',
        4: 'abril',
        5: 'mayo',
        6: 'junio',
        7: 'julio',
        8: 'agosto',
        9: 'septiembre',
        10: 'octubre',
        11: 'noviembre',
        12: 'diciembre',
    },
    'months_abbrev': {
        1: 'ene',
        2: 'feb',
        3: 'mar',
        4: 'abr',
        5: 'may',
        6: 'jun',
        7: 'jul',
        8: 'ago',
        9: 'sep',
        10: 'oct',
        11: 'nov',
        12: 'dec',
    },

    # Units of time
    'year': ['{count} año', '{count} años'],
    'month': ['{count} mes', '{count} meses'],
    'week': ['{count} semana', '{count} semanas'],
    'day': ['{count} día', '{count} días'],
    'hour': ['{count} hora', '{count} horas'],
    'minute': ['{count} minuto', '{count} minutos'],
    'second': ['{count} segundo', '{count} segundos'],

    # Relative time
    'ago': 'hace {time}',
    'from_now': 'dentro de {time}',
    'after': '{time} después',
    'before': '{time} antes',

    # Ordinals
    'ordinal': 'º',

    # Date formats
    'date_formats': {
        'LTS': 'H:mm:ss',
        'LT': 'H:mm',
        'LLLL': 'dddd, D [de] MMMM [de] YYYY H:mm',
        'LLL': 'D [de] MMMM [de] YYYY H:mm',
        'LL': 'D [de] MMMM [de] YYYY',
        'L': 'DD/MM/YYYY',
    },
}
