# -*- coding: utf-8 -*-

translations = {
    # Days
    'days': {
        0: 'svētdiena',
        1: 'pirmdiena',
        2: 'otrdiena',
        3: 'trešdiena',
        4: 'ceturtdiena',
        5: 'piektdiena',
        6: 'sestdiena'
    },
    'days_abbrev': {
        0: 'Sv',
        1: 'P',
        2: 'O',
        3: 'T',
        4: 'C',
        5: 'Pk',
        6: 'S'
    },

    # Months
    'months': {
        1: 'janvāris',
        2: 'februāris',
        3: 'marts',
        4: 'aprīlis',
        5: 'maijs',
        6: 'jūnijs',
        7: 'jūlijs',
        8: 'augusts',
        9: 'septembris',
        10: 'oktobris',
        11: 'novembris',
        12: 'decembris'
    },
    'months_abbrev': {
        1: 'jan',
        2: 'feb',
        3: 'mar',
        4: 'apr',
        5: 'mai',
        6: 'jūn',
        7: 'jūl',
        8: 'aug',
        9: 'sep',
        10: 'okt',
        11: 'nov',
        12: 'dec'
    },

    # Units of time
    'year': ['0 gadiem', '{count} gada', '{count} gadiem'],
    'month': ['0 mēnešiem', '{count} mēneša', '{count} mēnešiem'],
    'week': ['0 nedēļām', '{count} nedēļas', '{count} nedēļām'],
    'day': ['0 dienām', '{count} dienas', '{count} dienām'],
    'hour': ['0 stundām', '{count} stundas', '{count} stundām'],
    'minute': ['0 minūtēm', '{count} minūtes', '{count} minūtēm'],
    'second': ['0 sekundēm', '{count} sekundes', '{count} sekundēm'],

    # Relative time
    'ago': 'pirms {time}',
    'from_now': 'pēc {time}',
    'after': '{time} vēlāk',
    'before': '{time} pirms',

    'year_after': ['0 gadus', '{count} gadu', '{count} gadus'],
    'month_after': ['0 mēnešus', '{count} mēnesi', '{count} mēnešus'],
    'week_after': ['0 nedēļas', '{count} nedēļu', '{count} nedēļas'],
    'day_after': ['0 dienas', '{count} dienu', '{count} dienas'],
    'hour_after': ['0 stundas', '{count} stundu', '{count} stundas'],
    'minute_after': ['0 minūtes', '{count} minūti', '{count} minūtes'],
    'second_after': ['0 sekundes', '{count} sekundi', '{count} sekundes'],

    'year_before': ['0 gadus', '{count} gadu', '{count} gadus'],
    'month_before': ['0 mēnešus', '{count} mēnesi', '{count} mēnešus'],
    'week_before': ['0 nedēļas', '{count} nedēļu', '{count} nedēļas'],
    'day_before': ['0 dienas', '{count} dienu', '{count} dienas'],
    'hour_before': ['0 stundas', '{count} stundu', '{count} stundas'],
    'minute_before': ['0 minūtes', '{count} minūti', '{count} minūtes'],
    'second_before': ['0 sekundes', '{count} sekundi', '{count} sekundes'],

    # Date formats
    'date_formats': {
        'LTS': 'HH:mm:ss',
        'LT': 'HH:mm',
        'LLLL': 'YYYY. [gada] D. MMMM, dddd, HH:mm',
        'LLL': 'YYYY. [gada] D. MMMM, HH:mm',
        'LL': 'YYYY. [gada] D. MMMM',
        'L': 'DD.MM.YYYY.',
    },
}
