/* Copyright 2017-2018 PaGMO development team

This file is part of the PaGMO library.

The PaGMO library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 3 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The PaGMO library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the PaGMO library.  If not,
see https://www.gnu.org/licenses/. */

#ifndef PAGMO_CONFIG_HPP
#define PAGMO_CONFIG_HPP

// Start of defines instantiated by CMake.
// clang-format off
#define PAGMO_VERSION "2.8"
#define PAGMO_VERSION_MAJOR 2
#define PAGMO_VERSION_MINOR 8
#define PAGMO_WITH_EIGEN3
#define PAGMO_WITH_NLOPT

// clang-format on
// End of defines instantiated by CMake.

// NOTE: some compilers are not able to deal with the large data
// arrays embedded in the CEC 2013/2014 problems. We thus implement
// here some heuristic to signal the capability of compiling
// these problems on the current platform.

#if !defined(_MSC_VER)

// NOTE: thus far, only MSVC 2015 has issues with cec2013. In the future
// we might want to check if later versions fix this issue, in such a case
// we can make this switch dependent on the specific compiler version.
#define PAGMO_ENABLE_CEC2013

#endif

#if !defined(_MSC_VER) && (!defined(__apple_build_version__) || (defined(__clang_major__) && __clang_major__ >= 9))

// NOTE: MSVC and early versions of Xcode clang have issues with cec2014.
// We've seen this working properly on Xcode 9.4, so let's tentatively enable it for Xcode >= 9.
#define PAGMO_ENABLE_CEC2014

#endif

#endif
