
#ifndef PAGMO_CEC2013_DATA_HPP
#define PAGMO_CEC2013_DATA_HPP

#include <initializer_list>
#include <unordered_map>
#include <vector>

namespace pagmo
{
namespace detail
{

template <typename = void>
struct cec2013_data_ {
    static const std::unordered_map<unsigned, std::vector<double>> MD;
    static const std::vector<double> shift_data;
};
// clang-format off
template <typename T>
const std::unordered_map<unsigned,std::vector<double>> cec2013_data_<T>::MD = {{2u,{-6.4985711895798781e-01,-7.6005639589416241e-01,7.6005639589416241e-01,-6.4985711895798781e-01,8.9822993821175368e-01,-4.3952585600861893e-01,4.3952585600861893e-01,8.9822993821175368e-01,-2.5517719061728122e-01,-9.6689430724804226e-01,9.6689430724804226e-01,-2.5517719061728122e-01,-6.4570410476787210e-01,7.6358772193240565e-01,-7.6358772193240565e-01,-6.4570410476787210e-01,-8.6934765610621867e-01,-4.9420102470818883e-01,4.9420102470818883e-01,-8.6934765610621867e-01,4.4934844932308798e-01,8.9335657555700354e-01,-8.9335657555700354e-01,4.4934844932308798e-01,9.3449633491188222e-01,3.5597275181712890e-01,-3.5597275181712890e-01,9.3449633491188222e-01,8.9749712493043288e-01,-4.4102030649575180e-01,4.4102030649575180e-01,8.9749712493043288e-01,5.8091130819342474e-01,8.1396686174131427e-01,-8.1396686174131427e-01,5.8091130819342474e-01,2.4297106046965544e-01,-9.7003353744819110e-01,9.7003353744819110e-01,2.4297106046965544e-01}},{5u,{-2.0099973130783849e-02,-3.2880089796201317e-01,-9.4310133651887507e-01,2.1732624590495193e-02,-3.9667652618168722e-02,4.9005042436373569e-01,5.1355266966876811e-01,-1.8145345659471285e-01,-4.9800950627889673e-01,-4.6387003762118872e-01,5.6757852302959233e-01,-7.4260002295357697e-01,2.5475155936120497e-01,-8.2131308592423527e-02,-2.3399982319827489e-01,6.5708280582652179e-01,2.5938077544956950e-01,-1.1202186512685541e-01,5.2098009840759874e-01,4.6582683307322936e-01,7.4453872590725806e-02,-9.7058972856616077e-02,-1.3684183668655092e-02,-6.8800320485907862e-01,7.1519263829070767e-01,4.6639530920210354e-01,-2.4687259599564290e-02,5.2814061490220873e-02,-1.8321897370762380e-01,-8.6342772560891512e-01,-7.2919715777405303e-01,-1.4345422856200185e-01,-2.8080733669024532e-01,-5.3129324307340120e-01,-2.9422290687056391e-01,2.8676692883376315e-01,4.8874800049156553e-01,1.1267959811355857e-01,-7.5578309261031262e-01,3.0819692671429000e-01,-1.4064924262845649e-01,8.0140944988832841e-01,-4.4534540938869510e-01,3.1941725834703993e-01,-1.9390916838613600e-01,-3.8565456009726690e-01,3.1253753241226445e-01,8.4102835212327587e-01,1.0451234153212575e-01,-1.8798758603193760e-01,4.8348375654447595e-01,1.2888555440823232e-01,-1.7251059124842241e-01,-2.1619197014445035e-01,-8.2044688979525338e-01,-1.5383056865023670e-01,-9.3966476672653587e-01,9.7743812698797075e-03,-2.5083152287391008e-01,-1.7422482866990169e-01,1.6447021626009628e-01,-1.9879960573478195e-01,-7.8688071707281682e-01,5.5407371689638540e-01,8.5142927284916112e-02,-8.2037866582422492e-01,2.3284299807583880e-01,-3.7625657564405263e-01,-1.5713802648411551e-01,-3.2634584848716580e-01,2.0617469759941048e-01,8.1740412553390165e-02,-4.5759620164670478e-01,-7.4743196081992491e-01,4.2750634990463776e-01,-2.7750842941224180e-01,-2.9042126526275164e-01,-7.8450223918041262e-01,-3.7028699108942631e-02,-4.7098797484813931e-01,1.9741240794639092e-01,-8.4402396738067376e-01,-3.1388260429144825e-02,-1.6530475864087563e-01,4.6940493984800569e-01,-1.7436271476995879e-01,-4.5035907753053317e-01,5.5138635759022336e-01,3.7512781740229384e-01,-5.6747383222336745e-01,-8.8427861703417887e-01,-1.3490925835898344e-02,1.9278711023404388e-01,-3.5354945311598590e-01,2.3601956847940317e-01,2.6770577869767415e-01,-1.6544708402039216e-02,2.0585730159298121e-01,-8.3999114103980865e-01,-4.2437900870714668e-01,-9.5134063176262287e-02,5.7168517974196764e-01,-7.9638004569204057e-01,-1.2606600709480487e-01,-1.1837123791565710e-01,2.9965471337849658e-01,-2.4127999026781333e-01,-5.6881823071847082e-02,-1.0113898377091150e-01,-9.1571086223339293e-01,-7.7009325628154351e-02,4.2884244654662851e-01,4.5162881957493090e-01,-7.7438974690444673e-01,-8.0719570271529262e-02,-7.5964435786538576e-01,2.4272410139272499e-01,2.5723167438734806e-01,3.9881301622220600e-01,-3.7256610681865343e-01,5.6406256399730037e-01,6.1003212063198287e-01,3.0398446678868773e-01,4.6383937499739425e-01,-4.6267848958663538e-02,3.1042759956687416e-01,-5.1985374091525838e-01,4.0707743672757313e-01,-1.5633730986687766e-01,6.6575776340532322e-01,3.3513514563419522e-01,9.7223549051681513e-02,-8.1231313767520874e-01,1.3377638334166989e-01,4.4775357205813771e-01,-6.2156150614877437e-01,-5.1527157451112071e-01,-1.6219463070680470e-01,5.5512125029061832e-01,1.1700340943990321e-01,-1.2204109587926149e-01,6.5004094443943028e-01,3.5770877339033014e-01,4.7486415092010525e-01,4.5727586102854134e-01,-6.2456897503682463e-01,1.7955958515024925e-01,-1.4203049699636655e-01,-6.5115816853535635e-01,3.6536601959509918e-01,1.6143732650382067e-01,4.3832934788437539e-01,8.4425690918390883e-01,-2.6163689205411744e-01,2.4120124503242302e-02,8.5068543248649597e-01,5.9505000164651378e-02,-3.3470561944242000e-02,5.1994563653114068e-01,3.6465140148258100e-02,-9.8551231905032177e-02,8.7730665933389806e-01,-4.1531939238294235e-01,4.9097528920531708e-02,-2.1382215774553756e-01,-4.6873736331035309e-01,1.7412351238628332e-02,3.3314823913913777e-01,7.9871440934777660e-01,-1.7620907275144909e-01,-1.4437875014496118e-01,1.8535472276529996e-01,-5.1303468182230957e-02,1.4438627608820445e-01,9.5985361419595261e-01,3.8458480521925920e-01,7.5352004305108677e-01,-1.4716197436695180e-01,2.3208844479731355e-01,4.5692491659652118e-01,6.0575681190001396e-01,2.1093626349399819e-01,3.8767042746163055e-01,-2.0092270708911220e-01,-6.3079813175660338e-01,-4.4991699631486698e-01,5.0488007453893513e-01,-2.0828737614681547e-01,-6.8509286381672585e-01,-1.7301717731438995e-01,2.3480666727723806e-01,-9.7503305844597987e-02,-8.7476399919531722e-01,1.3805847525963058e-01,-3.8869877472450604e-01,4.7706785456616119e-01,-3.5114477519452392e-01,-1.3949662225956314e-01,-6.4602836232160143e-01,4.6075118713625646e-01,4.4160401856431927e-02,-2.4091692552839922e-01,1.6822519375318401e-01,-2.6590270506248398e-01,-9.1706320912409311e-01,-1.9875050352071175e-01,9.3319249308780516e-01,1.5442737347480912e-01,7.0157442473719342e-02,-2.4673898715454085e-01,-4.3562536428057941e-01,6.3648908458204451e-02,-7.1131743159740901e-01,-5.4783180055740288e-01,-9.3374649231430379e-03,-8.6409047422185203e-01,-2.5895823349527392e-01,2.2394022968113078e-01,3.6691525127294766e-01,-3.8887756141676708e-02,1.4874908608999726e-01,5.0556463141374075e-04,-6.2588397929999995e-01,6.9973366460914588e-01,-3.1066943341765318e-01,-2.6107677863475837e-01,-6.7593527745050963e-01,-4.4366081653020145e-01,3.8647175516641202e-01,-3.5882457927230604e-01,7.8200305610082677e-01,1.6382578474946405e-01,-1.2598674705993015e-02,3.3987938229173448e-01,-4.9593912064771728e-01,4.7461381525644342e-01,-3.7324070101039519e-01,-4.2873142451146995e-01,-6.4302687310662887e-01,1.9529186254441949e-01,-6.6859159931550255e-02,-3.5354465912580380e-01,6.3480686972146938e-01,-4.2907939887100910e-01,-5.3239753413759261e-01,3.0096796342407373e-01,-5.0196629972739459e-01,4.6499027630930356e-01,3.7084888819947492e-01,5.5109279072526762e-01}},{10u,{3.1911842062536983e-01,-3.5026796034077642e-02,2.2869946075488337e-01,-5.1509331368533506e-01,-1.7008045728342708e-01,-5.7237450740736251e-01,1.1845882795972437e-01,-2.0491829853532229e-01,-4.3974614726204161e-02,-4.0597325479415658e-01,1.2233915929669359e-01,-1.5022109881926649e-01,2.6882942116798386e-01,-3.0054326848530288e-01,-1.1108437105237511e-01,1.9173291603598250e-01,6.6801035526790720e-01,1.9307785478280515e-01,-1.1655133923520550e-02,5.1683387482975995e-01,-1.1075664391258927e-01,6.7449929550623544e-01,-4.0948119762886348e-01,-2.8258063556377999e-01,-4.4045117485500739e-02,3.7692010649014653e-02,1.5192993555436585e-01,-4.5754307044819398e-01,8.8177317642546965e-03,2.2223910618150977e-01,2.2748291664969006e-01,-1.2968407052013554e-02,-4.8917380393104509e-01,-3.6957905000753910e-02,-3.8525653777806751e-01,1.5793048439861379e-01,6.9906258466945759e-02,3.5046134230980142e-01,-6.0494550985888951e-01,-2.0097935398612143e-01,-2.5070477463827334e-01,-2.6197545428930169e-01,-4.6915789188729673e-01,1.4390092083207878e-01,-2.9169885467596035e-01,-2.0821350998471599e-01,3.8664165267949197e-01,6.5180359260975207e-02,5.5758523931022619e-01,-1.8605574785759948e-01,-2.4904830387808322e-01,-5.8868362051936729e-01,-1.9172599350000064e-01,-2.7051815821793651e-01,-1.8254381003164027e-01,-6.8694070532023671e-02,-3.3049303334483676e-01,-3.8458616134186968e-01,-1.9933962012677192e-01,3.8285512157200557e-01,-2.8555942595205203e-01,1.3164314049088477e-01,2.7976621949385494e-01,-3.6024983448930420e-01,-5.1934114733364123e-01,4.6512328246664025e-01,-2.6729951455885809e-01,1.2814791890673716e-01,2.5747833714015500e-01,-2.2990412803128102e-01,-2.6753711953072012e-01,-5.5055020163516308e-02,2.9669679916581859e-01,4.0528764177341675e-01,-2.1828460126961849e-01,1.5623249086528099e-01,3.7382416626237164e-01,-5.1450089009649003e-01,-3.4780274814931950e-01,-2.7500288735400086e-01,7.3533135953795337e-01,-1.1968080782430886e-01,-6.8564093069546847e-02,1.9650634094010480e-01,-2.2074693743882634e-01,3.3010031395363704e-01,-1.0399902597756989e-01,-3.6998649810218587e-01,3.0606279771136785e-01,5.0723259402815128e-02,-2.1693457404149318e-02,-2.6688059998130520e-01,-2.0148024750259119e-01,-3.6958708423281733e-01,5.6909336582768999e-01,4.5986625139942061e-01,1.7616280310329335e-01,-1.3558230198635232e-01,1.7880260414562907e-02,-4.0747442934150835e-01,-7.7024706230858941e-02,-1.6634806735438132e-01,1.2885544866597565e-01,3.7907505001280273e-01,1.4843666621519794e-01,2.6666268729844234e-01,3.0204661321208059e-01,1.2292911056386510e-01,4.8353209627461646e-01,6.1057714610477176e-01,-1.0530433190834135e-01,-5.5164033966611181e-01,-1.5385695168115024e-01,4.9536317512923983e-01,-5.1342586900983145e-01,-2.1528889408716340e-01,-1.2571910364275365e-01,-2.6471798554320253e-01,-1.4023402281080458e-01,6.7364344719557795e-03,8.4330730294005296e-01,-7.7907471901389691e-02,-2.1667179157778202e-01,6.9899415815338095e-02,-2.2996828099863903e-01,1.9787276103982177e-01,4.4559393847300635e-02,2.2257137489582576e-01,2.2683265190297092e-01,-1.8951247118243486e-01,1.6847312671229581e-01,3.3034433750850617e-01,7.4174038588779245e-01,1.7433469365232060e-01,-4.2031381483104258e-01,5.5711105901924150e-02,-8.0786733620653930e-03,6.5708007646422595e-02,-2.8082605148329703e-01,1.3749374568153244e-01,3.4073981576372980e-03,-4.1814626213930572e-01,2.2089382189767953e-01,-2.8406714965594126e-01,-7.3241900556039984e-03,2.3343864323223942e-01,7.1057027608460854e-01,-1.9972439082723192e-01,-2.0619274680694752e-01,-2.3192935289515709e-01,-2.4938923440155518e-02,1.8951046649760139e-01,-2.2004057605712637e-01,-1.4586814668361231e-01,-2.0260556002270250e-01,6.7747784938269373e-01,-2.1015415707810120e-01,-5.5491929449704813e-01,-5.3516427390564794e-02,1.9692387198553088e-01,2.5958549517790436e-01,-4.6477251743611037e-01,3.9311708158834235e-01,4.1038173034451120e-03,5.0674444315875133e-01,1.3101666942035906e-01,-5.0479510734749822e-01,-1.5080916736543259e-01,-1.0259082053865815e-01,1.5219776107798857e-03,2.1993310614374845e-01,2.6863502689734242e-01,-2.3421259610629436e-01,5.2919937548001883e-01,4.2308201534750434e-01,-1.9143581808090691e-02,2.6520684465437910e-01,-1.8026227461664368e-01,-5.1087664752108286e-01,3.6988598834054198e-02,-3.2522584327485587e-01,7.7088352098838728e-02,1.1018150878185504e-01,4.3082272090994528e-01,5.4599799792723371e-02,4.3557013389675514e-01,-7.1134102493313922e-02,1.7255380310185334e-01,1.7985579017979544e-01,-6.5624072920176280e-01,-1.4583271516345556e-01,-2.1895867764480162e-01,-2.0940478956564368e-01,-8.9388022317210852e-02,-7.0279461572043012e-02,3.4577640739582705e-01,-1.0781478330843633e-01,6.5430826025758182e-01,-5.1668890061498585e-01,2.1849040861097774e-01,-7.1619745683783642e-01,-1.8800944675633971e-01,-8.6919743323286752e-02,1.6444057414805310e-01,3.8941385555066949e-01,3.7141685611983288e-01,1.8418076400400055e-02,-1.9778854295367110e-01,2.7578842094916478e-01,-1.0956955894509902e-01,-6.8125326745719417e-02,-4.8167517742048610e-03,-2.5707479473506240e-02,-5.8421128777656442e-02,2.3305382231837174e-01,1.7214766214572852e-01,5.9162051003721523e-02,-3.0603639039511948e-01,-7.2694068244596899e-01,5.3076525693577947e-01,1.1066774574561934e-01,9.7931487468416692e-02,-2.1553724280086942e-01,3.6015348793491692e-01,-3.1478519513460132e-02,-1.5403653078739796e-01,5.0287041373139474e-01,-4.4122450369163552e-01,-2.3482469731804978e-01,-5.2400069824888085e-01,1.0738299034840355e-01,-1.3868619093049811e-01,-6.5984439056910948e-01,-1.1134014421829383e-01,2.7671981470525964e-02,1.3599579174412635e-01,5.2071852296419741e-01,3.6236785323933091e-01,1.5494781608286459e-01,2.7516563282901363e-01,2.4914858516571138e-02,2.3794067833129262e-01,-5.8392599490912089e-01,1.6052066584307373e-01,-3.4668001788548553e-01,9.1161085935249853e-02,-5.1480715201724792e-01,-3.7371210786857761e-01,1.4061385668940637e-01,1.5188895058003707e-01,-2.7203833986740822e-01,4.2874480441991447e-01,-3.0443283871443921e-01,-1.2539892512949249e-01,4.3264141543678353e-01,-5.2460684506599387e-01,-1.9112630032386496e-01,2.8129206682568975e-01,-1.8398911664981854e-01,-1.4788972172659626e-01,5.5348870424843222e-01,-2.4080235595162904e-02,-1.1355159271298057e-02,-7.6605772643529149e-02,6.6494054305176420e-01,-2.1003812567238721e-02,-8.9450450148655852e-02,-3.3331596758443199e-01,3.4712978871675554e-01,6.9899349419486292e-02,-8.0465009817380181e-02,7.4729653438684673e-01,1.7713350457588611e-01,-3.8505636812959210e-01,-8.3764564031805433e-02,2.9097080330143538e-01,3.1190711742747024e-01,-1.5854157535971566e-01,1.9727823934234309e-01,4.9070271134566301e-02,-2.0411795195790211e-01,-3.5273044840391943e-01,-8.1125175620574738e-02,-6.6128603706330769e-01,-1.7955811612945077e-01,-4.1051439327901929e-01,8.6042607652596720e-02,-4.1513785379741625e-01,9.7101564471367419e-02,-1.0095026287640019e-02,-1.7183589767710755e-01,1.0916134862746428e-01,1.9544239022483167e-01,4.4103430508212138e-01,-5.9303921093801892e-02,-5.0303347019280653e-01,2.4059875999134939e-01,-1.1777744633214884e-01,3.0639152632212691e-01,5.5104677960410642e-01,4.0438504075181053e-01,-3.8715606608177744e-01,-6.0582928366822408e-01,-3.6712873820184011e-01,-4.1933490471578745e-02,-6.9912240879463461e-02,3.3797446170896933e-01,-1.2091339300065344e-01,1.7296370635211500e-02,2.2131018749515843e-01,1.0328937779043230e-01,4.1698963524811072e-01,-8.2703284711608760e-02,-3.4406340074767960e-01,7.8285477192589992e-01,-5.1393665022307689e-02,4.1119540542912614e-02,2.6594430106069034e-01,-2.7119956279927998e-02,-3.9697718496691320e-02,1.4679787618949339e-01,8.1202618287117972e-02,-4.3713276448457666e-01,2.4909205069087373e-01,-1.6197115121998062e-01,-4.1702166027332194e-01,-1.9627185638377168e-01,3.2168328387055134e-01,-1.9714918810167381e-01,-5.8113020637581103e-01,3.9863915047505050e-01,2.9035134075016969e-02,7.9924851939527738e-02,2.3177021684143892e-01,-9.7569107891931683e-02,2.9509739718014172e-01,-7.8258667754459291e-02,4.9371438650723631e-01,-4.9986073510525053e-01,4.2871563963225245e-01,-2.0731644062442775e-01,7.2980954880641269e-02,-6.4483389359302132e-02,5.0237484642927543e-01,7.8293371355723396e-02,-1.9056103994602780e-01,7.0626104409501755e-01,2.6818916082466188e-01,2.3199339488101833e-01,1.6781148423581824e-01,-7.3000447944632493e-02,7.5752117009871855e-01,-3.2376623634726431e-01,-1.0687207629490394e-01,-4.0346380232428231e-01,-2.5832991717162211e-02,-6.7622022368714729e-02,-1.4708642298920033e-01,9.2902951987192728e-02,3.2603358644492247e-01,-8.9427144378902479e-02,1.4146086499178359e-01,-2.6517951762372222e-01,2.2579995186058682e-01,1.3320793681144744e-01,5.7944143220385802e-01,2.7412368012176785e-01,-3.9028157094973048e-01,-3.9863619027675778e-01,-3.3288853703265275e-01,2.0868312923454613e-01,3.6619527390517270e-02,7.7202867283282239e-02,3.5629786170866334e-01,2.8116275075341562e-01,-5.0987599971252306e-01,-1.1520304152407095e-01,-5.5134719136202903e-01,-3.0003128015717273e-01,2.7550254090593596e-01,7.3540079486669285e-01,2.1057693768830926e-01,2.4438044560452973e-01,1.6946149023045728e-01,-5.6838671521764424e-02,1.5330569519695011e-01,1.0314499474804070e-01,-1.3066197680840957e-01,4.5646524346632961e-01,-2.5218801315733491e-01,-6.8351231765464232e-02,-1.5470476606929506e-01,-4.2857095704790715e-01,4.0077359508105714e-01,2.8405145766568729e-01,2.7435749085396011e-01,-4.8683011707796620e-01,2.1993760924169208e-02,4.3645709198598748e-01,2.0775625089068581e-01,4.2904376944727485e-01,-1.4224076664407945e-01,-1.0497375689996254e-01,4.6252575118313649e-01,-4.0858251992622713e-01,-1.0032555484832870e-01,4.2899509203240843e-01,3.9346347920714342e-01,-1.8504498413167728e-01,-1.4367536637465655e-01,-1.1418877797972909e-01,2.5533182032003787e-01,-3.0864227764401986e-01,-4.7488963292634812e-01,6.8299733318948092e-02,-3.0250475436555468e-01,-1.0537397222406347e-01,5.2015735454720191e-01,-3.7653281638008346e-01,-2.8525090043188367e-01,3.6317412979977121e-02,-3.5849102938825178e-02,-2.5218560221076956e-02,-7.3782721608126239e-02,3.8208019574028129e-01,-1.3270457825664483e-01,4.5766189393300888e-01,-1.5717603274630415e-01,4.0542396927333585e-01,-6.5512817920512223e-01,-2.7908495515401266e-01,6.0544716725732722e-02,-6.0038760858652329e-01,4.9421792953679655e-02,-2.0378403046500293e-01,-3.9153822624440983e-02,5.9417890322100445e-02,2.1337680254194658e-01,6.2664551696353932e-01,2.6595568904943956e-01,2.9017254627417133e-01,-4.1324075579740432e-01,-4.3457139988593824e-01,2.8935813397320875e-01,3.5601083076149315e-01,-2.3148426656720272e-01,-5.2132063182122934e-01,-9.8413269241048609e-02,-4.6681987269266534e-02,-9.2104733283499815e-02,-4.6882921139116523e-01,3.4556655870511321e-02,3.9820376367781884e-01,5.1660265749296308e-01,2.8904159763183002e-01,-1.8253801113146406e-01,-1.4058296818037044e-01,4.5452568466175092e-01,8.9926333848480575e-02,-4.7448707010412025e-02,-5.4322774121249751e-01,-1.3442858115805945e-01,-2.1190313043247022e-01,2.0289247778949593e-01,-4.0471321730410414e-01,2.0985649500096573e-01,-1.1371753487918142e-01,-2.8897973495062562e-01,-2.5255376430465587e-01,-4.8239753103021338e-01,3.2513459406169093e-01,1.8232406966254144e-01,1.8545178897129344e-01,-5.5597554792189349e-02,-2.3845542681347881e-01,3.9164798429835829e-01,-5.0035219180257762e-01,2.6073262341739611e-01,3.7966883493221038e-01,-3.8836915438561304e-01,1.1254708141744615e-01,7.4865921310353389e-01,-2.8405295069160419e-01,3.8818185437522024e-01,2.7580329647556523e-01,2.4969815980973806e-01,4.3567728353180901e-02,-1.6029236337468228e-01,-1.7155994212711803e-01,5.4840153990454443e-03,-7.8729508598255366e-02,-3.5476272780464407e-01,-1.5880578694369749e-01,-8.4352411174929184e-02,3.6588559663442904e-01,7.2979447478507342e-01,1.8749327855089054e-01,3.3305502915484908e-01,-1.3891579450879912e-01,6.1328941261035164e-02,-2.7096243883673404e-02,-2.8125459819215359e-01,-2.3533877103362427e-01,-1.1637628995504748e-01,3.6244945487049712e-01,-3.7890134445089027e-02,-8.8023645732341019e-02,-4.9466539683792682e-01,-5.7409133194645590e-01,-3.6933145340029294e-01,3.3783264145357128e-01,3.9958746065215056e-01,-4.6740004317819872e-01,-1.3565111846789299e-01,-4.3365477558623639e-01,-4.8374810160414972e-01,1.4415445535525173e-01,-1.5563789344099488e-01,-2.8203966965387552e-02,-1.4651664251211066e-01,-5.1289966430580106e-02,5.2560703418043600e-02,-3.1977325157642633e-01,3.7195989120917317e-01,3.2151767510745982e-01,-2.4802873574013717e-01,-5.8543080254577395e-01,1.9659810160585361e-01,3.5553460745284760e-01,-2.8516811590221997e-01,-9.9704834480364962e-02,2.1027911124368423e-01,-5.1204498292392438e-02,-4.4790140818432517e-01,5.0141329843489002e-01,2.8532777337880701e-02,4.2280053887950847e-01,-8.9099874687901384e-02,4.9538950865593095e-01,-2.4138103776891764e-01,3.4911725322277348e-01,-1.1988777175144676e-01,-4.8224250424226156e-01,3.3278300497293599e-02,2.4907911132963176e-01,2.5306494271198648e-01,2.7652200548530137e-01,5.9780624632847390e-01,-2.4635286400545497e-01,9.7314219431692953e-02,-1.7593602246160611e-01,-6.0764061466996344e-01,-2.8774682313741717e-01,-4.0796041880546691e-01,-7.6385536444086466e-02,-3.3881914777896771e-01,-1.0512079128540268e-01,1.6675358612677937e-02,2.1562462629187251e-01,4.1489018905963032e-01,-5.0603065180096518e-01,-1.2923519268522796e-01,-4.5292816803451019e-01,2.8253549646776316e-01,-3.6502047557995737e-01,3.9599846236980862e-01,2.4876805245787695e-01,-1.3815579699036012e-01,1.7147836227044233e-01,-2.0452111275265161e-01,3.9778617850111636e-01,-1.0570343785647408e-02,-1.0878350593489475e-01,-3.9619191978544449e-01,-1.9656582100723013e-01,5.8612806031287057e-01,-4.6580758310779452e-01,-1.5095834968514915e-01,2.0730340969662125e-01,-8.9042006897628687e-02,-4.1329740092717426e-01,1.0472568382094991e-01,9.9860821045252735e-02,-4.5793232659957267e-01,-2.1528791291490418e-01,-5.6689278430996609e-02,-1.7814545023599254e-01,5.2223805037927251e-01,-2.6700255353721097e-01,-4.1619981280019530e-01,-3.6689404298990380e-01,5.5033139984577284e-01,-2.8101601760455419e-01,-1.2267841156653439e-01,1.9920569297772892e-01,1.4072987978659920e-01,-2.2774758050249522e-01,-1.1061186867664559e-01,-2.1668974915061778e-01,5.4585521547768945e-01,4.2378123013625318e-01,-1.0616460653418026e-01,-1.1732260737024015e-01,6.5390623234064649e-01,-2.2497519523925216e-01,-2.9767438069689961e-01,-2.7719327805269856e-01,1.9134568938796684e-01,-2.3502065044041096e-01,-2.4468903251871058e-01,-2.5279125189475482e-01,-4.4975264057390829e-02,5.3065650523482527e-02,2.5238524886693225e-01,4.5033788124124041e-01,4.9844367663915945e-01,7.0936686075886796e-02,9.1247903645589323e-03,-3.1968627596565768e-01,-5.5587285879373471e-01,5.9304161719845561e-01,-1.9850641027516761e-01,-3.0096990215695862e-01,-3.5927182368491339e-01,-3.7656096017960938e-02,4.8724387092968935e-01,-5.2417126794596952e-02,2.9866544389108440e-01,1.8967576429138863e-01,-1.4995882971872854e-01,2.1761360522316581e-01,1.5610561761727579e-02,4.2938481838885234e-01,2.2312888178996856e-01,5.8222786333229548e-01,4.0429114928932516e-02,-3.5781942380810233e-01,1.0351131301228222e-01,4.0548982110955228e-01,2.7285102869114647e-01,7.2274649013874634e-02,-1.3189949055798555e-01,-1.6159320848416142e-01,2.7428278039573747e-02,2.3160603790210316e-01,-4.1899552782564131e-01,3.9791012623915234e-01,-1.6944689710469979e-01,5.4992558154510351e-01,-4.8151090347535491e-01,-3.0237020029482115e-01,-8.0258765566842971e-02,-6.2881363093589637e-01,-1.8125076298580889e-01,3.4305612506796573e-01,-2.4096429928147056e-01,-5.3731846445325682e-01,8.0412014023483927e-02,-4.8556332605596289e-02,2.4210139135306761e-02,4.1419249292653768e-02,6.1203913133607535e-01,2.8977871416372092e-01,-3.6542724498332207e-01,-4.0635849679144465e-02,-2.3290546757777419e-01,-2.1998775101157567e-01,3.1990245334625961e-01,-4.6846833927520287e-02,-4.4425299969167259e-01,3.6020161353650249e-01,-3.0483759664191656e-01,1.9326357791692167e-01,-3.4959509083985851e-01,3.7339827167504031e-01,-3.3980586727386691e-01,1.6028091193375046e-01,-1.2547919775513436e-01,-5.6366423990641479e-01,6.0947742519194159e-02,-2.4477249991189293e-01,-1.9286938174102597e-01,1.9537397884469176e-02,6.1376321833854650e-02,7.7818453167783450e-02,-1.3828908245362517e-01,3.6938754909306581e-01,8.4257451878061895e-01,-1.3324248399008642e-02,1.6432578427533356e-01,2.6348873753219076e-01,6.4691762636180172e-01,-4.0649977508044788e-01,1.9162615416815060e-01,2.9616308493221982e-01,3.8011323961950609e-02,3.6024191091364544e-01,-1.3969777912299128e-02,-1.3153588398328211e-01,2.7144080076430782e-01,-2.4704717803532023e-01,6.0428530995142865e-02,4.4045960334644868e-01,-4.2020579000343644e-01,-3.3565160799769311e-01,2.1349513974990511e-01,6.7546303893620846e-02,5.5887796808447554e-01,1.5817672436439234e-01,2.5410505145548196e-01,2.4077699574579989e-01,-4.0298494124800077e-01,-1.5284705929485776e-02,-1.6922723528832201e-02,4.2808570456486006e-02,-2.4299516975923097e-01,-1.0176515744052103e-01,5.4100104304622598e-01,1.0078593975982983e-01,-6.3642302512548343e-01,7.3791509724321858e-02,-3.0155885426310891e-01,-1.5626939629206080e-01,4.0898382423847512e-01,-5.6355345797585377e-01,-6.8592116884243742e-02,-5.0734099293599944e-01,8.5940951292214379e-02,-5.7458575331113815e-03,3.5329598668201900e-01,4.9896139170101661e-01,-5.2170139176559371e-01,1.3698629959966538e-01,-1.0040534987907540e-01,3.0016642460236376e-01,2.5567467913284353e-01,1.8811567818258984e-01,5.2567060002891901e-02,-2.9958149018172092e-01,4.0822715418757527e-01,-5.9482920992058486e-01,-3.2323248520065029e-01,-3.2330492206701739e-01,3.7084106470707340e-01,2.2868542653962523e-01,1.1997985232025500e-01,3.6905862175784809e-01,2.6846184042159027e-01,8.7885389301444683e-02,1.3022191308305855e-01,3.2247342417381863e-01,3.2788604221822892e-01,1.1310298618652570e-01,5.3347328310386211e-01,-1.0861345949976843e-01,6.0767713969708126e-01,1.6735526460197411e-01,1.6893384945334156e-01,9.8113170822535428e-02,-2.0946262359965001e-01,-1.7044521727690665e-01,9.7397278880112556e-02,-2.6238131709814666e-01,-1.4938597691856453e-01,-2.0902560208828910e-01,2.1200583959838706e-01,-3.5693513453434446e-02,1.4382186632667995e-01,-8.4426246017047757e-01,-2.1662418186912819e-01,2.3223152487976198e-02,5.9024807830215194e-02,4.4248081794530564e-01,3.6044878708344774e-01,-2.1313687499178624e-01,-5.5187481509544534e-01,4.6996669949568848e-01,2.1602098191829278e-02,-3.1180214111515292e-01,4.1413661835212993e-02,-1.8066225619023729e-01,2.0070319481062954e-01,3.6816142985875538e-01,2.6163487664971102e-01,5.5671192211741294e-01,-5.7453152805775835e-02,-5.4242892261989484e-01,2.4038270434772496e-01,-2.1639285666581665e-01,1.0495642720110084e-01,-3.2641359781704637e-01,-4.5343248512222528e-01,4.9505749032271651e-01,5.4612880851006275e-02,-1.2112778358208351e-01,2.9802504815454484e-01,-1.0823606401812072e-01,-4.5307672156394085e-01,-2.9404980244425814e-02,-3.4415051328317925e-01,-2.9385360219531376e-01,-1.8836086071390132e-01,3.5691566007652531e-01,1.2080661163826155e-01,1.6230515211950031e-02,2.2840855539348540e-01,5.5787499326219592e-01,2.1579117336703227e-01,1.5972958932206273e-02,5.7070819949964557e-01,-3.6256225661008820e-02,1.1073026488242887e-01,9.1054542336120356e-02,-2.7761473920177571e-01,-2.9247183047327846e-01,8.3442268091344463e-01,-5.1468809729322787e-02,9.2522683724346910e-02,-1.6190392362477699e-01,-2.8607704125112871e-01,1.0274105960614817e-01,6.5251153088298353e-01,1.6242378404536792e-01,-4.2725192115605132e-02,-5.3379019907930580e-01,-1.6145232115492422e-01,1.0130322173880131e-01,5.9633355265273046e-03,4.4048784084435377e-01,1.4191468702850807e-01,1.6296968796788122e-01,5.4153086086197663e-02,-3.6976352907837090e-01,-1.2797817855467325e-01,-2.6413100441417214e-01,-1.3769207723033697e-01,6.2881590055538850e-01,-3.0653197257299686e-01,-4.8518957026449988e-01,-6.2452707941748148e-02,-2.1064419124560013e-01,-3.5527285536713188e-01,1.3282664658161580e-01,2.9999032428619332e-01,-6.6705739947231479e-01,-1.0968617480092159e-01,-3.6653808927689424e-01,-2.1984322749418703e-01,-2.5053894700735690e-01,1.3901618452439962e-01,-4.4410633869238658e-02,-5.2601120515061960e-03,6.0373999960492786e-01,1.3535444003713210e-01,1.6574586432986554e-01,-3.1892502911905207e-03,2.0323326207441392e-01,-6.1013416561996781e-01,1.0035731589911968e-01,-4.0503864343452689e-01,-5.5244908151271577e-01,3.1587812857820086e-01,1.2181425890121775e-01,-5.3886115209595631e-01,1.6196679468889191e-01,-1.8462208533382121e-01,-2.1285038194448963e-01,-1.8233506802009505e-01,-3.2487314140943713e-01,2.1306920989202327e-01,1.9907598712628963e-01,-1.7295743030134050e-01,-2.6129699177712323e-01,-2.2148415749118658e-01,6.0304993869687594e-02,2.9642597586539671e-01,-1.2116056626814171e-01,-6.0153205095230833e-01,3.5049205675613881e-01,4.7143685078498265e-01,-5.3330887568564189e-01,-3.3950680260043908e-01,-2.7632303915565865e-01,-2.6159057303110933e-01,-1.8994270313729253e-01,-1.1451522159641453e-01,2.1169472990277749e-01,3.8150366250352334e-02,4.9279044391325161e-01,-3.4238607894851131e-01,4.4679730208059598e-01,-3.9032106727703036e-01,3.9949914910456086e-01,-6.1152329691951901e-01,-1.4530727288701378e-01,-2.4379032684675470e-01,9.5797009381232145e-04,1.8368241718677114e-01,-4.7445526708798647e-03,1.2277483227548347e-02,-3.2670997288815656e-01,-1.8824162862069599e-01,-8.4632423309611363e-02,7.9035262852970245e-02,4.4762777686223604e-01,4.2773009495199321e-01,-8.4653047284035943e-02,4.5205437103022122e-01,-3.9021008533080381e-01,-3.1194486499701618e-01,-3.1081070143846518e-01,-3.9541745503313408e-01,2.2171718893178177e-02,7.6874324825979068e-01,-1.1371013765027858e-01,-4.1562962326277639e-02,3.0476248328719824e-01,-1.4557372738648036e-01,7.4388919644586368e-02,1.4601681180779380e-01,-1.0596932922667730e-01,2.1877188396512615e-01,-4.5020421547288042e-01,6.3649144042598749e-03,-6.1027861033712927e-01,5.7645530255824695e-01,7.1484771895464648e-03,-1.0274447368219622e-01,-1.4379819891071435e-01,4.6463626567554400e-02,-2.1860220237064915e-01,8.1693140716730811e-03,2.0036594432883387e-02,-2.5836862952697298e-02,2.5486713676710582e-01,1.7950830471502994e-02,-4.4027253642780995e-01,-4.6923178485552197e-01,-4.0816232345503084e-01,5.5243369245967378e-01,-2.4790858773666263e-01,8.3576423304264302e-01,2.8748046349022982e-01,3.6653629805343635e-01,5.3577242818947435e-02,-6.5330840982872701e-02,-1.8056617686841050e-02,1.0725550435772088e-01,-1.6367210217921657e-02,-6.1719480348878239e-02,3.7847176970314325e-03,-6.8197740933634413e-02,-1.7020188624324264e-01,2.2319171313937192e-01,-1.2085790709428558e-01,-2.4351517939239814e-01,-5.4844749307103746e-01,-3.2971518836084268e-01,-3.1170700543192719e-02,-6.5739400224131628e-01,-2.2523279094777540e-02,1.8409895023330464e-01,-8.1924565911984815e-01,8.7451437207422711e-02,2.8764407897494959e-01,-3.7927399877990298e-01,9.1036065824774193e-02,1.5107808571863338e-01,7.0959759584184295e-02,1.5509271904285354e-01,1.4040194204403042e-01,1.5904888140287732e-02,-4.9037309181502987e-02,1.7918931538566082e-01,2.9611653416713529e-01,4.5887204852747154e-01,-3.5878132717665395e-01,-2.7534902100978476e-02,7.0813105882752714e-01,1.2782994170328124e-01,-7.6439125311917289e-01,-1.0396490111308937e-01,2.5412007356765021e-02,-3.3942780805061534e-01,-2.2255658591138849e-01,-1.9339838595880832e-01,-1.9602573138607593e-01,1.8071100021734743e-01,3.5806329018259092e-01,5.3047734448446182e-02,2.6768245484351272e-01,-1.1034208577996130e-01,5.8590872107796260e-02,2.5089437968448269e-01,-3.3446888012746334e-01,-1.6526801787725953e-01,-4.7906606625005865e-01,6.0602406525469010e-01,-1.3781970746801833e-01,3.0796617127465375e-01}},{20u,{-3.0809142081485397e-01,1.0012133835038161e-02,4.4102809975642510e-01,-8.5541751845217257e-02,-7.4442981885166418e-02,-1.2346913092714660e-02,-6.8789078362091791e-02,3.1286971079456866e-01,-3.3104145636050825e-01,6.7310724152778084e-02,-3.3978776980228076e-01,-3.1918555534969674e-02,6.2584809313354542e-02,-1.7326230560600969e-01,-4.2205896164994972e-01,7.3857342209092319e-02,-1.6740997394566338e-02,-3.8078047653279357e-01,-2.8677928341762266e-02,-2.5042832692693990e-02,-9.4916454842776471e-02,3.0734909979757369e-01,1.7315481341710481e-01,-2.5957247974038739e-01,4.6824939392592146e-01,-3.7956596612756560e-01,-8.5692657555357044e-02,1.4398562750323832e-01,-1.6271141346621243e-01,-2.7114539060985149e-01,4.3457221695753423e-01,5.9142859548147672e-02,2.1372376633950116e-01,1.9453246511092284e-01,9.4714592329812913e-02,1.0270294895935554e-03,5.4417374309362193e-03,-4.4954365179049896e-02,-1.1734646078345261e-01,-8.4291001140330279e-02,-6.6579208506238455e-02,1.5000627533483402e-01,-2.8584435162415633e-01,2.0856199295082573e-01,-1.6103800345641850e-01,1.1618492387724735e-01,3.4971699078807178e-01,7.7920501431584188e-02,-3.9744774901445790e-01,5.2247634144728227e-03,4.7817503484928248e-02,2.7648745519099571e-01,3.7057796998791359e-01,-2.8997903920818191e-01,8.9789478835717557e-02,-1.8660713237666219e-02,4.7055145784213111e-02,1.1921827151833297e-01,-4.0419932695977762e-01,-1.8357589785739861e-01,7.8987505880859926e-02,4.3627218120214134e-01,5.9469193326234931e-02,-1.2991338704674962e-01,9.9934833262459055e-02,1.8213288327216759e-01,2.0930403982120063e-01,8.6424461539699071e-02,-3.6416517796191694e-01,2.3065269043291936e-01,-8.9481587472179588e-02,-2.8670803723775740e-01,-1.3568567916964563e-01,4.7354569411819696e-02,-5.8631250186952678e-03,-2.2901879684620435e-01,-2.4698318732012162e-01,4.1529505889760893e-01,3.1839254976011611e-01,6.7600470749402536e-02,-1.7613895477796743e-01,-7.8316775548881612e-02,-1.6319105754564953e-01,3.9373660538330618e-01,-1.8702440481574500e-01,-4.2854372533808432e-01,-9.8114931488406706e-02,-6.7800126356805254e-02,-4.9807003801724994e-02,4.1510893190620179e-02,4.8757037088925703e-02,-4.0391140770341510e-01,4.1138099252566063e-01,8.4307663510368530e-02,-4.8729022925156532e-02,-3.3698137329952166e-01,-1.6647920937497462e-01,-8.0954812418130156e-02,1.5156791182536691e-01,1.7055788715465314e-01,-3.3273652080088045e-01,-5.3676517763014797e-02,2.2953644989951008e-01,1.6699459497778529e-01,-3.9235956644539632e-02,2.3753039410058605e-01,-2.2276414523078403e-01,2.9091858591034625e-01,1.1879737961713417e-01,3.3565777366135502e-01,2.6638636878194039e-01,-3.0163851793062878e-02,2.0420255365867912e-01,-5.2111988759284980e-02,3.4758166083466535e-01,3.8543954931921959e-01,-6.1708097079582309e-02,2.2807817145913636e-01,5.5076989383895776e-02,2.0569612676210217e-01,-4.6282383925462378e-01,-1.8877325857833371e-01,2.0260705045815788e-01,1.6138969459198260e-01,1.6148101920174421e-01,1.8459820786044334e-01,1.6389847044269601e-01,-8.0592388883251209e-02,8.2018829703288734e-02,-2.8302786709664568e-01,1.7241843653937947e-01,2.5018143570090315e-03,-1.5043474378365709e-01,-1.1806910092976319e-01,-2.1172960118773651e-01,-3.8831691744256347e-01,3.5542190300481785e-01,3.2484820314370144e-01,1.1185125077748419e-02,9.3910776273893048e-02,1.5350904890919723e-01,-1.7191402254026741e-01,1.2585892510691973e-01,-1.6516954044431018e-02,1.3295164161269010e-01,7.9338137833895636e-02,-1.3011648078175497e-01,1.3069902452552451e-01,2.3650137685928919e-02,-2.2590119604547390e-01,-3.5981653207600178e-01,-6.5849829666558252e-02,3.9378544165571128e-01,-1.0926652859320969e-01,3.0514680676326306e-01,-8.8482177757219449e-02,2.1913156429978609e-01,1.4113178441936777e-01,3.7064309605097123e-01,-4.6273781729678370e-01,-8.3094096367720624e-02,1.5645934108862899e-01,5.4192576782242305e-03,-1.2938748715628778e-01,1.0729642257175012e-01,2.8978234357546512e-01,-4.6784141147456448e-01,-2.9068246503364281e-01,7.5506424495027882e-02,3.6477084569411129e-02,-3.2739740929325589e-01,-5.7540048070436767e-03,2.7484286522494572e-01,2.4112536439762838e-01,-8.2858642085576875e-02,-1.8553130945382482e-01,-7.7930573051659985e-02,1.7902199367282989e-01,-4.6554477276410217e-01,9.4401947297971994e-02,-6.8462575223906877e-02,-1.3651398381618587e-01,8.6463610687805156e-02,-6.8793034452535470e-02,-2.1002265550919724e-01,-3.9925743032623001e-02,-4.2119000051221306e-01,-4.4217137441761833e-01,-4.2931825285788849e-01,4.0280223773851501e-03,2.8165742002597227e-01,-1.3397111965391242e-01,-2.3908659934978790e-01,-2.5956593678526579e-01,7.9136242994337802e-02,6.0620776163993209e-02,-6.3189242599628603e-02,8.4205091777019833e-02,6.1075445078949478e-03,-3.4444697339186625e-01,-3.0212034516282044e-01,-6.0216181856329924e-02,1.8841350064353149e-01,-1.7331662175298884e-01,-2.4505368154714227e-02,-4.4533103217410330e-02,1.9692426365402324e-01,-1.9585309972145315e-01,2.4107033173718685e-02,1.9228474905138565e-01,-1.2869873856602668e-01,2.9630994665621641e-01,-8.5539345919641324e-02,2.3030286779159984e-02,5.5610924853374311e-01,-4.0393423467767525e-01,-2.1607549788227562e-01,-2.9999107913661993e-01,2.7927102155592253e-02,1.3756679888497512e-02,1.5957639941413862e-01,5.0860458420327226e-01,3.4033757013938737e-02,2.6566414838041696e-01,-1.6767252362530902e-01,1.3097317087187341e-01,-3.5490475637639418e-01,5.1185193735345337e-02,5.3885395530183185e-02,1.0378649260427392e-01,1.7043772242976754e-01,3.1938874367033637e-01,-3.7888995694663606e-02,-7.0191014308039937e-02,-2.9622101571748178e-02,-2.8537109258599208e-01,3.4212701264958262e-01,-2.4113518684045079e-01,2.4632165980265114e-01,3.1532248877946409e-02,2.2236988760489218e-01,-1.6599003446926666e-01,2.7570750915103436e-02,9.1361328258193111e-02,3.3296376806197359e-01,1.1346877722454121e-01,-1.2471569382963056e-01,1.1314531278903277e-01,1.9871786157144766e-01,4.3507375506169649e-02,1.8141121992251552e-01,1.7258089528683881e-01,7.1445037991727078e-02,-4.6328605635886916e-01,-2.2081314426609183e-01,-2.4279103689828832e-01,-5.7143233356773082e-01,-1.8597138349535379e-02,2.4155901627342553e-03,-5.8217093769006911e-02,-2.9053301825598371e-02,-1.0323732702056011e-01,-3.9981294129680940e-02,-3.0035037469837023e-01,-1.9939882657268834e-01,-4.0721051256961549e-01,-1.2296722721051444e-01,-3.1868461734804114e-02,-4.2940066126591681e-02,6.2134864485360423e-02,-1.2353738707803559e-01,5.2857620384453741e-01,1.3166678185454414e-01,-9.6032767993574339e-02,-1.7698195283611801e-01,3.1882375535118496e-02,1.2022735048009228e-02,4.3640258014036376e-01,2.4090513488215057e-01,2.5901510295341679e-01,2.9295034984979568e-01,-2.6034226357232798e-01,4.6628886934753453e-03,-1.9905352333818699e-01,3.0832640857019644e-01,-3.2934704705355283e-02,2.6940626925967444e-02,-8.9815876416732124e-02,-1.9144864885939245e-01,4.5960131502967766e-01,7.6171646168717813e-02,-1.7376350559270162e-01,1.3990894749735702e-01,-2.2818600124354291e-01,4.7664432130060733e-02,-1.2478512708838729e-01,4.5688976009696369e-01,-1.1984011222956242e-01,-1.0600372023023971e-01,3.0675768654217583e-01,4.8923909279293687e-02,2.3126476477104804e-01,4.1772585898615366e-01,9.9856263139857182e-02,-3.9966776266418171e-03,-1.3608030079337624e-01,3.2240812186269507e-01,-4.7703824178933008e-01,3.1428226559888262e-01,2.8698892944360943e-01,4.9798733117500958e-02,-1.0552527950125038e-02,2.5021844940541205e-01,-4.3321434661582732e-02,-2.1501284971911602e-01,1.9082509503671277e-01,3.1348602359288186e-02,6.7336219292940924e-02,2.6439923441819051e-02,-2.6932619642367250e-01,2.1926860445108071e-01,1.9431433284452646e-01,2.9418341329371228e-01,-1.7668013483145457e-02,-1.6957672987555106e-01,2.1994889146599611e-02,5.9532582159808931e-02,-1.7624689148150208e-01,5.2983312729080745e-03,-5.0298059076010315e-01,-7.7450372110616256e-02,-1.4822831504920109e-01,8.3771804440662054e-02,-3.8595453428489079e-01,2.3233789781719175e-01,1.0811352716553031e-01,-7.0380615246878803e-02,-3.5387351172339168e-02,-5.7987309137236834e-02,5.0125445314646677e-01,3.2597909889195037e-01,-1.8579403271892950e-01,3.5712843125224947e-01,-2.0831439949744956e-01,-5.0754211136629457e-01,3.5615510887827641e-02,6.0029770387030112e-02,2.9831160415026720e-01,7.6828502464945270e-02,1.3152174453093936e-02,2.6777891978105145e-01,-7.2805183869212503e-02,6.8768226004498043e-02,2.2484311831110182e-01,-2.3889793900900225e-02,-3.2213872250698655e-01,-8.7471076472990135e-03,1.2676985720089839e-01,-2.5640928124721551e-01,-1.1054232812372927e-01,-1.5978773280745449e-02,1.9419391016887827e-01,4.7463280752362620e-02,1.5582433156559455e-01,4.5567071086376712e-02,-4.6378439155131718e-01,-1.2284069457484441e-01,2.4727263787758005e-01,2.2477038299518337e-01,1.4643151989460315e-01,-2.6336526113722458e-01,-1.4716270540535265e-01,-3.5971811871362230e-01,-2.9727475881727577e-01,1.8144198761601787e-01,-8.7073229198972951e-02,1.0378017468113329e-01,2.3760924261631983e-01,-3.6676321606511736e-01,-1.3818605116686705e-01,2.9060944938546618e-01,-2.0860355734386432e-01,3.4159002363778468e-01,5.6344050977039739e-01,2.0133686751513491e-01,-9.3878146043616550e-02,-1.3146669286519131e-02,-5.8270813856905468e-02,-3.5037756596463898e-01,-1.2243662794286760e-02,-1.3119269048507498e-01,2.6877217139300658e-01,-1.3716515456356637e-01,3.3681078392050079e-01,6.5939102707292474e-02,5.7598279828494886e-02,-6.7767067631466296e-02,1.0739826069904615e-01,-7.2970900910901082e-02,1.0595572193622456e-01,-1.3966495230713744e-01,1.5102856755860014e-01,-4.5457670710723480e-01,2.0293651917707281e-01,2.9348754918482337e-02,3.7582498435745271e-01,-2.6488960985183746e-01,-2.3666560374041068e-01,1.2593772300604528e-01,1.0834797587800876e-01,-2.0723268938677608e-01,1.6819719814517173e-02,-1.0258127833247163e-01,3.4775450884880238e-01,3.0798236463662959e-01,1.9793627973055028e-01,-2.9779940247854514e-01,-1.0267295532426117e-01,-5.6090997272862715e-02,-5.3755451444014543e-02,-5.9447280892178134e-01,7.0595166307022839e-03,-2.1961640075298797e-01,-2.6446519665963752e-01,8.6963472287445748e-02,-2.6400915701641525e-01,-1.9589813979514500e-01,1.4899804356674026e-01,1.3325680147708110e-01,-7.5554042117511350e-02,2.0334913694629839e-01,-2.1408781533139870e-01,-1.5213036520542683e-01,-1.4667392547209279e-02,1.7723187268145180e-01,1.8509608758332549e-01,3.4519314948436464e-01,2.2521456213318095e-01,-8.8327868428358020e-02,-1.1478940350588494e-01,-4.3086969037473000e-05,1.3600564612491145e-01,-3.7888215944164794e-01,-3.2999099044038041e-02,-4.6165862416362780e-01,1.8179142260755565e-01,3.7837481809091361e-01,9.0468208397564365e-02,-1.8277445334324061e-01,-2.8123214823081610e-01,-9.4011901707919676e-02,-1.5170159646465509e-01,1.7731947314816288e-01,1.2626336783405745e-01,-4.6462579826582334e-03,-2.0193959101970793e-01,3.1982442428825181e-01,-1.0925322237872064e-01,-3.0425905883501903e-01,2.5915426472573888e-04,6.2819273256964389e-02,1.0880982012981841e-01,7.9676632326044911e-02,1.3975914714343748e-01,3.7984297761613711e-01,9.9459460479463191e-02,1.5608423919448894e-01,-3.6067024833180955e-01,3.0791523892330624e-01,4.0374003434236076e-02,1.7434901486710441e-01,-3.8578333930205222e-01,1.8933230300631074e-01,2.2286610024623724e-01,-3.0260298417885356e-01,-4.0854813318783982e-02,1.1373650859897474e-01,2.4791355361393524e-01,-3.1438663567170166e-01,1.4851594995340003e-01,-1.4054564301439545e-01,-2.0057394667061401e-01,-2.7120260894044290e-01,2.9867592183615987e-01,1.6025194099483897e-01,-1.1833722291794602e-01,-1.5051299129639026e-01,2.2289297263909363e-01,1.2769937732286926e-01,-9.2475367011866053e-02,3.8235000729970811e-02,3.5553549528898304e-02,4.9472668818368404e-01,-8.6234227299776131e-02,-1.6732308737694040e-01,1.4035283694914147e-01,8.8897786462164188e-02,-3.9968176426923108e-01,1.5937517717246483e-01,3.8041909627757842e-01,1.5365462889524290e-01,-2.2895384494498239e-01,2.1655675072563677e-01,-2.0535152896323433e-01,-9.7483443803366626e-02,-9.1532352862726360e-02,-5.7436213632133366e-02,-2.6394465563016500e-01,-8.4914733087353395e-02,-2.8153867467276333e-01,1.9782836914568519e-01,1.7457511462426459e-01,-6.2648402905794466e-03,2.0007950035959091e-01,3.9627241564471266e-01,2.7824202137578169e-01,3.7436080382109480e-02,-7.9458589719524603e-02,-2.8643290840204344e-01,4.7295867386894680e-01,-1.7571572945344402e-01,-2.8486614506161434e-01,-8.7313009114242460e-02,-2.6419922386602002e-01,1.0538955692338778e-01,4.0954701822778106e-01,1.2689313492004434e-01,-2.1147181750368599e-01,2.0797114523319613e-01,-1.9361038599293567e-01,-6.8224564685684969e-02,-3.8086931365300433e-02,-2.7067737168006950e-01,-1.6717401938761850e-01,-5.7276621820524093e-05,-3.5755577941328914e-01,7.9241556324663051e-02,-3.4011195724203795e-02,3.8984226805071720e-01,3.0915669043148380e-01,-1.1823907205681680e-01,-2.3311978897968033e-01,1.2787683130649255e-01,2.1878533953630937e-02,-2.0884555290599166e-01,2.0601158842479300e-01,-2.6393859710004097e-01,-2.6409649080351183e-01,-3.4564559880855772e-01,-7.5527437064662320e-02,-1.9323594594453100e-01,1.5341223478486155e-02,2.2948111895353621e-01,1.8473757755602946e-01,-3.1541305438156864e-01,2.8223165705564313e-01,2.5711439280394782e-01,3.2273757317524993e-01,2.7910412947335539e-01,-1.1193242624512015e-01,5.2922633066451091e-02,6.7348035610203388e-02,-3.7609929912196605e-01,-4.1942354823584699e-01,9.1495539904149825e-02,7.3924751635871810e-02,6.9034492738114465e-03,-2.4452747354082899e-01,-1.5778260721982626e-01,6.0393625924802116e-02,3.7264886608786973e-01,2.4451708279618561e-01,4.1610097124060541e-01,-2.9233933506206994e-01,-3.8284466025713101e-02,-2.1159716959532900e-02,-2.6962307228077759e-01,1.5936457753169614e-01,-1.7885666803388427e-02,-1.2446351900183636e-01,-1.8382602282037522e-01,6.0666742094736062e-02,2.8522616558245362e-01,8.1008644180955436e-02,2.4927116472764216e-01,5.6370950276441378e-01,7.8611570393299565e-02,3.1506223859233767e-01,-2.1662688568498248e-01,-2.3606398694294337e-01,4.2178950931672510e-02,-1.2022002832068374e-01,5.3180243799447253e-02,-3.3091558765166751e-01,9.4805174700219652e-02,2.8564716200855100e-01,-1.2731573542407723e-01,-2.4183258905187219e-03,-2.2192272882577330e-01,-4.4686706295086608e-02,1.6077080014568002e-01,3.8615693400713647e-01,1.8584914579529416e-01,-4.9969210501976391e-01,7.2371508947465982e-02,1.3489610975194022e-01,6.4303220875306641e-02,8.2125157616667485e-02,1.9097378254552108e-01,1.1959843201834869e-01,-7.6315238430101157e-02,-1.1879515966003364e-01,2.1536708103005267e-01,2.1543457835242363e-01,7.3078865467726406e-02,2.6087399222472213e-01,2.1814863047363375e-01,-3.3815466064868710e-01,3.1939774544966482e-01,-7.5068188306450026e-02,-9.8011470284117164e-02,2.6467597589375041e-01,9.6810822771806082e-02,1.0567626437111927e-01,2.8894030364917667e-01,-4.1517024173900435e-02,-2.4245530068362964e-01,-4.1309747133620914e-02,-5.0806619221446980e-01,-1.7856600716978627e-01,2.7478234446300148e-01,-8.7508451083163491e-02,1.9831442057072945e-02,2.9429711353449806e-01,1.3076303865612038e-01,-4.6228744022394652e-01,4.2210550428954142e-02,-1.6833412858846369e-01,1.8160095158799161e-01,-3.0754766855572938e-03,3.5559331263100324e-01,-2.0857897724540816e-01,-2.9639853299015750e-01,-9.6457951220300542e-02,1.7130487177759623e-01,-2.0568928211384500e-02,1.5656781969047537e-01,4.3537516497192225e-01,-1.2449704697650113e-01,-1.6102846880146771e-01,1.0577420123640713e-01,-2.1745667273071467e-01,-1.3157506361015056e-01,3.4733744503454600e-01,-3.8350519988910634e-02,1.7188368764876311e-01,-2.2436916765535597e-01,3.2355703080819226e-01,2.3959392218666797e-01,8.8018571335681153e-02,2.5115998846189519e-01,-1.7775459570329494e-01,-2.2743512168658164e-02,3.6191027041760138e-02,4.4142327920841565e-02,-9.6064874847821641e-02,-1.7659114141748350e-01,-1.8250119457060851e-01,2.4997081953806330e-01,-6.1449493187466475e-01,3.4895717045865540e-02,-1.5146740478161053e-01,-8.0608202617968236e-03,-9.0143354376425608e-02,-2.1563910016083737e-02,2.8713869821128793e-02,-4.2390882941815790e-02,-2.3200794142740863e-01,6.6699857974676820e-03,-5.4628547081971002e-01,-2.9189952062621916e-01,-3.7104942023229520e-01,4.6151749002581358e-02,-1.0986066696612434e-01,3.7826622430407819e-01,-1.1145083887874063e-01,4.5333132569984580e-01,-3.9094870694215758e-02,-1.1397402060862483e-01,5.7506392112039270e-02,-2.3419984336684607e-01,2.8159254905878506e-01,1.0023967849835955e-01,3.2063899432561271e-01,1.3056928704834825e-02,-1.8760623871472884e-02,-4.1008520684069849e-02,-1.7751178934113346e-01,-1.2839014172084917e-01,-2.9474796716193991e-01,3.4210223555488067e-01,-2.6131809799859601e-01,-1.8682885121480741e-01,-2.2022572433746848e-01,2.7505080905139179e-01,9.5090012734533449e-02,-3.6138878273066571e-01,5.4779705835634601e-02,-2.3746990989552794e-01,2.9819462169013838e-01,-2.2509494106802500e-01,-1.4547202572704376e-01,-1.3867953853286860e-01,-1.4839969587107812e-01,-5.6612628833116595e-02,-8.1862928739794283e-02,3.1159862759511775e-01,-1.7625225499097361e-01,-3.4125818271355884e-01,-7.6315532176112442e-03,6.3617064043763161e-02,1.3858108258887863e-01,-6.6011969125947256e-02,4.2644061346630249e-02,6.5056898633866142e-02,2.3304337190670507e-01,-8.5778020360574109e-02,1.6913590573602733e-01,1.5246218239799170e-01,-1.0294222153441279e-01,3.2071255764104967e-01,6.1214433636448262e-01,-3.0308002419302416e-01,1.9121698395543882e-01,-3.7981033194210856e-01,5.7664342755015821e-02,2.6896506099244133e-01,-4.3341440221330720e-02,-1.0858975383564336e-01,-5.1299600633012268e-02,2.5462303090252481e-01,6.8364025674158037e-03,-6.2188847332061196e-02,3.0156249997587414e-01,2.1300031517099627e-01,6.5320360107403067e-02,1.1442944239095958e-01,8.6006711424536191e-03,1.0643014534054808e-01,1.5646436340017549e-02,-5.1171081045988699e-02,2.3685192454795007e-01,1.9718745101265744e-01,-1.2824623252049572e-01,5.3773948684931883e-01,-5.8526178509848786e-02,4.5120708605792947e-01,3.3469482646007825e-01,1.7411625249165122e-01,-1.1565267630770681e-01,-4.5100342249727837e-02,-2.9340945126413132e-01,2.2456675889669295e-01,-1.3026501565319051e-01,-2.1453186978582034e-01,2.3101524171644017e-01,-3.0238466365398986e-01,3.3859312298712674e-01,3.1262279462629206e-01,1.0780735561350904e-01,1.1090694148275185e-01,1.3827545970088090e-02,3.3796501117822469e-01,2.6267962027210834e-01,1.2730619832934054e-01,-3.8824029491972634e-01,-1.2481232040780260e-01,1.2631658350322006e-01,-1.5204341941579519e-01,-1.1111879222442628e-01,-1.4234317254554251e-02,3.2383030661420054e-01,5.3252650051817127e-03,-2.0578783283295954e-01,1.9841918913266821e-01,-1.6537894125111538e-01,-1.9840531683025506e-01,1.0716107046893653e-01,7.6332392078548583e-02,-3.8345388643652700e-01,-5.7982847802958504e-01,2.2562446059395364e-01,1.1815584781037941e-01,-9.6862624714806021e-03,-9.8996804653683212e-02,-1.4416522223208497e-01,-1.2059733429587993e-01,2.7373125363838841e-01,-1.4191318282650375e-01,2.0190180753499018e-01,-2.0927247636333005e-01,5.5293876061407871e-02,8.1519536131042541e-02,-1.8738278895894450e-01,-1.3936857198619068e-01,-4.5605463850304756e-02,6.0949426121833428e-01,-1.5684166760043017e-01,2.2742505151634379e-01,2.7753165095716653e-01,-2.8170797127571712e-01,-4.6513413377464771e-02,1.7990112095217337e-01,-3.6045533943815256e-01,1.9707811631623029e-01,1.7737811285083144e-01,1.7760209592877296e-01,1.0088720684388060e-01,-2.7696024722426618e-02,9.1934522797337173e-02,1.7094934133677891e-01,3.3471109832287613e-02,4.0546144385054750e-01,-4.2120226143832581e-02,7.7132795854241987e-03,-2.5345770442328247e-01,1.6916018217808654e-01,7.4010772808784472e-02,4.2603855054317274e-01,-1.3585060832070192e-01,-2.0193688647846897e-01,2.9081629322180563e-01,-4.3923407133142867e-01,1.7905172423061422e-01,-2.8111803824691550e-01,-1.5783589471245535e-01,1.4539579251441823e-02,-1.5558752803419312e-02,-2.0322073968954885e-01,9.5368950713934197e-02,1.5783436891510944e-01,1.3994708160419345e-01,2.2385805727835204e-02,2.5634681599677377e-02,2.2248423694685016e-01,-1.3891320303603794e-01,3.6348374213177201e-02,-3.0070147202530914e-02,-1.9071122355590073e-01,1.8090424644761915e-01,-2.4928950376730954e-01,4.2566988873068096e-01,1.9372015230639783e-01,2.7029599372130320e-01,3.2392334372179832e-01,7.1829280557111880e-02,-1.5449506463729068e-01,2.1155272543736392e-01,-2.0840316893762958e-01,-4.8801408190121037e-01,-2.8159412108144199e-01,-2.6209047842228461e-01,3.2309092639687798e-01,1.0968443129921562e-01,-8.3223957034498128e-02,-1.0873005035057469e-02,8.3529675547306365e-02,-3.8209233431805867e-01,3.8939436563368707e-03,-3.1942859870458286e-02,1.9953372653795878e-01,3.7712320461371719e-02,4.1369029768663540e-01,4.9426381512896461e-01,-1.5056037218678428e-01,9.9684055552355134e-03,-8.9019688963761265e-02,1.9450381977675241e-01,-7.3583542616853584e-03,2.2201960347557592e-01,1.1742489121930211e-01,1.1182194399020065e-01,-3.5798392286151309e-01,-3.9932384986851771e-01,1.3326838280494130e-01,-3.8157367976509238e-01,-1.4203687422593048e-01,9.0202583812245898e-02,2.4476974845523330e-01,-6.1089254684030557e-02,1.6527064332672556e-01,1.4175476507364237e-01,1.9571266496876538e-01,2.5877577043727640e-01,1.9341364658319798e-01,1.8679974618300105e-01,2.6205807611009485e-01,-2.5550619802357382e-02,5.8175054033018765e-02,3.6481426013367230e-01,9.0899464537448502e-02,9.2854725075443151e-02,-1.3519981917626545e-01,-3.5880331379870935e-02,-5.7221296689658585e-01,2.2577553912040099e-01,9.8217709825721838e-02,-8.8914039639089990e-02,1.5530268528710717e-01,-1.0488232330922033e-01,3.3824963668377689e-01,3.2191428510614295e-01,4.0813274088837143e-02,-4.2504819559991344e-03,3.2379602426049287e-01,-3.9840333432701475e-01,-4.4206846221784002e-02,-1.3583735861314605e-01,-1.5726812881495122e-01,-6.3570279574211741e-02,3.1812744340489074e-01,2.6341672940398708e-01,-1.1950181490035373e-01,2.6943759710783760e-01,6.4011736991092222e-02,2.6854768960590425e-01,3.6014862944235654e-01,-5.6839627849120042e-02,-7.9782670410287970e-02,-4.0068379802457638e-01,-1.0285811681832502e-01,3.7279183257441242e-02,1.1532997477040845e-01,1.0424514802656923e-01,-4.7774079631109113e-02,3.9796016953759933e-01,-1.9508901956842450e-01,-2.6321606034828737e-01,-6.1184672530595820e-02,2.4204359886772836e-01,1.4909763731139603e-01,2.4543110300137418e-02,-1.0195801769190907e-01,-2.1530376288281922e-01,2.6872205556180656e-01,-4.1607591888810996e-02,2.9781564832846669e-01,-9.1026841307175158e-02,-4.4501821620135085e-01,-1.2127717967054013e-02,2.9763431668851043e-01,-5.9216877257452115e-03,-5.7061974816342426e-03,-1.5396222687443675e-01,-2.6686988563028413e-01,-2.7788472237010048e-01,1.7375939897544820e-01,1.7679248915555074e-01,-4.6150935873526994e-01,1.2676304841895697e-01,-1.0523145885203763e-01,-8.8578966747265120e-02,3.0576295852179941e-01,-2.7674404538480479e-01,3.4055237730320798e-01,2.9077817048328297e-01,-9.3068182311267206e-02,2.8297627479491161e-01,1.5227494892482854e-01,-1.5273173599554238e-01,-9.3070946003935548e-02,4.5533994328558473e-02,4.6419161103695805e-01,-1.1483779414475380e-01,1.8697500349068689e-02,-2.0826161162176351e-01,1.4724477295498486e-02,-4.0932239354433320e-01,-1.4457663936351106e-01,-5.8638185103176942e-02,-3.5469097891354262e-01,1.5069109393140151e-01,-1.2049377635659464e-01,4.2727757265162614e-01,-4.0735355483422220e-02,-1.8800505581703797e-01,2.3364160758741837e-01,6.0534103605602663e-01,1.3263352966920383e-02,-2.0861597627852788e-01,2.5743196338268114e-02,-1.0123523398230067e-01,1.3879247153787955e-01,1.3099832619734411e-01,3.7392160566257285e-02,-1.7423449084834733e-01,1.7115872712815275e-01,1.9267060370445607e-01,-7.7389796218558488e-02,-3.4295285700644836e-02,-2.3085248517982333e-02,-4.4859701328910234e-01,-3.6782684472997607e-01,-2.7448995001597306e-02,8.9877096422306998e-02,-3.7368680171621044e-01,2.8426706254934048e-01,-1.0436845632847355e-01,1.2461440747499859e-01,-2.3938934729425043e-01,2.9111673331548210e-02,6.4310535997669394e-02,9.4449907256528451e-02,-1.3384328661315123e-01,-1.8381161526858308e-01,-1.0527587219344411e-01,-3.2358555510999187e-01,-1.8902980076517750e-01,1.9046489044510725e-01,-3.1067165044337558e-01,-5.8002817252595512e-03,9.7255445001179622e-02,1.7013935511159214e-01,-1.1408224287846418e-01,6.0770113759741423e-02,-2.2086827296515929e-01,1.3599811986573024e-01,-2.3657505469094958e-01,-1.2030969179522055e-01,-2.1410952673211203e-01,-3.6241242234454726e-02,-5.6562579831034854e-01,-1.8752774489445842e-01,2.8767291328201811e-01,4.2656274448701248e-01,-1.7915647075431990e-01,7.3067011397207948e-02,-2.8034750432642175e-01,-3.9423306628579083e-02,-1.5026764023703990e-01,1.2221094842100623e-01,-3.0338591640588092e-01,2.1669901200822295e-01,-2.6692033156770523e-01,-6.2637689535591845e-02,1.6817074368798590e-02,1.0997119941112068e-01,3.3976801242487931e-01,-2.6577121696370282e-01,-2.0824807751924501e-01,-3.8668087262451703e-02,3.9009568410959483e-02,-1.1040850843456929e-01,-7.0539590919076772e-02,3.5358748199822287e-01,-1.2398075821590998e-02,-3.7635164556092005e-01,3.2731442399801242e-01,1.9871564526212518e-01,3.0894792645545310e-01,-5.8800535462093317e-01,-6.9565939492718086e-04,-1.6791573201449378e-01,-1.8252944523958387e-01,4.5056727280223099e-02,1.3395432329212265e-01,1.1942105217224701e-01,2.3779205478524933e-02,-3.1879601133846641e-01,8.7080969232409683e-02,-1.0576194890855263e-01,3.4933382264380292e-01,-3.5596758809817236e-01,2.2542437833896117e-01,-1.0695485146242190e-02,5.3170196774199818e-02,-9.2366352007370953e-03,-3.4569332141945647e-01,4.9927756035950628e-02,1.1379636300419295e-01,1.9380882617308920e-01,-1.4273443321768506e-01,3.6527979522628096e-02,7.0967689134568412e-02,2.3609548986341253e-01,1.9311733489759647e-01,3.3445375381240250e-01,2.6320894357107005e-01,1.9279914291018918e-01,5.1892639038927368e-01,4.5369868583973899e-01,-1.1187434416844505e-01,-1.3739917578104760e-01,2.4869007649071329e-01,6.5264506683116202e-02,7.2887649796619436e-02,-8.4980319585334835e-02,-1.3460433562076662e-01,1.2611106382721038e-01,-7.1866944072066341e-02,-1.9697679627003992e-01,3.1564192755031545e-01,-1.3027238861081358e-01,-4.0075283374658072e-01,-1.6155201735347408e-01,5.9520766332151011e-02,-4.0688352432944219e-02,1.2073427743072497e-01,1.7660539270101785e-01,2.8024142209668160e-02,4.2389807616988552e-02,-3.0350775013381848e-01,7.1279527134576323e-03,1.2839669918373769e-01,-2.3259370362982321e-01,1.4320870190591173e-01,-5.3757208722498340e-01,1.6152771474014152e-01,-2.9401082773057696e-01,-1.3989793919818469e-01,-1.9735791606473332e-02,3.6526239844672626e-01,3.4679645624420297e-01,-2.2785635175512195e-01,-9.5185753666821110e-02,-1.0738370032179745e-01,1.2767238025700700e-01,5.0191705479083075e-02,-1.7197406644699553e-01,-2.0346067472934196e-01,3.5542236399165433e-01,1.5045695447849913e-01,5.2456797883172736e-02,-8.6291767904470656e-02,-1.9585196525096177e-01,1.8814923073542475e-01,1.5236188960017633e-01,6.0268217785751184e-03,4.6356290897221486e-01,-3.3550815569716513e-01,-2.3578888730910075e-01,7.4262020787201774e-02,-1.0453040688554133e-01,2.0413889760426886e-02,4.6874760628068807e-01,3.3525955085703324e-01,6.6801648817033897e-03,-2.4939699542198962e-01,3.4388551788812005e-01,-3.2981202780883451e-01,1.6547044222954321e-01,6.8493137208646360e-02,-2.3335433773450848e-01,-8.6011556017759283e-02,2.0613849513033877e-01,-2.3346509886820015e-02,2.5864642502242186e-02,3.9256604958422381e-01,8.3275624654369718e-02,-8.6437046370395912e-02,1.2608650332425411e-01,-4.1781331550084810e-01,-1.2380919640050825e-01,-2.3460269079000468e-01,-2.3574350585822687e-01,3.2049426139625292e-01,7.4246814966298716e-02,1.2623609613592407e-01,-1.7352339238816787e-03,-2.0672386542689303e-01,-1.4742265794661849e-01,-9.2367701063568536e-02,-6.3016875917741119e-02,2.6596802336290021e-01,-1.1127829873445477e-01,2.5728402989859178e-01,4.4260259955520947e-01,1.4695906285529434e-01,-1.1781790640886046e-01,-3.1900037565377060e-01,1.7581456402982162e-01,2.2278008134477245e-01,-2.0179924965193347e-01,-1.4222703740927908e-01,3.2166700322443786e-02,2.2317985872847831e-01,1.3820304615918486e-01,-3.9680335279454138e-02,-1.0822422062569018e-02,1.0687503726956755e-01,-3.6022905013382328e-01,-7.1118885578641600e-02,1.2208639625981885e-01,2.6148746239605974e-01,-2.1109602047255807e-01,-5.1117653298521626e-01,1.7382321841414833e-02,1.4753713344715824e-01,4.7417297425939892e-01,6.7622984730945815e-02,7.2368588710903181e-02,-2.0698706213285600e-01,2.3287277712835999e-01,-1.9228480773583168e-01,-1.3540705746053830e-01,-1.0512149568971998e-01,2.5036067988513055e-01,-3.1606019203226970e-01,-9.6577772992926650e-02,-1.8207968724531029e-01,-4.2909235274650459e-02,-9.3208754566053043e-02,-2.8915156420711530e-01,-2.7386522900821997e-01,2.0404857263499654e-01,-1.4401220461723570e-03,4.3447299326693001e-01,1.1145649766610047e-01,-3.0545187125530637e-01,-3.4786151632794499e-01,3.3591872517678323e-01,1.6357854856502474e-01,-1.9152609142835491e-02,-1.9873224619291241e-01,3.4607213910345302e-01,-1.6321304914544552e-01,-2.1004199780306743e-01,-3.5248945203401161e-02,-2.6899388233125343e-01,1.4918167491401785e-01,-2.6541084977355556e-01,2.3130778694778986e-01,-2.8374435414886090e-01,-4.0349592208032248e-02,8.8842900216417081e-02,3.9377891814608734e-01,-1.2659391711073265e-01,-3.6774274596872014e-01,-1.1520429361557821e-01,-2.4270815554409634e-02,-1.3344000617611901e-01,-9.4814374487304939e-02,-7.2027009732862513e-01,-6.8918009670810881e-02,-2.0956727009761081e-01,-2.8538135527862513e-01,-2.6487366147708968e-01,4.5736904794905636e-02,-1.9116299130815989e-01,-3.6754113098903314e-02,1.2111434250474139e-01,9.9982857575911688e-02,-1.6326426361628754e-01,-1.1215960671605886e-02,2.1797451022144591e-02,9.1176359616633645e-02,4.8632595912133793e-02,2.8046880015019782e-01,1.1620942439286341e-01,-2.4370724642632441e-01,1.4884020665463876e-01,2.5624153099037772e-01,3.1799886284779220e-02,-2.0162462091167965e-01,8.0853104879956172e-02,-8.6675601445679498e-02,1.6702197063966057e-01,2.2359783328463799e-02,-3.2083148123496369e-01,-1.6820585955028983e-01,2.4987029154568109e-02,3.4073165592626231e-01,-1.3441438528004973e-02,2.4702673556026403e-01,-2.4319151318152038e-01,-6.4413765553628199e-01,-5.1705909339994333e-02,8.6895099591932645e-04,7.1522893081135894e-03,-2.0529193969455203e-01,-1.2727936993865060e-01,-2.6087290740981783e-01,1.3395090237556401e-01,-1.8615213106204836e-01,5.6222705448939567e-03,4.2391882581836393e-01,-7.1345774793940192e-02,-1.1118090301806970e-01,-3.1244372736847015e-01,-1.3059972366611153e-01,3.2695521788019744e-01,6.9636125313708108e-02,2.5188429871784840e-01,1.0360982303734050e-01,-2.3290030986470275e-01,3.4259650470113634e-01,-9.1074952358283445e-02,-1.6690915565812561e-01,1.3124679715677978e-01,-3.7464477802508572e-01,-5.5182830910201208e-01,2.1687880990316927e-01,3.6534547947663260e-01,3.3744322957252165e-01,-2.4936373859123814e-01,-1.1505152242608795e-01,-2.9160930611145408e-01,4.1936341357062160e-02,-2.6236406054381761e-01,-1.7300654961676928e-01,-4.3265774047442515e-02,1.8771336517880849e-01,-2.1099055286522975e-01,-8.2865037761086058e-02,9.5318404887313940e-02,4.4689719850570468e-03,-1.5741823845744907e-01,-6.9122346746694416e-02,-1.1372484985018191e-01,-5.8935825786317515e-03,-5.0473285915527979e-02,-2.8941811349458391e-02,5.3425813327310986e-02,-3.5094542522460614e-01,-3.1025659870139660e-01,3.9229281016775981e-02,-4.9152108885417052e-02,2.0732744588339228e-01,-1.0141115372320066e-01,-1.0816887265773562e-01,-2.6874155297739499e-01,9.8638197274996758e-02,2.4675263206852655e-01,3.4912965983402877e-01,5.0910087062152976e-01,2.3627387332824407e-02,2.9391720863115744e-01,-1.4699989639028732e-01,2.1625683521381106e-01,1.6179996561948032e-01,6.0831935906184680e-02,1.1028746656931074e-01,1.4938364492504523e-03,-3.8948353644027817e-01,-1.8256737811032264e-01,1.1537008875517035e-01,1.3792023055009200e-01,4.0281287074454791e-01,-1.8987581351573532e-01,-2.4948811404341295e-01,5.8342000542488809e-02,-2.3232843470437844e-01,-1.6114746201177491e-01,-5.2497656325400133e-01,-1.1078038009120646e-01,1.2204501576518810e-02,-2.2523995584448295e-01,1.0350259225515829e-02,1.3601707362471685e-01,2.5594297563065982e-01,-2.0657375790497732e-02,3.2095786097924500e-01,-1.0075148921061011e-01,-1.5093984552868027e-02,1.6537774534071081e-01,5.2493909740237021e-01,-1.7162682218207048e-01,-2.1791454587962886e-01,1.0459745301141582e-01,-2.4839931296444070e-01,-1.2360107898963660e-01,-2.6890332436361747e-01,-4.4390562523509458e-01,2.3327249364287839e-01,1.3598828964906051e-01,-4.2507472712136486e-02,9.1027779347659377e-03,1.6216268992977637e-01,2.0794468873546665e-01,-6.8626818169314804e-02,3.5212930721612606e-01,-4.3608740173482236e-01,1.4806252266983649e-01,9.2702208516402096e-02,-1.9299537755033271e-02,1.9641986036571427e-01,-4.1212525908221886e-01,1.8924927371379566e-01,-2.9350640108054245e-03,1.1872536342449654e-01,2.8857445924073477e-01,1.1949063390905981e-01,-1.9941529259558310e-01,-6.7462815193486833e-02,3.3926879678775129e-01,-3.3744217565681067e-01,-1.5109939157975028e-01,4.2854219146914570e-02,-3.2699280463765495e-02,4.2696520973239151e-03,-7.4262579133099402e-02,-2.4173281415332604e-01,1.3741361534421884e-01,-2.1218986670955148e-01,1.3547633656331118e-01,-1.7720213937052309e-01,-3.0757965046121205e-01,1.1848233963345764e-01,3.0694548051721932e-01,-2.4466834339583521e-01,-5.1037224949886106e-01,-1.3387025489991858e-01,1.7622180792225539e-01,-4.4727981017543550e-02,-1.3136166782946429e-01,-9.0509819072501871e-02,-2.8818633771503582e-01,1.2729396625368439e-01,-5.1980026798278678e-03,-3.5139942621257320e-01,1.8778813735601191e-01,-5.7037229419933957e-02,-1.6062411960466799e-01,1.1742643930313086e-01,-5.1407115392855451e-01,1.0560437430294684e-01,1.5430798996856291e-02,-4.8638755951752771e-01,9.2175883292945654e-02,2.3592917532051963e-02,-2.5819183537128992e-01,1.0698376267702436e-01,1.8410315723086344e-02,-2.1439923683953394e-01,-7.0347555907699727e-02,-1.5213007610336468e-01,-2.2781996807855576e-01,-3.7225528305684613e-01,2.3962356480865238e-01,-1.4339615055305191e-02,-5.8828181063195879e-02,8.7202820757018767e-02,-1.8982818506400873e-01,1.0871548281406455e-01,1.3982981479663614e-01,2.2646891058891302e-01,-7.7150165019000044e-02,2.6885919613910902e-01,3.8738693984741823e-01,-2.9813675036432280e-01,3.1401058380401539e-02,4.2604332744839218e-01,2.0514012652550283e-02,-3.0479057084588779e-01,-6.8545467936688753e-02,-2.3814977982915136e-02,4.0014039584940392e-01,-3.1050772927480114e-01,-5.6910051710512694e-02,-1.1045433158138460e-01,-1.1545669780900179e-01,-8.2861935696007361e-02,9.6366579551716444e-02,-2.0703512507703217e-01,-2.7001136665392531e-02,2.8379520303391959e-01,5.1968080096036491e-02,-1.1661263316190212e-01,4.6058854440240889e-02,2.6160292675745178e-01,-2.4270908742537214e-01,5.6483639833385102e-01,-6.2479400121631723e-02,-1.2421787930570570e-01,-1.2358070651079814e-01,1.1035229224273588e-01,-2.0326469115676905e-02,5.3690465941196130e-01,1.1621400815017301e-02,2.1443377601924335e-01,7.8230555445904626e-02,4.5998814223438333e-01,-8.6164646338246012e-02,-6.2335229144460103e-02,-2.1260467792297587e-02,1.1684547090283010e-01,2.8434783153217777e-02,-7.9502114277338665e-02,6.6874046363835274e-02,5.6514136926376274e-02,1.4041474449840918e-01,5.4013277916745206e-02,4.2604082176920388e-01,-2.3050034392068952e-01,4.7125530390164921e-01,2.4509907049278384e-02,-2.9574556572538613e-01,1.7655887665656839e-01,-2.5230682471506349e-01,-2.8253574880790444e-01,-2.4239960107388606e-01,-1.6250032958830030e-01,-5.0643666978369514e-02,2.5613695159865321e-03,2.8581671321549075e-02,5.7324504821291422e-03,5.5198206226374480e-01,2.4830983582766045e-01,2.1202179830900295e-01,1.6004117091115766e-01,1.0920041725814289e-03,1.3461628643357204e-01,-3.4161535436324925e-01,1.4021087476113209e-01,2.4863633813480229e-01,4.6094886329894190e-02,-3.4617298743744018e-01,-1.6165430008395815e-01,1.4288741431210306e-01,-2.9949000594112674e-01,1.5667426156486974e-01,1.1687240757258920e-01,-4.4806016171542139e-02,1.4194612690718267e-01,-3.8013503075131966e-01,3.0312128628435214e-01,-2.2252319432498790e-02,3.9798165789360224e-01,-9.6603085423407190e-02,3.4281759060627415e-01,-2.7506907943608039e-01,-1.6964531300493205e-01,-5.4954822866580384e-02,1.4063990233499032e-01,-2.5012076413917528e-01,3.7490016796518304e-02,1.2150059473858930e-01,2.8758935664864567e-03,-3.6775698620500041e-01,-2.7620290806628434e-01,2.3256232438904492e-01,2.3778972500638540e-01,3.2081438938688384e-01,1.7723743766785605e-01,-3.4846929661189241e-02,-1.7847199566366262e-01,-4.0004628578394985e-02,1.3490729819109190e-01,2.4848952368289642e-02,1.9320309064481586e-01,3.5594172069014690e-02,2.1247711207748009e-02,6.9598004157287313e-03,-1.6424734514932551e-01,-2.6407727719908632e-02,1.1358245883791240e-01,2.1479279230164305e-01,1.7818463727802109e-01,6.6149759382284457e-01,-3.2621596618908255e-01,3.8813551900670756e-01,7.3979323119119950e-02,1.2748745837248793e-01,5.2935724883300096e-02,-3.2663110385803296e-01,-1.5614909255114778e-01,5.3475010413791983e-02,4.1040697995742559e-02,2.8859145038881906e-01,-4.4256099775063035e-01,1.9239118393565299e-01,1.9723761533575113e-01,-1.1115723494885213e-01,3.2785357450932806e-01,-1.0771943135781936e-01,3.4696045794442204e-01,-1.7428675605840055e-01,1.6795614034397943e-01,-1.3737814182754382e-01,6.9707758660826305e-02,-1.9709955737518176e-01,2.1128364321769297e-01,1.3445303134402006e-01,-5.2361753373092523e-01,-1.8798671099160663e-01,-1.2343808333642292e-01,-2.6521000146647483e-01,-1.0421181238319858e-01,3.9690630057421095e-01,3.4779016371190336e-01,3.2980987832035669e-01,-4.7362461102424605e-02,-1.6749352275024526e-01,6.9510405485549542e-02,-1.4674956794363733e-01,-8.0262792696550955e-02,5.4817660843642632e-02,-1.8563801091919990e-01,-5.9510716100831827e-02,-3.3226015738463427e-02,9.2759612836127922e-02,-3.0862821071542791e-02,-2.4093555462935509e-01,2.5910119798475975e-02,1.9703340950332757e-01,1.6617042187572942e-01,-1.9079465207361768e-01,-7.2867085325300840e-01,8.9002854905160161e-02,2.3673888819059075e-01,-3.5736459299499472e-02,6.8310017765879388e-02,-3.0353278864134403e-01,-1.1491769116849984e-01,6.6427480016278587e-02,-3.6702552464839305e-02,-2.5584848669150134e-01,-1.5339360741706848e-01,-1.4355959361739351e-01,8.5544118721507773e-02,8.9624969600579446e-02,1.9092030103521759e-01,-5.6605314128713627e-02,1.1044161847058803e-01,-4.2073884618720431e-01,1.8336389140946951e-01,-1.4920824313869291e-01,1.9880308472975805e-01,4.1551313868107964e-01,3.1924914860195594e-02,-2.5235183283851342e-01,-3.4577438372638070e-01,-3.6160551709978178e-01,-2.6559279623801468e-01,-1.5068107064332563e-02,-5.0648070373556994e-02,1.5853492003339353e-01,1.3112794915124842e-01,-1.5590962766752414e-01,2.0012061443280163e-01,-2.2256621187732542e-01,-1.2878744986757557e-02,-1.0914370149620474e-01,-2.4004065126159602e-01,-6.5114070788607581e-01,-5.8027574704673943e-02,-4.8426593062804245e-02,-4.1210623377001585e-02,1.9270910893705678e-01,1.8552898171316709e-01,2.5284182486988938e-01,3.3397718906201040e-01,-1.2809249090554083e-02,2.3950069465172100e-01,-3.5267485835407390e-02,-7.4593530454016482e-02,-1.4726941082465436e-01,-9.0884031533014553e-02,-1.4516431089628443e-01,-2.9494171889095366e-01,-2.4505350709839779e-01,2.8985219421004355e-01,-2.2830893877122643e-01,7.6185361989673586e-02,8.7502455812668870e-02,-3.5678298429148791e-01,1.4732461798549165e-01,1.4094513119348420e-01,4.4883841751820613e-02,1.3511726314696831e-01,5.0908452906035462e-02,1.5386233261654811e-01,-8.8449675420068957e-02,1.3543966056203657e-01,-4.4104080032811813e-02,-3.6603784476570089e-01,-1.8244384564759553e-01,-1.2121845141847526e-02,1.3178376178727283e-01,6.0170769837892468e-01,-3.8071398552476282e-01,-2.2863473293475220e-01,-1.0602629212929468e-01,-2.8912071735477402e-02,1.6715778831612310e-01,-2.9859530423830716e-01,-4.3692700801268802e-01,1.2766106545909636e-01,3.2546003332316609e-01,-1.2434311342927314e-01,3.7663623706490679e-02,-1.1078812605969610e-01,-2.3535202512169624e-02,-3.0102290740821591e-01,-1.9168898210777937e-02,9.5104370943093958e-02,-7.3825661308228444e-02,-2.9471417028470975e-01,3.3671537792269651e-01,-1.5830096785166398e-01,-1.1224040243647693e-01,-1.2627521308078249e-01,1.6335681583051176e-01,1.0885561678586218e-01,3.3298279093715633e-02,-2.6750488494110519e-01,3.7702420552490012e-01,-1.0613239113506986e-01,1.1783937608792160e-01,2.9459384979745054e-02,-1.2576213891702515e-01,-2.8281028172790523e-01,1.3709630093057884e-01,-2.1089215935552458e-01,-4.7574298910683677e-01,-1.8991176418556960e-01,-3.1129789811500075e-01,4.3226650155315516e-03,-3.6746437552657657e-01,-1.9663937976068285e-01,-3.6957428018659888e-01,8.7718719704606582e-02,2.3800874417870233e-01,1.9062109817963327e-01,2.4497904523422448e-01,2.5891075580331668e-01,-7.5317499534790805e-02,2.1289257092321992e-01,-7.2191440859817962e-02,2.2950876574390883e-01,-1.4165843686447119e-01,1.9424671409096761e-03,-1.9063162667448452e-01,2.6742524762949588e-01,4.3140428403327234e-02,-1.7427628799427911e-01,2.0564255921441901e-01,-4.5511009302844030e-01,-3.1029881663435588e-01,-1.4472058691352988e-01,9.6408692754614087e-03,-4.3252230745171566e-01,-5.6803225466559595e-02,-3.4795439957595059e-01,4.3296758057941448e-03,-1.4587016620036264e-01,-3.1683300042425810e-02,-6.7173920096105177e-02,1.2801186873379630e-01,2.1556972748829456e-01,-2.9374165613794817e-01,-1.4305039407642811e-01,9.8618982477171227e-02,3.9019885406133586e-01,-2.0876595344456716e-01,2.7691988056863104e-01,2.6633238494134853e-01,-5.8865171941767561e-02,-9.6561868384460542e-02,3.5516722987107513e-01,-1.1025606081770120e-01,2.6929624428740379e-01,-4.4600260274739713e-02,4.3052924698631700e-02,-1.1289513089950649e-01,1.5289079573342468e-02,-1.0949945203237968e-01,-2.4478978300194182e-01,-1.3514007873072900e-01,-1.3265011898810100e-01,-5.6699567337936352e-01,2.0796338517958884e-01,6.7485649071446670e-03,9.2028222878735758e-02,-4.2306599412057755e-01,-1.2802102152601486e-01,1.7697766819989544e-01,6.8888673391899913e-02,3.7735373093060087e-01,-2.0891593261292010e-01,1.3984891899962762e-01,-3.6656845620051054e-01,-2.0592183642381776e-01,1.5853563367749104e-01,1.3188270572596994e-01,1.2684354181866242e-01,2.5277198016495844e-01,3.6013340090198293e-01,1.4007641637077864e-01,7.4475845627576906e-02,-2.6144563081291777e-01,5.5952420407158010e-01,-2.5861137309362120e-01,-1.4021530620306791e-01,-7.3306860168489640e-02,1.4090307978402755e-01,-1.5378215008643437e-01,6.2396487125062135e-02,3.5053938316724834e-04,-7.4572617796143603e-02,2.2999455418188880e-01,1.1476649203549504e-01,2.3862124762547487e-01,2.8283740646637556e-01,1.0500579570165630e-01,-3.7833004734136122e-01,-1.8748647392332157e-01,-1.0078923724887712e-01,3.7330467033345699e-01,2.9063532062339098e-01,-7.7868670841659188e-02,2.9672676456329450e-01,3.1839774265928172e-01,-4.2138117748616949e-02,2.0603946297160752e-01,-6.7696098982515190e-02,2.8254977316852181e-01,1.5228901223308239e-01,-1.3454369415608727e-01,-9.0955543666964817e-02,1.7502744612738227e-01,1.1860707768319452e-01,5.2234029872869470e-01,-3.1799324472261981e-01,-5.8129207633075788e-02,-3.9169311947725813e-02,2.9601931772755302e-01,-1.1533772670366640e-01,2.6717593200453132e-01,-2.6939698842909299e-01,-1.2928331686415775e-01,1.6942191383405764e-01,-1.3812422274953559e-01,-6.5814604357155984e-02,1.4574542503844115e-01,1.2826358457921384e-02,-7.9713421808811552e-02,-4.3461644962377610e-01,1.5709520775675723e-01,1.4621497474985395e-01,5.7107750422115619e-02,4.2338073595746750e-01,6.8986481836120203e-02,-3.3515114423420617e-01,1.4090658828674010e-01,6.3892346156229018e-02,-7.9627413859642386e-03,2.0516917232405646e-01,-3.1999857801805059e-02,5.9595990322166614e-01,-8.2048233122492598e-02,-9.1670802877846264e-02,7.9568682686840933e-02,-1.3869422069617221e-01,-9.0439756366973933e-02,3.3294218048975005e-01,-2.7854040930258989e-01,2.4634711165236273e-02,1.5919417710632072e-01,-1.2185307719710536e-01,1.4046613058742272e-01,6.3509024990862167e-02,3.8307086386615008e-01,6.7956010821265400e-02,7.9004733297508498e-02,-1.2475520323524730e-01,-4.3876708456755587e-01,7.9073011152084136e-02,-6.9991981441096779e-02,-1.6515577868684375e-01,2.4098286477116440e-01,1.6353417860075370e-01,-3.3894029670155768e-01,1.7703878210472890e-01,-4.3997481587351150e-01,1.9825307671264078e-01,-1.8749306488657522e-01,1.7493734614825618e-01,-1.6169528459270904e-01,1.2767504264739338e-01,-2.6511025063051580e-01,2.1422590604766595e-01,-8.2761536047657958e-02,7.0684126071159453e-02,1.8465044156866797e-01,-1.8818462956116211e-01,3.6005661471593958e-01,-1.6245014087311505e-01,2.6516267050298142e-01,-1.1343399230954120e-01,9.1817522577971808e-02,-1.1555334570434922e-01,-3.7138087827456862e-01,2.7943900032531588e-01,1.2938828787033443e-01,3.8902240321432313e-01,1.4964102898341419e-01,2.7618695386886177e-01,3.2502226440592252e-02,-2.4012238955016113e-01,-3.8490150575637694e-01,1.2040514805312641e-01,9.9850407732105170e-03,-3.0940689823941442e-01,1.8404536368586882e-01,3.1596800750443405e-01,3.3583164349919779e-02,-8.1017605280133173e-02,1.5697419886575611e-01,-1.3097489703707771e-01,1.7474492132710806e-01,2.9749399929260834e-01,2.0505699029826527e-01,-3.6513593278519557e-01,-2.0141467555637399e-01,4.6298765082306424e-02,2.9045288045307566e-01,1.9880453084724939e-01,-2.4175979378709211e-01,1.9715266067188256e-01,-2.1647324368685542e-01,-2.2250886694511307e-01,3.4300159000056141e-01,3.2948485277216955e-01,-7.3827181463450159e-02,4.2398173150750124e-01,6.1417727560741930e-02,-1.1610386991717346e-01,2.7665740065966771e-01,1.8655034380386715e-01,1.1366015433900635e-01,-7.0395352197234404e-02,1.7410108070263944e-01,1.7620771782107048e-01,-5.0741018964519005e-02,-5.5251032315017058e-03,-2.0491141896275852e-01,2.0276045602779655e-01,4.1714718863937106e-01,1.5704551972264658e-01,-2.1323252720265226e-01,-2.9044847049000022e-01,3.3936990132639644e-01,-1.9296517391476614e-01,-9.0257507988695196e-02,-2.1059134237733979e-01,3.5480065326193841e-02,-7.9876674982957169e-02,-3.4341201928533965e-01,2.9604927499688449e-01,-2.5738083013922823e-02,1.8622992480507791e-02,-3.9178946663827674e-01,-2.8104898725258204e-01,1.7376677275579705e-01,-2.0974041558511525e-01,1.8025753098573410e-01,3.0817687823811757e-01,1.2909078398780877e-01,-1.5489857637372734e-02,3.0519014978690406e-01,-1.8654889197212341e-02,-9.9575721355397689e-02,7.1800824344320585e-02,3.3394234924976451e-02,1.6243678481273532e-02,1.9829476084024839e-01,-2.1089174173178432e-02,7.0568588718644382e-02,2.3172272149376533e-01,4.6364561115829606e-01,-4.4939632473698518e-02,-1.6069563235955087e-01,-8.7824214163525038e-02,-4.2399435393517659e-01,-1.2023362640974299e-01,4.4428585036323864e-01,-2.6582922996463904e-01,2.7042265750151512e-01,-7.5408837742451537e-02,1.9343285632846416e-01,-5.8328326312699331e-02,-3.9311226279590383e-02,-4.2057733971367278e-01,3.3183016046849156e-01,1.3716254836217337e-01,-1.0579625014747773e-01,1.2597586800919142e-01,2.9986213962842512e-01,-7.7394357478089398e-02,1.1452435273325012e-04,-1.0220474959472209e-01,-7.4219663134078739e-02,2.6021431130589473e-01,1.9192572815960367e-02,-5.4887778064768544e-01,-7.9574046241795010e-02,2.8092493869220803e-01,5.1502379151714017e-02,-2.3590612919073894e-01,-5.0503747233375300e-02,-1.4294185666599288e-01,-2.0764601076728642e-01,1.3939114363647401e-01,-8.4768281664013165e-02,-5.0151299150864095e-02,1.9606993333282507e-01,2.2017934495635602e-01,-2.7388302440338569e-01,2.2224065806157711e-02,-1.1781482229166998e-01,5.9438314591097607e-01,-1.7215068537442491e-01,-2.9051772585257385e-01,1.0689769723357584e-01,2.5998245084733640e-01,-2.3743678526752088e-01,-1.8139222256305976e-01,2.9488100470707307e-01,7.6687772204380750e-02,1.2697627887449944e-01,2.0392702301635823e-01,-4.3325756910522523e-01,-8.9305301162069112e-02,1.7380152550216951e-01,4.2347976066968729e-01,2.1962568578336991e-01,1.0064852098982269e-01,-5.7585461144256167e-02,-2.8359310805089394e-01,-4.1983259628055120e-01,7.6041938180600399e-02,-1.1630437903418755e-01,1.0794135317435463e-01,-2.4468921490946002e-01,-1.1573540015294745e-01,2.4109907935053790e-01,-6.2609266104743710e-02,-1.6986927532223134e-01,-1.5350203172143470e-01,-3.5973354477226306e-02,-6.1731579979322285e-03,-1.3971537145135646e-01,-3.8640960170407707e-01,-1.5222850113803868e-01,2.4963490981360301e-01,1.7350964421118467e-01,-8.5328233181534166e-02,-4.1435371201715943e-01,-3.3353154614949587e-02,8.7448647466460472e-02,-4.0604746872041569e-01,1.6812433871035848e-01,-1.5021792631724601e-01,-6.4954091689829629e-02,2.3009685796448187e-01,-1.9250238743367767e-01,3.3379162863529555e-01,3.2270842028278740e-01,-3.2009837005124983e-02,-1.6124438536686531e-01,4.3399030163732788e-01,-4.9700815663790299e-01,1.2804446520248008e-01,-3.5365243233151072e-02,-3.0756394100574419e-01,-2.1417592284225218e-01,-5.4210311963091513e-02,3.7524729498380427e-02,-2.2734728787994229e-01,2.7148140517887359e-01,-1.9387540032184181e-02,7.9731381862195555e-02,3.6336405431264951e-01,-1.9681137729731811e-02,1.3557650334791230e-01,-1.1647235014512149e-01,-1.1340828146091775e-01,2.4341914691325817e-01,-8.7016632082273435e-02,1.9642749260071715e-01,-1.1629625150821814e-01,-7.2370013012535483e-02,2.2726124514797930e-01,-6.6659796833358473e-02,-4.7288278385579402e-01,1.8580665678692621e-01,2.6419175341307233e-01,5.6666287608501342e-02,-2.4279034279281314e-01,-2.6764467089444924e-03,-6.4174888997818119e-02,3.3314203375448720e-01,-3.0403980261154995e-01,-3.3467585040869130e-01,1.3427441724582648e-01,2.1464076089269646e-01,2.8235075609703997e-01,-1.2306980050682990e-01,-1.3393781204711119e-01,6.3693264421649728e-02,9.9503765939870495e-02,1.8608240273525192e-01,-8.5800754407458643e-02,8.0828303755315467e-02,2.7039147742389955e-02,1.1709795286417318e-01,-3.5077716385587515e-01,-1.4001589141157425e-01,6.8288316485682024e-02,2.0506954793462864e-01,2.9628025727650542e-01,2.3897214155017360e-01,5.6775932466209079e-02,-6.5552271036604959e-01,-5.6999503232317214e-02,2.1674019793019240e-02,-2.2085419143029048e-01,7.5827134466599000e-02,3.1247936782349006e-01,-1.8811428001894212e-01,-1.3677284422800878e-01,-1.9621804994789432e-01,1.8806380020909053e-01,1.9739653409422087e-01,-2.2327373712628262e-01,3.4787617724126263e-01,1.4429156016395378e-01,-2.7914305016683028e-01,3.1191610746509441e-01,-1.1938875328417541e-02,-3.1513931051880983e-01,5.0436201676500036e-04,1.2229949253608538e-01,6.5450903048209538e-02,-4.0924396818043873e-01,2.4895834041975409e-01,-1.5407270694748137e-01,2.0620247775352157e-01,2.2749602932823387e-01,9.0457107060357089e-02,-2.8478059918902782e-01,1.7905127588750423e-02,-9.4063523618517511e-02,1.7885761964127431e-01,6.8502877654904384e-02,3.3470740647394820e-01,2.9269464127158640e-01,3.6988022281867466e-01,9.5897464568174690e-02,2.4247230423812646e-01,5.2609001657434123e-02,-2.2656183431778690e-01,4.8171670657100324e-01,-1.9578100823112490e-01,1.8791166230308537e-01,-1.7233265062095621e-01,2.2863273350756003e-01,1.4062626917193072e-01,-2.8799259262160072e-02,1.8103698059635340e-01,-1.8697290421881160e-02,1.7581597936202675e-01,2.2427367705296339e-01,-2.7977071186279578e-01,1.3162976201935905e-01,1.9310627548802051e-01,9.0775070852348816e-02,-2.8958383220217754e-01,-1.3649537501920589e-01,-2.5719998938616616e-02,1.7650218102888657e-01,4.6303001503499625e-01,4.5960255033366071e-01,2.5175487037632210e-01,-2.0717275945460126e-01,-2.1774541023043154e-01,6.2784434034041992e-02,-1.3848290583690456e-01,-8.8140444166630263e-02,3.1619044739872504e-01,-9.2116783891128484e-02,1.0161151353604983e-01,-3.7977643330091387e-01,3.4631450578681167e-02,-2.4090989195514192e-01,2.8503928273099088e-01,-1.8003034298288861e-01,-1.2444972058446664e-01,-2.3962875854043458e-01,2.5759707257731773e-01,8.5005828568138625e-03,-1.2181458038430620e-01,4.5244661710746231e-02,2.8742798291400223e-01,1.1563444289998903e-01,2.9663010151563685e-01,-3.9185852638630519e-01,-3.2104606810884903e-03,-2.6518818412349870e-01,-5.7027581744309143e-02,1.1733480163700473e-01,-9.9933578326515796e-02,1.3624061769114434e-01,-6.8727079853523013e-02,2.4266826290136795e-02,2.8892514198542812e-01,-2.2997849246103187e-02,-1.6332417871471397e-02,5.8810457322406952e-02,3.3558804180083862e-01,-1.6342302748904775e-01,-2.2255935489574752e-01,-2.6538065567698865e-01,-1.4822129022723779e-01,-2.3323571587873371e-01,-5.0141083966431732e-01,-1.8342002026524612e-01,-4.1480245263567678e-01,-2.6194768389956707e-01,-2.0729296260199850e-01,-5.3080933028523673e-02,-7.7128055629878095e-02,-5.0119189207986525e-01,9.3979519677867742e-03,-1.5952067193422467e-01,-2.1006181839530030e-01,4.6783228143148414e-01,-2.2273734995388184e-01,-9.1130801421649810e-02,1.1216435528953306e-01,7.6061514239679495e-02,4.0760042368930410e-02,8.6886994664402709e-02,-2.3760628998375610e-02,-1.3218637320862953e-02,-5.2957701655970330e-02,-4.5564434552951456e-02,-4.5028391304259485e-01,3.3863342959239745e-01,1.4020089849786868e-01,1.0380804332877867e-01,-1.3895575736063490e-01,-4.1523759099099322e-01,-3.2773034272056462e-01,-3.0789989297655129e-01,1.6807243275721964e-01,-1.2131737765851942e-01,3.5410994205896040e-01,4.0075798190961631e-02,-2.8128102149616285e-01,1.2853593450761774e-01,3.5532368528863184e-03,-5.5662028099900229e-02,4.3404567315287773e-02,-4.5000323654297003e-01,-2.0677593675098666e-01,1.3110308575960666e-01,1.7230068149324826e-01,1.1353792296320041e-01,-1.2090076048769437e-01,-4.1937264192550538e-01,-1.2881604346581112e-02,1.8263400632961546e-01,-4.0911375068677225e-01,7.5999565876176650e-02,-2.0913534051854678e-02,-1.3473276115166855e-01,6.4392543593240897e-02,-5.4837569839056022e-01,-2.5072858058757131e-02,-2.2332480604494287e-01,-2.5465033618103539e-01,7.5604997094514043e-02,-1.2415986494813165e-01,-3.9823820481694847e-02,-7.3321557625555811e-03,-1.6841888133330399e-01,4.1418052614901911e-02,3.3344356761580340e-01,-2.7409791533036554e-01,-1.4492960428310764e-01,-2.3480837661743432e-02,-6.6585260117159567e-02,1.1302083461597232e-01,-1.6926131441338543e-01,2.0687501802127239e-01,-2.1611372735540391e-01,1.5449444624421690e-01,1.1193227308617103e-01,-4.7084538519158003e-01,-1.7844542925226142e-01,2.9372313574445164e-01,1.3401888719087593e-01,1.1815738430740463e-03,4.1349057682647739e-01,-2.4750801503497538e-01,-3.0996017352250976e-01,-2.1018377987725101e-01,-3.6011368654086315e-02,-5.2292266603815785e-01,1.5488549470426041e-01,3.3072149930077777e-01,-1.6582316916515794e-02,6.2044972452419786e-02,-2.4668392597993921e-01,1.8719674284457363e-01,-1.8115412909914747e-01,-2.3436034908304776e-01,-2.1091001242212290e-01,-1.3721868318047689e-01,1.7541912676945870e-01,-3.1482383262499275e-01,1.3192939952543803e-01,-6.2226376916135709e-02,-5.2593169833949571e-02,6.9386588108463029e-02,3.7663677140413798e-01,-4.2801895500206008e-02,-1.9920022835261353e-01,-1.9591458250499415e-02,-1.6822980688585065e-01,2.2376042456674794e-01,-1.1762521939782160e-01,-5.6030593587964590e-02,-7.2436306178234253e-02,-3.3630836533088099e-01,3.0047932720119180e-01,-1.2626339639937265e-01,1.3533275764523314e-02,-1.9772679226680645e-01,-1.0049919549821264e-01,-8.4393283417424515e-03,7.4096959444830135e-02,-3.4247725264319723e-01,-2.0435714456871021e-01,-1.3182599993687763e-01,-3.0817904657957224e-01,3.1254959299004775e-01,-5.0562592011995255e-01,1.9359391190516155e-02,7.2926356332292913e-02,-9.6541424461705994e-02,1.6557118188101454e-02,-6.5372068590582888e-01,-2.4931944753062395e-02,1.2220165657609897e-02,-6.5612301001923071e-03,-9.7840425837565095e-02,4.8545700582301810e-01,-2.9488724342615829e-02,6.2828152342501841e-03,-2.0942336699810382e-01,1.9077748727646732e-01,-1.6539655425960209e-01,2.3455178712767810e-01,3.1834880910215518e-01,-9.9278760671395912e-03,-1.8818035900683480e-01,-1.0448163774662743e-01,-1.7243632594851628e-02,-5.7417526492750715e-01,-4.2016643123255781e-01,-4.0841078326893196e-02,1.2441054842752176e-01,-5.4114986965262665e-02,-2.5226898652533952e-01,-3.9643092623520548e-01,-1.3107171212170482e-01,1.0965297307524607e-01,8.9395479178999190e-02,2.1993630568670039e-01,5.7166161982712564e-02,6.6124723252418111e-02,-2.3042726675157020e-02,-1.6363760267076924e-01,-2.6471849788806756e-03,2.2054491442208696e-01,-1.5748933628687550e-01,-2.4217415985894181e-01,-5.5221569439280149e-01,-7.7476252734892698e-02,-3.8002717807134045e-02,-1.1451660556441559e-01,-1.8599885278066003e-01,2.8647189864772782e-01,1.6279513380001998e-01,1.0913768860525716e-01,3.3282639675181530e-01,-3.4024949432042331e-02,2.5897457211864894e-01,1.7451538499251684e-01,3.5343883431854539e-01,-1.5805022932793653e-01,6.9867271091994518e-02,-1.0663209881863631e-01,2.8181049034789574e-01,-1.1823002568336215e-01,9.1028499701938645e-02,-2.0526817819074078e-01,-3.0642588337167476e-01,-1.0314388960543888e-01,-1.5458978382859176e-01,-2.0520026384763763e-02,4.9230195675671579e-02,-5.9253316170318981e-02,3.4704448039499725e-01,9.7209774858988601e-02,4.5757463001495476e-02,-8.2405529007914050e-02,5.9296386650994744e-02,4.3577795575911721e-01,-8.8832819997247570e-02,-1.2303318321351692e-01,-1.7269914852408380e-01,2.4028129591757257e-02,-1.9141262758269137e-01,1.6643668603885303e-02,-2.1906405976839793e-01,-6.2823778152942555e-01,2.1542039851190981e-01,1.3309896155510378e-01,1.2997113296877683e-02,-5.8695441620748232e-04,5.0393555512750510e-01,6.9361772992419121e-02,-2.0908433522772366e-01,-2.2412306970462650e-01,3.3096398852112330e-01,-2.5106939612928980e-01,8.8078589102861780e-03,2.3385716664280673e-01,3.9616705763896148e-01,4.4700234852348801e-02,3.0236272846767459e-01,-1.9122139885321070e-02,-2.8219766684929498e-01,2.6981557871960174e-02,-1.5253234152713940e-01,-3.5989118310776842e-02,2.8099841565284805e-02,-3.2308729719957047e-01,-4.4267808576215728e-01,-3.0922114717659688e-01,2.3044172837983973e-01,1.3389202233595635e-01,1.6027984562593367e-01,-5.5413554529278874e-02,-2.3688355563601041e-01,-5.0842081827060896e-02,2.0320876852076772e-02,-3.6930088120693044e-01,-6.4095472030441136e-02,2.8804693504019413e-01,2.5459440142103051e-01,2.1589935774419258e-01,-1.4971384160841528e-01,2.1607314963484189e-01,1.5166746240119586e-01,-1.3169227083822851e-01,-2.2173274530974010e-03,-4.0963846853990926e-01,4.5079765002105844e-02,-5.2334905664572816e-03,2.9252169209637291e-01,1.0113255891644581e-01,2.1498156768157817e-01,-7.2383355357040435e-02,5.1633654095374341e-02,5.4929771297207286e-01,-6.8841533977697045e-02,1.2325363326606893e-01,1.1027355426731811e-01,3.7435201674150848e-02,-3.2559678761766631e-01,-1.3019828693721237e-02,-2.3381815117304994e-01,-1.1314020216120715e-01,-1.6333312462454197e-01,3.8034230633779920e-01,5.5065254827249255e-01,1.8974173447408041e-01,4.8037130103615315e-02,-1.0918258275087046e-01,-1.6264444121798555e-01,-3.0575808810434535e-01,4.3419212132986945e-01,-1.9757351706525629e-02,2.9071466460644846e-01,1.8646358728824128e-01,-3.3338446286751511e-01,-1.4604657899966358e-01,-1.6990282675093213e-02,-5.2579924723374159e-02,1.5508642877432605e-02,1.1267195367041512e-03,-1.7602139351124188e-01,5.7811846309066037e-02,1.3400408506497913e-01,-1.7424304632092058e-01,-1.3609833830964577e-01,2.4942546442904007e-01,-1.6311475929201397e-01,2.5408435183007172e-02,-1.4375979371386441e-01,5.6440752095139668e-01,3.6833768896281566e-01,1.1746504302272842e-01,6.8345467558458758e-02,1.0784199145020731e-01,3.7307712484020150e-02,1.3210797708572614e-01,3.6527272893717372e-01,-1.3213229910283797e-01,1.1653506095106045e-01,-1.9054114635547773e-01,8.6673783515618774e-02,2.2678132584084054e-01,3.0870030660844361e-01,1.1474281919268585e-01,1.1667662940041222e-01,3.5382742301008485e-01,-2.0231581540571036e-01,4.1222640510714148e-01,1.9899340865917312e-01,-1.0265188890852234e-01,1.0753181657935471e-01,3.8291938539965542e-01,-3.6496387848193074e-01,-1.4451650271922026e-01,-2.9971006356165647e-02,-4.1289659398957991e-02,1.6803256273992132e-01,2.5428169657481148e-01,-2.7905781677704516e-01,1.3488844341799705e-01,-2.3047795406756652e-01,-1.8403846425589929e-01,5.1781036645215078e-02,8.1754125278297979e-02,-1.2515053587085562e-01,-2.7999705334785413e-01,2.1323514483067554e-01,-3.1896994255531541e-01,1.5738967696324904e-01,-3.0160109718509770e-01,1.7038339145758868e-01,4.9069767536418185e-01,1.3082506796529797e-01,-3.6438073995683828e-01,-5.4426017080968753e-02,1.4585566155158339e-01,9.7483932417372146e-02,1.4242046988425509e-02,6.1078634147829325e-02,-1.0759147736173250e-01,7.4325909428972076e-02,-5.7668919555952568e-02,3.1406268081122024e-01,2.5798453985751418e-01,1.3727060215219078e-01,-9.2657834701758646e-02,3.8367409807335745e-01,1.3459476389979941e-01,2.4917947820641047e-02,1.0926765981553511e-01,4.2550056110021689e-01,-1.3520852799035296e-01,-1.0938785254976068e-01,-3.1683953427063971e-01,4.5644551340044404e-01,-3.3059831166185061e-01,-3.4039617441600056e-02,-8.8802215437189524e-03,-3.4673074734972852e-02,-3.0384897419262674e-01,-9.7783317852972923e-02,3.8070703915448353e-02,-2.4306549190327209e-01,2.2601702330460764e-02,-2.4847643649816978e-01,9.7941523800806091e-02,3.8132017712022725e-01,3.1608687584841547e-02,2.7230496905941010e-01,-1.8815401608480026e-02,7.8833369191981709e-02,-1.6495828434034199e-01,-2.2542100199291340e-01,2.3754387300581289e-01,-2.8013703384165289e-01,-7.2958021256959216e-02,1.0576268253464474e-01,3.4138249571660934e-01,1.6861363593291318e-01,-2.7419538761215800e-01,2.0041133132296729e-01,-2.2547034491323822e-01,1.9904225567709305e-01,-3.4832543745583328e-01,-2.4301846712118147e-01,5.4991694222369832e-02,-1.1806509491769950e-01,2.0873549386162935e-01,-4.4915208791349949e-02,-2.7340576423194890e-01,2.0886480123885420e-01,-4.0585385188077205e-01,-2.2092907352226354e-01,-7.9037642396718052e-02,-7.3039877403944131e-02,1.8620875969973885e-01,-2.2341592305892857e-01,-2.4282164395408395e-01,3.6066043170635309e-01,-3.3903727415256942e-02,-3.1380831203105597e-01,-1.1487293653523478e-01,2.1593797502435683e-01,3.1910797574041849e-01,1.7969043138964663e-01,-4.3298327426563109e-02,-1.9086394946069157e-01,1.0889247581997503e-01,1.4304145935346257e-01,-1.2700783899002456e-02,4.4208618614752906e-02,4.3022998495320319e-01,-8.0557670289580385e-02,2.6698841337563917e-01,6.8199012611312115e-02,-1.8548176104262216e-02,-1.2747210924118493e-01,-2.3990732275213877e-01,5.4429817495868671e-01,-2.0452394219105949e-01,1.8505200100177105e-01,-2.4874645467695136e-01,-3.4471672070703707e-01,-1.6254702649431182e-02,2.1964214087292550e-01,1.4246175809928660e-01,2.4782671524455815e-01,-2.9628798633091352e-01,-2.0633791411807142e-01,8.2328738629254564e-02,-1.2366525530715589e-01,1.4317290047085074e-01,-2.9123105931085336e-01,1.8878619817259479e-01,2.4347286636360294e-01,4.3374701401381421e-01,-2.0723285497182031e-01,3.5049723939327604e-01,1.5816635164883391e-01,-7.7536153046150899e-02,-3.2653284760883411e-01,1.5511231214340485e-01,1.8536473616824367e-02,3.7306514423851689e-02,2.6233179663166101e-01,-4.0733799920314628e-01,-2.7480669112763556e-01,2.1941819375909080e-01,-3.1127553070790709e-01,1.6718929748222749e-01,-1.0523915443543058e-01,-8.5494854257869915e-02,6.9480495354876881e-02,-2.2265445414436105e-01,-1.7009090518794451e-01,1.6590019847972431e-01,-4.4493267448085178e-03,2.7026439045465533e-01,-4.9033270874115298e-02,-4.4510082035622489e-01,-3.4982029062602157e-02,-3.0199577143362433e-01,1.2551772017403109e-01,-7.5812215647236211e-02,-3.3118708710318423e-01,1.0976294519502426e-01,-1.6081516960975784e-01,1.7655321514541733e-01,-9.8952440194871941e-02,-2.5905775204688380e-01,5.3062767684807798e-02,7.6812363216911164e-02,3.2646679708701265e-01,5.8791721569840603e-02,-7.3954086616085601e-02,-8.9960038957756602e-02,-7.1283310176251280e-02,4.8262543068262609e-01,9.9927225495618513e-02,-2.5962370839889876e-01,-9.3931022695361993e-03,4.0491592458493980e-01,-3.1458410100485434e-01,1.8333158549743178e-01,-2.7856355536870608e-01,-8.8220945296714523e-02,1.3460187326433937e-01,9.5078909147577925e-02,-2.4608034242518279e-01,2.5617143741105353e-02,-2.0157589152509273e-01,2.2525652432717796e-01,2.6018222250389633e-01,1.7624000461168279e-01,1.8580286198486301e-01,-3.4798148394123901e-01,1.6890228893128564e-01,-4.5801633987557121e-02,1.5330939907480462e-01,6.0955115312575421e-02,-5.5090799126483703e-01,-2.4929155486247459e-01,1.7206956425536601e-01,-1.6555539152967513e-01,-1.3468076555208211e-01,1.2109245275136324e-01,1.2796562006221568e-01,-2.3752935986868584e-01,-4.6569148149007686e-02,3.6831403586248213e-01,-3.0455101232328231e-02,1.2487453305429194e-01,-1.1432964695375769e-01,-2.4618119228744362e-01,-6.1552399539473623e-01,-1.4939771694757445e-01,-1.7486010240852384e-01,-1.2899309209451715e-01,-2.1333906210514501e-02,-8.2173183192848609e-02,-2.8236623362155805e-01,-4.7034263841447467e-02,-3.4305354473343364e-01,1.0554541304167141e-01,-1.1527842573659144e-02,-1.8855864576263101e-01,6.6547267880202030e-02,-5.7997281716757290e-02,-4.1392408416597204e-01,-2.0334978415869209e-01,9.0358056726439900e-02,-7.2387201550647096e-02,-3.1570205217609626e-01,-3.1661213722010598e-02,-1.1797345614910762e-01,5.9050243057636870e-02,6.3734925482903204e-01,4.2060500092613071e-02,1.7986870181387982e-01,2.2562547447579812e-01,7.1294730025791175e-02,7.0249387994351306e-03,-3.4016376777918572e-01,1.6444724976921867e-02,-1.0496320526666329e-01,3.3037254525967741e-01,-3.3520523641207017e-01,-5.5607917740029189e-01,-4.1039367514603513e-02,-1.6276142197544080e-01,1.3973356630613804e-02,-1.6318538575120722e-01,3.4008622640387121e-03,2.5081462279628552e-02,2.3032841356043629e-01,-1.0588813443872570e-01,1.3866968380322170e-01,2.2845239756789218e-02,-1.8465707737697340e-01,-3.0588363145671993e-01,-2.3162642323984461e-04,-4.1492581317409621e-01,-1.1104361641493038e-01,8.0233171897221997e-02,4.8197428743420243e-02,-9.5701074026356470e-02,-7.4568885882054334e-02,1.3404437216860896e-03,1.0589109827959906e-01,-2.3828152336733038e-01,-2.9529573249222285e-01,5.6479698828763608e-02,-3.0877292292070940e-01,9.7419755734843391e-02,-6.3332356126583889e-02,-1.0283452568329074e-01,1.9062738905394933e-01,-3.6113914577927408e-01,-1.6944017571973352e-01,-4.9923885919977296e-01,-1.7551372550725469e-01,4.5209791476668254e-01,9.9698536721566422e-02,-1.2373811693322204e-01,2.0302759261505321e-01,-3.6927113204482437e-01,9.5681986035728958e-02,1.0861473675404440e-01,9.1827759357977226e-02,1.1973350385810787e-01,-1.6636371885235327e-01,1.4826938628414513e-01,4.8834993164625196e-01,3.0321219480620776e-01,-6.4174921395891080e-03,-1.5579118799843868e-02,-3.5007811245917966e-02,2.7336862922758121e-01,9.8056844135072485e-02,-7.5133457881990162e-02,-1.4627867666194563e-01,3.4748810103622396e-01,3.0849814337129183e-01,2.6419201631150158e-01,1.4399783639306385e-01,-3.2519433075274773e-01,-4.2498740486941305e-01,7.3512248661544377e-02,-1.2820344569685733e-02,4.9726804678557820e-02,3.2253041118262799e-01,9.4623815193493041e-02,-2.3196599568424670e-01,1.2868711853204806e-01,6.8497095595043050e-02,2.9221954217170032e-01,-3.2343305566965430e-01,4.6496433612412152e-02,3.9979608409410855e-01,2.1822382522349790e-03,-1.7847770377448779e-03,3.4964347786577393e-02,6.6559353540656563e-02,-3.7303779496393946e-01,1.1549947845390206e-01,6.2509451508726999e-02,-3.0583894421846824e-01,-1.7818148536795317e-01,4.7240489833217533e-02,6.0082269733052945e-02,-4.7427172913507615e-01,-3.0015624121089501e-01,8.9045720036732182e-02,-3.4436835060700327e-01,1.5166149582615795e-01,-2.2853486163987707e-01,8.6220118732126400e-02,9.9656944554706445e-02,2.4789335563060713e-01,3.1379236805947057e-02,1.5095763140918547e-01,-8.4417034035801614e-02,4.1326870122250386e-01,-2.3311501342779203e-01,3.1380139409767188e-01,1.4144873666578728e-01,1.8474552270893943e-01,3.3945252079273525e-01,-1.9106876339022869e-03,-6.8311710868916700e-02,5.1163911097148573e-02,2.2832103100282292e-01,-2.3498571621089237e-01,1.2698603962425337e-01,6.0004769287231585e-02,-1.2583653861526906e-01,3.6983943362378202e-01,-1.8760410401405958e-01,3.9915761856808624e-01,3.2317891634066215e-01,3.1171299331915292e-01,-8.0344826165446061e-03,1.5256945149449708e-01,1.6034209338031225e-01,-3.0294213047862850e-01,1.1410069184448063e-01,5.0668224802027602e-02,-9.9350014313004748e-02,-3.8662569300152227e-01,-2.5336638696183106e-01,3.1494753910767376e-01,1.7329597176487527e-01,1.4567338451023744e-02,-2.3503686637401408e-01,2.8762468207363240e-01,-1.8662955219845526e-01,-2.2465990995327204e-01,4.0069891797985208e-01,6.8011216889857187e-02,1.3943685375696041e-01,1.5213715582980866e-01,1.7177045065047147e-01,2.0789152924772561e-01,1.8944490374101916e-01,-3.1801215392841482e-02,-7.4133589718506837e-02,3.6502625219808893e-01,-1.7966625552047516e-01,2.9994478012984777e-01,-8.9479411487893318e-02,-3.0639893573135790e-01,1.6784588709035170e-01,-5.8256141458998167e-01,-8.6390551746986524e-02,-1.9678062640256533e-01,-5.4149836174896271e-03,-3.0884058545915088e-01,6.9641218324253920e-02,-2.5060308007122910e-02,4.6458159876697838e-02,-9.6306924036789726e-02,2.5501570491235631e-01,2.0838092690346763e-01,-4.0003539292748920e-02,-2.7473421082308724e-01,-2.4964586200249222e-01,2.9177427524774330e-01,-8.8010975288825677e-02,-1.2057497982648743e-01,5.7014707885099059e-01,1.4669193594417768e-01,-5.3111221079712924e-02,-9.0788139837988405e-02,-1.3535729188398707e-01,-1.8044915859540389e-01,-1.8583617627265420e-01,3.2557245736639540e-01,2.3996734203649264e-01,3.0129172178953534e-01,2.3086328242811656e-03,-6.9052695581339599e-02,1.0069244412695515e-03,-1.5378964370292902e-01,-1.7008575335295420e-01,-9.7442087874046845e-02,3.3420190338491185e-01,-2.2175626693482109e-02,1.5770188851673056e-01,3.0458061265247904e-01,4.4545601670301443e-01,-1.1064318499980678e-02,9.7171833349449496e-02,1.9487309649921231e-01,-1.4289272541540629e-01,-1.4236298806586689e-01,3.3540053906881057e-01,-3.1056055184911074e-01,1.9355154920097997e-01,-1.5623889878624991e-02,3.5919368876708080e-01,2.4518079190470793e-01,-1.5146004722590223e-01,1.2378119514048413e-02,1.2309116439749712e-01,2.0172742524974507e-01,1.8140556950143918e-01,-2.1693120448354009e-01,3.6026496993796464e-01,-3.6757108832732405e-01,3.3759237372913808e-01,-1.8189295569119296e-01,2.1847325829942418e-01,-2.3231323775451335e-01,-3.1715057637497893e-02,-1.1032952577721118e-01,-2.0090961915569761e-01,-1.0473644019194453e-01,1.2310807976181833e-01,-2.6857809253463888e-01,-3.9149523767798461e-01,1.6002321647936574e-01,1.7905662557328361e-01,-4.7171235181103818e-02,-2.6849810963427159e-02,1.7883747655157639e-01,-6.4855301231065865e-02,6.3875932160906645e-02,-1.6758722450841465e-01,3.4837022467144529e-01,2.3741565164151648e-01,2.8518740039164187e-01,1.8418706757950967e-01,3.9027641212438818e-02,-4.2336651352622601e-01,3.6362791214129658e-01,-6.3116595572759199e-02,-4.4579625472386281e-02,-3.2186293359635570e-01,3.2641605515321158e-02,-3.9005285353118480e-01,8.4580909215728042e-02,8.8656029455169622e-02,-3.7203912202413321e-04,2.1882760617410491e-01,2.4591679449417231e-01,-9.6736471740278621e-02,1.2467436287512884e-01,-2.8370636869225718e-01,4.5541760426563098e-02,-2.0703489517295554e-01,-1.0233622409704139e-01,-8.4913389146065721e-03,1.3718931856433789e-01,1.3900679648731394e-02,-9.1407345749884267e-02,7.4569258073957492e-02,-7.9501824539949667e-03,2.4245051034437570e-01,7.0183023366970618e-02,-8.4791111556765622e-02,6.2122996552678789e-01,1.8574659951553910e-01,-4.8516141314511158e-01,-1.3766246218650324e-01,4.2435209098764415e-02,-2.4252905262835203e-02,4.1975894283876262e-02,-4.7771321527073440e-01,-2.3840624824752865e-01,3.2497072143989841e-01,-2.5157995791061927e-02,1.2021274443242347e-01,4.9006806620841017e-02,4.1973985171031247e-01,8.6694673741170208e-02,-2.7858020237766029e-01,-2.8049504130091751e-01,-3.5559598135290921e-01,-1.0971804927320765e-01,2.3838715457224943e-01,1.7476109418239683e-01,-1.0904288616181833e-01,8.9402234721204982e-02,-4.4592687635675997e-02,5.1972608409905363e-01,3.8029565379118879e-01,1.1281299056589314e-01,-2.7188393361411345e-01,4.8808173453802894e-03,-4.8436149341298338e-03,3.8595071277729037e-01,4.7930707267600424e-02,9.2219873180973119e-02,-3.9323873854573727e-02,-2.4117542309648768e-01,-1.0971277610599274e-02,1.2911360948980885e-01,2.2422969304155316e-01,-1.3996843582496263e-01,2.3094260173740132e-02,-2.5718674851091711e-01,2.1775770537733052e-02,2.1007262054037945e-01,-2.8486743226968070e-01,4.8172908255832779e-02,1.3013031312381025e-02,-5.6666444976088089e-02,-6.0442807310325211e-02,2.6859420307209331e-01,-2.0481440351710636e-02,-1.1671878084711221e-01,3.3124565790120802e-01,-1.3720897151685749e-01,2.3950131350609660e-01,3.5997706902462800e-01,-1.9614959721181774e-01,6.1661106522278540e-02,4.5251696531136720e-01,-2.3713547495262749e-02,-9.8800725439438492e-02,-1.3267152042144864e-01,-5.3324404409261394e-01,-1.7196713078250062e-01,8.3506670357690119e-03,-2.9320598727983599e-01,4.7168077074147435e-01,-3.2740630380026325e-01,-2.3056588182467463e-01,1.9106211266776638e-01,-2.1284775078206010e-02,-2.3627988065328204e-02,1.4226859815905146e-01,2.4873148767676954e-02,2.5753646793403850e-01,-1.9020803072183701e-01,-1.2058275649361605e-01,7.6735245858689072e-02,-5.6561446745241564e-02,4.0833521659558064e-01,-2.0558356759489857e-01,-1.0789243348270412e-01,3.1007935259964525e-01,-1.2002138550893239e-01,1.2444963990955792e-01,2.1595666874553732e-01,3.1540865052583592e-02,-9.8018777802977991e-03,-7.2328894891973583e-02,-2.9363994335853294e-01,1.7767004254864716e-03,-3.1813811705720024e-01,3.3389118519054167e-01,1.2943864866323410e-01,-3.2686915623149548e-01,1.1308529607352996e-01,1.0852079338998288e-01,-8.1762948819965431e-02,-1.1409155605664537e-01,2.0710802205303624e-01,2.9125006635791656e-01,-4.3111509548687033e-01,8.1758030583024721e-02,-3.9996502562786951e-01,3.9637769202649081e-03,6.5182374332823395e-02,5.9040545838358591e-02,6.7133389159574813e-02,3.4585369204603361e-01,2.8135444494988904e-01,-3.3593409690427539e-02,1.3075660869028705e-01,-2.6700134516945706e-01,1.1163304944356214e-01,1.8497784861360098e-02,9.8263108915057407e-02,-5.8870768276193097e-01,-3.3194363565281371e-01,-1.5563294114115514e-02,2.1586655920928021e-02,2.0369889716765485e-01,-1.1936720794815468e-01,1.9514225831247028e-01,-2.7079398423886586e-01,-2.2887779004979769e-01,-1.4174081166337502e-01,-2.5250404255284235e-02,-2.1510088934245519e-01,-4.2356976791272233e-02,1.7530663593435691e-01,1.2374141671682355e-01,-9.2738090624244623e-03,1.3431670619420188e-01,-8.3412271863368151e-02,6.0570453677671540e-02,3.6851775135514458e-01,1.2062953908242761e-01,3.9690294750086724e-01,3.8360040515579244e-02,-4.0059815338417254e-01,3.2220671787745364e-01,3.0775979507343162e-02,4.6736960525291810e-01,-1.8824803665000021e-02,-2.5103692485269080e-01,2.8772293595456661e-01,-7.1580691924138282e-02,-2.6054200260294963e-01,-1.8717610592738421e-01,-2.0925435343751513e-02,1.4284985286987126e-01,8.3026231374274215e-02,-4.5153258066288343e-01,-3.3681923509205575e-01,3.0914947893640979e-02,1.2929446353112436e-02,-1.1234395614551689e-02,1.1840671606724907e-02,1.9470841124965538e-01,-3.6077168666589679e-02,2.0328549669648996e-01,-9.8881964980310044e-02,9.0432894580536674e-02,-1.6850299113535966e-01,5.7951036326407035e-01,3.6806382029977693e-02,3.4185431623536083e-01,3.8832419402928325e-01,4.5500492709509788e-02,-1.4766744582667279e-01,1.5054904278697495e-01,-1.0991850280994434e-01,-3.5104932283086249e-01,-6.6820021484974484e-02,2.4835290303828536e-01,5.0176863374918401e-01,3.3276295105447412e-01,-9.5121876670366118e-02,5.1487912418812863e-02,1.7692087817552532e-01,-2.1176696380156967e-01,-7.6765684273911575e-02,1.2122796170098078e-01,-1.1284149087905867e-02,-1.0916768880695463e-01,-5.2972110123318844e-02,3.1900302151632637e-01,-3.3396775527003081e-01,1.3139365716119222e-01,3.4690681803725049e-01,2.7434768142438885e-02,3.3122200770556492e-01,-3.6945025818704180e-02,-3.9189950577884364e-01,6.3800912877975569e-02,-7.3815003655520711e-02,-1.6373635724685059e-01,2.0409543282418414e-02,3.8434651555931959e-01,-1.1767017442243760e-01,-1.2407986887532310e-01,-2.8418769824636109e-02,-2.1135378722261522e-01,7.6526749506765940e-02,-3.4034249483757129e-01,-3.6624781260636885e-01,-1.3456899478731599e-01,2.9552317275202467e-02,-1.8803389961469513e-01,9.1908761719795590e-02,-1.5044574878252698e-01,1.8292031135422160e-01,3.5118105938298749e-01,5.5361866635510189e-02,4.9311764647811640e-01,-3.5640211861110960e-01,3.5906853326594257e-01,-1.5561603324705700e-01,-7.7543673310346922e-02,5.7396815860468402e-02,1.3108340074257441e-01,8.4274979751480003e-02,2.4531305211992135e-03,-1.2741243264325966e-01,-2.1776832904032947e-01,1.2923127894724762e-01,8.8545773624312624e-02,-9.6078427230919125e-02,2.1574297657004821e-01,4.1378040739910284e-02,-5.7308206959045538e-03,-9.9974496273922769e-02,-1.5729812282836611e-01,1.9308998323944787e-01,1.9350774757949618e-01,-2.8830610865314499e-01,1.4898205202599057e-01,-1.5634577032801023e-02,2.1643215271994254e-02,3.4393695124861490e-01,-6.6667763236438193e-01,-1.1441120001943933e-01,-1.5678449476973860e-01,-2.4367073002032130e-01,2.0650400121323140e-01,1.9696370317962725e-01,2.2492710240532905e-02,-5.9290906842147162e-02,-3.9019400174977914e-01,-3.6800900918890447e-02,-1.5959461351757495e-01,9.5697369707635052e-02,-3.0563276560116689e-02,-5.4434834701453869e-02,3.1497173238180104e-02,-1.1623299572943965e-01,1.7772669958786785e-01,-4.4236555725153406e-02,-1.0265170972674080e-01,-9.3955984825145181e-02,-3.0558197342955457e-01,-2.9395140609462311e-01,2.4426280976211884e-01,6.7689161486823668e-01,2.7062469540929373e-03,1.0454666759445008e-02,-1.1963390388270165e-01,-1.5843370012747010e-01,-1.7665920539162222e-01,2.3725100300206389e-01,1.1419296685070884e-01,-4.8989129714349600e-01,-2.8042871761730176e-01,-2.0695727734327884e-01,2.7078721543303919e-01,1.6456273381458247e-02,1.0973127227857982e-02,2.9929663662551731e-01,-3.7575718528871471e-01,-6.7478367170692707e-02,1.2731239484792414e-01,-2.4838849948664099e-01,-2.6634251649744323e-01,-4.7946075604242959e-02,-1.9568066594645281e-01,-2.9104503421856648e-01,-1.7798124543802837e-01,2.1895368907932414e-01,3.1233185970693339e-01,-7.8591265368581201e-02,-4.1616249080504882e-02,-6.0896206412976703e-02,-3.3441944129995388e-01,-4.1477457091039110e-01,1.7938294600322605e-01,1.7237822903208910e-01,-4.4578663998573867e-02,-3.5962396504707450e-01,-1.6014301289052910e-03,3.9870945545064251e-01,6.5852241392513906e-03,-7.4250903761673454e-02,2.0320034654785279e-01,1.9811528220703781e-01,-6.5991290017888712e-02,-7.4016248712465066e-02,1.0407904147731674e-01,-2.2792346899714028e-01,-2.2690663287460708e-01,-3.1800169605213230e-01,1.9386182078053812e-01,3.8011821649535832e-01,-5.0010160851943730e-01,1.0339004564074455e-01,1.3472005815351520e-01,1.7284731617845267e-01,8.6288554914785764e-02,-6.5992279868498760e-02,-1.2526844390306688e-01,-1.7763575900091724e-01,-4.3520345710361868e-02,-5.8452743449607623e-02,2.7501215267302176e-01,-3.6324596663149045e-01,-1.2767876348294810e-01,2.2322736092185880e-01,3.0719595027903475e-03,-4.5965263592284318e-02,-4.6128952369015414e-01,-2.5554926462029420e-01,1.5674052060371027e-01,-1.4727999883427925e-01,2.0199591022580574e-01,-4.3786007571134641e-02,-9.1831211827672760e-02,1.5877837138685602e-01,-6.7901247866776190e-02,-1.1513394007263472e-01,2.2802381858986920e-01,5.2971893018656313e-01,-4.6897184636255182e-02,2.1874218974679900e-02,-1.2155231237466942e-01,-1.0172574691453140e-01,-4.1117809743255745e-01,-3.1427807653471074e-01,1.6883642343258004e-01,-3.6068105404979239e-01,-1.0813308660042709e-01,2.5257491578580726e-01,-1.4041247043658880e-01,3.3336916668598476e-02,-1.5559834282957586e-02,8.3793972317304954e-02,-4.9351268383377100e-01,7.6524198801354582e-02,8.6397002476319845e-02,-3.4732035101628134e-01,-4.2470569231156052e-01,2.2057312416128472e-01,1.9059061865889765e-02,3.2571383117839553e-02,-1.6179602911104324e-01,1.1650720762773618e-02,6.9162646328376945e-02,-3.1537118692720301e-02,-3.4478726479697419e-01,2.3909606237372580e-02,-1.6634790768824237e-01,2.8230733350904619e-01,4.0372288769518254e-02,2.9937929166454746e-01,-5.2227991101370691e-02,1.1280895000331458e-01,1.8127105814996475e-01,5.8135052954656530e-01,1.9340017727194500e-01,1.3233369587650445e-01,1.5480523084463443e-01,9.5755392129497227e-02,-1.0548636137498724e-01,1.2219260816423759e-01,-3.1064208787311293e-01,1.1860388347621700e-01,2.6452580760794592e-01,-5.9140434410438980e-01,4.8200387107171706e-02,-1.1481320716626148e-01,-1.5064025915859292e-01,-2.5234363467343912e-01,4.3792139254413071e-01,-1.1002815121170539e-01,1.1024177425521857e-01,1.2063707795579448e-01,9.6493449618325289e-02,-9.8700610358840549e-02,-3.4342063813286927e-01,6.3428551451710211e-02,1.2438165513839314e-01,-3.5782209653413277e-02,-1.1390557525077312e-01,-9.8494249112870066e-02,-1.3158560945183709e-01,2.3239358007121913e-01,2.5693547856554910e-01,2.3086126040165195e-01,1.5582796745646202e-01,-3.6048833510935002e-01,-5.3419837943381863e-02,4.4903326695447388e-02,-1.1846393413233905e-01,-4.2156681079164159e-03,3.2162754211812528e-01,-2.1132732992260519e-01,3.9441457172879835e-01,1.9381930208762407e-01,-3.1905795485086480e-01,-1.1010247894628337e-01,-1.4464328602700133e-01,1.2217609913656348e-01,1.1387094593141819e-01,-3.7719176128468680e-02,2.6328809748567245e-01,-1.3724084216046289e-01,4.2426514583582886e-01,2.2175184429462358e-01,-4.9231123636812013e-01,-4.2815381205130831e-01,2.3833378678539582e-01,-3.7966852604797224e-01,2.1310892477374815e-02,2.4288217292626188e-02,5.0338268334417340e-02,-5.5334258779378066e-02,1.3941127336333604e-02,-9.6208196994275672e-02,2.4157479748860469e-02,-3.3930258329380414e-01,-3.6349903672825354e-02,-2.3251160080328806e-01,2.5448433223444686e-02,4.7892104971962127e-02,-3.4942282055865126e-01,1.0551173971634455e-01,-2.8905576576922706e-02,-1.6577169405652706e-01,4.1360560575866203e-03,-1.0901210160423960e-01,-1.9498682692544630e-01,7.2644686788154736e-02,-4.1637683671627918e-01,-4.8339336422295204e-01,-1.4505779067245536e-01,1.3646461238040969e-01,4.7257447807438631e-02,1.5608807747328837e-01,2.0427500671959965e-02,-3.0278276865679526e-01,4.7037235360527707e-01,-3.1602339264673779e-01,-8.3969541896394218e-02,2.4812121666028617e-02,8.2044911694048914e-02,-1.2523339484893919e-01,2.6926665578605218e-02,2.3285265540648084e-01,1.5637505397749207e-01,3.9194055574176362e-01,-2.2243850611535110e-01,1.4201026467629821e-01,3.7228725228122081e-02,1.4488916400580054e-01,-2.4734477700537158e-01,1.6153499933244986e-01,1.7963563944113306e-01,-1.8887992790789632e-01,-3.5157388958431329e-01,-4.6397618713035632e-01,-6.8661783248432431e-02,-6.4167204803230335e-02,1.7060086505105096e-01,-2.5058252573239292e-02,-3.6296618892020638e-01,2.9574797264828014e-02,1.0200578589215004e-01,-3.5059887975636347e-02,-1.5158084411203121e-01,2.1671867110788035e-01,-3.1619731196727652e-01,1.0698302685711637e-02,1.1824178528705821e-01,-5.3492390328382785e-03,5.7199737717385526e-02,-6.2004458418169572e-01,-2.0508939376206814e-01,-1.3758314703017313e-01,5.4665774842654780e-02,-7.2482591688813824e-02,-7.9502585474851339e-02,-2.1864452096283973e-01,-3.2132842271572665e-01,2.6157523959383860e-01,-1.9173344663712014e-02,-2.6722388191447216e-01,2.4532900637826216e-01,-2.2451914968141902e-03,-1.9333527690754870e-01,1.2144442980136021e-02,6.1013495201831025e-02,2.2013492987195010e-01,6.7391670575316878e-02,-5.6524010408436097e-02,8.6664149175070274e-02,2.3087686632691551e-01,1.0361583010020278e-01,1.1567052525628174e-01,-4.1428108566365407e-01,-5.9977110993011659e-02,-2.8638457083418889e-01,-1.2278020733550693e-01,-3.9932700411680999e-01,4.2672285320857795e-01,2.3373575734674401e-01,8.3261933013846712e-02,-3.7707163459651372e-01,-1.7350581373384907e-01,-2.0797509642065728e-01,1.1441849076755600e-01,-6.7829650250084028e-02,-2.0823869418338767e-01,-5.8862411729721376e-01,2.3897280457199316e-01,4.6217569916536208e-02,-3.2326298240855283e-02,-8.7769123362486642e-02,2.6230750424907232e-02,-4.0921829701522844e-01,2.5137853646460906e-01,-1.0371927425627225e-01,2.6825429063314470e-02,-1.4684153351689228e-01,-3.3695261659881726e-01,-1.8001276814208000e-01,-1.8294372888388297e-01,-8.5596887196520213e-02,-2.9381188363657412e-02,2.9314263856882533e-01,2.5412521942954419e-01,1.9479342798036775e-01,-1.0645202637811335e-01,1.3274843770829628e-01,-6.1462096689941646e-02,3.7283558297670205e-01,-2.9504517762092380e-02,7.2594731158108397e-02,4.2688538521947395e-01,1.9015226736065305e-01,-2.3546334922731968e-01,-1.8590938842054494e-01,-2.9017381189697183e-01,-2.2336161651741401e-01,-3.6297348870729268e-01,-1.6972614458908816e-01,-7.8444131986911220e-02,-1.5364120298306561e-01,3.9218979218256358e-02,-4.2962626545501004e-01,-1.8521285003773209e-02,-9.3395642752055735e-03,3.9648472641745985e-01,2.9866485093502876e-01,7.4644426434763447e-02,1.1402658071869029e-01,9.5990585125562577e-02,-2.0120880490020948e-01,-1.0085282263861012e-01,-9.4182199003705100e-02,-1.8109404150621444e-01,1.5716590180581638e-01,-1.3421636940538752e-02,2.8896868697574803e-02,-5.4317003755061610e-01,2.8696154227363219e-01,-2.0930720948777398e-01,-5.9979098586143420e-03,-3.8832433559911433e-01,-1.2029809426969188e-02,1.3448801609212378e-02,-4.9107088511221392e-01,1.8065519676345149e-01,-2.1233560182370628e-01,-2.5629051407580217e-01,-5.7195928361245832e-02,1.8490112353246109e-02,2.9043886138078256e-01,-5.1951943578238111e-02,-5.6770659952196781e-02,2.6001808460082693e-01,2.2359859979690036e-01,1.7497123294388114e-01,-3.8108098364935955e-01,-8.0061871462930270e-02,1.5804057579340772e-01,-2.1297288075457324e-01,1.5588769015259322e-02,-2.0406336929916807e-01,1.0511798977389158e-01,-7.9942891643549202e-03,1.3892843730982005e-01,-1.3779972592088224e-01,3.6973853504664156e-01,-1.5057933450956654e-01,2.5539963368995117e-01,1.3918203283915634e-01,3.2073980415048020e-01,-2.4641605416115775e-01,-2.6957787761263052e-01,3.3608703441366072e-02,2.3075494835549046e-01,-4.8752841109579370e-01,-1.4478119886075703e-02,3.0006386630829518e-01,9.2900406009658265e-02,1.0677130723870248e-01,-1.6237680993317155e-01,-2.9747137442106297e-01,-1.0810429459600282e-01,4.8877606250272682e-01,4.0670230352610348e-01,1.3541650708885702e-01,-4.7737754923096137e-01,1.7536848235792404e-01,9.6663416440160924e-02,-9.5164750289283673e-02,2.7047376021293273e-01,-9.3886728453401180e-02,-4.2068284288737760e-03,1.2246868455805797e-01,7.6342314028779376e-02,6.2984737694080792e-02,2.3424191038265488e-01,2.4595069184956277e-02,-9.6566174087071424e-02,1.6429770735160062e-01,3.9484263603243017e-02,2.6037270927140171e-01,-3.6406099196837216e-01,-1.0327605497772074e-01,2.2423355936298783e-01,1.9796842017132485e-01,9.8829952173126456e-02,1.8184661483707718e-02,-1.4960505034562097e-01,2.1777404714053217e-01,4.3683529092479939e-01,4.1536612865279224e-02,2.6358518232735839e-01,-6.5518723422106961e-02,-4.9303477766426379e-02,1.2294575073704750e-01,6.1352740983343652e-02,1.1589897416170275e-01,5.4656025625401949e-01,-1.3677923427632827e-01,-3.3498701178799287e-02,-1.7286069609106272e-01,1.6480918632771221e-02,-1.7296861805500496e-01,-1.9482219532091116e-02,5.2733676126236573e-01,1.6425261268482727e-01,1.9259631362663868e-01,1.1741297537513669e-01,-3.9765885805127332e-01,4.0557570155388148e-02,-7.8765053425966666e-02,1.9008875942184214e-01,7.5330582830252291e-02,-2.4748003367932403e-01,-4.1485735930216050e-01,3.1568593269326983e-02,-3.6515289030339498e-01,5.5752716144413003e-02,-3.3278413223716247e-02,-6.2576817949499763e-02,4.8549899148300789e-02,-1.5009714898263316e-01,3.3067749015574893e-01,-3.3537561863330290e-01,1.0639204142307050e-01,1.2723626558691806e-01,2.1838800433288968e-01,2.7673348740228015e-01,9.1521748082654869e-02,-2.9452209334836232e-01,-3.9852482227594486e-02,1.9301348662710568e-01,-1.2325410780920835e-01,4.6635227812100694e-01,4.0270309061403789e-02,2.6167764812614097e-01,-4.8286168251400717e-02,1.4690238774130193e-01,-9.0528761984077860e-02,-3.6423085208071160e-01,-1.7082628010536344e-01,-4.3663655303441457e-01,1.0291897696347635e-01,2.4133825590636668e-01,-9.7158466315387132e-02,6.0531494866769356e-02,-1.3821818061339541e-01,2.4108419805351572e-01,3.4501734221921310e-01,-3.1157865545160929e-01,-1.9929747021190165e-02,-7.9802178265351853e-02,1.3163521815408272e-01,-1.0669125673647407e-01,-1.6742739052320052e-01,-1.0193049406148440e-01,-2.8847250229991422e-01,-1.1402527856752259e-02,-4.0964129248538961e-01,2.8254546136000425e-01,3.2368355856051169e-02,-2.3562427035113381e-01,-2.0036933169966073e-01,-2.8094412757851644e-01,1.9146195196886437e-01,-1.2755682947528069e-01,2.4073938267120301e-01,8.2705402131886582e-02,4.6324301382110222e-01,1.5112617920712149e-01,-1.9816060465041241e-01,5.5991527388184283e-02,-2.7861921339581686e-01,2.1597603405152120e-02,-1.1518847084177301e-01,-8.9054903379406358e-02,-3.8062378567698674e-02,-3.1670100072499741e-01,3.9290599146238087e-01,2.6716737459677414e-01,-4.8727320389045059e-01,-2.0965326343170942e-01,-1.0710055235576209e-01,1.3022704073820521e-01,1.0800680746049245e-01,2.2360347478333481e-01,-2.8940193267478556e-02,1.3277959225656635e-01,-2.5588114592986860e-01,-9.6366304868975378e-02,1.3736298395821958e-01,4.8905489405931202e-02,-5.3316921803095707e-01,1.2083773152288813e-03,3.0809165086921081e-01,-1.5339739143841896e-01,3.1983472220279879e-01,-6.4238696343290061e-02,-2.4239223872709541e-02,6.5546338277230221e-02,2.0045249996875231e-01,2.2141049059423767e-01,1.5678568443246838e-01,1.1964823907563936e-01,3.9879281896868518e-01,-6.9844354004240369e-02,-6.9012009838345190e-01,1.3936991781416236e-01,7.0725751074997262e-02,-1.2557135975490036e-01,8.5043902542500174e-02,2.8891918158349567e-01,-1.2530593354193822e-01,1.4139920245881074e-01,-1.0026466295643899e-01,9.8311257934977844e-03,4.3112008698241472e-02,-5.5003463278757825e-02,1.4507369824296820e-01,1.7041901631807044e-01,1.0286618163136195e-01,-1.4462486773070221e-01,1.1173906331684855e-01,-2.7442537138357415e-01,-7.5712816242123962e-02,-4.3923096837541320e-01,-1.7606840838698057e-01,1.1857686490768118e-01,-1.1941141066835340e-01,2.9592975577270475e-02,6.1201466146167421e-02,-3.0598168130045766e-01,-4.4081383992361189e-01,-3.6029414464627008e-01,-3.1022851702883208e-01,1.0102305807896637e-01,9.0792180087291466e-02,2.1243062184222364e-01,-1.2911444756014676e-01,-1.5449463219338330e-01,-1.2582812117637390e-01,-3.3222900551469453e-02,9.0167369462563429e-02,1.0809826975895236e-01,4.1809174067701338e-01,1.3933361212578782e-01,-4.9349212192484532e-02,-3.7381631913596247e-01,2.9797939050277056e-01,-1.7762459044767925e-01,2.2502622535987923e-01,-5.2414423529295395e-01,-1.2508610798818681e-02,-6.1443755000869363e-02,7.2161264796264155e-02,2.3335999089457590e-02,-1.3702847371464683e-01,3.0685695332433302e-02,2.2023161401587493e-01,-3.2132444445487324e-01,9.1095801476125435e-02,-3.9315032969558850e-01,4.2287616701225827e-01,-2.9158747174465166e-01,-9.7733819250775705e-02,3.5095794823934917e-01,-7.9410465413180642e-02,-1.1124336736736397e-01,-2.3873475668714855e-01,1.4176291066685048e-01,3.5044940353241705e-01,1.6444919526077614e-02,2.0598247644744466e-01,-1.0840035542756007e-01,-1.3394252820136093e-01,-6.0489776294102710e-03,8.8591041835829609e-02,-1.0408791377053733e-01,2.7557339148296617e-01,2.3436335317802892e-01,-1.7531581150441808e-01,-2.1089106145094280e-01,9.3094078186993084e-03,-9.4289434699672010e-04,-1.5766902126868493e-01,-7.8983573126689077e-02,-1.5163753595395879e-01,-3.0496460425833044e-01,-9.3560581837305284e-02,-3.9132275913290060e-01,-5.1135587681286121e-01,2.0293232099073158e-01,7.3639373752125079e-02,-8.8548450915269139e-02,-6.2596655129203607e-02,-9.1955307991785501e-02,6.4088018137050895e-02,3.3950862809234272e-01,4.0675109771219564e-01,-5.0946124312885074e-02,-2.7409352865529385e-01,-3.3787416282279575e-02,-5.7569139198078191e-02,-5.4932875010498462e-02,-2.6585423813785258e-01,5.4301494124391975e-02,-2.7767297064650298e-01,7.2374727791057747e-02,2.3074325150309813e-01,2.0875919387093286e-01,1.0883358980027860e-01,3.7304201057330966e-01,1.1797952835758603e-02,-3.3012048270065480e-01,1.0889853776197872e-01,2.0481896307915504e-01,-2.2546270126013482e-01,-2.4484528763994937e-01,9.7223022625664304e-02,-4.8004217291085116e-01,-1.7397557491736770e-01,2.0440539615261766e-01,-6.5315208050167606e-03,-2.2915080701503485e-01,2.0534447922979679e-01,5.8487901109144029e-02,7.7965381239276599e-02,1.7933265191813916e-01,2.3676917297162670e-01,-1.5929284615517303e-01,-3.3518042719133778e-02,6.6355860998585925e-03,3.0651045418863743e-01,-4.1382048239768066e-01,1.3455721514950206e-01,3.6840412810121509e-01,4.7623118509847079e-01,1.3043444914381444e-01,-5.8764286396376111e-02,2.0660354069716824e-01,2.6675293412654087e-02,2.7492657275783838e-01,4.6833975131645339e-01,5.0652355929427413e-02,3.0818179355840747e-02,5.5967930841778681e-02,2.5827309913389124e-01,-7.4657048067688608e-02,2.1198680554018481e-01,-1.8890078011559053e-02,-1.2838947109014041e-02,2.5203897082683802e-01,-1.2032578962656655e-01,-2.8218117573751833e-01,-1.2563703111616334e-01,-5.8677147666863771e-01,1.5120334427627594e-01,-2.0132024926359023e-02,-1.2276151522496682e-01,-1.5467185890852661e-01,3.3140974806433915e-01,-1.3720652193578436e-01,2.3971737462065108e-02,4.8602684775043842e-02,1.0194152334624017e-01,7.6984011513912570e-02,-7.1290275577192280e-02,5.4132451983460117e-01,-1.3758260223447169e-01,3.0107798815956415e-02,-2.5259328469553166e-01,-2.3657996891715291e-01,1.6917349332237105e-01,-2.2305630954353375e-01,4.0807504622792640e-01,-2.8216642993261876e-01,-6.2054770965511583e-02,-6.8246752527531609e-03,2.1286452051961327e-01,-2.0158727896086143e-01,-7.6466057270798554e-02,3.0850849055087992e-01,2.9493801185313412e-01,-8.6749540330800623e-02,-1.1693176293704741e-01,2.9146159589534260e-01,-3.5707452276848822e-02,-3.1739335779004896e-02,3.0313597256445612e-02,1.7962361915132030e-01,-2.6615513243829142e-01,-1.2214562441341192e-01,-3.3845965926406624e-01,-1.1034570390340642e-01,2.3278691437424501e-01,1.9208344423947954e-01,-4.3927744512632005e-01,2.3643234005172989e-01,3.1527962169822989e-02,3.4196303352417029e-01,-1.5479503982112613e-01,1.7046164074356498e-01,-1.1975088368163689e-01,5.0558667637265471e-02,-1.7843653591045366e-01,-1.4298566436252080e-01,1.5042605012928750e-01,3.3346897967035999e-01,1.0149096024940410e-01,-8.5369156130555110e-02,5.1577619013145748e-01,4.9305283465698652e-02,4.5939154387644399e-02,5.4398944848582327e-02,-5.3330655679281434e-02,-1.6366044739570429e-01,-1.6954324361196454e-01,4.6966591533368052e-01,4.0445184239286897e-01,1.0156570164747085e-01}},{30u,{2.5438705632519525e-02,2.7287094150185546e-02,-4.7038238940790469e-02,-2.4751069101728393e-01,-1.7056487722548361e-01,-8.0401259532007122e-02,3.9478573492190659e-02,-1.2656493542008043e-01,-4.2466308473986407e-02,-1.1278891424563085e-01,1.2405398709437007e-01,1.0908225188801483e-01,-5.8373656904485434e-02,1.7230983220281901e-01,-2.9596808085825856e-02,3.8093077998003300e-01,3.8227239354952353e-01,4.2528872056104484e-02,-1.0006848013323018e-01,-4.0959486081868934e-01,7.8984169717092878e-03,-1.5047233496776255e-01,2.3640482553159053e-01,2.0734603245839842e-01,2.3388742032467544e-01,2.0847497516901461e-01,1.7399503313177936e-01,-1.8180985662622642e-01,1.3073611608462107e-01,1.8764883655918083e-01,5.0716972296503751e-03,1.2483927088887828e-01,-1.3948869540864658e-01,-5.7376432235862203e-02,3.2112395322131199e-01,-3.7708904103525631e-01,3.4636142833422139e-02,-3.2731280707738009e-01,-1.5239983566718449e-02,-5.0118177313729993e-02,9.0009015198084630e-02,8.9448384363837202e-02,-2.3440159494502413e-01,1.6342785648493785e-01,-1.6749609738087382e-02,-2.4369238661326748e-01,2.0447729747970825e-02,-3.4040767515120911e-02,-1.1830503316649560e-01,-3.4377781168073429e-01,1.4530206032634282e-01,1.7586199995526464e-01,-1.3209234092236261e-02,3.7527939982076028e-02,-3.8985730492926723e-01,-1.9585787435653773e-01,-4.6479051685935621e-02,-1.0685142809467760e-01,5.0117905773414288e-02,-2.3239344547385093e-01,-9.6345770230801903e-02,4.5812859957860497e-01,-8.3470312944776803e-02,1.0235049976622076e-01,-9.3430460258337039e-03,1.1448464366255212e-01,3.1838475159333253e-02,-1.6271576654078562e-01,2.1928391309860618e-01,1.0234583926485455e-01,3.8798020560339645e-02,5.2095162063492628e-02,2.5960425372569979e-01,1.1743372466160930e-01,-4.5172702798474185e-02,-1.8195431727667544e-01,-2.2159043973879328e-02,-1.6364679953756064e-01,-2.7233273587945958e-03,1.4740636506752247e-01,1.0390522727913586e-01,-4.5152613128072427e-01,1.0798293246644432e-01,2.9110242761503052e-01,9.0729433330921247e-02,3.9691978174271121e-02,1.0488188597677917e-04,-2.2454536084680871e-01,-2.4770059979799836e-01,-2.4886221247044299e-01,-3.3353394352954585e-01,3.6078695879534634e-02,4.7655459327745703e-01,9.9094723880598479e-02,9.6405479225274190e-02,8.6977688076688750e-02,1.7201947905512940e-01,-1.0146887449707850e-01,1.6873823973435886e-01,3.0090299168577909e-03,9.6162204798648440e-02,2.3262064879888505e-01,-3.8867620569799954e-01,-5.5360301265719836e-02,-4.2458578391001006e-02,3.0856767744416785e-01,-8.0577157869796953e-02,2.0466327011329909e-02,1.9247279873025339e-02,9.4779279415899923e-03,2.6086017852098242e-01,-6.8955811329381098e-02,-3.4860519541703205e-01,-3.6058519548434760e-02,1.1970311242030683e-03,7.6628729516894159e-02,-7.4379414331329052e-02,-9.0367155105399791e-02,-1.5815646818528384e-01,5.6619644975860958e-02,1.2872487917389411e-01,1.2051246029747147e-01,3.4105878602944567e-01,2.4290067238220053e-01,2.1063881215282337e-01,-3.3205724516279023e-01,2.1753578121803560e-01,1.0024236456489111e-01,-1.7378734728155118e-01,-3.6957981543362106e-02,-2.5674313849963970e-01,-1.2803301610868281e-01,-1.2475672408492787e-02,-9.3436126758183302e-02,-2.4190857559237972e-02,-6.7038849262885752e-02,-1.3506476717143405e-02,4.6848270327996079e-02,7.8063449372982999e-02,5.6172908455195084e-02,-3.9188930267176764e-02,-9.6633411443511952e-02,2.3847639041324575e-01,7.8776092875008377e-02,-2.6305974732178751e-02,-1.7354794496855130e-01,4.2071933633690051e-01,-1.6449441424389979e-01,-1.4620223118535239e-01,3.3453680499417904e-01,-9.5265211112953552e-02,-8.1334410106385244e-02,1.2113232055966440e-02,1.3392603260059438e-01,1.8372272890742969e-01,2.5977463781011934e-01,-2.7703680205198963e-02,-2.4652625869113262e-01,-9.8741846240625375e-02,1.1757730316088905e-01,-5.8045180230315102e-02,1.4514893871838483e-01,1.1838063922941799e-01,4.5266735017456677e-02,-1.2272315926156722e-01,-6.3044259260671880e-03,2.6389171801447575e-01,-2.1760085565123502e-01,-4.9071111551776048e-01,8.7029798869389538e-02,-2.7520065019781609e-01,-7.8571659066792240e-02,-1.7660614059599397e-01,-3.2945661897844913e-01,9.9486698944450808e-03,-1.3858173950094149e-01,3.2150061245011979e-01,-4.2127033506160871e-02,1.1255795040743637e-01,1.2640921446957549e-02,1.5036170309686364e-01,-3.8387770151311257e-02,1.7923631939152235e-01,-1.4036883632399658e-01,5.3772487940437014e-02,2.0373921318548166e-01,1.5482437847095729e-01,-2.7631820469565412e-02,9.7450943115823030e-02,7.5096190002114066e-02,9.7678050218688139e-02,-4.4903783748242505e-02,-3.0115465800962304e-01,-5.2862774176614877e-03,-4.2617355097094267e-01,-9.9435936752057585e-02,-3.2207253317974871e-01,-1.4679226791828304e-01,-2.0269895397334689e-01,8.1791696687507520e-02,-1.2451072757453356e-01,1.9969452487162628e-01,3.7660768454476601e-01,1.9023317296746631e-01,5.6769054042641091e-02,2.4635869141710670e-01,1.4452207298464897e-01,1.3478093830695126e-01,9.2618189470469056e-02,-1.6739835581509738e-01,-1.1666239692355343e-02,-7.7823864326421924e-02,-5.9515770965087665e-02,-1.0072654713559340e-01,-1.2487008254308135e-01,-1.9196367609670767e-01,3.5045248886244396e-01,3.8215438412534074e-02,-3.5199359726964968e-01,-2.6952181873705003e-02,-6.7424289751642427e-02,3.6255347556913958e-01,1.4973664799701979e-02,2.8554447089296214e-01,-7.8488809774724631e-03,-8.9205156699961777e-02,-2.6782089738559806e-01,-6.2409790453147942e-02,-9.1737287084539154e-02,2.1882596358797624e-02,-1.3225217458113608e-01,-1.6971392875850161e-01,-2.4847275656501880e-01,2.3773394147971713e-01,2.5731453337537974e-01,-1.9309609774592640e-01,-8.5937027826380200e-02,3.0376872940532362e-01,-2.2912555047441968e-05,2.7906287304280589e-02,-2.1576026299378818e-02,-2.4872320487437277e-01,-2.7403023558532719e-02,1.1921768492978979e-01,-2.5153985930070166e-01,-1.8875468731285532e-02,4.7386806059998227e-03,-2.7747511280629100e-01,-7.7398937143205476e-02,8.3496363793312406e-02,1.6215669929960694e-01,-8.3747923028068230e-02,-1.8817667416922901e-01,-3.3216622394433598e-01,-1.3584832022499865e-01,-1.0986026445632946e-01,3.3280424181400003e-01,-2.0019273869928567e-01,-1.3133115235720491e-02,1.5252709300914613e-01,2.2894135172777724e-01,-1.5105996828592341e-01,1.9437418472330839e-01,1.9274100710970790e-01,-4.3941105033450160e-02,-3.2041380771618150e-01,-1.8951341107654371e-01,2.4845692749290715e-01,-6.9717173289795986e-02,1.6728829683530066e-01,-1.0235396014780400e-02,2.6749477222620770e-02,-4.7171157784657664e-02,8.3374995144997521e-02,-3.2395405001433558e-01,6.8316019645419890e-02,1.5513176665530140e-01,-3.6597858522883464e-01,-3.2885090674890094e-03,1.6438925758541667e-01,-5.4317504305850051e-01,-1.4809564999280314e-01,-8.7898767320018112e-02,2.9996749291796770e-02,-2.3162812153103632e-01,-1.1732566018010530e-01,-5.0931602236226746e-02,2.0957845164310360e-01,9.5247635160461003e-03,-1.5836506901420430e-01,-1.6305137460518254e-01,8.4217220408184593e-02,-6.5165958952428604e-02,-8.5957408296588961e-02,3.0162518990907768e-02,9.9631865750559337e-02,-3.0386637741392286e-01,-2.5283100317962232e-01,-4.4397543334701049e-02,1.2754627408147837e-01,8.5354885882163389e-02,2.3668615740676824e-01,1.1472254029801202e-01,6.0666865436385629e-02,-3.1886963087821985e-01,-6.2957069251515466e-02,-1.9552887245322448e-02,3.5775699583217493e-03,3.2090219370397904e-01,1.1700290434336541e-01,-6.7860674800656218e-02,2.1755155972122850e-01,-2.0659411518229437e-01,4.2516752137385178e-01,1.8008044700659509e-01,-8.6034874414071691e-02,1.4850835346214733e-01,1.6556422191401809e-01,1.2483831479851114e-02,2.5037097216632337e-01,2.9994545082511207e-02,-1.3242849829734112e-02,1.9919568942169538e-01,-2.3176402676457752e-01,-1.7504460262110774e-01,-5.5976940972133127e-02,1.0019120755086969e-01,2.8793016977863295e-01,1.9729061581569673e-01,9.7564531962055084e-02,-7.3182559988297230e-02,1.9549778297698175e-01,-3.1620216804924206e-01,1.1361258730263749e-01,4.3712493807140547e-02,1.4970940081696543e-01,-9.8442563294618701e-02,4.2603554838006645e-02,-2.6133830515540718e-01,5.1809814682738531e-01,-8.6719579572728828e-02,6.3872204833095775e-02,-2.0293720714682228e-01,-1.1696473037056242e-01,2.4781319583816955e-01,2.1890623080052414e-02,-5.1708444141061828e-02,1.3999051112796176e-01,-1.4110903484420190e-01,-9.6557891241509944e-02,2.6147059858462685e-01,2.0335133378171019e-01,-6.8891971461223656e-03,1.4641367394499602e-01,8.8025838723213345e-02,1.4604331933208806e-01,2.5309790030745227e-01,1.6132633740249758e-01,-1.8463127220723830e-01,8.1642102730756574e-02,-2.2524018816827518e-01,-4.7007847937688058e-02,-1.6541310269795254e-01,1.4908073651113955e-02,-3.0867582845090785e-01,-2.1735120226928853e-01,-6.0045165712484146e-02,-2.4354927055682091e-01,2.7517293520574040e-02,1.5605152852200509e-03,6.6906767136261258e-02,-2.4569598363156042e-01,1.5621799699881994e-01,1.8208030423505650e-01,-1.6678212490987535e-01,3.6640625086692497e-01,-2.3247705258125112e-01,-1.2663180839232910e-01,1.0234304009318415e-01,2.4555745542835455e-01,5.8326044388249149e-02,2.5652986494050978e-01,-1.5323643361610684e-01,1.2141589487937064e-01,-1.5333621207408449e-01,-1.0149015499157095e-01,3.7995456413022510e-01,-4.2569256516166387e-02,-9.3611715433737676e-03,-2.0871941576291353e-02,-5.4351878490330276e-02,-1.6802049690305298e-02,-2.0459229429908232e-01,1.6860267065946058e-01,-5.7278642336244578e-02,6.9526513628064959e-02,2.5534227001899190e-01,4.4566501108988987e-01,-5.2471220161677476e-02,-9.2710297442996373e-02,-3.5061344264753541e-01,7.6355282036158614e-02,-6.5122273092573721e-02,4.6249541529770136e-02,-3.3650915803352383e-01,1.0368826122844621e-01,2.7824708604864984e-01,-1.8610451558443286e-01,1.0224508285796728e-01,-3.9490358415327026e-02,3.4354615149995699e-01,2.8729388188468034e-02,4.2571594436028688e-03,-7.0505786149958366e-02,-6.8403125619177857e-02,-3.0675464703604913e-02,6.6201055602950240e-02,-2.4667264215534373e-02,1.2716014724751284e-01,-3.3072627261746707e-01,2.7853502566122951e-01,-1.0660426901168234e-01,1.5466420610741125e-01,-1.2543169114208882e-01,-2.0540198629034642e-01,9.0504362327504057e-02,3.6937774137097201e-02,-1.5494610815909224e-01,-2.9129028707713689e-01,-2.0819050737809430e-01,-3.2326406221135195e-02,-3.1657479038191783e-01,-1.8022369615655004e-01,3.4373119028694249e-02,1.9867644033457119e-01,-7.8542236983804178e-02,5.2826738461268834e-02,1.9070921806150562e-01,-8.5658411837892690e-02,6.3904820125073702e-02,1.4859636534829793e-01,-2.9273389471553279e-01,-1.9133749442736289e-01,-7.9153614782606657e-02,-9.7181209003855129e-02,1.6910879431879469e-01,2.4591827588852511e-01,5.3488134743014337e-02,-1.4218180193606855e-01,-4.0504209250325168e-01,1.1518670796785615e-03,1.1215098765255907e-01,1.7905004080165454e-01,-5.2649762035088921e-02,5.3808957040529529e-02,-2.7548872222975801e-01,-6.7739053497735541e-02,-4.8184322987409337e-02,-1.8354053080509433e-01,-5.4417778918828132e-02,-2.7103550065986676e-01,4.3504964740764152e-02,1.1630536292325691e-01,-1.3722605913696131e-02,2.0253538442656410e-01,3.1095388762758092e-01,1.4010335574757254e-01,-2.1273643901815611e-01,-3.4014782837038954e-01,3.0473828361998490e-01,-4.2327312576756326e-03,2.2196828260280554e-01,2.0770127886489842e-01,3.9151129614476393e-02,-4.0274216240609631e-02,2.1669547328910657e-01,-3.5769730880487594e-01,5.5311381489783706e-02,-1.6914693584442617e-01,-1.6688964859453176e-01,2.7169742256709067e-01,1.2075782296055679e-01,1.0202890590247693e-01,-5.2312815557682281e-02,-1.2376485937817711e-01,1.8249584750860870e-01,-2.7935051777777675e-01,-9.7977593461147566e-02,-2.4045505698602135e-01,3.7466225578444631e-02,-1.6574206178821776e-01,3.5500106938148884e-01,-9.8680802399940620e-02,-1.9205898512478212e-01,1.0248217725030918e-01,9.7172368628746592e-02,-1.4725840325578565e-01,-3.1877091782171219e-01,2.9331587317947044e-01,2.1434646509860378e-02,-7.1069013485495935e-02,-7.5880879353758202e-02,-6.2657262706723560e-02,1.6718096272678787e-01,-2.7814615635251516e-01,-2.2043424123551474e-02,4.0828292655801894e-02,-2.0774999103948608e-01,3.2804185230748267e-01,1.1713650141782009e-02,-3.6490640350113918e-01,1.7246224255818443e-01,3.9478910792634442e-01,-1.2511690734586867e-01,-1.4668085376075612e-01,3.7853577637493273e-02,-6.4330043401990736e-02,1.5096207186993077e-01,2.9715967585827723e-02,9.5283990211351449e-02,-1.0675309277361084e-01,-2.3252584643565855e-01,8.1722506690154989e-02,-9.4596895440718726e-02,1.1653240496802100e-01,-1.9052113482276067e-01,2.1388418934732920e-01,4.6014540608932480e-02,-7.6254001257077542e-02,-1.7423544467904950e-01,-1.5332487862432662e-01,1.7023361057570915e-01,-1.5094313858076941e-01,3.7789151891249007e-01,2.9954834281924945e-02,-1.8526079330830289e-01,6.0045116326423773e-02,1.0230999480943184e-01,2.9011654074365578e-01,-1.9801524705360493e-01,-3.3383371458300087e-02,1.4921585049625880e-01,-1.0309616139674338e-01,3.3525302998730305e-01,-1.4458975315030914e-01,-1.0323228766172732e-01,1.7421931593385762e-01,-1.1443889031877075e-01,2.8275412888656822e-02,-3.1401192535319533e-01,1.3405534386788465e-01,-2.9707269824180066e-02,-1.5728972900066648e-01,-1.0394770075948608e-01,2.5364744009950746e-01,-2.8392018277817821e-01,8.7831087362921056e-02,-3.7870479262799406e-01,1.1531860233280648e-01,5.4423693405256102e-03,-9.0726357624848167e-02,2.5751051865865254e-01,-1.3164954885873015e-01,-7.2961361362081603e-02,2.9763137120278588e-01,3.3046138457541141e-01,8.9047480515150518e-02,-1.8103711980143530e-02,9.8640814041950922e-02,4.9009416354971053e-02,-7.2376790831368137e-02,-4.3319457887042384e-01,1.8965255793958730e-01,4.5994635464747297e-01,-9.0798893479324211e-02,8.2681537757733403e-02,-2.8822308558593623e-01,-8.0103655826236922e-02,4.5470986272253752e-03,-1.0342578466096722e-01,-5.9496544809422854e-02,2.9420155339976500e-01,1.2769438586988294e-01,2.0688407171533285e-01,6.6065638840074520e-02,-6.9201583357255625e-02,-3.7876700912468177e-02,1.0019313704946008e-01,8.3018235097074872e-02,-2.3101031455385188e-01,-2.6952294318116413e-02,1.3507743388258514e-01,2.2567412412431734e-01,1.5483641416511404e-01,5.1487777944185492e-02,5.4400906653465485e-03,8.5520879961889132e-02,7.6836265706562573e-03,-2.3220026227927787e-01,-2.3741558119167377e-01,-3.6130451818501733e-02,1.1731989774693521e-01,6.4973832138255458e-02,-2.4933335338463627e-01,-1.6782774847468324e-01,-7.2324745775348268e-02,-2.4086314396955563e-01,-1.2468204075698288e-02,1.4073781041521932e-02,-6.5519037146675937e-02,-9.7454291270973867e-02,4.1394594343921509e-02,-1.2874164366385735e-01,-1.1401626896934154e-01,3.6349247943486734e-02,-2.6487001632071863e-02,-2.2132439634726936e-01,-1.2429108275112843e-01,-5.6062754921258236e-02,-8.6740861083096130e-02,2.0082938499688194e-01,6.7972128364358952e-02,1.8201874415326338e-01,-3.7290723552445293e-01,4.9810881022981718e-01,-4.2448805485992280e-01,6.9720859388681111e-02,-1.5314525503471538e-01,-7.6877471644319101e-02,-1.5781508838441802e-01,-2.8193131200959021e-01,-2.0845747292479455e-01,6.2049360993182354e-03,-4.8028665212945809e-01,2.4083991832281174e-01,2.1834828640429385e-01,6.3396307174564487e-02,-1.7697371601613052e-01,9.7185713502412341e-04,-7.2008256454129643e-02,-2.8571638506045588e-01,1.7639776803596963e-02,4.1852496248721005e-02,1.9730005782441459e-01,1.3849851884373993e-01,-2.2444973713614441e-01,1.2661145178459920e-01,-2.0509964932104718e-01,3.3624092284308088e-01,1.0243352096298622e-01,1.3399195428868987e-01,7.9375923903192924e-02,1.0321580697735830e-01,-4.0857333139493086e-03,-2.2817307260292997e-02,1.0631753590596213e-01,1.2856288562137921e-01,8.5677103088632744e-02,-1.6164745588992085e-01,1.7194122879941387e-01,2.1452930591020941e-01,3.0523074242273118e-01,-5.4343082736442797e-03,-2.1604362560631793e-03,1.4057706731924280e-01,2.3059103155751665e-01,1.9094418320164741e-01,-2.3556217211421962e-01,-8.7631328877100234e-02,-1.0482175120421805e-01,9.7083832369851492e-02,1.0620087383612870e-01,4.3247066311292395e-02,-7.1384872571840063e-02,-9.2785333454326366e-02,2.2242324873858271e-01,2.4976767327957283e-01,2.4932536769056138e-01,3.4661695522475866e-01,7.9743332970965669e-02,-2.1865002038724390e-01,3.1056753096857720e-01,-1.8487477831103235e-03,1.6900967137318201e-02,1.4266081251792861e-01,-2.6433370312835586e-01,7.1271256638121179e-03,1.7535409678907665e-01,-1.8002985239726624e-01,-2.0601529395980567e-01,4.0010537115256739e-01,-2.8963834376039038e-01,9.2652285168755052e-02,-6.6290904321923319e-02,-5.6145734431469529e-02,4.7370502145904055e-02,3.6303342934210342e-01,5.7114584389308942e-02,2.6152645922221762e-01,3.8327548507899223e-01,7.7307055231103816e-02,-3.4897938285434589e-02,9.1532635348732475e-02,1.0524767988710794e-01,3.1419169696516969e-01,3.3970886600095181e-02,8.0578281092763299e-02,-1.9114873170153560e-01,-4.1713641133846513e-02,4.8804223886450507e-03,8.2659968614302221e-02,2.0762545601561905e-01,-1.0441311169666900e-01,9.6968306091478954e-02,6.3619402194958319e-02,-1.7226594912108686e-01,-1.3763879820461233e-02,-3.2272832242770083e-01,-5.3649550479383884e-02,-6.9237234762297456e-02,-1.9713670458853022e-01,-1.1262516133028154e-01,-7.9235001997122606e-02,-9.6167490384291926e-02,-1.1276118690276953e-01,-1.8456136398903497e-01,3.5550815702984101e-01,-1.3440122750698930e-01,1.9234894492242943e-01,1.0656928273533288e-01,-7.6632904960589582e-02,2.3768712869263708e-01,1.8176309663343063e-01,-5.0076769761441198e-01,1.8547936098717285e-01,8.5644042038336393e-02,-1.1842569599411260e-01,8.7245640433263882e-02,5.5798569801968137e-02,-1.2867360990137086e-01,-1.4015379524621491e-01,-1.4835821946824557e-01,1.9527592144286715e-01,-1.7509369811118236e-01,-1.5383992450605477e-01,1.0810099424348318e-01,1.8069340696250497e-01,1.4851300057118758e-01,5.6980438758404549e-02,-2.4571526891114187e-01,-1.8252648550000569e-01,-9.0755160553130404e-02,1.0261664259030438e-01,1.5281060828095616e-01,1.9627356564594450e-01,-1.1832490043393498e-01,5.4092516242591752e-02,-1.3180300072506021e-01,-3.3044957736629432e-01,3.9047855303318280e-01,1.6701351220379002e-01,-1.8514650019285125e-01,-2.9438094663918449e-02,2.0015992548174516e-01,3.6236290944767026e-02,6.8657830202278849e-02,2.7408206564532196e-03,1.7699551796615427e-02,3.2265543012453196e-01,1.0308948001896076e-01,4.1810647257599469e-03,-1.4431558040066442e-01,1.9471210639784658e-01,-1.8743474176257449e-01,2.1366628726059647e-01,8.3004061475288160e-02,-1.3959661955458319e-01,-7.9793640550913369e-02,3.8296672067605458e-01,-2.1665400335308732e-01,1.5258583631067629e-01,2.3775098246170731e-02,1.7460420118215775e-01,-1.5480002409097202e-01,-1.0055734498288252e-01,-3.6277542049437950e-01,-2.3049098823764202e-01,8.8972748040778565e-02,1.0529749131058218e-02,3.5784204302608125e-01,7.4666568180261267e-02,1.0679373853742447e-01,5.5117260122478182e-02,-2.7886619493222804e-02,-3.4248914906051170e-01,-1.3705003450038494e-01,2.2380237080584775e-01,-1.8080580340815311e-01,2.1787171028674410e-01,-1.2069923378025568e-01,-1.2533628114978854e-01,-2.8835831806304554e-03,-2.4482331549591954e-01,-1.5681049443329675e-01,3.6465193595974978e-02,2.4212907016534543e-01,8.5401978049607891e-02,1.4073884053935751e-01,-3.1181629056940680e-01,-6.7506051239811127e-02,-7.8019064138792296e-02,-1.8374760027488535e-01,-1.4378594387523233e-01,-1.3189381227001137e-01,2.9991436245736542e-02,-2.0159879480260867e-01,-1.0500119152868372e-01,3.7623813207951801e-02,2.7147988691842664e-02,-2.8466888205925543e-02,6.4830221862419296e-03,2.8879099564254951e-01,-1.6362655963075795e-01,-1.5296388532838504e-01,-8.5686085475184873e-02,-2.0646052103294843e-01,1.7911718846163568e-01,3.8560877632198454e-01,-3.4930314200910889e-02,4.9472948964504393e-01,-3.8667191375746264e-02,8.5253749871994078e-02,-8.0172940903036491e-02,1.8608998532569104e-01,1.5367760429066216e-01,6.8577477045276114e-02,9.4506560418398805e-02,-3.8620981708349333e-01,1.0157464516005289e-01,-9.8316753850803684e-02,2.8199936968121658e-01,-1.7184412542078198e-02,1.1070712420776926e-01,6.2386924579904537e-02,2.0367855752958200e-01,-9.5883416584061687e-02,-8.5301107496100245e-02,-2.8747359755522284e-01,1.9675287943393699e-01,-3.5521481535581101e-02,-2.0060226259951253e-01,3.2145632784955989e-02,3.3307907084423388e-01,-9.5560318318786974e-02,-1.1836434273460822e-01,-1.4215480679512303e-02,-4.5775535873873043e-02,1.1505489020801148e-01,-3.9898540836791153e-02,-6.3713811123308128e-03,4.6139810704264361e-01,2.8428194079258499e-02,-1.7850135358381400e-01,8.4657216068682123e-02,2.5583784924590947e-01,1.1965648752641632e-01,4.8366701909976578e-02,2.5887424331199160e-01,3.5512534308518506e-01,5.4514526385235997e-02,6.8036630765807168e-02,-1.2844303638053303e-01,-2.1174936281735618e-01,7.7653189447137574e-02,2.5988895525420164e-01,-1.3016696523942872e-01,-1.9030013115024397e-01,-2.1590687975291133e-02,3.5662641760865899e-01,2.4729054684097217e-02,-3.1698219358644880e-01,-1.8714508815991690e-01,-3.9464983573531076e-01,1.9412558616154076e-02,1.2326703553693420e-01,2.3815617390604879e-01,2.1166466558000654e-02,-1.2485273301239501e-01,8.5427483468500806e-02,-3.0136543466489918e-03,-3.1261449448572143e-01,-2.4469323647693053e-01,-1.0090345719505095e-01,1.8416061958606733e-01,1.7920155853197803e-01,-9.0954468637955740e-02,3.2075241930368092e-02,1.7500312586303016e-01,-1.2283664097436080e-02,-1.3517424402669542e-01,4.9756530631038472e-02,1.3937971504122582e-01,3.5393161375499048e-02,-1.1869247751676867e-01,2.0353700696687896e-01,-1.7838501887080727e-01,-2.1823349265914260e-01,4.3361734759056469e-01,-2.4012713871295779e-01,-3.5624317403502970e-01,1.4742874351115418e-01,-2.0628834156732351e-01,-6.1606403986613906e-02,-4.8020818123421273e-02,-1.3577661994145770e-02,-4.1545023223691357e-02,-8.2029652480109350e-02,-6.8722163875918840e-02,2.4031266185036697e-02,1.5436908390615417e-01,2.1816087569848572e-01,-1.7142222911941341e-02,-6.7887803214506506e-02,-1.4208775568485163e-01,1.7619054067431797e-01,-2.2555228479137654e-01,1.9929317635728122e-01,1.2573641795854329e-01,3.0034744922458539e-01,2.4655424743624418e-01,1.0750896346591328e-02,-5.7167026170415733e-02,1.4925956061570597e-01,1.9129735046554217e-02,-6.3188495209066053e-02,-2.5981506750860495e-01,1.4880787671350335e-01,-9.5505528963463981e-02,2.1381708599345697e-02,-1.7156380587988701e-01,-2.5578884159805743e-01,-4.0592038847393860e-02,1.1103995385162053e-01,-2.8614849845665946e-01,2.5205074803940414e-01,-1.9022734402495714e-01,-5.6954208981384938e-02,3.9600475360534487e-02,-2.4120985526051222e-01,-1.0972083752108722e-01,3.1575622981100981e-01,-7.3577792942241760e-02,-3.2529806290324474e-02,-3.1378650082023501e-01,-1.5097484713339554e-01,4.0465734209851523e-01,-2.0089240326866614e-01,3.3342175295918319e-02,-6.9068723160612870e-03,2.6942458906193706e-01,-2.6156496167382282e-01,1.6886111163408815e-01,5.8229201208582104e-02,1.1515561394734669e-01,8.3273253055802215e-02,-4.9550419204462508e-02,2.3310771453642926e-01,-2.3259566029058482e-01,3.4638892169408247e-01,-9.9038120758402570e-02,-2.7313273419234652e-01,-1.1841552109775765e-01,-2.1036812396878082e-01,1.7686576882176277e-03,1.0886547350813848e-01,-2.4495021090504807e-01,4.4965331632110868e-02,-2.3894905337890601e-01,-7.6421663357674571e-02,-1.2810190309739136e-01,6.4476634985103972e-03,4.6507117068592806e-02,-2.7486914546361537e-02,1.6855441058268089e-01,2.5664784040604227e-01,-2.6635103014932038e-01,1.9994038908755449e-01,-2.8382934501449752e-01,2.4335788503157779e-01,6.8935298555842531e-02,2.8504352478452288e-02,-2.2527198955654976e-01,2.3988954376889302e-01,-9.1550978555012999e-02,2.5893687804568782e-01,-2.5506970592678746e-01,9.9884336388653627e-02,1.5789629447703335e-01,-9.3983998752556169e-02,-7.9722202110578566e-02,-1.6899603824862014e-01,-6.3246643765383387e-02,2.1086231861856738e-01,1.8989986032983192e-01,8.8728033344586135e-02,2.2505744620359544e-01,2.9297173088956852e-01,-2.2346843192467777e-01,-1.5586336581734064e-01,-7.8394979027830852e-02,-1.4413427226311146e-01,3.9652452666531846e-01,-2.9171971088882631e-01,2.3967567044265578e-01,2.6947860563435198e-02,3.1869176329919015e-02,-1.5138121200917926e-01,7.2414061359644386e-02,-5.6577516891180957e-02,-9.3988329216068076e-02,-1.1489670995288834e-01,-2.2535027130301852e-01,1.3578639418432731e-01,3.9639866907040550e-02,2.5023000008173989e-02,9.7074130903837180e-02,-3.2475548115817970e-01,-3.7950131105509177e-01,5.3739837805315271e-02,-6.9494716306553961e-02,-2.1990942498455412e-01,-3.0591024769313774e-01,-2.6488580708554661e-03,-2.2231072393760449e-02,2.9229840252685541e-01,1.1531102364104616e-01,-1.6529077257332198e-01,-7.2904071251584296e-02,3.0408473108125500e-01,2.8403547768123416e-01,-1.8051674368830725e-01,-8.5561787983329446e-02,-1.6588532137003287e-01,-9.0895624302306813e-02,3.2431558569351350e-02,-7.0640655683998299e-02,6.1667704148641707e-02,3.1351986235455043e-01,-1.2013022527640417e-01,5.9475282895842453e-02,-2.0215613766530152e-01,1.2490842834704172e-01,-1.7284560746434596e-01,-3.9140862033929524e-01,2.7741800267520034e-01,2.6329699840846696e-02,4.9724918401716327e-03,-1.3243140862234115e-01,1.1630664375120559e-01,-3.3776286793397864e-01,6.6356937071934630e-02,-1.7665977588234710e-03,-1.3856107847159110e-01,-9.0676673395507196e-02,-1.5725542303457596e-01,8.5723555887614461e-02,-4.1476818953650532e-03,5.6105394986238850e-02,-1.4552720720089080e-01,-2.6525500387714163e-01,-3.7981735898664393e-01,7.7199791455575192e-02,1.7841174761588552e-01,-5.0055831636322830e-02,-1.9241330983192531e-01,1.3148411553928266e-01,1.7574211234298009e-01,1.9143193982631634e-01,-1.9614109453447473e-01,1.8478783717749675e-01,-1.9189723088442696e-02,-3.9769683774717446e-01,7.5837551616229959e-02,-4.2555763133141154e-02,5.3773138264545918e-02,1.2945563647616562e-01,1.6674259792848933e-01,-2.3547541535398636e-01,-9.3767573952782970e-02,-1.8876642905703692e-01,2.7440660228358904e-01,-2.5522024197126292e-04,-7.8961631425078463e-02,-2.1072760101612292e-01,-1.8989006680552267e-01,2.9364597244393931e-01,-2.4485968802365318e-01,-4.0461147944504056e-01,-8.8521728343012474e-02,6.0265999875807955e-02,2.5467998901586125e-01,-6.6614862397743418e-02,2.2901058263648982e-01,1.9916097180823300e-01,3.0825977112142335e-02,-1.1252545089912053e-02,-1.5882780782977668e-01,-8.0873660736637848e-02,9.4557303878881893e-02,4.8169294295144277e-03,2.8703072975005205e-02,4.6007257068588758e-01,2.5658055688843623e-01,1.7202993950552600e-01,5.3412673742999982e-02,3.1131587938766325e-01,2.4689264001409525e-01,-1.6207605669934516e-01,1.7048694131006353e-01,-1.3833933466960485e-01,7.9123409653979584e-02,1.0153914502599425e-01,3.7235796708046354e-01,-1.8687742654505582e-02,-9.5971394267152219e-02,3.0529549731735350e-01,1.0020896746329896e-01,8.5701735492846709e-02,-1.0642240278286806e-01,1.1516259386493008e-01,1.1096241858684337e-01,-1.3181642801837267e-02,-8.8971877370277355e-02,-1.0354705492311078e-01,3.7917413031497163e-02,-9.7187063271102270e-02,-9.3797900331608897e-03,3.1723023564727626e-01,1.1912219366802587e-01,1.1032294262144056e-03,-5.1153919530164083e-01,3.2401317479977862e-02,-1.3456126740739277e-01,4.2831567869102499e-02,-2.9163633775992320e-01,2.1699183039748374e-01,1.7267437923000103e-01,2.0700790570238403e-01,-4.8694203199338940e-02,-5.3313315135133918e-02,2.7619754232899785e-01,-4.6597232960519791e-01,6.4790932950430202e-02,6.8191813385297978e-02,1.9965229047263591e-01,6.9541835660284282e-02,1.0497637776264260e-01,-6.4384162847544585e-03,2.2187765123180606e-02,-3.1924393176772786e-02,7.1652934958815112e-02,1.3802260528862825e-01,-7.4087482313975328e-02,-6.4026586779699954e-02,-2.3554245642210991e-01,-6.4347351672227382e-02,-1.4643781411635609e-01,-1.2972279568923806e-01,-1.1372178324446088e-01,5.6440893639382490e-02,1.4712213098900773e-01,-8.7665385084949782e-02,-8.9797852453957827e-02,1.2084445469625101e-01,1.0233799391422722e-01,1.3170266020774843e-01,-2.6417823026592369e-01,5.8057594140030630e-02,3.4370820114680595e-01,-1.2845084441498811e-01,7.3052479599176240e-02,-1.0395227684985162e-01,4.0907596902935071e-02,1.8923815559026649e-01,-3.8806299092757263e-02,-3.1981625184817353e-01,1.3562398213640459e-01,-2.9550477352438737e-02,-2.5440107528118337e-02,-2.1484526956530589e-01,2.4923157945436752e-01,-1.8342885715247076e-01,1.7741225644277960e-02,3.9480726964865448e-01,-2.3246948528703557e-01,-9.3688673572482464e-02,-2.5075569658396524e-01,3.1740269577151908e-01,-2.4565409335719188e-02,9.9518652531879193e-02,-3.1519005460319455e-01,1.4223383559454858e-01,2.2790418558748241e-01,-1.1400065940601160e-01,5.0544421346562146e-02,1.7974760004764577e-02,3.5697459163312836e-02,7.4466715320251634e-02,-2.0972436003071276e-01,2.0276313488681033e-01,-1.0972273025045111e-02,2.3503238224204190e-01,-9.8828678099086201e-02,-3.1368056236501130e-01,1.5117959696153932e-01,-6.5763369949941350e-02,-5.6073109801101230e-02,1.5816990364748851e-01,3.2983955740031989e-01,-2.0607981469781261e-01,1.3963444843083742e-01,1.5029839921744662e-01,1.1112824897084027e-01,3.2351834371324578e-01,2.2465699808858200e-01,-6.2775448279332138e-02,-1.9280874769740264e-01,2.6298272613109375e-01,-1.1076080816500207e-01,1.3583013989935960e-01,-2.6380325636954122e-01,1.6488452952980751e-01,8.7069403304734339e-02,5.9522896526152377e-02,1.4899654767994000e-01,3.7400317031199649e-02,-2.7582929293168928e-01,-2.3223643253769979e-01,-3.1259265396994967e-01,1.6787247453954574e-01,4.8830414812241950e-02,-1.0170301311024244e-01,2.7574690847094568e-01,2.2992615462405280e-01,-3.1747522635264969e-01,-3.1400166555772563e-01,5.1045347134648242e-02,-2.8721699882291341e-01,-1.4030030198200358e-01,-1.9325009704311155e-02,8.4409293057335549e-02,7.2081620283997779e-03,1.1026085813847734e-01,-1.3994998715168105e-01,2.2631276464396086e-01,1.6405072950162980e-01,-2.2886801301958713e-02,-4.6529473241401609e-02,-2.1244622077659073e-01,3.9240900319580545e-02,5.4052857190207158e-02,-1.4044259998961584e-01,3.2269235152344211e-01,1.9944739497559949e-01,-1.4477893389807697e-01,-7.1023188614768362e-02,-2.8103034694931284e-01,-2.3298627641372802e-01,2.7491574842812162e-03,-1.7623779352778260e-01,3.8522834618318991e-01,1.0483599068789765e-01,-1.0242976189199085e-01,-2.3729653799629227e-02,-3.4531674105429996e-02,3.8782039436892776e-02,1.8060548627185677e-01,1.3704574535385866e-01,1.3655654569520642e-01,-4.8527282638505187e-01,-7.4088471167043257e-02,1.2456650901385291e-01,-1.8032089814435287e-01,-2.4540274935266623e-01,4.1154673389686466e-02,-8.9007606027426245e-02,-3.8295147536988872e-04,-1.6207277067953807e-01,1.1873117753926067e-01,2.6574739714754738e-02,-2.2076505856815781e-03,1.2487627588795244e-01,3.2201582091651193e-02,1.4388167513716507e-01,-4.8780203213828519e-02,1.7578332828600282e-01,-3.7905172617383305e-02,9.0268257722332670e-02,-2.5903266971667893e-01,-1.3029062813769982e-01,-5.3328727750074495e-02,2.3670406506470359e-01,-1.2419452658131810e-01,-1.9291389920378707e-01,5.2265190147608026e-02,-5.6167214215279863e-02,3.3664689435343076e-01,-2.8346582880167698e-01,-1.9951066801672877e-02,1.6587210915177727e-01,-4.0524507702913304e-01,-3.6854481795241845e-01,-1.3821378290297978e-01,8.7965924223057879e-02,-1.1556300695500675e-01,3.9437570575650005e-03,-2.4779030908238497e-01,-1.3579750612095048e-01,3.4106940149487786e-02,2.7470849068438952e-01,-1.6236758798827020e-01,-7.2491449029296856e-02,-2.0730885521443512e-01,6.6783276169157427e-02,2.9573182353030830e-01,-1.3949169399533945e-02,-5.3782568993992218e-02,1.1189688280993883e-01,1.0996584454973843e-01,8.8794548192562384e-02,-9.0248799128484464e-02,7.2904157881190854e-03,1.5184129992030039e-02,-3.9833442910424482e-02,-6.2355980348947446e-02,1.1420575160201975e-01,-2.7183477864953787e-01,1.3748390200788732e-01,-1.9249978489910183e-01,-1.5429068628257087e-01,-1.4741127236413876e-01,-1.6364716921406863e-01,-1.2660093088415164e-01,-2.9992390287375731e-01,2.2820098974684844e-01,-3.0240669040484136e-01,-5.5491898195388856e-01,-3.1790054236487980e-02,3.2954907768533243e-02,-9.6168598927379959e-02,1.3361177611739011e-01,9.9560521501040888e-03,2.7538214602454486e-01,2.2859157502771452e-01,1.2338932838479316e-01,-3.4133980504833600e-02,2.7906451024656109e-01,2.1445963224822820e-01,-2.0927047122878007e-03,2.2260298842502430e-02,-1.4241688558446841e-01,-1.5389262064395068e-01,1.5887125708880456e-02,3.3399080858473629e-01,-8.1087155044987008e-02,9.3956527347581892e-02,-1.8514231133008849e-01,-1.1586848944376639e-01,4.0373422375827273e-01,-2.2688982170307437e-01,-1.7313639765445174e-01,-1.2869132600751754e-01,3.7690723995492104e-01,-1.4923911794896591e-01,-1.1643545894462429e-01,3.8720760686293744e-02,-4.7375414842452487e-02,-3.3661338448956926e-02,-2.4945871087081042e-02,2.2342749862067574e-01,-4.7073429918297729e-02,1.6626726861355429e-01,-1.3862066015803046e-01,1.3726936938476605e-01,8.5144630377627553e-02,-3.1930062249888808e-01,1.3071871860460296e-01,-1.6305187473945940e-01,3.2085420058382205e-02,1.2595038735166864e-01,1.2451973223181489e-01,-1.5850955181805265e-01,-8.5061640695700921e-02,-8.0254785082404134e-02,-4.3840296821453884e-01,-9.3536397050880699e-03,-1.7742002964042766e-01,5.3772981123689195e-02,2.7026143820618992e-01,1.2258454432500096e-01,-3.8669707082438297e-02,6.9775260438152811e-02,-4.5965024669006588e-01,1.7982435093510196e-01,-1.8333231460821212e-01,2.1845234949095363e-01,-1.2052571275039181e-01,6.2727869542849868e-03,1.4902905018544066e-01,1.5873320359107226e-01,-3.8829844569441013e-01,-1.1930915190366932e-01,-8.0775443111364809e-02,2.1661067881027071e-01,-1.3673418214572847e-01,-3.3205006641513479e-01,-5.9580940667521162e-02,8.6650700432539945e-02,1.6075638711809756e-01,-3.7615739712394630e-01,8.0491694118232482e-02,4.2253523164842643e-01,2.8941028241430189e-01,2.2461429371681385e-01,3.0976202196751651e-02,3.2917992485181152e-02,-1.4725908003039023e-01,1.0578803269290038e-01,7.5918484919885662e-02,1.9809571312106056e-01,-5.0960949889864347e-02,-9.9994621386596774e-02,8.1403562560076873e-02,1.4859061039094973e-01,1.0442102815075993e-01,6.9831111770584500e-02,5.8200326378457415e-02,-5.6979693036322845e-02,-9.3332163819542124e-02,5.1182059480984504e-02,3.2740443880568661e-02,2.7959429071007397e-01,-5.6289792355754875e-02,-2.6536607850033112e-01,-1.1386879313186771e-01,-4.8974548276586577e-01,-1.1361091324637365e-01,-2.3009328022529593e-01,9.5513239875296869e-03,1.8797593485251152e-01,1.8255340696457192e-01,-1.4662048088112048e-01,1.9877337032538145e-01,2.0934121010075295e-02,2.4848183475244701e-01,1.9887279953817369e-01,1.2956025153533340e-01,-1.1606270918110670e-01,1.8531477780764201e-02,-5.8729288536418692e-02,-8.0794878828721883e-02,-2.6025291416122553e-01,2.7645162221336433e-01,9.2135749984779025e-02,-7.3376064103640351e-02,-1.1647855309879912e-01,-1.6139612293108216e-01,6.1570851523470305e-03,2.3167277937222880e-01,-7.1239519315154778e-02,8.3882046619715434e-02,1.0800623232642265e-01,-1.8178290883361034e-01,-1.8927335251081884e-02,-9.9653757942618160e-02,-7.3889102745620827e-02,1.3466666909341857e-01,-3.2328691851257418e-02,4.7972396298928126e-02,-3.4033837624193736e-03,1.6420205445281710e-01,3.3323753005351936e-01,-7.5617710685292008e-02,8.5078341427514054e-02,1.6493509025231495e-01,-2.5146155686694516e-01,-1.7491505062793278e-01,-5.1188145382120864e-01,1.3196527195433122e-01,1.4776430206594048e-02,-2.0597361483114491e-02,3.1469096457633977e-01,-8.0679770683948118e-02,-3.0707788390356233e-01,-1.5944369694487748e-01,-1.7587044473225102e-01,-1.0104868050817750e-01,2.8275883929809886e-01,-4.9361910039593511e-02,-1.0072048873482962e-01,-3.6067352141643180e-02,1.7065866376406114e-02,-4.3666713110328208e-02,-1.2566058175437292e-01,2.2204747893129300e-02,5.7217419593016655e-02,-1.9436442910887558e-01,2.0935019050091169e-01,5.1890779904181794e-01,7.0556579291300464e-02,3.0200516999509625e-02,9.2629598347655946e-04,-7.2840624733566894e-02,-1.4029422865023328e-01,-9.5348397936443452e-02,1.5633700454503816e-01,3.1904902724855444e-01,-2.0945987691910944e-01,2.7499133146184612e-01,1.5795061226215465e-01,8.2256489843598138e-02,1.2693084896694184e-01,1.1911550206575419e-01,-1.9936778576637912e-01,2.7917404691287506e-01,3.5425472893005117e-01,-1.6336411658594840e-01,-8.1239560162112895e-02,2.4793569405189595e-02,3.5727205470613976e-02,6.5302006243514607e-02,-1.6746139026842399e-01,-2.3674942684407854e-01,-4.5679496218326704e-01,3.3671856217066587e-02,2.3980396563639919e-01,1.3046697381814129e-01,-1.7047327329909201e-01,-9.7505163364588282e-02,-1.0066608953902972e-01,-1.3393053687553436e-01,1.3041524577293212e-01,4.0629384130596197e-01,1.4239659173444430e-01,-1.2714309720969388e-02,-1.1217041396372542e-01,7.7604559044404553e-02,8.0793438040973498e-02,3.6712835659763443e-01,-9.3917212810055717e-02,9.7892453450715650e-02,-2.0654054975267924e-02,-1.5716328737920654e-01,-5.5217956316235536e-02,3.5063120778688582e-02,-8.4098342196274989e-02,-5.6196285442593363e-02,-2.1811900418489572e-01,2.1771278668660324e-01,2.1267069967774815e-01,-8.5770403292171796e-02,-1.4040762269740781e-01,1.4217994663184469e-01,-1.5692392660328966e-01,-3.6232912747009055e-01,-1.5655011299628999e-01,-5.8533647047229388e-02,1.2267216647170948e-01,1.6513974450584340e-01,2.2742592833306174e-01,-2.1596301223976702e-01,5.8236285689144053e-02,1.1645953565552279e-01,-1.5601185363611778e-01,-3.9784590278911830e-01,1.2279797764843807e-01,5.1977018522349192e-02,-1.3964867718249596e-01,-9.4368854379585101e-02,-5.3055245714244206e-02,7.2254835668657563e-02,-8.0632729108079171e-02,-8.4832330728423139e-02,-8.5805037950360180e-02,-1.4260529834337904e-01,-4.1556686113726127e-01,1.6116161724342931e-01,6.9922925502724581e-02,-2.1929688437001438e-01,2.8521022399926232e-01,-1.1482137080603431e-01,-2.2032920669712253e-01,-1.3578893771745790e-02,2.2385546159416078e-01,2.2813796360318539e-01,-1.0531587418239057e-03,-1.1471426394353418e-02,1.0751349607281410e-01,4.0565720867562785e-02,9.9758717544809278e-02,4.2233933971958619e-02,-5.7497404913154693e-02,4.1416154484806161e-01,-4.8754447300665954e-01,-5.4565253703845754e-02,-2.5904239861495465e-01,8.0593068883518498e-02,-8.9735758351274144e-03,9.2740025353104077e-02,2.4591368453105625e-02,-2.2118167026680369e-01,1.1627560092446572e-01,2.1393050265930741e-01,-4.4567520358989240e-02,-2.3691768526999837e-01,-7.5304249097827305e-02,1.6570063096058918e-01,2.9981023292501151e-02,2.6939820819068172e-01,-1.9882939339678979e-01,-1.1619967594061810e-01,-1.6639978378207637e-01,-2.9946793503562601e-02,-6.3815380223792503e-02,6.5171710562433385e-02,-7.2830097009286943e-02,3.2428113867668518e-01,1.0162079720165036e-01,6.2173708588850359e-04,5.7718597448587747e-02,1.8077088079836393e-01,-3.3157981315860070e-02,-1.3849923306081835e-02,-2.1953956518271506e-02,1.6034640416616390e-02,-6.1176623227298818e-02,1.6524045508242133e-01,-1.2897337049119673e-01,1.1328886629507358e-01,-2.1904954691488276e-01,3.7947774386703083e-02,-5.4675338596384049e-01,-2.7890047629438103e-01,-9.0444985922494767e-02,2.2243257969462263e-01,1.4365341434677936e-01,2.6339711295811707e-01,2.6211846817890522e-01,-1.0586525908398729e-01,-2.7661385611954065e-01,-1.5200721270588802e-01,-1.1061960019068520e-01,-2.7967991734916753e-01,1.6619164202205419e-01,-3.1410913111680139e-01,-2.3842832518891861e-02,1.2153055696002165e-02,-7.2045899587287160e-02,-2.4141449614743640e-01,-1.1466274818878935e-01,-3.3978080020642287e-01,-2.5323176983412361e-02,-1.6668248509231967e-01,1.0826709448862692e-01,-2.3339750109941604e-01,1.0579779026333784e-01,2.3685533999922437e-01,2.9558620702704607e-02,3.6967880149786411e-03,-1.1660141059052412e-01,7.2462212474370506e-03,9.3710815964906796e-02,1.8518725597749816e-01,-6.9029626514861275e-02,9.3292903127792454e-02,7.4713057304366975e-02,-7.1119973810124887e-02,3.9443087697906720e-01,3.9826888213335510e-01,-9.7659036515536007e-02,1.6712532034214569e-01,1.9228281856134716e-01,-4.3553241698691031e-01,3.2495187422627131e-01,1.0983540612276502e-01,-5.9001132039753122e-02,-1.1854478612048622e-01,-3.4805816149184252e-02,-1.3048710481699013e-01,-1.4084832329893879e-01,-1.8342046584975935e-01,-2.7314104390093775e-02,1.3286279218416208e-01,-2.4667887414154657e-01,7.7653560249794598e-02,3.0554932645559524e-01,5.5449446427930316e-02,-1.5753121212089408e-01,1.8449324487231972e-01,-2.6900644593084871e-01,2.2324915091475742e-01,2.8487047599765392e-02,-2.8700890824528841e-02,5.4673496226601677e-02,1.8772679606186619e-02,-6.6514749630322084e-02,1.4068202482556824e-01,-1.5139018049537928e-01,-3.4984181408769954e-01,-3.4976333319522129e-02,2.5215743016625214e-01,-1.5758367856670114e-01,-2.4913014162634259e-01,1.7270256779906906e-01,-1.4266233914959442e-01,5.6349514353469868e-03,1.5669180141335337e-01,-3.0567774794544960e-02,4.2424032599572642e-02,1.8443053481056940e-01,2.5795265845324278e-01,-1.2554326227724544e-01,1.6054234655476909e-01,-4.4948799996538370e-02,1.3165566957426184e-01,-4.0123991853329308e-02,-2.0854699486851175e-02,2.5815216670343380e-02,-1.8780301774628078e-01,-3.1887688222183699e-02,-2.5549179831596064e-01,1.3652918663395100e-01,4.5002155134639593e-02,8.2046445706297461e-02,4.3833437025608679e-01,3.5405616703259583e-02,6.8198941266823271e-02,1.6834831592082042e-01,-3.1076955304821782e-02,5.0155624893064277e-01,1.8974211837884003e-01,1.7651273140788726e-01,1.2116240441461118e-01,-1.5720340923842385e-01,-4.2296486125495703e-01,5.6156818499583670e-02,-3.3522165633722442e-02,1.2920483214009462e-01,3.3433973513574605e-02,-3.3216645044182125e-01,-9.5840713844486808e-02,-2.2403223003499720e-01,1.9680031844438012e-01,-1.9283470340907138e-01,-1.6031515917784145e-01,-1.8222108445341020e-01,-2.8998739638114285e-01,-9.0103249357804144e-02,5.4639488523800489e-02,-1.4014684077846551e-01,-2.5174999033742979e-01,1.0534181418750109e-02,-5.0557014450169545e-02,1.6252149579115649e-01,2.3101306401065269e-01,8.8958030680472922e-02,-1.5132500297394758e-01,-2.4799291316709944e-02,-7.1565618797393288e-02,-3.0119012994202560e-01,-1.4897339858222525e-01,6.1686779934658140e-02,-9.9300922680591527e-03,-3.4856887872949938e-04,-5.4194660057315477e-02,2.2485787910168822e-01,-2.8008141723864338e-01,1.7878354420516809e-01,4.6936816294157351e-02,2.4207481229865097e-01,-6.7167552402747632e-02,1.4578825685479840e-01,1.0566141672106615e-01,6.9358369513284640e-02,1.5910426347419526e-01,2.2026560726849484e-01,-3.5635476802609528e-01,-2.3790840855804807e-01,-1.4129435506951407e-01,-3.0921057136667218e-01,-3.2417175490480822e-02,-3.8873591338973515e-02,-1.9640384879887998e-01,1.0725388417086576e-01,-1.1056045160967168e-01,2.9844730306680123e-01,2.1024191777382117e-01,3.5175738698443731e-03,3.5967750280568767e-01,8.3306711434418659e-02,-3.2953891777976896e-01,5.3209497450342869e-02,-7.7057275856459551e-02,1.8748804837865607e-01,-2.4011713182376376e-01,-3.6844905189666188e-01,1.9974411697707936e-01,4.2818520729807477e-02,7.0702983247985796e-02,-4.6274533385536241e-02,1.0072510370872416e-02,-2.7063595359764148e-01,-1.6990076451456659e-01,-2.8662985348266257e-01,-1.5078216233865627e-01,-2.1774988651710306e-02,-4.2601853424408746e-02,1.6401397626925460e-01,1.4036781509597313e-01,1.5934449820688043e-01,-3.6478418490424928e-02,-3.1109101631793779e-01,1.6613905502561802e-01,-1.6006530363882693e-02,4.9426579580923988e-02,-1.0559049139727590e-01,-2.9325941225756921e-02,3.5761937754572243e-01,-1.9674006997892385e-01,1.2960207919575484e-01,8.7449140729472602e-02,-3.5486947774413125e-01,1.3045749397655979e-01,-2.5487375152568620e-01,4.4267370839571857e-01,1.7030348248942870e-03,3.3018302171080632e-01,6.4933217859832609e-02,-4.1686725687830176e-02,-2.1969070142262823e-01,-2.1492876889461268e-01,-2.8476574765375606e-01,2.4322641559306743e-01,-7.7519670901849778e-03,3.0660772373357044e-03,2.4444235376490115e-02,1.2349115938434112e-02,2.4799482914796056e-01,-5.7929608478659383e-02,1.5654464567585991e-01,5.0252956003492236e-02,-1.1109142787531853e-01,9.4770608641632087e-03,-3.2249218338508662e-02,-1.4295777074507221e-01,-1.5887111911630107e-02,3.2420934026582504e-01,4.7739234005384143e-02,4.8615329960122779e-03,6.7160037408100115e-02,1.2448269902394438e-01,-8.5568911424071775e-02,-3.2141274535696945e-01,1.9042044419490686e-01,3.8920734547396321e-02,1.8777644755875525e-01,2.2056994883981138e-01,-7.8912284715043191e-02,-4.6588503091395117e-01,-3.1215090717154177e-02,2.8021097455779148e-01,-1.0261675320635134e-01,-1.5152259032247362e-01,-2.3705517449028914e-02,9.6200684497756594e-02,3.8723393375735926e-01,-2.8798953543730438e-01,-1.0065185945844569e-01,-1.6423745023294543e-02,-7.4734053897243344e-02,1.7489625172116730e-01,1.1552015204059767e-01,-5.5927180199852551e-02,-2.0773729952634795e-01,3.2634123736681668e-02,3.3391646805977393e-02,5.8378216638009246e-02,2.0576995878503712e-01,3.2411780653853819e-02,1.3433447307028196e-01,-2.0911635054794475e-01,-7.8607324150689134e-02,-3.3758876272266436e-01,-2.7696272785303661e-01,-9.7821903675917907e-02,-1.1224827646497271e-01,-5.1362399451394737e-02,-4.2730857069707903e-02,-8.4982948388520579e-02,9.7824347193134945e-02,2.9659410740968919e-02,-1.1580085552882306e-02,2.3414518164536310e-02,8.4106035784304225e-03,8.4506930009039707e-02,2.3388785579050023e-01,2.5398418677122736e-01,2.8542881878995902e-01,-3.0825257122929224e-02,-3.0347404488437663e-01,3.2727554739094729e-03,-7.0492731543203027e-02,8.9180813585729768e-02,-1.5630268817504106e-01,-2.3728697171927710e-01,-4.6129836760766874e-01,-7.8679893290756475e-02,-1.7429022014448980e-01,1.6753038292194919e-01,-2.0589123401228318e-01,2.7054247277685112e-01,1.8273923329725947e-01,-5.8398535638094468e-02,1.8163857205330516e-01,5.7087681256768719e-02,-1.4527179794598830e-01,2.5772191632077135e-01,-1.4996566448893173e-03,-2.4400787208289721e-03,3.2306060688475480e-01,-2.6949593306464775e-01,-8.8921627570688777e-02,1.5522927824535654e-01,2.4726554723617435e-02,-6.5313876084267752e-02,1.3122755724707455e-01,-1.9062121333896490e-01,5.8325207001636965e-02,-1.4818203382654210e-01,8.0585716714014044e-02,-3.7737325650000431e-01,8.8709133103129625e-02,4.1471603866865137e-01,-1.0929731941189159e-01,1.1260274044521834e-01,4.6514079067310289e-02,-1.4837226425771566e-01,-8.9221878679227484e-02,2.3911467606313735e-01,-1.7527707090308384e-01,1.1933497388822728e-01,2.6027297359847413e-03,9.3541781155144860e-02,7.0228047273662414e-02,-7.2455246800934542e-02,1.7997371611604979e-01,-2.7882408585893831e-01,3.2278039067664677e-01,7.8791714576110575e-02,2.1802756549573085e-01,-1.8270556564680318e-01,-3.9070927834498409e-01,7.8373569240241039e-04,1.3095976559563927e-01,2.0705223773899756e-01,1.1936698376785077e-01,1.5916205900241651e-01,-2.1940254806233500e-01,-2.0269566514512533e-02,-1.3761714082990795e-01,3.2569844496283340e-01,-2.3000903260404731e-01,2.6074184305146603e-01,8.6743268706580057e-02,1.2807745754081795e-01,-1.0402127712908434e-01,8.2437318625944569e-02,1.7671819732237143e-01,1.6857878055219622e-01,1.3216878996434434e-01,1.1019281256394001e-01,-4.2449024908616746e-02,-2.6837002588739067e-01,2.1303788536536829e-02,-1.0870663671680846e-02,-3.5696818924863684e-02,-4.7923300258137336e-01,6.1636562522556157e-02,-2.5330248087425032e-02,-1.6133018372423003e-01,-1.0040642707231384e-01,8.1011073008649570e-02,-4.8392504679930521e-03,-1.7145591180303130e-01,5.8353389985050325e-02,2.6229458621545998e-01,5.3966477676427635e-02,1.0969704463736733e-03,7.5724139603037643e-02,2.5362981116790451e-01,-2.5378621705127341e-01,-1.7897830012586519e-01,3.5416036592802097e-02,-1.9822583141064254e-01,2.1545847751164443e-01,1.4149537975170859e-01,4.1736579762820086e-01,-1.2721949915059755e-01,-1.8255518240015217e-01,-1.8350246898038070e-01,-1.8861257925753402e-01,-2.6249244496554150e-02,1.1195648068334280e-01,-2.8781024262183725e-02,-9.3761692825024889e-02,1.4073353797611290e-02,-2.9903818335564680e-01,5.3422609618759380e-02,-4.8169456907082231e-01,-4.1282376246876223e-02,-2.5179287189292227e-01,-1.6226666520506017e-01,5.2793472765393257e-02,1.4014340445719253e-01,3.9215532752143227e-02,-3.2383814802456196e-02,-2.1160323959357211e-01,4.1097918802715634e-02,3.8647389837879709e-01,2.3814766162743625e-02,-2.2390877916665208e-01,1.6621264412661518e-01,1.1213845744844775e-01,1.8391181117441971e-01,-3.9238341001265858e-01,1.1909369833170659e-01,-9.5409267520779176e-02,4.4812664325281706e-02,-1.1826754963938570e-02,2.5981815420102486e-02,-1.6766125127612308e-01,1.3097772051444262e-01,-6.0518493562332361e-02,2.0307149624529552e-01,2.2273942441803460e-01,-3.9078680833538687e-01,7.4347015999453592e-03,-7.4622484794751406e-02,-4.0469130840966101e-02,4.3566033547158788e-02,-1.3643193273110654e-01,5.8966952576599084e-02,1.8167504569464837e-01,1.5329887905579406e-01,1.4009710623890279e-01,1.9809093384851886e-01,1.2727834330991347e-01,-8.2905605593229556e-02,2.1241956788811778e-01,2.5647110518435279e-01,3.5756858676066489e-01,2.5522627603266391e-02,-7.3884504738701839e-02,-1.1251778804280174e-01,4.7571293671385739e-02,3.4175632782967869e-02,-1.5514259421138696e-01,-3.8675127370039647e-01,-9.6558833947079023e-03,3.2111437585127700e-01,2.5417725770185912e-01,8.7127719247950680e-02,-1.5286475659173923e-01,-8.5990249429380272e-02,-1.6763285386643090e-01,-8.3202719103703818e-02,5.9552978191276459e-02,2.6198291787344519e-01,-1.3427278105337320e-01,-1.9035655155649003e-01,1.6539673912822062e-01,-2.2433662072602678e-01,1.5945738414030827e-01,-2.2059091974120676e-01,1.9220527298892895e-01,-4.5083249097480599e-02,-2.3561299037408528e-02,-6.9282453084823184e-02,-1.8238556753548182e-01,6.3871929220255447e-02,-1.2268978082702224e-01,-3.6190935325434681e-01,-2.7225574991264689e-01,2.2632508348867406e-01,-1.3077702617187761e-01,1.5468829318275185e-01,-3.2542826482310172e-01,-2.6860007859333801e-01,9.8219859565287670e-02,4.4955200882757271e-02,-1.6964283086723181e-01,-2.1982042316403185e-02,1.3175161377211050e-01,1.5129844935208331e-01,5.9084405403622003e-03,-4.6259491201655623e-03,-8.5162850656586270e-02,2.3819806800462082e-01,1.3909194264222918e-01,7.5511695723607664e-02,2.1712033426060456e-01,1.6255535877649058e-01,2.4201877925767204e-01,-1.2668151568718780e-01,-3.4319941686276584e-02,1.8759531005202482e-01,1.9845478384351117e-01,1.6298650650702295e-01,6.3565137949875603e-02,-1.3633503314950508e-02,-1.8964317661959557e-01,6.0046433357866844e-02,-1.7444406472543764e-01,-1.9860985374389287e-01,-1.4897705378059239e-01,2.7988190142811575e-01,5.7104268902687647e-02,2.7865201582648058e-01,5.0982319092634865e-01,1.8936272350336805e-01,-7.3574053689282853e-02,-2.0281548892815493e-01,-2.5070406629877834e-01,-4.8233088408763461e-02,-5.0206560678963175e-01,1.1683709396195704e-01,2.9557604422872247e-01,2.1753483283557754e-02,-5.4065669375159324e-02,3.6693778718415053e-02,-2.9601701473588615e-01,2.9254905189953981e-03,5.6621445704527457e-02,-2.4557100067527503e-02,8.3146426105412202e-02,-2.7038110566468704e-01,2.2632211424813120e-01,-2.8285407973955717e-01,3.0444083288124212e-02,2.5363760874670604e-01,-1.9910828478088748e-02,2.3424492164577423e-01,-9.9507431329672796e-02,-1.3582187598358594e-01,1.5366422392521527e-02,-2.0344715892745405e-02,1.9903603467911610e-01,-4.9682450219793915e-02,1.7365898994622053e-01,7.7378944731149230e-02,-2.7913904701453474e-01,-1.3173303534494491e-02,-7.3497213104287973e-02,-1.7617107250225705e-01,1.8871961905921711e-01,-1.7124281290616357e-03,-1.0365014106138024e-02,-2.3621017254279252e-02,2.1359615558361097e-01,-1.4994929136099105e-01,-1.8254367459460294e-01,8.5959922747536249e-02,-3.1564102318882215e-01,-1.9351875572043215e-01,-8.0588847850081677e-02,2.7310267984025235e-02,-3.4008623257463799e-01,-4.3227638250009531e-01,-8.5916748172868193e-02,-1.1512938528710159e-01,1.0006829677869568e-02,-1.8161652001428016e-01,1.5712754609672855e-01,-1.2649111016920037e-01,-2.4004459200931061e-01,1.2626308636478514e-01,2.5124955395530273e-02,-1.5670587609618530e-01,3.0547527398476454e-01,8.3959011203277062e-02,7.4965847321302931e-02,-2.6669991069099214e-01,1.9394816686980093e-01,-1.0740866947202074e-01,1.0803376484779655e-01,-1.8049783961994634e-01,8.6538082354531420e-02,1.1046221425813513e-01,-2.1216174079543132e-01,3.4546450543906482e-01,2.1456808802869914e-01,3.4871473931264918e-01,-2.0876081385444858e-01,1.3267891721615391e-01,2.0573424125898332e-01,5.9947642389844846e-03,1.2401716236620582e-01,-2.6280712285209640e-01,-3.7792071090850171e-02,2.1230969679169776e-01,-2.8255114137354986e-01,-2.5748128027455364e-01,1.0448361473952589e-01,3.3882140022167273e-02,-1.1597205635827133e-01,-1.7916702061342016e-01,2.4572742963773528e-02,7.7976276700908759e-02,-1.1122090044796083e-01,1.4442157897147043e-01,-2.8043567287653337e-02,2.1228458573615930e-01,3.8970140767239719e-01,2.2984797591653847e-01,-1.4578618772112632e-02,1.7103105859850762e-01,2.0671410776996391e-01,1.6156230867790894e-01,7.7558103997904942e-02,-2.5210164785539707e-01,-1.4487096453715875e-01,-8.4695632432745804e-02,-6.1907016871634128e-02,-2.0498267098620470e-02,1.1673578885991956e-01,2.8946927605317835e-01,9.2258692407068771e-02,-2.2581300355019254e-01,1.2125850020185719e-01,-4.2135178106341944e-02,-2.1099256829248567e-01,2.1350714918434089e-02,-2.4755937116347554e-01,-2.5527886991429782e-01,-1.2407872461656537e-01,-3.3681307824362339e-01,-5.1625076414962091e-02,-5.9736586159400022e-02,-1.5754681764367179e-01,-2.1082798169133490e-01,-5.4173051692668860e-03,-1.8443704194425534e-01,-4.0614882400545185e-02,6.3814339591447920e-03,-8.2749523294190830e-02,1.2850628018001503e-01,-7.4347813806199092e-02,9.8442299858596122e-03,3.2624875770618555e-01,-2.0120658255495871e-01,2.8983040636111940e-01,9.9363793611849729e-03,9.9698422410705589e-02,1.0009076949863706e-01,8.5917192853540506e-02,1.4386799428116953e-01,-3.1078982482959022e-01,1.4862358115679621e-02,1.6529457340552942e-01,4.7265089623316364e-01,2.0154424023690741e-02,1.3284912261190804e-01,1.5969251107148280e-01,2.4596540700266850e-01,2.7172035907135079e-02,-3.6577033171379630e-01,-9.9238387009746173e-02,-2.2599738984365694e-02,2.3555194246961958e-01,-6.5260463808486338e-02,-6.7200478139379391e-02,-3.9316605555963124e-01,8.7114734737341812e-02,3.5488873336684845e-01,8.7053392490599291e-02,-1.0180229402625965e-01,-2.9472070214264963e-02,-1.1995120091862491e-01,2.1201621825205665e-02,2.6171368738243800e-03,3.5886891917466898e-02,-2.7353567919041144e-02,1.2991309077980903e-01,-5.2864808001176433e-01,2.7227185921739760e-01,-6.8138856411699006e-03,9.4798679288985818e-02,-1.2077675441164842e-01,-4.1409827234943061e-02,-2.7770106901790509e-01,-4.4036166060588675e-02,2.5792879478341690e-01,1.7417683798905853e-01,2.6433867479300627e-01,1.5046600333920910e-02,-2.3198484174237345e-02,2.5467547904538142e-02,-1.4423270644833056e-01,-8.3613125712598518e-02,-2.9339445163891222e-02,-9.0377011045223068e-02,4.5083932599889985e-02,1.7375897823262496e-01,-1.2404329572295493e-01,5.3938700817104834e-02,-1.8278533842916622e-01,-1.4365841284469819e-01,2.1767399681390368e-01,-3.0946991539432994e-01,-2.6623964671923372e-01,-2.9228609974426726e-02,-1.3122087772756388e-02,-1.3118846947920465e-01,-4.9194847451110559e-02,-8.5079910988685656e-02,-1.2521401598931198e-01,-6.1052767703212739e-02,5.9482404742202573e-02,-2.0709395575344658e-01,-7.2960389637730827e-02,-1.5384218620981580e-01,2.2051878681643558e-01,-3.4023201786970214e-02,-3.9917524385181216e-02,5.0841859193885341e-01,-3.1239020817027280e-01,2.2298992362901207e-03,-7.5188049287889067e-02,2.4133120827229293e-01,2.8133936320284153e-01,1.2654420139335459e-01,4.5230789234861857e-01,-9.9890310687253042e-02,-1.3176858550274109e-02,1.9802945777277220e-01,2.7926365926615480e-02,-3.3678978314186085e-02,-1.1898601954766265e-01,-5.1791142543241166e-02,2.6655799476487668e-01,-1.0576510679107494e-01,9.1134288217331064e-02,4.1920925704342346e-02,-3.5766740077249676e-01,1.7135507970399966e-01,-1.7864362903460906e-01,-1.4908209190501523e-01,3.6992418530433564e-02,1.5687156095573443e-01,7.6774924820329896e-02,4.0465451312643751e-02,-2.1032757166186047e-02,-2.5241568513347518e-01,1.9494770786717841e-01,-1.1455976691739526e-01,-3.3761605654097915e-01,3.1534348699644837e-01,1.3063380475266853e-01,1.5828110599374706e-01,5.6701264785921981e-02,-4.1800784461833185e-01,1.3042642340715091e-01,-4.5216626739101054e-02,-1.6595154486698516e-01,1.2745848188098197e-01,1.1836665678385092e-01,1.3453327321533737e-01,3.9256112921843395e-01,-3.9707200837686113e-02,1.0836480441546592e-01,-5.1737390614033339e-02,1.2961275794634911e-01,-6.4260685202955303e-02,-7.8761399456183129e-02,4.5497934858879524e-01,1.2934104257217721e-03,-9.5651316299182693e-02,1.5061057387868831e-01,-1.5061066991977962e-01,1.5778848586179972e-01,1.3719066218737158e-01,1.4614868134365938e-01,4.1018674344780903e-02,3.8254482678733964e-02,1.6518077216821569e-01,2.1039348075015843e-01,-1.0296719760783442e-01,8.3770479237194745e-02,-1.2776356939347572e-01,-3.1280048875118871e-01,1.3524247784345797e-01,1.0584757623219430e-01,1.3995962984151739e-01,-1.6194549810438369e-01,-2.6864345148583635e-01,9.1517212543009194e-02,-4.7412525408210199e-02,1.3326377821787469e-01,1.1907601497365167e-01,2.3110283148665804e-02,8.1026151957490161e-02,1.3638865336125910e-01,2.4395771894201368e-01,-1.6258752588040679e-01,1.5600497030969890e-01,-5.9009990689589065e-02,-2.7950616660822547e-01,1.5244963646472398e-01,-7.3634065545043009e-02,-7.9541912380351729e-02,7.1614283842974510e-02,8.8484757520378932e-02,2.7093126040907534e-01,-3.7828078246821750e-01,-1.8414116638656003e-01,-6.1479556790094023e-02,5.2527997253051406e-02,-1.3332536511113946e-01,-3.1922320257986936e-01,4.0962300892062731e-01,-2.3234697611326276e-02,-1.6561536321855935e-01,-3.3038808571190276e-01,1.9807691192097338e-01,1.4718451945773439e-01,-5.0096257717562188e-02,-1.4408337001481786e-01,4.2040741723930730e-01,1.6585656550122210e-01,1.8694866227783377e-01,-1.6054980494134091e-01,-1.2049735396037256e-02,1.7220686939280437e-02,8.2613311176194651e-02,-3.1175907747927178e-01,3.5952089315906474e-02,-1.3578503036891729e-01,-4.7618187043124753e-02,-2.8511793132128027e-01,1.2673183470782987e-02,-5.8961388233496441e-02,2.2077508029801229e-01,-2.7641469890932296e-01,9.2287238843075228e-02,-2.1529268348296762e-01,-1.7973550865458529e-01,-4.9349618871181104e-02,5.1267656013864078e-02,-2.6660389698858877e-01,1.1782611413855454e-01,2.6436252556089901e-01,-8.9637756524016898e-02,-7.4819310239975304e-03,-1.5674719629219486e-01,1.8491235033773612e-01,-1.4056893242899537e-01,-2.4754338016296429e-01,-5.8527819127993333e-02,-2.7209651675566035e-02,-5.1371528307133714e-02,-3.0856375459753751e-02,-8.9507797819064192e-02,-2.4106080159468801e-02,-2.6432687123043636e-01,1.2026975641303294e-02,-1.9463490560442426e-01,1.3501852931816732e-01,-1.4994002710052629e-01,3.0458530117647181e-02,2.1958772284654679e-01,1.6331873585643680e-01,1.8880704865327269e-01,1.6184196121010665e-02,-4.0108701679455494e-01,-9.2437179676225514e-02,-5.3826419059027783e-02,-4.3445672862066825e-01,3.3110534851371526e-01,1.4628441606650625e-02,-1.8607641314253581e-01,1.1084790720353237e-01,-6.7432611708655207e-02,-1.0607122963554108e-01,2.7700635100103155e-01,1.0981411413423586e-01,-2.1375096593080442e-01,3.6055843138473029e-02,2.8552499706711509e-01,8.1805919111015563e-02,-3.9043533973562888e-02,2.4408476678053495e-01,-1.2642679962541947e-01,-1.7919078792594437e-01,2.2904390882266154e-01,1.8305442499798014e-01,-4.7753973801240290e-01,-1.3675366044494888e-01,8.8963415082085773e-02,2.7554245490496720e-01,-1.7512181437924099e-01,7.3204517190071303e-03,3.0186983737311296e-03,8.6245189511825922e-03,-2.5669410762659434e-01,-6.6706362931016241e-02,9.0657089866165441e-03,2.0315172079794819e-01,-1.7465758063262202e-01,1.0938154252161690e-01,-1.9287060900518446e-01,-8.3167325729300690e-02,3.1149913378995514e-01,-2.0010737750416796e-01,1.9953356348225904e-01,1.0710387284003579e-01,-4.9128846449325685e-02,-3.9985661109892608e-02,-1.1763967772147184e-01,-3.9443906101226174e-02,-4.1910453564188327e-01,7.2286298605036770e-02,7.1322846881292951e-02,1.6232703151566169e-01,2.4828142327808958e-01,1.9288299156894279e-01,-1.5017481088202667e-01,2.2352440978661328e-01,-1.3038207438174512e-01,-3.8403614694460259e-01,3.4790742648984442e-02,-9.7239894377799424e-02,4.0586511372033549e-02,2.8852639115966167e-01,6.9096969453400089e-02,-2.3802256139813341e-01,-4.8164925607588664e-02,1.1130829538397431e-01,2.4646391526877784e-01,-2.8309201558067723e-02,6.2560060261909148e-02,5.8700921637864709e-02,2.4964792259212257e-01,5.2875422719926332e-02,-2.2710194845389506e-01,2.7485114170076295e-02,-8.4617857892469381e-02,3.7565564466934549e-02,7.3553124583231336e-02,7.5505862120953407e-02,1.0393086222337726e-01,3.0492379713600970e-01,-3.6736769791615237e-01,-3.4200645049391959e-01,-9.9776072084357167e-02,-1.1447480905142028e-01,1.5570350143770609e-01,2.7599066678645706e-01,-4.2800099306168189e-02,-1.5917934515693712e-02,1.6931883249453294e-01,-3.8698307876724597e-02,4.1647151522441295e-01,1.3055194293059885e-01,1.1599399750568579e-01,-1.8891743832269997e-01,1.3622426652585390e-01,2.0481674089496293e-01,-2.0239281055165859e-01,-4.9234956876703199e-02,6.6760745962874374e-02,-1.1056180700484669e-01,-1.0676115111968716e-01,1.0355369102074029e-01,1.0946772968312205e-02,-8.0539034053068073e-02,-9.5371693672986257e-02,-1.8405451015124591e-01,-4.0871782020270492e-01,1.9739527830150277e-01,1.6188245535218981e-01,-5.8966876777854310e-02,-3.4150627041204606e-01,-1.6250406154848487e-01,1.7986086343920862e-01,4.1276350070292972e-01,1.0801469781137649e-02,-1.7831525914157165e-01,1.3478336702917454e-01,-3.1232548584075231e-01,6.7119983229406446e-02,-2.0351574264265099e-01,3.1864821167749177e-02,-3.1992229874159078e-01,-1.4320137003590824e-01,-4.0590607932590311e-03,4.9284422063693330e-02,1.2074153610650467e-03,4.1249929530454206e-02,2.0372104704536230e-02,1.1240288768514309e-01,-2.8000386666391824e-01,2.8873147705864395e-03,-2.4024424850468414e-02,2.2192627658455011e-01,2.2367930306968853e-01,5.4530696627435660e-01,-8.8445988663677103e-02,-8.6356278059075128e-02,-1.5072380328891366e-01,1.7580122228587797e-01,1.6639357441625646e-01,-1.8847811695752226e-01,2.6712441754773553e-02,-1.1204115651096205e-01,-1.7017796639707647e-01,-2.6779979567468493e-01,1.3379834082492101e-01,7.5330228665142676e-02,-7.5293264406977034e-02,2.3060967592375131e-01,-1.1119716203505402e-01,-1.8801994314309417e-01,9.6866445633594755e-02,-1.8901463695275839e-01,1.8142814343525226e-02,-8.6356231071878675e-02,-1.2599061767148326e-01,-2.6694531249457093e-01,-1.4552072810540960e-02,8.9028010107923161e-02,-2.6146457080543850e-01,5.1559003746531488e-02,1.4049619250866138e-01,-1.4218521425384181e-01,-5.9169962425119967e-02,-2.2026135267335328e-01,-5.2263788842303323e-02,-3.3767485135147601e-02,-1.2553334779525629e-01,1.7720288549188934e-01,2.9277516949694532e-01,-2.0275487186512275e-01,4.9699684977842312e-01,4.0445157666771210e-02,-1.8156997293113161e-01,-2.7368944269066196e-02,-2.0190154006960717e-01,-3.9513604661669127e-01,-1.1812059763567309e-01,-1.8362081428819916e-02,6.6224367990632249e-02,-1.5231114837247279e-02,-7.7203301086718065e-02,-1.0078454969696697e-01,6.5593752091436294e-02,-4.2448147885256714e-02,2.1472379979539666e-01,1.2685910601144041e-02,-5.0439937276795813e-02,-2.9991967042638390e-01,6.5817675082931418e-02,-4.7495146453451154e-02,3.0910119474799885e-01,2.8571468522318033e-01,-2.3545012197424833e-01,-1.0156547839551247e-01,-9.3276733234632092e-02,1.7308114424360050e-02,-2.2534997956674344e-01,-8.1252653755568872e-03,-7.5938285951382772e-02,1.5156678012700231e-01,-1.8558930798675241e-01,-7.9385521146652260e-02,-1.3694536127921278e-01,1.9881347190738842e-02,-5.9575529890663018e-02,2.1093519994827536e-01,-3.7907770327291768e-01,2.4021927575229993e-01,3.8453120296446858e-01,-6.1326936275238289e-02,9.6213122912431025e-03,-2.8464421438618957e-03,-2.6815756146625502e-01,-1.9375870581142318e-02,1.5326073461255388e-01,-1.3139794271986321e-01,1.7064344929261316e-01,-2.4221790015212227e-01,1.0347883655793173e-01,9.9268018215108347e-02,-2.9545874982437886e-01,2.6855653309534694e-01,-2.4622844130467426e-02,-8.9050338750844976e-04,4.6242984437818169e-01,-1.4532090190136560e-01,1.1897932140018314e-01,-2.4084300024833799e-01,-8.2403259513958438e-02,-2.2324700599205352e-01,1.3938711155667455e-01,1.5224963401219910e-01,3.2510243446182543e-02,-1.2109886359142502e-01,9.5153755033480211e-02,-4.9127657601898578e-02,2.0848015704481931e-01,1.7803687579976105e-01,-1.1145579619758239e-01,8.7729484028323604e-02,1.1270018220880981e-01,-4.7066133083710643e-01,-4.2687891733403288e-02,1.2573081199124228e-01,-1.5952668188592892e-01,9.9540003327369148e-02,5.1023602263281197e-02,2.7737369853509386e-02,7.8333578140406257e-04,-1.8338551202080214e-01,-8.4299962796882233e-02,-8.0731466368283933e-02,1.9903575722922104e-01,1.6343918740739186e-01,-1.5368799370814045e-02,1.0212549559945215e-01,-2.0648202902593837e-02,1.1026713352253494e-01,-1.2394612336655056e-02,-5.3437541774780585e-02,2.1649870480229049e-02,4.2552958368826865e-01,1.2266686640344207e-01,2.0611065166406173e-01,3.3984928444238871e-01,-3.1467420166873816e-01,8.1766981635246122e-02,1.2085215388088251e-01,5.5391087001392926e-02,-2.6937495855456700e-01,-5.2643707597727595e-03,7.0746288096996637e-02,-2.1026334177506351e-02,4.7079859684231191e-03,3.4363110598101820e-02,-3.1627561641389845e-01,2.7513447424618448e-01,3.5670404506366038e-01,2.1264416326349578e-01,-2.0825746239711643e-01,4.1803291103418161e-01,7.7439020883387083e-02,4.1330726835657153e-02,1.6583542742953158e-01,8.0274695442266536e-02,1.0970815752915095e-01,-2.8920738191968043e-01,-1.9135557133745654e-01,-3.4730922541326886e-01,4.9485221696242539e-02,1.7723884008113844e-01,-1.2903969526199652e-01,-1.6655076149411674e-01,-3.7578325268275808e-01,2.1977347298390035e-01,4.6536790204701306e-02,-7.9496804049809688e-02,5.9248595669510101e-02,1.3312987107484311e-01,-2.0680198497469690e-01,8.2418698252318373e-02,-9.1893785995460359e-02,1.7793263346990773e-01,-2.4599492822949869e-02,9.4103924934068217e-02,3.5834653764501359e-02,-1.4343327251751084e-01,1.5370095780253681e-01,-9.4181737827146894e-02,2.1939549378446497e-03,1.7854582519083201e-02,2.5138491037386357e-01,-9.0705741408261903e-02,-2.9203338685980312e-01,6.6086410472044152e-02,-2.9099189929563457e-01,5.4310919477780925e-02,-4.6816267992838251e-02,-2.6674018650776447e-03,4.5531987908778264e-03,-1.7811387389126135e-01,-2.9089015917330385e-01,5.2528008427277076e-02,-1.7182396465520819e-01,1.3113184744762041e-01,-3.6423776435853711e-01,-2.3102442867314296e-01,-2.3934452804822398e-02,-3.2544536865032075e-01,-3.6421223458381025e-01,-8.4327465106438959e-02,2.2619005442785534e-01,-6.1114626611877512e-02,-1.9792056378778698e-02,-2.8514703234161477e-02,1.6825088653837481e-01,2.0375112946236440e-01,1.2590733535144105e-01,7.3601623035836436e-02,6.4649811358133843e-02,-1.1398980734207767e-02,3.2118162061172401e-01,6.1533359497449355e-02,-2.5158918366984090e-01,-3.4836475121428956e-01,-1.9497293891058809e-01,1.8308368326567270e-01,-1.5467626102399523e-01,-1.7104630229625062e-01,-7.7600331412541690e-02,4.3050934015047226e-02,-2.1461928865067315e-02,9.7866952224651124e-02,-8.4160986437869595e-02,-1.9928998602023068e-01,6.8284249833588981e-02,-2.7327874146464391e-02,-2.5492718037839257e-01,2.6348586303019239e-01,1.5063225150047471e-01,-1.7185970563931383e-02,-6.0528427377873763e-02,2.5076236244452904e-01,1.0259927157191794e-01,-5.8876618987629373e-02,-3.9448500633282474e-01,1.1513924511360703e-01,3.1148601808611898e-01,2.1150358662340094e-01,1.1165350821229962e-01,5.2890584321001362e-02,-1.3614461916913245e-01,-3.3943689339273692e-01,3.1936025240609139e-01,3.1884569873635735e-02,-2.6786282274646001e-01,-1.5729533235185755e-01,-1.2602635543983740e-01,-6.0852370010479065e-02,4.3016053021061575e-02,-1.6115195521532807e-01,-9.7131289292172792e-03,-1.7107602417298373e-01,2.6999715075496761e-01,-8.3415087550462921e-03,-1.0966424260267295e-01,-6.4638206124161046e-02,-1.3191874821340207e-02,3.4988667168276831e-02,1.4724642982736151e-02,1.5331126237903708e-01,1.4775077831354719e-01,2.9525867155835289e-01,8.7794321675626327e-02,-5.1224806018520153e-01,-6.9224033206270560e-02,1.5500708607722005e-01,-8.8076498771403888e-02,7.7547334608918703e-02,1.4012912254198848e-01,-7.3309483631191497e-02,1.7877870394165207e-01,-2.4026936755673040e-02,2.4512541266205345e-01,-3.0716175102727300e-01,2.5773621889364086e-02,-2.7523552030694350e-02,4.9696433781324371e-02,-1.6002254828986925e-01,-1.5850352613774116e-01,-2.0652301555001935e-02,-3.6717694107390353e-01,-1.5700941366004706e-01,3.0788146310353903e-01,2.2483335440942204e-01,1.2154261891298311e-02,3.4618647262219415e-01,-7.9469875303837534e-02,-3.1289468632490821e-03,-7.0752301553969735e-02,-2.5486591568964723e-01,-4.8010470671366733e-02,-2.5413722859572335e-01,3.1190104801162682e-01,6.1713138209563589e-02,1.6175456609877689e-01,-1.0696956256352903e-01,1.4238104439964294e-01,3.4196985830854332e-01,-3.1124000122303863e-01,1.3484658442233649e-03,9.1915170152797640e-02,2.6052842080533589e-01,-2.4507264425556663e-01,1.0084401154820573e-03,-9.9120143785245265e-02,-2.1761340362732057e-01,1.1528376220270302e-01,3.6431202533537377e-01,-3.4998252408696758e-02,-1.9905657622712497e-01,-2.4810748395494231e-01,8.2794584138925098e-02,1.9426578132499661e-01,-5.8038972664262514e-02,-1.5338919413187996e-01,1.7948834901462982e-01,1.9482521067897993e-01,4.4342344611756665e-02,7.1568572785786780e-02,2.7434892548188716e-01,-6.0147758635287291e-02,1.2568954966298690e-01,-8.7194050354369636e-03,-5.1235746246664229e-02,5.7509224124804668e-03,-2.9544910624967097e-01,1.0363495882531772e-01,-3.2961965769308449e-01,8.8056233209459184e-02,1.2299782433138756e-01,-8.8087215506754218e-02,3.3759802920539650e-02,-1.4070098952218976e-01,-3.7983167779187738e-01,-1.3190316800088339e-01,-2.8004921690283391e-01,-1.4453717489436405e-01,7.1956493467349003e-02,7.7035323952481402e-02,-6.4715776599407013e-02,-7.3326295590007452e-04,2.4070555934634247e-01,-6.6201626751886174e-03,2.7952193995526947e-01,2.5096756137852366e-01,-7.7437732641827767e-02,4.4624093160862710e-01,-3.4783055320062109e-02,7.7300495000161534e-02,2.6202449764898654e-02,-2.5798101907832527e-01,4.1360070908253957e-02,1.5756663305727867e-01,-1.0938511100868339e-01,7.8340924194085712e-02,1.9577163166332379e-01,-4.3151805620063988e-02,1.2080942684224198e-01,7.9119607075263443e-02,-1.9614124635906152e-01,-3.9162832135864978e-01,6.0619881629565928e-02,-5.9203810990006732e-02,1.3189479791460026e-01,-2.2375825462283727e-01,-2.3648063238903377e-01,2.8346532923364674e-02,-2.5718324612114885e-01,-1.6725836610371039e-01,-3.1943272207256312e-01,-9.6001258455561581e-02,2.0814150175200952e-01,2.4079478167226068e-03,7.7959101479876695e-03,9.4041271538485571e-03,-2.1252048000370832e-01,-1.3911576674931420e-01,1.8401761072403169e-01,-1.0729637689954116e-01,-3.1432225157556370e-01,-3.0196844667872363e-01,-1.4553660026740675e-01,-2.0608415311289985e-01,2.0792901142624831e-02,-1.3357883648883828e-01,-1.5858120819663205e-01,1.1348476763776899e-02,6.2656767271586422e-02,-4.5613285301499093e-02,-5.4325900548613831e-02,1.5531959034265241e-01,-4.8341126802161460e-01,-1.1755032828545407e-01,-1.4720101744164599e-01,2.2526849121870976e-01,7.4192454047813133e-02,1.1278594692040342e-01,-8.6504358327211553e-02,-2.1186031365193853e-01,-2.3142531434412736e-01,2.2612723407211580e-01,2.4444646750135571e-01,3.0471454545082963e-02,2.9016839688722335e-01,1.1384739029574759e-01,-1.6164720466611521e-01,-1.6223866671686549e-01,1.0277825707350806e-01,-1.7102586833671357e-02,3.7522016753932874e-01,1.7178477867889896e-02,-6.6203358743936458e-02,-6.5286646606916701e-02,-6.8720738981317663e-03,2.0129623018198731e-01,-2.3390161290116412e-01,7.4557846354369794e-02,3.7366623622192713e-01,2.7978066187013118e-01,-1.6008030426110620e-01,-1.9215707739473900e-01,2.4321372748950065e-01,2.2181843848507243e-01,-5.8255021991489991e-02,5.3630664143088237e-02,1.7867983373629609e-01,-1.4042671454179889e-01,2.4453704527704051e-01,4.4627405147967411e-02,-2.4523451158858589e-01,-2.5178279981002534e-02,2.2807385021850610e-01,-4.3406513198988889e-01,1.2490215410926954e-01,1.7237186730711335e-01,6.8508443909645028e-02,-4.2162798414612374e-02,2.8286471359087052e-02,-7.6709244628745121e-02,7.4193873235833152e-02,2.3682584198828024e-01,5.1212442752719183e-02,2.0956874877180789e-01,3.8945296977092841e-02,1.0919500595496773e-01,9.4264455761821353e-02,3.6777574426497497e-02,2.9229268305663819e-01,1.8433885657794485e-01,2.4549957549072979e-01,5.1806883898556103e-02,-1.0861923995984281e-01,-1.6720862672343344e-02,-4.3244674658796466e-02,-2.7163946080268425e-01,2.4385670435715082e-01,3.1855696015619972e-01,2.9417947204794709e-01,1.7753468615154391e-01,2.3205220745391178e-01,-8.7335472852145563e-03,-2.9713743422169470e-02,9.3023630047956579e-02,2.1542139747194111e-01,1.6077721613665011e-01,1.7995059032486698e-02,-8.5646695629235506e-02,1.0483448256336896e-01,-2.6506519941236484e-01,-2.7020612296380749e-02,-3.3610906411551583e-01,6.3875197037897456e-03,-2.7674763114232015e-01,6.1926795533699369e-02,-5.8317616910254933e-03,1.4982849504733411e-01,-9.8066870491918784e-02,-4.9508918493196344e-02,1.6954057836613035e-01,-3.5266686386480423e-01,1.8068768104322963e-01,1.2554572113046852e-01,1.3824755455083929e-01,-1.0298803937975699e-01,-1.4238514182887493e-01,-1.8277551761626837e-01,1.7365214251458086e-01,1.2844066508584534e-01,-4.2373962755420776e-02,3.4805030318059571e-01,4.8353363322005405e-03,-7.5245148986456845e-02,-8.3445996661247857e-02,1.7851614563929072e-01,-2.4258222965478687e-01,-4.5360514882247382e-01,2.0870791693131330e-02,2.1738444932421164e-01,2.7704154493394570e-02,6.8854558267235008e-02,7.3489349593506989e-02,6.5555830033075371e-02,1.9517564668573098e-01,7.8582026564501278e-02,-5.5639516157505051e-02,-2.4891395201556538e-01,-2.4838292504105156e-01,-3.4784832369868936e-02,-2.1684828638920151e-01,1.3290093347918036e-01,9.1110983636911391e-02,1.5963964352150528e-01,3.3537596418624882e-01,-1.5979503016035904e-01,-1.6596518466874609e-02,2.4434677636318314e-01,-1.4744365627229813e-01,1.2179275533858452e-01,-1.8186828900615210e-01,-1.4232936612374431e-01,-1.1991309202473507e-01,-1.2880805386023372e-01,-5.9165489914435661e-02,-1.0462959886367060e-01,4.7149648984061883e-02,-3.1257249828654354e-01,5.8822787037671534e-02,-6.3112046503639149e-02,-3.1339453561931005e-02,2.3637124874734489e-01,-1.6012507390508091e-01,-5.1549394346638155e-01,-8.8668196820236328e-02,-1.9563968368569884e-01,-2.4765867126463811e-01,1.1323176474633337e-02,-6.1684849153501503e-02,1.5166947055997401e-01,4.3270975806538485e-02,1.3052889996611242e-01,1.4116883281941502e-02,1.2078354048983016e-01,2.0660017793466423e-01,-1.6972274779768201e-01,3.4571043311614646e-02,-7.1345086987346457e-02,4.7173934155059133e-01,-1.4157502979782771e-01,-2.5719387122345233e-01,-7.0650692358232736e-02,6.2006363798412532e-02,2.0292040467667652e-02,-1.4748025520711630e-01,-1.6026609870847122e-01,-1.9156001497871730e-01,-1.5167309368578663e-01,-6.5528049854035181e-03,-2.9618826906301177e-01,3.6188550899062327e-01,-1.8439894396410375e-02,-1.9469125592138303e-01,1.6951108809938395e-01,-5.9233335917129842e-02,4.4526571081978591e-02,2.6206416974310581e-01,2.6326376587057060e-01,1.0593741060967078e-01,7.5885911886950666e-02,-3.6676107565607262e-02,3.8628685126880870e-02,1.2940211462304649e-01,-1.1611172693579377e-01,-1.3070336819151895e-01,2.1680382527060943e-01,-1.0328414313234542e-01,-1.9189006523669946e-01,2.9825937271771669e-01,-1.1703096941885935e-01,2.0431092801732856e-01,-2.8384708349197230e-01,2.8148963629120810e-02,-1.9321798104335183e-01,-1.2600974998172768e-01,-1.5060470396153065e-02,6.6495114218966561e-02,5.3721109952621131e-02,5.2120288844895571e-02,2.8010693615926724e-01,1.4570414096201234e-01,1.5941119183800062e-01,4.8597619949059576e-02,-3.3582227045248064e-01,3.3542807054737706e-01,2.3059219257610711e-01,-1.5367150204973323e-01,3.4273238551150320e-01,-1.1564405535990431e-01,-1.4811105660944746e-01,-6.2618912319552765e-04,2.4157023808695269e-01,-2.8271018739816878e-01,1.9821259399825375e-01,-7.0934581393846952e-03,2.5772195378755657e-03,-2.5350092283332720e-01,2.0227742348472677e-01,-1.7105916440496381e-02,-1.7980719216782554e-01,2.4109400057560285e-01,3.3119970644893068e-02,1.2152706659700073e-01,1.3526095678465905e-01,1.2955540237656607e-01,-5.2076340945158471e-02,-2.1930248490581752e-01,-3.2673107812948368e-03,-3.1339099724467201e-01,-7.1675871331111626e-02,-5.9338989855841337e-02,3.2713217855388749e-01,-1.9298804567223524e-01,-4.1527530810734160e-02,4.1153533849055141e-01,8.0750291968936738e-02,1.8164918077053260e-01,-2.0222043181668373e-01,1.0837997682421739e-02,9.1350314023019588e-02,7.1744829369409166e-02,-1.6357090926482365e-01,-5.9110183518322749e-02,3.2326228924830286e-01,-3.1223959660222239e-01,-1.0622034210233854e-01,1.8464695101019984e-01,1.7574266883947301e-01,-1.3618686847238742e-01,-1.2587128596751190e-01,8.8843896598025301e-02,-2.4251436523030370e-01,1.2181830587990788e-01,-6.0288604377542365e-01,1.5172818033566116e-01,2.1618920166336561e-01,1.4064162700807299e-02,-1.8557527398216384e-01,-1.2818739412382298e-02,4.5968599092428036e-02,1.3660004385195421e-02,3.7072183492937734e-02,-1.1126978697035358e-01,1.2444271053325862e-01,-9.9032048355680372e-02,-4.2140634600112151e-02,2.0401116730547131e-01,8.2114528588949090e-02,-5.0480604883063600e-02,1.0667262447004182e-01,-1.7708694411442938e-01,-2.9052341698082246e-01,-1.9336839305534997e-01,-2.1631224267002727e-01,-2.9497703803689788e-02,-1.5353525961335535e-01,-2.0038625087684361e-01,-6.3599306933272801e-02,8.1556161769615915e-02,2.0218621098975223e-02,2.7473060297747898e-01,9.0801594619516257e-02,5.9517757046692835e-02,-2.4374965281304722e-01,-2.0280824418931923e-01,1.6143164861678957e-01,1.6673879773116276e-01,2.1202979156691712e-02,-6.4066599415405351e-02,-5.0912398702908013e-01,1.6584801964081308e-01,2.0741375921859630e-02,-3.3131832925390958e-02,-6.8180665575642840e-02,1.6974017040788568e-02,3.2183114906686273e-02,-2.5479138887942299e-01,-1.9933098088770765e-01,2.6054177059934969e-01,7.8844502426519539e-02,-3.7625529329943835e-01,-1.8650214586513791e-01,-1.9434563745356145e-01,-1.1256023671356453e-02,-8.9910611163480536e-02,-1.6965637854355520e-01,-2.7257269346633606e-01,-8.7924425240618234e-02,-1.5668788823273876e-02,2.8753924653148751e-02,-1.9558671282963092e-01,3.0652030350543319e-01,1.4693042579463705e-01,-9.9297551990009184e-02,-8.6181747850110207e-02,-2.0836253862050882e-01,1.5074765763392031e-01,3.6342579239906143e-02,-4.5549501045634391e-02,2.5525081061310190e-01,-1.4563119418351667e-01,-4.8083589264434623e-03,1.3549369069720690e-01,-1.8939003071484273e-01,1.6867151358447005e-02,-1.4111124351920404e-01,4.5360170826018531e-01,2.0102106519148594e-01,1.0943886007500137e-01,1.5182077119799467e-01,2.7428240282642603e-02,2.8996325243225202e-01,1.6546785169403935e-01,8.1827297134291294e-02,-6.8577302655604189e-02,-9.7023541995276338e-02,-1.7076014863667921e-01,-2.8718380938166777e-01,-3.1270509281292441e-01,1.9397968941562685e-01,-1.1401375708071718e-01,-5.6680414123539254e-02,4.0852138286180012e-01,-1.9839171968832989e-02,-2.9931473045825926e-02,1.7686427911555605e-01,-1.4532796819092367e-01,1.2385378040789170e-01,-3.1816304262484857e-01,-1.1115997394778707e-01,2.4092295047579149e-01,-2.2103844529949074e-01,1.0150209776875520e-01,-2.0894483097478989e-01,-8.3107798434468083e-02,4.4779959131354109e-02,1.2711719457844755e-02,-5.8648614813347787e-02,-2.4039438304598976e-01,3.2998638845660444e-01,3.7038533375000127e-01,2.9691839557290101e-03,6.1666926241526580e-02,1.2386025768513464e-01,-1.1011195666722408e-01,-6.9588661372937288e-02,-1.1155651882625087e-03,-8.9438477543535261e-02,-6.3574571810685751e-02,-3.4534706630066847e-01,2.3102103991300521e-01,2.3461954904859439e-01,5.7761069935227644e-02,1.7512991063953673e-01,1.9643711576868136e-01,-1.5769984606678505e-01,-6.6075728935603706e-04,-7.9100916480958308e-02,2.7628292631071061e-01,-1.0276587652978253e-01,5.5330627539332933e-02,1.8566995580277132e-01,2.3147322021613104e-01,-3.5586830972418459e-01,-2.3128117011423963e-01,-3.8323270360176284e-02,4.2795167223666102e-02,-3.9851893078054069e-02,1.0643947696632033e-01,1.7081715487849736e-01,-2.6214945408425355e-01,4.7742376990942748e-02,1.6937986207392411e-02,-2.4409343755931089e-02,-7.0569313873823994e-02,9.0078952135868126e-02,2.4257595131374390e-01,1.8092624163073137e-01,5.9037699362248813e-02,1.5855467335918874e-02,3.5968904821826542e-01,1.0392138630502072e-01,-8.5452715147127392e-02,2.2017804024119803e-01,-2.2560110172376753e-02,1.8664799697297990e-01,-1.2832575010614064e-01,-1.9913651564643747e-01,-3.5000739408147477e-02,1.4005441849093905e-01,3.0161486701267559e-01,-3.8597806308512289e-01,-5.0886420437244270e-02,-1.4025004996311644e-01,1.6964724186097585e-01,-4.2443315179343705e-01,1.0027010358596058e-01,4.8164134259451059e-03,3.2428007346655990e-02,8.2521816717016527e-02,6.3283522582719381e-02,1.8810431429535801e-01,-3.7429719982218401e-01,-2.5199965225667276e-01,-1.5524599004493672e-01,-8.1958587607347227e-02,-1.1752913538591221e-01,3.5108852457482742e-01,-8.8158190853619145e-02,-9.1879436055958136e-03,-2.8587493940391562e-01,8.7540715440193109e-02,-8.7807018806247708e-02,-1.2823801193301174e-01,-1.1891428099303517e-01,1.3731125132139935e-01,-3.4519152521985874e-01,7.4442153436581324e-02,3.6773279981246387e-01,1.7786469069327915e-01,2.6448754837359595e-01,-3.1821012405282165e-02,1.0902126607094910e-01,-5.0626696419805745e-02,5.2347090410698321e-03,1.8960698612782462e-01,-8.3653426893328733e-02,-8.9153910949790527e-02,-3.0623851613235872e-03,1.2921805629095021e-01,-3.7671803428683714e-01,-9.4153994792790935e-02,4.0452467886810242e-02,1.6043575667394361e-01,3.2430921456251663e-02,2.2714334822150149e-02,-1.9556243403416468e-01,2.0475832550986356e-01,1.1062175005134046e-04,-3.4518383566391192e-01,-1.0868189144182316e-01,5.6519144696132187e-02,-1.3051753182316289e-01,2.2162446786883575e-01,1.7717803694747561e-01,2.5992206621117880e-01,2.2934791314568503e-01,1.2361345335150500e-02,2.6758805655472707e-03,-1.6490730179634938e-01,1.0786367003194844e-01,3.5932199204040796e-02,2.0645138218831915e-01,1.6128413387916987e-01,-4.1975736802285571e-02,1.6455495310130311e-01,-7.5391158901321254e-02,1.3659923764120546e-01,-4.5765300927276353e-01,-2.0224849744659165e-01,-1.0549806702979739e-01,-1.8158927567308056e-01,1.6565242851076764e-01,-2.8827653767708315e-02,3.5756110700054855e-01,-7.4300713754336861e-02,-2.5223853179828687e-01,8.5086387200746960e-02,-1.4365860910219000e-01,-3.0083527585488309e-02,3.8627231307421434e-01,-2.0254980236789552e-01,-2.1969200003938118e-02,4.3853594528292884e-02,-4.3942723322034555e-02,4.4738570728725516e-02,-1.7382121766411585e-01,1.2402710129237939e-01,4.6168454943648268e-02,2.6580475916465846e-01,2.3998035338711227e-01,3.1892752697924201e-02,-2.6269588930235583e-02,3.1821427885902684e-02,-4.1184443879587479e-01,2.0776280776212289e-01,2.3643618894296170e-01,-1.3166111754237556e-02,1.2970602454102365e-01,-2.4698859240038680e-02,5.2713932550533187e-02,5.2727280529347359e-02,-1.0925299360161976e-01,-4.3372103148696384e-04,3.1951184906121366e-02,3.0758641507494844e-01,1.0905659141239737e-02,-1.0149440400083119e-01,-2.1925483007430457e-01,2.3905179508481272e-01,-1.2007173066552389e-01,1.6219635680100544e-01,-2.3387494819171151e-01,9.8094311465684626e-03,3.0467805683019894e-01,1.5660027658661058e-01,1.7945082777296895e-01,-3.1645322352946526e-01,-2.1105739586334024e-01,-1.3862065446447955e-03,3.0036948189662693e-01,1.1521233521477871e-01,5.4621346693541982e-02,-2.2574540866552195e-02,1.0665737392912503e-02,2.7488300515000824e-01,6.4639217458322074e-02,2.2962381033416768e-01,3.7589089192311681e-01,4.4133300806714786e-02,-3.5156612629241746e-02,1.7014456674093348e-01,1.8972444842579142e-01,2.4488135922751193e-02,1.1405133403523225e-01,1.5695647871328250e-01,-2.6797949984017566e-01,1.8880220291925379e-01,6.6847597129422592e-02,2.5877391076827676e-02,-3.4173744310870689e-02,-1.9701337205862243e-01,3.2011036498507900e-01,-6.5715201891447972e-02,1.5029165130767966e-01,-1.2075114648272607e-01,2.9558996053037312e-01,-2.5853920698788146e-01,3.2470502669168960e-01,-2.0048470588248348e-02,-4.5193491742680093e-02,-3.2809256928168418e-01,1.4574143329281167e-01,9.5372028499770542e-02,2.0431868807531545e-01,1.1362137377341118e-01,1.0097723410746814e-01,-2.9896925041243161e-01,2.0683821402682681e-01,3.1855190929798560e-01,-1.6385525548019830e-01,-1.3997452469286412e-01,1.2262499255288713e-02,-2.8214501293412642e-01,4.2075821922374891e-02,-1.9955317030780834e-01,1.8913714484805239e-01,-3.1921448870531700e-02,-3.2319633646423368e-01,8.0063861880508166e-02,1.4738698024146091e-01,-1.3703940703635668e-02,5.2740362979755186e-02,8.1529247145920941e-02,1.4910276977603132e-01,-2.9272838449679583e-01,-1.7785192627788232e-01,-1.8968400389064419e-01,9.4441223957622000e-02,-9.6767056518734851e-02,-1.6577633679739281e-01,-1.0524254830711456e-01,-2.6282509861079428e-01,5.9378341253832199e-02,1.7706153889730283e-01,4.0801335093415464e-01,1.9593222226233893e-02,1.5327912124845527e-01,-1.5829554152025210e-01,1.1231498596311129e-01,-1.3537061617626950e-01,-1.3348822518898193e-01,2.5432899349049649e-02,-1.3741060329002072e-01,-8.4770194725280454e-02,-2.8089617403033902e-02,-1.0209041611043122e-01,3.1228798556485454e-01,-1.8101013469197266e-01,1.5635940196740628e-01,-8.4195273849345456e-03,-5.2289477007450666e-02,4.3855748878623207e-01,-6.2014128886152577e-02,3.1422403685222713e-02,-7.6739756058524719e-02,-4.6587687511695890e-03,1.0611471016559210e-02,3.2210719622908279e-01,-1.0640145267166742e-01,2.0239182667156955e-01,4.9242769865430747e-02,2.7880651801168427e-01,-3.2797675244666558e-01,1.7020653675227429e-01,-8.1674563057079014e-02,2.8798477259907979e-01,5.0994049015713326e-02,2.9604748852946638e-01,-7.2450769817942767e-02,-1.7562821268067677e-01,-4.8562081785953427e-02,3.1806514098956969e-03,-2.6483246887843198e-01,-1.2387203149109095e-01,1.1647949619613025e-01,1.5048361048432457e-01,-7.0741679843636371e-02,-6.2129031451030207e-02,1.3176472191036434e-01,-1.4007266904377622e-01,1.4012287974485127e-01,-1.9930028196459545e-01,4.1487051997121671e-01,1.8822516067036160e-01,3.8847509772837596e-01,5.4648646790760334e-02,-1.7146239296822521e-01,5.8506326257813310e-02,-2.7441795955583220e-01,2.8556019165825425e-02,-2.3533012095882955e-01,-2.4335169259221589e-02,9.1440128551114455e-02,1.5342612162941804e-02,2.9312521858198243e-01,7.2923045973587480e-02,2.3648178095416725e-01,2.2917373426539156e-01,-8.7045424830589593e-02,-1.1452398032542274e-01,1.8849045921930954e-01,1.3872876053815317e-01,7.4175164183170411e-02,8.3909804101997817e-02,-4.2032213961191017e-01,-2.6566295371740267e-01,7.9379315420654489e-02,3.6526562303089698e-02,-1.9820350813313559e-01,-2.0576395388670668e-01,1.0206388429541519e-01,1.4294834357007483e-01,1.4019650391763755e-01,2.2538152594506516e-01,-7.8003818152976787e-02,-3.3182057958632016e-01,1.0471499175883064e-01,6.8107445262538827e-02,1.0966858301880741e-01,-6.2293580049922956e-03,-1.8947412232864960e-01,-2.1837645115415558e-01,-9.0148527833897471e-02,-8.8506514050571607e-03,2.2028886851639573e-01,-2.9122271605456651e-01,-1.5711958234166579e-01,2.8373099651993566e-01,1.5426995525342124e-01,2.8315427077473559e-01,2.0808545762345557e-01,-9.2624207129630459e-02,-1.8256876989330759e-01,-1.7967553623370849e-01,1.3265962229490930e-01,1.1604259952352938e-01,2.7649550016477042e-01,1.2602910465193351e-01,1.5879856668980963e-01,4.7764156808207288e-03,1.1958962414159557e-01,-2.3669341697304266e-01,3.0896116492531006e-01,-2.2065035146697010e-01,-1.2363272962607050e-01,-2.1290986835195133e-01,2.1680572030846890e-03,-1.2398275948532514e-01,1.2272494744890736e-01,2.1067555487272760e-01,-3.8558408731021697e-02,-1.3252703758498605e-01,-4.3959094683841127e-02,4.6130190581350580e-02,-1.5883840748788300e-01,1.4199000628113520e-01,-4.1605267524862882e-01,1.9592272219376344e-01,7.4897206359700833e-02,2.5000153034156136e-01,-4.6138726059907786e-01,1.5989302367667713e-01,7.3012624326216177e-02,-1.0805650342244882e-01,-2.3995125399274009e-02,-8.5306635870153802e-02,1.6161515811443045e-01,-1.8827453762638660e-01,-8.6312739814893624e-02,-2.6463864883320926e-01,-2.1783039097795473e-01,-5.9531074589672252e-02,2.5047866326203255e-01,-3.2072819766680166e-03,-5.4714872891793789e-03,-2.4645342843349605e-01,-1.0874688680854522e-01,-2.9481599369414614e-02,2.4222208912256052e-01,-4.0415599742659875e-02,9.1314311684946789e-02,3.0034427662633650e-01,2.6015184810369602e-01,-3.0060403790819690e-01,-6.1089331499259159e-02,-7.3630697300968606e-02,1.2346416936020894e-01,3.2228762825721249e-02,2.1600237747218609e-01,1.1974842646347154e-01,8.2335010512161827e-02,-1.8594934539891245e-01,-3.9337911471562026e-01,1.4670997552171475e-01,2.6122309147414362e-02,-8.7634626790253814e-02,1.3500707372173465e-01,1.2702229312629029e-01,-8.1477375231482602e-02,3.6646778965798626e-02,-1.6198080854434074e-01,2.0692313959193565e-01,1.8861046703160115e-03,6.3763880992743042e-03,-1.7460281362386096e-01,-1.2218883123397355e-02,-1.5427587453204578e-01,-2.4029775603544007e-01,-2.3569083741910973e-01,-4.9484917084538727e-01,-2.7198584831610201e-01,-8.3795142702420521e-03,1.2292372667848177e-02,-8.4320560735167804e-02,-2.0808060032615028e-01,-1.2034386137793250e-01,1.8902713950360131e-01,1.1894212665250778e-01,2.1831396032436798e-01,4.3012592753420664e-01,-8.6996545073049020e-02,-7.9958675977753288e-02,-1.5744002533073474e-03,-2.1475352040662468e-01,-1.6612582771704720e-01,7.7415006721054794e-02,6.0524193387976724e-02,-1.4899212561778677e-01,-1.6898734880933003e-01,3.8623076283978769e-01,-1.3659791507089913e-01,-1.4998971862437915e-01,-1.0083060787961981e-01,4.8125654487798451e-02,2.6011830283642784e-01,5.3561762876449252e-02,2.3132966015974735e-01,2.4498178986144309e-01,-1.1281131093895042e-01,8.7611633602583006e-02,-5.2991362785661980e-02,-1.1866327206923509e-01,-4.8976559850964572e-02,1.7039559315933592e-01,-4.7287105170355781e-04,-3.5783702028155978e-01,1.3310090486465473e-01,1.3370502018594838e-01,-3.2911099282036158e-02,-1.1019347263894946e-02,-1.7234345429277839e-01,-2.4442226250552326e-01,3.0936403357878878e-01,-1.0541556592609977e-01,-3.7839333856417634e-02,-1.0873522184421433e-02,-2.3278181868105685e-01,3.5106516233799379e-01,-2.7403831654261251e-01,-8.7309443797831295e-04,-9.9430843900130378e-02,3.9933559865624468e-03,-5.0013713197102679e-03,-3.1013564848328296e-01,7.5006357668611454e-02,-2.2930127096332870e-01,-3.1899604470722648e-01,2.6379173756057572e-01,-2.0242453331833432e-01,-1.7339028856388594e-01,6.5401052316387751e-02,-3.1059861673622485e-02,2.4822074892225807e-02,1.1652060510293695e-01,1.6032998748818444e-02,2.0352150511759554e-01,-1.1230042202215423e-01,2.6081556503938280e-01,1.0164235770475732e-01,1.5309235077680786e-01,-2.7163869629984266e-01,-1.7046235652403527e-02,-1.9446527308048300e-01,1.2529703745030113e-01,-2.1044576805770748e-02,2.9580929434978054e-01,-3.7651480076849972e-02,-1.5668695471242855e-01,-1.2200840816030949e-01,-3.0636101418219053e-01,1.8522216810775344e-01,8.2224507706369923e-02,-4.3709060577996217e-01,-2.1220526534087086e-01,1.7097881849772301e-01,-1.0129740870278911e-01,-7.6124583111960908e-02,-1.6839257040797140e-01,2.3648088676568785e-01,2.1827077282579918e-02,-1.8829976236535714e-01,-2.3975856721889427e-01,-2.2120840398645603e-01,1.3000933199960580e-02,2.2119254922892023e-01,1.2802010047299847e-01,1.4602377458268926e-02,3.4858540733466364e-02,3.7298120304278581e-01,-2.6065208003084406e-01,7.1869855910260891e-02,1.1212917231055347e-01,2.6853055763220951e-01,-1.4251012621707279e-01,-7.3759238895169332e-02,1.7869239848404345e-01,-1.5868067324928867e-01,-2.2470251953517895e-01,-1.1739821677287784e-01,4.3743899285200498e-02,8.6084370679641135e-03,-3.0835279090673551e-01,1.0311386412263587e-02,1.1918810959789568e-01,-1.8216792961661313e-01,-1.8818735056667812e-02,7.8771289226485353e-02,-3.5011899788165224e-01,7.7485683745904171e-02,-2.2645252264608912e-01,1.8478218455947149e-02,2.0163769201251402e-01,-1.9418250505068668e-01,2.0856016980231790e-01,-3.4585557109307385e-02,1.2691352950881613e-01,8.8549992370957925e-02,2.7861041297108369e-01,-1.7713199893171505e-01,-2.0648032427374280e-01,-4.0913305116854135e-02,-2.3207426645867299e-01,-1.6701978755334854e-01,3.3207846015296819e-02,2.1943276509946798e-02,1.3693754882267985e-02,-5.3180206345126463e-02,-1.3155132463006966e-01,4.6251188946067699e-03,-4.6014214006934000e-02,1.3215673697707470e-01,-3.4696988549628155e-01,-1.7138298825084999e-01,-2.3248895982318918e-01,-4.2544437496525972e-01,-6.3507815939707002e-02,1.8307189546701019e-01,3.7496895375021788e-01,1.1965441550603495e-01,4.4284396868487341e-02,-3.0096432530775430e-01,1.1758040141964901e-01,2.1696670282667452e-01,-1.3067806853846491e-02,-1.0109631277013557e-01,-1.0047403931537345e-01,1.8634846291295953e-01,1.2295655425282516e-01,2.3341547380032049e-01,-5.1968938621730638e-02,-2.2205047606695359e-02,-1.3302302524572127e-01,-9.7732140711420695e-02,1.6732533538449992e-01,5.2496445056369571e-03,-8.2907806649733448e-02,1.3035120362691839e-02,-1.7845360916593561e-01,-2.1191778761756436e-01,-3.7209372412907371e-01,2.4063280109727986e-01,2.7262336469235933e-02,1.6077372228504921e-01,-1.0182173771906229e-01,1.5075615381775392e-01,3.2546395196322596e-02,1.0323674446207373e-01,7.6116085877053929e-02,-1.6621331829830682e-01,-7.8595203691054258e-02,1.4486427357017209e-01,1.6996168947060319e-01,1.6463411898060293e-01,4.9042860479546846e-01,-1.4393673194620216e-01,-1.7875376679757857e-01,-2.2337299868019633e-01,-2.7537292976803868e-01,-3.3730399845386860e-01,9.1355758103310258e-02,5.3979014697017144e-02,9.7076989529540358e-04,8.0177441839263203e-02,4.9317446398936121e-02,2.2708138787421471e-02,6.2110715171181075e-01,2.1519120804483333e-01,-5.6328525193553147e-03,-2.7195145030816098e-01,-9.4535496133017233e-02,-1.8382927898406443e-01,1.3345234079119256e-01,9.8073224774954428e-03,1.9253133748215517e-01,-2.2897894329358870e-01,2.2191282233848869e-01,-1.1227058580934154e-01,-1.8603882238538712e-02,-8.4202943273290906e-02,5.6234832333252237e-02,-4.7133864052156790e-02,1.7060878244688804e-01,1.1849132242874458e-01,1.2150361676337343e-01,7.0484502924949885e-02,-1.3193346401190748e-01,-2.0315919763770424e-01,1.1469056898805949e-01,2.8808867255401727e-01,7.8429075226980713e-02,7.4929023265039668e-02,-3.0646899100896730e-02,-1.1200621674045722e-01,-2.0957123704983208e-01,-3.4542222702391177e-02,7.2783192527718374e-03,-1.4874051391395532e-01,7.6138758056963560e-02,8.0846065937041564e-02,-1.8613776507691945e-01,-7.4879635704108698e-03,-1.2826175557770795e-02,9.4755671003582093e-02,-1.6164234256113849e-01,-3.8584742690828805e-01,2.4037177770227278e-01,-2.2516290693972940e-01,1.6395313184668817e-01,-3.9944160622170662e-02,2.8991341806684817e-02,2.3966356098859373e-01,4.3228942104153179e-02,-2.5760759060534627e-01,-1.2837618472374490e-01,4.5529593256383200e-01,-2.9965767122968945e-01,3.7388670948912996e-02,-1.2185473669704536e-01,-4.3786598404207006e-01,1.3353872700578933e-02,-1.1075670348059835e-01,-1.1326636695172759e-01,-1.1755594903623413e-01,-1.8944806260741956e-01,1.3833540095276339e-01,-3.2133434899622476e-01,-1.5743739181571853e-01,-2.8666454778236183e-01,-6.6337550759640221e-02,-7.9776495099175976e-02,-2.4393282525186083e-01,-1.8374343136866356e-01,-2.4850079581565345e-02,-4.6802546979095291e-02,6.1401817011946865e-02,8.4547767491815209e-02,-4.7765702398952739e-02,-1.9492967407797396e-01,-1.0134590752379113e-01,-3.8427786692110721e-02,-9.6895684397009310e-02,8.8759445022523267e-02,-4.3728055230264784e-01,8.9020536002946543e-03,-8.4520393567246818e-02,-1.5221491180012983e-01,-3.0804390849639329e-01,1.9631247418353093e-02,6.4652391103701939e-02,-1.0115890423604737e-01,2.3488062370095508e-01,3.7745940784815235e-01,-1.4861650035435833e-01,2.2865757070520085e-01,9.6365163252115846e-02,2.5058745563170420e-02,-3.3303923079609533e-02,-2.9701414257033248e-01,9.1512050302611128e-02,3.0418701296134920e-01,-1.4406252360007726e-01,-8.5488203646183376e-03,-1.4412045689484104e-01,-3.0175790762504578e-01,1.4877736737772235e-01,-1.8808865278754899e-01,-2.1107608952649412e-01,1.1346274357563745e-01,-2.3158153006303431e-02,-1.4226375296670812e-01,3.6575724503098914e-02,1.8772847039168494e-01,1.9926579417252929e-01,-3.4302112291195751e-02,2.3570404295958375e-01,-1.1956236863656101e-01,-2.8976446890654600e-01,1.1738070188093634e-01,-1.2900833448332397e-01,2.8365177244385944e-02,3.1486506300507960e-01,-7.8366990601138803e-02,-1.9425141905847421e-01,-2.0816533129904325e-02,-2.3707935403925140e-01,2.4725133868153320e-02,-1.7556745647745311e-02,-1.8600757411154559e-01,-1.9269403899999657e-01,-1.3372627931321723e-01,-3.9196540745646991e-01,1.7665180765805519e-02,2.1348397241080680e-01,-2.4131277091747882e-01,7.9053177957652626e-02,1.6469111779096460e-01,2.7108851955489593e-01,8.4375341878705601e-02,1.8827980547849116e-01,-1.6824118784757369e-01,2.1389908978767869e-01,-1.7310565346198453e-01,5.0161796754115320e-02,-3.3058036588408833e-03,9.2699802518354524e-02,3.8262408659142666e-01,1.5362746673517441e-01,-5.7018815185664457e-03,-7.1936307637683675e-03,-9.6139040677250626e-02,-4.2475597244441743e-01,-1.4608386128046762e-02,-7.0193738293393565e-02,2.4616492230614281e-02,-1.8999287198682194e-01,2.1174758695077764e-01,-2.4229334832463956e-01,8.1313818785464842e-02,4.6979227216978720e-01,3.3239982226455661e-02,-7.9878138478563676e-02,1.6607859336542891e-01,1.4071939574343287e-01,-5.3126689944793151e-02,-3.6808679375848266e-02,1.1402813174087920e-01,3.5557851593716039e-01,-9.8615253440099346e-03,2.5042398780728059e-02,-2.7720601833730746e-01,5.4695436600670222e-02,-1.1650801241187517e-01,7.5094609039205257e-02,1.7135815242973230e-02,-1.7679635818033536e-02,-1.2723314180950568e-01,-3.0830077939094841e-01,1.6577895706337703e-01,-3.3523296477298223e-02,-1.0418541006601176e-01,9.3547902127228535e-02,-1.1764409901907823e-02,6.6575582684112542e-03,-3.6020850739342336e-01,3.7051943364859430e-01,1.0946039892703992e-02,1.3580358077292276e-01,-1.2120374699814675e-01,-9.3912892481746946e-02,-5.9348504187454243e-02,2.7850632781692769e-01,1.1206895515609569e-01,-1.2821794649630031e-01,1.6419177635251353e-01,1.0512912299901409e-01,1.2494960444915382e-01,-4.5055596803876462e-02,2.3518396275876846e-01,2.5506259543420162e-01,-4.0657935750112123e-01,2.5351302934424874e-01,-2.2826323170815357e-01,6.0318989069814227e-02,-1.5552431172554779e-01,-1.4449590785173461e-01,-1.1987048554633968e-01,-8.0245400778016368e-02,1.8077045840449912e-01,9.1422319696039450e-02,-1.4615824514548770e-01,-5.1704261170345114e-02,-1.8897953856837282e-01,1.8767725655843517e-01,4.8454884884361610e-01,4.3552437643746483e-01,1.0549666886474278e-01,1.3460518622765383e-01,-1.0085403128663861e-02,6.6390356761578700e-02,-2.3073987311632630e-02,-3.1483007582101769e-01,-9.6403302984856942e-02,2.0594096630187569e-01,4.4692808282737778e-02,3.6196232257428990e-02,-1.7106771642404917e-01,5.3385468469125064e-02,1.5299631498257507e-01,1.5176522269360507e-01,1.0351313236643331e-03,8.4650616390658323e-02,-2.0818468043165150e-01,-3.1246480881959249e-01,5.2535588898741825e-02,3.8553156382665869e-02,-1.8923966235313339e-01,1.3030995130753145e-01,6.7246749056970520e-03,-4.1009774259789314e-02,1.9495095963121317e-01,3.0126073981066377e-02,6.0502474852053324e-02,2.5388560798777003e-03,-1.3518386014138789e-02,-6.8833592439437083e-02,-1.6686178279269095e-01,1.2555774785638535e-01,4.8233737168121453e-02,3.8889093625301757e-01,-2.4626566018144944e-01,-2.5646637708663206e-01,-2.8764389526139700e-01,-3.1253528137924541e-01,3.0913122091001011e-01,-8.6641364469378673e-02,-1.7255973279786899e-02,-2.1826136273465976e-01,9.5239411679249208e-02,3.3716851703702977e-02,-1.6801660707612101e-01,6.0390522404821137e-02,-1.4309939648421940e-01,1.6978972025314115e-01,4.2691973041415343e-01,9.1923130168865219e-02,1.1702701753889992e-01,-2.4034120510189484e-03,1.2607524526365658e-03,3.5420907420971659e-01,-2.1570970157040084e-01,-5.7824451588877376e-02,-9.1231031755199476e-02,1.0858992211932705e-01,-1.1564510099742227e-01,-4.0833307401150480e-02,3.9723850039826425e-02,4.5072706244229002e-02,-2.4058154659937744e-01,-7.6533137418584724e-02,-4.9839748688229150e-02,-2.4753633747899503e-01,-3.7040803467779285e-02,-3.8936473168529301e-02,1.8973343985374430e-01,-6.2519982085436743e-02,4.7258616581825758e-02,-4.3876976219421944e-02,1.9389671149708493e-01,-1.9493576611592361e-01,5.5752145151495652e-02,-3.3387537494855080e-01,-2.6037448471936614e-01,9.9542970661446212e-02,-3.0024153212433369e-01,-2.7857638223283326e-02,2.0372767454471041e-01,-3.5568721017359728e-01,-2.9090689119684832e-01,2.7836160689710551e-02,-1.1697496974168306e-01,-1.8029517025329678e-01,5.7938354460677122e-01,1.7946541415076095e-02,-2.7858106525366046e-02,1.3926525111364607e-01,-1.0990247044295173e-01,3.0343765851609289e-01,3.4954408574340756e-01,-1.8611354654295725e-01,-9.7673048723994030e-02,-6.6542037762831616e-02,-1.8896847891264340e-01,-5.4771559516027073e-03,-2.6670625685338145e-01,2.7173383843091849e-03,3.0756685592145444e-01,1.9986708012872098e-01,6.3942493957525243e-02,-9.1681667699574101e-02,-9.4735538148467663e-02,-1.9165295313225822e-01,-9.2086650759550207e-02,-9.2103510624748974e-02,7.2068927329831278e-02,4.0761312895208485e-03,8.4182095161280685e-03,2.3599402617205771e-03,-6.6705090151611690e-03,-4.5410500896876566e-02,3.8994865751431412e-01,1.8260332192704803e-01,-9.1358250398147656e-02,3.7563507905310456e-01,7.0315941790496592e-02,1.0593641763822118e-01,-2.2733265407776287e-02,6.1035307216796425e-02,-5.8995603856265448e-02,1.8657583735263766e-01,-9.5815636054061903e-02,1.9229233177490257e-01,4.1924149042546571e-02,4.5170407876445239e-02,-3.3636589637078940e-02,6.4648191479557929e-02,3.4632121276501525e-02,2.5716647251110031e-01,1.5064449022551324e-01,-6.0721485310197332e-02,-3.5090970450876852e-01,-3.2270433822207711e-01,3.1449236297790889e-01,-1.3721143523105822e-01,-1.2231099516737461e-01,2.4419665868321083e-01,1.6373618088494413e-01,-5.2043577648181870e-02,-7.9291270380148174e-02,-1.5608990560921629e-01,-2.1639340162719178e-01,-1.9414400929130056e-02,-2.3638233661351749e-02,-4.2327297953729588e-02,-1.5441974761023078e-01,-3.9075650825370445e-01,2.6999541338577299e-01,3.3260262946194813e-01,4.9664838199902049e-02,1.2153217610572919e-01,1.3748506723230844e-01,7.2758343299309997e-02,-1.4389426020454241e-01,6.9528540612002018e-02,-8.8957448037247963e-02,1.3365249816632876e-01,-2.1816864526676835e-01,-2.0275351815363268e-01,1.0821996856178073e-01,8.4747378107059151e-02,-2.7708374753481901e-01,-6.2821366746365409e-03,8.2490835370181495e-02,-2.9118583881140075e-01,2.0792623492736882e-02,-1.1140897099427853e-01,-8.1892835713496967e-02,6.0846436327344509e-02,-4.1714936079575188e-01,1.9008782604905772e-01,-1.0990745707318066e-01,2.5809044019353228e-01,-9.0612695689274297e-02,-6.5262425230973420e-02,2.3265740667990703e-03,-9.6590203528216859e-02,7.6226596219082107e-02,-1.2662342500997043e-01,3.4248595497477785e-01,8.0428748887148044e-02,-2.8554413506647924e-01,-2.2617145440243366e-01,-7.1126546597974474e-02,-1.9641988270140442e-01,5.9383532209703827e-02,3.9112677554918468e-01,1.4674324228859062e-01,1.5832738605537879e-02,9.4087895724459164e-02,2.4792428896315588e-01,1.3257703196081527e-01,-1.0568110058489986e-01,3.5436582799010480e-01,-5.2150835678616773e-02,-1.8212154382566925e-01,-2.2414936404536243e-01,-1.5803057502323437e-01,-9.2278267787544221e-02,1.3741647014123534e-01,-4.9946202666433959e-02,9.4093821929702406e-02,8.6091193859160128e-02,2.3936480015111838e-01,-2.0884821065968939e-01,-6.0762634315549527e-02,1.2159760558439688e-01,2.2179236695955970e-01,-1.9018148498643223e-01,9.4464072957250567e-02,-5.1234089205959496e-02,-2.0275998963427397e-01,-3.6236838589070369e-02,-9.5259436706921469e-02,-1.5711725266110665e-01,1.7512080144482201e-01,-7.0488427803263309e-02,-4.6543127433625786e-01,3.2476339027123596e-01,1.2013773582999890e-01,-4.1684893499989500e-01,-3.9399421866915724e-02,2.6102395307751725e-01,2.8224187019735815e-02,-1.3978828670456403e-01,-1.7477018929039856e-01,-1.0574594710780638e-01,5.3519321487992738e-02,3.1282275125224045e-02,-8.5042662978837891e-02,-5.9249956190979176e-03,-1.3619351037986632e-01,-6.1626151899795534e-02,-2.9478954437450533e-01,8.1654171801252617e-02,1.6381519556123197e-01,-1.7068340452502462e-01,-8.1191574229164593e-02,4.3956425532845184e-01,-2.1767452360535625e-02,3.6509792240583330e-02,-5.6952735560183362e-02,9.1149973620400809e-02,-2.5550070334963820e-01,-2.2117006984518933e-01,-7.9739441039148803e-02,9.8824988798802679e-02,1.0639990329337677e-01,1.2126731237969392e-01,-2.0632008639901683e-01,-3.2719487918034140e-01,1.6419016804623904e-02,3.5316300545996454e-01,2.2472413906567682e-02,7.7369864828673474e-02,-3.0459884982559221e-01,1.8267172814822130e-01,-2.0159405048221311e-02,-6.1441817894519454e-02,2.1708510499330427e-01,9.1497549536561085e-03,-2.3410237496362110e-01,5.1043987074323817e-02,-1.8312213833864494e-01,4.2478506635862834e-02,-4.4647219933914456e-01,2.3996766916406326e-01,-1.4376560640488331e-02,1.5251883888315443e-01,1.1686055101775182e-01,5.1222481142793340e-02,-2.0967818005688508e-02,-2.3202853843415303e-01,2.3476025682203092e-01,-1.2893603147504382e-01,-1.3205771034862707e-01,5.3729284961621854e-02,-2.8137934625750666e-01,2.5845315425126203e-01,-2.5815065369266871e-01,2.5760112154872346e-02,4.9555702984724975e-02,-1.1382679665168560e-01,7.2194125335189208e-02,2.0310487652480000e-01,1.8511021466494718e-01,3.3244128236581355e-01,-1.3717789879490966e-01,7.2085268499187130e-02,-1.4215309658089154e-01,4.9985899394177774e-02,-1.7069364022918421e-02,-2.1235890217349862e-01,-1.4091183701040674e-01,-3.5329805387250574e-01,9.7509231926550963e-02,6.8890900829320048e-02,-1.1046496405501173e-01,1.1177139399119629e-02,2.5303540449800443e-01,-2.8922727422273986e-01,2.9740459607040415e-01,4.1968702221895249e-02,-1.4586109623812599e-01,4.0850049338310955e-03,3.5455445579564820e-01,-2.5047181445486524e-02,-1.9485226628824650e-02,1.1629329430260507e-01,7.4664719191177800e-02,2.6357115796141212e-01,-1.0676987976528721e-01,6.6840567257814787e-02,2.5022836740635085e-01,-3.5512462832083619e-02,2.5368897153079793e-02,3.3536724698225207e-01,2.2265117147087576e-01,-2.3391122462392078e-01,-9.6146115720141492e-02,-2.7672365928195763e-01,-1.9629185032624050e-03,-4.3821387095758217e-02,-5.4435351757021855e-02,3.1563928286910004e-01,4.7391937359306753e-02,-2.0198318763586565e-01,-1.2693513001262138e-01,-2.1378030937695269e-01,-1.4809545718588227e-01,1.0344820263915136e-01,8.3013321073489733e-03,3.9803234545393618e-01,-1.9338719333195586e-02,-2.1310198835502381e-01,-3.4030564739923291e-01,1.0900214885090166e-01,2.6761074843472082e-01,-1.6903484067893576e-01,-3.0296432922894523e-02,-3.0654928315486100e-02,4.0418303407700468e-01,-6.4424733686029925e-02,2.3784413654936481e-02,-5.3848063545440736e-02,2.0548787918551661e-01,9.3880729916181849e-02,7.9768510545514482e-02,-1.0780622847622665e-01,-8.5980824375850792e-02,3.7864921309745704e-02,-2.4991831254389099e-01,1.9792191173420229e-01,1.2282997271691604e-01,1.2829047520531073e-02,1.0182192314649587e-01,7.8568765636011090e-02,1.8150773296430087e-01,3.7729819927437923e-02,1.4269381725860214e-01,-3.2437359807628069e-01,-1.3015469865942084e-01,-2.6712722498915070e-02,-2.4928156931510714e-01,-1.8473923999579178e-01,-1.0020494030999098e-01,3.1768651255751207e-01,7.4790761918361592e-03,-3.7158420706954604e-01,3.9577808029724371e-01,-8.3792092708865257e-02,2.4858233121999758e-02,1.2712196276915461e-01,-1.0573936815560536e-01,1.8511863634775477e-01,-2.0295589853191551e-01,-7.8633604588717626e-02,2.2927272130305143e-01,-9.5385548061703213e-02,8.5118259211961672e-02,-2.7408060575820992e-01,1.9786961054715230e-01,1.6084811571748517e-01,-8.9824447657703005e-02,3.6967640850026295e-01,9.2870524032392737e-02,9.5617476166307641e-02,1.1370564099767787e-02,1.3709813142165383e-01,1.6495013034341149e-01,2.2151160124342892e-01,-3.3832264841747291e-02,-3.8892949205626964e-01,2.1502466832467773e-01,-6.2778507639643877e-02,-4.7067396190633118e-02,-2.5348408246691545e-01,-1.3943738813946979e-01,-1.6666348425163352e-01,2.6919838846614091e-01,9.2576300745423876e-02,-5.3530009411698908e-02,8.4822306028575697e-02,3.4028074871978020e-01,-3.3629105690944835e-02,1.0135608709901617e-01,7.3493661702633620e-03,2.4690741082156997e-01,-4.8128641448957954e-02,-6.5221955485380567e-02,-3.8737771368461814e-02,3.0557292513740986e-01,-7.8312154849280974e-02,2.4582535473171888e-01,9.4227447591286123e-02,1.3532829260989263e-01,-3.6037543590286998e-03,-2.9229215976538475e-01,1.4654779187387909e-01,-3.5589930137348465e-02,-2.1883039227323489e-01,-4.6627248811266363e-02,1.5387686593950797e-01,-6.9185592882464161e-02,2.8936386767585531e-01,-1.7573032025337154e-01,-3.7577207826651179e-02,-1.3104681276877356e-01,7.8574540616421537e-02,6.6675138623972632e-02,1.2323697522325366e-01,-2.7901929185428648e-01,1.2679771239165419e-01,-3.5681782443915777e-01,4.4885061661619818e-02,8.1627580365421240e-02,3.1803550079918197e-01,2.3272971635635781e-01,-2.1994805552004287e-01,-1.7898377305988480e-01,4.6365499367036100e-02,-1.2300297301244670e-01,5.1760176500634025e-02,1.7881523824567364e-01,-8.1804321410751821e-02,-2.4897138655207399e-01,5.6673272096318776e-02,-1.9599287296172624e-01,-1.3319566580933545e-01,-1.7572279766652882e-01,2.3801115388414229e-01,-9.0614430552911948e-02,-1.5853807334754333e-01,1.3901072615369947e-01,-4.7230466529780302e-02,-6.8865135715279066e-02,3.8181683457030914e-02,-4.5572543985405896e-02,-1.2691146149735594e-01,5.4674145821707938e-02,-1.3767813947688411e-02,9.6553208079084352e-02,1.5956572636840080e-01,-8.9353358168860461e-02,-3.3843960344013380e-02,-4.0136945866084894e-01,4.3402032782313416e-02,-8.0457995640726324e-02,8.7389465892824453e-02,-6.5500125486759297e-01,-3.9987600135627038e-01,-3.1102431162789673e-01,-2.1220593240175500e-01,1.2909814840086267e-01,1.2601723146854812e-01,-1.2682775019264933e-01,6.7011081429903641e-02,2.1640082154314613e-01,4.9368578502716018e-02,-2.6453693619665097e-01,-7.8445148363340864e-02,-4.6148728063156882e-02,-2.1096729296104441e-01,-8.2588601612096704e-02,1.8061064241044933e-01,-4.6098352876924403e-02,6.2676524800470673e-02,3.0711339988678982e-01,-6.1588469883567629e-02,-1.5525230843796736e-01,-1.9218450782688398e-02,-3.7878150179996123e-01,1.4141756178839268e-01,6.9198752882451420e-02,-1.1675617448042812e-01,1.0142105842457369e-01,-1.1997428066513567e-01,-1.6587037458635678e-01,-2.6318476494243648e-01,-4.1705852053353663e-02,-1.2527682727691028e-01,-2.1964177306226518e-01,-2.8108477244457469e-01,-1.1761448770430295e-01,4.2301080046983318e-02,-4.6194882319252450e-02,1.4442463739503369e-01,1.2448716016736913e-01,-2.4527221486905112e-02,8.7367073181542326e-02,-6.3439410929100243e-02,2.1392555313149125e-02,2.0792429236887561e-01,2.9240748095799646e-01,-2.7362589888161276e-01,-7.7982307970799469e-02,-1.2622260621517420e-01,1.6393907665632929e-01,1.6725883319616247e-01,2.5117764569978973e-01,4.7116019574806024e-02,-3.3252666958813176e-01,-6.9565772163972958e-02,-1.0452937366247715e-01,2.5827237865288988e-01,1.2227076754648888e-03,2.3874251980556968e-01,4.7325493259078533e-02,4.3298608996641086e-01,-6.8442342478994306e-02,-3.1942433412875343e-01,8.8131715275687736e-02,4.3031326111941416e-04,-1.7085015942231058e-01,4.3968057501474145e-02,-4.2650012649216440e-01,1.7213967978891473e-01,1.2812428656308711e-01,1.4999927365580079e-01,1.4380655833231692e-01,2.6959049354912623e-01,-1.1420555303967972e-01,2.4302492748822388e-01,-6.9958389779199062e-02,-3.3094268535465224e-02,-2.6729853834795557e-02,1.0744290692714743e-01,-4.1386855593980171e-01,-4.1337843395454425e-02,-1.5315522352031728e-02,3.4290742694319511e-02,-2.1209606228289213e-02,-1.7701752197925449e-01,-2.3548187234796977e-01,2.0135200933104330e-01,-9.7929783323818548e-02,-6.0602155620102335e-02,-1.9586144560386273e-01,-2.5221754421013054e-01,8.6558500625735335e-02,-1.3403716916793873e-01,-3.4393654376823102e-01,2.4591645930584331e-02,-9.0472343276315828e-02,1.7183978356164564e-01,1.8256146333650064e-01,8.5666052165819948e-02,-3.0946094642344005e-02,4.2006033308624091e-01,-1.9046043101510479e-01,-3.2177951131413790e-01,-1.6277668337094589e-01,-3.1651550246720714e-02,8.7477398788354713e-02,2.0895146596882769e-02,1.5059637469388570e-01,-5.3689450447422578e-02,-2.9180473255419609e-01,1.7403919098020490e-01,-2.1056758805686834e-01,-1.1046239847291281e-01,3.8290720131301770e-01,-9.7003425438320391e-03,-8.5825659741009044e-03,1.5969338668533956e-01,1.1218195881393642e-01,2.3495813933941380e-02,-4.5501132309487963e-03,9.3182660492896752e-02,-2.0068020754016003e-01,-1.6394237574298093e-01,1.7163300784215338e-01,-7.3003173250068979e-03,-1.4087451776111543e-01,-1.0824784210578017e-01,-2.0019868612254260e-01,-3.2342433565844625e-01,1.8907960225689055e-01,2.2902551418687073e-01,6.4859603078173983e-02,-2.6305660500209777e-01,5.2002988994505325e-02,1.2873484064048199e-01,-1.8735731558479840e-01,-3.1690067018385407e-02,2.5753849294331982e-01,1.2540621761564563e-01,5.7036024217185774e-02,-5.2122632839782621e-02,7.3673387466336351e-02,3.7678968092837195e-01,4.9904069002687949e-02,5.8753675765776441e-02,3.0709309638302495e-01,-1.9207294023927660e-01,-1.4901941524390150e-01,3.1801795107292047e-01,-7.4922331881983092e-02,7.7571808680829787e-02,-2.0697320841317143e-01,-1.7023640461782807e-01,3.1850880817452590e-04,-2.5190404294186386e-01,1.4057183981906467e-02,1.7429256586503589e-01,1.8878879153573377e-01,-2.9559250957856370e-01,-2.9723927882036708e-02,-2.9156893083626739e-01,1.3100221240582191e-01,-1.4846077207062955e-01,-1.7318328242232600e-01,3.6525787374823551e-02,3.0454056086597536e-01,2.4415728045208154e-02,2.3151992875815003e-01,-5.4107913248514217e-03,-1.2968765632961141e-01,-1.0986164181350272e-01,-2.1221297349628343e-01,2.8710993715164645e-01,-2.3878720779498382e-02,2.2433376714407042e-02,-1.5232019757854287e-01,-1.6262417300794245e-03,-3.5973538099492064e-01,-3.3455019259679497e-01,1.3985788031602092e-01,-4.2629649486069718e-03,9.5033581195100511e-02,7.5980148180388452e-02,-2.3863651570555991e-03,2.7027136125479084e-01,2.4568010985196931e-01,4.0576833165176213e-02,1.7803734613616962e-01,-4.2929585431986793e-02,3.0894528269014998e-01,-1.7548198643029100e-01,-3.4493223197523398e-01,-1.2490220821800471e-02,6.1729535311230183e-02,8.9959807667278180e-02,-1.7388039074695869e-01,-2.3318185833236449e-01,-7.0001566748643038e-02,-3.3296931286946296e-01,-1.3221219613526236e-01,1.8867380027752825e-01,3.6591548009890111e-02,3.6791988587958913e-01,-8.7282939090834746e-02,-2.1629916131305998e-01,8.1884707912310173e-02,2.2109433178307425e-01,-4.3999795018412849e-02,-1.0823541147690166e-01,-9.7236904491461454e-02,-1.7181683402884379e-01,-1.2479353534750146e-01,1.2723818180633231e-01,-4.1676911865899134e-02,-4.3263759016548026e-02,-4.9479596007360460e-01,1.9563107166303998e-02,-1.2834801861854392e-01,-5.6004385114379156e-02,-2.7742695737786921e-01,-1.5183433202035665e-01,4.5995036831071812e-02,-2.9336992230967412e-01,1.0531680825021532e-01,-1.5579381834662062e-01,-7.4977404568966538e-02,-2.0979651389751477e-01,-1.0692742288329897e-01,1.1608147550171478e-01,-1.0063678218138311e-01,2.0710143581896548e-01,1.7237561023007153e-01,1.1112719184805242e-01,-1.5062089916649599e-01,-1.4842270830473051e-02,-4.9027102030879635e-02,-9.0291468538768849e-02,2.3463983434434171e-01,-3.4570450904011729e-01,-4.2201277274780388e-02,-2.0052204207312163e-01,-2.6865496975863812e-01,-1.5940658472365760e-01,-3.5307974885610244e-01,6.2425671223183141e-02,3.9750350868034573e-01,-4.9680520031729701e-02,4.4083802379730613e-02,-2.0795290152638410e-01,-3.6737946240192265e-01,4.0710872306009394e-02,4.3661232712178227e-01,1.8283032028837265e-01,2.9648852107106584e-02,-1.4284195385623302e-01,-1.7456460003147442e-01,-2.5256611945650903e-01,5.8954219169184627e-02,8.7542722522723382e-02,-6.1042668328943041e-02,1.3182474999887323e-01,-9.2816772313527321e-02,2.0640850361832008e-01,-5.1391901880445151e-02,-2.5627824934434759e-02,1.3405489508083415e-02,4.1740076961022873e-02,1.9785431358895486e-01,1.0433526959591677e-01,-1.4836361424892919e-01,1.5700815991167946e-02,5.6228392155431184e-02,-2.3663770653780775e-01,1.1607732744240996e-01,3.6482586273493572e-01,-2.3622245729687866e-02,-3.6182657578290124e-02,2.2728591317898791e-01,1.7790166564294682e-01,7.8414542952232033e-02,-1.2829916782617060e-01,-8.7122486822647185e-02,9.8135547769711104e-02,2.5774259367454744e-01,8.4978255086235480e-02,2.5886837518456163e-01,2.0077428020151895e-02,2.6311057722517178e-01,4.1099258118331211e-01,5.9071261415342219e-02,2.0918419567773355e-01,8.9407935995318683e-02,1.1984786953658566e-01,2.9447925862273447e-02,3.8991876968992328e-01,-1.6877100238989767e-01,5.3997143370068848e-02,1.2652751840845175e-01,-3.2102648921534763e-02,-1.4778043078747852e-01,1.9655286134876285e-02,-6.4481613645908193e-03,1.3452407570502803e-01,-5.4000010201506091e-02,-1.8636280440985911e-01,-1.6146139981976271e-01,1.0610496603680721e-01,4.1171452099510800e-02,5.2069644281759003e-02,2.5686072878018973e-01,-1.6764852340502806e-01,1.6617283149812617e-01,1.0474781640797261e-01,-2.6215029464405143e-01,-2.1597039127463452e-01,-2.0896928326858275e-01,2.0154816515419677e-01,-3.2764166888845292e-01,-3.4762701691548853e-02,-1.5819929140636763e-03,2.3769382867920166e-01,1.9593927237985968e-02,3.1968923408554833e-01,2.9429892211221043e-01,3.7659397622348395e-01,-1.1725069333653056e-01,4.8015552786716015e-02,2.7161398460563979e-03,1.4845176385936878e-01,-1.5125895938054376e-01,7.7982254331581041e-02,8.4021453655806266e-02,-2.2073383796171228e-02,2.0187905558693242e-01,-1.3908305244103297e-01,2.7169789130809835e-01,3.4470306624883695e-01,1.6024235479091112e-01,2.1525994409693078e-02,1.4301356405088356e-01,4.8905501905969116e-02,5.8605452998987298e-02,-4.6985950579287034e-02,-5.1685423292302649e-02,-4.8379180329676280e-02,-7.2162825089068225e-02,-3.8969821669996650e-02,-5.2672906456608874e-02,2.4541979676191161e-01,-1.0709655055259461e-01,2.5349214836297845e-01,2.6064699677023745e-01,-2.0479108349823705e-01,9.5222020816221678e-03,-2.9764259134614129e-01,-6.6522903306304809e-02,-4.2504667919023104e-01,-1.0857398198981245e-01,-1.1885850223639044e-01,-2.8969636750269534e-01,2.0755689304045977e-01,-7.1462394474972810e-02,5.2844270739089996e-02,-1.3139567751063799e-01,2.7156715787750977e-02,-7.6595326576534589e-02,3.7754332112943101e-01,-1.4288103489290072e-01,-1.6804581074625785e-01,-2.6252335201059623e-01,1.6018288394636238e-01,-2.6206326178183698e-01,-2.5893811690735685e-03,4.9489282343117819e-01,-7.9644233469768205e-02,-1.0268680466710330e-01,8.7770370891385840e-02,-2.5532643228159350e-02,-1.3060014945444623e-01,-2.8080498906409204e-02,-8.4713596714047421e-02,1.6781032884214592e-01,8.0080713302441264e-02,2.1815492561294204e-02,1.2174000988383825e-01,-1.4639751276726248e-01,7.2900108609228950e-02,-2.8153486657146626e-01,1.6725977311252797e-02,-1.9340124516954812e-01,1.4226654907210173e-01,3.3150961571277426e-01,-6.7988310882014708e-02,7.5917553034246410e-02,5.9949437366044779e-02,2.2234153097358175e-01,1.3601893588047634e-01,-3.3927212425917680e-01,5.9694084936104397e-02,1.0299580843591927e-01,-3.0530368321005358e-01,1.2106197202887735e-01,-2.6797701225086867e-01,6.8900661007452901e-02,1.5175700589844052e-01,-1.3749647297647263e-01,-1.4790310789383326e-01,1.4073449522537632e-01,-3.4030729755511657e-01,-2.3524307142479975e-01,-4.0335675264426905e-02,-9.1190824391056705e-02,-2.5774125212260418e-01,2.3636275414174023e-02,4.1898993927288253e-01,-2.5628482002474928e-02,-1.5018125418710282e-01,2.0743053108579793e-01,-5.0070739777122675e-02,-9.5991638293230121e-04,1.6843939362703880e-01,-3.5340617930668099e-03,2.2344443994099011e-01,1.5346219662497890e-01,-3.5100719486983079e-01,3.2688339748574852e-01,-1.5938640696035230e-02,-2.1685107790663208e-01,7.7645717023268446e-02,-2.8682905302705303e-02,3.7783186425998611e-01,-1.1290377311949230e-01,8.3940532224060713e-02,-1.4070223605050230e-02,1.4069521307660560e-01,1.3635088765153819e-01,-1.8482465941167348e-01,-5.5353381284440131e-04,1.0673474545190277e-01,8.9197060401350572e-02,8.5553305538071805e-02,1.1831354673201587e-01,2.2361042611944448e-01,1.5777488115562033e-01,2.5223933348683758e-01,1.4919493700312059e-01,1.0730394024432556e-01,1.3367905275147018e-01,-3.9545842050716296e-01,1.2118643428896315e-01,-3.5908596228429485e-02,6.2019379441971209e-02,2.2067337993309438e-02,-1.7714592241755558e-01,-3.5938967786803264e-02,-1.4161041418457165e-01,7.2096107616967248e-02,1.0223169883672786e-01,3.7866381353822359e-01,-2.4171330480504816e-01,-5.4852632050481992e-02,-2.2218073901054627e-01,2.2025870721700419e-01,-2.8592550127741384e-01,2.1386846385876501e-01,-3.3158593659892227e-01,-6.4377385132381157e-02,3.7056410310093968e-01,-7.2705671809419364e-02,4.1372569860264694e-03,-2.3046403884705725e-02,1.2867952934329030e-01,2.1297529354662925e-01,-7.3069829828670566e-02,1.8780760455426909e-02,-1.8420308970057211e-02,-3.5959239994158115e-01,-1.7799134477796644e-02,2.1559941614379546e-02,1.7255198602370683e-01,6.8482444210853879e-02,1.0583036560509981e-01,9.7120182935875168e-02,1.9876664528121474e-01,-2.0196055480689640e-01,-7.1539828421143051e-02,1.2201609385075239e-01,2.1066349428546355e-01,-1.3511867079255499e-01,-5.3104463600704404e-03,1.2597857084827087e-02,5.4487515099563934e-02,1.2711566026852053e-01,-1.0860867412550047e-01,-3.0402388177423013e-02,-2.2071964354885781e-01,2.5185690317016902e-02,3.8809331532483193e-01,-1.1961199852270925e-01,1.6978182414897874e-01,-3.1721733665640212e-01,1.3659537956136203e-01,-1.2730900305595266e-01,-1.7074829961448688e-02,2.6046233670226078e-02,-1.4073368258325902e-01,3.8740438998634158e-01,2.2411523622721630e-01,-7.3549087439195249e-02,-3.6086048025744349e-01,2.3461415843265283e-02,-2.4440870424721906e-01,2.4445749173793141e-01,-1.7031392559317896e-01,1.4055051089245728e-02,1.4313683633265184e-02,-2.8544863046136601e-03,-7.4634568068985399e-02,-3.3008640124462141e-01,8.7888541354524702e-02,-1.2173532211338843e-02,-1.8793769064210225e-01,3.5465090268947813e-02,-2.8713899367731893e-01,-8.4413891006685088e-03,4.0484069201447892e-01,-1.4216270202932624e-01,1.2604823015630962e-01,-2.6632410558993708e-02,-1.5695014848830877e-01,-3.8071078324767763e-02,2.7682378784634287e-01,-7.8406140334380953e-02,-3.5652180001506460e-02,9.0787957500234384e-02,-9.8240312738985869e-02,-2.0149030624844066e-01,1.7007392017003189e-01,3.0248829338955729e-01,-1.9148537474391736e-01,-3.2256365133673232e-01,1.9712465952222646e-01,-1.8066822307166958e-01,-6.1705704315726327e-02,-2.8086573360257139e-01,8.8994572287749596e-02,-2.1703312801867850e-01,-1.1040281656635648e-02,-1.1166708443731212e-01,-4.8770067410921214e-02,-3.1532827914443134e-01,-2.8039696802722081e-01,4.3905710718991596e-02,7.4810244203261697e-02,-6.9052018003966084e-02,-8.8254054960254874e-02,2.9073440174526322e-01,7.4865040325786409e-03,2.1902778233500747e-01,-4.2944643094588786e-01,-5.4890932300772022e-02,2.8392984882436367e-01,-1.7707753931542565e-02,4.4596729015591086e-02,-8.7510399541819398e-02,2.7260029406834152e-01,1.8344512694303167e-01,2.0898518087320464e-01,2.5039036331608713e-02,1.1375149776076443e-01,1.9289435378914005e-01,5.9622165097172691e-02,-2.5482023193885456e-01,1.0237356643217187e-01,-2.8688290562310197e-02,-1.9876992813169701e-02,-1.2171333339752459e-01,-1.4007168164009789e-01,-2.9044541179634142e-01,8.4260501430871118e-02,2.0139599982525073e-02,-1.2656195349824170e-01,1.3642950938449397e-01,-3.9729006258217854e-02,-2.7053690107402395e-01,-1.9737393646858234e-01,-1.4307109790914088e-01,2.1304114299935020e-01,-1.0447675360353080e-01,1.9689978723186982e-01,4.0634945662156935e-01,1.4770067071272830e-01,-2.3056105682495845e-01,1.5458605047529494e-01,-1.9856546966538349e-02,-3.0439668311521056e-01,6.5711090988361337e-02,-9.3627800055798946e-02,-1.6393250889629701e-02,3.9608482358957531e-01,-6.3260461873464582e-02,4.3509030883163678e-02,-1.8182530513483189e-01,1.4375759123627124e-01,-2.1819522927305303e-02,-1.5568959822651468e-01,-2.5883652612419195e-01,3.2068404419663382e-01,-2.0214708446621327e-01,-1.1318384276876299e-01,1.8044462329249536e-01,-1.6126300258570775e-01,9.9212400664341713e-02,-1.8188246672843644e-01,1.0177895802950673e-01,-1.3024074027975754e-01,-2.8954450375641810e-01,-2.8908688687166167e-01,-4.5678819011425009e-02,-1.7823227944650866e-01,2.1309410913011986e-02,-8.2636088344697267e-02,-2.2147834010778433e-01,-2.3621973478483474e-01,3.6794925941292800e-01,1.3786914003909659e-01,-2.5499107940608074e-02,-1.8534252846526039e-01,-1.0467323691387728e-01,-1.7186624508219903e-01,1.2990306222797343e-01,9.5266422906171960e-02,-2.0531314573958509e-01,1.4318353336635145e-01,1.5259352459335973e-01,4.8110593163018467e-02,-2.9448872497353951e-01,-8.1341839592498008e-02,2.5222768953039411e-02,-3.3798199071146902e-02,9.8533927749987274e-02,-1.6128308646403339e-01,-1.5662908322156963e-01,-1.4682916131042448e-01,-2.1775223027849283e-01,8.6771312945082349e-02,-4.6345497950346329e-02,-1.5903201763640809e-01,-1.3020739267106929e-01,6.8321504530465912e-02,-3.1308752928577038e-01,3.9514422411354361e-02,2.8650704882320349e-01,1.1365901535414678e-01,-1.7066664759292519e-01,-3.8592285055975667e-01,-1.7306075221616768e-01,2.6198847796507185e-01,-1.3679786434011240e-01,-1.2165153780026210e-01,3.3619635680086341e-01,1.1413157439740905e-01,6.8208570746472602e-02,1.9475418636820821e-01,-3.2933180762827913e-01,-4.8376194778229457e-03,2.8595208891766737e-02,8.9973584809177568e-02,2.4912153976910817e-01,6.7304873807608495e-02,-8.0708483127848896e-02,-1.5735428783067618e-01,-4.6439278815368495e-02,2.2422863894069209e-01,-3.4243453272429802e-01,-4.5242474571204686e-02,-4.8239880037236749e-01,6.5303799875073870e-02,1.9832126661086408e-01,-1.4955711825616988e-01,-1.6693237377621181e-01,-3.1547983276061964e-01,3.9743903844717050e-02,3.2660806674514889e-02,-2.2431287938504525e-02,-9.3292615677985080e-02,4.0561775013547886e-03,-1.7779772346519944e-02,3.3785730084657489e-01,4.2478327351398185e-02,-1.0679992896094366e-01,6.9310856463755108e-02,-2.5118943807595007e-01,-3.5204087066338496e-03,-2.3817945279729993e-01,6.0906014724195601e-02,-3.1561240439983956e-01,1.6164284537309420e-01,2.7969233135338478e-01,-1.6157819601025647e-01,-6.8591969129014441e-02,1.4151275597469987e-01,-1.9652399943224755e-01,1.5723544223582236e-01,3.3131056150139393e-02,8.4917767337711586e-02,4.3028685915535020e-03,2.2814080591621173e-02,-3.3160491362683253e-01,8.7981599757025214e-02,4.3098783610659816e-02,3.0132241532965687e-01,-3.9841040912545228e-02,3.0407297059859806e-01,-3.2270060637066313e-03,7.8093408794036034e-02,-6.3579210522893490e-02,-2.0218541027403436e-01,2.7862647766411869e-02,-2.5747506096479461e-01,-3.5109325797676855e-01,6.0704742018177410e-02,-4.7506919518113477e-02,2.5682462789887128e-01,1.7778422403508742e-01,6.1533929500972404e-02,1.5300036518328691e-01,-2.3190149686633316e-01,1.2754502324937345e-01,-3.3177557072973313e-01,-1.8621595454324416e-01,-1.2990247622163606e-01,-2.6436656108396972e-01,-4.2467937523946170e-01,-1.2688199308297696e-01,3.3243513963914811e-02,-5.2684695538017329e-02,4.7473826318452428e-02,1.2602729195513701e-01,1.9580470385713478e-01,1.7115985429393352e-01,-2.9355887321606190e-02,-2.3725411828964718e-02,-1.8014378816874364e-02,-6.5334112347292875e-02,2.6192979261033678e-01,3.1400955918369255e-01,-1.1947004386085520e-01,1.0907565990222093e-01,-1.8238054505878695e-01,3.7084521457364086e-02,2.2645077387939497e-01,6.9927083069423093e-02,2.8466401478379599e-02,-2.0975791362508686e-01,-1.6862194344097892e-01,-5.7991854738125792e-02,2.2419575665390008e-02,1.4706445774436289e-01,3.6090590094802782e-02,-1.6989222690919595e-01,-1.6470685642406466e-01,1.5055450924081612e-01,4.2032017047451137e-01,2.6137066059351738e-01,4.4931242617446514e-03,2.8040081058892163e-01,7.5678722274795968e-02,4.1209000670473350e-03,-2.1720634233935013e-01,6.4372582338488679e-02,1.3549688954023711e-01,2.4516208657435971e-02,-2.4510115355730910e-01,4.0530511047657106e-02,7.8839331012223304e-02,3.0380873924282403e-01,1.7931108000122931e-01,-1.1766423428680426e-02,-4.0857955651396760e-01,2.3451787156527237e-01,4.7942523723658217e-02,2.1418462530570237e-01,-5.3612398416214610e-02,1.1227793319022744e-01,-1.7324445337249431e-02,1.2839062868355020e-01,-9.4683244019666185e-02,4.2299370494893615e-02,5.3825191398740896e-02,-9.0229205280126207e-02,5.4948761985399774e-02,1.8932328476045987e-01,2.7000925344732796e-02,1.3232039317348568e-01,-4.3583412259183896e-01,-2.2042314161838447e-01,2.6267025779157938e-01,-2.7404955900977890e-01,3.3004166880974983e-01,3.2536848962072284e-01,-3.0824032093529041e-01,9.2641775764193746e-02,6.1857915911774447e-02,1.6050061513494082e-01,1.9500328580318282e-01,9.6854318424292901e-02,2.9322416541739581e-02,-1.8412217555853555e-01,-9.7207262263107455e-02,-5.9134979370901786e-02,-1.3131192830003982e-01,1.9508207161561000e-01,-2.2366279906767444e-01,-1.6889418246372040e-01,2.0954348008108539e-02,-7.2301925723913141e-02,-1.0468414667196133e-01,-2.4062100341199552e-01,1.6524247903919934e-01,-2.0312729992456532e-01,-2.3195424325723343e-01,-1.3786418368522232e-01,-1.8216246732497832e-01,1.8949199470878128e-01,-1.4409641416825780e-02,1.6971476119669365e-01,-3.2191227720883753e-01,1.0940848642652988e-01,1.0195974706041833e-01,4.0598518343086049e-01,1.3247354080633653e-01,8.7708605363497533e-02,1.4550070312927904e-01,8.3963152820849152e-02,-8.0287495255090491e-02,-6.0503850393322220e-02,3.1059542221303860e-01,1.9370221396750714e-01,1.9730152110481428e-01,4.0923724695066208e-02,-2.0103060616951593e-01,-1.4227241588124519e-02,8.2054535106086540e-02,5.8808333394968729e-02,-4.4468963621209529e-02,-1.6532237550868500e-01,-2.2946736939804546e-02,1.2668549109713576e-01,1.3468128686909964e-01,2.1929478036023749e-02,2.4875275585405438e-02,1.4129941957642256e-01,-6.1136780715680877e-02,-3.0379945265095482e-01,1.7309658158149277e-01,-3.5430798503435414e-03,4.7017919165909167e-01,2.1656559625850930e-01,2.5981586734235240e-01,4.4964800412192509e-02,1.5289879360163444e-01,-4.9470252465065478e-02,2.1639787017266189e-02,1.3251208695521421e-01,-2.0637259320763604e-01,-1.9878033573347795e-01,5.4674859871742032e-01,-6.1433858899469271e-02,-6.6189768993212841e-02,3.0373261839979300e-02,8.3946761479343476e-02,-5.9507434647894368e-02,-2.6344469672716364e-01,2.7046882368090452e-01,1.8820047630586786e-01,9.5775287769125098e-02,7.6673488035260154e-02,4.7654410427604399e-01,6.5181360196195554e-02,-1.3788413279819320e-01,-2.8996278527611368e-02,-2.4942938703253897e-01,-3.5078122673808734e-02,1.8679920540788292e-01,1.3241540033564167e-01,-4.8450508285762438e-02,2.7038810862252960e-03,-1.9165222790247058e-01,-1.1790591822588870e-01,1.0918535451818727e-01,1.1675528732399075e-01,3.7786780949419468e-01,-7.7857624602797784e-02,-2.6544329960984783e-02,-8.6062158750771764e-02,-3.4430266745599021e-02,9.2421755674338149e-02,-2.2691735254580095e-01,1.8865996292686263e-01,1.8300388145403440e-02,3.2205352188256486e-01,-1.4280120582523687e-01,1.7984390261115230e-01,-1.7303165285379681e-02,-7.1453249924735063e-02,-1.3584987142571175e-01,-1.1092748187618075e-01,6.3207881101615251e-02,-5.0339095350373876e-02,-4.2352551553795137e-01,-5.0166063608107811e-02,-2.6867793707815175e-02,-3.8123769693431897e-01,-2.7345942765366887e-01,-4.1516186241896080e-01,2.3834492445960706e-01,1.8174764836007801e-01,-1.4986011364507285e-01,-9.2352222630306541e-02,1.5803289613881191e-03,9.2411355047109289e-02,1.1962935699026853e-01,-2.2515516013539166e-01,-1.6596980052596477e-01,7.0025390723575720e-02,-2.7931512180834440e-02,-1.0236399422921885e-01,2.6865803064454935e-01,6.4413658409836747e-02,6.6218298217635779e-02,1.0334693730998201e-01,-7.6503413889000144e-02,2.6056377433793743e-01,2.5592364311218407e-01,2.0406701227651086e-01,2.4837819183188461e-01,-1.6052241271033671e-01,-7.4685321306983146e-02,5.1272511278234040e-02,-9.8736016832337875e-02,-1.8382606235856150e-01,1.2058717137059281e-02,-6.7659744533281024e-02,8.7385440996953417e-02,2.6376564523214296e-01,2.0457715594776463e-01,2.1395420199596443e-01,-2.6561418301814382e-02,-7.2539343982916615e-02,2.6356088682531836e-01,2.3610173240249474e-01,-3.6258156301229000e-01,-5.3184976849630179e-03,-1.1337079093213168e-01,2.4194275389693631e-01,-3.9650995665385005e-02,-1.5394255600376877e-01,-2.8878880510085231e-01,1.0912710116299315e-01,6.5511953023260655e-02,-2.2675529185739010e-01,1.4845168245668489e-01,2.6662431502459355e-01,-2.6699724683925652e-01,1.1804765578286470e-01,2.7034607344544143e-01,-2.9124798983874069e-02,1.8659803095287675e-01,3.2531841884026447e-01,-1.9220485034562579e-01,-7.1129918144703680e-02,3.2324203853373520e-02,-2.9119208202871286e-02,-8.1243699293400251e-02,1.0958915213611704e-02,-2.0472653538854377e-01,-2.0605219186432167e-01,3.2462516862593258e-03,-1.0464104583486782e-01,5.2258886371111077e-02,-9.3232398717999515e-02,-8.8629921498410494e-02,7.2597392352622796e-03,-3.6212862691178471e-01,-1.1230665019182964e-01,-1.6117801759002229e-01,1.0735577622987602e-01,-2.9906346854010668e-02,-2.8614555487764481e-01,-4.1401230737374828e-01,7.9709893391978176e-02,-2.9383464791605285e-01,7.7747228257421030e-02,-1.0711066502829691e-01,1.5518054121803466e-02,1.2857307046356459e-02,-3.3908921511939932e-01,-1.4269518026207094e-02,1.0637864499711182e-01,-2.1348609834539556e-01,-5.9810872816217775e-02,-2.4102617921943070e-01,-1.1864213015207666e-01,1.4798138085188312e-01,3.7883745893921260e-02,-4.1710699467086959e-01,-1.1668298779714018e-01,-5.9963805872477148e-03,1.4210834353087215e-01,-1.5018285093234127e-01,1.4001164141343933e-02,-1.0022914566177937e-01,-1.2318716273167570e-01,3.2034358367486931e-01,-1.1694881452866007e-01,-1.3477819104546870e-01,-1.0192824874028543e-01,-6.9918716570262801e-02,-2.6418794410607294e-01,3.8594308654306719e-01,-1.7205094931770009e-02,-2.7322291847456923e-02,-3.8289308684036377e-02,-1.3122463983179972e-01,1.1008699218639723e-01,2.8259212451489818e-01,9.6117517489591797e-02,1.5241090661220796e-01,9.8887828560188545e-02,-1.0461830555694435e-01,1.6784604166112510e-01,9.1097900669483700e-03,5.0275694724044463e-03,3.9066758443447602e-01,-4.2692290336715198e-02,2.4222864482654738e-01,1.7447696854854400e-01,-2.1152274845747832e-01,1.5876252731567203e-01,-4.8135141187586311e-01,-4.8159152660963073e-02,-1.9304131164742594e-01,-1.1512252746984648e-02,3.4800341028282014e-02,-8.3358558039360958e-02,-1.3043127779704763e-01,1.8331241951660604e-01,2.4904794001439046e-01,2.1221776100620982e-01,-2.8721346218760758e-02,-2.3565292773923854e-01,2.4439476331928785e-02,-5.4352301448921142e-02,2.8861884745045568e-01,-1.9393849841252597e-01,-1.0369793471789918e-01,-1.7633112045271168e-01,1.2614894102330397e-02,-1.1382657209803129e-01,-8.4317748024064096e-02,-2.8632897531812673e-01,3.0870331225332220e-01,-2.1881346158909715e-01,4.5065736675389517e-02,9.7188243254956147e-02,-2.2251755509613901e-02,-3.1429804339165646e-01,-6.0733250715969272e-02,2.6843010165145864e-01,-3.4923218286187929e-01,9.1484701561208512e-03,-2.7116498211231004e-02,-2.1903602903315234e-01,-1.7118471509928704e-01,-3.3824270501457560e-02,2.8841813665507460e-01,1.8645391078492432e-01,-2.2485077330246961e-01,4.0940899894943747e-02,-1.6047341215203897e-01,-6.8279154645064663e-02,-1.3853145651544743e-01,-8.6493770401079278e-02,-3.9745654943796321e-01,-2.3002790628743022e-01,4.9463420620353166e-02,1.7078911806891311e-01,-2.9307011255583149e-01,-3.2626476934113258e-01,-1.4165052745861981e-01,-5.2273718214445958e-02,-1.0176303924114305e-01,-2.7552765788261921e-02,1.1093063156371230e-01,-5.0876113432631126e-02,-3.0440197300439321e-02,1.4583985650888659e-01,2.5947162459289675e-02,-8.9002160156014407e-02,-2.4769852073002516e-02,-8.0709725663791920e-02,3.8324508581113664e-02,-1.6537353809332053e-01,-7.0858129604910405e-02,6.4010780820380586e-02,-2.8467959554541572e-01,1.5206499181393962e-01,-5.1686353552427466e-01,1.5160409858679888e-01,-1.3160038341894895e-01,4.7037739454735820e-02,-4.6996504569654001e-03,-4.7136048976391169e-02,2.7934398324445492e-01,-2.6844813357153202e-01,-2.4114907760816168e-01,3.1380145283826311e-01,-4.1547006333839925e-02,2.1317546332019871e-01,-3.6592550539970714e-01,1.1189639730762414e-02,-1.3423398431937583e-01,2.0395053409516287e-01,-3.1302235809451878e-02,7.4495941222878212e-02,1.9786517963653440e-03,-1.1536669454972191e-02,-6.0595723557256537e-02,-2.7667850226625691e-02,1.2959926592148049e-01,-1.7941042889928535e-01,-3.5027255368876065e-01,-1.8969999101789914e-01,2.1581445069771119e-01,-2.7648358985584159e-01,-3.2290251172956218e-02,-1.9020857125080504e-01,2.2398325039938063e-02,8.7408139066303125e-02,-2.4832608334614684e-01,-3.7545109431089199e-02,2.2572951800660199e-02,-1.3303507846043858e-01,2.6132721050566143e-01,2.6460365563960239e-02,-1.7888485356913751e-02,-7.0472456515926055e-02,8.3696237088435391e-03,2.1715390683596961e-01,2.5673896689785303e-01,-1.2390483089756668e-01,-2.2312766081202273e-01,1.2703661942614158e-01,-7.0930950863476713e-02,-3.7982257782097045e-01,8.1721355892482195e-02,1.2049541872020959e-02,2.1215811516896244e-01,-1.7415791096279948e-01,-1.6621196241349642e-01,8.4540975892765990e-02,1.7917841458922643e-01,-2.6052949746103604e-01,-5.5376370774606429e-02,-4.5938727577850114e-02,-2.6484210984319939e-01,2.4191144513999122e-02,-1.4677364942038640e-01,-1.5933476602965368e-01,-7.3957998891119592e-02,-4.6752200998394788e-01,-9.5857617884469670e-02,-8.4032691450292185e-02,-2.8446312480188654e-02,7.0969203790943666e-02,6.9820200349986067e-02,-5.3415896681264846e-03,-2.0928596120989243e-01,1.3596227389055202e-01,3.5813620577909600e-01,-1.9941034696854210e-01,1.6014202094392094e-01,-2.5299695755021612e-01,-7.2140453444228730e-02,2.0836653714363473e-01,1.6173090918743516e-01,2.2768544320085758e-02,-4.8555676787152435e-01,-2.2323357498558247e-01,1.0884225249960078e-01,-2.9087913716801717e-01,3.5529903481151051e-02,-2.7997049483767922e-01,2.0526640134394231e-01,-1.0797719363598368e-01,-1.2591724467625823e-01,8.4971648109808617e-02,9.3290712102764101e-02,-1.5998397226221223e-01,-7.4353280095357617e-03,6.9392857207317013e-02,7.9144716765270434e-02,-9.8287283127052177e-03,3.0423504444083360e-01,1.6768921656594876e-01,-2.2150025419370925e-01,1.8689611804124928e-01,-2.0190758376483434e-01,-1.9754889727501276e-01,-1.1841914891716669e-01,6.7704750590689186e-02,-2.6325830330023320e-01,-1.2992445907789840e-01,1.7840138885647638e-01,1.8630337557479670e-02,1.8783260455239839e-01,-3.6785286983065782e-02,-1.0461843456274134e-01,1.0719719433974872e-01,-1.0901800267065115e-01,-6.3641984864230505e-02,-6.7093405256035937e-02,2.5394554438005795e-01,-1.3117288401536337e-01,1.7665266839112381e-01,-1.9452762557848566e-01,1.4479315109086655e-01,6.5169069495274526e-03,-5.4661468209969721e-01,-3.0574674222117394e-02,1.4570728706641356e-01,6.7099116402409523e-02,-3.0552042095737059e-01,-8.0828721443825510e-02,-3.2010507319709380e-01,-1.9799749478034623e-01,-1.7443059545860151e-01,1.7493581423979632e-01,8.3051590942948506e-02,2.5236821057998027e-01,3.8417348965226396e-02,3.5375455924172190e-02,-2.9655359961112177e-01,3.9249666435134134e-01,1.8808976162546481e-02,-1.2392351062820352e-01,2.3303566115188701e-01,9.9435288062549018e-02,-3.9066085378936959e-02,1.0841592478741355e-01,2.0057263086490895e-01,-2.3975979691898727e-01,-6.5675402691479812e-02,-1.6610957963932352e-01,9.7110981393943613e-02,-1.1411936038035553e-01,-2.1489091233570018e-01,1.4629128900910976e-01,-9.9058960364497045e-02,-1.9665327738106050e-01,1.2762686747155180e-01,1.9442876281233845e-01,1.0825984077479721e-01,1.5345782549740500e-01,-2.9062035545514253e-01,1.4763037518262223e-01,1.5692968208196251e-01,6.5159797378668380e-02,-6.5664406106847983e-02,1.4975246211160913e-02,-2.9936089566498736e-01,1.7332072831854958e-01,2.2737717486753548e-01,-4.0168997124019383e-02,2.7264425581093387e-02,-1.5000681439023877e-01,-1.5793082501665873e-01,-1.1329727747412889e-01,1.2348894053935043e-01,-3.0027335818500700e-02,1.2583067644026297e-01,4.5102561058132186e-02,-4.1942614540778224e-02,-7.7477621126007326e-04,2.8502629881107810e-01,-5.5353536318387020e-01,-2.8407467570593131e-02,2.3471043444848569e-01,1.0354454843418756e-01,2.1696645712890977e-01,1.2711279178794926e-01,2.5358907873483747e-02,-5.7487084164340820e-02,2.3291574590482320e-01,-3.0941987046982700e-01,1.6277943731784933e-01,-2.2104892070246876e-01,-1.6969879777167621e-01,1.4985806175795283e-01,-1.8879188997889165e-01,9.8945533300923177e-02,2.9511574168072036e-01,-5.7002606233476333e-02,9.4330606170032000e-02,-4.2640824384677846e-02,6.0353336558073352e-02,6.0457084884555451e-02,6.4387351194921144e-02,-4.3744641673784268e-01,-1.4782726960129292e-01,-1.0703018361509638e-01,1.1500271071661809e-01,4.6486927847657594e-01,-3.0627810930409956e-03,-2.3496888280193640e-01,-1.0959126747924038e-01,-8.3454361729176970e-03,-1.1027922810491621e-01,-4.4527335055357525e-03,1.4796749445395718e-01,7.8356198828055584e-02,-3.2824721129181687e-02,2.4424917842591826e-01,-1.4605872378899462e-01,9.1133423128732474e-02,-3.6359419482046151e-01,3.7766350754028455e-01,1.0384730639978500e-01,8.8891183533353985e-02,8.3705504338885944e-03,5.5217324399252511e-02,3.3961078844520970e-01,-1.8217178931268943e-01,1.6197421585980284e-01,9.2489520230276331e-03,-5.5476723713499966e-02,-7.7242831868456749e-02,-1.9563046432315170e-01,2.1884496024551295e-03,1.6942344814557978e-02,2.9966926962457147e-01,2.2886142336058646e-01,1.4757674934240400e-01,6.2679076619985979e-02,-1.5712858300011337e-01,-1.1907861088093584e-01,-2.0867589101615988e-01,-2.0203940625386912e-01,-5.7659646784639043e-02,4.0132749233617232e-02,-3.0738225588413992e-01,-2.2168138465455581e-01,1.1040680241171469e-01,-1.7420332400931191e-02,-1.0122202728369728e-01,2.2420222172170692e-01,2.1470034522174200e-01,1.5401110208672719e-01,1.7732079344436830e-01,1.6385285098657837e-01,-1.7157789669204632e-01,1.5695329193996920e-02,-2.0188002513585909e-01,3.8907019269371436e-02,-2.8879121794622020e-01,3.3562971157323140e-01,-1.9827675828063743e-01,2.7322244053681066e-01,1.4937496465902045e-01,-1.7087699930961174e-02,1.8318797099054564e-02,-1.0523313760504532e-01,1.4099810696170323e-01,3.9230934324331634e-01,1.0543132116323597e-01,3.9729706404515119e-02,-7.6085994570396498e-02,-1.7470188148181845e-01,-4.9172490091486859e-02,-1.1767794195131207e-01,3.0774589672540081e-01,2.4391826389290674e-02,1.5590615509505121e-02,-4.0993446128539793e-02,2.9015976719347963e-01,-1.5924262730629357e-01,-3.9359111170254285e-01,2.3449233586269281e-03,-2.3516301675658752e-01,-1.5281578323689174e-01,-1.6565510257838656e-01,1.8064135316561020e-01,2.3088690988306057e-01,8.4237938720558889e-02,7.5055124745343010e-02,1.2885952443427393e-01,7.6696188503256615e-02,8.4704534505987680e-02,-3.9529849032906988e-03,-8.9965656860529375e-02,3.3784903797627615e-02,1.8706258446500165e-01,2.5768811402125787e-02,3.5915553939699502e-01,-6.6722653963684209e-03,-2.1756877002789890e-01,-1.9544050953431605e-01,8.0782112129761247e-02,-1.6732052247381089e-03,-4.7370103178163714e-01,9.0471032131821144e-02,7.0771742817356723e-02,3.0271864921418284e-01,8.6394675199121598e-03,-3.7769097621194248e-01,3.7971208709199164e-02,-6.0024508579368738e-02,1.7165052122926228e-01,2.1345369584691857e-02,-3.3421363216281946e-02,2.0888140051157655e-01,-2.2813487995384069e-01,-1.8885479331838778e-01,3.9090600527000294e-02,3.9279986711888065e-01,1.1104539182239451e-01,-8.0282922100743948e-05,1.1975619774564339e-01,-6.6554702320098386e-03,8.9526059829578564e-03,-2.4832083310454878e-01,3.7276900371963761e-01,-4.4814520898019558e-02,1.6123249634267373e-01,2.9529193547781185e-01,2.6421444253093253e-02,8.5943674242061462e-03,5.6656884032064841e-02,-3.9663684950745549e-02,-1.2576575252700861e-01,-2.7091081756537083e-01,-3.5146890125776836e-01,3.3630163969098237e-02,8.8729236660329364e-02,-2.8158148900924429e-01,3.5730825232311170e-01,1.4943446589233989e-02,-1.2986911634366777e-01,-2.1910389507925290e-01,6.6474121276486095e-02,-4.1825946428298184e-02,-1.1121252601350536e-01,1.2500516330061373e-01,2.0131911167169406e-02,9.4608189649314865e-03,1.8874857627440397e-03,7.0573291177103981e-02,-1.7619744234870019e-01,2.2647252691700803e-01,1.8168275802883921e-01,3.2904369673064249e-01,1.9682480707884456e-01,1.0723987041279780e-01,-9.3391021525237844e-02,-3.4534923690977026e-01,9.4535905651816063e-02,-4.5333270385327341e-02,1.8582212448271349e-01,-2.1137940529817256e-01,-2.3126127935199087e-01,-1.0121161874940669e-01,4.3855138407597705e-01,1.9721127907224006e-01,1.1103039402212852e-02,4.0366688122831999e-02,1.0350815835277496e-01,2.0239238236448659e-01,-2.5848531553890719e-01,7.6027936425536846e-02,1.7435063529866388e-02,-3.8375129960298560e-01,-2.2716588767976714e-01,-1.6002913446052888e-01,1.0332207974167641e-01,4.7228661677411188e-03,-2.2497999590923620e-01,3.4667469750825053e-01,5.6291078335322015e-02,-7.2684384224517479e-02,-2.4662794848462891e-01,1.3064311172302384e-01,1.3511413140181525e-01,-9.3681739305805783e-04,1.3131794865177951e-01,-1.0677336524841381e-01,2.6892858598067265e-01,-9.1023150149209836e-02,6.4175717002048341e-02,4.4725287648145970e-02,-4.1930289541410946e-02,1.2142966601677764e-01,-1.8907914934724096e-01,-1.7266379517251770e-01,-1.0713610955568173e-02,-1.9874742276785921e-02,-1.5051317290922184e-02,1.0893808287091335e-02,-3.0917454732246802e-01,4.2962920645353064e-01,-1.0541264197397873e-01,2.1004360563817720e-01,3.1649783885889772e-02,1.0067206771275591e-01,-1.3737619599851009e-01,4.2581313889101427e-02,-1.4747470356124118e-01,-2.0820586740024280e-02,-1.9620375452945457e-01,-5.1355080286305449e-02,-1.6903924203694723e-01,3.7179982424487928e-01,8.7810462957365235e-02,1.9152436328265542e-02,1.2103266223851034e-01,4.7803372190708793e-01,1.1240354336661419e-01,1.2166650695559127e-01,3.4227352074976680e-03,1.6030811361890336e-02,-2.2709861099810266e-01,7.5575754755650260e-02,-4.9703953746793222e-01,-7.9609473656649721e-02,2.5993176154622391e-02,7.8321689788392698e-02,-1.2875335381779363e-01,1.9291578775813292e-01,1.1216385536905452e-01,2.4166289111441284e-02,-5.9663955349144038e-02,-4.5782980843000853e-01,7.0288979386155581e-02,2.2197445773105177e-02,8.3831423176700018e-02,2.9689386960492302e-02,-2.3705256721636844e-01,1.7091221586850303e-01,1.5688021032852215e-01,-1.3624654426228777e-01,1.6849548262367845e-03,-3.0081111692992635e-01,4.1621274973147104e-02,2.4864122616400608e-01,-1.2044182425161779e-01,2.0510198700737398e-01,8.6224965832158176e-02,1.1390993515867869e-01,2.2365967289754415e-01,2.8380870645940467e-02,-5.1381641578406870e-02,-1.8236836101372828e-01,3.1581688008818311e-02,-9.5766150049658952e-02,1.8154608823041057e-01,1.5317923951351917e-01,2.8101875279726213e-01,2.3078290651886957e-01,3.5078505598136987e-03,-3.2590395204499567e-01,-1.4693225300269680e-01,2.2993393392408934e-01,2.5690348114361139e-01,-2.4614589709505019e-01,4.1743079952092699e-02,-3.7591656376767063e-02,-2.4496514193728494e-01,-9.1276822979176844e-02,2.7135830609024209e-01,-2.8529350258204789e-01,1.0990931033815197e-01,1.4005699778644645e-01,-8.0506846623615097e-02,-2.6368292627239004e-01,2.5426145823971458e-01,4.2242073709538634e-02,1.4827761783665062e-02,1.6448634883732793e-01,1.8005047219005699e-01,-1.2772404506368884e-01,-6.2308945136310585e-02,-1.1555526192469609e-01,-1.0439798564484846e-01,-7.3087984998245939e-02,5.9377742471086625e-02,1.5759947210589859e-01,1.0048859965447575e-01,1.2305678944023772e-01,-2.9800545114314275e-01,2.6377305186564148e-01,-1.0325930593202244e-01,1.1517544226545430e-01,2.3761384030073282e-01,1.4819845909223552e-02,1.7437773958919917e-01,1.3487221463197469e-01,9.7347268107969620e-02,8.6483159234417933e-02,3.5958405731502702e-01,3.2491970240193435e-01,4.5115797821165149e-02,-1.6542674094731438e-01,3.0177170993741570e-01,-3.0110038989029281e-01,-2.5717934026340522e-01,-4.6656557398873692e-02,-6.7544755221431066e-02,-2.5009384675580654e-01,5.7734683167041299e-02,-4.0515794916305567e-02,1.2248305104249058e-01,1.5557303851898588e-01,1.6422268287875996e-01,-5.3946339656338571e-01,-1.9626712693970694e-01,-1.1389626921663454e-02,1.9630188916600325e-01,1.1526616883188254e-01,1.6436097942249508e-01,-3.1484443218071242e-02,-2.1860890268575844e-01,-1.5365345488777071e-01,2.8064777524021305e-02,-1.1764177641574416e-01,-4.0012048286212964e-01,2.0655770856871369e-01,1.2103205772461870e-01,9.1453115855437528e-02,-2.5030421179285372e-03,1.1959465264067018e-01,-1.1938860999148197e-01,2.1954970704976581e-02,-7.3606300952341469e-03,1.4095397789164091e-01,4.7643538820192274e-02,4.2874841236700614e-02,-2.3409835870093817e-03,-2.9686283346521003e-01,-8.4448476755431434e-02,-2.3727914718491375e-01,7.6604399405597587e-02,-2.0303296213401228e-01,2.3536351264765526e-01,-3.5413777014266373e-01,-3.7656645345966293e-02,-1.0138117411705537e-01,9.4634725941987727e-02,-2.9779045974974772e-02,7.7445887310190614e-02,-1.6770482105927878e-01,-2.2856089703434881e-01,-1.2748114298420779e-01,-4.4261329811287838e-02,-7.3514523184284378e-02,-1.8115505008584365e-01,-1.2365778254449096e-01,3.3558216898725035e-01,-3.2423542837336899e-01,1.9165387832501123e-02,1.9432008965694476e-02,1.2393771604575134e-02,-1.1222533619509621e-01,4.0057275084562538e-01,4.0557421614790506e-02,-1.0569388474639770e-01,2.9603837350003592e-01,6.3161655288340932e-02,-8.3258544218210676e-02,1.8253837510406043e-01,-3.3707446403584196e-02,-3.0643518234143807e-01,9.0193505948171354e-02,-1.7160642182194522e-01,1.6468755544847502e-02,3.3838328879812751e-02,8.0145786619001708e-02,-2.9171457379252291e-01,1.0419814738929378e-01,1.9916833170238246e-01,-3.5962982440043825e-02,4.2926609053267278e-01,6.1620771964060107e-02,-1.4108175274769347e-02,1.1384908491401144e-01,-1.5565148895168329e-01,3.3678369124090296e-01,8.8207093086823840e-02,-2.3690427833322450e-01,8.7488974945011899e-02,-1.8486429210293026e-01,-3.4825776496913707e-01,1.2198679946352278e-03,9.3909856969828329e-02,1.0362014938170969e-01,-4.3944830722369627e-02,5.7372946561321789e-02,2.2354255980915128e-01,1.4392416547595066e-01,-1.8503046219899638e-01,-2.0506877622058989e-01,-2.2933384143769173e-01,-1.8855157539690315e-01,9.9376186939953513e-03,-4.7508238774385578e-02,-5.6806069492829625e-02,4.5832520220019136e-02,-1.2515588921636539e-01,1.5035475296077994e-01,1.3005184101616907e-01,2.0654943800341441e-01,1.2005595369542049e-01,-4.9312467778111435e-01,-3.5408487445274028e-01,-9.6916214460162201e-02,-2.2620246859534723e-01,1.9353211532716943e-01,2.6429185201384209e-01,5.2588540870208304e-02,1.1633360354320893e-01,1.0848121232253439e-02,8.4255985102228370e-02,3.8840580535238763e-02,-3.0911789067667372e-01,-1.4731564200517555e-01,1.1900105909576518e-01,8.1471820442556034e-02,-3.7643531868268137e-01,5.9883179937124581e-02,5.5093683424644144e-02,9.6818529011254845e-02,-1.5870063549671940e-02,1.5037846481297165e-01,1.7663330961583357e-01,9.6934993687151250e-02,1.7551976950672768e-01,-4.9393519389414375e-01,3.1203231176853585e-01,1.1037434057873859e-01,-1.2768052113567649e-01,1.5916216861937349e-01,1.0707787962494925e-01,7.5612490192534715e-02,-4.9859568176208492e-03,1.1803251478442051e-01,-2.9749342546238827e-01,8.4221788200896305e-03,1.7951378089495326e-01,9.7619601886864429e-02,-1.9571797003374003e-01,1.9841880393058067e-01,-8.2146654614202702e-02,1.5441276168451676e-01,1.4318361639020286e-01,-4.1732661966556797e-02,2.5003523145702922e-01,-7.9753219914740270e-02,-1.3787856753339739e-01,1.3248173987344100e-01,-1.1114231752140463e-01,-1.8046042108026014e-01,1.7973876770704934e-02,-3.0130418182284469e-01,4.4109871234802790e-02,7.0349771519161858e-02,-1.3254576991575229e-01,-5.0043364252788367e-02,-2.5776585124582196e-01,-1.4750116481061284e-01,-2.2055858738351791e-01,5.2272715952962614e-03,-4.8005914545896346e-02,-1.5303377137951116e-02,-1.6733387458417301e-01,-1.1430280900223756e-01,3.7639171712397407e-01,2.5245556347789933e-01,1.8424184472028812e-01,-1.7090931718303107e-01,-2.4332620593466533e-01,1.7597312387317574e-01,1.7264340092275279e-01,1.9503642525583592e-01,1.5309703162891808e-01,1.9492897762697897e-01,-4.2472379272067637e-02,1.6445584918511241e-01,-1.4748065933061039e-01,-1.0531801213510496e-01,-3.4965769612738412e-01,-2.8077755297505530e-01,1.8850414330936838e-01,7.8851821812381470e-02,4.1289386346542818e-03,-7.3106831536199388e-02,-1.4490915644456155e-02,-1.6149415445600362e-01,-2.0588479721419181e-01,-5.8322335241341748e-02,-1.4382773540317836e-01,1.4562928681471141e-01,1.6215733265702253e-01,-8.7163780375677541e-02,-3.0279459983784085e-01,-3.9331775620683695e-01,-4.5265290317789628e-02,-8.0374115452546746e-02,-2.4007273315132782e-01,8.2443424648384375e-02,-8.5121045738245874e-02,-2.0700803512812629e-01,1.8304064975344100e-01,-7.9016576627548088e-02,1.0972021049688890e-01,1.6068049171073223e-01,3.5351829768201987e-01,-5.3555410458566086e-02,3.5296513712509903e-01,-6.4443286264748115e-02,3.2694764437928403e-01,-1.6531474902126200e-01,1.6052696073220581e-02,-9.3180665532565196e-02,4.2382660651444415e-01,3.5202877943238775e-01,1.9566032463557606e-01,1.2828326927512265e-01,-1.7122727968602203e-01,2.9139403198155645e-01,-1.7750141717736388e-02,4.3001270757688212e-02,-1.1716737650580721e-01,1.9398139479909666e-02,-2.9230925378250022e-01,2.7004141488530470e-01,-5.2464510836325390e-02,-1.3057399409851025e-01,-3.1474232155482902e-02,1.7573195489267522e-02,-4.1492253401336603e-02,-2.2704779315977736e-01,1.1970791116153806e-01,9.0914701355758049e-03,1.4109977529033244e-01,-3.1233110467968900e-01,-1.4731586103372923e-01,-3.4512172977582141e-02,2.1945952349916276e-01,-3.2606826500885255e-03,-1.0118023750701466e-01,-1.4629913381824303e-01,3.8075604067874719e-02,2.0600741107343573e-01,-1.8906209275441582e-01,-1.1640140806148332e-01,2.6719948339695744e-02,5.4667529350231003e-02,-1.4983172798516670e-01,1.3294781116360424e-01,1.1754074918349339e-01,-2.4515196991455585e-01,-1.6204344405187315e-01,-1.0488319159400696e-01,-5.3376324398323238e-02,3.2742511685071091e-01,-5.7624867602911731e-02,-2.1110465508874615e-01,-7.5570470722186742e-02,-3.2979948530339220e-01,-3.8818968059811038e-01,1.6990802501408450e-01,1.0837483104280533e-01,-2.4550852605913637e-01,-2.8059578559780490e-01,4.9040616853190118e-02,2.9918915616148578e-01,-2.1334677590708478e-01,-4.2691406188117072e-02,-4.4108321332044308e-02,-2.7140190498879418e-02,-2.1527056327148530e-01,-4.2251250710223620e-02,-5.3886987070625558e-02,-1.6732765922329731e-01,2.7893753018711026e-01,2.1246922897644607e-01,2.9617904261830408e-01,-1.3044155300778093e-01,-3.5224061417181013e-02,5.1562224927470035e-02,8.3811393254476355e-02,-1.7084582409382382e-01,1.8869516502603048e-01,7.8513037267782651e-02,-3.3659007318749651e-01,-2.5591113512213215e-01,1.6940304902046212e-02,8.0464816582507565e-02,2.7746693460261648e-02,-2.3556386621728204e-01,3.5763142285170685e-01,-1.9689790329282250e-01,5.7380331073378865e-02,8.4025052959400784e-02,-1.3222334531970370e-01,2.9475742275302313e-01,1.9400290178113885e-01,1.3072465016172763e-01,-4.4253830387571982e-02,-2.3825255664080836e-02,1.5483741872541529e-01,-9.2915176259203924e-02,2.2221859146053657e-01,-3.3384186286055401e-01,3.2821270420331916e-01,-3.7305842506081821e-02,-2.0080860148032481e-02,2.4173960787819634e-01,-2.4636681669145455e-01,1.3273669803474636e-01,-6.6430401437985218e-02,-2.8222803342275657e-03,9.2302004666192511e-02,-1.7835367873703589e-01,-1.0836242098516019e-01,-1.9653658858386294e-01,-1.6662904673882792e-01,-1.8656132709614556e-01,-3.7157196536125503e-01,1.9790971971580459e-01,-1.8125887558600373e-01,3.3746811879556654e-01,2.3804761089273305e-01,8.4753898273706690e-02,-1.3435292715842939e-01,-9.2342232814191100e-03,5.1963702608848070e-02,-1.9701029470571915e-01,3.7239486640476195e-02,-1.0057952442977559e-01,-1.0880363180834947e-01,-1.0722028952606449e-01,-4.7720335982680752e-02,-1.0742604853081468e-01,7.7036109762034871e-02,9.5796241642354368e-02,1.7111102821132040e-01,3.2594160356115326e-01,3.3354532477213339e-01,-3.6841999541395987e-01,-2.4251821386083106e-01,1.1313814569150644e-01,-6.8918072187913737e-02,1.7339537734377974e-01,-2.1847549757164431e-01,9.1496420304526094e-02,1.4971149527660577e-01,2.7492880962359306e-01,-3.8082055194158498e-02,-3.3723719841315003e-02,-3.3385831640210423e-01,1.0809632461229823e-01,-8.6934231768928644e-02,2.2650688048684028e-02,6.1382258666185345e-03,1.8876057507714533e-01,-2.3706796488479512e-01,-2.0750302917937183e-02,-2.1111095022426202e-01,-1.2261571688970044e-01,9.5186947416942974e-03,-1.6760904090564493e-01,1.2814742371175880e-01,-4.1212545267047701e-01,-1.0615752466399755e-02,-2.1025223260401038e-01,-1.9859425116679791e-01,1.9145680008429117e-02,3.3923673832797568e-02,-2.0408945365091186e-01,-1.1841550295630021e-01,-1.5249140164772854e-01,-1.9922079193971123e-01,-8.0425567237636539e-02,6.1479370918094037e-02,5.8942241797632515e-02,-4.1219434921623999e-02,1.9208665304991368e-01,1.6697521290566175e-01,2.2920871327747852e-01,2.0801708355950460e-01,-6.1363813648118742e-02,4.1273604403428185e-02,-7.6003143615871363e-02,-4.3034453842490034e-01,-6.2427196057337986e-02,6.9056231360086789e-02,4.4440205288886270e-01,-5.0597920417509337e-02,-5.9177786129513119e-02,-1.9210260218107361e-01,2.6591982086456446e-02,-6.3078405567750406e-02,-1.1024177034228065e-01,-1.2158098408483778e-01,2.6981539491270151e-01,-1.8707606700782611e-01,-4.7211551139900367e-02,-8.3098862518109468e-02,2.1875354195742766e-01,-1.9425623209935766e-02,3.7371675824391848e-01,-9.3919086466740812e-02,1.5292495586402599e-01,2.4141039790169597e-01,2.1497255552477423e-01,-4.9494423727815269e-02,-1.3291308589445333e-01,2.6136727138601695e-01,-5.2154615845059725e-02,7.9147802859661026e-02,2.1141266332353412e-01,1.3679829595736076e-01,1.4265825276611890e-01,-1.3018390203095054e-01,1.2162302554949353e-01,1.5932838508865918e-01,-4.5049121030272254e-02,-2.9628670396129164e-01,-3.1546168333923486e-02,-4.0647343023561787e-02,-3.1188928701190649e-01,3.2171806149019572e-01,1.9141439492627121e-01,2.7603201062244148e-01,-1.0947067131693593e-01,1.4067627859162568e-02,-1.4481093205305190e-01,-2.1587686432944322e-01,-7.2013505544977943e-02,-1.3562416067197031e-01,-3.2691685102569507e-02,-2.4668043725940988e-01,1.7237852740428472e-01,-1.0066156358415615e-01,2.1960169633486235e-01,-1.8287004218757885e-01,5.8424154149072677e-02,1.4796593640176200e-01,-2.4254545706862962e-01,-1.5620350866167179e-01,-1.4127498441190298e-02,1.1345350104910914e-02,-1.6077775311256565e-01,-1.2209408212037383e-01,2.4036647234832089e-02,1.6038051433757014e-01,-4.7849580200247654e-02,3.0191614452272186e-01,-2.7925931253763164e-02,5.2518338796625597e-02,-4.7219831751655811e-01,-3.2330637961738834e-01,1.7704297119379611e-01,-4.1440317405836896e-01,2.1329628841797613e-01,2.8300576510072711e-01,1.8991614470740201e-01,-8.5968809640066639e-03,-1.6654158013427570e-01,2.8099695212766679e-01,-1.9595851457076829e-02,8.1772592360474641e-02,-1.0760195518176169e-02,-1.9911217012896901e-02,1.3524286373373606e-01,-1.3670545376565643e-01,-1.0945082139924633e-01,-1.4853083656362875e-01,2.2413253684494913e-01,1.1875141812860604e-02,2.5708824848895563e-02,1.3640997498152765e-01,-2.7730629618935826e-01,-6.3961323315653976e-02,2.4494560922418745e-01,2.4755768066736664e-01,1.3957791625560884e-01,1.6489778299951230e-01,-3.0944227918340550e-01,-1.5833929491433379e-01,-8.9762953459352743e-02,-4.9227528571376807e-02,2.5124601396746757e-02,2.3241553996917541e-01,-1.3217995315295300e-01,1.0409290432060010e-01,1.3322588738135394e-01,2.5912044144123975e-01,-2.5977179147633156e-01,-1.2616511505060485e-01,1.4706049798750520e-01,1.1713344339711332e-01,-2.8461496007132547e-01,1.7812380695289359e-01,2.4233129191009978e-01,-5.3727370264643887e-03,-2.0271973421599615e-01,-8.2201351498613517e-02,1.6936638230109588e-01,2.5436580224273220e-01,-2.4540935905312972e-01,-5.1857187335692376e-02,3.1481114845128749e-02,7.3814379863711796e-02,1.2885964467339237e-01,3.1360842510151721e-01,-2.1247579992754959e-01,-8.8136478982618796e-02,3.6845930516523384e-01,-2.3735685364207712e-02,-1.5400589555386923e-01,-5.8419790695779142e-02,-1.2281995412547856e-02,-1.1064081624704643e-01,-3.9243838568154871e-01,-1.6818672041164279e-01,-1.2642572421729795e-01,-6.5249373010700593e-02,-7.9407249420630835e-03,1.1755690746832595e-01,2.3717094271823551e-03,4.2189598757263286e-01,-2.4612123423873902e-01,1.2818123149959118e-01,5.3967179249810579e-02,-2.3855174134139129e-01,2.3823160900324183e-01,3.0577786077711664e-03,-5.4164998346457570e-02,-2.5578909666450278e-01,-1.9977479208526702e-01,1.3633523741833328e-01,-8.8291953687074556e-02,-5.4582936563034291e-02,2.3283364051849362e-01,-1.1373958059802571e-01,-3.1682116428882308e-02,-1.7582417209072776e-01,-1.5484835319802931e-01,3.0536508775645910e-01,-1.6082512515256481e-01,1.4074052751903346e-01,7.9245206407623600e-02,4.1330939810073089e-02,2.2688889183897357e-01,-7.6514192012643673e-02,-4.1120896050537781e-01,-1.5278012845665906e-01,-2.3283999555455320e-01,3.3417641371129320e-02,-1.5434994192577781e-01,-4.8126454570872952e-02,2.2455108245232644e-01,3.8536732434152496e-02,5.5046200344106566e-02,-3.1694328973646262e-02,7.0828785508413178e-02,-2.0279621300118045e-01,4.4028835198210470e-01,8.2656826360798796e-02,-1.1298750566404296e-01,2.0423625995934333e-01,7.0894029757367860e-02,-5.6611114120991304e-02,1.5664165981312017e-01,-4.1390915481571505e-01,-1.7838391863086589e-01,-6.0407764268650063e-03,2.1108572365878459e-01,-8.7877023797824333e-02,-1.1333136891065845e-01,4.9533424135596971e-02,2.8329155770641934e-01,5.8653981907928907e-02,-8.6734022790126930e-02,1.9378812174884803e-02,6.0681069254229704e-02,3.2767331569564379e-03,4.8877905454176036e-02,-1.1708478342649528e-01,1.2078551929633628e-01,-5.9910247720180804e-02,-1.5554736622010634e-02,-2.1788454728039941e-01,-2.1195115013971524e-01,-1.0846166179599054e-01,-9.6749954392673518e-02,-2.0129972677186331e-02,-1.3006970884454849e-02,2.0725486211412525e-01,-1.2283343752439201e-01,3.1833543365713446e-01,-3.7051056749608030e-01,1.4535302787691634e-01,-2.8484741386399592e-01,-1.5733332536968839e-01,1.2484206694253963e-01,-5.0519154159694712e-01,-5.7991633137676010e-02,-1.5499730529820688e-01,-1.7636136045466663e-01,-5.5930536235604109e-02,-8.6849622559898212e-02,7.3679461945295080e-02,2.0377555559406840e-01,-1.5912204620250413e-02,1.2553132771915754e-01,-1.2619006704663852e-01,-6.1969837138458453e-02,4.2719776465487957e-01,-5.4123114945699338e-02,-7.9717858649914763e-02,-2.4363800969832808e-01,9.4961289956566913e-02,1.8941218922079958e-01,2.0415000717324969e-01,9.7639677129440113e-03,-2.1074679900801513e-01,-7.9600190352250813e-02,1.8331008161238690e-01,1.0579681285102518e-01,-2.2068039316080934e-01,2.9689627890879720e-02,-1.0731928183643828e-02,-2.0648374954075363e-01,-2.3907790310510585e-01,1.6608135524022405e-01,-1.6967712621150621e-01,-3.1705332709585136e-02,3.4938120950434043e-01,-3.1641544211476069e-01,-2.1752907455121029e-01,1.2669283759477826e-02,-3.5878939901750606e-01,-2.4115264490726211e-02,1.1342352332330130e-01,-1.5505879434329950e-01,2.2307769537911859e-01,-5.8716495960049103e-02,-2.8806446246977246e-01,-9.2182548465258876e-02,7.2520369412481883e-02,-1.2430703420921052e-01,-7.0069710785815476e-02,-6.0026307002211350e-02,2.4894195960963994e-01,-2.9350964097994076e-01,5.9450667335163167e-02,-1.3297366518832943e-01,5.3153983753861926e-02,1.2627074802246910e-01,3.6217076677600879e-01,2.1203537760552593e-01,-3.1585746963434069e-01,-1.3602021354896313e-02,-1.0028864243802292e-01,-1.0255960821384241e-01,1.5460722512867533e-02,-3.0229251741801230e-02,2.6902939630747863e-01,-6.6783228868673161e-02,-3.1137755307541537e-01,2.3490485829416347e-01,2.2012906378298960e-02,3.8940421173847009e-02,-3.2135626580716659e-01,-4.3445004628652639e-02,-1.5874278553234457e-02,1.8157270775263263e-02,-3.2267801221635456e-01,3.0536960072650510e-01,8.2184887071022020e-02,-7.3329937371595252e-02,-2.9627161060000706e-01,8.9914386270227173e-02,-2.6574907740905554e-02,-1.1432587356101748e-01,-2.3296182785202571e-01,1.4497157949233888e-01,2.5327180199116645e-01,1.0551104114865578e-02,-3.3643528769455683e-01,-9.7014170824447771e-02,-2.1572332596658303e-01,2.2735308355653912e-02,-8.0930799151384097e-02,5.4428067908299536e-02,2.1058188900188202e-01,-2.4437984676498808e-01,2.3104677244240890e-01,7.1181037088555582e-02,1.9160051662280669e-01,-8.5168675029612312e-02,-4.6480210677103215e-02,5.9646324301803244e-01,-6.6569731664042439e-02,-2.8436686241528994e-02,-2.1318422071906343e-01,4.4001057653047633e-02,-3.1983034859369464e-01,-5.9925284468093427e-02,1.0709689435488687e-01,-3.1413926269228865e-01,-4.9557695623589415e-02,1.1735945881371498e-01,-5.1819676275075048e-02,2.2706409746274139e-01,8.5866937602771767e-02,-2.8364874911071258e-03,-2.1141387488822311e-01,-1.8550448587692608e-01,-3.2522252295331608e-03,-1.9300690669553852e-01,-1.0300029790628927e-02,-6.0807851433750879e-02,1.5827500719426249e-01,-8.1485883934997713e-02,-1.7878021955924012e-01,8.0389906125308178e-02,5.1829168857236603e-02,2.0935453427100087e-01,-2.2693422571401684e-01,9.5090887868905433e-02,9.4162708792789707e-02,-7.7655332524704149e-02,1.7394221317899938e-01,-2.0482557431251336e-01,2.1531896326557762e-02,-6.5563990243826989e-02,3.1025151813295630e-02,3.0140355237988986e-01,2.8889664354954499e-02,2.4215289184751790e-01,1.3583093435988841e-01,-1.2701708574823689e-01,-1.9350972035710637e-01,2.5686931285077491e-01,-1.0934605125722298e-01,1.4223365513996064e-01,9.5109223924747591e-02,3.6039200910725605e-01,-7.1461596494692636e-02,4.0269597551850174e-02,-5.1399113460062984e-02,1.1128238041395325e-01,2.0534888371255294e-01,6.9844697061659952e-02,-2.8109918015295576e-01,3.7436942186859414e-03,2.4757178171073721e-01,2.7487510720342245e-01,-3.9243350620013240e-01,2.6014836538124952e-01,-9.7908903223778831e-03,-1.6605306071320020e-01,2.4814091675265540e-01,1.6913609855165204e-01,-5.2822514773670914e-01,2.2023281112647189e-02,-1.7959814279210631e-01,3.3082392451245404e-02,1.5586308368762034e-01,-9.2844224823968563e-02,1.8556116171203701e-01,-1.2647730231139576e-01,4.2255884922145109e-01,6.6219152302929699e-02,1.5505333181977046e-01,4.1801952418721533e-02,4.2786997512903838e-02,9.5079899839320831e-02,-1.8001841789848463e-01,-3.6706341219104086e-02,-2.0022804379645529e-01,2.2286936900564475e-01,-1.3045944306691815e-01,4.1976881811543298e-02,-6.7119562674205879e-02,1.0747984741145898e-01,-1.9690766108789720e-01,-3.6418230701620903e-02,1.4779223266319936e-02,1.0569965963310189e-02,3.4589735041364894e-02,3.6444031011221539e-02,-3.3667651241624574e-01,-1.0251272128205238e-01,-3.8550754322085601e-02,-3.4345194919681288e-01,2.6530477133725451e-02,-1.4116081120425639e-01,5.7040386995567828e-02,2.2511748894784958e-01,1.5856015676024812e-01,-2.5637822864300508e-01,3.4844762439479471e-01,-2.1616861751792973e-01,-2.1331368179138444e-01,-1.1474626358446199e-01,-2.2458471823097176e-01,6.0556201864447698e-02,3.4980324940119822e-03,-3.3058493328809396e-01,-4.5742585891978986e-02,-4.2727986081928182e-02,3.5649177438576080e-01,6.3772990310272309e-02,-1.0393246013017846e-01,9.6575984528368297e-02,1.3874657469555324e-01,-1.3530705390097954e-02,1.5418634058054131e-01,1.3052923989608475e-01,1.0402460893698912e-01,-9.1514021461227793e-02,-1.7176821286232091e-01,2.3693334992186385e-02,1.9200833012292146e-01,4.5265745539618213e-01,1.3519565218996588e-01,-3.0222815452627938e-01,-8.8860401739477915e-03,1.7095500194475652e-01,-1.8668262884698378e-01,2.4866841184642247e-01,2.0104068635157565e-01,-1.2276369673330298e-01,-7.4127843998297555e-02,1.4380168488603351e-01,-1.3695130918555987e-01,-1.1984533935520142e-01,-1.6104676582008781e-01,9.8936761679950594e-03,-2.0604344124541613e-01,2.5600260403941388e-01,8.8171532755885754e-02,-7.9301414181374888e-02,-3.4182780206233526e-01,-8.3220916803219663e-02,-1.2523622589494374e-01,5.3406863753114972e-02,-2.2615623675616900e-01,-8.7539468754880057e-02,-1.7006848305026051e-01,-3.0925769861074918e-02,1.0172580619037275e-01,-8.2227159323250365e-02,-1.1120137800679125e-01,-2.5007076506594306e-01,2.3482043940247610e-01,1.9919738970678363e-01,4.0492074914095344e-02,6.8848124334690675e-02,-1.4466454451265659e-01,-1.0172768205893364e-01,-1.8284043329484700e-01,-1.1688839698098108e-01,-4.1007875493471471e-02,-2.0871577828725954e-01,-8.3480000439621907e-02,-2.3564388102722839e-01,-3.1475967148214756e-01,1.0799039663276458e-01,-4.3080366913428153e-01,-2.5956846482225804e-01,-8.6509119802095497e-03,-3.4339593388615608e-01,-1.8148910835947316e-01,-9.5506326979464679e-03,-2.5538211930197996e-01,4.5678257138282621e-02,-3.3182854854903132e-02,-3.1315680511944444e-02,2.7213071815424348e-02,1.6609718763169832e-02,-6.3649759649210894e-03,-1.3182086791412204e-01,-6.7031237832543597e-02,-1.8417221748865240e-01,-1.0574732658885409e-01,-2.0543717590114691e-01,-1.5143825264933211e-01,-1.1711243090970355e-01,7.9975983779355386e-02,-2.8721853371188316e-01,-6.1459420870955878e-02,-2.3017089476613439e-01,3.1592598527144805e-01,2.7274842708292607e-01,-3.1562439225568965e-04,-5.1366281376156703e-02,-2.9876545701619744e-01,1.6983711776223301e-01,2.9707529792640175e-01,8.1534786937411952e-02,6.9769149950752229e-02,-1.3774178864024980e-01,-1.5996515507839765e-01,-4.8886650916629626e-01,7.4639211799315777e-02,-1.3502498582366662e-01,-6.6494149193569219e-02,7.4706832609698917e-02,4.1924895532601814e-02,-4.4938089349011362e-02,7.6283312933042940e-02,1.9031533883934065e-01,-2.3866759401853049e-01,-3.7658672314828404e-02,-4.9194286008721382e-02,9.6195989953264144e-02,-5.1617543187668113e-01,1.1670025598500729e-03,1.5357426661844470e-01,3.6526637138726323e-02,-5.8471707380274546e-02,-1.7469650278684717e-01,-2.3357424177748715e-01,-1.2920798822684629e-01,-1.1490248512128999e-01,-3.9610836555045598e-01,2.0384426937506359e-01,2.0114596590967310e-01,-5.7276845188434969e-02,2.0831017656251605e-01,-2.4096226536372910e-02,1.2739310161884870e-01,-9.1875330580531600e-02,-8.6673951665524274e-02,2.3835167877875676e-01,2.9904568892443095e-01,6.4870020104544665e-02,1.9801289093476060e-01,2.8764314774258028e-02,-1.1893956388199420e-01,8.1041741449953075e-02,2.6140559401465058e-01,5.1019657575892916e-03,3.3450185643539325e-03,-1.5038811512241783e-02,-5.1808257701015603e-01,-2.9385972853003312e-01,7.4709466245036951e-02,1.2493170330892354e-01,-2.2963063033903200e-01,2.8440806782703040e-02,1.1381455246209574e-02,4.0526165250378815e-01,1.2017675901190807e-01,4.5177753452609416e-02,-1.7705378632255184e-01,-1.0571680575823164e-01,-2.2301073837741231e-01,-3.1272321257068650e-02,2.9377030826453088e-01,8.2500109900601193e-02,-1.3781277278560744e-01,6.2752516014056597e-02,-1.1121413032909022e-01,-4.1746145456676251e-02,1.7060695473907292e-01,-8.8429634050907993e-02,-2.1062746038479968e-01,4.1629228039182753e-01,1.2991715417271110e-01,-1.1867673096795558e-01,3.3084158033291600e-01,1.0046743142302993e-01,2.7216237560840317e-01,-2.3361877661990538e-01,6.0641027699084651e-03,-7.3010792654462225e-02,-2.9544884013673695e-01,-5.6044725830978831e-02,1.2081974455345718e-01,-3.8557700681801921e-02,2.0076380214080816e-01,-2.2496177185625521e-04,5.0089940944094080e-02,-1.7400960196502305e-01,-1.6425572154617027e-01,-3.6019203031890004e-02,9.5939715412869692e-02,-1.0870572907276771e-01,-1.9195298745444896e-02,-3.3006546297267327e-04,1.8971059968736417e-01,2.2548270339999074e-01,9.1982945876742328e-02,-2.2412248964377621e-01,-1.3171153034181582e-01,-3.2505037604294967e-01,3.1697897267721341e-02,3.2823750722440266e-02,-2.0391806393064160e-01,1.4509169385230594e-01,-3.0999219501540659e-01,-1.6868361086219896e-01,-1.4347002087743846e-01,-7.4785730889760788e-02,-9.7578043555746105e-02,8.3729582590736179e-02,-2.8291182290189582e-01,2.4273059752579512e-01,1.6208264388761043e-01,9.2914904572955481e-02,3.3063984302850302e-01,2.5258433255632942e-02,-1.9110513227137854e-01,-4.6870244083514800e-01,1.2087707203308032e-01,6.7520917784867379e-02,-1.3062972927467942e-01,1.6330009553531127e-01,3.2692911478348036e-01,-9.2169346569820256e-03,-1.1527855219957030e-01,4.3004110206539686e-02,1.4500983934330358e-01,4.9178895352636892e-03,-1.4811520696092728e-01,1.7289830774205733e-03,-6.6224146738680989e-02,1.0966204774652863e-01,2.5999965543130554e-01,1.2612263392940193e-01,-2.2977704067891452e-01,-1.3237816092170263e-01,4.4486073902540385e-01,1.3680595576934390e-01,3.3056748961228948e-02,9.7120736224617477e-02,2.8224754760491538e-01,-1.4632603550382553e-01,-3.7858518832928517e-01,5.6585005396227787e-02,-1.5299927774469892e-02,-1.2460210121451511e-02,-1.2736238824151444e-01,-1.0320516864761820e-01,-4.5036661633056349e-02,7.7621401969518625e-02,4.4726643488590540e-02,-1.1367317092533738e-01,3.3731279395414010e-01,2.0301547162305009e-01,5.7295646193385841e-02,-3.2840864434989736e-02,3.2265102009676699e-01,-1.6447796198395329e-01,6.0719275121038960e-02,1.0284630748617246e-01,-4.4422017808312386e-01,2.1307768893201484e-01,1.7570634824577441e-01,1.2200790560158810e-01,7.7343142559578568e-02,-4.7537868643251124e-01,-1.3158595933566924e-01,-1.9754778628824327e-01,-3.0581381848584846e-02,-2.1271882237157788e-01,1.4446020525136005e-01,3.6222937096990959e-03,-5.3313634032896035e-03,1.5242899993910750e-01,1.4173613603249385e-01,5.6071638040602535e-02,1.8066723914967994e-01,1.7022564437785809e-01,1.3193788014989788e-01,-7.7649810066361489e-03,2.3402327014433233e-02,9.2687381796815765e-02,-1.4635109570140456e-04,-1.4909244879061639e-01,3.5986090830482168e-03,5.0319037842826563e-02,1.0974081676355062e-01,3.9777264202662715e-01,3.9303202337468007e-02,1.5757512183759326e-01,-8.2632684658946354e-02,-4.3030848687393319e-01,-2.4361510874574888e-01,-1.3266784557537137e-01,2.3234429782246341e-01,4.3884312433125419e-03,2.8982588142280885e-01,-3.6728878982095321e-02,-3.6387325557011949e-02,1.4637038340992728e-01,9.8525102144683650e-03,1.9738003757724384e-01,3.8132523426918488e-02,2.3745995162075798e-01,8.1718499802098735e-02,7.0679578879209743e-03,-2.1173625976934474e-01,1.8276545654419668e-01,-3.3723685456993441e-01,1.2362814757479818e-01,9.1039600137720875e-02,-1.8772415329704542e-02,9.7700719565109104e-02,-1.4050871525572931e-01,1.4162903694756437e-01,-4.5682409987992466e-02,2.5926183006314946e-01,3.2736283841253916e-01,-1.3565007301449772e-01,-7.2292272373476282e-02,-3.2867806086456897e-01,-6.3723935482300889e-02,3.2700872211011159e-02,1.1916487084382084e-01,-1.1111999755479970e-01,-1.3854369559344126e-01,-2.5155221964626806e-01,1.1156651977238034e-02,-6.4640659934482425e-02,2.3831091238698954e-01,3.3264047153154178e-03,1.5734100808750383e-03,-1.5525591417961940e-01,-1.1838802257732509e-01,1.2289816910087355e-01,9.7700337012527644e-02,9.9438739508895656e-03,-7.0993094633750572e-02,-4.8567797791875372e-01,7.0321752193682530e-02,7.6178144524448030e-02,2.4673292333071065e-01,-2.2346782368559090e-01,2.3689343017837788e-01,1.6830181509421747e-02,-3.1129386838058737e-01,-1.0563895145842396e-01,-1.1543803314347852e-01,1.6620743262160539e-01,-2.9315622237626698e-01,-1.6334597425394923e-01,-6.5799977547167455e-03,-1.1333665424200336e-01,2.9757208252190981e-01,1.4637697869299338e-01,1.0740439464718943e-01,-3.1552058887969381e-01,1.3200176095618729e-01,-2.3132929719657055e-01,3.0778097967293827e-01,-6.4077289334832269e-02,-7.6124157264555792e-02,-2.0919376493901204e-01,1.6021540700706760e-01,-6.7074028949025866e-02,-2.2658693098888713e-01,1.5368332872179641e-01,1.8857521330039286e-02,-1.1745839853562302e-01,1.4095867515488470e-03,9.8298040633307548e-02,-1.0860998055861629e-01,8.2609159280525452e-02,-3.5462176803128820e-01,1.1510575766375018e-01,2.5768172236888137e-01,6.1548103716818667e-02,-2.9466949920573438e-01,-8.7783192600704663e-02,2.6218424157895548e-01,-1.2975578107812628e-02,9.6912299016914227e-02,-3.9562529011087066e-01,4.1771233228007090e-02,-2.6355910698435864e-01,-1.8000793402175150e-01,1.8774182968621070e-01,-1.6202905560592923e-01,1.9062452845821976e-01,4.7381115288787773e-02,1.6146765839511681e-01,-1.3745543122012990e-01,1.4178606413471356e-01,1.5076720029616963e-01,-7.7755225555875579e-02,7.3224961311749853e-02,2.1556187913648947e-01,-4.2587119282639106e-02,-2.1129062523497300e-01,3.0195608690730252e-01,-3.2918680388161753e-01,-2.9635814378871306e-01,-1.3654117657450407e-01,-1.9246097670271187e-01,-7.8098833386497368e-02,1.4877621013236905e-01,-1.3596006745593803e-01,-9.5659674819277285e-02,1.7979925952127901e-01,-8.2718725480295102e-02,1.4142745473331614e-01,6.7905523997391776e-02,-1.1067997378616573e-01,4.9459681140024067e-02,1.4551121135680930e-02,9.6739512975218003e-02,-8.4801867013512888e-02,-2.1679143452009619e-01,1.9405951317987577e-01,-1.0114175375368709e-01,-2.3094369464507998e-02,1.5374990639431313e-01,-2.2880683501260568e-01,3.7633616443624662e-01,7.1091776895439412e-02,1.6899700420865896e-01,-1.4294049530585345e-01,-6.4951315383125818e-02,1.7595678675673659e-01,-4.5311652109217671e-02,4.7090692567231840e-01,-9.5223899518483840e-02,-1.4491768043126313e-01,-1.9456196548221852e-01,-9.9399791652604930e-02,-1.7093381707010372e-01,1.1950881038212414e-01,-1.5430885743851730e-01,4.0474342162019689e-01,-9.4464243967804368e-02,-6.4802213607153603e-02,-2.0940659179735799e-01,5.8864478039527234e-02,7.4941804889990762e-02,-1.3968135278352298e-01,3.8316308245258543e-02,1.0145244285737383e-01,-1.7495415344650359e-01,-3.6683206045184068e-02,-8.3683026463795065e-03,1.5906645646606388e-01,1.9652066166604995e-01,-5.9247522407422884e-02,-2.1561801608525713e-01,-1.4531247947538339e-01,-2.0150069028044815e-01,1.5292874939875253e-01,-8.2650524226987876e-02,2.0212692163955440e-01,-2.3160825698684864e-01,-1.6542136282617081e-01,1.8126539725832183e-01,1.6297744841789447e-01,-3.7849657134577319e-01,3.6725620035607104e-01,-3.3765750402235624e-02,1.5019580299289164e-02,-3.7876653990398204e-02,2.1538178100759092e-01,-4.0633040084393146e-01,-2.9489190396509551e-01,4.5341746816033923e-02,-1.0323601008050046e-01,4.2801888149475165e-03,-1.5917213158045451e-01,3.1001061511830012e-02,4.8636887437871423e-02,2.6913865079042343e-01,7.3358238882364188e-02,-8.1752559386043880e-02,-6.6417983866379426e-02,1.6255122095543001e-01,2.3341550086921445e-01,6.5358049179388478e-02,2.4139446554219395e-02,2.0693171795786316e-01,-1.7118639125931748e-01,5.6914912072633617e-01,1.5911265800694163e-01,6.0111349210407325e-02,-7.1968200733856652e-03,2.1603626610650514e-01,1.5433145021747738e-01,2.0653697621863813e-02,1.3597314115792300e-02,1.4125486430867568e-01,-9.9554451814531948e-03,-4.1077838568697828e-01,5.9345640905026267e-02,-9.2304678531836978e-02,9.1194861514055856e-02,-2.4945845683017817e-02,3.0589537419754231e-01,-3.5266805641101302e-02,2.0160052113534532e-01,1.2299449733029365e-01,-1.3890688522350833e-01,-2.9013264543177225e-01,3.2016239356611415e-01,2.5255996252150054e-01,1.8822491540561972e-01,-8.9637026482962553e-02,2.5114913729761157e-02,2.7676720925692837e-02,-7.1751457361477256e-02,9.0861219023892173e-02,-2.7021976243876644e-02,3.5656187727481407e-02,-1.0681316524373488e-01,1.9414438106954193e-01,-2.6654152353395917e-02,2.9671793656368811e-01,3.7860736183099858e-01,-1.5568118077358692e-01,-3.9153685408175432e-01,1.5175766051802450e-01,-1.1934468893998916e-01,-2.1434106515796504e-02,-4.7703576059893976e-02,-1.0818407434027424e-01,-1.3905122384486557e-01,1.0510783796129827e-01,-2.5739329806694194e-01,-2.5228533426070260e-01,1.7234229676811894e-01,2.0105880130186957e-01,-9.4529273421453716e-02,8.2582482382894451e-02,-1.0100938719119507e-01,2.7034994292380071e-01,3.1321511226080190e-01,-4.0729712199287574e-02,2.8749325954443278e-01,-9.3114055824512931e-02,2.2144984509284588e-01,-1.2049317274263881e-01,2.6153789597296134e-01,-7.2931939346434799e-02,1.9027854911583708e-01,3.6769518257032577e-02,1.2273022559875725e-01,-7.3097504921334169e-02,2.3507086833936905e-01,2.4524659883345795e-01,-2.2718539403960701e-02,-7.9596828913331544e-02,1.4705432049036193e-01,7.0971748126498202e-02,3.6670090081464790e-01,2.8764097962794589e-02,1.6676271056172559e-01,1.0122369636201239e-01,1.7312358834458620e-02,2.4167091517231787e-01,-1.6358508781385653e-01,1.2543727530174384e-01,-1.2863543575728312e-01,-3.3051776432653679e-01,-5.0221960541858859e-02,1.2317332581475700e-01,-8.4924969279250306e-02,1.2734391704316247e-01,3.6521280998779722e-02,-4.8692241512507034e-01,-1.8644905477703044e-02,9.4503918974659609e-02,-6.4879587373045472e-02,3.2264472690357054e-01,-9.4994579774242249e-02,6.2006697250590818e-02,-5.4413611276790189e-03,-1.8129219984065076e-01,-1.0282936488447815e-01,5.1957113586469032e-02,-5.6080010686412718e-02,1.4356460953612959e-01,4.8261012000081482e-01,1.0572740202391635e-01,9.4674830524842782e-02,4.4381077287259249e-02,8.2443294897789357e-02,-2.5281258057363087e-02,2.4706217727325633e-01,-2.7997705913180015e-01,-1.4938924082707766e-01,-5.2372539878934258e-03,2.9835543939587506e-01,1.0090211430481197e-01,-3.6696049017323512e-01,1.0789613794118375e-01,-2.7585591761084560e-01,-3.6630299135096321e-02,2.2846500523597907e-02,-1.0669688489670454e-02,8.5658711797360787e-02,-2.0202384754517418e-02,2.7555283870950992e-01,3.5193524457442719e-02,1.1370330956904488e-02,2.1894912422145102e-01,3.4022155909318182e-02,2.5078084212870871e-01,-1.8484556875721159e-01,-3.3206222929058610e-01,-2.9536558861217366e-01,-1.0031989462641415e-01,1.3557360939960042e-01,-4.9366226101695443e-02,1.8652704679473633e-01,1.1332223483879417e-01,8.1550719842116828e-02,2.8739497361767091e-01,-4.3533726196818318e-01,9.3512057106185029e-02,5.2861195493415038e-02,5.8779180924292643e-02,1.4364374940654271e-02,2.4963902321885106e-01,1.9711786836143438e-01,-1.7701133741401509e-01,-8.1624329070197010e-02,-3.5899178894547340e-01,-1.8171113210285139e-01,-1.3610880897235336e-01,-7.0481434965437614e-02,-6.3650227488716224e-02,8.4301040076209741e-02,4.9169972279197824e-02,-7.4007188194773810e-02,-8.2727454304067971e-02,1.8145532379264796e-02,3.5449807073055500e-01,9.2236596869071680e-02,-1.7093557462307946e-01,-1.2153641607916599e-01,-1.7299781166908806e-01,2.7484937928569958e-01,1.6916409948153863e-01,-1.1653522242529446e-01,-1.7151455159224155e-01,1.2967614040353864e-01,-4.0011892449889737e-02,-1.2563973283479107e-02,-1.0583337001769014e-01,3.4904184329759495e-02,-1.9591986248980431e-01,-2.1533890580022411e-01,-1.0874408286934054e-01,-2.6472234850090171e-01,-2.2954341233665887e-01,-1.9199491242756064e-02,-2.3539718169801360e-01,-9.2953327207811173e-02,-6.9291595511214304e-03,1.7002996877419171e-02,-4.2507105005808626e-01,-2.4006631035296638e-01,1.6260999464517889e-01,1.3919920540997674e-01,5.1920217830510706e-01,6.9546454225260818e-02,-9.6326514493309978e-02,1.0309363453299576e-01,6.5805202401835530e-02,5.2449894003199667e-02,-1.6796987281669756e-02,-2.9933539986967399e-02,-6.5285374324055651e-02,2.1663893692129087e-02,-3.0570941252244510e-01,2.2327282206406351e-01,5.0913184900199443e-02,-7.2051557998290133e-02,2.2223349699662026e-02,2.1721262515296244e-01,-2.0959065648421296e-01,7.3930352795310753e-02,1.2618750331048514e-01,2.0363826596966724e-02,3.4513743004756814e-01,-3.0970208319180088e-02,-1.0957650027281297e-01,-1.7250870919853845e-01,-1.2594494955759608e-02,8.6294281056639138e-02,1.6450050328311999e-01,-2.0217271848366361e-01,-4.2970318842499744e-02,2.2053006372963851e-01,7.4205204915300707e-02,-1.1205374296501708e-01,3.0498803653602174e-01,-2.5751755272593141e-01,8.9791675927296921e-02,2.6998391329806121e-01,4.3936405558026875e-01,-4.6893119202147712e-02,1.3566657294998188e-01,2.6151720874308404e-01,-2.6609641705437143e-02,1.0477891457674821e-02,-1.7060784171679827e-01,6.2109817066432975e-02,3.1383726839186454e-01,5.5926759350714110e-03,2.3780057246541170e-02,1.1279288269368369e-01,1.5950937708200824e-01,-4.5102989502003907e-02,1.9081950973819609e-01,8.6839266816298263e-02,-1.9673030605162517e-01,-3.8066338176701048e-02,-9.6739699980800453e-02,4.6163255095148381e-01,1.8205227199859569e-01,8.3475557272678247e-02,1.1864590309800968e-01,2.9122012657247476e-01,-4.5626067945252279e-02,7.5746866442298305e-02,-3.0397702080989542e-01,-6.9100697002510314e-02,-1.4559138480170433e-01,-1.9513177746687535e-01,-7.0960264228650510e-02,-1.4446694987688052e-01,7.7243561242285347e-02,-2.5704196709924565e-01,-3.4620380573708409e-01,-1.1734417969681388e-01,-1.7314976023095432e-01,3.7918619449931933e-02,4.0273263410143506e-01,2.9583449053560701e-01,1.5536789664566489e-01,1.2197184776224942e-01,-8.2179465721381989e-02,1.3086771698264227e-01,-5.4563904613202895e-03,-2.9018874845303078e-01,6.1212453115261196e-02,-2.6862917325241729e-02,2.1687974242669963e-01,-1.3353129598825164e-01,-1.1881658445834216e-01,2.3387890582276588e-01,4.0938575783574516e-03,2.4606251421087841e-01,2.2295011561962175e-01,-3.4075191025050572e-01,5.7662555448852161e-02,-7.3314801533805082e-02,3.1927935319647216e-01,-7.9731363445651349e-02,-2.0674262615385877e-01,1.5787989058055396e-01,-3.6530625581902468e-02,8.5037663938665173e-02,-1.4102414445594139e-02,-2.1864249596490120e-02,3.8423654421665743e-01,6.7473406787150914e-02,-9.0555723801004004e-02,-3.7342036100239527e-02,1.3424392894226364e-01,1.0882756349845944e-02,7.0337645354410908e-02,6.3420637835123028e-02,2.2721235194135234e-01,-2.0584448339202016e-01,1.9503822337935978e-01,-2.3218676853606826e-01,9.2624389385208825e-02,1.6509997972163010e-01,-2.8516866050732226e-01,-2.2438921123194619e-01,2.4647943566649447e-01,-7.0500292575566045e-02,-1.3457295910140701e-01,-3.3545531253439553e-01,-1.8734479616763292e-01,1.1991559809504301e-01,-9.2802515838002766e-02,-5.5761284759902371e-02,-1.8845346902372262e-01,-2.6302113994818993e-01,2.4163281992676663e-01,1.9107391629817472e-01,-4.2321155979703866e-03,3.1637386043092403e-01,-7.4230441734489713e-02,1.2409762292852621e-01,-1.4352437150982894e-01,5.3020720522236095e-02,-3.7402147898432420e-01,-1.7217502941968915e-01,2.5976180904841983e-01,2.4738553313029929e-01,-1.7070068459269453e-03,-8.7458202263838870e-03,2.7556102807066879e-01,-2.5913687908236095e-02,1.2990200395566370e-01,1.3135087466264592e-01,-2.2140862067560424e-01,3.4370112759268384e-01,1.1111921456407264e-01,-1.4398829906948354e-01,-1.9390723543995714e-01,-4.3733617532614150e-02,-9.9840023820864252e-02,-1.3397033922590396e-02,1.2340216523832083e-01,-1.1185954486980448e-01,1.7090594529538636e-01,2.6018650949581684e-01,-1.3663067972565213e-01,-2.2193465844973875e-02,-2.2991901216903901e-01,3.0932247278006975e-01,-4.9811448608384087e-02,8.8264856494334201e-02,2.8091330396731434e-01,2.9764136989916437e-02,-1.6841868147012617e-01,8.4758354808137149e-02,-1.5579191160483985e-01,-4.7155333009438707e-02,2.9342728877549389e-02,-8.4948290994877704e-02,-3.8659352502261923e-01,4.3017258185912804e-01,1.5462634749330473e-01,1.6836162044715758e-01,-1.1195590170308201e-01,-6.6352466668262569e-02,1.7250837486814852e-01,-1.9112065984886803e-01,-3.0440389341645990e-01,2.2072866164329186e-02,9.4391190921836940e-02,1.3558928763495096e-01,-6.2339949880873147e-04,1.7696248149849145e-01,-2.0313094587843206e-01,-5.2303768932352883e-02,-1.0950966626431154e-01,2.1474706908452185e-01,1.4241511860676723e-01,1.9660739736772387e-01,1.1904926038808861e-01,-2.2483684620934344e-01,-1.3670880775940181e-01,-2.2512007025810195e-02,-1.0764107294809913e-01,1.0235991651944684e-01,-3.7477182301923700e-01,2.4755702617250904e-02,1.7548329296242843e-01,5.7229232578429164e-02,1.4929436680742347e-01,-2.5451395249145908e-01,-3.9764554480344827e-02,1.7367336857528431e-01,2.7885249217515916e-02,2.8962016682838382e-01,2.3258768264672072e-01,1.2892827609022398e-01,7.9076321238658834e-02,6.4242334592122252e-02,1.8011464791025142e-01,3.2929100218541188e-02,1.1392554868655631e-01,2.3212480420654211e-01,-2.4083892126561471e-01,-1.5859124832642266e-01,-2.0647340038849774e-01,-3.6019412787958238e-01,1.9936270644956919e-01,-1.6975457472201642e-02,3.6845041620021189e-02,1.5508631752783485e-02,-1.5394969825396934e-01,-1.3875252102752589e-01,-1.8483993007928951e-01,-9.9414816296887226e-02,-2.0077521353434154e-02,-7.5961856345646631e-02,3.2420432149634493e-01,-3.7591059165222951e-01,-1.7194812318303460e-01,2.6219008094389148e-02,1.4085659473052761e-01,-4.7933466764437022e-01,2.8981312312837315e-01,1.5876114186360882e-01,6.5851982374489360e-02,1.3393439884588829e-01,-8.3757384151090436e-02,1.5774041975697450e-01,-2.0022255030910013e-01,2.5788539088398482e-01,9.7549334876138649e-02,1.0472157505970081e-01,-7.7449661977791628e-02,-1.4971528168688092e-03,1.7588519111741360e-01,-3.5340777962788013e-02,-2.2368455085220712e-01,7.4909379998448870e-03,-2.1415483370513422e-01,5.9950235516689862e-02,1.2046456408129944e-02,-2.8492774015186403e-02,4.5160578226732438e-02,-4.4441755267923072e-02,1.4487286185930204e-01,3.3562320758223346e-01,-2.2463597069400526e-01,-3.3169928921559616e-01,-3.1254100252840859e-02,-1.3101853444172906e-01,-2.6488587636949890e-01,2.4807987891412484e-01,1.3069067978506782e-01,2.2768921920197052e-01,-2.5941904417501917e-02,-1.1644002599111238e-01,2.7181116654091275e-01,1.4269615199856628e-01,-1.0298819216174988e-01,2.9998504305200596e-01,-6.0745235243073674e-02,2.7083964620081402e-01,6.4315035930829018e-02,-1.8485785218245793e-01,1.1277091116526305e-01,2.3896086491660523e-01,1.9591094087084704e-01,4.2287428928543286e-02,1.1297685475226356e-01,3.1083642683169696e-02,-4.7211063662727787e-03,4.0591608490124104e-01,-3.5506846333263381e-01,-3.8411707113515652e-02,1.8441866368351628e-01,8.3571721115535860e-02,9.8172500718178568e-02,3.9570701344030401e-02,1.6028537229652190e-01,1.5276426127932302e-01,-3.0380318896047215e-01,-1.4140644022343737e-01,1.7313939448562887e-01,-1.9202983091224485e-01,-1.1697559638069024e-01,6.7392157726644503e-02,1.5814421707779563e-01,-1.1803089324313634e-01,-1.7302836545939884e-01,1.8854916589658835e-02,-2.9293349360407189e-01,4.2267611602252370e-02,-4.1319422175904685e-01,8.0157543900473346e-02,-2.1952812679585770e-01,1.3353429170668667e-03,1.0660852401720861e-01,-1.9760511975955358e-01,-1.9100888750465367e-01,-2.6009957099038827e-01,2.8511370582328055e-02,1.2790290440895899e-01,-3.1777168979786896e-01,2.6785556545106359e-01,-1.6129070948472529e-01,2.6780854908004553e-02,4.1448226330250290e-02,-1.8680003403944109e-01,2.7283318684733632e-02,-1.1499273541807364e-01,-3.1051606080815003e-01,-1.0538613216976411e-01,-2.5450605793468239e-01,-8.5656329257354613e-02,7.4272468620201759e-03,5.1543058077847065e-02,-2.5410884124195926e-01,2.1738224649165394e-01,-3.3338328842364567e-02,7.3613729398099528e-02,9.8476675723433590e-02,-4.2128806465038021e-01,1.5557757367982133e-01,-2.0600652225028021e-01,-8.9212059537605651e-02,1.3622590567061046e-01,9.2523729151298320e-02,-1.8786788338633262e-01,-2.8894034763548937e-01,-2.6288985351557763e-02,-4.0427177896565214e-01,1.0112407371744020e-02,8.2401108462345721e-03,-2.0554495133740638e-01,-1.8819663842520667e-01,8.7715429515053428e-02,-3.1093240147913096e-02,-9.3323172139374341e-02,-3.7401116983472921e-01,-2.1383951732201595e-01,-1.7898846671485780e-03,1.9975179844239055e-01,1.5131281519169087e-01,-1.2227321974593802e-01,1.8560645529816719e-02,9.6338750484458099e-02,-2.3775041633537497e-01,-3.9767185496879009e-01,-9.2614192285371683e-02,-3.3056894239160597e-02,-4.2854045216504336e-02,-1.8415837944146841e-02,-4.2374335724018899e-02,2.5950327540949314e-01,-2.0757885341180857e-01,2.3987040167203690e-02,9.7887859315626297e-02,1.7275662293078534e-01,-1.0576625859665812e-02,2.0546309828008305e-01,9.9545853421281916e-02,1.6689882387116275e-01,-8.3110771385393023e-02,3.1666127754342333e-01,1.8401418419141052e-01,3.4116354754213446e-01,-2.1456079514636858e-01,1.3962230017247024e-01,-1.4211980329247082e-02,-9.9390703616207082e-02,3.4843602934718193e-01,7.9438026525387728e-02,-7.4730406043795411e-02,-1.3261400690641320e-01,2.3524664220646235e-02,1.5227856088321740e-01,-1.4880669697557036e-01,2.6467402153086461e-01,1.2072915907093321e-01,-5.7798253099782940e-02,-4.3398264596567836e-02,-2.9462784948378318e-01,1.8765957668275374e-01,8.8392138082538194e-02,-3.3159174132310387e-01,1.7441042439701726e-01,-1.3535566861963923e-02,8.3743269770163595e-02,2.7918435403866232e-01,2.6509026994961882e-01,2.0617269331445465e-01,1.6775978163877509e-01,1.4410980011864766e-01,1.6057632872206778e-01,-3.0233163550875064e-01,-2.8017056574230950e-03,-7.5242848327821688e-02,-2.1068202432210703e-01,-1.7845655013186520e-01,1.6401594966949132e-01,1.9923579462770730e-01,-2.1660800780127754e-01,-3.5008760853833518e-02,3.2838214358942150e-03,-1.3964845480919773e-02,2.8441090665397506e-01,2.1021732330039225e-01,-1.7516387247762846e-01,2.9058261247176942e-01,1.6697458070534469e-02,-2.0833120099322713e-01,3.3442598790031808e-02,-1.0819635181082463e-01,-6.5374042703622709e-02,2.2491301741664194e-01,-1.4681579650405810e-01,-2.5727771697281543e-01,-1.5144528154024223e-01,1.3355160714039802e-01,1.3125427383847335e-01,-2.1923147596094886e-01,1.9438749710565670e-02,2.6494861760973903e-01,-1.5928051920257486e-01,3.0880384669085942e-01,2.5274780954144616e-01,6.4655018200961367e-02,-1.8112884447772917e-01,-1.6903869544552093e-02,8.5001628500419299e-02,8.3851331183961236e-02,-3.2715706313318527e-01,2.9008528531116023e-01,-3.0083544383270100e-02,-3.7252375264341986e-01,-3.6913491165543641e-02,-1.3453037777791965e-01,-2.0935887666506232e-02,-2.7284772831933984e-01,4.3893908490447234e-02,-6.3157385255382392e-02,-4.9974749995188847e-02,1.6967235955930557e-01,-1.1105495735065703e-01,1.1396680968969380e-01,2.3672618728540479e-01,-2.0845369189975269e-01,2.6469274557939454e-01,-1.2629249806500598e-01,6.9605791544969250e-02,1.0488901427887279e-01,-1.2310695838019360e-01,2.8823638005138119e-01,7.2556934339008991e-02,1.7709400382970014e-01,-1.2719353226856289e-01,-4.8544350135087386e-02,-2.1784421185022956e-01,-2.9882855351914367e-01,-2.9099419918158359e-01,1.4106293095947053e-01,2.3112228916290620e-01,-7.3960037622339235e-03,1.8797746555467151e-01,9.2801145603157012e-02,1.7042572055660128e-02,-3.6775462610972948e-01,-5.5227287454534958e-02,-1.4275121628160312e-01,-1.7634132127476546e-01,3.4607697898867126e-02,-3.7076773662774343e-02,-1.2244804250430256e-01,-3.7046584812275163e-01,1.9422111082727925e-01,-1.2449631978556074e-01,8.8900355440680270e-02,-1.4592685853629050e-02,1.7074918519103915e-01,4.4275433652750787e-02,6.8935516667928132e-02,-4.3028921576434664e-01,2.5041751340489887e-01,1.0448214033336682e-01,-1.6584192079361457e-01,1.3939593606773498e-01,1.2138958330011261e-01,1.3928232028770002e-01,-2.5289396796850389e-01,-1.3405790503667314e-01,-1.5872836843489363e-01,2.3164505141518625e-02,-1.2512100795888656e-01,8.2164906745650801e-02,2.6158505355450751e-01,-2.8467153393190864e-02,1.8104167275953298e-01,7.4137926461339945e-02,-7.3608798674746623e-02,2.6765228694398474e-01,8.5007369664798545e-03,-8.5652065666345423e-02,5.1793092468033708e-01,3.5023000031550788e-02,1.2706337101858650e-01,1.2801490469013968e-01,-4.9668080479350306e-03,-2.2230678882279337e-01,1.0876282968823850e-01,2.2054514856733845e-01,2.6569078860993061e-02,-2.8898015678719513e-01,-1.9418909970890832e-01,-2.1208583206072060e-01,1.0505712710815304e-01,-1.2363140845889968e-01,1.1182393395724580e-01,-2.6223655333603935e-01,-1.7475582355680649e-01,1.0261971747286792e-01,3.0279649972811653e-02,-5.2648653425731197e-02,-7.4384891664055583e-02,8.1024793312342261e-02,-6.3784652689091656e-02,-5.7651045740845688e-02,-1.2368548649367109e-01,-1.1616353378867475e-01,4.8105482731238075e-01,-2.9938657071395269e-01,2.5821104909896064e-01,-1.7554100136826990e-02,2.3164878091282173e-01,-3.4634976163319904e-02,-2.6933579150047127e-01,3.1250705379366153e-02,7.8503886747853913e-02,-2.6469876433554379e-01,-1.3552187207734742e-01,2.3900829315717687e-01,-1.1528396736138746e-01,-2.9095026457666762e-01,2.3288257390250197e-01,5.9325077528927385e-02,-8.3525028417241520e-02,1.9032800283494256e-01,-1.3308369825924601e-01,-2.5565302639650175e-02,2.4921958643252248e-01,2.4177062511717468e-01,-3.5399121325702151e-02,1.8107143539606044e-01,1.1074851783329238e-01,1.8678784356871930e-01,2.7243918305494436e-01,9.5257138029456109e-03,-1.9263741475239685e-01,-1.0684985938318781e-01,1.3101278131161262e-01,6.4916807451273761e-02,-3.6526040383264852e-01,5.8362300256982448e-02,-2.9141902575533030e-01,3.3463082882021100e-02,-1.1190534249801302e-01,2.1153171290796596e-01,1.0521299586777812e-01,2.9541930832951679e-01,-1.9246262684010218e-01,-3.8583443334231116e-01,9.8150272879551789e-02,-1.9763461820124470e-01,-1.2152985304669633e-01,3.2179960325911267e-03,-5.4558632563709283e-02,4.3664019994158684e-02,-1.3657485208826178e-01,-1.5331140686781737e-02,-1.9659855226043474e-01,3.4179695810868505e-01,-1.0758546118009263e-01,-1.6676038482623920e-01,2.0007604241801241e-01,2.7937887871699957e-01,-1.0053802212535123e-01,1.1580543003909353e-01,9.8037689176463078e-02,1.5718569768566870e-01,-4.1672165781679087e-02,-3.4193140836237107e-01,-3.3782739790897903e-01,-8.7047107520712361e-03,1.4958987573560595e-01,-3.3711470392622921e-02,-9.3155162233362621e-02,5.8536227542401301e-02,1.7849199847920411e-02,-2.1256257957876659e-01,7.4034070989775630e-02,-8.7438033883996985e-02,-2.3113921224440379e-01,-9.2390941026618045e-02,-1.9278507698239153e-01,1.5255067407748664e-02,1.2669960451644330e-01,3.6569993468784062e-01,-2.0296277843364546e-01,5.6759879880776069e-02,-2.8914022278669549e-01,2.1473744413541149e-02,-2.4995233017774357e-02,7.6999713907264927e-03,1.6745482994861341e-01,-1.0715638286629758e-01,5.7703616596315156e-02,3.7714336007483090e-01,-9.9273535246234057e-02,5.7260362619453213e-02,3.0067842879333027e-02,1.2814950644945197e-01,1.0656219098014291e-01,2.7789272448767066e-01,-1.2335114891451004e-02,9.5473156254157754e-03,1.2291002753101422e-01,-4.3005279704495020e-01,2.4280070403234139e-01,-2.7903094425468855e-01,-9.6883663429216602e-02,1.6028109271140323e-01,3.0576556049597292e-01,2.9011767708449149e-01,-1.0220679958399104e-01,-2.0865762241049496e-01,1.3164738684906957e-01,2.3898701835147881e-01,9.9054989375212850e-03,1.2733712738222461e-01,-2.7168882154364793e-01,1.0868246334984590e-01,-2.8420858325816839e-01,9.3820942188787296e-02,-2.4829525528702862e-01,-6.7578818437981039e-02,1.8627092845164128e-01,3.4009603985823783e-02,9.8071811785027607e-02,5.1266587063548225e-02,-1.4216011296179257e-01,-3.0747873017431959e-01,-1.7394500980609875e-02,5.3802530932130777e-02,-1.0265037913900510e-01,-1.2948691161467130e-01,2.1491179225970677e-01,2.8609285791471983e-01,-4.3017568485516126e-02,9.4701820542925669e-02,5.1170974278402226e-02,-4.4059525411615325e-01,2.7138376413872334e-01,-8.1094989729967065e-02,6.2235765865236381e-02,-1.0650749762322132e-02,1.7320819790731706e-01,2.1614519211992334e-01,1.9905139234157440e-01,8.8150730687485621e-02,-6.4966851691649577e-02,-2.6749753472632365e-02,9.2510008055657997e-02,9.9828573113871930e-02,-9.5370781225621350e-03,-2.9684302624163528e-01,-5.8096139268855845e-02,3.8876816171254408e-02,-1.6465244807932711e-02,-5.1422438483684207e-01,1.8449288009762185e-01,1.7642706992903875e-01,-9.0476412660607325e-02,1.4960434674690143e-01,-7.1250093903202749e-02,-1.7171647465875436e-01,-1.8550304670577406e-01,1.9994726544201252e-01,-5.3487406447498206e-03,6.8047914470807422e-02,-2.4260007874194953e-01,2.4102890776887670e-01,-1.4183922209782762e-01,3.3114966348373062e-02,3.7958754488953229e-02,8.3006357520227378e-02,-1.5600959944503667e-01,1.3281975448066460e-01,1.4806358428735761e-01,-1.1209261678191125e-01,-1.7455366004913506e-01,-6.4557756361757257e-02,-5.9105001615086770e-02,-1.8890718478528570e-01,-2.3573668469888959e-01,-1.3257585569553879e-01,-2.7990359775057194e-01,-7.5769919146773793e-02,2.1120097209502889e-01,-2.0457783293671991e-01,-1.4225767049742713e-01,-5.1486572932610275e-04,-1.8541599466160014e-01,-1.3886415708943214e-01,-5.8294306318780811e-02,-4.8667039490131805e-03,-1.3706561520182797e-01,-5.8431991734151451e-02,5.9613249777936939e-01,3.2103275758440103e-01,3.4260965016298617e-01,-1.2654340058179434e-02,-4.3763152677602812e-01,8.6415157073457816e-02,-4.0426973203607879e-03,2.0105770877981596e-02,-5.4630590465960048e-02,1.0090509529199850e-01,-1.0535042885459076e-01,2.6236052916621233e-01,-2.2340282844646561e-01,5.5501142389302316e-02,7.6654371902539598e-02,6.8706012364792277e-02,3.2716567539889468e-02,1.5868379770820176e-01,1.0579268095573316e-02,-2.7492729143549888e-01,5.6941456850078342e-02,-1.1676361934040305e-01,1.6910739892721233e-01,-1.6139007785646028e-01,1.8134773588764966e-01,9.2083569548291708e-02,-1.9245667359286792e-01,9.3467161980973254e-02,1.7845394000812073e-01,3.3478761285544850e-01,1.3698399780405057e-01,-4.9837528867237066e-02,1.3489368566063861e-01,-1.3728898586343550e-03,1.4001494360580091e-01,-1.2062248766624198e-01,-1.2851529724312535e-01,-2.7098652826113317e-01,-4.0878426711334953e-01,1.4341506292172550e-02,-1.7689341737216926e-01,-3.8570785426552526e-02,-2.7795800821942308e-03,-1.1143069062315808e-01,1.3203376119730764e-01,3.4167892146451750e-01,8.1734920914395395e-02,-1.4365881785584780e-01,-2.5660785077579007e-01,1.5379720512753292e-01,-2.2383910424990869e-01,-2.2063600220417737e-01,-2.5914851967753522e-01,-1.6821881144186998e-01,-6.0959786703940463e-02,-1.2794616717211066e-01,1.0059033278813292e-01,3.6926384351602537e-01,1.4239093459077323e-01,9.8751016620189980e-02,2.9600964761446913e-02,-2.4787520900646373e-01,1.7298876830458854e-01,4.7766332997988444e-03,-2.2114152981665688e-01,-4.6937934883755993e-02,-1.1606173817043808e-01,2.4652192508018744e-01,-1.3500736143732434e-01,-2.7548626612820298e-01,6.2345914022867086e-03,2.9999230474279617e-02,-2.3886342336724189e-01,-3.6084642740858947e-01,-1.2933427816450113e-01,1.1486162122267340e-01,6.9373188695292881e-02,-1.6767343347247898e-01,-1.7312120731093172e-01,5.0159101619939188e-02,4.0000466756854550e-02,1.9212869131560140e-01,-3.0394130692447757e-02,-9.7272736186554229e-02,-3.2408300395572831e-01,2.3962872995448353e-01,-8.7936977378252471e-02,-2.2216937071583281e-01,-2.6382879821233268e-01,1.9409295888435021e-01,-1.7285877243325776e-01,-8.2087673712740811e-02,1.4508546154203156e-01,-8.1165715265999167e-02,9.9171370526074720e-02,-1.0587523655910154e-01,8.9070038489111603e-02,-1.3130178528848227e-01,4.1613691716516399e-01,-1.6540094006177344e-01,-3.9750382074992030e-01,-7.6970900051713517e-02,-1.3746874441913609e-01,-2.6405997162752343e-01,-1.3799799007137861e-02,-2.0627688846677708e-01,-2.0581136995861093e-01,2.0577917821902256e-01,3.6804927845670590e-02,5.4906887600047395e-02,2.1294139651492966e-01,-1.1942766506553806e-01,-8.3844689122158367e-02,8.5769774889715059e-02,-1.1650131266279769e-01,-4.9808263968728103e-02,-2.1807000900586532e-01,4.1889607034936183e-01,-1.4332730060763471e-01,2.9226771044729365e-02,-5.8078660976496679e-03,-3.1955007102901459e-02,-3.3813902163726423e-01,5.8653010994863454e-02,-1.3316743355247135e-01,-1.0796422978374180e-01,-1.6715077227494904e-01,5.6687532298692972e-02,6.7310202280672790e-02,3.7187911002922625e-02,-6.0255015714183610e-02,-2.5989934321715663e-01,-1.7787290705810196e-01,1.8959749876470366e-02,1.0488956946748743e-01,3.3814235904214096e-01,3.2314228772482106e-01,-4.7631720235928383e-02,3.0244670271734143e-02,-5.6049563429177995e-04,5.1908549792187264e-01,-1.0461156434907856e-01,-1.5325921569598616e-02,1.2696877123297262e-01,2.1287248345999213e-01,-2.5563438142345346e-01,-1.0901919439347356e-01,-2.5395803620022951e-02,2.8520880504666071e-02,1.0336212478235360e-01,-2.1721131517520242e-01,3.6219123063851122e-01,1.6709076978643003e-02,1.6038594291466868e-01,-1.9983524663545105e-01,2.3107232931540081e-01,-1.2742186344780457e-02,-1.8136644498900914e-01,-1.1139628810332564e-03,3.8736892164751610e-02,2.1845531694401749e-01,-1.7351528573671107e-01,-1.7009602726285666e-01,-3.6301662452531989e-02,-4.0275521789486968e-01,2.1722266135030231e-02,1.5147285192736104e-01,-7.6741236046208555e-02,3.2812985878729012e-01,1.2947098506877749e-01,-1.9340823788742231e-01,-1.6518985420934240e-01,-5.7753271048087973e-02,4.2079955785147637e-02,-1.0154648359854340e-01,-1.9336294901074233e-02,4.7334618038762183e-02,2.4757352585732434e-01,-3.0732678458890889e-01,-8.3627315813636832e-02,-2.1315711058958497e-01,7.1186199840168399e-02,1.9636034093707841e-01,5.0493328184583790e-02,1.5032076670049485e-01,-2.1508688745006166e-01,2.0761102111528223e-01,4.0711211137028314e-01,9.9007537926132025e-03,3.5567872859536706e-02,-1.6918467045392585e-01,-5.7698581400368293e-02,1.8499751819760513e-01,1.1501729393899007e-01,-3.8857837818360935e-01,-8.1548847261122187e-02,1.1312453607651485e-01,-2.8046677935694037e-01,-3.9826981221181071e-02,7.0841402264046033e-02,5.7213131146932897e-02,-8.4369927882818080e-02,-1.8094150935180708e-01,-3.2060678571480750e-01,3.9749049490064975e-01,-1.7136448824876478e-02,-1.4668390963442368e-01,2.0300104424394678e-02,-1.1469222639775989e-01,-1.0969599879965132e-02,1.5272808750964248e-02,-1.1114241830174230e-01,1.7635211192164893e-01,-1.5774226531669500e-01,-9.7624217227879326e-02,6.0656380379059596e-03,-2.1089372972193274e-01,-1.7645623412961806e-02,1.2448824293843225e-04,-1.8070908920791390e-01,4.6910313000966701e-02,-4.7219305952920426e-02,1.1388316015417912e-01,-1.2417405166233249e-01,1.0072587466970147e-01,-3.1709031792333664e-01,2.1147692311195898e-01,-1.9008054367335886e-01,4.6724639486153674e-01,1.6505716511588256e-01,-1.9031148578875071e-02,-8.8194615202492652e-02,-3.2672382762206659e-02,-1.1478072397936991e-01,-1.0402953576960393e-01,-4.2468821030078524e-01,-1.5992524038111008e-02,-1.7994035007189207e-01,1.7246152176389842e-01,1.7311540725179481e-01,2.6232826745133914e-01,-2.8990486696016581e-02,-1.6112288711260764e-01,8.5446244100151857e-03,-1.3364736586515957e-01,1.8697211347106290e-02,1.2568653071182562e-01,1.3881650265985533e-02,1.3219441987680072e-01,-1.1551257741091137e-01,-4.5992897018982570e-02,3.6249969712967056e-01,3.4017785529522573e-02,-1.0136133514793061e-01,-3.9964349505809582e-01,7.4877591365983848e-02,5.7741195489728545e-03,3.6901516174379416e-02,-3.1856647500973417e-01,2.5935352987191673e-01,-8.3758766140428847e-02,-1.3034987615912749e-01,4.0030483241529358e-01,4.1067104046779296e-03,-7.5303108492035545e-02,-4.1397508314823317e-01,3.4387629902610732e-02,-2.2722425948284344e-02,2.3625699673212669e-01,-5.1821793539437930e-02,-7.8569536020941549e-02,-1.6200247520629249e-02,-1.4254432225120900e-01,8.4844326410114759e-02,-4.2442457092033141e-02,-8.2648911542278242e-02,2.0107565579867526e-01,-2.6532000419098944e-01,-1.5935472171894977e-01,2.0642388009655563e-01,1.4997011738584393e-01,3.4476021955805103e-01,1.5226056823594553e-01,-3.7851237760323009e-01,2.0719974954997658e-01,-1.6912313490500983e-01,1.4452902540168971e-01,1.6408073423572972e-01,7.9047739943577999e-02,2.0426993054684572e-01,2.5104371867226283e-01,-7.9513689378639771e-02,-2.0990122001011510e-02,-3.6066137818355470e-01,1.2553295960396788e-01,1.0641644488912252e-01,-6.7192032163816945e-02,-6.7037778804859560e-02,-2.0189984514976039e-01,-1.2807400788184709e-01,-1.2849254886991165e-01,-2.4926544901315761e-01,2.9894960772586615e-01,-6.3454487731778891e-02,2.0916568818080564e-01,2.9599723241849624e-01,-9.1449288479468621e-03,2.7063155890941987e-01,7.4337798180837036e-02,5.1527028013489413e-02,3.3646796161104620e-01,8.1745044935730704e-03,-2.2860454191128327e-02,-1.3389770176072131e-02,-3.9120702024098036e-02,2.2042729779595863e-01,2.9782642651226360e-01,5.0444015991615376e-01,-8.1329651269989423e-02,8.1580471952181488e-03,6.0468516607247100e-02,-9.3359060872087771e-02,-9.1384995879855144e-02,-2.4435626443546903e-02,-6.0120869695735289e-03,-1.3981919794946546e-01,1.3244623574297065e-02,9.8727151471238075e-02,-1.1741946981376528e-01,-1.0813999269778940e-01,2.0334381495304324e-01,-6.1365514640432661e-02,-2.5785579095268085e-01,2.2804717547889078e-01,1.4417417190443918e-01,1.4075804248659013e-01,-1.6783081884780776e-01,2.0766451386433518e-01,2.1779583255919846e-03,-1.6926230798906255e-01,-3.2601710296295550e-01,2.4306645647434652e-01,-5.9502438489370917e-02,-7.1111053095051072e-02,-8.4405944507912889e-03,-2.0066009366010190e-01,2.9676126732817087e-01,4.5320024746035269e-02,8.4902457842242665e-02,-2.5663518075691272e-01,-9.3650698592090312e-02,-4.2682431678559291e-01,-4.8153198541480625e-02,3.8656521998842910e-02,-1.0308533459095007e-02,2.4203789592214017e-01,3.2444521191585518e-01,-1.1051626826437906e-02,2.8743405762390352e-02,3.8121162424160776e-03,-4.7506582543072606e-03,5.0333629410361611e-02,3.8366469174698617e-02,-1.2697418495834706e-01,1.1103254773877932e-01,2.2695765043656416e-01,1.0279265317581755e-01,-1.6886329836100133e-01,-1.4577521293914958e-01,2.6834842692787791e-01,-3.1478817191436781e-01,-3.8246223961145992e-01,2.1269478930002092e-01,-3.8095487393382582e-01,-2.6498867432335727e-01,3.7818196297176608e-02,1.7418400280729801e-01,3.8008660308976955e-02,-2.4668852253256556e-02,-1.5610991330813445e-01,1.1024988590854096e-01,1.4564400201657274e-01,3.1202327817037689e-01,3.2815025517565377e-02,-7.9337621693924450e-03,8.5974284186513650e-02,1.3974307922746637e-01,-1.3033405396184461e-01,3.5788940754554258e-02,8.9776319182828745e-02,1.8555700154671301e-01,2.4942368158371858e-01,1.1685920596825893e-01,2.3280521267866242e-01,4.8517518449916724e-02,-1.0349420666778163e-01,-3.8946925848535280e-01,-7.5991820704633173e-02,7.0708915475361980e-04,-4.8511502474520660e-03,-5.1998217856821877e-02,8.2297251017980008e-03,2.2815554300009194e-01,-2.6325379842394692e-02,-1.2770141046586661e-01,-2.3592978135100928e-02,-1.1668600740135815e-01,3.2615297076819255e-01,-1.3067710340531283e-01,3.8955530821979717e-01,1.3155636182067134e-02,-8.3487694785756419e-02,-1.7371479541837451e-01,2.9942023315482413e-01,1.4445745534845827e-01,1.0286750984606488e-01,-4.0189865133774857e-02,-3.2254519383319114e-01,-5.7614249796118032e-02,2.6094974044373737e-01,5.1877886377095325e-02,1.1916271722310816e-01,-1.9673312731785908e-01,9.0121970463486384e-02,4.3979162325428228e-02,-3.9001308809585800e-02,1.4108921213859989e-02,1.8012090484959592e-01,2.2063490115667173e-01,-1.2839456127086196e-01,3.2416083126665468e-01,-1.3668577299416412e-01,1.2698538583245839e-01,-1.3490500959887469e-01,5.7135336619374887e-02,-1.2636104354741690e-03,1.0853454844115132e-01,-7.0987843160469091e-02,-1.3635223639151581e-02,2.8328073447325952e-01,6.1295219655633025e-02,1.1359549071133822e-01,1.4511328072641716e-01,-1.1574555257629240e-01,-2.8079557892896474e-02,3.8657604528190015e-01,8.1359556419580606e-02,3.9379261683816841e-01,3.2700191900709835e-01,2.8411302066548916e-01,1.6857284123747016e-01,9.4307083713652165e-02,1.8963029875118859e-01,7.3285043760031920e-02,-1.8562018680979051e-01,-1.1894315317455471e-01,-2.3778105914846884e-01,9.5018705842928999e-02,2.8325005160161765e-01,1.7233065134279354e-01,1.1833555946142540e-02,-8.2323314824002181e-02,3.3203964425496690e-01,-6.1778720518931046e-02,-1.5251675698159783e-02,2.2046417872061599e-01,-2.1992843884825800e-01,-1.4062583484249285e-02,4.3972894116671504e-02,-1.6318515242601209e-01,1.9701021003083932e-01,-2.1642288877180843e-01,-6.8034248705059641e-02,-2.9151318303568646e-01,-3.4440692610271062e-01,3.7686357003175922e-02,2.1572676314205541e-01,-7.9146026909746578e-02,1.7311920943110148e-01,-2.8497792274264461e-01,-1.3944366157007007e-01,8.0669081058237918e-02,1.5957959556140144e-01,1.3542374447723471e-01,-1.9648356956711223e-02,1.5203595846523105e-01,3.2315133550366654e-01,-2.8338728233358140e-01,1.7671873519719283e-01,-3.4350661327758991e-01,-1.6100063186844077e-01,1.4523082989640829e-01,4.8249714793571777e-02,2.7000325722608104e-01,8.3316050748097309e-02,3.0546431344451042e-01,1.3423263890154774e-01,-1.8151365292611810e-01,3.3039924679303327e-02,1.7361180967394568e-01,2.6823051261843101e-01,4.7499809781888259e-02,-4.7662115767274249e-02,7.0954945735497189e-04,-7.5329557902339458e-02,1.0145099403553076e-01,2.4562084815665958e-01,-1.5823205741248539e-01,-1.5950505781830923e-01,-3.0991593132177885e-02,2.8865433873975949e-01,2.0453437109531869e-01,1.6492580042279859e-01,3.0735314426774896e-01,3.5233036089487568e-01,-2.7079356096234436e-01,-1.8757440374198805e-01,-1.8992540209534320e-01,1.2604713388014777e-01,3.9580958330676624e-02,1.2517345181244657e-01,2.1061050210609092e-01,-5.4479329116790765e-02,-7.1420962766390123e-02,-6.1521736533112152e-02,-4.1513609464345749e-02,3.6128719569769996e-01,-1.6772477134909203e-01,-8.4052924803423523e-02,-2.9005393954491798e-01,3.2935433892917171e-02,2.3972566791965444e-01,8.4299299055193178e-02,1.1204666498961539e-01,-1.8380178066501535e-01,-6.4855739457030159e-02,-2.7713623451016089e-01,1.8839917211017645e-02,7.6184178445335343e-02,-1.5096677418905463e-01,7.0047300125575765e-02}},{40u,{4.4974792029751143e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5853072201589881e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2813851195982757e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.8482640559839431e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.2537761877480281e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0637481871082519e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8127950032842055e-01,0.0000000000000000e+00,-1.8757289795754403e-02,0.0000000000000000e+00,4.1230714447654832e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.2039364538822612e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0559604611915623e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0683572650197579e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7253166432284084e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3888367935762437e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6590671037082919e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5003372462710067e-02,3.0566673870307071e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.2087497170609077e-02,-8.9411026202777322e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3653665151357162e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8248089704283763e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4379963880467381e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6140952385814070e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.1323981767218154e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3588938224472994e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4606833838373673e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3320328504495197e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.5618260744263804e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4913545654169884e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.3411370662495223e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.7332284639832127e-01,-1.2865834352871839e-02,-6.8675436412206275e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1090566545710949e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1783896955508258e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1135041982637199e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1600597792625191e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5924160180839470e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.5090385587767372e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.3710847924755325e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.5998320544162302e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0043699026239140e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.1703413166214003e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.4400465667273259e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.3375218089803396e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.5925340384053943e-01,0.0000000000000000e+00,-1.6429451163091716e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.6324155998599115e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.9625792268860144e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.8857846341992524e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0622573501023996e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7154657393465494e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.3694878203568357e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1790382760281783e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.5543884957041250e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1914240966776908e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4770677023615790e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8912943769195442e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4865798833888537e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1740924977569626e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1326770376479859e-03,1.3028309692153159e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.8326602770457476e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2581443704801216e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0772492998902289e-01,0.0000000000000000e+00,-8.3352368742201433e-01,0.0000000000000000e+00,-9.4933924206756698e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.1640974725161266e-01,0.0000000000000000e+00,0.0000000000000000e+00,-9.3785050120928332e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9393955858212684e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1417578969199735e-01,0.0000000000000000e+00,-7.8053596146356900e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.7941720395304894e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1197582283458949e-01,0.0000000000000000e+00,1.7743362328383661e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.5398815718153078e-01,-1.3202080708436770e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5021624768905133e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4458306959957256e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5648307037681218e-01,0.0000000000000000e+00,-3.2005640833994334e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9923058218093848e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.1258087196235720e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.7489945697250092e-02,0.0000000000000000e+00,0.0000000000000000e+00,-7.2535146943502726e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3100036307017893e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6095730133662516e-02,0.0000000000000000e+00,0.0000000000000000e+00,-2.5753144114709425e-01,1.2122502403718666e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1929217926604823e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.2596827563790838e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7745902623242696e-01,0.0000000000000000e+00,2.0383703376894879e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7531144750081629e-01,-5.9042226849415658e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1363682636247446e-01,0.0000000000000000e+00,-3.5097787808480357e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4590479938346185e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0022333196946973e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.1392386524444873e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7332580450792829e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0686231470845295e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.2152498033621411e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0758774573680736e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8058547952052997e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3577694488410675e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.9986433736123683e-01,4.2358352611600647e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7530514883256214e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7890447181186371e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2379713520404076e-01,0.0000000000000000e+00,-4.9675233797410168e-01,0.0000000000000000e+00,1.5929401538193327e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.9532929060132090e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.5736626649944449e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.9321475918518370e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9158083005007551e-01,0.0000000000000000e+00,1.3096973341241129e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9940458096800222e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4503384474163505e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6723699530074145e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1630368502567152e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.5205380557529402e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8393124510057583e-02,3.9074505448809160e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9399255360295462e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.2296191254855894e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6621192002878762e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.8231994614622928e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.1680748330791996e-01,1.0205547042480445e-02,-8.6577111967912651e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3981552528509894e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7462321090970127e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.7372551900043629e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0288136514016970e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9219258991680742e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.9485402014976525e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2498060549183457e-01,0.0000000000000000e+00,1.3729943084660154e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7223108004271045e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1807102074708165e-01,0.0000000000000000e+00,-6.6747509507393199e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1059123114740910e-01,1.9333687922657419e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9578504827543876e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0817098572783673e-02,0.0000000000000000e+00,-3.4943021023611220e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5899257888997169e-02,1.1114578669486656e-01,-7.8011286655716339e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6270478154740218e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.7290406999991711e-02,0.0000000000000000e+00,4.7179681740162783e-03,0.0000000000000000e+00,4.2747423992716377e-01,0.0000000000000000e+00,-1.5716022327672102e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9714484486789244e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.6515669893907919e-02,0.0000000000000000e+00,7.6402745682660833e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.5710708652906291e-02,-2.2130366396653522e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.2593661143039106e-02,0.0000000000000000e+00,9.3638375097771143e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.4688429649197680e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4813092375147302e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8352456697100787e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8016658530031818e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.1787682410391149e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4791892629122141e-01,2.5900109764348041e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4742632678697360e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.6039398721012711e-01,0.0000000000000000e+00,-8.7219208519466393e-03,0.0000000000000000e+00,0.0000000000000000e+00,2.2316456287404188e-01,8.9553774813470113e-02,0.0000000000000000e+00,6.2789315486384946e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4544947798952597e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5020884201073493e-01,6.1320398112310812e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.2255715775385596e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5222086148327491e-01,0.0000000000000000e+00,-2.0649783487853717e-02,0.0000000000000000e+00,0.0000000000000000e+00,-9.4258792373854983e-02,2.1202509078094064e-01,0.0000000000000000e+00,1.4865828206352110e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.8594423830642521e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5359632488525519e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8831908350780331e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1042294008437218e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8793772217166924e-02,0.0000000000000000e+00,9.9934136815631869e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.2094643206241830e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5585255833900550e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.5101591696144578e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3852261667120080e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2684679975101412e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9049116919582856e-02,-7.3717246892265206e-02,5.1740848212002655e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7423848278004839e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.4630243698913927e-02,0.0000000000000000e+00,-3.1291840658668087e-03,0.0000000000000000e+00,6.4451621149025795e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.0382952956662001e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.9183477384884002e-02,-5.7916526044100088e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.9745726877416458e-03,1.6941248006487294e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7761434904413495e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6308160182506475e-01,2.1389323836655189e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4218717871244353e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.3918478923736513e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8798046149453284e-04,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0513083963141385e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.9091971036461406e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.3041604657342667e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8353042429390743e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.0505595922935028e-02,0.0000000000000000e+00,-8.1000867627426332e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.3427997318318201e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0203319774960060e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9281504478389666e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9223543735362025e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6311553421084221e-02,0.0000000000000000e+00,7.9091008216749181e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.0883575526047218e-01,0.0000000000000000e+00,5.5569480821682379e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.5231043820060501e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5341945821846817e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6995119149458671e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7245025322008122e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.8135733855927079e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7937867395970535e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4291881441608995e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4279924887347434e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.3378265856640028e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9380837558932551e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.0616299244512359e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.5274036626662505e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3724030604135046e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7379517930020506e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1608772582389835e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9801029284986715e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7030057936002788e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7669279114405371e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4832074746648080e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9429184274398223e-01,0.0000000000000000e+00,1.7199634376429845e-01,-4.0450965672815437e-01,2.3837202773137520e-01,-1.0868949649653707e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.4674683751896269e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1705190521456859e-01,0.0000000000000000e+00,8.4036494475549811e-02,0.0000000000000000e+00,-1.5812834080406029e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4985655283073572e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.9510869807730910e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5519964860700889e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.5222327308925896e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9861192789451133e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8696905674108344e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0861452990537534e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4007144319758653e-02,0.0000000000000000e+00,6.1193238345899903e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.8690775359469256e-01,0.0000000000000000e+00,-7.1822416709257986e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5445277960365780e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.2676162361214278e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.5117469015903400e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.3833861711726467e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.4125430220497709e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6796365831565158e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.5700935901319475e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.1423132566061053e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3224424325354739e-02,0.0000000000000000e+00,5.4105976405847567e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.0491853348827353e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2954959721272311e-01,0.0000000000000000e+00,-2.9430206788731358e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4170768085189093e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.0483179722413080e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7496725714856802e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.3551942727444616e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4188038695269209e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.6910810007557049e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4661277761818089e-04,0.0000000000000000e+00,7.7359889021355641e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1671902936199899e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.6448909495093981e-02,-6.2567057157339498e-02,-2.6259810434065689e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3516807841598806e-01,-1.2414294601679163e-01,2.0313420576912183e-01,-6.5913548852692003e-02,-1.1577045904469219e-01,-1.0055394500456087e-01,5.6357826774448755e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7392882277621144e-02,-6.6394762696724963e-01,0.0000000000000000e+00,0.0000000000000000e+00,9.8460276104104377e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1936004421422644e-01,0.0000000000000000e+00,2.4051202190407427e-02,-4.8928467507377132e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6733659120053892e-01,0.0000000000000000e+00,-6.9371054091738216e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.3837588495472046e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8712889585806583e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6584538729365631e-02,0.0000000000000000e+00,-5.5175737685216542e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.0806403642722882e-01,0.0000000000000000e+00,4.2681494904746609e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.8567964876385177e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.6676037316396389e-02,0.0000000000000000e+00,4.8037105215971693e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.1312339966542173e-01,0.0000000000000000e+00,-3.7159366553673040e-01,3.9658699786277798e-03,0.0000000000000000e+00,0.0000000000000000e+00,6.2758146661421625e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8402847949288317e-02,-3.9651204415066288e-01,0.0000000000000000e+00,0.0000000000000000e+00,5.8800850790001913e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9220266600134065e-01,2.5879845402445156e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.8828605848929747e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7919163842848145e-01,0.0000000000000000e+00,0.0000000000000000e+00,-7.3323442149336851e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.2589606973370261e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.4787565881602726e-02,0.0000000000000000e+00,1.8964933870027936e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5816858185574360e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.0460481821382407e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9496177810804449e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.7253319814882691e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9271678147511544e-01,0.0000000000000000e+00,2.8796409759395408e-01,0.0000000000000000e+00,1.3942689882592396e-01,-1.8197289600212563e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5381275557369772e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.2451092354959732e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5806680986936701e-01,0.0000000000000000e+00,-2.0926907639249090e-01,0.0000000000000000e+00,8.8320427838482163e-01,1.3224322126617483e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9688262231421392e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3362073951771964e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.5491304479393979e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5379135598186100e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5434495612848222e-01,0.0000000000000000e+00,3.7843611079068067e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.1661950816691034e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7687536353438156e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.2055117002789821e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7650345719508079e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8067750477453831e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6851900072041641e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9216950178799855e-01,0.0000000000000000e+00,1.1231181735232935e-01,-2.6414058397639106e-01,1.5565444621984867e-01,-7.0973106820015799e-02,0.0000000000000000e+00,0.0000000000000000e+00,8.3729797304365483e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7233054133457812e-01,0.0000000000000000e+00,5.4874953803681403e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.8953326070165533e-01,0.0000000000000000e+00,1.2289728301110514e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.5067868209963560e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0739115109580231e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.6179377181295726e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.0472595121593894e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4783021114578651e-01,0.0000000000000000e+00,0.0000000000000000e+00,9.8122321306133231e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2917522027715970e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6586270994296807e-02,0.0000000000000000e+00,7.8906947604158353e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4368925401585822e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9432316978160995e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0169548310526825e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0681081358945441e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.0740262495485096e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2999714247392726e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.3869714783291693e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2526022188389224e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6682684031945347e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9367835359736578e-02,0.0000000000000000e+00,-3.5233498970247151e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5127303531065934e-03,0.0000000000000000e+00,0.0000000000000000e+00,-3.9762851750231292e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5122554548660447e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.7255553854454011e-02,8.1270286142320802e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4852362516526875e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9075692876130975e-02,0.0000000000000000e+00,-4.7779784456456136e-02,0.0000000000000000e+00,0.0000000000000000e+00,3.0193436683758380e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9763647628019736e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5329547684584467e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2871300683440559e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6392415850286910e-01,0.0000000000000000e+00,1.0983962172218371e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5440494860329743e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8384101944185767e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.1083446328265955e-02,-2.0575739135275192e-01,7.9851277738660645e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0191847875645368e-01,-4.0825523666593222e-01,-6.1769394428111399e-02,-2.4062059690926793e-01,-3.8072156069037943e-01,-3.3068068652066201e-01,1.4758359684568442e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1370491175846154e-02,2.0189432249712591e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.9939968047959682e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9252623417317650e-01,0.0000000000000000e+00,7.9094540265033236e-02,1.4878251532197753e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.9744417060945538e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8818105502100044e-02,0.0000000000000000e+00,-1.6841863281829186e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.2566797881685732e-03,0.0000000000000000e+00,0.0000000000000000e+00,8.3184643691259323e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2556862919983849e-01,0.0000000000000000e+00,0.0000000000000000e+00,7.7939328707359451e-02,3.8847775216419350e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.2911806626621700e-01,1.0269231399127655e-01,0.0000000000000000e+00,0.0000000000000000e+00,6.6944316902935050e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2286806257381995e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5946041984101836e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4045922828555120e-01,-2.2189422451040508e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5243503445521813e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.8333456913172270e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8675369109214888e-02,-7.2298825685840673e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.4813680527721707e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3603151889981003e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5700714467694632e-01,1.7809277248599270e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5965471016583827e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.5819731497771754e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0859425108507008e-02,-4.7845992848265767e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.0567897854071095e-01,5.9462131918271634e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2556615111341479e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.7690926068649386e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0404864690747136e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.8280540407241814e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1588004772770545e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1617133236918382e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1637582171669709e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.6809064789186356e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5360403507070477e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.3948872525088927e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4833263382463051e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6958240884125959e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7906749475768141e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5088889569102096e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6093062568838954e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3491720496210358e-01,0.0000000000000000e+00,-2.8636912905258879e-02,0.0000000000000000e+00,7.0824196300444053e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0021453907462668e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3396287626722647e-03,0.0000000000000000e+00,1.3687232800061882e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5773857706578615e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.6024302429939977e-01,0.0000000000000000e+00,-5.2532453117555573e-03,0.0000000000000000e+00,0.0000000000000000e+00,3.9766327626802996e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9143465859091373e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.6280641842875535e-03,0.0000000000000000e+00,0.0000000000000000e+00,-1.3043537292424653e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9447269019636133e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2577037970791716e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9558844826329276e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.9974701502765763e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.8188252024311908e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.6082534567183955e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4539507234211529e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.8937367710012936e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9937860369338425e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7635544504126770e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0047627897443704e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4791953712315403e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2257146971831798e-01,0.0000000000000000e+00,0.0000000000000000e+00,5.3024333594712458e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.2349553955726245e-02,0.0000000000000000e+00,0.0000000000000000e+00,-6.5436640227648705e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0045985347393008e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0485726889628584e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.2153094828155086e-03,2.1689686607652700e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4900199104575546e-05,0.0000000000000000e+00,0.0000000000000000e+00,9.4702086747223457e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9529757894232795e-01,2.8299167593486378e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9607334608665008e-02,-3.5169692098513060e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.4267819369879780e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4150049819965855e-02,1.9576759048469939e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2663345860896692e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1540996882390895e-03,0.0000000000000000e+00,0.0000000000000000e+00,2.2641549773860088e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.3268007486155216e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.5230421580282567e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.0361056913173421e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7211133109889455e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.4684246363842857e-02,-8.8200239289096360e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.8392704943707209e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.1672974763909565e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3471956153798706e-01,3.5801509146649385e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1524931155894431e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5432691588894613e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6119158974643886e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2629179373733216e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5199384746647917e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6023862618123928e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.6521518188330798e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2521841714727986e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7559360703563264e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5851311078260432e-01,1.2105454699153136e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.3161038023094676e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.0265619143958657e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.8683989195039057e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6170042564984660e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5250191809770045e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5987509967001358e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3760815962719494e-02,0.0000000000000000e+00,9.6421915648107392e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7975431183203951e-02,0.0000000000000000e+00,0.0000000000000000e+00,-2.1177007657397875e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1727782088138351e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0687606205818241e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.3522666180759271e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5100178596805256e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.7991278059454938e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9614950060950567e-02,2.5459978197171235e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.2229603087211062e-01,-3.1641199023658445e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.6816702493532332e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8525281719233485e-02,1.0804398498100931e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.6142233483817721e-01,0.0000000000000000e+00,1.6214575984789212e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.2394252370947690e-03,5.5366732384683044e-02,0.0000000000000000e+00,0.0000000000000000e+00,2.0369975960894607e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.4483569118037568e-02,-5.1696490240679516e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.2354078270749778e-01,6.4247460224129263e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3567132625255204e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0590467112008640e-03,1.0716510592318879e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2406138593950146e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1242215991768199e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.1361239798008381e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1011716213599238e-01,7.9585175471786695e-01,0.0000000000000000e+00,3.8765353198531978e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6581035236543975e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.8751612753010840e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6564020447455312e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.3171936748195732e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.2232283650002676e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9861269308027800e-02,0.0000000000000000e+00,0.0000000000000000e+00,-6.8834067822063738e-01,0.0000000000000000e+00,0.0000000000000000e+00,6.2257054607887542e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.2084208712982467e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.8161251756357103e-02,-2.0635778347771114e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4176194041973496e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.0334621570286973e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.6570038255283616e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0868651334545341e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3060366665878223e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0314763128634699e-02,0.0000000000000000e+00,0.0000000000000000e+00,9.9015711221330482e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.1222768003892056e-01,0.0000000000000000e+00,0.0000000000000000e+00,6.4417517331758246e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8955075618770156e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0968028964560718e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.0873626633939072e-02,-2.1351887231803819e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4668140520761162e-04,0.0000000000000000e+00,0.0000000000000000e+00,9.6200329288854566e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0340518629380255e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2689586500432790e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.9368755811734583e-01,0.0000000000000000e+00,0.0000000000000000e+00,8.1450426124904551e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.1513930696061835e-03,3.0874681591418120e-02,0.0000000000000000e+00,-9.9924834120022088e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1950337317034576e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.1154048272516012e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3260392828746744e-02,0.0000000000000000e+00,2.2377703326008211e-01,0.0000000000000000e+00,1.4791797377426804e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.3459623290374230e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9539673538643247e-02,0.0000000000000000e+00,-1.0695595435412547e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5110056317877987e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.4146527511212832e-01,0.0000000000000000e+00,4.1050362332743444e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.1074546510703827e-01,6.4538891652323582e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.5657180929526144e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7310220550004599e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2932816070747394e-01,0.0000000000000000e+00,0.0000000000000000e+00,-9.1988484236343190e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0612890410631769e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9643154982623566e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9433542161023110e-03,5.1184281404600580e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.4793813301760039e-02,-6.3610896374838499e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3432709472376594e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4188985968152601e-01,-5.3743013020101604e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7317879400016198e-01,0.0000000000000000e+00,-8.0654204712934419e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.0984376675218905e-02,1.1130828113378722e-02,0.0000000000000000e+00,0.0000000000000000e+00,4.0951432625469436e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0026319238559709e-02,0.0000000000000000e+00,-5.0671203528440711e-01,0.0000000000000000e+00,-3.3493972305546245e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.3121061135237985e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1217571544491838e-01,0.0000000000000000e+00,2.4218691492605757e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5229476714044446e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.3609214820832341e-01,0.0000000000000000e+00,-9.2952848394461551e-02,0.0000000000000000e+00,0.0000000000000000e+00,7.0363997942891177e-01,2.8502030143698220e-01,5.1554092525866035e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6937578154548572e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.5307076216728150e-01,0.0000000000000000e+00,0.0000000000000000e+00,-7.5909129898487679e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3852061847211712e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7145676247028255e-01,4.0636679829962537e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.3333076981228826e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6307404214063332e-01,0.0000000000000000e+00,4.2267555726053991e-06,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3703972027658784e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5808810141478135e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7602871228499908e-02,-8.6695235380013613e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.1323505343413964e-01,0.0000000000000000e+00,-6.8777474698372340e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5831925654352621e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2594348986507114e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4757098695339852e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.2108401317278694e-01,-1.7244031520655789e-01,-2.9157956119621492e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6499122539270481e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3133781687787938e-01,0.0000000000000000e+00,2.6839901766374569e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.7558006459291282e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5605664876840034e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0010836994821353e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1998482814092570e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.0475985158885057e-01,0.0000000000000000e+00,-3.4486571946705291e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8492431660219504e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7298581030159385e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6368014792839989e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.2732095056005261e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8549744966430715e-02,6.7665271915361968e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4403839213281082e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0614394626751024e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4371287218567619e-01,0.0000000000000000e+00,7.0380888974407990e-07,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9532953925657576e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4797924115966392e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6765658985176302e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5732917267986805e-01,1.8071075698096126e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8585152475104666e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8257783953624311e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6339011761336947e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.7257324443560851e-01,1.1920664324568725e-01,0.0000000000000000e+00,-7.1916244300964727e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2721512531171389e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4802466055759499e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1926110951805745e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4487031561206349e-01,5.0328926933717862e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.3228604923434146e-01,0.0000000000000000e+00,5.2348782742701267e-06,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4169571372947658e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7172503183626647e-01,0.0000000000000000e+00,2.8461609559637873e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7938991881943760e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0244875953635822e-01,2.9603862154805720e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.4284572665459667e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4039612611926363e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.2179524215474926e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.2410205012707524e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6091561509233394e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0874778003465360e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.8381738165744290e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.1188500717444434e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4071339530250493e-01,0.0000000000000000e+00,-1.2300696715390574e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.3524290655515526e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.8452927267797452e-02,9.5827169591321182e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.3298803300418978e-03,1.6740114676302053e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9646309569427930e-01,0.0000000000000000e+00,1.3280347051951622e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.9660752105877481e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.9626294547716677e-02,0.0000000000000000e+00,-8.0979407021441935e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1331729595937777e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.8803672022984692e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5076474822295355e-01,8.4037156766103716e-01,0.0000000000000000e+00,8.3019386688856875e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6172951210027322e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.2048355365132066e-02,9.9658102120382571e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.5398426956584288e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5089192427730207e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1166178287450380e-01,0.0000000000000000e+00,1.0365769060247393e-06,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.8461379855000435e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5688596896386489e-01,0.0000000000000000e+00,2.7250542140682354e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.3844268603517647e-06,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2034687937987383e-02,0.0000000000000000e+00,3.6520167045734865e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4902641424922864e-02,0.0000000000000000e+00,-3.9696765114536348e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.9943245592574903e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7985834526575844e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.3518342179422509e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.7247988552157384e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0135556506245142e-01,9.4649905909755860e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.5088111594334463e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9322166756155458e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.7106857593578533e-01,0.0000000000000000e+00,-1.6094435603465118e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6507021875462128e-04,0.0000000000000000e+00,1.7494362197239777e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2678297730104373e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6740355181460119e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.5228112165150676e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3037281405080388e-02,7.8301106796141545e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1383370789476868e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.3843446779415476e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6630210201573348e-01,0.0000000000000000e+00,8.1443572869783560e-07,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1451582765339916e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9961927648741784e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5443638871553513e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.3549083261396357e-01,8.3673187135791749e-02,-3.3416137851093247e-01,-5.0412762262487421e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0128641592251347e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5084341766911433e-01,0.0000000000000000e+00,-5.2435982643023009e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.6133535799955450e-02,0.0000000000000000e+00,4.7902115336609585e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8880168322682118e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4445872635339059e-01,2.4607283873668048e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0755941570411034e-02,-6.5190364621296168e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6507844125282243e-01,0.0000000000000000e+00,-5.1717128786439657e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.2024501949884861e-02,0.0000000000000000e+00,1.2675188144714783e-01,-9.3693043807282395e-01,2.9849421852545099e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1226965199067532e-01,-2.3345292221685510e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.3831862266047480e-01,0.0000000000000000e+00,6.9138035135649234e-01,1.7176897720310905e-01,-5.4723429332298915e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1238563525662648e-01,4.2799302962926427e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7298581030159385e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8492431660219504e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9961927648741784e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1451582765339916e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.7811137011628422e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3662016231140551e-01,0.0000000000000000e+00,0.0000000000000000e+00,5.5580518555974767e-01,-7.9154315156860522e-01,9.2290370146798681e-02,0.0000000000000000e+00,0.0000000000000000e+00,-6.2281549557813221e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.7576675987659589e-01,7.4340994668048860e-02,3.7610940884702104e-01,-4.4924050020556971e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9989794386838420e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6977913157052280e-01,0.0000000000000000e+00,-4.6726991369109580e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5191469564070717e-06,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7686075617675275e-02,0.0000000000000000e+00,-2.9312801604395901e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0086802126753949e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9473828300184641e-01,-3.0489215174194284e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6408226350295593e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1402645575458121e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.0799845455491077e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.7682217333928127e-01,5.4552743290547079e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.2962618556352485e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4757059084629709e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0309800354942191e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.1486743536207371e-02,1.1604834835204797e-01,1.9622630850276249e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.4404070140959879e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5600299368333395e-01,0.0000000000000000e+00,-3.1880421993113328e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4611381426230068e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8536400993093860e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7524852318595984e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1047748059241196e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.7812422765765024e-01,0.0000000000000000e+00,3.6401067767008749e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.0937278020562737e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6432849152511712e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.7770289000592687e-01,1.8695273353642772e-01,4.6939764458676744e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5991159592213153e-01,0.0000000000000000e+00,-9.0356543903586040e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5081986817954271e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0862709179882480e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.5755670583548274e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5227305930852719e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6390148021631554e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.6518260872493038e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1557213995404562e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.4624192124019655e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.8827371494222626e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2495928659216854e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2033270372508631e-01,9.3145347506466566e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5204329673269259e-02,0.0000000000000000e+00,-8.7926133680407503e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.5942920416503232e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0286493453082965e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.0112743800783844e-01,0.0000000000000000e+00,4.9055435349127569e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5511907270055991e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.7144857827934193e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3109099709035726e-01,4.6835597185195227e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2747795638828349e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.6531314832860599e-01,0.0000000000000000e+00,0.0000000000000000e+00,9.2155857671725044e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3227871967912685e-01,0.0000000000000000e+00,8.2830577129955507e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9437859966656043e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1996190071861915e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.1541513593199774e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.3210748723810399e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1355601942777585e-01,2.6226818971734473e-02,-8.8181197205164694e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0120403136760482e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0407178765112636e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.3512161596483394e-01,0.0000000000000000e+00,-1.0276082353851343e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1628577479062155e-01,0.0000000000000000e+00,1.0836075784867191e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9270580935568302e-02,0.0000000000000000e+00,3.9140690526154298e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4816866686579800e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.8161702632715780e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.9457136513563025e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5152336823364039e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2997117115178769e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6239410397013282e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.0325005666203818e-02,7.5443092075597562e-01,3.5970876627121917e-03,0.0000000000000000e+00,3.9544884422566505e-02,3.0610315297645171e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5750705922468153e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1811906403494274e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.2891788123319129e-01,-1.8274711874636293e-01,5.3018911848633687e-01,0.0000000000000000e+00,-3.3233466249595500e-02,0.0000000000000000e+00,1.6121066519138763e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8242854096304557e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.7942151758193033e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2418045726964465e-02,0.0000000000000000e+00,0.0000000000000000e+00,-9.8329595090505617e-01,0.0000000000000000e+00,1.7402217701108519e-01,0.0000000000000000e+00,-5.4590591996841664e-03,-4.2256672581266752e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3157552665793135e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6306001966971687e-02,0.0000000000000000e+00,0.0000000000000000e+00,3.1601464608280040e-02,2.5227721723692940e-02,0.0000000000000000e+00,0.0000000000000000e+00,4.5877858113985859e-03,0.0000000000000000e+00,-2.2254675358161840e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5183742963753989e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9401372414865428e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.0445490583565116e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0971704351823715e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.8697983037856892e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.8433822736554444e-02,-3.1659307221173943e-01,8.5717420740177887e-03,0.0000000000000000e+00,9.4234164246501259e-02,7.2943378682614343e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0902243360284009e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.8147386048648848e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.4550381254318447e-01,-4.3548039790684950e-01,-2.2249114830371144e-01,0.0000000000000000e+00,-7.9194261477163422e-02,0.0000000000000000e+00,3.8415973453354700e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.3472123748454009e-02,0.0000000000000000e+00,0.0000000000000000e+00,-7.7035616048291761e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.7062557005813841e-01,6.9777748772312506e-02,0.0000000000000000e+00,0.0000000000000000e+00,-4.0581976318578789e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9337361059201872e-01,3.0061454197901111e-01,-2.6925832992269066e-01,0.0000000000000000e+00,-1.2457982266939788e-01,0.0000000000000000e+00,3.7217599590970256e-02,0.0000000000000000e+00,0.0000000000000000e+00,4.7955294093264561e-01,0.0000000000000000e+00,3.6748779572379639e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1585500758295625e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.9775470039598222e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4076658799557525e-02,9.6034290681174761e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.2906994744715463e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.5539643013384579e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.4336156015138103e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0675228764469655e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0037698878228443e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4638985720085805e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1748507567612221e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.5076472731791770e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.2562394256392158e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9281459866027683e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1362253122223011e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0571321635713190e-02,-1.5923542338111170e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9570207414296363e-01,0.0000000000000000e+00,6.0183106193061175e-03,0.0000000000000000e+00,-4.4115792459754069e-02,0.0000000000000000e+00,0.0000000000000000e+00,6.1445754439620866e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4680512343308954e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.7288110289681760e-02,0.0000000000000000e+00,-8.3862084645943066e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4899662661376664e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5943309938244026e-02,1.7487762571114041e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6307776023143680e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6990343458276851e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2982892281335708e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2966729458467247e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2116392681399602e-01,1.7119527926546321e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.2614143344308800e-02,0.0000000000000000e+00,-6.4703339577431448e-02,0.0000000000000000e+00,4.7429241872199351e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.6060822822013776e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7285296635738258e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.8586585862434846e-01,0.0000000000000000e+00,9.0160798997499472e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0202738754070316e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2950001954157433e-01,-4.9292608602684335e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0249098159352999e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.5966590489789161e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.4638397577305651e-01,-4.4197490435718229e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.2161316100136456e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7229827566046302e-01,0.0000000000000000e+00,4.8748073545643106e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.7356966396506101e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.2485999756650938e-01,-5.1953112039091975e-02,0.0000000000000000e+00,0.0000000000000000e+00,-5.4505280571277537e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9402740842382655e-01,4.0375263702647374e-01,2.0047663371282387e-01,0.0000000000000000e+00,-1.6732201839580924e-01,0.0000000000000000e+00,-2.7710411347391783e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.5705175514111265e-01,0.0000000000000000e+00,-2.7361350803299364e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0962537744621991e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6955019242798545e-02,2.9291992827302354e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6734401556469818e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.3958165204626095e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.7315515999068568e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.4548901849810917e-01,-7.4120124759865225e-01,1.4702604817059867e-02,0.0000000000000000e+00,-1.0424583973338125e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0238776152999141e-01,0.0000000000000000e+00,-2.8968404414410004e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5051447402957761e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.2612512787581944e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.1267142691209260e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.8954748129829979e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.4388339635707573e-02,-2.3004374102997538e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6326184468280763e-02,0.0000000000000000e+00,0.0000000000000000e+00,2.2854918870509147e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.0719101451859308e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7937259749865384e-01,0.0000000000000000e+00,2.3651114996349979e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5502095637103843e-02,0.0000000000000000e+00,0.0000000000000000e+00,8.9321800474023272e-01,0.0000000000000000e+00,6.2807050113265026e-02,0.0000000000000000e+00,0.0000000000000000e+00,-2.4735180111779889e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0905679891898824e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.5258984744344781e-02,5.8255354280171867e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.7069458650312348e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2479572182411503e-01,0.0000000000000000e+00,0.0000000000000000e+00,8.0561997342864367e-01,-3.4779119531215680e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.3247546831941906e-02,0.0000000000000000e+00,3.0680456320516664e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4718490094855795e-02,0.0000000000000000e+00,0.0000000000000000e+00,-5.5439030743032347e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.6218176684458836e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9224667175198804e-01,-6.7497087285682975e-02,2.2694227504783046e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6045771491556768e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6783814471117240e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.4774768212607865e-01,0.0000000000000000e+00,2.6446426016830055e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9927194371474997e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.7498070614136532e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.1816696802375055e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0382268355447762e-01,-3.9518842720237946e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.6852309330868716e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3813487761780252e-01,0.0000000000000000e+00,-8.2350254563575453e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2504507716287647e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8089488948075023e-01,-2.7399265486590454e-02,9.2123258857797721e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0572826718873905e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0872422395527359e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.5323121784944242e-01,0.0000000000000000e+00,-4.4346615667352629e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.0824023998328913e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5179861993282899e-03,-1.7197165389177621e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6635907479219552e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.9936649130702176e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.6036786882211287e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.4412523167095381e-02,4.3515511275620887e-02,2.5042998953478890e-01,0.0000000000000000e+00,6.1202150280389896e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.0111282944797142e-03,0.0000000000000000e+00,1.7007188439253466e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4399466665909642e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1296758304002501e-01,-2.9706380310048963e-02,9.9880362280885815e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1463096031418442e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1787918721073014e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.9139488547280841e-01,0.0000000000000000e+00,6.2443618635149423e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1723899203197437e-01,0.0000000000000000e+00,9.5562626747892954e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9458180002214890e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.2787667035695747e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.3746795319810126e-01,0.0000000000000000e+00,4.2582126771112860e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7252989539131460e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2791320066495990e-01,4.5700248483759404e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1189700770894197e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.5403342285340925e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.0892140166634707e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5499867408164572e-01,0.0000000000000000e+00,-4.6985057163990519e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1025988147421564e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.4962383834476305e-01,0.0000000000000000e+00,-1.2477182747319922e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4255400781937356e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5294367705478860e-01,0.0000000000000000e+00,9.0480729880173238e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.4593721275825260e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5435601165100421e-02,-5.5147616123605712e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.9597903164691966e-02,0.0000000000000000e+00,0.0000000000000000e+00,5.4789332096749264e-02,0.0000000000000000e+00,0.0000000000000000e+00,-5.7542599856796127e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9479814179653888e-01,0.0000000000000000e+00,2.1544207054495265e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.0557812625269483e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.7212021180864703e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3819147573511787e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4498213143495832e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9469787988213904e-03,0.0000000000000000e+00,0.0000000000000000e+00,-7.8969511266937908e-01,0.0000000000000000e+00,4.4790423112779160e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0045750037748312e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.5077005431664097e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.8504400322290874e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2118293175018192e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9492490004104061e-02,9.4857518241679895e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0600832545853524e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.5420446770936247e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4448507582139371e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7203211524868683e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5719793148360390e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5827917969953378e-02,-4.1053023279934997e-01,4.3052976625860039e-03,0.0000000000000000e+00,0.0000000000000000e+00,-9.1142951566985730e-01,-1.3542445321983725e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9702077762723571e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1836736088463053e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0206097997172843e-01,0.0000000000000000e+00,-5.3256045161971333e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9957796241054142e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9049906423090049e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9117051209662360e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.0204066898873917e-01,5.9776599867153524e-01,0.0000000000000000e+00,2.9725173187695358e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.4660153017358658e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4834858884469155e-02,0.0000000000000000e+00,2.2996134542009766e-01,-5.0572636874499277e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1124044299940153e-01,7.2159688025589114e-02,-3.7243574371849997e-01,1.6129527335329391e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.0215895157709119e-01,0.0000000000000000e+00,4.0710523043116842e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3010104867564137e-01,0.0000000000000000e+00,-4.9068290785505253e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1131510419546395e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3438667835347962e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6359822907275687e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.6963611520545264e-01,0.0000000000000000e+00,0.0000000000000000e+00,5.4568521134602965e-01,-9.7864753511485631e-04,0.0000000000000000e+00,0.0000000000000000e+00,3.0667625353856764e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6658849096597558e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.5537807471453106e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6139407964053718e-01,0.0000000000000000e+00,-5.8428231443575318e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4321078706752239e-02,0.0000000000000000e+00,0.0000000000000000e+00,8.5099007297264342e-02,7.1677031660422286e-01,0.0000000000000000e+00,-2.4789946548579453e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0604152744302179e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.2410137697176182e-02,0.0000000000000000e+00,2.7574245897192312e-01,4.2176136603924586e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7616850397430489e-01,-6.0179121508264433e-02,3.1060078678982717e-01,-1.3451565714079117e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.2000976474987219e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1647664112822809e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4920081799390691e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8918634231157798e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7379835590248267e-03,0.0000000000000000e+00,-5.2541767595659901e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1510852761854071e-01,-1.6791086315023265e-03,0.0000000000000000e+00,6.3328460016044358e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4366536947536476e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5387492026682635e-01,7.1308127012157229e-03,0.0000000000000000e+00,8.8262359779241084e-01,0.0000000000000000e+00,0.0000000000000000e+00,-3.4708528977357600e-02,0.0000000000000000e+00,1.9686201339945104e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6656641150071629e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5097123231744795e-02,0.0000000000000000e+00,6.6218223316042890e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1818901004861683e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.7277146314174079e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.0153764247120711e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2489993585769098e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5344831673492345e-01,-2.2794745470575131e-01,1.5054157779464680e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.3187492425771880e-01,-4.7353313191000246e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3804185513980902e-01,0.0000000000000000e+00,-4.5680112977925219e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.4728389699247309e-02,-1.4598266388657141e-01,0.0000000000000000e+00,5.5058125004722602e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2490349314384554e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1995693087962478e-01,0.0000000000000000e+00,1.0837980049407626e-03,0.0000000000000000e+00,0.0000000000000000e+00,3.1314189172963088e-02,0.0000000000000000e+00,-1.7760978382524696e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5189614210316067e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5594122887564419e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.9989567685522720e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9171275457370707e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9327753127229601e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1575727134661132e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6330514078045122e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.3907772629018562e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5024987448466545e-01,-8.8289573894706341e-01,-4.0868952862318633e-02,0.0000000000000000e+00,0.0000000000000000e+00,3.8975023068348574e-01,1.2855453975097222e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.8178510167314519e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0326466427450792e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.5757953539736873e-01,0.0000000000000000e+00,-1.2446463950174770e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9150732587451209e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4871375342527153e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1498151601768609e-02,0.0000000000000000e+00,1.1088221594519368e-01,9.0809938653147348e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9790714214744560e-02,0.0000000000000000e+00,0.0000000000000000e+00,8.6405850728244726e-01,0.0000000000000000e+00,-3.8655932703488816e-01,0.0000000000000000e+00,2.7027594809974859e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9368324476071379e-01,0.0000000000000000e+00,0.0000000000000000e+00,-8.5647343232166648e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5774647802095265e-02,0.0000000000000000e+00,-6.3073895184353967e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.8376792511919822e-02,-3.1655192828813500e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.1698036626292512e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2600388012350914e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.3262063715615663e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5904891598124089e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.3331874294513972e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0314261046270177e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.3260203956889283e-01,0.0000000000000000e+00,0.0000000000000000e+00,6.7758629755352995e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9298309641840283e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5662623816888919e-02,0.0000000000000000e+00,0.0000000000000000e+00,3.7616235317811103e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5712192805415834e-01,1.6448824547847010e-01,2.7701997448235272e-01,3.6767310452402613e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1682941758414182e-03,0.0000000000000000e+00,0.0000000000000000e+00,9.4179018619224720e-03,0.0000000000000000e+00,0.0000000000000000e+00,1.3903429769309292e-02,6.8607851407578347e-04,8.6584210039831633e-02,0.0000000000000000e+00,7.8137572071466221e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0119647828882081e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1678646319857121e-01,0.0000000000000000e+00,0.0000000000000000e+00,5.9966075365864492e-02,-9.8203898237585951e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.6600196465483553e-03,0.0000000000000000e+00,-1.4886839436547781e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.8375123020709467e-01,0.0000000000000000e+00,6.0938896299752382e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9474606861074002e-02,0.0000000000000000e+00,-7.3449498072453892e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6662570470979049e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5740407047929255e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.2771965782498245e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.6526945280883177e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6905548108272909e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4093970645999413e-02,0.0000000000000000e+00,4.6236209197312944e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.2280997138112875e-01,1.4775981377065118e-02,0.0000000000000000e+00,-5.5728386375934594e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2642403142183050e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.1577304870279395e-02,-6.2750410366380724e-02,0.0000000000000000e+00,1.1100694968680794e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.0543144628820301e-01,0.0000000000000000e+00,-1.7323652497928346e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0908719030353221e-02,0.0000000000000000e+00,0.0000000000000000e+00,6.9835589866168987e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.0309665924936361e-01,5.0874067735514348e-03,-1.1676590611032380e-02,0.0000000000000000e+00,5.7940542557397640e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3647174787564588e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6599453524046444e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.4466021270256101e-01,1.3243600832071589e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.9385352210713808e-02,0.0000000000000000e+00,-1.1038883485265386e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9049906423090049e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9957796241054142e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7121821486580795e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4606941808739344e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.6799739790340278e-04,0.0000000000000000e+00,0.0000000000000000e+00,1.9367289594493339e-01,0.0000000000000000e+00,-1.0984860885776612e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7850391345000547e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.2465809163850152e-02,0.0000000000000000e+00,-3.2550525341548647e-01,-2.6658118113862223e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.8097517179202196e-02,0.0000000000000000e+00,0.0000000000000000e+00,2.9433848144834818e-01,0.0000000000000000e+00,-1.3168007067830617e-01,0.0000000000000000e+00,-7.9342066018777979e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.0222577313457755e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.8577180546405082e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2479542192832758e-01,0.0000000000000000e+00,3.9633438067836219e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1557990838854648e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1072861198447439e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4509730811184954e-01,0.0000000000000000e+00,5.4785488119125669e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6354367865507431e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8670428363478950e-02,0.0000000000000000e+00,1.0092784710776417e-01,-9.5952489749070535e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8014017499492219e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4601212497593347e-01,4.5947840510844778e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1153718272955048e-01,3.2808251527399572e-02,6.8711841541109916e-02,0.0000000000000000e+00,0.0000000000000000e+00,-9.0707646955404855e-02,0.0000000000000000e+00,0.0000000000000000e+00,-2.3776666846170730e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.8541169207314467e-02,0.0000000000000000e+00,4.6093333650697543e-01,6.6282959003828006e-03,0.0000000000000000e+00,0.0000000000000000e+00,-5.1581327241696939e-01,-1.1100996986886121e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5485563171020758e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.2066237144654111e-01,-1.3786195526756245e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0974851120540220e-03,-1.2727924376466313e-02,-5.1393008579907674e-02,-1.3027944830264182e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4366678415819546e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7820320101530193e-03,0.0000000000000000e+00,8.3157662405829558e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.2924446538706689e-03,0.0000000000000000e+00,2.2393774721815259e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1317320713629924e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2462259992932540e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.7444583615560199e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.2633535679293405e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.0456517927026225e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3502149159309226e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2093746305541498e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.3735026180870223e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5882688698172882e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.5428579624662984e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0970642689737140e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.4214445561960891e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9601182907004739e-01,4.2338657559746740e-01,-6.6119668378417790e-02,0.0000000000000000e+00,0.0000000000000000e+00,5.6965995189357951e-02,0.0000000000000000e+00,0.0000000000000000e+00,-2.4708813652234163e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.7841698488058909e-02,0.0000000000000000e+00,1.1263313074140910e-01,-6.3782416104381078e-03,0.0000000000000000e+00,0.0000000000000000e+00,-5.4045779394158400e-01,1.0682208815544271e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4901366031768168e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.1611035022290124e-01,-1.4326673223280029e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9429063567219848e-03,-1.6425234705711636e-01,-6.9001711909825930e-02,-8.2268740242012628e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.6141677805434167e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.2405639992484672e-03,0.0000000000000000e+00,-3.2403084458487413e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0900455970175053e-02,0.0000000000000000e+00,7.4381282367166099e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.0721855992792377e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5336529769273732e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2516105121711722e-02,0.0000000000000000e+00,4.2043692787339387e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0172891037942186e-02,0.0000000000000000e+00,0.0000000000000000e+00,4.7140320834206838e-04,2.5716571070090105e-01,0.0000000000000000e+00,-9.5671390301036185e-01,-1.3373799486684574e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.0720376728390718e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0249074336602599e-05,-1.0676162188789261e-01,-1.0161170556991779e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.2393870326161394e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5469508403298157e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3855445295632199e-01,3.4511606095099123e-01,2.3133587962102648e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.3406853643700531e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.2423558903018988e-03,0.0000000000000000e+00,-3.2479578494711686e-01,-1.1760952706104348e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.9205909491817400e-03,-3.7374327991125215e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2136084512474444e-02,0.0000000000000000e+00,0.0000000000000000e+00,-4.0624054325547512e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.3055914100482853e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.2703948859692454e-03,-1.3388738870218969e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3206182435537514e-01,0.0000000000000000e+00,0.0000000000000000e+00,1.5496611294873706e-03,8.4539031270444676e-01,0.0000000000000000e+00,2.9103008055299007e-01,-4.3964183635836593e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3386159423055810e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.9438896199433816e-05,-3.5096141187194130e-01,-3.3403190227834678e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0510966801177613e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9513270533687274e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.1458289640907561e-02,1.2491369068148818e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.2507387604934417e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.8978085550533623e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.3525731048191775e-04,-5.1857567545887787e-02,2.4698524166213986e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0306717785590454e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4041902155777978e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9340084357325000e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4561985285281820e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3892650021046571e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.2361370841960161e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7340288108343977e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1986373053143451e-01,-5.3981702732985049e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.0153281442735524e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8171045060526694e-04,0.0000000000000000e+00,2.0376993256393425e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.5419036390465310e-03,0.0000000000000000e+00,5.4873812381194848e-05,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0124415973179889e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7444583615560199e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2462259992932540e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1877801542985889e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9817227475023547e-01,0.0000000000000000e+00,9.2534004803346129e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5194172593097918e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4993828578036286e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6271237007532017e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.6297553412779225e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.0456517927026225e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.2633535679293405e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8410946581485593e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.5405904352300785e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7326918457736515e-01,-1.3703648353415782e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.7899724651494401e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4552915788670778e-02,7.1425060732848877e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0250053330414576e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4611099743054619e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.9974420086800774e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.2304955409679554e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.2050037865643852e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1929676439845910e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.7509681646212387e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6982733650209288e-02,0.0000000000000000e+00,9.0639520291665165e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9735815792081867e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7177195252523831e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.7362182633393373e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.0801219560932429e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.8739140538983914e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0066946982258015e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9294953943973622e-01,3.2835446960538667e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9103157045031071e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0347580278430307e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3850534064238285e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9402386717341624e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0059840507321101e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5611436656893709e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.7484024815639996e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.3593141647742042e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5204358640452269e-02,0.0000000000000000e+00,-6.5190551022127653e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3400537559244508e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1920635723742810e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8030810702836934e-01,-5.7211854987185467e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1927882344418493e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4623551689632463e-02,0.0000000000000000e+00,6.2700270040417089e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.5918631226340973e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9173265306907739e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9144116829751654e-01,5.5026360430549329e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7632635332646778e-03,2.1022879807088994e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1791002800668840e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0403234768990398e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.1384684897005031e-01,0.0000000000000000e+00,3.2522305068647256e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0002152447798601e-02,1.1925276327409159e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.6884731238303838e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3394671996675661e-03,0.0000000000000000e+00,-4.0037986905661355e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0296284114716926e-03,0.0000000000000000e+00,-1.0781948808333936e-04,1.0118107050696640e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.0036244652063591e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.3592922442615283e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.7705847357190729e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5244679746847084e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.0591755087823574e-03,0.0000000000000000e+00,0.0000000000000000e+00,7.9404575129721688e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8636371107271846e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0978758496647052e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.6040389325371328e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.9141564066366642e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0172489864648333e-03,1.2128364690182235e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8023783297876160e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3622784279443889e-04,0.0000000000000000e+00,-4.0719836867553788e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0812232137223045e-04,0.0000000000000000e+00,-1.0965566216507099e-05,-9.9486802691164233e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.1569568745744914e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3069921706073979e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0662843953391344e-01,5.1467702127822879e-01,3.4499484350291237e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.9993852152342545e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.3093237287366522e-03,0.0000000000000000e+00,-4.8437307339354685e-01,-1.7539294142069756e-02,0.0000000000000000e+00,0.0000000000000000e+00,-5.8468390773090909e-03,-5.5736924412449915e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.7751364581669924e-02,0.0000000000000000e+00,0.0000000000000000e+00,-6.0583292515867151e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5693043846904389e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0842454486516911e-02,-1.9966837305131643e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.6900449852476904e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4913855843267531e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.7733233999859461e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8774258708821698e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7288595278443413e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7668838932992793e-02,5.1457421144820059e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.8450283432943438e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.5148253453243117e-01,7.2834526055292276e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0113816605350582e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.3110577623767590e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1846564675106721e-01,3.1147822034308587e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1025112304248065e-03,8.3589183652006335e-03,7.5101900385617604e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4990050729763502e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2464207860605850e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.1150246508880048e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1953161111074923e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.5402748983617586e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.2920136205733115e-01,1.3310954339663977e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1955727964562580e-01,0.0000000000000000e+00,-1.7288061575394373e-01,0.0000000000000000e+00,-2.2645627560112563e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2223395408524854e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.5073372165933516e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8990089931149761e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3382750303193150e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6500084154208559e-02,0.0000000000000000e+00,3.4712453646160615e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8736687485952914e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6603898386533634e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3020905485848958e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.6884466992854914e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.8102711654795917e-02,0.0000000000000000e+00,5.3870357076167066e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.2791433915979660e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8567415806593919e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.2263505450428718e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.6482457339890029e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7950722184166459e-03,-7.1366382810486365e-03,-6.4120149743636756e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9270054858605221e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6311615112166141e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.9910663549111887e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0205314065510870e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.8710038956281598e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4404399061204542e-01,3.6231255612909873e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9761574696503811e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1283255747530014e-02,-4.4858649182210553e-02,1.0262733958246266e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8025730711824803e-01,0.0000000000000000e+00,6.3374809075595051e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0928734485131182e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.4147373795686302e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1678852348939426e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9729062276348885e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4145449585194378e-01,9.5994655844443777e-01,0.0000000000000000e+00,1.8161530020182094e-02,1.2012205060110508e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8669369503180808e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.1376731451002581e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.2263505450428718e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8567415806593919e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4609076444162432e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1141302483925581e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9004467761132134e-02,0.0000000000000000e+00,2.2139114961513276e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0412294388743097e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4126903536972717e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9737485947839568e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3397404420179257e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9098484119597718e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.6884523746883517e-01,0.0000000000000000e+00,6.5631356286929210e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.3194323497036859e-03,0.0000000000000000e+00,0.0000000000000000e+00,4.9321238845695205e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.2804706009652150e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.0106214002129413e-01,3.2889342690195400e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.9461147473799463e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9520028820317730e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9662191731974598e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1253076154891752e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7629049048617579e-01,0.0000000000000000e+00,1.3221831765892927e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.4756969816838745e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0810409465498958e-02,0.0000000000000000e+00,0.0000000000000000e+00,-4.7838063613943310e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.9159001014833215e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.8997257252468941e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.9485220150779606e-01,0.0000000000000000e+00,7.9120973838206224e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.0719553161935449e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.2024881857227272e-02,0.0000000000000000e+00,0.0000000000000000e+00,8.0059167869301140e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5510193184753957e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.9502907675052587e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9921314570366626e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.6199509488747206e-01,-9.1052301159940230e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.2772249607891355e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.6481944370302398e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9358240712393759e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1522593045393852e-01,0.0000000000000000e+00,-8.9898924265210789e-01,0.0000000000000000e+00,8.1047196904182293e-03,6.9648115325710747e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.1556669518859704e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8480949824776044e-03,2.7225855485254479e-02,-6.2287143443818166e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.1856238977800686e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.8932673198116408e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.9214376185943658e-01,0.0000000000000000e+00,6.0775930406607881e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6007935761782257e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1222384392361858e-02,4.4616643964227987e-02,-1.0207368154461711e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7874536389354532e-01,0.0000000000000000e+00,6.3718560490363940e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1096495088931869e-01,0.0000000000000000e+00,0.0000000000000000e+00,6.3801309001907569e-01,0.0000000000000000e+00,0.0000000000000000e+00,8.7743053793232795e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1041314390823193e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8914585858477072e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.3067876476120986e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3084815640454279e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7272664021341027e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1236897548365278e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5174242329447715e-01,0.0000000000000000e+00,1.5892816213492778e-01,0.0000000000000000e+00,-7.2287979174978367e-02,0.0000000000000000e+00,-3.1020899961829744e-03,5.6004246451142612e-03,0.0000000000000000e+00,0.0000000000000000e+00,9.2927506345559796e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2857346698018879e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1320013914937763e-01,1.7939059057506529e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9589546365822672e-01,0.0000000000000000e+00,1.2827907947327966e-01,0.0000000000000000e+00,1.6803273431421151e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.0698769448807476e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5705164123822259e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.8145546460529582e-01,-2.1190418035879011e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.0051057672675421e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0655343672377918e-01,0.0000000000000000e+00,2.5888044528932345e-02,-1.0292266111144727e-01,0.0000000000000000e+00,1.2694247485574070e-01,8.3960934850234081e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.6441639389625059e-02,0.0000000000000000e+00,-2.1321269154680193e-02,0.0000000000000000e+00,0.0000000000000000e+00,4.5534441001426496e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.7016583427845143e-05,0.0000000000000000e+00,0.0000000000000000e+00,1.2124210174827969e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.0640948948746663e-04,1.3049208773140028e-01,1.3622049955106501e-02,2.4843224846186284e-03,8.0849003922105409e-03,1.7582782125892946e-01,7.6528042918125906e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3362203567337941e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.6337665996842392e-04,0.0000000000000000e+00,0.0000000000000000e+00,4.3368717541803842e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.5537307453440745e-03,0.0000000000000000e+00,0.0000000000000000e+00,8.8865071262018402e-01,-6.5706394783562522e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2035230303605279e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.8088669995069786e-01,0.0000000000000000e+00,-7.5328508213348033e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.1431234979190089e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0144083083809745e-03,0.0000000000000000e+00,0.0000000000000000e+00,4.2835098563277135e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8490622866530573e-02,0.0000000000000000e+00,-1.5386130514205721e-03,8.7771654365200277e-02,2.8564129141676681e-01,-1.9859784796224328e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2132626064351806e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.1847445066622406e-03,0.0000000000000000e+00,-3.8885716085520399e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4927222815438924e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2560258031063301e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.3893183241575900e-02,0.0000000000000000e+00,0.0000000000000000e+00,-9.9145764740895437e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8426520302693547e-01,0.0000000000000000e+00,1.4970054406923179e-02,-5.9516192303429451e-02,0.0000000000000000e+00,7.3405921139239022e-02,4.8551359735163929e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.8432888824399708e-02,0.0000000000000000e+00,3.6871339962161097e-02,0.0000000000000000e+00,0.0000000000000000e+00,-7.8743710891245311e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8600032474498904e-05,0.0000000000000000e+00,0.0000000000000000e+00,-2.0966663470436361e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3945416766655487e-03,7.5458524912102296e-02,-2.3556910765137180e-02,-4.2961935446468105e-03,-1.3981396171060900e-02,-3.0406292071131291e-01,4.4253205948380841e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.6337512044827632e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.2644993433024002e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6611708265009419e-01,0.0000000000000000e+00,-7.4155662583698589e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0026887448165467e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5470644019484082e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5401582442445081e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7333767739390138e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3058590394082639e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7040155094566198e-02,0.0000000000000000e+00,8.9186413198264991e-01,0.0000000000000000e+00,-4.0566162053102278e-01,0.0000000000000000e+00,-1.7408134370980450e-02,3.1428148402097164e-02,0.0000000000000000e+00,0.0000000000000000e+00,5.2148535961695705e-02,1.1496674900435944e-01,-6.7418055438813029e-01,-3.3058287840881184e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.7550581971886351e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.8786571334803095e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.7410040575521261e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.8929650129582067e-02,2.5359558433379120e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8832235271189606e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4049837149799432e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9698983476745799e-01,1.7352140472418204e-01,8.4922082875273461e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1792184157440461e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.2089541667322281e-02,1.5101441753053149e-01,0.0000000000000000e+00,0.0000000000000000e+00,-7.0807459478433177e-01,0.0000000000000000e+00,6.5123793767126625e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.3870588544488435e-01,0.0000000000000000e+00,-3.5782014531773543e-02,0.0000000000000000e+00,-8.8278374687894581e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5077513575129400e-01,7.1653717210374834e-03,0.0000000000000000e+00,0.0000000000000000e+00,8.9612371159523241e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4373631649513667e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0053931876012391e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.5658366923675049e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.5425319707085459e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.6227732368164751e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.9253442707267818e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0676860850208157e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.3583765140530663e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.0717837461587618e-01,3.4655786582274722e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8145629575901344e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1627355896006375e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0444978857334642e-02,-4.6608414805557824e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0180702148311545e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0014472780663820e-01,5.0835342135683315e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.7349437923040966e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.2303719555290572e-01,0.0000000000000000e+00,0.0000000000000000e+00,-4.4560743057585964e-02,2.2366777592388629e-01,0.0000000000000000e+00,-2.0207692856848780e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.9572290726807582e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.1708377213804871e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.7741629047389428e-03,0.0000000000000000e+00,0.0000000000000000e+00,2.5839317437019141e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2549615437136483e-01,0.0000000000000000e+00,0.0000000000000000e+00,9.7223613355584859e-01,0.0000000000000000e+00,0.0000000000000000e+00,-9.2783872876828332e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5608915626042204e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.3689685398669982e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.8378571948790001e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.0602518838628583e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1874363071127190e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4079475399915649e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.3419583479902806e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9242968772997066e-01,0.0000000000000000e+00,0.0000000000000000e+00,6.3912356887948341e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2429141219994459e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.3073840544588275e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.0982717379974283e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.3875701445264127e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.0649578432864105e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.1795807604760462e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1527195018817017e-01,0.0000000000000000e+00,1.2778968284109832e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.6391591933498100e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0823327824325370e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.9267302251217207e-02,0.0000000000000000e+00,0.0000000000000000e+00,9.4217967173961997e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.8561649787892369e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0516113625002890e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1003323892386435e-02,0.0000000000000000e+00,0.0000000000000000e+00,-9.5221609869185597e-01,0.0000000000000000e+00,-5.7537246642995026e-02,0.0000000000000000e+00,-1.4195105234082980e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6220616057214524e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.2646763431184260e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9526028517544292e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5229044504277784e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.5483852243712632e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1113690412487691e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9945629008248478e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.2036684088640721e-01,0.0000000000000000e+00,-1.2985480302083260e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.7141294182865084e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4468221469393382e-02,0.0000000000000000e+00,0.0000000000000000e+00,-4.4380434148032488e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9598635646705871e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.0684491933832210e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.3468451631899708e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7724212149750067e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.1724398949521037e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1450661099792003e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.8116940431279331e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0106368598904753e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.4965817198601790e-01,1.0187956500513882e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.8819819158846471e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4160438211373321e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.9948177781655434e-01,-1.5871107212222017e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4667348367377650e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0220534583884434e-02,1.7310461395679325e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.6123440560038595e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.2756228711873417e-04,0.0000000000000000e+00,0.0000000000000000e+00,9.8114435161089923e-04,7.6163398099176440e-03,0.0000000000000000e+00,-6.8811278216751540e-03,0.0000000000000000e+00,0.0000000000000000e+00,1.3475164761095665e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1020137758575439e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.5095270908609373e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.3694017276827075e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.4171567762152285e-01,0.0000000000000000e+00,-9.7975001463148248e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.5567944035153903e-01,0.0000000000000000e+00,2.1145189310856549e-01,1.2354439522320736e-01,6.0463130681759812e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.3958417833661050e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1025351598524778e-02,1.0751978935077390e-01,0.0000000000000000e+00,0.0000000000000000e+00,-5.0413750237094979e-01,0.0000000000000000e+00,-9.1468108731467671e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.9481612292021361e-01,0.0000000000000000e+00,5.0256795657923251e-02,0.0000000000000000e+00,1.2398933642384839e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.7357839722350996e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.8272806681172056e-02,9.0743538426832504e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.7046560363587332e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.1378089299234768e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1812667149279383e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.7659298816112704e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4050786539305441e-02,0.0000000000000000e+00,0.0000000000000000e+00,-1.8997856980551384e-01,0.0000000000000000e+00,3.6605130088176324e-01,0.0000000000000000e+00,9.0309096111783005e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1883250983920464e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.4736087959226027e-01,0.0000000000000000e+00,3.0292897834373472e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.9134232871891057e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.2654641323942728e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.0148078432679323e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9400023975814631e-01,2.8167031709224938e-02,0.0000000000000000e+00,0.0000000000000000e+00,-2.6235549193955387e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9835153197759844e-03,0.0000000000000000e+00,0.0000000000000000e+00,3.8732803335771018e-02,-4.4264882976905451e-01,0.0000000000000000e+00,9.4206662664327298e-02,0.0000000000000000e+00,0.0000000000000000e+00,-7.8315385884925412e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.8417403974158432e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4274289066926465e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.6429909639955114e-01,0.0000000000000000e+00,0.0000000000000000e+00,-2.1691770337951369e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8819798068843908e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0453663235263266e-02,-1.6003580576945592e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.4956710679840269e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0305843604074162e-01,1.7454948798816342e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.6258020107221285e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.1904780297865629e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.2358542919325217e-01,7.6799120703785209e-02,0.0000000000000000e+00,-6.9385633958566631e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.3587639611919696e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7630711831319135e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1978391338422458e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.6481550687791916e-01,0.0000000000000000e+00,0.0000000000000000e+00,7.8988405108149740e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.8530406267237415e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5568943132861121e-01,2.2307293912874801e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.2323751640522502e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.8490456733253122e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.8731452922218446e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.6807300087435854e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.0849123807392505e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.1821069332044908e-01,2.0698371980333173e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4185418264875452e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9718598314335085e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5629306904208937e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5520545978134003e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.7091323526965438e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.9970914808746273e-01,0.0000000000000000e+00,8.0948427791723052e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9386773222071927e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.7864486279466065e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2639372144148889e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.7263057661318022e-01,-4.1331577378088763e-01,0.0000000000000000e+00,0.0000000000000000e+00,3.8497369646922558e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.2966957910571466e-03,0.0000000000000000e+00,0.0000000000000000e+00,3.5771552112157913e-02,2.7768421228441115e-01,0.0000000000000000e+00,3.3231896797214749e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.9129117206864303e-02,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.7275487456831463e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9936978499227798e-03,0.0000000000000000e+00,-6.7539291411769023e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.9442151261044014e-03,0.0000000000000000e+00,9.7435854802172296e-03,-6.6544991294297950e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.8321922368066853e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.1704933279950556e-03,6.4297444285665073e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.7839805444953249e-03,0.0000000000000000e+00,0.0000000000000000e+00,3.6305402829698873e-02,0.0000000000000000e+00,2.5439254643809861e-01,0.0000000000000000e+00,-1.0959341612285671e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8861011919102957e-01,1.7556575262457264e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.9198999504155658e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.1197976314867548e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.3857262373604984e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.5319524158324797e-01,-1.0710855183340490e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.2678363476655645e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4924940591447145e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.8023751549900221e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4127335061106698e-01,2.8811370936492688e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4929762023728957e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.7046159868465349e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1570788888005793e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6237331050776456e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4268293033529260e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.5520603336810552e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3028313641807396e-01,0.0000000000000000e+00,0.0000000000000000e+00,4.8538841405713136e-02,7.5694701660779473e-01,0.0000000000000000e+00,0.0000000000000000e+00,-6.8917449594269415e-03,7.0312422824194198e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.6788983659258703e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.1263864079342524e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9495030249372203e-02,0.0000000000000000e+00,5.7480594533529417e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3742851631263245e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.7140501318532535e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.2957221004108882e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9156998864682666e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.2096738690409769e-03,0.0000000000000000e+00,0.0000000000000000e+00,7.1905145401008577e-02,0.0000000000000000e+00,-4.7315285694474024e-01,0.0000000000000000e+00,8.5618505526605837e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.4885351519316177e-02,0.0000000000000000e+00,1.0807701507487544e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1564690246460629e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.8369535988066409e-02,1.4467676997298778e-01,-2.2108358086255324e-02,-2.4943124359501113e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7155206077318041e-01,2.1417015351527283e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.9499463549816126e-03,1.9894156473161759e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.4680985776969129e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1869912241135230e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.9662883888171077e-02,0.0000000000000000e+00,1.6263526356923061e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.9656175809556635e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6880254654055080e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9243478002949918e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9993017478552129e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.1418157753874517e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5879715594550736e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.9841613993988293e-01,0.0000000000000000e+00,-5.7211542801462023e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.9428528804077552e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.5180832321332234e-02,0.0000000000000000e+00,0.0000000000000000e+00,7.2824751067136206e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.5459396997606999e-01,0.0000000000000000e+00,-3.2418531441962536e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1050914355172727e-02,-1.5351677719492046e-01,-4.3396909259952476e-01,6.6315719512876348e-02,2.0845317308669742e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.9775339706780185e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7212599777857374e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.3899710085990917e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1617793855117797e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.0016906025502291e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.2528536112844035e-02,0.0000000000000000e+00,1.8557969380194241e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.2212316094808860e-01,-5.0695965759490480e-01,2.4842535346891448e-01,-3.7962394883579172e-02,6.8837654869750742e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.6191292588752594e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.8657765476716861e-01,0.0000000000000000e+00,5.8833955565946050e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.7292534250334181e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.3909021725929706e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4816022447811964e-01,0.0000000000000000e+00,9.1056239679430584e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5127637095477824e-03,0.0000000000000000e+00,1.6498439929702011e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.7497217480779465e-03,0.0000000000000000e+00,-4.0848452171945880e-03,-2.7252909882317744e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.2835236129067242e-04,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1676481398227800e-03,2.6332446976076546e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.5863744265929602e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.1876105221730353e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.9481404347939969e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.4940331840406001e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.1076966713952800e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.4767241005912491e-01,0.0000000000000000e+00,8.2017311406046944e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.1454636356828051e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9759514482240215e-03,0.0000000000000000e+00,0.0000000000000000e+00,1.1915573956544948e-01,0.0000000000000000e+00,-7.8407293778958176e-01,0.0000000000000000e+00,-5.1666928604190965e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.4380591626816622e-02,0.0000000000000000e+00,1.7909701161792486e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.9164125341481161e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,3.0440598289945057e-02,2.3974734252925889e-01,-3.6636289985286466e-02,-4.1333849108490139e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.2201577756874226e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.6514188556221068e-02,0.0000000000000000e+00,0.0000000000000000e+00,-8.1989788737706659e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0308652520878625e-02,0.0000000000000000e+00,-2.2496090404412142e-03,5.1296657365286835e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0713916565833555e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.0888107913375450e-01,5.3243393357489080e-02,-3.0114281880156048e-02,4.6018260391162014e-03,-7.2296686356173853e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.7244916584100816e-02,0.0000000000000000e+00,0.0000000000000000e+00,9.8424566453431783e-02,5.3174511439848318e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-8.5184160250242336e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,9.9249439194733990e-01,0.0000000000000000e+00,4.3470305940598496e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,1.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.8994252499074118e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.4799460661081358e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.7787285904092557e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.0078600684102641e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.4330750522898730e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.3259564224532626e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-6.9300677175507097e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.5862830536682662e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0047530548106767e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.6575081207217586e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,6.9485794147302715e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.1914702333519198e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.9431945047886971e-02,0.0000000000000000e+00,-1.0327208997145999e-01,0.0000000000000000e+00,-2.6996401649321194e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-7.6567342366547761e-02,4.3247521077407436e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.4032167957016790e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.6850702262808501e-01,0.0000000000000000e+00,0.0000000000000000e+00,2.5923216059251736e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-5.1497709803206310e-02,0.0000000000000000e+00,0.0000000000000000e+00,6.9699419767625836e-02,0.0000000000000000e+00,0.0000000000000000e+00,1.9426199463544530e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.3508471327260247e-02,0.0000000000000000e+00,-9.4946502693098577e-03,-1.2153941522877447e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.5384951400409996e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.8159887278105120e-01,2.2471789097251571e-01,-1.2709967350923271e-01,1.9422365422679104e-02,-3.0513379891433362e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.0111318071028976e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0769785581136105e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.1866816512437273e-01,-1.4416921027111598e-01,-9.4870601505598795e-01,-1.6949701144046997e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-9.9722139992319891e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.4494828915941835e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.7103483743767003e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.1554282092370258e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.4633586811325159e-01,-4.2239986076390824e-02,-2.7796038274187429e-01,5.7850990382653111e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3028395876025957e-02,0.0000000000000000e+00,0.0000000000000000e+00,-3.9334642191530655e-01,0.0000000000000000e+00,-3.2401188532618230e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-2.4553865120598367e-01,0.0000000000000000e+00,-5.9121926440597390e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,7.9194218844305650e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-1.0048781923538154e-01,-7.9143278948630513e-01,1.2094049040792128e-01,1.3644765841834544e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-4.6149156831140792e-01,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,8.8714459496605014e-01,0.0000000000000000e+00,0.0000000000000000e+00,-1.1991511549225406e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.7711744825730797e-01,0.0000000000000000e+00,-2.1727366917164183e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,5.6276103158325930e-01,0.0000000000000000e+00,-6.1305661132447953e-01,-8.7604127000373410e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,4.9279366837674143e-02,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,-3.2532224661776243e-01,8.4645310870804617e-03,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,0.0000000000000000e+00,2.3808425498355082e-01}},{50u,{-1.7235778523115614e-02,-2.0805577390939339e-02,3.2027909094182093e-02,1.4239757455609453e-01,-1.1153745674176412e-01,9.3052048519010028e-02,2.2819262226872253e-01,-1.5515983102206365e-01,-1.4041452150495118e-01,2.1509852266648305e-01,2.0826501516155058e-01,1.1269331609350799e-01,1.9599939971955284e-02,1.3943624269344579e-01,1.8480969478853703e-02,2.3381441515010248e-01,-1.6380168768170891e-01,-5.4873578747063875e-02,1.2364890665591013e-01,-4.9736779984751574e-02,5.9153930349979546e-02,2.7215496643084908e-01,1.3480953601418565e-02,7.9572452868496860e-02,-5.0749915459997776e-02,-1.0298598116987433e-01,-9.8092659170468138e-02,1.3322840259975413e-01,-1.6870413015405072e-01,-2.7317210408059578e-01,-1.7671654054471192e-01,-1.2710403198352768e-01,1.9842980727734624e-01,-2.3738717203581378e-01,6.7691862401948272e-02,-3.6231365804767011e-02,-1.4118376251187508e-02,8.4685264516411660e-02,-2.0364909208916174e-01,3.4484703520483162e-03,5.0807757760292192e-02,-2.1844861795497311e-02,1.1224659083330615e-01,-2.2016912545293815e-01,3.1575362506994054e-02,1.5136054663602933e-01,-9.1960844184535401e-02,-8.7979989350786218e-03,-2.5974439933674109e-01,-2.1587059758201377e-01,-1.2653974636019302e-01,-1.5839069208706191e-01,2.0086527292190173e-01,7.2902633896989949e-02,1.5554638109254978e-01,-1.4587544612479250e-01,8.1948729581739765e-02,2.3972915067118172e-01,-1.7669428306339641e-01,2.9752835767908138e-02,-6.8718648716449213e-03,-1.5411345718423894e-01,-1.0032364048442217e-03,4.7450296409019613e-02,1.9375799536247643e-02,-4.8427685266185537e-02,-8.2462384402230970e-02,9.2217208174759591e-02,5.0703371263580918e-02,6.1054077597308297e-03,2.1634132999998951e-01,-4.5426666794182037e-02,9.6815730750036577e-02,-1.8098266455199088e-01,-1.7176840588537740e-01,-5.1030566236124592e-02,5.7765845325501643e-02,2.4228819216682462e-01,-1.0102738412667316e-01,-1.7023953754864728e-02,1.5799515061079059e-01,-6.8075461168703496e-03,-9.9679479492897766e-02,-1.7116078701114082e-01,-1.0880268741036743e-01,-1.3200775853816982e-01,-4.2448607558071658e-02,-2.5980757856052672e-01,8.8028104949268035e-02,5.8509127637344244e-03,-1.4712355979569045e-01,-1.6671974633183179e-01,6.4720168089160771e-03,1.2753907692460315e-01,-2.2901598753624526e-02,-3.4505830960681555e-01,-1.4589816866875438e-01,2.5602422777497413e-01,-2.9391160347661183e-01,1.0168904274136877e-03,-7.1065268305145451e-02,2.2049681975841895e-01,-9.3456396920882256e-02,1.1679341953063353e-01,1.3877445579907122e-01,1.1998082075925818e-02,1.3768491175196315e-01,-1.4908702966403239e-01,2.0749583370286803e-01,-1.5215026227343120e-01,-2.7241507404286514e-01,6.2612419030724509e-02,-3.1378978868060736e-02,1.9088372543946550e-01,1.0507404026797350e-01,4.8401266667647706e-02,-9.1114695688910632e-02,7.5593166091158695e-02,-4.7812513757692875e-02,-1.2287162873950037e-01,8.2935108068639005e-02,3.7330788167365452e-02,-8.0140776522875917e-03,1.0809060200591671e-01,-6.4173694958601202e-02,-1.5890787081052543e-02,8.4258957096070120e-02,2.3153107132640949e-02,-1.9331888798820060e-01,-1.7769781494326359e-01,6.7680021157639159e-02,5.7607783080946016e-02,-3.1430711267896205e-01,-1.6556730756617508e-01,-6.6443272978824408e-02,1.6384575360024273e-01,-2.7388463110996519e-01,1.8055638720816469e-01,1.9825408663161317e-01,-1.8017914068646221e-01,-3.4602697633019541e-02,-1.2529370611558005e-01,2.3973824744085995e-01,2.2162429429868835e-01,-1.0081099310586650e-01,-1.2355237728630583e-02,1.1829448870900061e-01,-1.4866611252064713e-01,4.9944174884076889e-02,-1.3682124728623932e-01,2.2780943961553568e-01,-3.5492137276382479e-02,-1.3302776851059159e-02,-4.7306343209471309e-02,-2.5155122876226110e-01,3.7839948621688130e-02,-9.8307971438128042e-02,-9.6353620061689502e-02,2.7605058949908351e-01,-8.6979242089248635e-02,1.6699718945822561e-01,-6.7732638614515478e-02,-1.6019468012054025e-01,-1.6412405457561435e-01,-5.6006376378860356e-02,5.3067695319010247e-02,-6.4284177335100612e-02,-1.3786374544364177e-01,1.9409893698454375e-01,-8.7128306599251387e-02,4.3668450631369187e-03,3.3152033309353762e-02,9.6064010860021004e-02,-1.0157726357965899e-01,-2.2066972939849862e-03,-1.0572523117966826e-01,1.1997258824924081e-01,-4.2078460879353838e-02,4.4570454919964288e-02,-6.9637524636632614e-02,-2.2360140303658138e-01,1.7674220466585214e-01,-3.9496142565903274e-02,2.4693533425079904e-03,-9.9379632892410155e-02,6.9595350632551803e-02,1.1780599139271004e-02,1.5760756434880266e-01,2.9838474471322968e-01,-2.1167346581096347e-01,-3.0597244728427869e-01,3.7003053854529046e-02,-8.5219482206374139e-02,-7.9670107898581088e-02,-9.1770974643913261e-02,-5.2676752016135038e-02,-1.0527131657691570e-01,3.9633438712320251e-01,-4.4134431479562794e-02,-1.2836039564365884e-01,-1.3511485965879289e-01,1.7456357313047882e-01,-2.4197406521499907e-02,1.2229680053084188e-01,2.2703796427729683e-01,-1.4866011334579965e-01,-1.0576274607284965e-01,1.1160042885613958e-01,1.9136485098744860e-01,4.6012801282554784e-02,1.5071630655121912e-01,1.9069464776577522e-01,-2.1375640736640728e-01,-7.2487430624301061e-02,-3.0626623622088855e-01,2.0667276737682500e-01,2.4217433596931215e-01,-8.9934911145258326e-02,-1.6309200131174262e-02,3.5303504886454184e-01,-8.6421727822658848e-02,8.6627808628622460e-02,9.9424958187733115e-02,2.7148002773986959e-04,4.0558986318516808e-02,-1.8812159911065948e-01,-6.3388299762988348e-02,5.4717615454542387e-02,3.1797807886201901e-02,-1.4631005211285242e-04,9.6581978895555226e-02,2.4773941833108090e-01,1.2518429429676745e-01,1.3265617304692825e-02,2.2715787565076953e-01,9.8291902395887393e-02,1.7789166410973101e-02,7.1405526365906330e-02,3.1713095903676908e-02,-4.6935999767352271e-02,1.3632873119948552e-01,-9.2645177723995373e-02,1.8173796177022761e-01,1.1240529964671336e-01,1.3464328308912452e-01,-9.2828975589697355e-02,4.9458573919202858e-02,7.6225997909696405e-02,-1.6296031747912745e-01,2.8051476641412804e-02,2.0820775723460472e-01,-1.5350148536051303e-02,2.6831506324952298e-01,-2.1616507497699070e-01,7.6395212131386045e-02,-1.6910384793265784e-01,-1.5630915514763841e-01,-2.5979196735000121e-01,-6.8974348966963944e-02,1.7976691413258272e-01,1.5910038186656258e-01,2.1622606462938401e-01,1.4318749139997963e-01,-5.6475844949594886e-02,9.2366391843845212e-03,1.0760743443708719e-02,1.8408760184823722e-02,8.7487056819286948e-03,-6.2790519904166356e-02,1.5784942796147994e-01,5.4502220238978626e-02,-7.2281525595203150e-02,-8.7623778741229008e-02,4.2953088965594723e-02,2.6914545282749669e-01,-2.5113762076594007e-02,-3.3700327627356870e-02,2.3022436203456598e-01,1.2852493683105629e-01,-4.5140540117266065e-02,-4.9360833557683961e-02,-8.2950176988677682e-02,-1.3139345230172905e-01,-7.1554275136583412e-02,5.9186016538694486e-02,6.9497425862390712e-03,-9.6363405159032078e-02,-1.9695797312438711e-02,1.9905518406004877e-01,2.4269449713843474e-01,-4.9324124507276752e-02,1.1457714506308687e-01,-2.3158303313762764e-02,2.9796027666063757e-01,-1.8677210104724665e-01,-2.3919328833926102e-03,-1.1770091253331717e-01,-1.2157527377608748e-01,1.3522636731279375e-02,-2.7112995343460344e-01,-2.6948629469506147e-01,-1.6085801963933222e-02,3.8029441533861522e-02,-4.7811383034587804e-02,-1.5910887983606048e-01,-2.4429340182167034e-01,2.2857747641460108e-01,3.2207410091093416e-02,1.4050742203697669e-01,-7.3426643298454039e-02,-7.1549669027472697e-03,7.3588729748796503e-02,-1.2989070861350649e-01,-1.1861290559237946e-01,6.4596506809591267e-02,4.4607429410156458e-04,-4.6301946809585385e-03,6.4321878951415182e-02,-2.0085638304770351e-01,1.6210201080973158e-01,7.1271479630153983e-02,-3.1991481535494345e-02,8.8683571361255153e-02,5.4162721906108338e-02,1.3535913488659951e-01,7.2488975087075871e-02,3.5140225413577007e-03,3.1429233849617022e-01,1.9446366243925421e-02,-2.5252987511267866e-01,-7.3119923049995511e-02,-2.9219799758889903e-01,5.5590477415046524e-02,6.3243932744194403e-02,-1.4030702031829695e-01,4.5050942396079562e-02,-1.3497542072362292e-01,1.0548579084713470e-02,1.8461158509893874e-01,-1.5408960952999542e-01,3.6622049120441653e-02,1.9789061719679954e-01,-1.9207256062488615e-01,-7.9924716254463485e-02,3.1317327635393449e-01,8.4870624668709080e-02,-5.3696887341796805e-02,3.2841754571800642e-02,1.0885332461357275e-01,2.1126729148631435e-01,9.0760283450529583e-02,1.5553217671390612e-01,-1.6441073409662960e-02,-7.1948007367689165e-02,7.9144929411205212e-02,-2.0239172768829497e-01,-1.6958084391138409e-01,-9.9805988075586466e-02,-3.1320697494752414e-02,1.9595970990789974e-01,-9.5186459796777118e-02,7.7693469911915142e-05,-8.2352683564642704e-02,1.2857750496223172e-01,4.4658020966758388e-02,-2.5258389012638507e-02,-5.9408736139971871e-02,3.4734783683173474e-02,2.6865283718986455e-01,-1.1544466351470342e-01,-1.0565560490564058e-01,1.9401777342131565e-02,-1.6290218197735448e-01,7.6243558723197075e-02,-1.0911577194127292e-01,6.5716785256825089e-02,1.9040210457867798e-01,5.0580906796988387e-02,-2.2739095267808873e-01,7.7754426404005289e-02,2.8122343504652431e-01,-1.6979856620358100e-01,4.2289603280719477e-02,1.7719739013738436e-01,7.9933243267375553e-02,2.1733242420013729e-01,-1.0179584202892142e-01,-2.8711313750257594e-03,1.4901220264788836e-02,2.0504711935877051e-01,4.3993652397202147e-03,1.8652449443331659e-01,4.8281751746387165e-02,-1.1348050101805859e-01,3.3296205879507501e-01,-1.9443061968148975e-03,5.8276108551836361e-02,3.5173873868132910e-01,5.9278311231955719e-02,-1.2646486941332760e-01,-2.1690767833007266e-01,-2.5722602645265328e-02,-2.5689128495115097e-02,1.8987217214040848e-02,1.1890271966482810e-01,1.6620254808766233e-01,2.8728475098015904e-01,1.3896877233293439e-01,-5.4046072741971075e-02,-4.0368464192282391e-02,4.1922304743290228e-02,6.3458597851576828e-02,-1.8461005721374667e-02,1.4506461501326937e-01,-2.4270262514662463e-01,6.5149581819315822e-02,3.4444239996072407e-02,-9.1606668756362933e-02,1.5021905454405304e-01,-2.2053723998334469e-03,-7.9279330977694323e-02,-3.0377100524117628e-01,-7.6394494300541599e-02,2.0093150791985975e-01,3.1251888954557709e-02,-1.6623263051027132e-01,-2.3187137908929730e-02,1.3661950552261637e-01,7.8528585236462296e-03,-7.8411536230136181e-03,-1.0495683381662108e-01,-6.5576634155508462e-02,4.1026680972716147e-02,3.6170944846262132e-01,-2.6508652555681933e-01,9.7198522380227970e-02,1.3710691007076778e-01,-5.3756773345489381e-02,5.5276394174224384e-02,1.6028035837182156e-01,-1.5401555301158804e-01,-2.1409596479691578e-01,-3.1128049011469695e-02,2.8120752249832810e-02,-9.1110378591464536e-02,8.5776547949283438e-02,2.0593896134854014e-02,6.3182887433848992e-02,1.8551701170853183e-01,-2.9007624275385530e-01,1.8111162442073464e-01,2.0593341513695587e-02,-3.1848463890429080e-01,-4.7507749790570070e-02,1.4907868303403091e-01,2.6681026362018075e-02,-5.2224239398477972e-02,-1.4129768808997016e-02,8.5073474106516445e-02,1.9379460319948641e-01,-1.3424135298738840e-01,1.1303942452513954e-01,-1.4696106351278129e-01,2.0522182166385600e-01,4.5171340392569058e-02,-5.0479904882862010e-03,1.4758629954333420e-02,-1.0871843663674217e-01,-8.4894851979194011e-03,-5.2361841949038666e-02,1.2531124123751680e-01,-1.1108826262339312e-01,-9.4567134360348970e-02,-9.5492619092657244e-02,3.3586991692577961e-01,-2.6928433758806269e-01,2.0239048312435270e-01,9.0808103963381001e-02,-1.4366860475241000e-01,-1.3262420510793338e-01,9.1639034018424267e-03,-1.0253378051663005e-01,-2.7706522852051534e-02,7.8609265338322035e-02,4.4271669290789004e-02,-1.2394318625563906e-01,2.3515505899384523e-01,-8.5875668122811256e-03,-2.4800922203514486e-01,-2.0884991368158562e-01,-1.6374483688168148e-01,5.5795377541281020e-02,-1.7739834944420926e-01,5.0912168311629868e-02,2.2308237816472447e-02,-2.0425377439919068e-01,-1.3347540885740955e-01,-1.4233788597950978e-01,-5.6042912430734795e-02,1.3909124524205677e-01,-6.8021137849169383e-02,-4.2469991110803143e-02,-4.4634846210146656e-02,7.8908299219730086e-03,-2.2099476701548104e-01,-8.9101014269857448e-02,7.2120169435362647e-02,-1.3448122438481758e-01,-4.8515239326961893e-03,5.9309664344377858e-02,-1.0183432349393776e-01,-5.3510783500835754e-02,8.3750898797352452e-02,2.0816695267105711e-01,-2.4962075103881997e-02,2.4506398473433283e-01,3.3964510731939757e-01,-1.3851575711054215e-01,2.1709618251199859e-02,1.6684027043483771e-01,3.6200217644875785e-02,1.7548367689290503e-01,-5.0076654155381373e-02,-3.6733191285767297e-01,2.8864039144942448e-02,7.6102435502683821e-03,-6.4346798923428039e-02,-3.2312086180519971e-02,-6.2901619868133959e-02,-2.4510300581560722e-02,1.8675247680944015e-01,8.2607338862499460e-03,-3.3441498291752453e-01,1.6828993757251090e-01,2.9973045229039326e-02,-5.1709068355006937e-02,1.7456170450151312e-02,-2.3462897019576537e-01,1.5538767155377883e-01,8.3973242932248587e-02,-1.8480563209970635e-01,-3.0535266119237788e-02,1.0484918528596805e-02,-2.2660835978387373e-01,-9.2183198538222461e-02,2.5753704449738013e-01,7.3763079042162255e-02,-5.7118033327055069e-02,-5.3597702822860388e-02,4.9474969729919147e-02,1.4887138941833089e-01,2.5480279621042851e-01,1.8814840936632701e-01,-5.7008125648384970e-02,-3.3495055552096353e-01,1.3331960542198706e-01,1.9843252753860346e-01,5.3092522624200174e-02,4.8134638982962524e-02,1.6041005165846695e-01,1.2491460426191899e-01,2.9239792025538702e-01,1.0295093471632943e-01,7.1158665681140112e-02,2.5261055737919785e-02,1.3008701919826271e-01,8.1248089413915564e-02,7.3338408265260641e-02,-3.0826053856601365e-01,-4.9285767940581024e-02,1.4680582323049943e-01,-1.9603547857146250e-01,-9.1913221235716533e-02,2.6411582359759791e-02,-1.6295130344302508e-01,2.1539931012627148e-01,1.3142661595405164e-01,-1.5083366054953307e-01,-5.2194563240235685e-02,2.4278373859722892e-02,-5.2234775611932509e-02,4.5881952564181833e-04,-6.8196185934192369e-02,1.0559011916949153e-01,5.7895353892847390e-02,2.1688284082552403e-01,2.2424840278233579e-01,-1.2959187309094972e-01,-2.2166705535063759e-02,-7.9191611103929790e-02,5.7165560309575439e-02,-1.0268935645523132e-01,5.7093886919108175e-02,1.0408906807385054e-01,8.9792145035154258e-02,-1.9107853634985114e-01,-1.3975016651741872e-03,1.1106559654419826e-01,-1.1594367410410740e-01,6.2117722563247497e-02,-5.9431106119877286e-02,-2.3086338177406665e-01,5.3956227689465203e-02,-8.3472160711163826e-02,-8.5495947683764770e-02,-4.3405568719571297e-02,-1.8040830613176279e-01,-6.5417499105850027e-02,2.3285512416394080e-01,-2.5063686841369795e-02,2.3736327104649395e-02,1.5473699385555431e-01,-3.0180849915777680e-01,9.1877980727567671e-02,1.3045811662387324e-01,8.1529228255368472e-02,-2.3474247194463664e-02,1.1027855738327212e-01,3.3153350747493343e-03,5.7360456828259368e-02,6.3122773046774383e-02,-1.3591844791105534e-02,-1.7916354356650002e-01,2.7348858425417427e-01,-3.0493459814357865e-01,-2.4840648774959592e-01,-9.4931559275220914e-02,-1.0228086493548041e-01,2.1056382315937439e-01,1.6816638379960586e-01,7.5893293934607226e-02,-2.6680983984928641e-01,-9.3521078539307412e-02,-1.7872245787671842e-01,2.2770499801125523e-02,-5.5415225011359426e-02,5.7049495083750013e-02,-9.6822380916873313e-02,-1.2377509972065348e-01,-1.1643556773034615e-02,-1.9333585678119936e-01,-1.9206007951097892e-01,-4.0672114168682036e-02,1.2487461638162539e-01,3.5957033085331699e-02,2.3378842085025386e-01,3.2313610576308979e-02,3.6859492769413055e-02,-3.6601220258639829e-02,1.0169860803615878e-01,-2.8006208965326146e-01,1.7633674731918211e-01,1.5853103289210921e-01,2.3763654415856125e-01,-8.2315686718922865e-02,8.8945428084111933e-02,-2.8521036536070293e-01,-6.9739613611893084e-03,1.4153587454077496e-01,1.6540826841130135e-01,1.3690065734370113e-01,8.0707393704714914e-02,1.3126464404028418e-01,-1.2217827189870136e-02,1.6311381566053568e-02,-1.2598374285913982e-01,1.2989625316036085e-01,-1.0755011532957699e-01,1.7601664616193891e-01,-1.7928713507785535e-01,-3.6059846199717152e-02,-1.7489968023010768e-01,8.3054909086919926e-02,-8.2951582186805622e-02,-1.4663467278611250e-01,1.1939007481681076e-01,1.0651667495203117e-01,7.4791347165588551e-02,8.4601957806563349e-02,-1.5740178671609553e-01,-6.9129416126024898e-02,-8.1015635424379950e-02,3.8121593170632198e-02,9.0110400075565186e-02,2.4680275588296602e-01,-3.1235600671869629e-01,-2.2022040850538113e-01,-1.1370653084338027e-01,-7.5050159580271725e-02,-1.6465558016333201e-01,-1.9152168926823798e-01,-6.6575873162722038e-02,-3.9700934199345863e-03,2.9754872896170785e-02,7.6285948970406109e-02,-3.3914737396002731e-02,3.8253827152387843e-02,-1.4557942462639437e-01,1.7745544179048628e-01,-8.9796846303663622e-02,-5.8651979552520562e-03,-2.2663214758258984e-01,7.8945243729305448e-02,-3.4175723812896137e-02,4.5837914610032976e-02,1.5545841446437567e-01,1.5128466158281431e-01,1.0449259553498653e-01,1.4680411421785597e-01,5.2853262875494511e-01,7.7197550258255060e-02,1.1064563713599440e-01,-7.6150123378932066e-02,1.4625985942085487e-01,4.6649980039273356e-02,-2.0022004070192187e-01,4.7239384881145013e-02,3.8420003893459453e-02,1.1955553554488399e-01,1.5153471176434518e-02,5.5392266667394288e-02,-2.1180980121829965e-02,-1.4012496943471234e-01,2.2475268985605971e-02,5.5722573109734122e-02,2.5496592807332775e-02,-2.4036210348364975e-01,5.2250772189004938e-02,-5.3324754880619857e-02,2.0476193891932390e-01,3.6168190516729058e-03,3.0857176888025817e-01,1.9631850562880984e-02,-1.3987466172558605e-01,-1.6025239461767399e-01,5.8398603833421069e-02,-1.6327621313085938e-01,-2.2961487110016963e-02,1.4708695948330566e-01,-1.6455991024916530e-01,-1.6391547105407429e-02,1.6718932306134962e-01,6.1722638045247927e-02,-1.3045647121305112e-01,1.5097300230097740e-02,-5.1041034475541397e-02,1.6085705128735828e-01,-5.4610646373944083e-02,1.5633958224729788e-01,1.2767791012009055e-01,-5.8348117226355786e-02,1.6627095741208206e-01,7.2674800089899863e-02,1.5165980975729975e-03,7.1952212656598374e-02,1.2279500435773592e-01,2.1351306782984750e-02,1.0095701770702362e-02,-1.2444466474463067e-02,-1.8015161175193167e-01,3.1803956475421352e-01,-5.7205330204997414e-02,1.3027257644888710e-01,2.4858492008782704e-01,-2.4106917315866028e-01,-1.8665405780957257e-02,2.0428967760694645e-02,-1.9134310416702324e-01,-1.5773575032501932e-01,-1.3228215443846272e-01,-8.9351475232837874e-02,5.0132876614173254e-03,-1.9417029158063182e-01,-6.8793253412839969e-02,1.2228647509578575e-01,4.9146333214640715e-02,1.8259759607155326e-01,1.2874578474014170e-01,-1.5053682368222319e-02,1.0257856573379390e-01,2.0071432306870546e-01,-1.0271063122036485e-01,1.5847466640599422e-01,-3.4970129088360596e-01,-4.3065324734307242e-02,5.0631218049290078e-02,-4.7349541686295717e-02,9.8729863010048782e-02,-3.6041435671079151e-03,2.3641203618922899e-02,-1.9366277151421735e-01,9.3571724221792635e-02,-2.2124597971014539e-02,7.8619827453277891e-02,-1.3887545930622952e-01,1.8120097088222986e-01,5.9337086478594842e-02,1.5705919409532193e-01,4.9360981837194735e-02,3.3137257633089912e-01,1.5543939080744784e-01,-9.2303467899170530e-02,-3.2437044529259085e-01,7.8387063299477505e-02,-5.6271181280362258e-02,2.6826469579443324e-01,1.1446170818643656e-01,-3.0049598361041378e-02,1.0635975486613795e-01,-7.2446512664756310e-02,-3.6647940304453001e-02,1.3863833915758553e-01,2.5805333085032472e-01,-2.0361803024965406e-02,-9.5717317885726377e-02,2.0940016666382399e-01,9.2884306671534078e-02,3.3515989779393612e-01,1.3129017808337301e-01,4.7825482178174568e-02,-1.9028388003621949e-01,-1.2149591119915343e-01,8.2577965188130639e-02,-7.1394409622413155e-02,-3.0347640650613544e-02,5.5505053388569592e-02,-2.0776916381662200e-01,2.2535551275670102e-01,1.1110897517329367e-01,1.5920761952776766e-01,8.1834071732325153e-02,-2.5309617014976521e-01,-1.0763504194339513e-01,-7.5057261484619164e-02,1.0673790753091769e-01,-2.0087674039969694e-01,-5.9154637738328825e-02,1.7253757126387034e-01,4.2011151343400825e-02,3.6129783528279384e-02,-1.5296713546319497e-02,1.0555773435985563e-01,5.1709781504010947e-02,2.6152863392676820e-02,7.1271121814539026e-02,-2.1964093740772184e-01,1.7867421720208825e-02,1.5899538994988666e-01,-1.2381784588591736e-02,2.8262056160763181e-02,1.0860409487484134e-01,1.9553115775571958e-01,-6.4125400598184654e-02,-2.8041862031931057e-03,-1.1525752160782787e-01,-1.2569331739412801e-01,1.3150205326747824e-01,1.3471361859424263e-01,-6.2007567186724052e-02,1.4625018166312204e-01,8.0869504359797159e-02,-1.8915928781596861e-01,1.7954097924016743e-01,1.5379744225836720e-02,-2.6558083867578183e-02,-3.4555828509038161e-01,-5.1688165066978049e-02,2.5414866604203237e-02,-7.2606184070318769e-02,1.8993404747838361e-01,-1.7058665728124911e-01,-1.7143454872283673e-01,4.4059560382874050e-02,-5.8033630566905380e-02,-5.7141568186193120e-02,-3.6645629505231170e-01,-3.0700793009167260e-01,-2.5900670343020549e-01,-1.7227379921272035e-01,-1.8624353068934071e-01,7.0403246082324109e-02,-1.3195705992514964e-01,-8.9752720981161480e-02,-1.3893478965397177e-01,1.9375880845061758e-01,1.9261055578715540e-02,2.9785044872135426e-02,3.6671924508904420e-02,6.5794302826583065e-02,-9.0544803861415876e-02,-3.4413430299611317e-02,-5.6931898509311907e-02,-3.5856593117487422e-02,9.6827283885479204e-02,4.6267070097969723e-02,1.3301611547746706e-01,-9.3414910074006652e-02,1.2743007178832130e-01,1.5720373880479827e-01,-4.9660557367227014e-02,-3.4811649240415776e-01,-4.2552143887006851e-02,3.5705159386708755e-02,-8.0937220438091304e-02,-2.8754869831601060e-01,-4.9295671229997159e-02,-1.7235452017109881e-01,4.5092153054362719e-02,3.0503735149547864e-02,1.2412251072548507e-01,-7.0174656759007886e-02,-8.4162872024373170e-02,2.7089968121172363e-02,1.3688868045091340e-01,1.7796673070677207e-01,-8.8705107804762109e-02,-1.1997162071156789e-01,2.4421219518152015e-01,-1.2593138155812991e-01,1.2399100093256145e-01,-3.0980207273219741e-02,3.7443539351087504e-02,-6.1924551327405316e-03,-5.3461242662754503e-02,2.3747882224506181e-01,-3.3308541637325724e-02,1.2998609264494251e-01,8.6490634668179758e-02,2.1273911140164109e-02,3.5530538648199168e-02,1.2231779539247528e-02,3.5082031157196561e-02,1.0215685194777734e-01,5.7485758871136522e-02,5.1250642880225593e-02,-6.0379557171588709e-02,2.4695158001225581e-01,3.6422476939067250e-01,-6.4605048837005166e-04,1.2488822533626075e-01,-1.1772625646591145e-01,-1.4321693071973621e-01,3.9172578233126581e-01,-8.7941257529822597e-02,-1.4233979704225200e-01,-9.0851300123054257e-02,4.6565633315899090e-03,9.9809266424335227e-02,7.7828783469517646e-02,-1.0071038722663451e-02,7.7680574627526722e-03,1.1053615388101323e-01,-2.0243040708552085e-01,4.3391018135090033e-02,-9.6040391022362403e-03,4.7438179354509023e-02,2.4269809484218702e-01,-2.7596009288682940e-02,1.8074293561904919e-01,1.3986847667575203e-01,7.5977853229902623e-02,-1.3184025405983868e-01,2.9473204494380421e-02,-1.5434085672302350e-01,2.4836449673560891e-02,-1.8304085026844738e-01,1.3728422358387404e-01,2.2485931258889316e-01,-1.2752220525918670e-01,-6.0357548820333035e-02,6.2805779350089436e-02,1.7049854182391749e-01,-1.3959418475821728e-01,-1.8028145805358969e-02,9.9892545461237200e-02,3.5744371221419421e-02,1.5544111991162610e-01,-6.7566103323619994e-02,2.2591248107696554e-01,-7.9815736587655201e-03,1.7401011782644854e-01,2.0050096823586011e-01,8.5081031476096414e-02,8.7126371903252217e-02,-2.0025337902278392e-01,-2.0548986234081684e-01,-1.2888520080621033e-01,-2.9355878379633077e-02,-1.4882029783367570e-01,1.0905645921499516e-01,-1.2104117226093351e-01,-1.0826187691612697e-02,1.8421305636439411e-02,2.4012410249955796e-01,2.1102150670850961e-01,2.5338235539931148e-01,-1.4985305075141608e-01,6.3963424127960786e-02,-2.0281528769120694e-01,-2.1703076237201485e-01,7.2986052562138609e-02,2.5111925563774874e-02,6.7366145922306803e-02,-8.3192556426930783e-02,2.2606326646246719e-01,3.4535959118217452e-01,1.5306338678488815e-02,1.8496290313344915e-01,-1.8925885724289099e-01,6.4078437502418109e-02,4.9452989286886552e-02,2.3690344347629840e-02,-1.5875138802328800e-01,-1.3415253249234056e-02,-7.0071193556870193e-02,1.4147294559363869e-02,-1.5439021489379101e-01,1.7349872515818621e-01,-4.6445096496179200e-02,1.2389912638410237e-01,1.3766463811597879e-01,1.8454296570755530e-01,5.0992374105661195e-02,-1.1435159498693918e-01,1.5144063450885945e-01,3.7839633613563566e-02,1.3485338196220356e-01,-2.4315853548003055e-01,3.2350883472055181e-01,-1.3025320130134624e-01,1.3512943833841479e-01,-2.5222628281016080e-01,-1.8200299254031268e-02,3.7003579535244822e-02,1.8654719468875389e-01,1.6536213607066597e-01,-1.5938438406626476e-01,1.4441193719438175e-02,1.7808266855821228e-01,-7.3634068699709565e-02,-1.7998752509992996e-01,-1.4110667052002662e-01,-2.6258354898522449e-02,-2.2833449909152614e-01,7.8324896664781249e-02,-4.0940416621254548e-02,6.4276073357201008e-02,-6.5281741844087290e-02,6.6867674571648883e-02,-8.1397405606258397e-02,1.8157691222947381e-01,1.6835336556292552e-01,1.4481170827286738e-03,-1.9874916955112421e-01,-2.0697206477895891e-01,2.9601512223321652e-01,-2.1633946526735862e-01,1.1508039189030501e-01,-1.4610975553508918e-01,1.6231459652919927e-02,-8.0096656518814785e-02,-3.5909600933467713e-02,-1.6537031823451376e-01,6.6486463593293757e-02,1.8591760213959482e-01,5.1649137943095266e-02,1.7847391337644400e-01,-2.5452302535357959e-02,6.7418368753988586e-02,1.2704391681580482e-01,-4.1262507762104342e-03,-2.0916671369505369e-01,2.2159969356230938e-01,7.6407833132383904e-02,4.8591678519076489e-02,1.1918988099613054e-02,3.4846556581874549e-02,2.4094658085132054e-01,-5.8288537222711385e-02,-1.6627506265386674e-01,1.9627605320047853e-01,1.7463219969641527e-01,4.2504305415403038e-02,-1.8935954693849208e-01,-1.7724104768915958e-01,-9.2845210101561770e-02,-1.0273645008261779e-01,6.6133727825812894e-02,2.3739247646658652e-04,9.4376839739936561e-02,1.8662379665924120e-01,-2.7553894934761214e-01,-1.8492790914665425e-01,-2.1864504893016126e-02,7.8776524481294394e-02,1.7462153159366869e-01,1.0591165649453917e-01,3.6369004426505119e-02,-1.8558019903208132e-02,-8.8167157642092108e-03,-4.8115301754242487e-02,-1.2610314027093578e-02,7.2789359947310235e-03,-4.9264766140873828e-02,-5.9386073807690384e-02,2.1383049878265024e-02,-1.2074457387424209e-01,1.4916051287824101e-02,2.3612403501130913e-01,-9.1339162843837498e-03,1.1469079385893757e-01,-1.7610840562525287e-01,3.2248063655428161e-01,-1.7883150381506705e-02,-8.7826595858443657e-02,-1.3859820201273626e-01,8.8319475671803926e-02,5.3367988146472846e-02,3.8412548791130408e-01,2.9956821799548039e-01,1.6373365412380789e-01,1.6525634426047062e-01,-4.7248920455391377e-02,1.7598873587612973e-01,8.5042164956238731e-02,1.5019101137918608e-01,1.6652512873938092e-03,-1.0186076969547650e-01,-8.7894470623320342e-02,-1.7139667639300232e-01,5.5887067061548418e-03,-1.9045163844804164e-01,-2.1326913600327686e-02,1.6400887570909684e-02,-2.0730153012750147e-01,2.3223585416799439e-01,6.3859682506252027e-02,3.7342043391779794e-02,-1.5342268773849554e-01,-1.9979641952782880e-02,-1.1293825241980512e-02,-8.1783950441643716e-02,-1.3249393473009916e-01,1.0256899988121329e-01,-4.6090686426349323e-02,-1.5682538801514423e-01,2.3408453865414430e-01,-9.2982938021824502e-02,-1.9383675143749365e-01,8.0710556716026130e-02,-5.8193871279570486e-02,2.9655115944524818e-01,-2.0273754898242946e-01,8.6271624538372574e-02,1.3993572479586402e-01,-8.7645390241173182e-02,-1.0608013267679121e-01,-6.3934121568300001e-02,-2.1452367056522897e-02,1.0671629425074472e-01,5.9630447099237607e-02,1.7956428700060739e-01,-1.3355722157086577e-02,-2.3474466895061619e-01,-8.4714256003732447e-02,-7.0302942589109865e-02,-1.9505945593565885e-01,1.2518316727786627e-01,1.8455602998255369e-02,4.9238575970569715e-02,1.5954983945088763e-01,-1.5987087233832348e-01,-2.0739429429906012e-01,1.4740560717426460e-01,1.1465204794596728e-02,1.2273669531975151e-01,-9.6120223700692439e-02,8.0102739104843251e-03,1.6304258928637520e-02,-1.0635607712452806e-01,7.2564908182565502e-03,4.8181181983450470e-02,-1.9687640086279046e-01,6.2222440789352081e-02,-7.2315934667005935e-02,-1.5922106377686707e-01,-7.1752434851741681e-02,-4.4593419093701785e-02,-2.2640075930473961e-04,5.3516551395858772e-02,7.8981151994462900e-02,-1.1759436502479911e-01,-6.9453394606867813e-03,-3.6099274351941535e-01,-3.5458746524401508e-01,1.0782085026741521e-01,-9.0577889371042219e-02,2.0859161008905341e-01,-9.6943784731863852e-02,2.4426619710769834e-01,9.3565169071827645e-02,4.1665882041661037e-02,1.0372891077617628e-01,4.9106777810424607e-02,-3.0038871628157562e-02,1.0572569916830921e-01,-1.3170736453451251e-01,1.5441626396183583e-01,1.9845868002959033e-01,3.7233600298579124e-03,-7.1731098438944638e-02,7.4324509578293591e-02,1.1763702321154287e-01,2.5141323710014943e-02,1.0411055379697077e-02,1.6469983592034501e-01,-3.1704290850387273e-01,-1.8100634564085061e-01,-2.3576962185743902e-01,-3.9037775842944787e-02,-5.0951483363154630e-02,1.7404743245786872e-01,-7.6220398428597708e-02,7.9922240554301208e-02,-2.9522918241440344e-03,-1.5625767900603782e-01,-1.8972515775193077e-01,-1.4795795556858871e-01,-9.6693114115755791e-02,-2.0316757081271583e-01,1.1008995207968419e-01,1.2526363466951251e-02,1.3252314891898051e-01,1.7696126579411303e-01,-1.8743875337249835e-01,-3.5005007354630252e-01,-4.6863135623523185e-02,-4.6737651894972324e-02,1.9754303459454767e-01,2.8056355942474148e-01,-6.6299969812217599e-02,9.1413886617510473e-02,-3.1482108610101457e-02,4.7965257930674500e-02,8.9435094572529253e-02,-1.7513887252261265e-01,2.4538957762684482e-01,-1.1559854000823076e-03,-4.3417138784041798e-02,7.1527368778289510e-02,1.1301190144115465e-01,-2.0938150198024824e-01,1.8186597607505059e-01,-1.0463289659264062e-01,1.2832096737135093e-01,-1.6291808690691915e-02,2.5051472393868951e-01,-2.4163628777434960e-02,6.8983862933009718e-02,-4.2235744476120135e-02,7.1709780518486699e-02,-2.8076045271748399e-02,9.1214841711057676e-05,-1.6683957999190373e-03,2.2825817339371536e-02,-1.5708595096229780e-01,-9.9616460889643418e-02,-1.2271303772861722e-01,-3.1019133211213752e-02,1.8621619549437674e-01,-3.4554227193773029e-01,-2.0965106684309182e-01,3.8256688344539075e-02,1.9220212617118762e-01,-5.4216172491824983e-02,1.0612575616300493e-01,2.8381150377155778e-01,2.0820435621343232e-02,-4.8710568071722346e-02,-7.2237594953206724e-02,2.1225109194596475e-03,1.1887956303619163e-01,-2.7851476256665036e-01,7.5418814670163217e-02,1.9955363006440749e-01,-1.8728211707530146e-01,-1.1735683119958380e-02,1.7749288326352611e-01,-6.6200568403400287e-02,3.7871076309095794e-02,-1.4059691251334760e-01,6.1467771737071198e-03,4.4773980688800098e-02,-1.8508458889276710e-01,1.0418025619775090e-01,5.6473697827825776e-02,1.5700853128788109e-01,-9.5109866526160936e-02,-3.1202149351530484e-01,7.4498534665403834e-02,6.3955359773362946e-02,1.7105098410635039e-02,-7.5490246379302489e-02,-1.5389016081607079e-01,1.9620552905194572e-02,1.4806302339843759e-02,-1.0445567001677745e-01,-2.6729069220643475e-01,-3.3346546820880826e-02,7.4102544133200929e-02,-9.8838155488071233e-02,5.0900837445812600e-04,-7.4118477764332849e-02,5.7787456498960645e-02,-2.8239437387091287e-01,-2.9438976924704224e-01,-1.6855494025978589e-02,4.7561259963888131e-02,-2.3051278440903028e-01,-1.3140785213215178e-01,-2.0956148685876949e-01,2.4025006694075252e-01,-6.7455937218206512e-03,-1.2036732378951816e-01,-1.0971888180281898e-01,1.1047494460125538e-01,-2.3235113577564309e-01,2.5991733513847137e-01,-4.2709736965266767e-02,-1.1427631054612530e-02,-2.4887039123922972e-01,4.9022205124508835e-03,1.2328952074143999e-02,8.2946493401455282e-02,-1.0804908390972761e-02,1.1925652129777148e-01,-3.9161959046993849e-02,-1.5458787591160685e-02,-1.9476512194578188e-02,6.3338278567706713e-02,-1.5542679155086447e-01,-4.2011853343247080e-01,-9.5469116249040670e-02,1.9532452511906440e-03,1.5509582302698369e-01,-9.8679045260816986e-02,6.3231407714646956e-02,-2.3535384895538053e-02,-6.9084979514223169e-02,1.1139951046214512e-01,-2.8599426795886760e-03,1.0448161390687383e-01,7.9042969095651491e-02,8.1908984324735118e-02,-6.0228601406179229e-02,-1.0843193519213462e-01,8.1936830140920264e-02,1.0186658939666043e-01,6.7459618521580861e-02,5.8472420861642130e-02,1.2358356180718931e-01,-1.0943395736546857e-01,-2.2279292180275920e-01,6.6904744076244516e-03,8.3872898108118724e-02,1.7878884103247580e-01,-1.4517099112598977e-01,4.3537274022429173e-01,1.2386596066912886e-01,-1.4265547017137800e-01,-2.7648714586933326e-01,-8.9664770054891416e-02,-5.9372285961679587e-02,-2.8564167752666952e-01,7.5265639146654489e-02,-1.1433429505769677e-01,4.8667116150180545e-02,3.1524797343622596e-02,-7.2804187772824540e-03,-8.4210411394112325e-02,-1.5388492619550878e-01,5.5102716316002547e-02,2.9359951083746560e-02,6.4262914791263656e-02,8.9676834310118594e-02,1.3118881412468977e-01,-7.9814578827132249e-02,-1.0825013087242942e-01,-7.7482089324341585e-02,1.2263544155800954e-01,5.5201692088081122e-02,5.5706848469971301e-02,-2.3105707154373539e-01,1.5017522686457638e-01,-2.2874639677666925e-01,6.2072422321741920e-02,3.3260291894949412e-01,-9.0546180669582116e-02,-1.0877606873376067e-01,9.7796889820295607e-02,2.2046523216510566e-01,2.7310933610823235e-01,1.9129482802417186e-01,-1.4123238097639038e-01,6.5974540742974014e-02,3.7486957169469121e-02,1.7575457440745518e-01,-9.8522565075773796e-03,2.5984438278890509e-01,-1.1892103844300318e-01,-3.6435244169797362e-02,-1.9809926121706634e-01,1.5408082804154979e-02,-1.2157255213436471e-01,3.0204796693929097e-02,1.6263498484348368e-02,-4.4331588242423732e-02,9.4755804323834375e-02,1.0853693669334831e-01,1.8921568743445066e-02,-4.3282980559003967e-03,1.9547335812772465e-01,5.1851317002144882e-02,1.5239075066606772e-01,8.4184630923358608e-02,-7.7208146568519417e-02,7.6717567921823875e-03,2.8314327202148193e-01,2.8920296472342649e-02,3.1448158887462496e-02,8.8362051183391715e-04,3.7472137099721171e-02,-4.5442604636928667e-03,-9.5859568742477669e-02,1.0937498878378621e-01,-1.0121201962626163e-01,2.3796764797843822e-01,-4.1853935442801160e-01,-9.8655108718423631e-02,-2.5953572945316160e-02,-4.4204803813350756e-02,-4.1374254069254018e-02,2.4385301798117709e-01,-1.7251860996990376e-01,1.6358356490967230e-03,-2.4855927662517263e-02,3.6167409236785970e-02,-1.9475906061404678e-02,3.0328370138761718e-01,2.3600197566011435e-02,2.4952533451058428e-01,-2.6893073879660151e-01,-1.3662016649618858e-01,1.1519654152526776e-01,5.8816278544929254e-02,-3.0283871072330987e-01,-4.0112680681910227e-02,2.3973336371065995e-01,1.8260003871176714e-01,-9.4214121122022057e-02,2.3001567257330882e-01,2.9804804853239153e-01,7.7864621968951608e-02,9.7712258082888900e-02,-6.9600577516150022e-02,-1.1774320084288595e-01,-6.4971232106176002e-02,5.7820889671672038e-02,5.0656923990833116e-02,-1.4249989833467255e-01,9.5517151582109786e-02,3.2623782858320141e-03,7.3266288500341170e-02,-2.3417529555499969e-01,2.2049648305171640e-02,1.4442798892590206e-01,1.3218129991181246e-01,-9.6433582489102478e-03,-1.5251210688464426e-02,-1.5117437836680422e-01,1.8950902685085050e-02,-3.4809950928832330e-03,-5.0271094557947128e-02,-1.2513332144743514e-01,-8.9635056444666072e-02,-4.1991066756798395e-02,1.7489536894822008e-01,1.5636493674951076e-02,4.4070783645792679e-02,1.3933477253842474e-01,1.7277610918965078e-01,-2.5219426348453367e-01,8.9775005964890700e-02,-7.3978302342143407e-02,1.3096046955942270e-01,1.6256925671108566e-01,9.4096183290496266e-02,-5.2062297582645058e-02,2.2436079191602848e-01,-7.8510050504250015e-02,2.2212746899110231e-01,6.6454463743853720e-02,-7.5666956673891644e-02,1.9241431108057139e-01,-4.9605671526860073e-02,-7.7830643987106762e-02,1.7983681730433423e-02,1.2033707410372467e-01,-3.3736133419213221e-01,-5.8711695980254372e-02,1.4489864356851440e-01,-1.5536448331732367e-01,-2.5714439457982580e-01,6.7397048844787713e-02,5.2526061279980926e-02,4.9606898662496027e-02,1.9791001417348417e-01,6.3145806203710297e-02,1.5475583326845152e-01,7.1126008281615458e-02,1.1057082346523578e-01,6.4984763601298151e-02,-1.9989384169667518e-01,1.7992695095384934e-01,-8.3133516872572130e-02,1.7341289082389047e-01,-8.3597457480530504e-02,7.1425875111178383e-04,-6.4454676212832261e-03,-1.7796775799891973e-01,-2.2391505321309879e-01,5.5710647778780813e-02,-5.1518760330580310e-02,6.2504052496334062e-02,2.4715916841698299e-02,-1.2576036148795877e-01,4.1597474452225586e-02,1.4056887543163632e-01,1.1212123992422489e-01,1.5250570672546615e-01,-2.5034852947056435e-01,7.2892632293077853e-02,2.0787445339678831e-01,1.9805406076709919e-01,1.2263784875203133e-01,-6.4399618890290736e-02,-4.0882159461353956e-02,-1.0435790310131632e-01,1.4836051258549998e-01,2.5986333362569664e-01,6.8212144070673913e-02,-1.3250556978437794e-01,1.6756116881305164e-01,-1.8602647141313439e-01,-2.7702024054412411e-02,5.7161135916153419e-02,1.7436591779684801e-03,6.9641774358001424e-02,4.5965741113310990e-02,-2.1360165549380139e-01,-3.6184114380517760e-02,1.6103122995715158e-01,-1.6769115910397711e-01,2.2845771604453682e-01,-2.0323147541275596e-01,-1.0614403091271125e-01,1.9992496805875476e-02,1.8547593893114217e-01,-5.1557775335762168e-02,1.2792372987039213e-01,1.0486449123193509e-01,1.2479448782666562e-01,7.1585730761165173e-02,-2.8082914130255709e-02,-5.7424615205656698e-02,1.8206681013310322e-01,-1.3889866638361867e-01,-2.7232289194830138e-02,-2.0767874044287718e-01,-1.8136875558155741e-01,9.7335237833398286e-02,9.4791915772440852e-02,4.0518943769103651e-02,2.2586462777129412e-01,1.0977110754200967e-01,-1.4478422248523989e-01,-1.6426209233156375e-01,2.7619879879930302e-02,-3.4735671906466886e-01,-1.2112347029201341e-01,-1.5785386473704997e-02,2.0485753335999041e-01,-2.8678561297483550e-02,1.0361262607028240e-01,-2.5870223483057725e-01,5.8166572190771496e-02,-8.0064694263477523e-02,2.1713008709485920e-01,1.5109525871598856e-01,-1.0896875144043154e-01,1.4570170462629750e-01,3.3662531897551071e-02,2.8825290024858713e-01,9.6194304888211513e-02,-1.0683609117963171e-01,-5.5173644531602166e-02,-8.1485777073711796e-03,-1.4887324651490436e-01,-3.9697628349699400e-02,-8.5226147264873264e-02,1.0204923575414001e-02,-7.6882514065693838e-02,1.4907137263277859e-01,1.4152882557455590e-01,-2.3528361131978540e-01,-1.9513919697066784e-02,-1.4879253493400860e-01,1.6645294430988355e-01,1.5117651687571990e-01,-1.7359719988583702e-01,2.9261813057416525e-01,-9.9498892676970332e-02,4.7611588447331557e-02,5.6980268982685200e-04,-3.6811129165526119e-02,-2.9417290502769056e-01,-8.3473101113129708e-02,1.3461518992054913e-01,1.8026093932158185e-01,6.0134488923536109e-02,2.2661843455113492e-01,1.5143734808426029e-01,-2.9651220563373082e-03,2.8844117725842827e-01,1.5562161898386804e-02,2.5633898591327489e-02,8.5568560089728570e-03,2.5027588685026114e-01,4.0056300246933220e-02,-1.1034474562912400e-01,1.0090902056769883e-01,-2.1179814030514315e-02,-1.5319787743065992e-02,-6.0944924983850637e-02,1.6017546672579183e-01,1.0697175422480849e-01,-9.9131256860247416e-02,-1.9992400757584075e-01,-8.9443632146814833e-02,2.0414872191744685e-01,-2.6215139375469841e-02,1.5567259519746790e-01,-6.6946121129657393e-02,-1.6291870406437609e-01,2.3722866925244768e-01,-1.7128881811214899e-01,6.0636236077637410e-03,-8.5470921666183294e-02,2.9309569598242368e-03,-1.1180557524944393e-01,2.3093167211236634e-01,-1.1874891671551830e-02,1.9321592816848884e-01,4.3368175468570830e-01,3.0676465929203073e-01,9.6194066634320841e-02,6.8485127657048533e-02,1.7669586581620389e-01,-1.1412058043100290e-02,1.3624756977719762e-01,-1.3049638417445197e-01,1.1262108063128121e-01,-6.5424847429597352e-02,6.7659771472766667e-02,-1.6495177540988851e-01,2.1571411854955192e-02,2.1318054319024438e-02,-6.8239451715562519e-02,1.0849823899827733e-01,4.8537384924855036e-02,-8.5653221496888837e-02,1.4777041651363934e-01,1.6743393289490452e-01,7.6525080511476648e-02,-4.6810111851188663e-02,-1.6460557275898613e-01,2.3447100184859335e-02,2.5917750642541773e-02,1.8664077093243708e-01,-1.8642547963806577e-01,5.5201770431999635e-02,-9.9731482175948946e-02,-2.8252266960946193e-01,-1.4848230869332993e-01,-8.0276946572394384e-04,-1.2909518267216560e-01,-1.2148449240430499e-01,-5.5295730934997768e-04,4.1965519095067801e-02,-7.1066796870307175e-02,-4.5555472579181688e-02,-1.5867949515232876e-01,7.4205978752247947e-03,-1.7627644025514419e-01,1.6369645641921601e-01,2.1860447941983244e-01,-1.6833233343781598e-01,-8.6169825125959207e-02,4.0304564256130354e-02,5.2616459708748238e-02,2.3080892986650538e-02,-1.8555381982926317e-01,6.1182095768186444e-03,-3.9434324360197393e-02,-1.1079823614185019e-01,1.3363074610483947e-01,-1.0719920451911977e-01,1.4605629580790680e-01,5.5971264791360074e-02,9.2712325733681246e-03,-4.8668172306028296e-02,-1.2793239239157148e-01,-1.4977957848211604e-01,-7.7555461789235433e-02,4.7777004883923987e-02,1.6293871466558685e-01,1.8698438657861645e-02,-5.2337993302845588e-02,-2.8550616785750854e-01,-6.8050154417653455e-02,-7.8953205542753785e-02,-9.1026650046242732e-02,1.1908673973903132e-01,9.1239419952265241e-02,3.8278563378394456e-02,-1.5185327868623821e-01,1.6043160611048893e-01,-1.5233138357451892e-01,3.2463228317600329e-01,-2.6736110773302690e-01,1.9162672247561985e-01,-5.4257939274011763e-02,2.1519792878681454e-01,2.0790191433367927e-01,1.0658120027853399e-01,3.1085153317247716e-01,-1.1772649129680379e-01,-8.9385108754883955e-03,-1.2493035929610626e-01,6.9301873114047646e-02,-4.0621075502259657e-02,-9.4890029985737701e-02,-9.2307501368316197e-02,-1.9421723559302292e-01,-1.8227558659603224e-01,-3.2666133762817948e-02,-7.6331672382706411e-02,-1.4654027643206022e-01,-2.2771711444300974e-01,-9.2418730711752217e-02,1.9314951731236951e-01,1.3962554356778917e-01,7.9874960921460611e-02,-7.8217638287753299e-02,-1.5122601895145199e-01,8.3095221708073846e-02,-2.2965148383551529e-02,1.4567256157387884e-01,2.8904743857971191e-02,7.1781531339574087e-02,-1.9424352593276739e-01,-2.5458177861436310e-02,-7.9439466373912825e-03,5.7523770088663785e-03,2.1864848033252993e-02,-2.9394482450076020e-01,2.4717706254005228e-01,-1.6780790193324469e-01,-9.1280578865730433e-02,-5.3185543419770789e-02,-7.6360364597341922e-03,8.6854998930611188e-02,-5.1416640959601703e-02,-1.8206784617472348e-02,-2.9891822180800920e-01,-8.1195928479660812e-03,-3.3401520905896820e-01,-2.3527689922315481e-01,-1.4446722228475845e-01,-7.3548477304120605e-02,-2.3450312291254834e-03,-2.2026696673598897e-02,2.6960270339899600e-01,-5.8314137921772022e-02,1.1696113756506092e-01,-1.8841882734124851e-01,-5.8480050439903647e-02,-1.0319890641498142e-01,1.3962280061150667e-01,1.2654373988552800e-01,-6.0761414129007971e-02,-8.4297362673802112e-02,-5.7340181048513086e-02,1.4014822249502187e-01,-6.3508553585200328e-02,2.5079797928145775e-01,-8.0725873569677628e-02,9.5832668383628306e-03,3.0284047936050780e-02,-2.9191279479749471e-01,-2.0302498472847531e-02,7.8241232268206798e-02,6.4020887683224767e-02,2.4387647212313096e-01,2.1838657302003475e-01,-2.6429758157759969e-01,-8.2813924093056490e-02,-1.1855608232322876e-01,7.1410044667799322e-02,9.0834674033474949e-02,6.7275869889084662e-03,-1.7756868935659743e-02,-2.6310118235756558e-01,-7.4846203657709054e-02,1.5437738828980310e-01,-1.2356807904193992e-01,-5.3258202839146930e-02,1.0213040719841870e-01,2.3279399336820183e-01,-1.4922289012663192e-01,-1.9631458929924442e-01,1.3704929461255438e-01,-1.0512614579826776e-01,4.7771035901008972e-02,1.8542755267116151e-01,1.7518267050068492e-01,-9.2643913045183449e-02,-2.5776218492802477e-01,6.1550622607171555e-03,1.0542477328017896e-01,2.2551593825811786e-01,7.5605565801408883e-02,1.0669309611768801e-01,2.9157517851431593e-02,1.4589925774490192e-01,-2.2720037460012346e-03,-5.9188754425726173e-02,2.1253484070680567e-01,-1.3369768631781040e-01,4.6001659442290774e-02,-1.4913739935054135e-01,-1.9839429332314656e-01,-2.9581246583892917e-01,-1.3165949135908381e-01,-1.4381024492875891e-01,-5.4338034790392337e-03,-4.0978037175663957e-02,6.9213252600656583e-02,6.6328764720050889e-03,2.4034120757498147e-02,1.8205898619251432e-01,-1.7576192845512678e-01,6.2400053059613790e-02,4.5874284800167739e-02,-1.6612043643320162e-01,3.4750794581524976e-02,7.6252303588822887e-02,1.0853853170378848e-01,-1.5349136446255102e-01,-2.7479002124695512e-01,2.0551357275022192e-01,5.2526555653712947e-02,1.0758680032239636e-01,4.1752145444715139e-01,7.1857710710738487e-02,-6.9544022805090477e-02,8.3133664176231734e-02,3.6894799990334647e-02,-1.2328407708538723e-01,-4.3364787379644505e-02,4.0935706303221207e-02,1.5639382244118480e-01,-8.4077417124000728e-02,-2.0766537291293241e-02,4.1027505892152261e-01,2.6428484410877227e-02,-5.6037847342845719e-02,-1.4536009698812083e-01,1.7912214720712222e-01,1.3167603585243590e-01,4.0890881349946305e-02,2.7497253973866501e-02,-1.7320592000924739e-01,-3.7024126820718012e-02,-3.6748097015633516e-02,-6.2308130938456920e-02,8.0446580952081875e-02,-1.2320211499008334e-02,5.8245549620865224e-03,-4.4330830325628887e-02,-8.1166290705599900e-02,-1.0303909481654304e-01,2.9594140010654024e-02,-2.0262716577859027e-01,5.1401902698106634e-02,-1.5583212051014018e-02,6.6178123567209257e-02,3.0214991944328116e-02,-5.1916883389719178e-02,1.0545973667212447e-01,-2.2117041610265500e-01,-1.0169702676315096e-01,2.0194711515513419e-01,-1.7964897561513932e-01,-1.3189317411406934e-01,2.4046974191017881e-01,-3.8068601765507040e-02,-6.4027695726226894e-02,2.1221878246380985e-03,7.9489440867143588e-02,1.3028665530013683e-01,9.1951336443373607e-03,-4.3949963802233061e-01,-1.4995195379392323e-01,-2.2249149173990987e-01,-7.1706921329729542e-02,1.4457321193002770e-01,8.5656694738919695e-02,1.3569841734605789e-01,-2.0889991388736515e-01,-1.0909044094321989e-01,1.9451143544899352e-01,-6.3684442201171795e-02,-1.4105744404227688e-01,1.2557730444222950e-01,-5.1322358639563685e-02,9.8818724914626725e-03,2.0269845369019598e-01,-1.4592120015038576e-01,-3.4511545896105458e-02,8.9280086107124942e-02,-6.1136390344677799e-02,-1.6300091741312212e-01,5.2002718447320906e-02,1.0377323496150036e-01,-2.0605843745671072e-02,1.3780053922843410e-01,1.4046977516258030e-01,2.7359031478166429e-01,-1.7586147165897584e-02,-1.5339236630899325e-01,-1.8932906214683368e-02,8.9661411553572060e-02,1.4979424467182009e-01,2.1063172008080330e-01,1.2356519311109757e-01,1.5411368836980280e-02,-4.5619297752726734e-01,-1.6320419068759426e-01,4.1790800943794115e-02,1.5835136270530344e-04,1.0891389770390419e-01,-5.8854179759280350e-03,2.3583579706272562e-02,-3.9547760065120653e-03,-9.6902471367428245e-02,8.6876238954335536e-02,1.7017442101409472e-01,-1.5818862121965642e-02,4.6536699462700905e-04,1.0184461611976141e-01,-5.2427310708394841e-03,3.2010923073235142e-01,6.5175238804401668e-03,1.8726728274146825e-02,-8.5527030641698726e-02,6.0358396370063044e-02,-1.7167461459841213e-01,3.0941654155088115e-02,-1.5694868948152207e-01,-5.0569673023565138e-02,9.9530414055619881e-02,-8.8121048316191400e-02,-1.0162371110852068e-01,-9.6018021272453929e-02,-9.3718537164186724e-02,3.3581882598133317e-01,-4.3858067044732101e-02,2.0723550141500516e-02,8.0455492200905435e-02,-1.9275112816578302e-02,1.6339353767301185e-01,-8.5724981740716466e-02,7.9955256914051406e-02,1.1987020148370095e-01,3.5284678348177646e-02,3.0394950518031355e-01,2.6665473938750217e-01,1.1401223428709691e-01,9.1088464877591008e-02,9.7310180402362390e-02,-1.2188913791364854e-01,3.2591031078014067e-02,2.0334882382790706e-01,8.9542281980899363e-02,2.0223714123965872e-01,-3.5506102509457356e-02,-2.2045107751744560e-02,1.9199053979237882e-01,2.8134320988059364e-01,8.6550744409861408e-02,-2.0332313704598945e-01,-1.9358397769954239e-02,6.2754849548465122e-02,1.8936726456552623e-02,7.2168156849908086e-03,6.4646451283825040e-02,-3.2797934656124704e-02,-1.4639378296839622e-01,9.4390947930478877e-02,-1.0699965757457265e-01,1.7454887937412175e-01,1.5934920553367876e-01,1.9553346542851929e-02,-2.7455424314668064e-01,-1.1276222221954608e-01,2.7348647952990851e-01,9.1951927943541720e-02,2.6892158715584282e-02,-8.5007689289947452e-02,-3.6096484629189733e-02,-1.3736225643957428e-01,-1.4436072261002339e-01,1.6149083446247794e-01,-8.9214545261367059e-02,9.6835899251160484e-02,-6.0292883094782528e-02,6.1437856529003368e-02,-1.7933217956786129e-03,1.8272610730432107e-01,2.9038308555910958e-01,1.0068736154869376e-02,-1.0819479808585216e-02,4.9838717877280170e-02,-2.1035639765297195e-01,-8.9418319288067788e-03,-3.0802133164770318e-01,2.8966079941038225e-02,1.9356360211186302e-01,2.0169155326858906e-01,-1.7493348438148060e-01,1.1333515955097620e-01,-8.3284999259242459e-02,-1.9167038744179946e-01,-8.1288585045010839e-02,5.4040490487887866e-02,-9.9864914559360571e-02,1.5481824383492054e-01,-2.5553564409187175e-02,3.4164076267610449e-02,-5.6901134250091148e-02,1.2388711816464421e-01,-6.9896263518111595e-02,5.5027566697189972e-02,-1.8669289845524231e-01,-9.5984401555682261e-02,-7.2445539215742635e-02,5.6889892014261312e-02,1.1403842883550207e-01,-1.0435682587626405e-01,-2.5476760088944317e-01,8.0667332578612888e-02,-1.0413886650726139e-02,1.5156088429555074e-03,-2.6554061679673729e-01,7.1806810742458330e-02,-2.3304037149199229e-02,6.9881683590450119e-02,2.2425735180916928e-01,-2.8984341968349403e-01,1.8558626927749702e-01,1.0487374974991384e-01,-1.3752626211885385e-01,-1.5742400575245716e-01,-1.1866659357801697e-01,8.9083456925416846e-02,3.4958462616196240e-01,-4.6879308635473030e-02,1.0404309046866445e-01,9.7472260735312604e-03,-2.3602479624685452e-02,3.4181641633175996e-01,-1.8959629297172558e-03,-1.2720634600095562e-02,-3.0056942213235280e-02,-2.7643099163190028e-02,-1.9644935478815717e-01,-2.3854323274379644e-01,-1.0852039008868389e-01,-6.8860041604595496e-02,-6.9034087704084701e-02,-1.1133445388736009e-01,-1.7265579118319213e-01,5.1519553052368383e-02,-1.3458818108482420e-01,4.2416846300087165e-02,2.2316692696406731e-01,-3.3028180604090734e-01,-9.5964542014874647e-03,-1.3760314218871684e-02,1.6703373485453663e-01,4.0648042344342744e-02,-1.2536368999986447e-01,-1.1445196698124943e-01,1.4504731405330668e-01,9.2645842139265043e-03,-3.3897261620200886e-01,-1.7957146870777968e-01,1.5594493060131775e-01,1.5643510618951673e-01,-3.2499393105617988e-02,-2.1401904575380680e-02,-3.7954197682361877e-03,-7.1496867580250562e-02,-3.8764330418872991e-02,1.8992642727718190e-01,-5.0749531487859198e-02,2.2306572809763940e-02,-4.4806543444670856e-03,-5.5610776771281359e-02,4.1970240007665022e-01,1.3881004587377521e-01,1.7219595070455354e-01,6.7150418574722953e-02,1.6174110545056536e-01,6.5292506287619068e-02,6.3550474261665393e-02,-6.8659131094224612e-02,3.7371832558540943e-02,4.2185226772982962e-02,-2.6217022734170335e-02,-1.8716032151806528e-01,-1.0275121645877526e-01,2.0553608070418683e-01,-6.5545143288778057e-02,-1.4490114663562739e-01,-7.6993529917931319e-02,-8.4178090530105498e-02,1.9402899994146486e-01,9.5152019467583684e-02,-5.1908866095968162e-02,1.5648905433036420e-02,6.5976125087092038e-02,8.8110929826713744e-02,-4.1342345587967164e-02,-3.5532311387636954e-02,-8.3802554712361282e-02,-1.3219639353746321e-01,5.7014003422058812e-02,1.2209593118427240e-02,2.6062258432404933e-01,-3.6701345047059158e-01,-2.6817758082009113e-01,1.5203048506739317e-01,-1.3514753759525061e-01,1.2573557859567791e-01,-7.5873838196514137e-02,-7.5202319450763194e-02,-1.5236204070103004e-01,-5.5858607303589262e-02,-4.8665080014917900e-02,-1.2430496509081690e-01,-1.2726828443718313e-01,-1.3012588710606891e-02,1.9300145740319469e-01,1.6280797637790281e-01,-2.0612620834198053e-01,-5.8886114878302545e-02,1.2202909830709510e-01,-1.3156155274431439e-03,9.2326173777795159e-02,-7.8279721119430531e-02,-3.4537419873740038e-01,-6.4464631209727216e-02,-1.5425198031704487e-01,-1.0338084866070198e-01,4.1540057857523835e-02,3.6791187507942309e-02,-1.7725643670865754e-01,-9.9762124571198915e-02,2.3847054174687346e-01,-5.4098856764213030e-04,1.9506571931769104e-04,-7.9669929740035714e-02,1.5002114848637754e-01,-2.2786544254681620e-01,3.8413562991682068e-02,3.1479012571841533e-02,6.8041088892875259e-02,-2.5306539134810069e-01,2.3663947184686399e-01,-1.5409586349856080e-01,-8.0629990597405179e-02,3.2452903580185927e-01,-8.9882082167084723e-02,-1.9844354332138570e-01,-1.0977335553438272e-01,-4.9401943905752144e-02,-6.2744170486722498e-02,1.4474857002977837e-01,-2.8705415276426510e-01,-1.3250064447363452e-01,1.1926732643440270e-01,1.8881522379195625e-01,-1.6914164842166948e-01,1.0217338564609377e-01,-9.0519939744900454e-02,4.5473397327269086e-02,-1.5676012211247528e-01,1.5895805593198523e-01,-1.3290406406551813e-01,-1.6172988490997886e-01,4.5783604383732988e-02,2.1370841818574018e-01,2.5858214217025263e-02,1.5158571315656094e-01,8.0670915494718276e-02,3.5285477287772087e-02,2.7365159029403241e-01,-1.5642970468652362e-01,4.2380121951444368e-02,7.0830752151160359e-02,2.6438104539282348e-01,-6.1642591008170454e-02,-4.1094103221357758e-02,1.1535548847289408e-01,-3.3710608842352149e-02,-2.2722491923279892e-01,-1.0394640607910934e-02,-2.2038301028129581e-01,-1.2006316234565821e-01,1.7939465985452055e-02,5.7528639557106104e-02,-1.8890434057903201e-02,-1.1276212492488100e-01,6.3896582361183910e-02,9.5490029545241634e-02,7.8386013745171262e-02,-1.1216085910167135e-02,-5.2259631189781046e-02,-3.8636672120731998e-02,7.4951172399136505e-03,1.4789860927705623e-01,3.3709211762488783e-01,-1.4306647474645839e-01,5.6467001314546753e-02,-8.2835277883050035e-02,1.5730473408380333e-01,-1.8156203915154326e-01,2.9489764488366370e-03,-6.4987377778965516e-02,1.9031253764445771e-01,6.3236397638912992e-02,-7.1289435541247226e-02,-5.5766788838873524e-02,1.3870630095398160e-02,-1.4231902135213423e-01,9.5185689255379485e-02,5.4030302397290883e-02,8.4035013928977179e-02,-2.3031939451951619e-01,3.4528037607817624e-01,-1.1069135364975319e-01,1.8067353808609402e-01,2.2182344337423407e-01,2.4664989216918530e-02,1.2189772314049514e-01,6.1044014093347539e-02,-1.8062251596557904e-01,2.3528213973623363e-01,2.4726324780313867e-02,9.6198536163055876e-02,-2.7843616414462552e-01,-1.2569308228155119e-02,2.4274326751313538e-03,-6.8440565949292459e-02,1.1050341612643752e-01,-3.7881040275486999e-03,3.6527973729245725e-02,-1.9815564664328905e-01,7.3711389522454901e-03,-1.0212492281261511e-01,-3.0925515262623293e-01,1.1265228447707318e-01,9.4918731339711265e-02,9.4955356109519953e-02,-1.1429948291268259e-01,4.2771007904337965e-02,9.9618252867845369e-02,-4.8195044978391895e-02,2.3249218333535968e-02,1.8674906740900177e-01,-1.9019751047977501e-01,3.6857776905085585e-02,-1.7961166019615188e-01,3.7064843166609983e-02,1.4123184766055112e-02,-4.5167904856268135e-02,-2.4210246601406728e-02,-2.0941173674082054e-02,6.7524743489763197e-03,-3.7082729035872869e-02,-1.4870130796974518e-01,1.3281526763182991e-01,-2.4042119067170351e-01,-1.9644382421448403e-01,-2.4368774936620438e-01,-2.4748225131057486e-02,-1.7313721288095218e-02,3.7169591536630620e-01,2.4649966696477249e-01,-1.2831626417812925e-02,2.3854836440003850e-03,-1.2371967721326428e-01,-2.3023473711864975e-01,-3.9992708325199015e-02,2.4926985914701363e-01,9.2424587614561571e-02,-5.1066436893106346e-02,3.2272710534471227e-01,-1.8504328927226141e-01,-7.2325927515521832e-02,4.2985348033087352e-02,-5.3246439709726937e-02,-4.5931763425395428e-03,-1.9905252088917988e-01,-4.5647194281723934e-03,-5.6249078986295525e-02,1.2007232806435630e-01,5.5668874184649345e-02,1.0619068562435098e-01,1.6810391728891183e-01,-4.0196257190342116e-02,1.4253066112144039e-02,-6.2282263220625883e-03,1.5480437012748205e-02,2.0396177657325301e-01,-1.5779349701403805e-01,-1.9421215700397412e-02,-1.8121860604810608e-01,-6.1674092594230345e-02,3.9968606461316412e-02,-9.6527897226253129e-02,2.3666153673745204e-02,1.5952240611207177e-01,8.7983208040304739e-02,-2.1435938316882791e-01,8.2975378097382771e-02,9.5906687012890068e-02,-3.3074442681148564e-03,1.2141248488152691e-01,-8.1710224275617693e-02,1.6350373594436052e-01,1.7386294055142488e-02,9.4735043991453119e-02,2.3806158078928355e-01,-2.8862354905204574e-01,7.1014054877084121e-02,-1.3551242228922034e-01,1.7518491969914052e-01,1.2192071257030948e-01,-1.5013893799934419e-01,2.0224538858812763e-01,-8.3374806254162395e-02,-6.0552811158484099e-02,1.0042583492995455e-01,-1.2628319874658506e-01,6.5934811591415315e-02,-1.4178229303789830e-01,9.4111280766099745e-02,-1.1851476147060561e-01,2.2726282756751409e-01,-1.4099970763905284e-01,-1.6951268742275677e-02,-3.1197676696758214e-02,2.5772233415478940e-01,-1.2164423067795633e-02,-2.5199688665170472e-02,-2.2645423321096814e-01,1.3983329933925104e-01,-3.4788173154080193e-01,1.2042712605767125e-01,-4.2946021783063296e-02,-2.4043327540411455e-02,2.3703381380532557e-01,1.7546149834868346e-01,-1.6599016100135236e-01,-8.4225338811865821e-02,7.2570821574033120e-02,-3.8009404449099804e-03,-5.2945427568918561e-02,1.6317726684176239e-03,1.9945617653767103e-01,1.1189169903971423e-01,-4.8024536049493895e-02,3.0369769049160757e-02,7.7211330129366568e-02,-1.2110349778018289e-01,2.4002800422643567e-01,-7.0063274590651592e-02,-2.6445818127085102e-01,-7.8925705412107340e-03,-9.9145993965191317e-02,1.0391267765043950e-01,-2.2107619533043354e-01,1.1637161218201960e-02,9.0525724918592315e-02,1.5621303390624969e-01,1.0941080918205248e-01,6.2780850451718204e-02,-9.0502424245085707e-03,-1.7001899797848150e-01,-9.5091136916310409e-02,-7.5122320505678006e-03,1.2770887568370645e-01,7.5401652994898288e-02,5.3817795506442986e-02,-2.8453250884456777e-01,-1.3165480598982812e-01,-2.3947337307967397e-02,-8.6098516425647392e-02,6.1368643725220301e-02,1.5471147693596823e-01,-2.9233097945405928e-01,6.4754508751926745e-02,-4.4157007406651759e-02,-5.8597855492418846e-02,-1.6165457593034564e-02,8.6452237068373530e-02,3.5699947106292168e-01,-2.2823750143020238e-02,-7.9082122291765672e-02,-1.7648599913333651e-01,-1.6716427867694814e-01,9.4030742402991294e-02,-1.3016727142647688e-01,-3.7080886890881515e-01,-1.0816425285996531e-01,3.6430678617143726e-02,3.1801993689539447e-02,8.1743573676835435e-02,-1.3072671153572937e-01,5.0918316216229761e-02,2.6909806422253268e-01,4.4339517607282004e-02,1.4679202142411812e-01,-1.4250628852220479e-01,-9.6987188839431152e-02,-4.0260203755472263e-04,-1.9678359970188250e-01,1.3231027098641104e-01,-1.5403518661353000e-02,-3.5218902120201519e-02,-2.4777012246165078e-01,1.1102174280950648e-01,-1.2787332064596260e-01,2.3322487933245706e-01,1.9259996046140054e-01,-2.5687155181262561e-01,7.7469188632700622e-02,1.3519624277743707e-02,-7.8601907221600167e-02,-3.2621350322191706e-01,-5.4893317746482623e-02,-1.6259527467644766e-01,-1.4234801777837161e-01,7.3499801600372311e-05,1.7325996094335394e-01,-2.5818173197706251e-01,-1.0039587269479061e-01,1.9657533791349668e-01,1.2263996705404507e-02,1.4016737623601083e-01,1.1949722536632078e-02,-3.1375318093635182e-02,1.3366536761348069e-01,1.2209386816914979e-01,2.2579391354219335e-02,5.2155742281988715e-02,-5.8146503446538683e-02,-9.2862145412973579e-02,7.8238192480922605e-02,-4.6649743435746863e-02,-2.5286120043036675e-01,-4.6654657412869012e-02,-8.1660869877581380e-02,8.0543996408009660e-02,-1.5221209529838878e-01,-2.8797195241226387e-03,-2.2176554811408819e-01,-9.5943715815772601e-02,-1.1991617918495624e-01,-8.3501955347355952e-02,-1.4537886596007629e-01,3.9404877216751483e-02,1.2119542384578329e-01,-1.0370803866249208e-01,8.0588603128246381e-02,2.2635148265031949e-02,2.9630585982932978e-01,-8.3658070244929203e-02,-9.7637012631039730e-02,1.4047532549412844e-01,-2.0600459407764035e-01,1.8671742670801919e-02,2.7394221170585282e-02,-8.0319538870638515e-02,1.8457448042959877e-02,3.1931753355581322e-02,3.9218531399489255e-02,-1.2639559534159567e-01,-2.1614062029049430e-01,1.1333146811286333e-01,-1.0444361635382393e-01,-1.8216353917950145e-01,-1.9241348635694469e-01,-1.9389223259446264e-02,3.2821253047031526e-02,-1.4972749094804973e-02,-1.3970684005907336e-01,-8.0164986059758803e-02,2.7848282977320682e-01,-8.5376471702350645e-02,2.2049772640070454e-02,2.1727078616914935e-01,-1.8903044118262480e-01,-2.1049522038218221e-02,-2.2888644000319042e-01,1.7863319083295279e-01,-3.8129537388843802e-02,3.4000452528806652e-01,7.0464211376437269e-02,-1.5493730184888718e-01,-2.2147008788715672e-02,6.4561300523324261e-02,2.4618018525431572e-02,-2.2974262586700828e-01,1.5643331157617180e-01,-1.4390384470258136e-01,-2.2543085535834528e-01,6.2407221250112166e-02,-1.5397584151198251e-01,-2.4667161496942316e-01,-3.8068832580055950e-01,-1.8221727820263239e-01,-1.2438433579884153e-02,4.0743510045504944e-02,-2.3618537359396624e-01,7.2660455137504914e-03,1.5071709355315975e-02,-2.1302087616218338e-01,-8.9007951119920492e-02,-1.2848044186396665e-01,-1.1904698625721483e-01,-6.4609669243566634e-02,7.3869423470272269e-02,-1.3305835698448183e-02,6.9091257602254116e-03,-2.2251178584730050e-01,-2.3531480426256503e-02,-1.8232486444636962e-02,2.8433858588624256e-01,2.8693903451647002e-01,1.6369587710923714e-01,-4.8042092190105516e-02,1.3061152701311186e-02,6.5611946023679230e-02,9.9502040146188381e-02,-1.6105276723265876e-02,-1.0553046684147438e-01,-2.5450627263176961e-01,5.3741985675146653e-02,1.8237965407557656e-02,1.0060611460181923e-01,-4.7311475036869492e-02,-9.3090963219363013e-02,3.0803988567093890e-02,-5.6259648969315408e-02,-2.8314609463659013e-01,3.1106197192212776e-02,-2.3907761793523810e-01,-1.0479551489715799e-02,-4.5578998311635102e-02,1.7633483139704108e-02,1.3158896973517359e-01,-8.8158773722954997e-02,-1.6147092069653954e-01,-6.8626613315222226e-02,-3.4335786754020110e-02,1.4924395530361304e-01,-7.0778955413348874e-03,-2.1793559503017162e-01,1.1749506437548131e-01,1.2457147856818306e-03,-2.5385977992973215e-02,2.6710388348209338e-02,1.2165735234163649e-02,1.1245598617953305e-01,3.3763074992351311e-01,-1.8688465739065946e-01,-7.9879395029664180e-02,-6.9122657682560359e-02,2.0753014635048206e-01,8.1349579655634857e-02,-6.4411410426957107e-03,-1.0778251863241825e-01,-2.4994023437529461e-01,-2.4947208181512312e-01,-7.4250285068027874e-02,-8.1455594948488308e-02,-1.6254110766673510e-01,-1.1481682185104007e-01,-9.6602332880475240e-04,6.3051490334882637e-02,2.2193027518867967e-01,-1.6616882846966829e-01,3.4080565946407460e-03,-2.6010931018465305e-01,2.5366416366731964e-02,-1.1485306559845650e-01,-4.1183769017875363e-02,-1.3698117183108693e-01,9.3298694569499518e-02,-1.8233238781157415e-02,-6.5671111438423357e-02,3.5675416393390974e-02,-4.5753848199107890e-02,-1.6989346862533391e-02,-2.7392268053264157e-01,1.3171076680811819e-01,-1.1467768450259663e-02,-4.9687010173975560e-02,8.3568093332248780e-02,2.0529334345214242e-01,1.9393294152678597e-01,2.3487206527200094e-01,-6.7219899655850457e-02,2.5946303756680966e-01,7.3419187208975542e-02,-1.1264623573307023e-01,1.3659167791258606e-01,1.8339651181791397e-01,-1.2025279506309711e-01,-1.7967249234881727e-01,1.1677194871248364e-01,6.2836148770195679e-03,-2.2402026205654677e-01,-2.9212252547907838e-02,-2.8359128689637231e-01,2.0458997193969177e-02,1.0150053596897396e-01,1.8755856607863208e-01,-2.6586468132009881e-02,2.5685161473480801e-02,1.1867742956933089e-01,-7.9721905211152036e-02,-2.8158775726098290e-04,1.4332779683810769e-03,-6.6522109014538408e-02,-8.2656815189068422e-02,-1.5407625384009505e-01,-2.3029588342599699e-01,9.8365152038143930e-02,-1.0340760924593237e-01,1.3570019974828602e-02,3.5472628276172724e-01,1.5461901496118005e-01,-3.8428499006227010e-02,-1.7846431561448312e-01,-4.5377189639868878e-02,-1.9499322510905880e-02,-4.6186000144358974e-03,2.8182038932735215e-01,1.3283842146841848e-01,1.5223165445450354e-01,-1.0780300523995051e-01,-4.8278101458708707e-02,7.2293048312249752e-02,-1.5473616682983563e-01,3.3568373122810358e-02,6.5069025091658003e-02,2.8817441160720741e-02,2.7004025218809596e-01,3.4484112708179186e-02,4.0027857171043395e-02,2.6490347609877379e-01,-1.0063547157362368e-01,-9.5871816144087629e-02,2.0101933497680530e-01,-1.3725315412321232e-01,-1.4456870976174935e-01,-2.5612270273085613e-01,-7.2198176356799204e-02,8.2756254946922125e-02,-2.3712194650441706e-02,-9.7650134350774048e-02,4.1624728308649050e-02,8.6663596787983563e-03,-1.1606552362678367e-01,-4.1879673499092211e-02,-7.4205582751553048e-02,-7.7813452716431045e-02,6.8780452063607389e-02,1.5407299682418435e-01,1.5002046109052242e-01,4.5895164657688708e-01,1.3273157853063872e-01,-1.4861631004352624e-01,-9.7422962925859585e-02,3.2313415913583624e-02,1.1155238100931276e-01,-2.9253454255672599e-02,-1.4641528311256913e-02,-1.0052622819910879e-01,-2.7379437539838974e-01,1.1929130922667242e-01,1.5153923733589636e-01,-1.9809527057768678e-01,6.9629819083196043e-02,8.8318895869197028e-02,1.4429686910263925e-01,-1.4636497625494987e-01,-2.5840765334711899e-02,1.1051976169347036e-01,1.1178842449876580e-01,8.1811532317161123e-02,9.6558968215100474e-02,-3.6929768396414889e-02,-2.4278368107857537e-01,1.1334490229217969e-01,-2.0028621887202253e-02,1.7393317721262833e-01,-2.6491110180537719e-01,-1.5674767456472258e-01,-1.5952815366190815e-01,1.3485987472181835e-01,1.2179239740274279e-02,2.4189171228753831e-03,4.7182824655183392e-02,-1.8712260284539964e-01,-1.0012452275969595e-01,2.2721994479284527e-01,6.7120679814277107e-02,2.0692111320492756e-03,1.2187798446307824e-01,5.7339594050114014e-03,-2.1840107377945575e-02,2.7444239075689014e-01,-1.0978944771736788e-02,1.4803984361992278e-01,-2.0029940866034412e-01,4.4796219464907985e-02,-8.1827456863742709e-02,-1.7775125709292236e-01,-8.2888518971095476e-02,1.3613643991646759e-01,-1.8617163476466986e-01,8.4730494956284541e-02,3.2096881596386281e-02,2.5805046550950372e-01,-1.4495137404124053e-01,1.1607683926160652e-01,1.3642223717449697e-01,-2.4279763138118221e-01,-3.7398151738206764e-02,-7.7085362661605511e-02,2.5235051416749088e-01,-8.8652602575709921e-02,-3.0612307678909535e-02,2.6092298132605846e-01,-5.4440595623196690e-02,-2.0559764170378889e-01,-1.9443142950177673e-02,-2.0123956904568863e-02,1.4104350563668447e-01,8.0145423325639648e-02,-1.0113255838685446e-01,-1.1110417030612288e-01,1.2352377125882244e-01,1.8611566856553494e-01,-3.1211717899423141e-01,1.8293916161948170e-03,-2.6953152764274405e-02,3.0355315042905578e-01,5.3875296448713465e-02,-7.2195723248268603e-03,2.5402488416087367e-02,-2.4211763947382139e-02,6.2762198352814130e-02,5.1691903864033113e-02,5.7570288869304376e-02,-2.9187385782665842e-02,7.0780540541431777e-02,-8.3685140166170152e-02,8.5484941506097298e-03,-2.9255349867815883e-01,-1.0296930089785673e-02,1.7870790198033412e-01,-2.2066726370351086e-01,-3.9309716433695713e-02,1.2452300722155023e-02,-1.2080324149108182e-01,-5.3432847299566703e-02,5.3552966580983241e-02,1.9331836464369537e-02,-2.3561595854912470e-01,1.0265804277006177e-01,-1.1021027208636597e-01,-1.5638062784137852e-01,1.9402459051139026e-01,-1.2136530570088763e-01,3.0382638679167445e-01,2.1438987771002675e-02,-5.8876505345593917e-02,5.1655161721155779e-02,-3.3676358539999002e-03,3.8166973518332238e-02,-4.6589306095864846e-01,5.2553284583390550e-02,-1.7297447395786654e-02,-5.7953617539925777e-02,1.4772635897166364e-01,9.7869084933049494e-02,-1.6622899407738703e-01,5.2504342925314577e-02,-9.3156338798686442e-02,-4.8028489424296460e-02,-6.9930920954178299e-02,-5.7772976040731908e-02,-7.6752632302781662e-02,3.2113261918212138e-01,-1.3265377680947231e-02,-9.2873345548473416e-02,-5.4847911576699042e-03,8.7071035180597334e-02,-1.4308502941742324e-01,2.3467450077645421e-01,-1.7152346147485500e-01,-6.1800423242335159e-02,3.0596624747980514e-02,-2.1471819339966916e-01,-1.4969816630775061e-02,-2.8250369103788198e-02,-5.4965550989060370e-02,1.6266930897968088e-01,-1.3940808173663286e-01,-4.9102589532751047e-02,-1.0671186646129145e-01,1.1459883208930202e-01,-3.5182347474659995e-02,5.4174541497415823e-02,1.9319111175187414e-01,4.7840741276128189e-02,-4.6798085748634942e-02,-2.6542750481330923e-01,2.9156652980981010e-02,-2.4105113756660898e-01,6.9791566600158880e-02,1.3805487200459104e-01,-8.8454013241003882e-02,-1.6751332331142399e-01,6.9637585081879977e-02,1.6923540991045402e-01,9.2055627795102818e-02,-5.2851780199954158e-02,1.6237533964404080e-01,3.2244036054744518e-01,2.1099931858306199e-02,-1.2530836783391061e-01,7.6790996160631134e-02,2.5829863606865971e-01,1.4993170842581183e-01,-1.4469714628747093e-01,-2.4053381419492623e-01,-2.0137150377256052e-01,-2.6056830969203207e-02,-1.4886371570364063e-01,6.4249355021060217e-02,-1.5599365507532051e-01,-1.9355175057123014e-01,1.5033742980858744e-01,-1.9175220190026376e-04,-2.0269987800127276e-01,-1.2192059755295707e-01,-7.4487755049424190e-02,1.1200999730286348e-01,5.5118521104655961e-02,1.2176235702833341e-01,6.9079907752608152e-02,1.6764167913739661e-01,-2.5925797054355454e-01,3.1457906332019697e-02,-1.2689117359512184e-01,1.1082524676276333e-01,2.7668341988697043e-01,1.3206774791320694e-01,9.7710516159272440e-02,1.1871954460938386e-01,-1.8030545706898551e-01,-5.7236574869998724e-02,-1.2838248446247913e-01,5.1444760257280023e-02,1.0819400387415795e-01,2.4801966460516859e-02,-7.5398237907956300e-02,1.2480481140947214e-03,-9.4510332902074778e-02,5.4855797777261586e-02,-1.2544560661682705e-01,-4.1949758391826397e-01,7.3385984497366885e-02,1.6883695061590143e-02,-6.2869111936379063e-02,-5.7997153521632358e-02,2.6753122087516507e-01,-1.0399602818554385e-01,2.2275246826279443e-01,9.4085476410678631e-02,1.3240229919323795e-01,-2.0810509553644940e-01,-1.8976503112007170e-01,-1.7346933040832879e-01,2.0421581138000883e-01,4.0395547830985402e-02,1.9550362340226546e-01,-1.8986104880002630e-02,-2.3135174323149921e-02,-7.2808675717147442e-02,-1.1507355847984803e-02,-1.5857794941197523e-01,-2.5156808321115429e-02,-2.4213704181710385e-02,-1.1245602906959071e-01,-1.9635446465712822e-01,4.5426918525726875e-02,-1.4087753323806335e-01,1.5535678391938271e-01,-5.8979559031487841e-02,-1.1235631487890003e-01,2.8418052763675792e-02,-3.0833803462735382e-01,1.8151987311550716e-01,-6.5167234287562006e-02,8.0603491028451282e-02,-2.1259358439987405e-01,2.2839428168983819e-01,2.3272263486021050e-01,1.7984079619326929e-01,1.6675632599570842e-01,-3.9210050342438588e-02,5.8850296839477956e-02,7.1541075009889030e-02,-1.5590130364742288e-01,1.9369789275618540e-01,1.4369846307462616e-01,-1.5374903651268347e-02,2.3144118517105204e-02,6.5195217112741066e-02,-9.6955718648584432e-02,8.8642555734257278e-02,-1.4305470315249075e-01,-2.9499404156064724e-02,9.2414819611371157e-02,1.6458201541028261e-01,6.0985044192872609e-02,1.2442515042637123e-01,-1.4089732644544198e-01,6.0741349878141462e-02,-1.2588278882616641e-01,1.9444947957686631e-01,2.9041014503858632e-02,-1.3005707104706163e-01,1.3166318217789807e-01,2.8459131318339697e-02,-1.9327737943618381e-01,-1.8483168346538822e-01,-1.4995921117516672e-01,-2.6228193213417633e-01,-4.3240192373335332e-02,-1.4631792475218825e-02,1.4543610589544817e-01,-5.0170434507191025e-02,-1.8272588715499269e-01,-9.1558515970574794e-02,1.2247687354564665e-01,-3.0500974295249103e-02,-1.4131634851327327e-01,-2.3712038379158135e-01,3.7846989034451460e-02,-1.4677846778214659e-01,8.2466503650024600e-02,-7.8341805757405514e-02,9.3208519077294841e-02,1.5695159190358496e-01,4.1417649249655721e-02,3.0564434668845009e-02,7.0310394402585505e-02,-8.6903492287874542e-03,-1.5388488868830202e-01,-1.3475660933282252e-01,2.3179095994179752e-01,-1.2443887683914226e-01,1.7125378219698961e-01,8.1149034807775522e-02,-2.3687437796324887e-02,8.6727430849300985e-02,-9.5944026578381039e-02,9.6861592260135493e-02,-1.9972130828564763e-02,-2.1971798506043597e-01,-1.5196756298521949e-01,-4.5348751392884808e-02,1.6146670699675891e-01,-1.5427048529371740e-01,4.5643286763600618e-02,2.7356440089439119e-02,8.0312714915589764e-02,-1.8780490624963470e-02,1.8873871967240474e-01,2.3244146659561477e-01,-1.9749514249298335e-04,2.6030258347328528e-01,-2.8809805960470825e-01,2.1555623524490763e-01,-1.4749522931996470e-01,7.3404289229979700e-02,1.1404558104354534e-01,-3.6751318019123130e-01,-6.0479046136204404e-02,4.7622003296743660e-02,2.7452104067784769e-03,7.4887989266092497e-02,2.4967108423906204e-01,3.9351985408614683e-02,1.6658179951084851e-01,-4.6759857284325398e-02,-7.8488243459847867e-02,-2.0700504695667030e-01,-4.2639338745017380e-02,1.4430912912459301e-01,6.3746042050039767e-02,7.8065333495907732e-02,-2.7645196927026405e-01,-8.8721662345426000e-02,-1.6417362469775124e-01,1.9105124671300898e-02,-5.0089436807783182e-02,3.2947752721348494e-01,-7.4669479990589430e-03,-1.4713533374478013e-01,-3.9698380257256416e-02,-1.8191475466197210e-01,-4.6744538173518181e-02,3.3591016695176001e-01,-2.1500754526119895e-02,1.0951122067391714e-02,-1.7572283208503223e-01,8.4130307229717205e-02,2.3649167636837046e-01,2.0482921011024660e-01,2.0226270000607799e-01,-2.6003339936212422e-01,5.8262416015137763e-02,-1.1823516801462911e-01,-5.8043954791343041e-02,-2.3488121138870756e-02,2.4622614925794511e-02,8.5452830006930072e-03,7.2754762149043861e-02,-3.7872557004605088e-02,-4.0556493081665444e-02,1.1737445762745626e-01,-4.6050231331936760e-02,-1.2397768753016185e-01,1.5337162855434930e-01,-4.1616831834482483e-02,-3.7461538784227172e-02,2.3545103975764224e-02,-1.5521671422658900e-01,3.1660432953071381e-02,-5.4193187809068871e-02,-2.4090316337322412e-01,7.9859689997814634e-02,-2.7275561636341195e-01,4.0101557304620235e-02,-1.7435082589723219e-02,2.1575821738617712e-03,8.9288093042609762e-02,1.7127783885607581e-02,2.9149685207181236e-01,2.5271053813824157e-01,1.7269979732466459e-01,9.1448490215319617e-02,-7.7531756579949540e-02,-3.5961110643666631e-02,3.7028355971670945e-01,3.0653742168136558e-02,-2.1930613964208132e-01,-9.1364347298039141e-03,-1.5146925660431179e-01,3.1227436478376558e-03,-4.6511660320656158e-02,2.6756581235962273e-01,8.5869786273736232e-02,-6.8474953386196385e-02,-1.0782231426627795e-01,7.3255008995467580e-02,-7.9833330624862146e-03,-1.8211252785711815e-01,1.4795013278729680e-01,3.6516235791096870e-02,-4.1072357817308364e-02,-8.4264847124906644e-02,-1.7147733095875028e-01,-1.8114591305425312e-01,-6.6759284812306250e-03,2.2350499957958880e-01,1.0514128199774678e-01,7.6229389545210982e-02,1.5171000721080405e-01,1.6659634086118710e-01,-1.3652401759323210e-01,1.5011592919643410e-01,-2.3869273140997593e-01,1.3356459202577034e-02,-3.5628923009456331e-02,3.9319629636567821e-02,9.1889122089776773e-02,-7.0626482102151458e-02,-4.4484983978170814e-02,6.9054382142610005e-02,1.7051770790821535e-01,-1.6222633727157398e-01,4.1490971324833224e-02,2.6928306887375342e-01,-7.7103698286450251e-02,-7.7883144547672284e-02,4.3303990529201461e-02,-2.5087273534566740e-01,7.6093749557639409e-02,1.6135817325354504e-01,2.0950446544698342e-01,-5.5211653772629099e-02,3.7367060237761140e-01,-1.5944100868584885e-01,-1.4334925696637787e-01,-5.1594368878932893e-02,1.0027558838733246e-01,-4.2023005754397914e-02,-9.2178245645808572e-03,-1.6542374294608025e-01,5.0221526119038219e-02,-1.2314576921058733e-01,3.8208310435453918e-02,-2.2915294613514309e-01,1.1327019084043505e-01,1.3508588772732125e-01,-1.0014643326372737e-01,-8.2302384610916837e-02,-1.0230215140017859e-02,5.6824207869605750e-02,-5.5457425122039862e-02,-7.5321801271579558e-02,7.4813209221042648e-02,7.4129615162672510e-02,9.0374285255195733e-04,1.0128501665435624e-01,-3.9077220488852871e-02,-2.5219511480974627e-01,-3.1251252860477537e-02,-1.0788417663175551e-01,-2.8101220167332082e-02,-1.3522345043302841e-01,-5.2986495103265585e-02,9.1579525601561528e-03,-2.5736798963167956e-01,3.0885145335093900e-01,-2.0117203535499506e-01,-8.7080890669310462e-02,-3.5820447257695831e-01,-5.4606758362837488e-03,1.4208298978800857e-01,4.2722979446921168e-02,1.4609573220461095e-01,1.3330594777441770e-02,5.9958692688737505e-02,-1.2615859213290972e-01,2.1019742878403819e-01,-2.1704738524911549e-02,3.2925540757721770e-02,9.9404925434043293e-02,3.9612515822737622e-02,1.1261913221015991e-01,1.8902615818374355e-02,-9.8997876225875484e-02,-1.1396466874572712e-01,-1.5678316571460466e-01,1.7657139722741066e-01,2.1084614211753852e-01,1.1573644289345598e-01,2.1589784938032922e-01,2.5448899481803045e-01,-1.2380124838339519e-01,-1.1853760922754985e-02,-8.5502019629713669e-02,2.2557245360140032e-01,1.5606293035474100e-01,-2.2679772883167773e-01,-3.0799375374837934e-01,-1.6436173972354398e-01,8.1108243941286212e-02,-5.7774562301305836e-02,3.0082705848948205e-03,1.1261728086873726e-01,2.4201841994641381e-02,-8.2260814237186383e-02,2.0220633200868976e-01,1.1362548210327093e-01,1.8534701017420566e-01,8.2227121336583830e-02,-1.6784043332760144e-02,2.4367863131262421e-02,-7.5815230072353537e-02,5.7262203426932695e-02,1.2359091376221389e-01,-1.9029152369492602e-01,-1.7290225969603162e-01,1.5381500091419389e-01,5.8576414369077796e-02,3.1311366293693693e-01,1.8129343943690590e-01,-1.5384925605922264e-01,4.1630525382703627e-03,-2.9937038500723597e-02,6.4110127797169528e-02,-2.2051116791054672e-02,-2.6039557195330906e-02,-3.3277259241992208e-02,-1.1386343481741072e-01,1.9575917001908333e-01,-1.1545168535842283e-01,-9.6720199928486794e-02,3.4331064375415288e-01,-6.1449091735280917e-02,-1.8240255566233948e-01,1.0297543977349966e-01,1.0597413091759221e-01,-8.2061875408742671e-02,6.0325806886009414e-02,2.2097261359712728e-01,-1.8157558149356268e-01,1.9056011010430740e-01,8.3660635934354285e-02,1.6562716769014513e-01,1.3475621929575496e-01,-2.7269266054212593e-03,-3.3465975340329759e-02,4.0712498753431164e-02,-8.1605941790846043e-02,-1.9750886083130244e-02,2.5760938677757472e-01,3.8917491837262022e-02,-1.6514065125468949e-03,-3.4918849506892696e-01,-1.0471245506407650e-01,-1.0987550762677052e-01,5.4725126391511579e-02,-3.2776456012101704e-02,-9.1525360918008392e-02,-9.5028753158337004e-02,-4.1105854860034562e-02,2.6400461559897094e-02,-1.3896620005489804e-01,1.0435491039685801e-01,-5.4261788625928058e-02,-1.8831975664168188e-01,-2.2070516446508107e-01,7.4817111940572889e-02,-9.8649544186844795e-02,-2.7235413894319749e-01,5.1941540197694376e-02,2.7250177376047312e-02,2.0346081402541949e-01,3.3142171561206302e-02,2.4090221398910278e-02,-6.5668760346839217e-02,9.8953712656344769e-02,-7.0747610547447520e-02,3.0304121015296887e-01,9.3077244605617906e-02,-5.7273834135718640e-02,3.0300977074302665e-01,-9.3392345862574208e-02,-3.0657138837198000e-01,-1.3866768657440326e-02,-1.5156444257824782e-02,3.0468262804405422e-01,3.1898464079707305e-02,3.7836642619552933e-02,1.4744554619704503e-01,3.0746567675389649e-03,-3.3088425145911732e-02,3.8608673892068834e-01,-2.1465427381678118e-02,8.7174501873000798e-02,3.1591145618587041e-01,-2.4317244540405583e-03,-1.8539422520888293e-01,1.6054590267785160e-01,-6.8165999514461048e-02,-5.4409068766133412e-02,1.2555460806847996e-01,-2.6640530421740222e-01,8.4767526219647726e-02,2.0799379179879096e-01,6.5069345263332832e-04,-5.3905099674500148e-02,-5.5043038714102710e-02,-1.2966476312310696e-02,8.2243627841014744e-02,1.1823126340935831e-01,2.0782391480447004e-01,1.3253940087656324e-02,-1.0600587387424919e-01,9.9335829945245147e-02,-1.8333951246313915e-01,1.5862478766436947e-01,7.6476823658896978e-02,-7.3651484595075339e-02,-1.1880144268163518e-02,-4.2375154550264957e-02,-6.8484331211580152e-02,1.0149011535355841e-01,1.2192095356545180e-01,-1.0587511271310321e-01,-7.4928143592548988e-03,-2.6412651623745783e-02,-1.2631256189057988e-01,-2.1230606380116639e-03,2.6529256134389771e-02,9.8118631854598570e-02,9.4573642696276453e-02,-1.2305787509099791e-01,3.4770803612624010e-02,-1.4823954529199870e-01,1.4135269332725167e-01,2.8531064261438147e-02,1.2599551326988806e-01,-8.3596495384156214e-02,8.4329220389941159e-02,-6.9514679623994519e-02,-1.3625329523200752e-02,-1.2209230554901726e-01,-3.3152343261253298e-01,-2.9234321587943407e-01,-7.9096762613611329e-02,-9.8194146191213125e-02,-4.6110178881989361e-01,1.4081038805075063e-01,-1.6265776646294197e-01,8.9856532994476629e-02,-1.8158871515447234e-01,7.2861806501372441e-03,-8.3916806302529331e-02,-1.2621110440938760e-01,7.4464575826925464e-02,-1.1811681247579200e-01,-9.0679985054227433e-02,1.5315637273290306e-01,-9.9884158705434697e-02,1.7341971389580613e-01,-2.3078908827274335e-02,-5.0488900224819472e-02,-5.3415232852029038e-02,-1.6719087216863035e-01,5.6152347938881034e-02,-1.9713748170221942e-01,-1.5595251456509460e-02,-1.4655183454542731e-01,-2.0526564151462590e-02,-8.0975983526621609e-02,1.4873417864129704e-01,1.6204596412720262e-02,-4.4512977246406613e-02,2.1454633869477678e-02,-1.7346721328505293e-01,6.1510793494209862e-02,-2.4886636870202264e-01,4.5594419347518150e-02,-1.4006897196642981e-01,3.8664035498626001e-02,2.0951391102392375e-01,-1.3828522840843452e-01,-1.0812045190039987e-01,2.2992214613095363e-01,-2.0679814360228557e-01,6.1088306306620099e-02,-7.4416522716530709e-02,1.4374248798017458e-01,1.3766085455960375e-01,8.0163810177837080e-04,1.9834405418331252e-01,1.6267772500414154e-02,4.1828137699733481e-01,-1.7862474915461765e-01,3.3460124126524160e-02,1.2289467456423188e-01,-4.5760643681742354e-03,1.5092659666430977e-01,1.3449898962918733e-02,-1.1005068472971363e-01,-5.5623490538704704e-02,1.4491365881493162e-01,1.1917265465374756e-02,-1.6139425160614246e-01,-2.2414807533134587e-01,-1.3818527387982968e-01,1.2202828374977395e-01,1.1541733198657793e-01,-8.0767247517074314e-02,-1.6778365903237891e-01,-5.0817708939088560e-02,1.0368359752256567e-02,3.7834280918544877e-03,-9.3618757337362704e-02,5.1110912903480563e-02,7.9671121090726382e-02,-4.0215009931374245e-02,-9.6514059634346408e-02,1.5383213248084626e-01,7.9496125236903095e-02,3.3457646629862886e-01,3.1846544855641895e-02,4.3888938004431784e-02,1.4678012203235954e-01,-1.0628633582197038e-01,2.5105812191592330e-01,1.4231590620736628e-02,9.1642325781682632e-02,-1.3524450395063448e-01,-3.2153101945368537e-02,1.0132000255830674e-01,-5.6664193726630535e-02,1.3702996194887787e-01,-2.1682988581489315e-02,3.6842084225071667e-02,1.1606091502890103e-01,-2.1897371636823271e-01,-1.3671948688730562e-01,4.8419510738039823e-02,-5.5371835553479104e-02,3.1557814188923228e-02,1.6046588347347385e-01,1.3690819073997634e-01,-5.7496220750010721e-02,-8.1494630576179339e-02,1.3915912275157083e-01,-1.3515475099159543e-01,6.5600538878545306e-02,1.3381963642814382e-01,-3.4160506904958993e-01,-1.0444081818002809e-01,8.7391599856768518e-02,4.4190835125903008e-04,-4.4975087116533204e-02,1.3041188275251639e-01,1.4161197348229615e-01,-1.9267060589885071e-01,2.1055681695410966e-01,-1.0335122262583807e-01,-1.1179785392688524e-01,-1.1994920506614493e-01,-1.8702755006717006e-01,2.3206543067619048e-01,-1.2132371281908143e-01,-1.6593217979140162e-01,-8.5446967951224778e-02,1.6926631767590999e-01,1.1459188780114093e-01,-4.3762646655807480e-03,-9.8629219745093338e-02,-3.6988782919229896e-01,-3.1394095636613426e-02,-3.3769411217570836e-02,-1.2771520238439402e-01,-2.5798695856311138e-01,-9.8647972840797363e-02,2.0769811684428513e-01,-2.0334943033182888e-02,-7.5655098013662825e-02,1.6425231756271130e-01,-5.5750777798168602e-02,8.1553382463792484e-02,-1.9626661148962421e-01,3.5505860446967762e-02,-8.9955164273043967e-02,1.9020929169740022e-01,-1.2399983898533954e-02,-9.8797278566302799e-02,-1.1041889498708618e-01,1.0587586683677158e-01,-1.1391080578214285e-01,7.0934205457115693e-03,-1.6631133084890526e-01,1.2271865387982587e-02,1.1198635711720210e-01,-5.7891366113871252e-02,3.9863198738878357e-02,-4.1792889527995307e-02,1.3936721549410594e-01,5.1246764300403071e-02,-1.5188750857354236e-01,-1.1839392456596431e-02,-1.8821958359486801e-01,3.4319156705578707e-01,2.0372915577832001e-01,-4.5657384974964160e-02,1.6541465994351306e-01,-1.0048075686695414e-02,-5.9751660770284334e-02,-1.9795250722867369e-01,-2.5365803829259437e-01,-1.6603327735712942e-01,-1.2742887772409950e-01,-1.7969386771387430e-01,-2.6895386561383366e-01,-1.4224962743758193e-01,-1.4694337733644075e-01,2.3586666757153839e-02,1.9958713749688894e-01,1.1974689263025709e-01,2.3053149799810443e-01,-7.6177024066305957e-02,-7.3634119891672109e-02,-2.0590414952338368e-01,-3.8396714905272342e-02,1.2100797601193276e-01,1.9144970236819051e-01,6.1906986144332987e-02,2.9203920706409148e-02,1.7539660447695485e-01,-1.6182635883217633e-01,-8.7003126135239556e-02,1.5400712469422958e-02,-1.4763208755527191e-01,-2.2619135156472059e-01,1.1648865290879115e-01,-8.9877616207845568e-02,2.0319371081753829e-02,2.8484676654681301e-01,2.3681889963613964e-04,-1.4975107580317806e-01,-9.1203525696933768e-02,2.7204034247432346e-01,1.0800775736705427e-01,-4.0164478523721486e-02,-1.3437539028969606e-01,-2.1450909506423393e-01,-9.7519610699602202e-02,-1.6886792226984451e-01,-2.0945988489238102e-01,-2.5456901010896822e-02,-1.9533601018926433e-01,-7.9839450749589966e-02,-5.0648177367616398e-02,1.4849479228100171e-01,1.1613481355142277e-01,2.4543357169684341e-01,8.8442601019971118e-02,1.0251310219374025e-01,-3.0822923974809055e-02,3.6145504464953772e-02,1.6360800499370151e-01,-2.5028394669816872e-01,4.5656949694207485e-02,1.5302852600721439e-01,-1.7564145527936986e-01,-2.1042731247688612e-01,2.5764988670991146e-01,-1.6091424131591145e-01,-1.4260054383809417e-01,-5.7014725373536551e-02,-5.4426724071465045e-02,4.6610555947811688e-02,1.6151185629510831e-02,3.6743652023602566e-02,1.0453779577280836e-03,6.5296508683038240e-02,1.1857693695840273e-01,2.1370295413443144e-03,3.9789665356953212e-02,6.7910790295635612e-02,-2.1147108413428173e-01,-8.1093851161051569e-02,3.5473814105855879e-02,5.1720032330255496e-02,2.4637546190213314e-01,-8.4808929422696355e-02,-1.3859559979605978e-02,2.3546440074313660e-01,3.3062651830342010e-01,-1.5798198391171629e-02,-2.3434667678849688e-01,-1.1696811865257650e-01,1.9941927254521347e-03,3.3807586730582768e-02,-1.5258204221646954e-01,7.9035619580753759e-03,2.4105169298925210e-02,2.6917648970140630e-02,2.3062289465510588e-01,1.8169475336944688e-01,1.1686717592756274e-02,-7.1601567446262393e-02,-4.1053131767872460e-02,-1.8164791489125334e-01,1.6331391600538259e-01,-1.9609382184490662e-01,1.5950788113289005e-01,8.1558527374459483e-02,2.3239023448451274e-02,-2.6337505735301814e-01,9.1072064527878013e-02,5.8867352169176768e-02,-1.7403795843988504e-01,7.6430784047781392e-02,1.8299819363662315e-01,-4.2004074234755828e-02,2.9569396366898173e-02,-1.1506080506663290e-01,2.3533899776136954e-01,-1.3485163284494409e-01,2.1098720172341040e-01,-1.1188146615549333e-01,7.3594732116509590e-02,1.3146615314814397e-01,-1.0331697693659810e-01,2.2514404329560350e-01,3.8724831226456383e-02,-6.6291563829595071e-02,-4.6820469308310519e-02,1.9140899370656905e-01,2.5465576876683577e-01,-2.2248569882051164e-01,1.3037998177593474e-01,6.0207702806805409e-02,-8.1494262301579551e-02,5.4437612848441987e-02,7.0944120276762834e-02,-2.9028987058639705e-01,-8.0705366887890220e-02,-7.9378471596351100e-02,-2.2221874878451209e-01,-7.8187703479355962e-03,3.1421252725009330e-01,1.6408752373658098e-01,-1.7195956010658919e-01,-9.0895823778534515e-02,9.0157598958274417e-03,-1.4823391713365963e-01,-8.1390675688646816e-02,-1.0110007192494061e-01,-1.1594568561604412e-02,2.4568322496174952e-01,-3.2419938857572056e-01,9.4040865068145768e-02,6.7747284973833921e-02,-8.5664866344523014e-02,1.8223562984504676e-01,-1.4796454082300697e-01,-1.3025767128356772e-01,-1.1869361268590993e-01,-8.1136988758117590e-02,-1.2802293234501089e-01,-2.7095795670682266e-02,2.3962105382847623e-02,1.4711997776531854e-01,-3.5380125195895527e-02,1.4934471874039726e-01,-1.6611688119967832e-01,1.1063855109059348e-01,6.8222009421392643e-02,8.8939147796631035e-02,8.8354834713316927e-02,-7.0169705501402349e-02,-1.8458235844974735e-01,-6.2011530485712306e-02,-5.9354696659289861e-03,8.0149792934132824e-02,1.0550057560963552e-01,-1.3785040188347374e-02,2.9386901621537773e-02,-1.2294425327788178e-01,-7.6247063887028579e-02,4.0249010618327918e-02,-1.2897825653372053e-01,2.2387686145371503e-02,-2.7641501375027100e-01,2.0152759603203274e-01,-2.8457570729644853e-02,-2.7115480617242904e-01,-3.1989554089994959e-01,-8.5575578883907329e-03,2.2624165382720291e-02,-1.3225191703322936e-01,7.9154471399191226e-02,5.2746256504524872e-02,5.3341812463563294e-02,-5.4731410414197053e-02,-4.4188974474541960e-02,1.9927016577173196e-01,-2.7757730220734522e-01,1.4311826065553482e-01,5.0383219780023247e-02,8.2407699818274865e-02,9.4067964377101715e-02,9.3391945668045595e-02,-9.3513839537088111e-02,-1.4231842460747676e-01,2.4317793552357522e-02,2.3364414660776597e-01,-1.4435142923887415e-01,-2.3649037162637807e-02,1.3061804972079155e-01,3.3754266915940669e-02,-1.4206251545524337e-02,-1.2182973950425488e-02,-8.4967443554857275e-02,2.4394436209737366e-01,7.2377786831418949e-03,2.0752887010656287e-01,-2.0745621689346946e-01,9.5836869061388372e-02,1.7985208696350466e-01,1.0773982753977407e-01,3.5479059976032006e-02,2.9146625744443988e-01,-2.1193259732235648e-01,-7.1984933483655186e-02,-7.3526586082083584e-03,6.2310780752070381e-02,1.0584911989659840e-01,3.8370105936806620e-02,-1.7307650396053376e-01,1.4203685540309297e-01,5.4901450101916972e-02,-4.8564284183606865e-02,1.5973962465740787e-01,3.8822812308498038e-02,9.6084956662028237e-02,1.6535233198860848e-02,-5.0008848855849400e-02,1.5159684489312364e-01,-1.1816783458200848e-01,-2.7614900215476405e-02,4.3616830777179469e-02,2.2162471974757661e-01,5.2718091165110177e-02,-2.4258868234099148e-01,6.0493190951774856e-02,3.3936927562390987e-02,-1.4387867726520753e-01,-2.6250653833943503e-02,1.4168295540040260e-01,-4.0650735483051412e-02,6.5756724899218300e-02,-9.8349494266801826e-02,3.8715691992520507e-02,4.3163769078900426e-02,2.6044424044035558e-01,-2.9538450915403031e-01,-7.8025835393836611e-03,-2.3318170614957626e-01,-4.4921739239935747e-02,-5.2450219951873919e-02,3.1266859140787417e-01,-1.7653767356005567e-01,-2.2592986293125471e-02,-2.2207667348000479e-01,-3.5007136453304671e-01,-4.5476636796611195e-02,-2.1509583489955419e-01,3.5522652902972802e-02,-7.9983303495370722e-02,7.2022104243465810e-03,1.4261883278712653e-01,1.9369316496370706e-01,6.8804237129004131e-02,-6.2936536054110051e-02,-1.8728365775436479e-01,1.9910671018613135e-01,-1.4182804569383478e-01,8.9017078368220648e-02,8.1459498752221207e-02,-9.3163303687672838e-02,1.7433200967211882e-01,9.1932191882980629e-02,9.1637181691105823e-02,-2.1912169658241537e-01,1.8533490396505423e-01,-1.4577609681460377e-01,-1.1104944466419486e-01,6.0750026607466617e-03,-4.3672177044219940e-02,-2.5254114341734635e-02,-6.1623813384763838e-03,-8.5392220289349063e-02,1.3697447099757076e-01,1.8259583787302383e-01,1.1621999369623718e-02,-1.5727757182000923e-01,2.8397218703561815e-02,-1.7232180317420570e-01,3.9630787381729260e-01,-1.9305992448138683e-02,-9.6678510019599755e-03,1.5852086613583852e-01,6.8627346633232278e-02,3.2378082078006860e-02,3.0785011714036529e-02,-6.4494790513190042e-02,-1.1235413702874901e-01,-1.9474852614630897e-01,4.9762215309298155e-02,4.6933818648366994e-02,-1.0831916697277989e-01,1.0360164971218730e-01,1.9448883750162857e-01,2.2208139983738058e-02,1.0840418199589442e-01,1.2297492792625636e-01,4.5973571836510803e-02,-9.0708787146378062e-02,-1.2663373512225637e-01,3.1869737418990185e-01,1.8792314095381313e-01,2.0458875574249358e-01,-1.2730069461425655e-01,2.8052315302528114e-01,-1.5676044995727228e-03,5.5158858413671460e-03,4.9121034845608966e-02,-5.1532785157490185e-02,8.9427549314929758e-02,-2.1442556107659130e-01,-2.9729703223626708e-01,3.6789916923497347e-02,-1.4855498199010789e-01,-1.9091597671736385e-01,-1.7894570931030324e-01,-1.3427474356546867e-01,2.2854692170891150e-01,-2.0083066532527224e-02,-1.2532006630871823e-01,2.6385890732818612e-01,8.3986623965038643e-02,-9.4441856320753317e-02,4.9289369871501378e-02,1.6562317562074672e-01,9.3695971476601095e-02,-8.1439500508686091e-02,-1.1567371887580735e-01,-3.6520536649035144e-02,-7.5309944301753307e-02,1.3982645118202812e-02,-3.0612535116648393e-01,9.4142192035649386e-02,1.8564466603447841e-01,1.4616041473232172e-01,-7.5391014138184401e-02,-7.6299319240136942e-02,-8.2609386781931055e-02,-5.0258479420874497e-02,-1.1920496439941415e-01,-1.2741026036597172e-01,4.1947403577878753e-02,-1.1174793120742321e-01,4.1399440938745563e-02,-1.2737960020272845e-01,-6.8438187324748559e-02,1.1205478227634591e-01,-1.3180882870262700e-01,1.0858174156208633e-02,1.1313824714886322e-01,1.9513969030857777e-02,2.3653584601166391e-01,-1.9633889869657837e-02,-2.5992023500230799e-01,-3.0925961661240314e-01,-1.1615866322714102e-01,1.6747455135766132e-02,1.8269512712244870e-01,-8.9490395398989925e-02,-4.0591233959832006e-03,-1.2818057219520204e-01,-1.1213456120595977e-01,1.6844274403667973e-02,-4.6738712292543005e-02,3.3539828515772468e-01,-7.2081523995030745e-03,-1.8654235417159815e-02,-6.2783855936180993e-02,-9.2099214824693076e-02,-1.7204646084768574e-01,1.5782282456229141e-01,-2.0412623171622840e-01,6.0564331713993398e-02,1.4689930577292135e-01,-3.8959578149340951e-02,8.7643178379970918e-02,-2.4542201205154546e-01,4.8163189681736052e-02,-2.6242925663249095e-01,-2.9880173168613310e-02,6.5471075025145209e-02,7.4020711352923412e-03,1.8715565100782158e-01,6.1616506434690438e-02,1.0669124348292273e-01,-1.1355364015109588e-01,2.4381175670835820e-01,-5.2045746815130030e-02,-1.6701652691477550e-01,2.7287408993251794e-01,2.9467557796753974e-01,1.1289297747451044e-01,-7.2919116392657204e-02,-1.3842085741336363e-01,-2.3502698098719507e-01,-3.5948136044535978e-02,2.5987049295057667e-02,2.0743635184440368e-01,1.2086887675137714e-01,-1.9730613043433914e-01,-5.9898922492398143e-02,-1.2444528969870196e-01,7.0013654268780340e-02,6.7118696699679348e-02,1.1161959586989258e-02,1.4360018553357076e-02,8.2395367910796977e-02,-1.1829470535318122e-01,2.3985355236729608e-01,-2.5502942117094440e-01,-3.7089600927351793e-02,5.6481247979092451e-02,1.9531896769827992e-01,1.7755596568428561e-01,-2.6380341517281271e-02,-4.8029392376839349e-02,-2.3406569686000214e-01,1.2442620150209452e-01,-2.2800710713705619e-01,-1.9695311390071836e-02,-9.1792331041959704e-02,-7.5521186177376326e-02,2.7666091947126714e-01,5.1778547067602515e-02,2.4874036331485044e-01,-1.7444511927985015e-01,-5.6415982604818699e-02,-1.0071288097310428e-01,-1.6584550998853650e-01,-1.1115762158074449e-01,-5.6763344856658557e-02,1.6302243589611388e-02,2.1047989615140686e-01,6.0708813926170863e-02,-9.2069757223221721e-02,9.9741982448934785e-02,2.6499236306578466e-02,1.6628504887555051e-01,2.2748575898800336e-01,1.6225378799197135e-01,-2.0386475738904258e-01,7.6061870273147827e-02,1.6279680062082832e-01,-1.5829037514967309e-01,-1.0835060688471163e-01,1.3654417573300812e-01,6.5922918331364461e-02,-1.9178918818418283e-01,-5.1490316349409350e-02,2.9590546431589607e-02,-8.6670153320517113e-02,-5.0831843230920007e-02,8.2826745684323466e-02,1.7648098243724245e-01,-1.3653519790354371e-01,-3.0018710462340149e-02,-2.8870887942019235e-01,-3.4648860333500220e-01,-1.7316683095430729e-01,2.7438890902377073e-02,-5.1777796027877493e-02,4.2444140588612372e-02,-8.1421986411403566e-02,5.8335393593822615e-02,-1.6856457834862171e-02,-9.6335195625857864e-02,9.4667618059651487e-02,-6.6308248029638236e-02,4.5207590203529741e-02,-9.3330133534350795e-02,4.7535553075016834e-03,-2.1656774617185043e-02,3.3460779488670755e-01,-4.7639897059344162e-02,1.9128519950828637e-01,3.8516549730015531e-02,-3.2786709478569508e-02,2.1053063601787596e-02,4.4333240890878436e-02,5.8811014491582089e-02,-1.3681320733224672e-03,-6.0031249709300433e-03,1.9313151718206267e-01,1.8262587132898853e-01,-4.9582589188258905e-03,1.7060674396888895e-01,-3.1123503767311059e-02,-1.4195849376556696e-01,8.0878191183620697e-04,-3.1251917375034993e-01,1.0573579052708110e-01,-7.5420391829707223e-02,-1.5328858193415819e-02,3.9772342001225605e-02,-6.3467221708145422e-02,-2.2634911953467673e-02,8.3749051615226569e-02,3.6446072749851816e-02,4.1175869692389033e-01,1.6870948206670333e-01,5.0884880358823409e-02,-2.8591720163921019e-01,-7.5887396479531683e-03,3.1652687632362654e-02,1.0565779875202271e-01,-1.1477526782101477e-01,-1.7303972021324718e-01,6.0813293783117568e-02,2.3170818412701677e-01,-1.4077604272010866e-01,-7.6277729778219325e-02,-2.5905440461164142e-01,-3.3763439863480980e-02,3.0169709717728553e-02,-1.7655659142124205e-01,-1.1623435428995596e-02,-4.5444831902346564e-02,-6.3346365679121497e-02,-4.5051050896691924e-02,1.0238914665409739e-01,-1.5304562107771533e-01,1.7764654086240109e-01,-1.6784884186260882e-01,-5.2188548238840837e-02,-3.1182677788579867e-02,9.9303767920954383e-02,4.5012352246231631e-02,7.5290692055681886e-03,-1.0904292636545282e-01,-3.9118991228386003e-03,1.8207528923054733e-01,1.0617603630069546e-01,7.1592072175928854e-03,9.6320777551192754e-02,-1.9340768815522433e-01,-2.3347385271814087e-02,5.6173368050359621e-02,6.0274431368500143e-03,-5.2503458782260058e-02,1.1021616419456526e-01,-3.0146431400588293e-02,2.6938514452489276e-01,-2.5762353688758299e-02,2.0072348904442472e-01,6.5273954990467634e-02,-3.9532942143341810e-03,5.0652754135914101e-02,6.2590828954310118e-02,1.0014520444503647e-01,-1.9260678731826988e-01,3.8596976783899489e-01,-2.7262628404806444e-01,-2.6708693105544035e-01,1.0015964293019743e-01,-1.1592398175625813e-01,-2.3886066606321160e-01,-1.0375119870223928e-01,1.4886107555853037e-01,7.7507343417392044e-02,-1.0408106785805045e-01,3.2180211538691217e-02,4.8636579217075225e-02,-1.7449873536026225e-01,-1.2826049046617247e-01,-2.5725438712921161e-01,-2.2765271296149961e-01,-8.7392284971646778e-02,-3.0078161764312328e-02,2.3929058358519863e-02,1.0181995778388125e-01,-1.4388177400205598e-01,-1.0482891997198493e-01,-1.2938353644206878e-02,-2.4741627470835995e-01,2.5317481829091073e-02,1.7250283275463335e-01,2.2515723566488169e-01,1.9394538266024450e-01,-6.8414512917255338e-02,1.9818198125969008e-01,5.8900331354428577e-02,-1.6051505250274983e-01,3.4298239592692112e-02,2.4731111206521095e-01,2.2564215238334584e-01,1.0355937030662886e-01,1.1981965046492922e-01,9.4193799537075393e-02,5.0624806264106901e-03,1.9698989875497624e-01,8.1120174107467496e-02,-3.9733569447197685e-02,-1.6945821633611854e-01,-3.1146347426233478e-01,2.2002907120139369e-02,1.5847683444893575e-02,8.7371218590200903e-02,-6.8023584227930978e-02,-3.7221904619396604e-02,9.1257308811967322e-02,-1.1304242021866040e-01,1.4017866545001406e-01,-2.8480325159290006e-02,1.3086965853432136e-01,2.7714369027005742e-01,-8.7555169040505726e-02,-1.9319794354629469e-01,1.6944913129520683e-01,5.7455104415636976e-02,-2.8970828408782772e-02,-2.2736562922974851e-01,6.7449604738487892e-02,-3.4773980711273283e-01,-6.4502311796943670e-02,-1.9072057958674289e-02,2.2570516770679228e-01,6.8596709949493323e-02,-1.1778091491005535e-01,-3.2454811261061714e-02,4.7010610202255138e-02,6.5966749366202365e-02,-1.2112876811624147e-01,-4.7495341670115744e-02,2.5910204169785057e-02,-7.7886242930208807e-02,-1.2166443908965206e-01,7.7494152845327489e-03,2.1862956015993758e-03,4.4623529168481238e-02,-2.0912780891032159e-01,1.7355709035092437e-01,7.4717808573711075e-02,1.9712888735328137e-02,1.2936345371714447e-01,9.3178408241052210e-02,-8.1430926167628287e-02,-2.9146977822816292e-03,-4.3198667103265150e-02,-1.7245639708425084e-01,-1.7754017493694424e-01,-7.9460753295133232e-02,1.2231782700385856e-01,4.3413679094905883e-01,9.8751102052001376e-03,-2.0255467253385606e-01,1.6015531348587278e-01,9.3803301592427876e-02,-2.0786063418188239e-01,-2.3330657477496963e-01,1.4369571034041137e-01,-5.6083857618418276e-02,-7.3922137252203743e-02,1.0283431157708296e-01,-2.9731413719096073e-02,1.4019865467278245e-01,-1.1009771833273131e-01,-1.7626452302978515e-01,3.3472971371717834e-02,2.3972332247154851e-01,1.8856775587906080e-01,9.8430408301326669e-02,1.4094622356156078e-01,5.5659047033182939e-02,-3.0875944450901038e-01,-1.0531078002287278e-01,2.8020158220644648e-01,-1.9393090701182145e-01,-4.7679334911414392e-02,-1.4857357243541244e-01,-1.3765222550869307e-02,-9.1582415636444772e-02,1.0276627119060944e-01,2.1294495822136855e-02,-7.8688117243391642e-02,-5.2561433838321410e-02,1.8042365329608270e-01,-1.2336949639153086e-01,-1.5955126329356081e-01,8.4975797690206578e-04,1.2073333114811130e-01,8.5117545150263263e-02,-1.1927137452451124e-02,-1.2126590468661269e-01,-6.7819043653703961e-02,3.9588408671002724e-02,-2.0095432204465082e-03,-6.0410983575505520e-02,4.2998950906229828e-02,1.6456985942115876e-01,-2.3481130894593505e-01,9.3476367367027968e-02,1.4685161481717401e-01,-9.2285198502928718e-03,-1.3360792836944665e-01,-2.1728331954663305e-01,1.7597769629896173e-01,1.1843743323132537e-01,8.5945851143973580e-03,2.5646037099938962e-01,-1.9670693967633873e-01,-1.2568846693266297e-01,6.2745210902390325e-02,-5.7169968941890942e-02,-4.7484326739118538e-03,-8.9943392409795125e-02,2.9462724752574848e-01,-6.9080164394956844e-02,5.8867824162821332e-02,-9.0808093751836072e-02,1.2236238504221541e-02,-1.8621751750092294e-01,2.8484351641777296e-02,-1.3594011240999024e-01,6.5733123427393937e-03,3.1107631993357334e-02,8.3334827882713666e-02,-1.8767545651022180e-01,-1.5826914176777765e-01,-6.5052409317267704e-02,5.7714185637403242e-02,7.9036434719803872e-02,-4.7554416812344749e-02,-6.3947512276032376e-02,6.7757430109973010e-02,5.2856794390625725e-02,-8.3561465979102578e-02,4.3175939033932582e-02,-9.8635646571590782e-02,9.8625299262381810e-02,5.4878881778983632e-02,2.4183472033022618e-01,-1.5717044140728172e-02,9.1239412906104239e-02,-1.1007100565169473e-01,2.5702340514823496e-01,3.9713292926818677e-01,-1.5661976368292754e-01,1.6474679797297428e-01,1.7100303389999186e-01,1.6771768324483494e-01,-1.4803569888127768e-01,3.6514258972137354e-03,-7.0929411581859322e-02,3.4280881126239865e-01,5.4245825841359160e-02,-1.0778236779943204e-01,9.9548331819276151e-02,3.9615051296877529e-01,-2.3345042214949971e-02,7.4420442125278763e-02,-2.0405486401533451e-01,1.4749854989050924e-04,-1.2305038278100916e-02,9.7447549267680539e-02,-8.2082851632823098e-02,1.8293459793417909e-02,-1.3450369171802984e-01,2.0342560034227708e-01,-2.2278752013575234e-02,9.9117235325774808e-02,-3.1721196655473273e-02,-6.6742403403044825e-02,1.7220637854676255e-01,9.8917050064173492e-02,-2.0687929711795416e-01,1.4485249486960478e-01,-6.7685668700456336e-02,-7.7434715248359848e-02,7.8545950941972226e-02,1.7901471438353357e-03,3.2815579221270719e-01,-2.0355644201915632e-01,1.0060927288322924e-01,-4.0081669235464884e-02,4.6244944650072541e-02,-2.3242403447051097e-01,2.0919614522679700e-01,1.2037473884599816e-01,1.9522632768318923e-01,1.4136841484014989e-01,-1.3346554633589722e-01,1.8132161414814249e-01,-2.4830311787027173e-02,2.9219482712374460e-02,-7.4674866919312535e-02,-9.3462395301522602e-02,1.1375324595831701e-01,3.7320469565324949e-03,-1.6156486513952800e-01,-4.8539881782426131e-02,-1.8200394366693566e-02,4.2875733697165241e-02,-1.9354179594053914e-01,-2.7812100097115010e-02,-5.4122726154394153e-02,2.1726639503171361e-01,-9.2553250527027085e-03,9.2062552487882268e-02,4.9157999778650228e-02,1.5087677627255444e-01,1.7211674226609913e-01,1.0747258197708076e-01,7.4880533637520189e-02,3.5048937760160692e-01,-2.3751990910480353e-01,1.1493720540511508e-01,-1.2350031999130026e-01,8.7011635065294718e-02,2.7404838027051254e-01,-1.5372555682222580e-01,-2.6639343961217266e-01,-1.9401049573689977e-01,1.2000896348051721e-01,1.0439416967432367e-02,-8.9244497284206151e-02,-1.0401824562164503e-02,1.4820680723565477e-01,-1.2307285815795620e-01,-1.8630352906117004e-03,-2.7143539796211424e-02,-2.9299389548545729e-01,-7.8603493066381931e-03,2.1044039794884040e-01,3.6917535313440841e-01,1.6734678229521696e-04,-1.8728477069975061e-01,-3.5471472645785027e-02,-1.3431174823329714e-01,1.3550484124054218e-01,5.5730407432437394e-02,-4.1290897110214518e-02,-7.2741810895286585e-02,-7.9192928019609504e-02,-1.3916072467726021e-01,3.0337555893823187e-01,-1.0050703348158943e-01,1.4427330843540825e-01,-9.5273933576800918e-02,1.0791816209600283e-01,-1.5995863564260951e-01,1.6502954124508701e-01,-1.1681045612049908e-01,-5.4073532913110040e-02,-1.1405076178941768e-02,3.8126733891470546e-02,-7.7779557380385819e-02,-2.1798503520969870e-01,4.4432892166696693e-02,-2.0898282913014342e-02,-2.0296836180661582e-03,7.8798988189436106e-03,1.7892274708210568e-01,-1.2752983011470978e-01,2.6524181629946950e-02,8.9414421965703428e-02,-8.2297567864642651e-02,-2.1536957092993103e-01,-4.3403025336553720e-02,3.1419153807214009e-03,-1.7983381396625595e-01,1.9628808404933300e-02,1.2516214192852174e-01,-4.8807922046230412e-02,-1.1798934221503118e-01,1.1746766391541666e-01,-5.0549144979739218e-02,6.5779194124574669e-02,2.7363960346296332e-02,-1.8775941657602480e-01,1.1887315120184083e-01,-9.8024788167305393e-02,-9.6713218432046527e-02,2.1053313908724547e-01,-2.3566468226776685e-01,3.0369186184982855e-01,-2.9906733847524035e-02,-1.9841122062118438e-02,1.0790687748438531e-01,-1.3546249735044713e-01,-2.1281910770069301e-01,1.1441470386502106e-01,1.8746641115628543e-01,-2.6211280441029473e-02,-1.0606155977635293e-01,3.8725154761077622e-02,-2.6050936623023459e-03,-2.3622677816917942e-01,-1.0569034428215335e-01,-2.7233378530149782e-01,4.1320163470789796e-02,1.5778414872419760e-01,2.6863114477903988e-02,-7.9001552032101404e-03,4.0425086483615279e-03,1.3256920002505995e-01,-7.9857170113317624e-02,-1.9001651364863186e-02,1.1152162758523151e-01,-9.4874183422484631e-02,-1.0231188705069566e-02,1.7214429775360357e-01,3.7083373488875881e-01,-9.8061888942840889e-02,-1.2634219486668880e-01,-1.8651187499333055e-01,1.5809656843934111e-01,-2.7824088866666659e-02,5.7256956563518431e-02,2.1742141139412208e-01,2.4435949694199063e-01,2.1525484079407464e-01,-2.3253019801386252e-01,5.5451748766541721e-02,-6.3051336389516474e-02,2.7181461133005230e-01,7.7462409607440011e-02,7.9398518690660308e-02,-2.0017580340462809e-01,5.5704492153339689e-02,-1.3701796310915362e-01,1.5181966984890691e-02,-1.0034661022281145e-01,-7.1044599672526521e-02,3.1557768994090211e-03,2.1502768718224799e-01,1.3001017738708526e-01,2.8445862943793276e-01,1.7378216178039887e-02,-4.0449419317128962e-02,9.0384067550888098e-03,-1.2801819351295191e-01,2.8440614522086449e-01,1.4946526273404570e-01,1.2173287838288704e-01,1.7427183305094571e-01,-3.7251356224518046e-03,-2.6328463126421636e-01,1.3821379850979737e-01,2.1498033827387775e-01,5.4549425170917695e-02,2.4913537302280629e-03,-2.2047547058439934e-01,3.3601877599181339e-02,4.7634640189563038e-04,-1.9905905836845458e-01,1.7559199329951619e-02,-7.2401825183467577e-02,-7.7251565044980056e-02,-7.2728159985377960e-02,5.3974410179712471e-03,1.2349415683944673e-01,-1.3742910298408413e-02,-9.1523197605596796e-02,-1.2856514740002717e-01,-9.5515106980638090e-03,-1.5121107842106021e-01,5.5992893536030305e-02,6.5991334553376677e-02,4.2180685761699687e-03,4.6224979819066626e-02,2.6903106983267122e-01,-1.7394560915617385e-01,7.0069082218393891e-02,-9.9041075748194166e-03,-5.5044558489803198e-02,-6.1306680067906141e-02,-1.1603252323197724e-01,-2.9059665520847533e-01,-1.2482706660016120e-01,-5.0380676141915604e-02,1.9748708549063632e-02,-7.9357570453336496e-02,6.9668418811103056e-02,-5.7059182017769570e-02,8.2847285318280069e-03,-2.6235488291615211e-01,-1.5289677171597640e-01,2.5352803515020568e-02,-1.3156770728430939e-03,-2.2216098282137808e-01,-9.9194495846626235e-02,-2.1715754068972418e-01,-2.8582434203548163e-01,1.4473353728311766e-01,-1.1515738945920323e-01,2.8966897830991895e-01,6.1142002508034504e-02,-1.8043659485173585e-01,-6.4153790081754952e-02,5.7633080211015916e-02,8.7515146624390708e-02,-1.2349917295709492e-01,-5.8877817675403968e-02,2.2798302440540941e-01,-2.0892748289117014e-01,-2.4088336951307448e-02,1.6811075050119564e-01,-1.3142999000203792e-01,-1.2120628830929055e-01,-9.9681737107235151e-03,5.8057634089483442e-03,-2.6996893870095726e-02,-2.6262977893404299e-01,5.1892127541545065e-03,1.7081454050994266e-01,1.4292304238114181e-01,-7.8929307958585920e-03,5.7555010742676084e-02,-5.2917978268381231e-02,1.0268826850790091e-01,-9.9573118601298471e-02,1.6846927321356667e-01,2.8703343807875076e-01,-8.9589415246320650e-02,-5.1918119359849080e-02,-1.2508897263793278e-01,2.4731530598753149e-01,-1.2749327959667497e-01,-1.7762430102280086e-01,9.8340169053613799e-02,-2.1863108625850927e-01,7.8038922263270347e-02,-1.2473976737221125e-01,1.2634214122235468e-01,-4.6057563523399819e-02,-4.0046028568166581e-02,1.2174588278972925e-02,2.1540420359043811e-03,-1.3346129866291406e-01,1.8338843026191487e-02,-1.0735406881929417e-01,1.9466136657300117e-03,9.0667887626683125e-02,-2.8133973260937670e-02,-1.7830270621930189e-01,-1.3570174585232486e-01,-2.2940963908351444e-01,1.8065626048957018e-01,-7.2932720914832494e-02,2.1379532127931280e-02,2.3502022478295811e-01,2.0057378973641396e-01,-2.1830603925365000e-01,1.5135528371816440e-01,-1.3922167040605177e-01,8.9326222359159421e-02,1.9151627690321740e-01,2.4953303347443820e-05,-8.2535436042298599e-02,4.0339597883087408e-01,-1.8456429950396347e-01,-5.6182967396699784e-02,1.2938295750161369e-02,-1.5252926721613599e-02,1.2259155520195747e-02,-1.0476682577277194e-01,1.2282013370178951e-01,-1.8226607541743090e-02,1.3095809708147063e-01,-1.0707297004421967e-01,1.9470493423024743e-01,5.2901643167577478e-02,-1.4312205831839928e-01,6.6237248995288447e-02,-4.4233095457827290e-02,2.4164896655215778e-01,1.8246896765361897e-01,-2.6559167087507646e-01,-6.4280900529769952e-02,2.4185937259129950e-01,9.4719294413561944e-02,-8.3146042938407938e-02,8.9251361062066006e-02,-3.8473217736378157e-02,1.1515667791590115e-01,9.4045933856748212e-03,5.6552931730097247e-02,-6.0228882947238632e-02,2.8270918244501980e-02,1.8671776921974359e-01,1.2890935773307430e-01,-2.8860982018596248e-01,3.0757942349762546e-01,-3.6760496614118239e-02,-2.2436805749958333e-01,-1.3829286732188392e-01,1.1427768694529473e-01,-1.2177897713015766e-01,-1.0282650300850273e-01,-4.9891908508491560e-03,-1.5620868760749912e-01,-4.6170952123106526e-02,-1.5061418398764398e-01,-5.3464060378926918e-02,-1.0968271987297813e-01,-3.7317154775424875e-02,-1.9101818811340693e-01,7.6343971912846642e-02,-4.2477584903636484e-02,3.3146329843033234e-03,-2.2134802968455014e-01,-3.8054679255920654e-02,-1.8726976323151676e-01,-2.2510469838781352e-01,-1.7026724620404965e-01,-6.1456027868665761e-02,-3.9733675509536187e-02,-2.5074307840389248e-02,-1.9233161893418248e-02,-9.8629942843331923e-03,1.1078741811850978e-01,-4.2033638067966644e-02,2.4969695146160167e-01,-8.6985394610500796e-02,-5.3553933294779935e-02,-2.8951584430577746e-02,1.4170377926580929e-01,1.3212011012554081e-01,-1.2329532072502306e-01,-1.5028512669401867e-01,2.3457227433085412e-01,-4.7065094895566408e-02,1.8347730251178598e-01,-1.5171983432988614e-01,-9.4920403092822042e-03,1.5992107746611661e-01,9.5354267468600262e-02,-3.7695309446780445e-01,1.6970614313808699e-01,5.4571680418862525e-02,2.4526265126893376e-01,-1.3737474693700816e-01,1.0563739524407341e-01,-4.0963350641379778e-02,6.0781156214542390e-03,-1.0841851648983195e-02,6.0721477621320449e-02,2.1028700831186173e-01,-1.0061193066735740e-02,6.2217288475917773e-03,1.0226573538334036e-01,1.7198371368447254e-01,9.8358353638310234e-02,4.7880035530561013e-02,5.1602908136086784e-03,-1.2268677641692217e-01,-1.1721246400519947e-01,4.4340467518671656e-02,-3.0348462621116379e-01,1.0194838897884409e-01,2.4074152781716554e-01,-1.0586496783579470e-01,-3.3281611450083286e-02,3.3182782648742845e-02,2.9437189630330440e-01,1.6856214469914027e-01,3.6288656633760752e-01,4.6278810234364601e-02,9.0745906068605803e-02,1.0614557209297017e-01,-5.2794183928417684e-02,1.4892824255843179e-01,-1.8074480254300443e-01,-1.1366871631187667e-01,8.8212759025621784e-02,1.1754382990805442e-02,-2.5829817490819876e-02,5.0904220433925215e-02,-2.7959042302207634e-02,1.0806666374076238e-02,1.2705277236427684e-01,3.5316805290629005e-01,1.0467859146798163e-01,8.8490045958665262e-02,3.7789536253689721e-01,-1.3423056194701555e-01,1.9131541708930137e-03,2.2811062799292181e-01,2.4350887924778791e-01,-2.2125311117470833e-02,2.3920347899389144e-01,7.2874562134787241e-02,-8.9842587984428901e-02,-1.0527822785455698e-01,4.4226545210904793e-02,-3.2353474840649751e-02,3.1246984335122324e-02,-4.1758729237547920e-02,9.6632690482927386e-02,-5.9864124105321145e-02,1.6787478810564518e-01,1.0881607888932873e-01,-2.3772989443689346e-01,-1.2618206286979824e-01,-8.3055363331560453e-02,-1.0432835571414485e-01,1.1553455580074425e-01,-1.0366296145542468e-01,-1.2106550563391967e-01,-8.4502300348100121e-03,1.1262292168614858e-01,-1.5949011495388010e-01,-8.8685193399997003e-03,1.1211657685204335e-01,4.6195055186884569e-02,-9.7129860621300412e-02,5.6505068781799922e-02,-1.4291861475769571e-01,-4.8218472707189403e-02,-1.0227494776837799e-01,1.0998443521611767e-01,-4.1971576632042963e-02,-1.9645165967599815e-02,-1.9178674584286529e-01,-6.2559037122140448e-02,6.0972474672600280e-02,-7.1261353294191435e-02,3.2030131831031106e-01,-1.4973034502611252e-01,1.0590515519523208e-01,3.7375606007971116e-02,-1.8267894047650265e-01,-2.4176868084501735e-01,1.5801342724750353e-01,1.2766165752037279e-03,-1.1262767899276740e-01,1.9383953065621365e-01,-1.3890642964273889e-01,-2.0816462923353857e-01,1.4480611854333628e-01,3.9623469377796948e-02,5.2571476638493507e-02,-1.1675158087539593e-01,-2.4627251019017002e-01,6.8168596053198000e-02,3.2684485009896430e-01,4.5040780664001502e-02,-4.2809025257222397e-02,-2.2664635344783579e-01,-1.3073167932063995e-01,2.2324226705072719e-01,-1.9365321250962980e-01,4.9430421577860532e-03,-1.2220175505778738e-01,-1.2710503525554892e-01,9.0839665825212107e-02,-1.1632720676822339e-01,-3.6991332237896433e-02,-4.3511284763229192e-02,6.9007116999318469e-02,2.2460104872130317e-02,-2.1717500189021671e-01,-6.4066953373580954e-02,2.5861441991012125e-02,-1.2920677963123459e-01,-1.7827005376296839e-01,7.3781204143447243e-02,1.9975770867955667e-01,-1.3296729807929326e-02,7.0556119834699796e-02,-8.0534635473790070e-04,4.8316532701616226e-02,1.1779079869926064e-01,-1.2553316890690169e-01,1.2791858432648784e-01,-2.0519952869474081e-01,-1.8416588691024588e-01,-3.6227835499027299e-02,-5.2590409519055609e-02,-2.1720206357567284e-02,6.4321739864979868e-02,-9.1841801651025234e-02,1.1068949569430042e-01,-3.6941701292295612e-02,-8.5711362768664992e-02,-1.5636455277638484e-01,6.5828429828221471e-02,9.7295021503451887e-02,1.0876311866189109e-01,-9.1920167669226130e-02,3.7071838368755015e-02,-1.4523601087506832e-01,2.2157835430112541e-01,-1.1148399857968096e-01,-1.2980144762686385e-01,7.4818381907273898e-02,-1.4424636319962100e-01,2.4289252092780717e-01,-1.6320041093979229e-01,-3.0434815147886307e-01,-1.9753742720114952e-03,2.4578825318050369e-02,-9.9008685275750290e-04,3.8886789141846734e-02,1.8607209239281100e-01,2.5214361345837860e-01,-8.4847392941094363e-02,4.0962794864430399e-03,1.0265041303894898e-01,-3.7231452337644494e-01,-5.0436394798709115e-02,1.0285238871734734e-01,-7.8790485526730847e-02,-4.2359957965534760e-02,1.7782257765003942e-01,-3.3702557525653343e-01,-5.6183528255708479e-02,8.2358540041513134e-02,-1.9901396304216634e-01,4.1967952962938876e-03,-4.7957650581306029e-02,-1.1608004589074665e-01,-2.1033186140039031e-01,-6.0866526952868358e-02,-5.2712910910082894e-03,2.8868765469990780e-02,-4.4246343273858506e-02,2.3931895818319213e-02,2.4276730067817859e-01,-1.0184578951840831e-01,-1.4989884878192038e-02,1.7902897906830084e-02,1.7003392719134613e-01,2.0456638320638543e-01,4.3542666264177257e-02,-9.3569967484164240e-02,1.1795006498268325e-01,-7.2279325251046134e-02,-3.9507430849483888e-01,3.3338544240322621e-02,-8.2350714406100117e-02,-2.9238780797634666e-02,5.3111379582487447e-02,-2.4755128572632917e-01,-5.8709347754131058e-02,-4.9426761468280234e-02,-1.8348330099446608e-01,-6.1638424125663754e-02,6.4833626126169108e-02,-3.0124993738168612e-02,-2.7619820718600246e-01,1.6748962637277334e-01,-1.9512146482084125e-01,-1.7295855145473632e-01,4.8614838613368468e-02,1.7480670753063351e-01,9.2674487484986787e-02,2.0994784176102167e-02,-1.1328039467968465e-01,3.2649385320283143e-02,1.0095741332234442e-01,-8.7580473835934647e-02,-2.6164384916401567e-01,-4.1566293208573392e-02,2.4311833953255754e-01,2.4535026557630507e-01,1.2817489166229834e-01,-2.6557317077996846e-02,1.1196759901535994e-01,-5.0369967063721287e-02,-1.9231741577959305e-01,-1.4056418012758115e-01,1.6850266284106574e-01,8.5373920384394494e-02,4.5624657435675973e-02,3.6199544297853617e-02,-3.7110100699934173e-02,1.7813041539731855e-01,3.2860517180104298e-01,3.1837325444369902e-04,-8.3115490305569251e-02,-2.6116852453293832e-01,-8.0977731366260880e-02,-1.1206025919930128e-01,1.1307743708453044e-01,-2.5691030726935148e-02,1.1485678197907537e-01,-4.4472591037993982e-03,2.8449232965223692e-01,1.2671375209502275e-01,-2.5147160659680735e-02,6.7898752696129203e-02,5.4612990099343055e-02,4.0278991552027361e-02,-1.1321803147153806e-01,1.0787934940339754e-01,-1.4625205882436812e-01,-2.6498277796314146e-01,-3.7427764497282045e-03,5.4335064925281985e-02,2.4962359221481631e-01,2.8021452035559952e-01,1.5481101632874200e-01,-6.7090867728545972e-02,5.3748651799727862e-02,7.2111606385510084e-05,2.0996237238105342e-01,2.7772972511264600e-02,-4.2721842255610487e-02,-7.8276335270027392e-02,-2.7654363034223634e-01,-6.3132372051936725e-02,-2.0442789041325998e-01,-1.6306954784483463e-01,2.2848480134838707e-02,9.8809152630433286e-02,-1.2775052076995788e-01,1.1099185882666880e-01,1.1610452985144321e-01,-2.8381192645686684e-02,-2.5846141814662033e-01,-5.0326657026172311e-02,-1.5162045739155369e-01,-2.3427538770259979e-01,-5.8591772515610603e-02,-6.5672307447833950e-02,3.0410655595227459e-01,-9.0255986905647456e-02,6.5625806769582462e-02,-1.2569623845783873e-01,5.4313103445004188e-02,1.9481996920167780e-02,-1.2077768097558259e-01,-1.6885569256611871e-01,1.4544748622103112e-01,-1.1137717648284262e-01,-7.7658841859869904e-02,-1.0000418483958647e-01,-7.9721961034997131e-03,3.7231009033892037e-02,-1.5665903992712649e-01,-2.2278732814869345e-01,-3.0264156791340400e-03,-8.2648921048775206e-02,-3.3883081909412455e-01,2.2018785765229601e-01,-2.0287114286678420e-01,-5.3855988412186723e-02,1.4814448164154190e-01,1.2163370979411244e-01,9.0187083034499349e-02,-1.2424898762409486e-01,-1.0140394114742962e-02,-9.7468173289004090e-02,-5.9048022054992043e-03,1.0803895577067507e-02,-1.5692128417767862e-01,-2.7811315188854858e-03,-5.7234386850199305e-02,-1.8854285384211850e-01,6.2011239687587379e-02,-8.0821641553148346e-02,3.6051501274799208e-01,1.2184723486021559e-01,-6.3187086761573821e-02,5.3316098880355718e-02,1.6509851557234674e-02,1.8617824236772257e-01,-8.6185341427421069e-02,-1.8196976816449800e-01,-8.7965201825132497e-02,-1.4807645841343874e-04,1.5691905995620387e-01,4.6088360577028170e-02,6.6092366077421527e-02,1.2621099063721541e-01,-1.2622665844355380e-01,2.1944183058152050e-01,-3.4764132644604366e-02,3.7723470127259656e-01,2.0967745925799950e-02,-5.7171456079389997e-02,-1.4963763361584120e-01,-8.8745106054952505e-02,-3.3910908749471357e-02,4.5125971177451027e-02,-1.3351632065720967e-02,-1.2602511466876307e-01,1.3595082635104083e-01,-1.4434964065437611e-01,1.2546792884469052e-01,8.0504015364017009e-02,7.9253074444451760e-02,-2.1845079992515878e-01,-3.2285278313058607e-02,-1.8930111076495582e-01,1.5941165132018520e-01,1.4427230024724425e-01,2.2107637851944692e-01,1.1973349344158373e-02,7.5150655540557151e-02,-1.8036954170362507e-01,-2.1580947930089972e-01,1.3720942367394190e-01,3.1517708041758624e-01,8.5075345022770713e-02,-2.9929752686440408e-02,-9.6480799581552659e-02,2.7386244783201424e-01,1.0864675479838397e-01,4.1482531650737869e-02,7.6678437867670798e-02,-1.9262225862063526e-01,-3.3701183099261123e-02,5.9259115989518232e-02,-6.8808262144653146e-02,-8.7018932313770558e-02,-3.3792934125848842e-02,-6.7874181679833306e-02,2.3790508605018270e-02,-1.1636497845355162e-01,-1.1043505672246064e-01,-1.3555173259214104e-01,-1.2713616407852626e-01,1.1676510521508333e-01,1.2124788864176914e-01,1.1537051025971658e-01,7.2560008573804374e-02,1.2522113160008291e-01,2.0120745805066687e-01,-1.1437042531635520e-01,-8.0379564926225614e-03,2.3356917029031740e-01,-2.6607733063441891e-01,1.4254503796897044e-01,7.4409951078621339e-03,2.9842578555314569e-01,-4.5369956217060803e-02,-1.6899483054944275e-01,-1.1802052865505713e-01,9.3452219622907687e-02,9.6163672963249042e-02,-1.0150965004779196e-02,-1.2365268289019000e-01,-1.4586054202249676e-01,1.5856550091825281e-01,6.5594523667969473e-02,1.0730403575378052e-01,1.3069734071717773e-01,7.3606310429663646e-02,1.2069949642245958e-01,8.2936846936968497e-02,-1.7275139822054786e-01,-1.1913397297069381e-01,-3.0951327553623259e-01,1.8274501501263921e-01,1.2451154553020602e-01,1.5887179345549168e-01,4.7157796155726135e-02,-5.9197324361668996e-02,5.6614353397973431e-02,-3.0388802325059715e-02,3.0470554120710464e-01,-2.6819152597684109e-01,-1.3676793747161475e-02,-4.4069537873937858e-02,-7.0475623330801040e-02,7.5049314716622628e-02,2.8416784911284260e-01,9.9798960021526453e-02,-2.3098099866384128e-03,-4.4658240390034555e-02,1.6131831452879256e-01,1.6283710783685962e-01,-1.1209605143180540e-01,3.9417449140237197e-02,-2.9302412547590161e-02,-2.6290812015330600e-01,6.5041041693804008e-02,-2.3258556408979325e-01,3.1203580021803401e-02,7.7223709223131459e-02,1.5537480868325065e-01,1.1926241500808847e-01,-8.9758063323248802e-02,1.8108859224669629e-01,3.1029993990905193e-03,9.6503589149737525e-03,1.5335594774090555e-01,-1.1804257865988335e-01,2.7604913957312471e-01,2.8932769271902473e-02,1.8641846858594538e-01,2.7803013960929594e-03,1.4080595801999243e-01,2.3895515346189869e-01,1.0243440811266364e-03,1.7149118792680412e-01,-8.7910916966203734e-02,1.1197486977981932e-01,6.9458420171939900e-02,-3.5504809091219286e-01,-1.6672656086979173e-01,3.3469781808333945e-02,-7.4122413934105777e-02,9.7533307049399443e-04,-1.1773931347947993e-02,-1.2968308611938681e-01,1.8245204332964826e-01,-1.0177645133404847e-01,-2.0806868336241879e-01,1.2741692388921366e-01,8.4983457881288693e-02,-2.0848192300841822e-01,-3.0351180304046200e-02,5.0797108823539883e-02,2.1868179970181867e-01,9.8811728739421928e-02,2.5475354820448726e-01,-1.5275732636311337e-02,7.8063476893865710e-02,-1.5293033190943792e-01,-2.0139327360456347e-01,-1.8388890973237659e-01,-2.0131945744845108e-02,6.5499642638965683e-02,-3.5248015346312014e-02,-2.5451822492517730e-02,-5.0978904108474894e-02,3.4618959292920568e-02,-1.8712457218052633e-01,1.0637721579071936e-01,1.4671277586085879e-01,7.2553363145352157e-02,-1.3231771530127345e-02,2.6451150143806543e-02,-3.2035350307736785e-02,3.5926666502504763e-02,-8.4859592365469388e-02,1.3868964648765564e-01,1.8386849675955438e-01,5.9602646468257220e-02,1.3554724140303498e-01,4.8589277048415883e-02,7.4132409036973435e-02,1.1074095684231064e-01,-3.5218157261048780e-02,-2.6551202617202357e-01,1.1208117639220205e-01,-2.6655533518065189e-01,1.9822720135868921e-01,1.5698888732334024e-01,4.0507904741908317e-02,-1.0759578444152010e-01,1.9822402170570103e-01,2.0552405453027306e-01,-1.3299165034814120e-01,-2.2926438610247629e-01,-5.8684222711987234e-02,2.6610790162265024e-01,1.9376523812122813e-02,6.3428475266629564e-02,-2.1741640044698099e-02,-1.4777127309130852e-01,3.1379858308148934e-01,2.6777042726688089e-02,-1.3983973131797642e-01,2.5005032986268055e-01,-2.7231501737192970e-01,1.8887166044011264e-01,-2.2447607807416052e-03,8.8515300618526901e-02,2.6751448641068365e-01,-1.4671447885609432e-01,-6.3773270570117141e-02,-1.5592879108717544e-02,1.7879205581680369e-01,-1.4810205023567655e-01,-1.2068117154896710e-01,-2.0891830120917879e-01,-8.8913608971215082e-03,9.7130029674421345e-02,-3.6327162830410355e-02,-1.0930634887281200e-01,-1.9719991262938399e-01,-3.7345944600856072e-02,2.0279359225858709e-01,2.1584006586833876e-01,2.3862678916585365e-02,-6.5204005404763954e-03,-1.7542271178550516e-02,-5.8656718836712161e-02,1.8198205245759475e-01,-9.1863465859209043e-02,-3.8415058622368048e-01,6.6454317695277057e-02,-1.0357098713504204e-01,-7.9257728787270734e-02,1.2512314483630047e-01,-1.5831920833408650e-01,1.4758715669878830e-01,-2.4308540797426111e-02,-6.0254282782571583e-02,8.6311454416962710e-02,7.6794308052482163e-02,2.4587410559670994e-01,-1.8868140440489606e-01,-2.1819808161893613e-02,-1.0435447531442313e-01,-5.3091897839943739e-02,-2.8841001139823779e-03,-7.7381917011257004e-02,-5.8912643825244013e-02,1.2773922031029175e-01,-9.3349032407543678e-02,1.5587374980886668e-02,-1.0771501284910905e-01,-1.9833012876884967e-01,2.4914485329857697e-02,1.8432754459147588e-01,-9.7982404501875009e-02,-1.2865380022475173e-01,1.7865970966769902e-03,2.3899389702881021e-01,-1.1129354854236438e-01,1.0354056943834167e-01,-7.5017979965853313e-02,-4.5237592650203613e-02,1.3046974111014401e-01,-8.9511278439055889e-02,-1.7523145154862685e-01,-1.9567046745224273e-01,1.9839306794142433e-02,2.2840794341975466e-02,3.2331081885363412e-02,2.6143818236090844e-03,1.7434624200067844e-01,-2.6060049129096062e-02,-2.0479895465281639e-01,5.4772836212650194e-02,1.8724685649892239e-01,1.4532923685681737e-02,1.7942884104522216e-01,-1.8986031296774980e-01,2.9235666493006084e-02,-2.8480579019933453e-02,2.5872857395473836e-01,-7.3473702748438577e-02,2.9578389895094211e-02,1.5929500027554513e-01,-1.3457022361800811e-01,1.5731329057654236e-01,2.1441034798793973e-01,8.8419741013541928e-02,-8.4778402281254148e-02,1.0231994504520751e-01,-1.4335461182756834e-01,-2.6838998954232474e-01,1.9002910183568111e-01,8.9457726846634361e-02,1.8306208496792292e-01,-1.1025746213486867e-01,-7.8890991191838136e-02,3.3396210295992829e-01,-9.7877705578100327e-02,2.4994845654811790e-02,4.2386569753035935e-03,2.7741094795022989e-02,-4.4064504109926447e-02,-2.5721115131522441e-02,-6.3063789277362531e-02,1.0548857378809957e-01,4.3171927161001072e-02,-1.7093859690598698e-01,1.5140863309141223e-01,1.7095168691899526e-01,1.3518164966046170e-01,-2.6411858182781400e-01,3.5597788709914396e-02,1.5346928081016867e-01,6.4165314219967060e-02,1.0885576644894619e-01,-4.6819405787336218e-02,9.0522374123094149e-02,1.7635823331331574e-01,5.8806107377725528e-02,3.8177471923735322e-02,1.8881972375725378e-02,-2.1749232437209446e-02,1.2085534868957257e-01,2.5912463365549770e-01,-2.0920640620189460e-01,-4.3502708915261548e-03,-1.0120736298841472e-01,3.6749435873738003e-02,3.5378622764157042e-02,-1.4138020944250629e-01,8.4587437122580239e-02,-2.0736851864508857e-01,2.2066812292664933e-01,-1.7999049290198493e-01,-1.1276096583138115e-01,7.9538432700905798e-02,-3.6752202384314375e-01,2.4380603901376835e-02,1.0682680990836732e-01,-1.5692026589621932e-01,2.0848324587255634e-01,-3.9718405552602212e-02,7.9471640367459198e-02,2.5920692627173686e-01,1.3534748419516676e-01,-3.1975886286610211e-01,1.3295647612302289e-02,2.6725949337543076e-02,-4.3039686665534448e-02,3.3034537683631432e-02,6.9599191184934045e-02,1.1197937904480033e-01,-1.2871343158954845e-01,-8.7751754640428017e-02,-1.2924062413362383e-02,1.5425921463118483e-01,-1.4782540716014486e-01,4.9119931339059481e-02,1.4061869954575962e-01,5.7709844665324965e-03,-1.9986686135126380e-01,8.8702598091937257e-02,-8.8470455461021544e-03,-1.5957442035179581e-01,-6.9425861189604685e-02,4.3127616646822166e-02,1.5524540176962620e-01,-1.4341632806687338e-01,-1.3752491234538780e-01,-2.7783271714085472e-01,1.5830253625270135e-01,-9.5913217753441207e-02,-9.2841739813954036e-02,-4.8900943943358199e-02,-1.5632715395353419e-01,9.2877417863860990e-03,-8.0211917159385901e-02,1.2016406268782587e-01,-2.9607418685042647e-01,1.3593184906110502e-02,1.6815041099605929e-01,2.3582680294447589e-01,1.5748895401938878e-01,-6.9324165361650841e-02,1.4032712170277428e-01,9.1069644865763133e-02,2.0309174618639406e-01,4.4681912124000446e-02,7.9977361059133445e-02,-1.4256897668858390e-01,-2.5167470699789807e-03,-1.8280462238569897e-01,-2.2541238688550924e-01,2.1778713470466202e-01,7.8192740469189170e-02,3.0253080933958648e-01,-1.8628103770602816e-01,-1.8488154730967252e-02,1.1876287667223348e-01,-1.2749788651829017e-01,6.9627567701349036e-02,-2.6003711440211120e-02,-1.1159793444998165e-01,-1.8682432867821691e-01,1.0372635686177173e-01,8.5652016348170851e-02,-1.3667333165413881e-02,7.6774328301574213e-02,-1.6012310647192621e-02,1.5337209777194871e-01,-2.0466818176410320e-01,3.7248811735191062e-01,1.3017331329552220e-01,-1.9964130565863336e-01,-1.8480953898578423e-01,6.5838013765073880e-03,2.5100020713963472e-02,1.3994802777245724e-01,-1.6604656485391439e-01,1.4877106420815991e-01,1.4702862111757031e-01,2.3041439775458628e-01,-6.0118320144806350e-02,5.2318329647770452e-02,3.7999318008184083e-02,-8.2952540350019102e-02,7.5312579125100226e-02,-1.9355461462197032e-02,5.2526368027884671e-02,8.9133030429593071e-02,5.8296448700108333e-02,-1.3032572051546037e-04,-8.1678616158358711e-02,2.3726876093446184e-01,-2.5968854909185313e-02,2.9976608937778637e-01,-1.1493915718109432e-01,2.1699829669360654e-01,-2.3378081479809815e-01,1.2182642894920036e-01,-1.4104821043241803e-02,-2.0635501002259145e-02,8.4204693935910083e-02,-2.3948033814134384e-01,-5.9207156095100369e-02,7.8031744456708671e-02,1.4793487230974600e-01,1.3935038296467156e-01,1.8043629825948687e-01,-2.0331912534661314e-01,1.5828632418729222e-01,1.2570328684159615e-01,3.5446448525188434e-01,1.8838650124190937e-03,-1.4311262477892522e-03,-1.1061734940946799e-01,2.2243938962776051e-02,4.5506599929698111e-01,-1.8608175577651748e-01,3.6554610252854662e-02,1.9215880093305535e-02,-7.8201597267978512e-02,1.4111337819440681e-01,1.1924969120820998e-01,1.2840342846396258e-01,-2.8152740903788470e-01,6.6427404223386846e-02,-8.2568014893325464e-02,-8.0070440150048341e-02,-9.9391964392155238e-02,1.2430998785158233e-01,-1.2092891651741507e-01,1.9823801144056900e-02,-6.2879367362730684e-02,-1.7366975912627580e-01,1.5767200035276976e-01,-1.5804875186870720e-01,-5.3346115966375257e-02,2.8986709430624640e-03,1.6202626982763907e-01,4.2987091325003626e-02,-3.6836649467816882e-02,4.2524228948643543e-02,7.2520657002294389e-02,3.3148104123056306e-02,4.5990862157983682e-02,-3.2393944812578179e-02,-1.4783149540762699e-01,-2.8337003807155237e-01,-7.6851206916598191e-02,-1.5305000274179634e-01,6.3597169493656777e-02,1.8677547974634348e-01,-5.0466893241621395e-02,-2.5595021970403174e-02,1.0682204690648944e-01,-1.5339860351906071e-01,7.0837167930284398e-02,-2.9167551999340458e-02,-6.4511113568267275e-02,-1.4905830489677552e-01,-2.3241625576557259e-02,7.4772107984368952e-02,2.2743965466674229e-01,-2.2866802799860725e-01,7.6143079015410465e-03,-1.6836071237925138e-01,-2.1880956456977688e-02,8.0201003832850851e-02,1.9606992303103254e-01,-1.1197948186552184e-02,5.4733348524056612e-02,-6.5381552469650162e-02,-9.5926451317657563e-02,1.4504811264021097e-01,-1.1740870885584728e-01,-2.6600051244719793e-02,7.2345092526879068e-02,-1.3008525159117712e-01,-1.2002147009285270e-01,-7.1384556464709772e-02,-2.3677722387835401e-01,-5.0768714432791497e-02,6.1940715828625814e-02,-9.7050585928108064e-03,-1.0747708150625056e-01,-8.8676028595891632e-02,3.8451806552246323e-02,2.1483407257181308e-01,-2.8813904006058311e-01,-2.2230994643356077e-02,6.0126891476471198e-02,8.1169562338376577e-02,2.3702066879956610e-01,-2.4549037313083617e-02,1.6220500741454902e-01,2.9474380247045329e-01,2.6612177865165937e-01,-1.9444799408239438e-01,1.0393175240143496e-01,1.3360076000592114e-01,3.3309953818646687e-01,-1.8598673660592577e-02,7.5116367617340626e-02,8.0824023766781466e-02,-3.9302122131038959e-02,-5.6783436895275650e-04,-1.6015603582362853e-01,-1.2111064942596605e-01,2.1582694261342683e-01,-2.0823500465577427e-01,5.0943358092308079e-02,8.2669445141458048e-02,2.6396886006776332e-01,8.2977799096235025e-02,2.1460328678839805e-02,-1.9305416144554843e-01,-4.0401331693257138e-02,-1.1090541426166922e-01,8.5849734457819321e-02,-3.1966926294293696e-01,-9.6218252654507952e-02,1.8498021221780606e-01,5.7689831622813596e-02,-7.2565906051496085e-02,4.4987129637093486e-03,8.8647775450925018e-02,5.3386605875249925e-02,2.3104012405808719e-01,1.3937664056071558e-01,-7.8736062417030683e-02,6.1887879144078048e-02,2.3737649142314687e-01,1.9243314366156594e-01,2.6515858401282943e-01,2.5686374589043704e-02,-7.5716245978727836e-02,-1.4739979811472531e-01,-2.8794481527926202e-01,7.9775927476010366e-02,8.8849535718841383e-02,1.6886856647605586e-01,1.8703126429023928e-02,1.7151165364235244e-01,7.4689525386844174e-02,-9.3455040456791177e-02,9.6994779210407153e-02,-1.1422954618412358e-01,-3.0773175288483495e-01,-3.8193774860518392e-02,-2.4941122316207275e-02,-1.1322175818487126e-01,-6.5823775210741009e-02,-4.5349409831303443e-02,9.0321756956895892e-03,-2.2122081861670344e-02,3.9581382800713098e-02,-1.1544340440068943e-01,-4.1549250674752250e-02,-9.3876370555359516e-03,8.9891070156471020e-02,-1.5028215893908808e-01,-2.4995559813037260e-01,7.7720061168609494e-02,-2.2606752557985382e-01,-2.1443649898082795e-01,-1.7314937967523891e-01,2.3229649179525080e-01,-3.1582242633195839e-02,-1.0153860914971194e-01,-1.6732331240152917e-01,7.9243370899145835e-02,-1.8782105935932272e-01,9.7289434106286654e-02,1.0679630036698366e-01,9.0454802543315227e-03,-1.8184585449776461e-01,2.0678330208526257e-02,2.7029334512978787e-01,-5.0910279732790886e-02,-5.2821247850441899e-02,-6.8091462144269657e-02,2.1257678798449253e-01,-9.8151083690359409e-02,-8.7656882232444111e-02,1.5747640290353325e-02,1.5758054923866310e-02,-1.5688339664817913e-01,7.6012664485446838e-03,1.7364872297195133e-01,2.6591155863633942e-01,2.7458404480195188e-02,-1.6398884891183205e-01,-1.6923736164037145e-01,-1.3002147819645867e-02,1.5763713741157759e-01,1.6694005504310026e-02,4.2196256432720798e-02,8.5982887917484610e-02,1.3921578766996978e-01,-1.6595516310104300e-01,1.8592085260564173e-01,-1.1494363863077607e-01,-8.4234808828189803e-02,2.0176177025894645e-01,-6.3164099946625002e-03,1.0659945116282810e-01,-5.1380097470927054e-02,2.5587021672700955e-01,-1.9296834815676034e-01,-2.4234521450669466e-01,-1.9086290321071331e-01,1.9487699921587190e-01,1.6652994876040130e-03,-2.7947493687134870e-02,-1.5983552273560669e-01,9.1858591879201104e-02,1.7176597257441942e-01,6.3324455377689784e-02,-2.1815399408908545e-01,-5.5341533195681261e-02,-1.2891826813161544e-01,1.0150614871601848e-01,1.4249446098172927e-01,-1.9726919206068737e-02,3.3101254904403615e-01,6.2345194896007594e-02,1.6814837788802765e-02,-7.3735267906418156e-02,-1.8925530161529364e-01,2.5781800894513934e-01,3.8042365034787962e-01,2.7716744448837888e-02,3.6233983307281496e-02,7.8627185159565238e-02,-3.8446326876392212e-02,-1.4717781837060875e-01,-5.7328517592048919e-02,1.6568637360313601e-01,5.7257292705020571e-03,-1.4231251698991071e-01,1.5851936174047893e-01,1.0221325283341115e-01,1.3226091930486380e-02,4.7104477136435972e-02,6.5092778877955490e-02,9.4295809766445540e-02,9.1108307669986385e-02,7.5114713123708210e-02,1.5634469447895161e-01,-1.0971701294103209e-02,-1.2827068357294902e-01,-6.3246946145443433e-02,4.6078728807912604e-02,3.0255155921192323e-01,-5.0362339633704324e-02,4.3312068386296393e-02,2.1629832406435109e-02,-7.6550359507589913e-02,6.0462415660769306e-02,-8.4018611074726496e-02,-1.7701328457856370e-02,-5.5548391011054285e-02,-2.0188657608930780e-01,6.5330397491640671e-02,1.1548606714863675e-01,8.6159401516200051e-02,-7.2501036554956252e-02,-2.0801661406722310e-01,1.9794058833286521e-01,2.1379799255020624e-02,-6.3423876257336656e-02,-2.1983053506655967e-01,3.6291375374987278e-02,4.6420434234184363e-02,1.8170037840820852e-01,1.4725688114389235e-01,-1.2062309183436921e-01,5.5900221645906051e-03,1.0264667877062145e-01,-1.2339600395197727e-01,-3.3990917260227654e-02,1.8950570827183907e-01,-1.3097464587065519e-01,-8.7050820267438350e-02,4.4003484135687311e-02,2.7144891681935245e-02,-1.4185274910877463e-01,1.3512481759012679e-01,7.9811354824714173e-02,6.3827872447909079e-02,3.1280270301283469e-01,1.3391057291104833e-01,-1.1654712653877813e-01,-1.1213428480090481e-02,-1.6054332424936796e-01,-1.7220616429126601e-01,2.2975550950610260e-01,-2.5983777547268916e-01,2.0405193345596698e-01,-9.0287777959969368e-04,9.6385458896897758e-02,1.9516016856103385e-01,3.4579129044928258e-01,7.1143565864292560e-02,1.2346665668294116e-01,-2.3510300385524034e-02,1.8093183350376491e-01,-1.9295325613842770e-02,1.1235856458449310e-01,3.3821116898310327e-01,-7.3261802836737444e-02,2.3678125918825080e-02,1.1595681897618322e-01,1.7782341500791485e-01,-1.8011485620265869e-01,4.2223240359739331e-02,-2.2983441260891000e-03,6.5784614765722199e-02,-6.6642957259700972e-03,-1.5522071396321754e-01,-2.4031802030060126e-01,-1.3561864940445820e-01,-6.3746644808487379e-02,-2.1170988263502344e-01,1.4209530654669009e-01,-1.0592292193918368e-01,4.0898416691472587e-02,1.4048566783230965e-01,-1.3012541592217367e-01,2.0729446415012956e-01,-2.2381000137553511e-01,-7.1600727448474427e-02,-1.1081908531562467e-02,1.7054039135091062e-01,-7.0198982434796595e-02,-1.6379555918442126e-01,8.0654388403211513e-02,4.0984615171776186e-02,4.2671195034314297e-02,1.6024637953137938e-01,-9.8563813193760841e-02,1.6670278718378045e-01,3.9650573305704283e-02,-1.2783870424620325e-01,3.9491000787210670e-02,1.8245453539929532e-01,-7.2721266429622358e-03,-2.7147566907756722e-02,2.2697744332013967e-01,1.2690620251705498e-01,-2.6428565048401381e-02,1.3404418103648638e-01,8.1609314483430839e-02,-2.4686118193101073e-01,-3.5502070957092291e-02,1.3366541937276194e-01,3.1997812220659527e-01,-5.6722484887325945e-02,-2.6236113172902548e-02,9.1747367471922289e-02,-8.9391290059623679e-02,-8.5874265444060051e-03,-6.8224468280781464e-02,-4.0569305547141304e-02,1.2801790274952773e-01,-1.7624587347590068e-01,-2.9190349080205591e-01,-3.3351369692900791e-02,7.5887709756665006e-02,8.7449704524699565e-02,-9.8007078176793674e-02,3.6821589017369420e-02,2.6879296174720204e-02,-1.9342425080726731e-02,2.8885656145960122e-02,1.1589967142165131e-01,-7.5939640560439919e-02,2.6049113262338358e-02,-2.0685052558516329e-01,-1.4511753977754191e-01,-1.1671511221396977e-01,-1.7867774355960639e-01,4.2193562090652025e-02,1.8569172865563557e-01,-2.8011168694556537e-01,-3.3239792548259373e-01,-1.7278538947966957e-01,1.1537179999391596e-01,4.4331733816091859e-02,-5.0565203359810296e-02,6.0201504185725029e-02,-1.4141361120116987e-02,-2.2028075817204895e-01,-2.3312952353923319e-02,2.3709796489574761e-01,-1.7070110600825442e-01,-1.9625107900100802e-01,-1.1244631886150085e-01,-1.9316145508846286e-01,-6.0141776773446447e-02,1.0550667900795379e-02,7.5400536407313631e-02,-2.6939203237055204e-01,2.7149882138598175e-01,9.2469925915636297e-02,4.7257851446820313e-02,1.4506095377145808e-01,-6.8559408575969679e-03,1.7640490944873335e-01,8.2458479671588883e-02,-1.1327449003033443e-01,5.2535862180449582e-02,1.0302148373451635e-01,-3.1157884110622198e-03,-1.5852962903896647e-01,2.5136581016369958e-01,-2.4240216362992389e-01,2.1281635445125603e-02,3.7043899462394109e-01,3.9261409691594530e-03,-8.7573410227378454e-02,2.3903554796737853e-01,-2.2423691334108375e-01,1.4826524870172711e-01,3.3625656584231514e-02,-7.8424335985410164e-03,-6.6903351334148486e-02,-8.0401524656340852e-03,1.3856615927400801e-01,6.8314210942345147e-02,1.1798862410345826e-01,-7.6121675503892233e-03,-1.8827479872062344e-01,-6.6469737407169632e-02,1.9046551020672139e-01,5.7380884706377420e-03,7.1464598648208165e-04,3.7069879264192121e-04,9.0269417112911990e-02,1.3159752586892762e-01,-4.3686925731373595e-02,1.9328592360974645e-02,-1.8089050072942575e-01,3.0924219023779047e-02,3.1999702505504690e-01,7.1243186686460458e-02,1.9747359472693697e-03,-7.0753866036825722e-04,1.2216662720480476e-01,-1.2810932857635685e-01,-2.2214277945977363e-02,-1.4745350308134733e-01,-5.4827316882006399e-02,9.5989533072753042e-02,-1.9963209727665426e-01,-3.2002129831004711e-01,-2.9489874349680603e-02,-1.2821053230179069e-01,9.1242147355300840e-02,-1.1242370614334109e-01,1.4727173405538979e-01,-2.1386361084512476e-02,-1.6649791196312860e-01,-8.6960903610188121e-03,2.5938829693984956e-02,8.8948863202111927e-02,1.3889627900461904e-01,-1.2848571025500352e-01,-4.6641292495393755e-02,-4.5948212512865759e-02,-2.2430671096017799e-01,-3.0768379061408321e-02,-9.2602454812673207e-02,1.2497172838464554e-01,1.3308381376278675e-01,2.1643807959473446e-01,3.5601109831945849e-01,-1.2852151949753551e-01,1.5162974982999633e-01,1.2708243401462236e-02,1.8804733633913988e-02,3.7341917262370697e-02,-4.0892555232925448e-01,1.8765174000626941e-01,4.8146610584335031e-02,-1.8393497540749684e-01,-3.3945055537799924e-02,-1.4068585848653378e-01,-2.5712886172675564e-01,1.4555577922704391e-01,3.1187321593594386e-02,2.7794826511535337e-04,6.7224810641923705e-02,-1.3030709471761601e-01,8.3085677140154329e-02,7.5825684508283253e-02,-7.0626925295214901e-02,1.9057037048602288e-01,-1.9277114995971059e-01,8.8326233513450272e-02,2.0983435446626419e-01,1.0854547613570432e-01,-1.0533455304239192e-01,1.3277545606852729e-02,-2.9937603180954297e-02,2.3405559415223438e-02,6.7254292094490811e-03,1.8828611790436067e-01,-1.0835753658137093e-01,-1.3467641464912730e-01,2.2909472575348716e-01,-3.2391403923774265e-02,-7.1221597798131836e-02,2.3414377518062360e-01,-1.6283541313925015e-01,-3.9817682573172537e-02,1.1131336758190144e-01,-1.1340105375475575e-01,1.3695067442215267e-01,1.5276879273443239e-01,-2.0137775530428639e-01,-2.0079648315262189e-01,-4.9419057741340151e-02,-7.8977635028956855e-03,9.9319372430296510e-02,-1.8129967028062943e-01,-1.9891248201139376e-02,-4.4019344374008548e-02,1.4706107886446303e-02,-1.6074499402169226e-01,8.9326520555031902e-02,-7.3637557851603738e-02,1.4411677838556725e-01,-4.7828510519692689e-02,-3.0627279189567924e-01,-1.6522448373242196e-01,-8.4988380628232205e-02,-7.2664989421928602e-02,1.0066328393339431e-01,-5.1643288292660267e-03,-7.5112612940362006e-02,-5.9602928048317412e-02,1.8595510565492770e-01,-1.5515731892572615e-01,1.5736177333163784e-01,-6.5678536044517094e-02,9.7774356208063615e-02,-8.9216943709659775e-03,-1.1892535028133362e-01,-2.3478885343965170e-01,-1.5227276072184812e-02,-3.7395455867227034e-01,2.1461635594501299e-01,-1.3545554497658022e-01,-1.5057090339038132e-01,-1.2623080877144627e-01,3.3004187880219388e-02,8.0704808541508216e-02,-1.0501973180749254e-02,-1.1953572314673672e-01,-9.2212174215533196e-02,-1.1776007858825990e-01,1.0159598583958118e-01,6.4988394048617087e-02,7.3009150750895840e-02,3.0855302410645602e-01,2.2441371715765224e-01,1.2794627210861492e-01,3.8187819328599840e-02,-2.9847128490328623e-01,1.9119516491698439e-02,-5.2795893711719014e-02,7.2832877423542219e-02,8.8654728985725142e-02,7.5534136725957990e-02,-4.3793346785818171e-02,-1.1917310030953425e-01,-2.0859581390727626e-02,1.2944882604113250e-01,-1.0395222741585328e-01,-1.8728501887941931e-01,-4.0476104519000017e-01,-7.0398105416687839e-02,9.7605260976586450e-02,-4.5102930536218250e-02,1.0238684774022275e-01,3.5173678040008885e-02,-1.3375337711679730e-01,5.2190345264772210e-02,-7.5716743826227381e-02,-6.5236244726480139e-02,-3.8342619563708713e-01,6.5026265483516976e-02,-2.5214054835735706e-02,2.6470223597220472e-02,2.5775481274597997e-02,-1.0372362735648863e-01,-9.8362020249084997e-02,-8.3530841366097855e-02,2.2183923634845289e-02,-1.5456966602415051e-02,1.0105555361063812e-01,2.1439939364707597e-01,3.0118912932580355e-01,-1.1809945144990609e-02,3.1122601372003234e-02,1.1962922371918168e-01,-1.5259856894124951e-01,-8.0139943970371177e-02,-4.8092454687644962e-02,1.6546407557616222e-01,1.3599903904277733e-01,-1.3332606301503763e-01,2.8369786620743374e-02,1.8237201686016430e-01,-6.2351187671997627e-02,4.4855274774966467e-02,2.5632598516476968e-01,-2.5158644728324636e-01,1.1957941735273425e-01,1.2032016992551954e-01,1.4483835643339616e-02,5.3675161567846366e-03,1.8130523503666623e-01,1.2869157824967556e-01,1.2348656028213002e-01,-1.6543961508497435e-01,1.1205394617063318e-01,1.9283374288135097e-01,1.7933251544721787e-01,-2.3480566294727903e-01,1.1376252093486636e-01,-1.3859782674508606e-01,1.3484660727585127e-01,-1.5855084281355836e-01,-6.1754878518838228e-02,-1.4689979078222249e-02,3.4621672596502936e-02,-5.4417722432716829e-02,3.0295035579817958e-01,-7.6078060376581019e-02,-1.2738026884514045e-01,-5.1318712232410552e-02,2.2422349951822124e-01,-2.8344409896022153e-02,-6.3656349744905222e-02,1.7774080730364289e-01,-1.3684029277885101e-01,5.6128806419612903e-02,-5.3379239330221089e-02,-4.9633711493797542e-02,-2.1668020219526893e-01,-1.3383598375760467e-01,-8.4647013979384844e-02,-2.1159144682667125e-01,-6.0206705359635432e-03,1.0291989361868879e-01,-2.4315023918283291e-01,-3.1454775283224318e-01,1.0166597010850556e-02,1.1512679406637509e-01,7.3812633264730851e-02,8.2190005509091085e-02,7.9314528125500786e-02,-3.6758364267620680e-01,1.8235501658648928e-01,-2.4892588543546376e-01,1.4602949184301391e-02,-1.4153317364402705e-02,-1.3403593720520909e-01,1.9712743267625138e-01,-5.5475149669251447e-02,4.0430007331986068e-02,6.5531547122232275e-02,-1.6649295802050812e-01,7.9469214259135501e-02,3.3980640970165027e-01,-1.9415993905211711e-02,-1.2311936078051917e-01,3.9921193351712132e-02,-1.4653692231949283e-01,-1.0290585462332749e-01,1.3611757630634052e-02,5.4281222697099098e-02,-3.6140927425219224e-02,4.7107922892568259e-02,-2.1874319787896046e-01,-4.9773170555517762e-02,2.5619466072533917e-02,7.9564372625056820e-02,3.3739982738824897e-01,-1.3382209449119284e-01,-1.9395276121353841e-01,-9.8520624379800414e-02,-1.7146617903104031e-01,-3.6192231725941923e-02,1.7141262264695539e-01,1.2364447791885985e-02,-1.1136325194062154e-01,8.7502695744508169e-02,-1.4389598600596495e-01,-8.1177686019011028e-03,-3.1897851197202190e-02,-8.4310597991104880e-02,-9.9744712750527473e-02,-1.0759410300059302e-01,7.4633255212880212e-03,-1.0415320353308659e-02,-2.8991456585569113e-02,1.7513809018960960e-01,-4.8169509740741766e-02,6.1159699589947353e-02,-2.3751927330833733e-01,-1.1197118650836184e-01,-1.2465131708163019e-01,2.2852727934385544e-01,-1.6428183741825178e-01,1.7514586115098922e-02,1.4666078364805610e-01,-1.4596034937286364e-02,-4.1171997168495809e-02,-4.7324887477142544e-02,4.8412337487552727e-02,7.9596385390526561e-02,-3.9448022180092940e-02,-1.8098857826165657e-01,-6.7033214051848422e-02,-6.0307539771490115e-02,-1.6171122503566088e-01,1.1234831578420562e-01,4.9557949407478763e-02,5.2976195674688815e-02,1.2927332185187093e-01,1.8578292726739498e-01,1.4605915316581397e-02,-7.6679572712819097e-02,1.1361572728106192e-01,-1.6041245622069039e-01,-2.0258538922913918e-01,7.2533564632147079e-02,-5.9014577291403775e-02,-4.5385565507972583e-02,1.6024132962995785e-01,4.0246348898578777e-01,-2.1618406454651590e-01,-1.5106389430903416e-01,-9.0848500010055205e-02,-1.8372574689383847e-01,3.9366210040013283e-03,7.3562410222504315e-02,1.5373946510340991e-01,-1.1111420442942221e-01,8.6286651361707795e-02,1.6365132944430744e-01,-1.5582356677088904e-01,5.1976188937942785e-02,1.0123987936362711e-02,3.5756711109897427e-01,-9.7857633414237366e-02,7.8963435890100180e-04,5.7081021808079634e-02,7.5419308150682526e-02,2.4159117817047288e-01,2.8059061491907167e-01,-8.1233157147020355e-02,-1.0124776653790768e-01,-2.2131397401615634e-02,-1.1931394742817801e-01,2.0742585527901550e-02,9.0503611014622135e-02,1.1033965291503033e-01,5.4449143321090604e-02,8.8875450580906248e-02,-2.1186864095630448e-01,9.0904644313197613e-02,2.5127170605940952e-01,-1.5988273789100366e-01,2.2644812577660892e-01,1.5264473833615269e-02,6.1427154842617737e-02,5.5733290390482231e-03,-2.0754274972183975e-01,-4.8313750166284926e-02,6.2979785501492580e-02,1.7709164523020557e-01,-2.2190261195539007e-01,5.2855862662751982e-02,-9.9536830962386608e-02,-1.2825316206331799e-01,-5.7882799917405386e-02,-8.6656578212132934e-02,-2.1342886674582609e-01,-7.7506091479191616e-02,1.2695589522920503e-01,9.9205851570263043e-02,-2.4323092135684718e-01,1.7229886844434608e-01,1.3853028539569875e-01,1.9415794724495591e-01,1.1282118966733486e-01,2.6970406692219112e-01,9.6264178112116308e-03,1.0836010840111072e-01,-3.9861892282436903e-02,1.2802920426029638e-01,-6.4115169402481464e-02,-2.3005509641645630e-01,1.3570075633517165e-01,-1.0502078623899735e-01,-8.9872624669062456e-02,-1.5923639709202109e-01,1.6959835379811192e-01,6.3302430549684346e-02,-2.0768199052284050e-01,-1.2244360592120014e-01,-7.5067018795733478e-02,9.5049292728707560e-02,-8.8234598679208742e-02,1.9820899674486953e-01,1.0513250047179197e-01,2.3532803491454954e-01,4.1647159275165151e-02,-2.5404126914367520e-01,1.4955249343102645e-01,2.9636397747353904e-01,1.5467301668329106e-01,-2.0697539322471806e-01,2.2111328655871321e-01,-9.4505704021158474e-02,-1.4302052897005069e-01,2.1264841800591981e-03,-1.2919090762144494e-01,-1.3232020605190817e-01,-3.0483108220742391e-02,-4.1522690840778066e-02,1.4969713118289934e-02,-1.9430239097518662e-03,-1.7559396292920032e-01,1.3916265779181336e-01,-4.8910570612308045e-02,-1.8402043656413178e-01,1.6304128429959849e-01,3.6972143215169437e-02,-1.1033182713219861e-01,-2.4148006975973538e-01,9.0314429232418197e-02,1.0966435631469473e-01,-7.9504936256521233e-03,-1.7720152770261116e-01,1.4415023309537220e-01,-1.2166520169504810e-01,6.0002043149067180e-02,-8.5907035450733582e-02,-6.7346008811825148e-02,-1.5360243225964418e-01,1.0604385927646678e-01,1.1600392543744149e-01,2.0480411479138000e-01,-2.9158468640292708e-02,-1.5287114971755977e-01,-2.4924142748017922e-01,-1.0290334328963639e-01,7.8797980215126878e-02,1.0380921626964681e-01,-1.2006238393335501e-01,-2.4169706672663258e-02,-1.3455555541961855e-02,2.0917006620514700e-01,-2.8855461024063489e-01,5.6074173913776372e-02,-1.4926188191488263e-01,-3.0693241888584716e-02,-4.3436008074503085e-01,1.6965444622324875e-02,-1.2178464357072866e-02,1.1601253775207729e-01,-1.2713897323437695e-01,-3.2804958381161348e-02,-1.0294178765487537e-01,2.7355161377843266e-02,-3.1336369368668585e-02,-6.9316212992069193e-02,5.5554962988852472e-02,-2.0063094547680629e-01,1.7178864845426350e-01,8.0242202570725799e-02,-1.2463448093477798e-01,-7.5667356738644609e-02,-2.3526932489086602e-01,7.6108684167725718e-02,1.7311471937158060e-01,-9.5242789257268361e-03,1.2073532307891864e-01,-1.7847497101044024e-01,-2.2566831993377435e-02,-2.8610134837124862e-01,-2.4579125025596807e-01,-2.3013526954807473e-01,6.7538000857724836e-02,-1.1857895859757142e-01,9.6552966562226061e-02,-2.1521331800707113e-02,-5.1167639466728712e-02,-8.9322815289292215e-02,-6.4790180767382355e-02,3.6431094297289295e-02,7.5942406843477767e-03,4.5583103950509740e-02,-1.0908764476238645e-02,1.6182439139095756e-01,-3.0162367822977143e-01,3.5110595087784369e-01,-5.2077306364510328e-02,-3.1642099259792153e-02,6.7219895390300363e-02,-1.7307071885708830e-01,-3.4094412711325336e-02,-7.2991815621444328e-02,-2.2316388045083360e-02,4.5417692442438130e-02,5.9775809202549615e-02,-1.7383412005921145e-01,-1.5637226364487405e-01,5.3399517853099314e-02,-9.7226342721827425e-02,1.7002328627865512e-01,2.3159700061892244e-01,9.8653121323367565e-02,-3.8748220091125031e-02,-4.0348994442828683e-02,2.0935718536766698e-01,5.4664499872701167e-02,-3.5674886210883917e-02,8.9151396305214625e-02,-1.9097390621879307e-01,1.1070497535001007e-01,3.9444538094469900e-01,-5.5907163137232790e-02,1.8124611997496629e-01,1.3027672860453718e-01,1.4699096106615187e-01,-2.4432812459939185e-01,7.9964116968102239e-02,-4.8837231210465432e-02,2.9411140869317898e-02,-7.6765219355475339e-02,-1.4535210908633273e-01,7.1604315743780941e-02,-1.7531393901403021e-02,-2.7083465456391825e-02,1.2332431702416523e-01,-4.3496487043302903e-02,2.2944107443587103e-01,7.5550504438943802e-03,1.2399727076662224e-02,-4.5931433144508926e-02,-1.9223191073525197e-03,-1.9169222930345020e-01,-1.6806722920914546e-02,4.8007480976043470e-03,2.9582747360914395e-02,2.6622412495577291e-01,9.6206201387149470e-02,-8.7516038435130727e-02,2.0469569210668090e-01,2.6110926410472881e-02,1.7017614335396607e-02,9.7595139250240853e-02,7.2489735665565491e-02,-1.7665794553231870e-01,-2.1449840643482626e-01,1.2230226440569629e-01,-5.6362442920199103e-02,-4.4346817513756426e-01,1.1598990891963129e-01,-9.6114176008718452e-02,1.9211221307759446e-01,3.6756603731978740e-02,-1.6263465889599624e-01,-5.5259292511120363e-02,-1.0702315151639702e-01,-5.5482559867900696e-02,-2.2312667425732649e-01,-1.5952633633675276e-01,-1.7782137548568444e-01,2.9880990920373823e-01,-1.6606340592175978e-01,-6.7640301658953702e-03,4.5037245881384431e-03,1.4957941051633662e-02,-9.0997079817777396e-02,5.7824983377530476e-02,1.8656359700597650e-02,1.3098535600820138e-01,-1.7410283206497854e-01,-1.9040686422483694e-01,1.5127221330756518e-01,6.3730168649609953e-02,-3.3443184149804184e-02,-2.2156397369298408e-01,1.7993454255189850e-01,-3.0092857756836899e-02,-7.8513015852812632e-02,8.0409145015569908e-02,-5.0994839396403993e-02,-9.8057571007733005e-02,-2.8986717207652807e-02,2.3445465275003470e-02,1.7622032018353848e-01,-4.4540132360648473e-02,3.1407414455293589e-02,2.5321677123767256e-01,-1.1376973030297559e-01,3.1502906374068176e-02,6.9242940316949705e-02,-4.0380188620855314e-03,6.2541510346731791e-02,5.1252343602254979e-01,8.7605136328353428e-02,4.6705003760601924e-02,-1.7473624977301908e-01,-1.2343830119152095e-01,8.5444503796725066e-02,2.2874959882641660e-01,4.4545234957770491e-02,-1.0338226540374788e-01,8.9336454038020874e-02,5.5194090289370341e-02,-1.4834854025975565e-02,-8.1980537069038420e-02,5.5028681464194283e-02,-8.5406973682635362e-02,5.0687536055929620e-02,-2.9121389242102818e-02,-6.8006124939795576e-02,-4.8617822010143592e-02,4.0723003273745555e-02,-1.4238595900648104e-01,1.2447360417189547e-01,-8.9357685862030009e-02,8.7563606418880668e-02,-8.5958143607555576e-02,-1.2811348265911254e-01,-7.3412967961638931e-02,8.7037849633432599e-02,-3.1081546767692304e-02,1.2892068331389483e-01,-1.0733744252225605e-01,1.8919626586965096e-01,3.2513823413815188e-02,-1.3232597955992778e-01,2.6383290386649361e-01,-1.1804313921667310e-01,-1.4853082957567498e-01,1.0595299333171966e-01,-5.0249174727424219e-02,-2.7970985273125942e-01,2.8105116717749645e-01,2.6807255898388399e-01,5.7899706873335344e-02,-1.1418569739626176e-01,4.2976237316593217e-02,-7.6655527321859179e-02,-2.9424055251226756e-02,-4.8488779986763104e-02,1.5490757503813679e-01,1.0241126266646772e-01,9.6842283886972233e-03,-3.5586409345884883e-02,-6.2506858423334741e-02,2.9469802746756796e-01,8.7991802166327515e-02,1.7534039399617954e-01,-5.9935355882281403e-02,-8.8985766698287616e-02,-3.5715781971260657e-02,-8.7145063373618978e-02,3.4560101975225727e-01,9.6262760285982421e-02,1.2945537035860188e-01,-1.8399101328439086e-02,-5.8028928182261429e-02,-1.7033523039695128e-01,-1.9403220113276241e-03,-2.6135873070958282e-01,-4.5851220733149095e-02,4.7421109989823407e-02,1.2875788697537766e-01,-3.1227891966660309e-01,-2.6550369041004629e-01,2.8244102135060339e-01,1.5443007600855910e-01,1.9358130575080571e-02,-1.2093935468272225e-01,6.6055295225727312e-02,-8.4594144793488646e-04,-7.7218769282907843e-02,-6.3244092683607950e-02,-1.3705162031837195e-01,-2.2647436111767622e-01,2.8141482482644524e-02,-6.5498996817894631e-02,8.3946544161566494e-02,-1.5659721030594251e-01,-7.4008201593659367e-02,-1.2913512643011824e-01,-4.4937309919711186e-03,1.3436841153218373e-01,-3.1266820988556487e-01,-1.8645159803898853e-01,6.2433698804206551e-02,-1.6202452027075198e-01,-8.5781792150510669e-02,4.8346219951322836e-02,6.4309369337434740e-03,-3.4785236424833332e-02,-1.5807449605376195e-01,3.0002409357390447e-01,2.3223668490500243e-01,6.6434550820493557e-02,-1.0728245609138914e-01,4.7075491011988636e-02,-2.6120397657018870e-02,-5.5890567766118719e-02,-2.6128993052476296e-01,1.4717751892154252e-01,2.9258516751318558e-02,2.9644268993324630e-01,6.3621907817128065e-02,2.5677319053669628e-01,-1.5134914867430073e-02,2.5687290058119233e-01,-1.4796217186293373e-01,-7.8955044966620092e-02,-9.8159373991176857e-02,-4.6886895835537755e-02,1.4616394402932515e-02,-7.8739661446719941e-02,8.2917954474143879e-02,-2.2510018284156658e-01,-1.3349021952826920e-01,-7.8405402569565297e-02,1.1472963030712735e-01,-1.3719369208092222e-01,-1.1333259179536562e-01,1.5755043733523824e-01,-1.3328084615474151e-01,5.2788786179508031e-02,1.1673631812872678e-01,-2.6953471931404765e-02,7.8352164566942439e-02,7.0083871345745716e-03,4.8650128373340096e-02,1.5943417090244105e-01,1.1179484568049920e-01,-3.2386597091027737e-02,1.9001964870099369e-01,6.7559801514374213e-02,-1.5529422459140518e-01,1.3363934638704419e-01,-6.8762371668309921e-04,-1.5342398914737709e-01,1.7460502762877916e-01,-3.7800684214231900e-01,-3.9264530806703331e-03,1.4206839346609232e-01,-1.8194709497997948e-02,-5.1512833290997456e-02,-1.0656693307259037e-01,-6.0824215323356662e-02,-1.4790473281014621e-01,-2.8399561594629787e-04,-1.7067610370392050e-01,-9.0866409961284617e-02,6.1868677536129749e-02,-1.4323624730775195e-01,-1.1016713966304185e-01,-5.2631464286780158e-02,1.5828292130648203e-01,2.1809153111224594e-01,1.5502727000251465e-02,2.0979394132675500e-01,-7.1555629149005442e-02,1.1872486892699022e-01,-1.5410676500149206e-01,-1.8393692339315668e-01,1.4475391275656244e-01,-8.0634873658553818e-02,5.4077727039510484e-02,-8.6380181841744674e-02,-5.9139743846249537e-02,-3.8162265771483996e-02,-6.7428513760938086e-02,-2.2790672517926303e-01,-2.8054092159179186e-02,-2.7608886363271823e-01,1.8659030880229838e-01,-1.7979150207986869e-01,-1.8734484075235205e-01,9.5793850744202033e-02,-8.5860189605504608e-02,6.3996831676396373e-02,6.8558402558319367e-02,-3.6076686396556659e-02,1.4938627541722008e-01,-9.7243477960515967e-02,-2.9170269187170500e-01,-9.2966748240883468e-02,-3.7922734608934854e-02,-2.3901005778386511e-01,-2.1017745684439451e-01,-6.6014456373094110e-02,1.5324881541399343e-01,8.3449419883082604e-02,1.5771211298813539e-01,4.0510821865442852e-02,2.3308720513735265e-01,4.0795749827243113e-02,2.0072353586922692e-02,8.5986591653712974e-02,-1.1854404506824836e-03,-3.1498205794756878e-01,-1.2069405325397703e-01,-5.7200969489886976e-02,-2.7530380726191073e-01,-8.1322986291060786e-02,-6.9156879445502212e-03,5.4001404972995388e-02,-2.4953871405901922e-02,6.0467411187241790e-02,5.6751992959181818e-02,1.7382693630308248e-02,7.8780131921754898e-02,4.2458778734757607e-01,1.0002511143451935e-01,9.8359230341385898e-02,-3.6595749928164119e-02,2.0982382792719006e-02,4.8229239388354564e-02,-8.2848510445530082e-03,-2.7093288711847387e-02,2.2651841920178595e-01,-1.3743241636639156e-01,1.7233702657949157e-01,7.0546537693554234e-02,-7.4135387203018668e-02,1.2004150030435681e-01,6.1988015387586054e-02,-1.3581899047534274e-01,7.0520610182776500e-02,3.1285532522567314e-02,4.5313278873378202e-02,-1.0149593549906234e-01,-2.9122467585790280e-02,-2.3307858602927927e-02,-3.7562285407439638e-01,1.8902366841981239e-01,8.5230755183323542e-02,-1.1230038740795306e-01,-1.1734132789152193e-01,-1.2856659986345650e-02,-5.9035439719603719e-02,-3.3902385410714098e-01,-2.8195943302467658e-01,-5.4767180677655028e-02,2.5831378917148456e-02,1.7204838615598511e-01,4.3025571717663531e-03,2.3326545393323628e-01,-2.7727633351368023e-02,-1.8100267098247066e-01,5.5028417644596456e-02,5.2338843329086976e-02,-3.5735544562152000e-01,-6.7818676249045404e-02,1.7329149131598673e-01,-1.8349777312800533e-01,1.2781393292626850e-01,-1.5603174569028663e-01,-1.6212349207914420e-01,-3.7991581953880818e-02,1.9465873260708613e-02,8.0676472254295167e-02,1.3186491275295878e-01,1.3845228309272239e-01,6.2372255038295993e-02,5.5736282776358413e-02,1.7600378395718511e-01,-1.5627658391978749e-01,1.9204551999361591e-01,9.4778701824126399e-02,-2.6889142352961909e-01,-1.7461432236812392e-02,-7.3029621190818086e-02,9.4412230690357493e-02,5.4575639908066638e-02,-3.7222296650050571e-02,5.1461046631154458e-02,2.7466559631906855e-02,7.6848211075088990e-02,-2.1577154686241809e-01,3.3467019757505947e-02,-1.3730461208383150e-02,-2.0260806538680168e-01,-1.5096587999333769e-01,-4.6733772456849280e-02,-1.1930233167940528e-01,-6.1351809209787667e-02,-4.5199726542037889e-02,9.7145722425868566e-02,1.8775327592439534e-01,5.8744147345760916e-02,2.3424197949387543e-01,-1.2046933055998867e-01,8.3016827147857214e-02,3.2983837163694080e-01,1.1900060362912485e-01,1.3458679451680234e-02,9.4238109153159388e-03,1.1173963967132895e-02,-9.7994410633742049e-02,3.3058467031111996e-02,-1.5441339821465788e-01,6.8913491513896752e-02,-8.5127535006766578e-02,8.0422985131324495e-02,-1.3779921664674544e-01,1.5644468135728379e-01,7.5552498438501162e-02,-1.2035400343156508e-01,2.6266061580536870e-01,7.5068585282118003e-02,2.0984576198896621e-01,-2.1582699202302227e-01,-3.3257178526186071e-01,2.8024967510970906e-02,-1.7066231570171275e-01,-4.0594150356904925e-02,-1.2522936683378197e-01,1.0541617759693461e-01,1.6271647334336106e-01,-4.4698158549853963e-02,-7.6125983769844321e-02,1.9888351206334245e-01,1.2171123466688208e-01,3.5186601758092254e-02,-7.4959500618463820e-02,1.7183698892619872e-01,2.7011836505878472e-02,2.7966384707639552e-01,1.1120442330825539e-01,2.5093690704831716e-02,-3.7434541244213505e-02,-1.0890242925254190e-01,1.3360406191266871e-01,1.2047581659544232e-01,1.9146754754867706e-01,-9.3953635756685635e-03,1.5963765389575318e-01,3.0959286102980044e-01,1.8018079604187315e-01,1.8184291336889792e-02,-1.8467851114535905e-01,-5.6471779153718510e-02,-2.1402533724348768e-01,-3.0868942242675348e-03,9.4327849630149757e-02,1.7185398880557143e-01,-8.7321985086157017e-02,9.7534071320514379e-02,7.8909167737676464e-02,-2.6457645138006447e-01,-9.3954514364741171e-02,-1.7940260113289100e-01,-1.0034741720435651e-01,2.0551493502786600e-01,-1.9023060051049499e-02,8.4716255082764272e-02,6.0531345427891015e-02,-8.5972144262441125e-02,7.2417855406962842e-02,-4.2888054310694194e-02,-9.0168488412203138e-02,8.7979054155626873e-02,4.9979680998997945e-02,8.8135332905521682e-02,-3.3045142974046560e-01,-8.5617812019782219e-02,1.1780091276757797e-01,-1.8235944117416350e-01,-4.3303645446872326e-02,1.8885874388711102e-01,2.0017083390980886e-01,1.9253307230047340e-02,9.7200181332745147e-02,-2.9119077181123616e-02,-1.1124716905975780e-02,-6.0488451456448267e-02,1.9720752019693047e-02,2.2169166456232031e-01,-4.2773550767720506e-03,-6.8719174317517978e-02,2.4777251983977108e-02,2.8096961018356664e-01,-8.9761188468918993e-02,-1.1045233548608225e-02,-2.0542100676237546e-01,-2.1423955222917873e-01,5.9969021425154742e-02,-2.0558406331163633e-02,-3.0579003247753991e-02,2.3926392948837477e-01,-6.4165146725927269e-02,-8.6736805470474604e-02,7.3221812503759962e-02,-1.5150617824319458e-02,-1.5698592060904068e-01,-3.2831886531185534e-04,-3.7255972598219539e-01,-1.0669532626964599e-01,-6.8328033781777627e-03,1.5011897788276218e-01,-1.2793118388922509e-01,-6.6159553269571750e-02,-1.7894423024291051e-01,-7.5345887017266910e-02,5.1447231343811184e-02,5.7542789783999820e-02,5.5586546833331738e-02,-2.4727021084993561e-01,7.0133652175957795e-02,1.4729993010158204e-02,-8.9743085244917267e-02,-5.4748254910909344e-03,1.4518812757031729e-01,-1.2668033876430548e-01,-1.6379461711215332e-01,1.9630822734750814e-01,-2.2424287626345268e-02,-2.7623774201139446e-02,-2.5005603546948091e-01,-1.7172126745463706e-01,-5.5088087026073117e-02,-7.5868697391629256e-02,6.3257767320362840e-02,1.3126815210493611e-01,1.0365706083698167e-01,-1.6641272772093990e-01,6.6793449766285734e-05,1.8219457492586849e-01,-1.2769209469703335e-01,-1.5383103729900563e-01,2.9233347424289757e-01,1.4101622142615046e-02,1.0752586665349040e-01,-1.4205324857795501e-01,2.1133257334362110e-01,2.8608236892735506e-01,2.2400982384584051e-01,-1.8465978560679097e-01,-9.3981090507298984e-02,-1.2816144731854823e-02,-9.4989011467922213e-02,-1.0232748896139385e-01,1.0095452271228555e-01,1.7333516499432913e-01,-1.4923764750351101e-01,-8.0174841423377399e-02,-4.5025515633329363e-02,1.0514732900756016e-01,2.2176570790124254e-02,1.0295300270172654e-01,2.0564065815681160e-01,1.3862587945292332e-01,9.0592250704559105e-02,3.6010010849173844e-02,3.0849587405597942e-02,1.1738285274869760e-01,-2.9271453970449912e-01,3.1988836847276375e-01,-1.3544209852381883e-01,2.0010272354602898e-02,1.1736613671624056e-01,-2.9670677182044733e-02,2.5127921468772661e-02,1.6345092659793395e-01,-2.5215851739264533e-01,-4.2425188341154246e-02,2.4958470346219133e-01,9.5869469708355290e-02,-9.5845511507766767e-02,-7.3481933926174095e-02,2.8365383600908256e-01,-1.1616431469735199e-01,2.2564856454446605e-01,-1.2488370745249819e-01,3.3729651647038963e-02,6.4556666643600574e-02,-1.5041492532856121e-01,2.0891125440827996e-01,1.5367332598085842e-01,-2.8604843902492426e-02,8.6492991544688480e-02,-1.6799719689872752e-01,1.0737193918413949e-01,-5.5299105041151590e-02,-2.0765463163878846e-02,-3.1169842380520993e-02,4.8788020233933090e-02,3.7399475191411284e-02,1.0937751905164159e-01,7.7918180783523805e-02,7.6066027533877228e-02,-4.7282224770832361e-02,-7.7586683198121427e-03,2.7343288867917800e-03,1.4253883110893165e-01,2.1788901030585225e-01,2.2716499163833961e-01,8.7856035248619291e-02,-3.5278801767634582e-03,6.4291071730599544e-02,6.1993011466655437e-02,2.7140181540118779e-02,2.3239563352781593e-02,-1.3240741184412827e-01,8.9289244566476120e-02,3.1094703331747017e-02,-1.1759091678072027e-01,-5.4385378571227327e-02,8.4319794139452203e-02,3.7846960464318222e-02,-1.1818058981057997e-01,1.5200327863188037e-01,3.3838754118968373e-01,3.9743898079223669e-02,7.8192243986485277e-02,-2.9743135892827378e-03,-5.4909955002164383e-02,-1.3444523770697708e-01,1.2296395364242885e-01,-1.9154298203257071e-02,-1.4639835730897249e-01,-1.4271300227034681e-01,1.7414495143062515e-02,-1.9238667077801894e-01,7.1347376641960225e-02,-9.7853792981829640e-02,-1.5193211401151679e-01,5.3706802361732552e-02,9.8239828569667412e-02,-4.2802847157205881e-01,-1.6829918953387285e-02,-7.0320373281240550e-02,2.4033848625231891e-01,3.6155468718932798e-01,2.3800820367222353e-01,-1.5195492444044309e-01,2.4150273550296758e-01,2.1764585381786206e-02,4.1878019738645765e-02,8.8044890727119102e-02,6.2744989481834240e-03,2.2408022935938268e-01,1.1498228730120333e-01,1.2373199343400548e-01,2.2649133562386839e-01,-7.3171850965695298e-02,7.1698909131326191e-02,4.8956630402822082e-02,1.3483602254990118e-01,6.6351015779900380e-02,-2.6604948816060564e-01,-9.7332500756147466e-02,3.8358302730576575e-02,3.8525730374596993e-02,-6.3048225600326857e-02,-2.1811084175595402e-01,-1.4717848555221461e-01,1.1581400921032398e-01,-2.2025217803942515e-01,2.8775755877659348e-01,1.2730286034727048e-01,5.6670252420129547e-02,-1.0902635980211284e-01,-5.4412761108701226e-02,-3.0910196076752425e-02,1.4641755201970721e-01,1.4161496929957632e-01,-1.8077214112821505e-01,7.1953266083065570e-02,-2.5349371120736464e-01,-2.0785615924637749e-01,-1.8993314180151133e-01,-1.8465812178098076e-01,9.5271217431684985e-02,-1.0217287150703824e-01,3.7173169945593755e-02,8.7600194855976796e-02,1.6589855479565460e-01,1.0460279089577160e-01,-1.5227202367341497e-01,-8.1680269111923776e-02,1.2871656585361307e-01,-1.5302617729264004e-01,-1.2722350118286856e-02,-1.1867651316839938e-01,1.4718228545988485e-01,-2.0128207964751166e-01,2.0839671452766179e-01,-6.5505645069272762e-03,-7.8082655273732315e-02,5.0852012789912922e-02,7.6116727690513419e-02,1.0975331602558511e-02,-4.1548370105170727e-02,3.7543167428525051e-02,-2.9051816671751295e-02,-6.7628302998906514e-02,1.0706958274291678e-01,-3.2540323571986868e-01,2.2946208197547949e-01,1.7258158636377342e-02,1.3224103430167650e-01,5.0583999869275163e-02,2.2335591812164257e-01,2.3933255355512238e-02,7.1823790136908969e-02,2.1907138117493052e-01,4.1511292304521441e-02,-1.8729940808190243e-01,-1.2030696398592292e-01,1.0337150412733914e-01,1.6235687873936408e-01,-3.0629143984986548e-02,4.2182607970274372e-01,1.1319104296118486e-01,2.1613664659882889e-01,1.3794135538158298e-01,-6.2294879369995712e-02,1.3939166897963948e-01,1.4453602043440911e-01,-2.5795479053744227e-02,3.5629378468310872e-02,1.1243660992205889e-01,7.1866198877183443e-02,3.1756018981421268e-02,-8.7592023601641755e-02,-9.8317680007601979e-02,5.0361524548275118e-02,2.8034956493104418e-03,-1.5373495075039792e-01,1.0089343171798788e-01,5.1376124492148637e-02,-2.3607810097191720e-02,9.3135118828360133e-02,-1.2129910103964722e-01,3.2850661408458598e-01,-4.8649545999945046e-02,-2.3623102120893111e-02,-6.7246291518716306e-02,-3.7343614279321910e-02,-3.4161672353755057e-01,2.8016324577607088e-01,-1.7188863359093925e-01,3.0606476036960206e-02,5.7309851799477174e-03,-6.2759190982764959e-02,-6.3498352399145100e-02,-3.6044092332042721e-01,-9.4949530004422966e-02,1.6586004232601584e-01,-2.4475499006844670e-01,2.6421224119675635e-01,-8.4294164799206317e-02,-7.4234179513282650e-02,-1.5607950922026037e-01,1.4500340688270780e-01,-1.8257208701206268e-01,-1.5713127573720556e-01,1.6804126101203506e-02,7.1794758834453687e-02,-4.0459306448530061e-02,1.5204896591385830e-01,-1.0218553515702972e-01,6.2499425740018905e-02,-7.3499308042291600e-03,6.9549446564377393e-02,-5.1351531114120393e-03,-1.3263798288445572e-01,-1.2700677291305779e-01,6.7008116036983867e-02,-5.0542836388041260e-02,1.0797037305629098e-01,-5.6465785509865286e-02,2.2253631987852136e-02,1.6235008532087028e-01,1.0405152368934278e-01,-5.2995243942694628e-02,-4.3962666666045813e-02,1.7400857262528474e-01,1.6338395609425765e-02,-7.1960359660343656e-02,-1.1716831992861226e-01,2.4456746813707680e-01,4.8298762246160032e-02,-1.8982674102312602e-01,-2.2398986937046073e-01,3.7695165882207338e-02,3.8168920785166052e-02,-1.3066062859380873e-01,9.0750988946255474e-04,7.1316786626779677e-02,-1.0433145751297562e-01,-2.1751184892969699e-01,-1.1497235913549847e-01,-6.0350671589777166e-02,2.6653227104746846e-01,7.0742639394967607e-03,-2.0170868792307292e-01,1.8662998888660739e-02,1.8946523534275506e-02,2.9161061396688126e-01,-4.6916123906974395e-02,1.2769335587899874e-02,2.8750802629459871e-01,-2.6279017790589426e-01,-4.6230752184778129e-01,1.1360902407858192e-01,-9.9160827891901171e-02,1.1124777383261031e-01,1.0276733008381266e-01,-3.1786472350985501e-02,1.1454041421634671e-01,-1.3606711293953780e-01,6.3602181191893148e-02,-8.7034211222580871e-02,-2.5219505827787925e-02,1.1420149946735426e-01,-2.7222772814592313e-02,-9.2310169484224935e-02,3.9100809411630640e-03,-6.1889247015441531e-02,-5.6597162841393558e-02,-6.4171621749324032e-02,1.3749981944622283e-02,-5.7593354073564550e-02,4.2555619676166230e-02,-4.4433267491354456e-02,-1.7805186305157102e-02,3.0113359905457859e-01,-5.7208160122550700e-02,2.7078697185282267e-02,-2.7174176880784784e-01,-1.0342147213872354e-03,-1.1512611449144977e-01,1.2720546417368675e-01,7.0353986980460692e-02,2.0260073906810078e-01,-6.2310789528567223e-02,-1.8803376771816935e-01,-1.4429788239503472e-01,-1.0021178040823463e-01,-1.8391888424007283e-01,-2.7175561527378288e-02,3.8990598802633288e-02,7.8437928487573028e-02,-1.1493848254292288e-01,9.2647188146827153e-04,-1.2688561410864402e-01,-2.0695948310184739e-01,-1.1153947531959663e-01,-6.0922805757321133e-03,1.2641664820580416e-02,-1.2051021208842663e-01,2.7028918885181352e-01,2.2369553957415630e-01,4.7541386962914767e-02,1.4463640913214756e-01,8.7432204640352812e-02,-5.9006374194413583e-02,-2.6396427249547783e-01,1.2320608335046879e-01,-2.6693663062699013e-01,8.9038067677702434e-03,-2.5939745545127924e-01,9.7710578579909932e-02,5.9453283159100659e-02,1.6645709045502929e-01,-2.0057320209292659e-01,-2.3167367541670713e-02,-4.8054080063982395e-02,-2.7794930000142326e-02,2.0599973434693158e-01,-2.0831967530426782e-01,-4.5850397637806309e-02,1.5707998064838752e-01,-5.6490006697379691e-02,7.3154104339297504e-02,5.6697242600719677e-02,1.4525786396405706e-02,-2.9127640627607165e-01,-2.2434568174160630e-01,-1.2019801421578756e-01,2.5434993018204760e-03,-1.2823049797868276e-02,6.8619220989432281e-02,-5.2070228184386294e-02,-4.1394592681761891e-02,1.6396461685737837e-01,-1.0493625474367602e-01,-3.7062442980008888e-02,9.0003250841961757e-02,-1.5488197955153440e-01,1.7184667326101669e-01,1.9529656510115223e-01,9.7462721090609050e-02,-3.9772363706834603e-02,5.6430989414921043e-02,4.6643161820909725e-02,7.9108974634343590e-02,5.7713861371056059e-02,-2.2855034840769166e-02,1.8183752590954980e-01,-5.3228811462635833e-02,2.7468294552497147e-01,1.6597202905344144e-01,-7.0146404951211008e-02,-1.1127495035504069e-01,-1.1989799959780852e-01,-1.2326587977381066e-01,5.5861214811626279e-02,1.2085947327939534e-01,2.5638228085747122e-01,-3.9561266600855571e-02,-3.9259329030986924e-02,-2.0183809432312597e-01,-1.3206317341844001e-01,-1.5837469110365132e-01,-6.1178190630019273e-02,-2.0204242914364501e-01,7.8744614361659027e-02,5.4110688798625850e-02,-9.0068787903340747e-02,-2.6162829603059694e-02,-1.0097754468754443e-01,1.7579206742983113e-02,1.5036405793149960e-01,3.7320633981012091e-01,-3.6544204161172300e-01,-2.2689765473526802e-01,-1.0377789915802313e-01,1.4565610243161781e-01,-5.9389765118925547e-02,1.3675870196666590e-01,4.2131250820296867e-02,-3.2463964063370217e-02,1.2054148338629124e-02,-1.7218850942585270e-01,-1.7880765154830018e-03,-4.3818677959856590e-02,1.4698329491596412e-01,-8.0962922260729084e-02,-1.7234148063280715e-02,8.3245444304004407e-02,5.3180477302735438e-02,-8.0423268793061276e-02,-1.2354655611526628e-01,-1.3296179856909229e-01,-1.5914478780311345e-01,-3.8075082145487965e-02,1.2224694801377580e-02,1.2155649256904351e-01,5.1583713707365189e-03,-8.4123260882856109e-03,-1.1272101772424115e-01,-1.4652276359123542e-01,-3.4467928425738252e-02,5.7085188972543090e-02,-2.3746389766023313e-01,-2.7485988570321973e-01,1.5536487558518550e-01,-2.6631124130547069e-02,-5.2832633109314346e-02,6.7154002067909599e-02,5.0200680637206806e-03,2.0616792786621954e-01,-2.9395571360888673e-01,3.5178843685260218e-02,-2.1708255651732924e-01,2.1476893603968369e-01,1.3265767601359871e-01,1.8640192264035393e-01,-1.3327659400181135e-01,2.2410675134099947e-01,-1.5801658316949768e-01,4.3746672186248156e-02,1.8526439717206894e-01,2.4898545430995250e-01,2.0566782440657203e-01,-1.6165977700740200e-02,-1.3872924291422126e-01,-2.4025333149963132e-01,5.5085237950374587e-02,-1.2393006097067190e-01,-1.1829296492763292e-01,1.6455202237955752e-01,1.8614264927875459e-02,1.2968354452228018e-01,-8.7147813919254219e-02,-3.0053252858495555e-02,-1.3154083926079172e-02,2.1547043783342515e-01,1.4383868656584797e-01,-6.9952175802122332e-02,1.8381754066527584e-01,-3.1362553430820450e-02,1.5678405138005250e-01,3.7606572165215055e-02,-6.5423890235968352e-04,1.0431238523881944e-02,1.4939833896057596e-02,2.7421847507410470e-02,-4.6734193732778382e-03,-2.2575564233409406e-01,8.7705974118199165e-02,-1.1651922562816350e-01,-5.7538758115303512e-02,-4.2864576418825226e-02,-1.6726155923338101e-01,-5.0044399402226082e-02,7.4804811521544820e-02,-2.3458546331679064e-01,-1.0120265416301611e-02,-4.6947775502377831e-02,-1.9596490455839916e-01,1.5355894781587959e-01,3.4702812587718129e-01,1.9852921421225589e-01,2.5640917332445201e-01,6.6281750881333396e-02,8.8635207576388167e-02,3.7148869512557198e-01,5.2224766793583940e-02,-8.4039449061808491e-02,-2.1618810945667277e-01,6.8645308813326575e-02,1.9945005786222383e-01,-9.2064757991294072e-02,2.7418849635432660e-03,-2.2472835170430105e-01,-2.1763796723055558e-02,-3.6582147644727836e-02,1.0412419345923095e-01,6.4673609653519593e-02,1.6935253170919726e-01,-1.0104203733277628e-01,1.2756984704695029e-01,9.9336474253115231e-02,1.0042049142828620e-03,-2.8433680789804255e-01,1.8262238054461871e-01,-9.3437296988194932e-02,1.3888890380151342e-01,-2.5121315289889390e-01,1.2724533606057742e-01,1.9336151048112385e-02,1.6915578787544228e-02,1.8801968117955592e-02,2.0075622299803894e-01,-2.2782646132315513e-02,-3.8905018674147709e-02,8.7077854237726557e-02,-1.7486397533552803e-01,3.2019768399289675e-02,7.1436684374932710e-02,1.4715396919174869e-04,-1.6830614421358282e-02,2.2171421786514073e-01,-3.0641249266244654e-02,-1.7156239807417373e-01,1.6367585094828588e-01,2.6297668317996775e-01,-1.1503752938266890e-01,-4.7831437034052557e-02,8.2342222423542513e-02,5.1473098756761371e-02,-1.5113797161200432e-01,-2.4678360380229855e-01,1.8031828520326212e-01,-1.2516213565179893e-01,-2.5239758875022212e-02,-1.8944230140689584e-02,-1.1051677926436874e-01,8.7514153384754562e-03,1.2741403325263401e-01,2.4254945777758316e-01,-4.7143120448667718e-03,-2.0823095231690777e-01,-6.5282179233873722e-02,-4.9326454752348779e-02,-1.0636511901550204e-02,-1.5510626637355365e-01,2.5482006502790094e-01,3.4319909761830841e-01,-2.6397294215125440e-03,5.0640237775822140e-02,-2.1205549769380192e-02,2.0214963141997164e-01,-2.2849918513864109e-01,1.8593253804805240e-01,2.1473040469629576e-01,-8.7393008997550092e-02,-1.7989552092002101e-01,-1.2894537733343939e-01,-1.7850107173384303e-01,-3.8541988137041343e-02,-1.6231605427845325e-01,1.4871379471541813e-02,-4.5583262116732998e-02,-7.9413391505074316e-02,4.1269409677308057e-02,-9.0964522979887677e-02,2.1520030916839610e-02,-3.3797987645370980e-01,-8.9140787422781850e-02,-2.2235305087508167e-01,-8.9544374156037734e-02,1.4387847526812261e-01,2.8530392471290639e-01,1.8380241997223272e-03,-2.8824223540472577e-01,3.2627758928599239e-02,1.3880019929792398e-01,-1.2268566604521780e-01,1.3562996457061111e-01,-2.1625727942662681e-02,-7.9627144265943167e-02,-5.8116922847167721e-03,1.3106193455166479e-01,2.1715177314749232e-02,7.8740745254634398e-02,-1.2927585285170506e-01,-1.9919892484262772e-01,-6.5472035306864532e-02,-1.3422452359984324e-01,6.5144924597360987e-02,1.8310082344187165e-01,2.0879826811518171e-01,-4.0228993403981027e-02,-1.8024007398251270e-02,2.4129226530753877e-03,5.8241812416112829e-02,1.5670380890564889e-01,2.8118557512682996e-02,2.1172823343823988e-01,6.2293415406320607e-02,4.6117796706600898e-02,-3.0906257172860090e-02,-2.1261243880348901e-01,-1.5971146003300862e-01,1.3491038830759132e-02,-2.5971991180652326e-02,-1.7842915605692650e-01,-1.0233589640770324e-01,7.0202888828211810e-02,-4.4398855036114716e-02,1.0981387708052272e-01,-1.4691821095930357e-01,-8.3993270518307128e-02,3.7954989865461176e-02,2.1506308758357290e-01,-1.9006823611071738e-01,5.1108202936743265e-02,-6.6216624846552691e-02,-5.9813737927038542e-02,-9.6694877710251093e-02,1.0009438427023565e-04,2.3232957273595211e-03,1.9012403378445970e-02,2.3001556304210097e-01,6.5616965087267914e-02,-1.7586733538970839e-01,-9.1005745590491155e-02,7.4505620798299713e-02,-2.2699439138907192e-04,1.0921239868371957e-01,-7.6643066880140304e-03,1.6230747551790706e-01,-1.1484896606145751e-02,1.4505809221629548e-01,2.8599680118831905e-01,1.9184824053967323e-01,2.7606984795492062e-01,3.4722650775006669e-01,-2.1569851494106512e-01,-1.2147102037455826e-01,3.7447913396155136e-02,1.0534646829737231e-01,-3.7101897247915620e-02,1.3648236396680533e-01,1.2058959592412826e-02,1.5948960656152766e-01,8.6441116410313171e-02,3.4118741802957930e-01,3.6749954645028386e-02,6.4766399664707527e-02,-8.8346516675000167e-02,8.6597506569499327e-02,-2.2518877467635706e-01,1.8503880139678960e-01,-5.7012852548816127e-02,4.6129864435662762e-02,-1.3583730764973431e-01,8.3786160897605669e-02,-7.4473871241286377e-02,-1.0960336987209862e-01,3.1358638037507880e-01,-4.5308241392798210e-02,2.8385986823454357e-01,-4.0991943655198440e-02,-2.3701781273456057e-01,-1.5786706329755038e-01,-2.5865440108995916e-03,5.9179393695616318e-03,1.1064090706473503e-02,1.3857389060573738e-01,2.0452543584972518e-02,-7.6507652101699936e-02,8.8112586143024460e-02,1.0879540256130432e-01,2.6389886808294766e-01,-8.5581045804056899e-02,-3.4525811533143651e-02,-1.3704949045995646e-01,-4.3120346686106703e-02,-1.4815531153543757e-01,-6.5435793330667777e-02,-2.9266623389268276e-03,1.6164667297562654e-01,-1.5532639586093122e-01,-9.7259928162312451e-03,-2.4227863289908944e-01,-8.3060103211546429e-02,-1.1633669896586038e-01,8.2334144738358192e-03,-2.9463223351172391e-01,-1.3473609993043789e-01,4.9368567613104507e-02,1.4958888903874409e-01,-9.2246842041000914e-03,1.5912214251344853e-01,1.4542941458650926e-01,-1.7134923709706784e-01,2.0681189684327517e-01,-1.1054035945623333e-01,5.7379609512390475e-02,1.7774149057786079e-01,2.1375610642753631e-02,1.3718908188679441e-01,-1.1105804338018152e-01,-7.4683019382398463e-02,-4.0852925537997291e-02,1.6706426021382376e-01,-1.3081323441826115e-01,-4.1677554804493509e-03,2.2350742811153301e-02,1.2135783252315785e-01,4.3009028424587259e-02,-3.6892454484584759e-02,-9.0982783222027047e-02,-8.6550587308373533e-02,2.7485000190767273e-02,1.4855037957644601e-01,-3.5926982915209671e-01,2.4129653163790968e-01,-1.9600403615356006e-03,7.2421611629403665e-02,-2.8091658604707354e-01,-2.2808349403956533e-02,-3.5681938618938182e-02,2.6660476060069066e-01,7.2684709169038089e-02,2.2496031104014236e-01,3.7438967014668000e-02,4.0435523073072854e-02,-6.7890914213357814e-02,1.4011194529666293e-01,-3.7058362627352009e-01,1.5734060740688366e-01,8.7559071826443402e-02,1.6545541468785055e-01,2.1742146187235767e-01,-7.3400647920101134e-02,-1.3487184228569074e-01,-3.4176033302895495e-02,9.5178747532056865e-02,1.0987714817384248e-01,8.5864932082481235e-02,-3.7533959996485414e-02,2.5969029505935032e-01,1.7193462676493704e-01,-4.3718308322276460e-02,3.9147743706038005e-02,1.2935917737520577e-01,-9.2456329356699216e-02,-4.7747946796943774e-02,-6.7106459887564820e-02,2.7739899938626922e-01,1.8427371564688944e-01,-9.5922658513818371e-02,-1.1934397924701301e-01,1.9900078428242113e-01,-6.4264228253420375e-02,4.9724176310339763e-02,-1.1563680466739357e-01,3.8627409597874560e-03,-1.7571026762515626e-01,-1.5326462847556549e-01,2.6760094385856009e-01,-9.6510217466052012e-02,5.8304428759587988e-02,1.8676007032141246e-02,-6.8314212657165987e-02,-2.3482045109928890e-01,-5.7715670276845467e-02,-2.0426101349770909e-02,6.8594354682330605e-02,-1.3739326743874419e-01,-8.2218096545953537e-02,2.7472579061296604e-01,-1.4645463491839827e-01,-5.5418679484317689e-02,-6.4708981607700181e-02,1.9846301689794085e-01,1.7744327861918086e-01,2.5566315135363660e-01,4.0180027312921147e-02,1.7908995885562401e-01,1.5556174681718599e-01,-5.6583488150151261e-02,-1.2489286241758078e-01,-5.9689327322762532e-02,-4.8017900539138771e-02,-2.4987499480658484e-01,1.1995364352166762e-03,-4.8205920030640101e-02,5.5848263958564529e-02,-8.0541151571913078e-02,1.0612525870977010e-01,1.1214008005339827e-02,9.5204120422684835e-02,1.8191923753872283e-01,1.0100165356292959e-01,1.6969718591611935e-02,2.1253440339312643e-01,-1.6606050105299369e-01,-1.9747792961426483e-01,-1.0166418831180825e-01,-1.5616827594220475e-01,1.3736483179168096e-01,-1.7116417368458806e-01,1.5616571568605159e-01,-1.2912798008259047e-01,2.0366971090248397e-02,1.7212078530792188e-01,-9.9487400929009498e-02,9.8567870069435973e-02,2.2552471211683284e-01,-4.6827762227726374e-02,3.4016557515289869e-02,1.2009004693739217e-01,-3.2813229994182545e-03,-1.8872907054524435e-01,8.5059298645099479e-02,-1.2572054472912320e-01,-2.6333765470998810e-01,5.1620918668619675e-02,-1.7808901506281938e-01,9.5551149362760629e-02,1.0463447273238728e-01,2.6808154828072217e-03,-2.1630824198678991e-01,-2.6568488714939251e-02,9.1968622608944603e-02,-1.7844500574899797e-02,-1.0343896108663952e-01,-3.4092380231928003e-02,-1.6897822367979476e-01,-1.9757666196861978e-02,-1.9037418133252282e-01,-2.2358878900017733e-02,-1.4237132876680875e-01,-6.6250307644428380e-02,-5.7734237219301890e-02,-7.9383359512128944e-03,1.3997666101906045e-01,-8.5361694995252976e-03,-2.9554172084550845e-01,-2.0832546853391526e-01,9.9232385226361311e-02,1.2806324552277443e-01,-3.1734202882400225e-01,3.0764484327081948e-01,1.2633022032485947e-01,8.4992489708603944e-02,-1.3167657864412938e-01,-2.9533225446075034e-02,-4.4081309554937345e-02,-1.7087734084252001e-01,-8.0737446221579440e-02,-1.5451875900173651e-01,2.2678093733466589e-01,1.8494117147817501e-01,-2.5000759873715153e-02,2.8021927478762937e-01,2.9144433625769156e-01,-4.9492214562300643e-02,-9.9933762607661097e-02,1.6513167770897791e-01,-2.3907007538585257e-01,-1.4802575864870676e-01,2.2006665728289319e-02,2.2682750780816191e-01,1.7330021630000372e-01,4.6520987986197596e-02,-1.7135626727108738e-01,-5.4329480581522677e-03,4.5443399428168781e-02,-1.8710618989505690e-01,-1.1360662394129314e-01,8.7924288686443322e-02,-3.7785503017541390e-02,5.4071291697594150e-02,1.2988619995408709e-01,-1.4700594991619703e-01,-4.5774624701967158e-03,-7.3333890676939156e-03,-9.9673702323567204e-02,1.1891287185913713e-01,-5.4059522127298504e-02,1.6403046731800430e-01,-6.9555743753099419e-02,3.8768590695972570e-02,6.2902685237458164e-02,1.9566908628913589e-02,4.4065001170600117e-02,-1.2726773811719547e-01,-5.4264608584852721e-02,5.8350396836698709e-02,-7.9325038211433899e-02,-3.1862848348381079e-01,2.3819918163568962e-01,1.4239976493170373e-01,-1.8825636887765040e-03,9.9760191997409944e-02,-2.2564023541512290e-01,1.4510065440849612e-01,8.3931060774651206e-02,-9.4630366782465558e-02,1.5820230404668789e-01,-1.0126714265258094e-01,-2.9244104499900628e-02,1.5359130871431804e-02,-1.6824760856841670e-01,-3.0922328140788088e-02,2.2879764194016539e-01,-1.8307959694490974e-01,-2.5486805956027092e-01,-3.7363684267270875e-01,-1.0013448580098808e-01,2.6229860090840211e-02,1.8610237561891768e-01,-1.8660815815297227e-01,9.0484572873514163e-03,1.1271683362772560e-02,5.2994332783805005e-02,1.2205898745974540e-01,-1.4293882926433932e-01,8.2332186658934978e-02,1.9994444499590625e-01,2.3555495687573788e-01,1.0327208140728666e-01,-3.3888136181816450e-02,-7.9415872346099092e-02,-1.1137465669161825e-01,7.2982718914493469e-02,1.3300119410363898e-01,-6.8256319429563783e-02,-2.1405387172434093e-01,1.4645932856771909e-01,-1.0041825971805521e-01,-2.7548024468824400e-01,8.2546390496103433e-02,-6.6944805495505466e-02,-1.4965622024436942e-01,2.2730067274067478e-03,-5.1198698829720363e-02,-9.8835058540221662e-02,2.2554004343399212e-01,9.1240248908921032e-02,-1.3304885592823090e-01,-1.0858605434774583e-01,-1.8325268085562169e-01,1.2056981070458318e-01,9.8726726432781214e-02,-3.3255108669476216e-02,4.4566091264041569e-02,-9.1791550272577849e-02,8.4424276043540608e-02,2.9609062521186813e-01,1.0999869416220359e-02,2.0846411975234788e-01,1.6971609434334542e-01,-7.4971170102861945e-02,1.4258675448368541e-01,-3.0263626083892950e-02,-5.1730225382846662e-02,-1.4902023559894800e-01,-1.3484331507604344e-01,-2.5170905244577124e-01,-1.2829158547727701e-01,1.3161076725667578e-01,-1.4016383042106029e-01,-1.5516169194425466e-01,4.4652711846323190e-02,2.5353997950086438e-03,5.5118840264628849e-02,1.3436798551612955e-01,-4.0343525289713557e-02,-3.5049657704332757e-02,-3.1011351775626694e-01,1.6974123482044887e-02,-7.0072748404645287e-03,4.8095539728188412e-02,2.2101736507364025e-01,-9.2070254139713467e-02,-2.1280466499906117e-01,2.8423426782733116e-02,2.0178649957935921e-01,1.3603946023287530e-01,1.4909113309608837e-01,2.3777679765974925e-02,-2.0210604467471516e-01,1.3706561380452917e-01,-2.6908586402679935e-01,-2.1252774693459428e-01,-1.4796408913673670e-01,-1.4670276811784794e-01,-9.3940589549436695e-02,1.6785370615778172e-02,1.0712194100015567e-01,-4.9322717151293480e-02,-2.8635371250929388e-02,5.6088281445352266e-02,-6.6216154303424757e-02,2.2503427430849199e-01,2.7686702054077909e-02,1.2880306096243957e-01,1.0926842045105647e-01,-1.5612248748297253e-01,-8.1896101184851730e-02,-2.3288343757665017e-01,-2.8008577662397782e-01,7.5349756895008099e-02,-1.1903909077783624e-03,-8.2521304648395816e-03,-1.9775034154772008e-02,-2.7372805896657061e-02,1.6668560998338987e-02,1.7047693287703603e-02,-2.4891545493361769e-01,1.0576765926878899e-01,-1.8273127915390164e-01,7.8998337182702619e-02,-6.7022509461929919e-02,-3.5712515038314158e-02,-1.1746216260268097e-01,-9.7967368210081202e-02,7.3469876312193157e-03,1.3841126218260358e-03,-6.4733741371379216e-02,1.0954010207102520e-01,2.0206895106227966e-02,-1.2916869182699833e-01,-2.7880165390827000e-01,2.6854651249955321e-02,-6.9924125082065150e-02,1.0839706959117022e-01,2.0839024186368660e-01,-6.5248248755392479e-02,-7.3134583974545392e-02,3.1128591079509133e-01,-2.4533998539362364e-01,1.0851920034191156e-01,-3.0165242227202821e-01,-4.9391215577246784e-03,-1.1572432974810447e-01,-9.5191941025696336e-02,1.5124606045962508e-01,1.5665442409690741e-01,-2.1168655227354782e-01,-1.0723161601560278e-01,1.3731706132974866e-01,3.9132830519503801e-02,-1.8429507533271125e-01,-1.8881571427385216e-01,2.7942682125057013e-02,1.1985643944796794e-01,8.1904219255030122e-02,-3.2844559594364713e-02,9.4467003726745422e-02,-1.1518373316626410e-01,6.9040795877243433e-02,1.5645357748172559e-03,-2.6066754702993394e-01,1.8616098365102646e-01,9.3651917392323189e-02,2.4098828049049820e-01,-1.0898429028313781e-02,-2.3682697728804472e-01,-1.5606772141348746e-01,-1.4056675934851134e-01,3.4386263696327185e-01,-5.8778539179289664e-02,-7.7377250542432732e-02,1.3088307874364408e-01,3.2104309434000451e-02,6.6007556980137827e-02,2.6574772295310023e-01,7.7333082039223094e-02,-1.1990604165490616e-01,2.4006017944885899e-01,-9.6112845331928959e-02,6.1510751261132160e-02,-9.7372802946793249e-02,-7.9433663986517161e-02,-8.4420626470922480e-02,9.6264220288239569e-02,-1.8616475028642263e-01,-2.8163598777618051e-02,8.0087671185347709e-02,-2.2382582804426962e-01,-7.1163081208887854e-02,3.8716142546992099e-02,-1.2881949228203818e-01,-3.2431162549122802e-02,7.0792979635696265e-02,-8.8965576117950348e-02,-8.2926853874215847e-02,1.5779621454328982e-01,-6.4787809959267126e-02,-4.1387872230032499e-02,3.2752018899021901e-01,8.6581194203988715e-02,2.1053745400207879e-01,1.0111007042037667e-01,3.1602696499180016e-02,1.1043844056476811e-01,-3.9474739047010307e-02,1.3604118525765674e-01,-1.5157347022297631e-02,-2.1076245842608410e-01,-5.5357793413625025e-02,-1.5986574120608232e-01,3.0632992007358889e-02,1.1927668068236752e-02,-7.8523460053482041e-02,9.1149016559846821e-02,4.1573308925843155e-02,-1.6309830303322403e-02,3.1078673594377167e-02,-1.1515220495576271e-01,-1.5327968412595036e-01,-2.7733537141080178e-01,-7.4134081025656356e-02,-1.5282452220108406e-01,-6.4301748164682843e-02,-5.9908549402053909e-02,-2.4937910771094286e-02,-1.1828531917603367e-01,2.9081901687620598e-01,1.1137321395788508e-02,-1.1691344511806463e-01,1.8939211976669174e-02,6.7056641917779297e-02,-3.0615711467290008e-01,1.9043053119197925e-01,1.4974818673557688e-01,2.1724044723736502e-01,1.4070281674308022e-01,-4.0331274271363300e-02,-2.4762960357511948e-02,-5.5528135088043828e-02,-2.6684290722972768e-02,-2.5450326944327355e-02,-1.7871578882461106e-01,8.6647073409891390e-02,3.9698224252441794e-02,-2.1512112791311103e-01,-3.2179844044359246e-01,-3.5116819335841720e-01,-3.5657311867266173e-02,1.1051231640203853e-01,-1.0520837661131983e-01,1.4927122144133947e-01,9.3020928608586531e-02,-1.1006182461329381e-01,5.2733237786276449e-03,-4.7676201891517729e-02,-4.5680472735335285e-02,-3.5516046543902779e-02,-1.0775360212666335e-02,5.9089312842242080e-02,-1.5940085908587271e-02,-1.2614640695376478e-01,-3.6500888304585484e-02,7.2812526997212315e-02,-1.7741944804320633e-01,-7.3498443559312135e-02,1.1377757882069976e-01,2.6724567587770770e-01,2.7176174623885085e-01,-1.6930884759834633e-02,5.4315541626999947e-02,-2.3688443696793515e-02,5.7017602998680833e-02,1.6282921799574052e-02,-2.1402990153967877e-01,2.6957395603047468e-01,-6.6451848726360507e-02,-2.3852195881299029e-01,4.4513546254451981e-02,2.5658052285188060e-01,-1.2721381106502808e-01,-1.6868523188649245e-01,-2.8399443421209536e-01,-1.5197466568866597e-01,-5.3295967321703872e-02,5.4320509678159594e-02,-1.0767173852402361e-01,1.8513702334772572e-01,1.4771402908609448e-03,-6.7354441308312557e-02,-1.1198412744955850e-01,-4.8263002649490447e-02,5.1500212764873488e-02,4.2411170309886975e-02,6.5013369467013776e-02,7.2315650196031034e-02,-3.7297788181712005e-01,-9.4639043706488540e-03,2.6455276944952005e-01,1.0939375876294274e-01,1.5882106618464495e-01,1.3300561488314908e-01,1.5225053372913581e-02,-1.4233519899022781e-01,-8.9484052594031679e-02,1.1406090716268280e-02,-1.9054063428659399e-02,-6.6939348595107709e-02,2.4893581751328150e-01,-2.4530975463505672e-01,1.0127866999660411e-01,-3.4457986709208591e-02,2.4435251212148168e-01,9.3654151949677279e-03,-9.8206234219043856e-02,1.8821950223516437e-01,5.5726800766798264e-02,4.7185893215142161e-02,-8.6208901794755363e-02,7.2142874264228080e-02,-2.4949385080657506e-02,-7.8135451187255872e-02,2.1942027530981634e-01,4.1176408485490434e-01,-1.3514451196738023e-01,-2.1179787030355664e-02,-5.4120785384681541e-02,-6.1088597734118052e-02,1.0398177162192539e-02,8.7938796637275427e-02,-2.1026065859138490e-01,1.2224121844692588e-01,-8.3512187926095938e-02,1.4403896205824068e-01,1.3383189915216265e-01,-5.4055910697648042e-02,2.8685228744273256e-01,8.5074664955199367e-04,-4.7432542620640623e-02,-1.0258756105214915e-01,1.1458898699161003e-01,3.9532470727883059e-02,1.8178217405839497e-01,1.7054687883016051e-01,-1.3409830032660741e-01,-1.2520015111248345e-01,-8.5085007453595318e-02,-1.2165944031361146e-01,-5.8925810395376033e-02,6.8626803382397086e-02,6.1138142785276524e-02,-3.5064951458039595e-01,2.6237601192876867e-04,5.2837577540191159e-02,2.8223857067803759e-01,1.3925782053556254e-01,-5.0267839205086165e-02,9.9290800827918885e-02,-2.7180776711491189e-02,-4.5832809061592872e-02,-1.9089577780723421e-01,-7.0402427718394223e-02,4.3816657131691208e-02,-1.2047538721820466e-02,1.9504700684192827e-01,1.4759750170290564e-01,-3.9740493339301255e-02,2.8361958144830218e-01,-8.4072174820503137e-02,-1.0322329826382595e-01,1.0433041939947832e-01,9.7632316579099154e-02,2.0293305060722802e-01,1.3504500832824007e-01,1.2978285846418278e-01,-5.3444990695935633e-02,-2.3217976278974539e-01,4.5602756625180152e-02,-3.1987911864335705e-01,2.9220286878217133e-01,3.9034636677866705e-02,-6.0482898971416753e-02,1.2861679742734367e-01,8.6839021940200697e-02,-6.8971158544612221e-02,9.5561268000871669e-02,-3.9544903790648164e-02,1.5046463401267895e-01,-1.6574368498337433e-01,8.9395420383641233e-02,2.4418665695438713e-02,-2.1663674526099341e-01,-1.4555895118299092e-02,-2.8874253327710314e-01,-7.1156572474708871e-02,1.7668300619651039e-01,-5.4518330813889777e-03,-2.7498982044349606e-02,-1.6674617674088157e-01,7.4284346296105946e-02,-7.5442682552265689e-02,-1.4722094234327871e-02,1.6491932671991083e-01,-4.5108680519588343e-02,1.5124322954866962e-01,-4.7229079135761701e-02,5.8856871102245835e-02,7.0612245044691824e-02,3.3849794451541730e-02,-1.0273745422160310e-01,-1.6059937593158222e-01,1.3848735890128799e-01,3.8030637416689453e-02,1.9618748785300466e-01,-7.4336471970870843e-02,-1.3348411662612267e-01,2.3680077685845159e-02,-5.7419305761574946e-02,6.7028342479218711e-02,1.5122135785949470e-01,1.6855648302704293e-01,3.6555972529858934e-02,8.7400483707056525e-02,-1.1317546200963241e-01,-5.7252238267709782e-02,2.6498454384781414e-03,-5.6583231207805356e-04,-1.5097865648556518e-02,5.7952691747778333e-02,-3.6745421332200590e-01,1.1127064041782794e-01,7.9322232522600650e-02,9.0479413963037256e-02,1.5436264166523267e-01,-1.6948070176190227e-01,-5.0781411959238666e-02,6.0859649813091624e-02,8.2159201368141491e-02,3.1349078139527267e-02,-1.6076880091157950e-01,1.9933756809220973e-04,2.1547825932140038e-01,-9.6057202215231605e-02,-7.1379395237329460e-02,-7.8870135214443984e-02,2.7526535339032498e-01,-1.7863760906254983e-01,5.3917840446254639e-02,-1.7465713919773515e-02,2.7807522396795237e-01,-6.9687923997857323e-02,-2.7307858640046706e-01,1.0467503612782324e-01,-3.9791077416330939e-01,1.0661642357950704e-01,1.3401998069676438e-01,-1.7855261450956886e-01,-1.7057604620793540e-01,-9.4248196153394220e-02,-5.0607087739116631e-02,-8.6407773695461987e-02,-6.5333401436666799e-02,-1.4899321699802237e-01,2.3163910531630069e-01,-2.1207538635622072e-01,5.8407743161385549e-02,-1.9913756539561686e-01,-1.5299376779786348e-02,2.2448608878158388e-01,-1.0090308055363345e-01,-3.0453924432456689e-02,-2.6307317588306515e-02,-1.0476998952915366e-01,1.6418998274579177e-01,1.9824438746925530e-01,2.4426115934927956e-02,-3.3553527435653863e-01,-4.4809568050013869e-02,7.5508736036157750e-02,-2.1029564406397638e-01,-2.2948093040885004e-01,8.1474379566447597e-02,5.1080255537401996e-02,2.1783534589058340e-01,-1.4872752611806545e-01,-1.2545118087777604e-01,-1.4786091359556824e-01,-4.8373488983921520e-02,-1.3470678509489920e-01,2.0414172306673345e-01,1.4845348376482662e-01,-7.6450007655716509e-02,-1.5084839898991234e-01,4.3065182826147165e-02,-1.7497462650388939e-02,-2.3517164162289206e-01,-3.1605975802106889e-02,1.3938477196250484e-01,5.8636889882645760e-02,5.2297306971168800e-02,3.8652113722589827e-03,6.4668912988568791e-06,-2.2630209318239128e-01,2.5759371398279687e-02,-1.3147540677450864e-01,-5.1496975875952825e-02,4.2178991907966326e-02,-1.7635042497501197e-02,-2.3689183811444958e-01,-4.6830905287847849e-02,3.9202084372838432e-02,-8.3223500813122117e-02,-2.5840821004579534e-01,-2.1172247538960906e-01,-1.6529418354150446e-01,6.0882444238847450e-02,-7.7425513762508169e-02,8.9288816576664792e-02,1.0780820910578828e-01,1.0814935790883737e-01,9.4190138671595130e-03,2.7522020243393036e-01,-5.1957351036609076e-02,6.8685168538470176e-02,1.0425761020036559e-01,-5.5526234393360088e-02,3.3561100145574320e-02,3.5590455996301541e-02,-1.8592144841141914e-01,4.0448604992164633e-03,-2.7218954584486910e-01,9.0639830821908129e-02,1.8702676544951273e-02,3.8440184007963056e-02,2.7022939370608470e-02,1.4788988039999350e-02,-1.3107832301780109e-01,1.7725394341933398e-01,-1.9751077905447719e-02,-1.9777687479530381e-01,2.7157506190582926e-02,3.1094115346539036e-01,-5.4887215669475624e-02,1.8984093656070933e-01,-2.8619015944848547e-01,1.4255405185231171e-01,2.5772409338384822e-01,-2.1758734303596727e-01,3.0713690012201214e-02,1.3373742889059573e-01,2.0965742105757534e-02,1.1713622171982029e-01,1.9214283125486251e-01,3.9253734204208912e-02,-7.0071290801808156e-02,-1.0575513758178089e-01,4.1221448514741091e-02,2.9758791237054633e-01,5.5337168048146181e-02,2.8198620906660116e-02,-3.4075072871060701e-02,-1.8917395345514704e-01,1.8948302130253925e-01,-6.9868017296225188e-02,-2.9074757183294542e-02,2.1918921208739683e-01,1.6665689515511489e-01,-1.4091522346139443e-01,-6.5360405304408179e-03,-1.3110904740121632e-01,3.2505018531407914e-02,4.9322542133198533e-01,-2.4618298485807136e-01,-2.4826103969901689e-02,-2.0478190413528247e-01,5.7070405361900910e-02,-1.9425492337364914e-01,3.3136926339102077e-02,2.8263895124476024e-02,-1.1354287250555242e-01,-2.8127381731417593e-02,-7.1346532410347966e-03,4.3491953746546096e-02,1.1919211439708054e-02,1.0931510869702825e-01,-6.3415193667815645e-02,9.9634144038227221e-02,-9.6593188745403152e-02,3.8504355606924848e-02,-2.2172401095026453e-04,2.2719639442162320e-01,-9.8196212047492584e-02,4.6122237810561004e-02,-5.6558985322528168e-03,-1.1592831949977364e-01,1.0801103637248279e-01,-1.3781448719844624e-01,2.9284724719297334e-01,-3.6778696660708918e-02,1.1173127515573150e-01,4.9270229832524368e-02,2.0224189485331812e-01,-4.0960531658693053e-02,5.7697423124768984e-02,2.7911639253610543e-01,1.1879146268459405e-01,-3.1318005767405795e-02,-1.7832967984299805e-01,-3.4491280637008431e-02,1.2549587171706383e-01,2.4671358611542540e-01,2.2993679925053970e-01,1.3466014119497574e-01,-8.5765102220393477e-03,4.4825235856767377e-02,4.1945502676673088e-02,1.1473505433928696e-01,1.3378826430851559e-01,2.1122331754010237e-02,-4.6933876886829602e-02,-5.4236752677430930e-02,-7.4473158432592099e-02,-1.4261065098172429e-01,-1.6214795971089929e-01,-1.9029604314877397e-02,-6.3940642033528422e-02,-1.8699523322501505e-01,-2.0988508673746403e-01,-4.5096837338717229e-02,-2.1045286511294760e-02,3.6587757095501765e-02,-1.5118105438215149e-01,-2.3410741275709832e-01,8.9911358535918445e-02,6.8970386510422046e-02,-3.8406093107244854e-02,2.4200703323628869e-01,6.1640206036184093e-02,-1.4377073261823778e-01,2.1807717410264306e-02,7.6735232421652561e-02,1.8334934675541931e-01,-2.3028915429850660e-01,2.4805794715757840e-01,7.0620002334612242e-02,2.9271432308372464e-01,1.7003283996605040e-01,1.5784910498474783e-01,-1.4744345358718214e-01,-1.3322419304122618e-02,1.4702241231451285e-01,-5.7938678041578179e-03,3.9092796313320334e-02,1.6516675099819544e-01,1.7595660109371386e-01,-3.2069806918581145e-01,-8.8973786920042208e-02,1.5135248907397353e-01,1.4683982118732425e-02,-7.3242549266860177e-02,-1.5176501364244196e-01,-1.1440356062706392e-01,-5.5733149972009698e-02,-3.6449142615147623e-01,-3.5867288771330844e-02,-2.1697344001407640e-01,2.8319900389933345e-02,-1.3263592085065504e-01,1.0805219652468465e-01,2.5447881748475382e-01,-2.4710760515205973e-02,-2.1586098288643393e-01,-1.1120266136596921e-02,8.4443652587228302e-03,2.3517595710197670e-01,-4.7272271187038514e-02,-1.0240669600202108e-01,8.8402026486656973e-02,-1.9524774858000574e-01,5.2408805862273047e-02,4.7239023830702512e-03,-5.7364469060248334e-03,-7.0039794819864554e-02,7.2998133462620754e-02,1.1725054439251671e-01,1.0989673261233014e-01,-5.7420285955448597e-04,8.8937224637134410e-02,-4.5955982474277166e-02,-2.0875318717132893e-01,-8.7160380050290739e-02,-7.8659450893812669e-02,5.4107868775816255e-02,1.4298000195008653e-01,5.7767675532984591e-02,-1.5874011581416332e-02,-9.1923426865412772e-02,3.5780322826967714e-01,-7.1121067203312030e-02,5.5757285997024647e-02,1.6027062401702014e-02,-9.7595180868631864e-02,-2.2519592767802135e-01,1.2167937061285147e-01,-1.4378698550851904e-01,2.8102550809472726e-01,2.4578175389497448e-01,4.9194319406956073e-02,-3.9509689156742023e-02,-1.8775397408157388e-01,1.9319123168348243e-01,-1.0071228415015024e-01,2.9274727038942644e-01,-9.8442104294229421e-02,-1.2873962234348152e-01,5.4070076900156715e-03,-6.8648440146298534e-02,3.4388489500681513e-01,1.7741437744045286e-02,1.3595802234538581e-01,1.2354984698478987e-01,1.4419580987883202e-01,-7.5891972330010590e-02,-7.4933787415149097e-02,2.2383564410131315e-01,2.2865258502763382e-02,-6.7868127394110883e-02,1.9248852386981896e-01,6.2161386739328681e-02,-1.3437776298610810e-01,1.2290507142512221e-01,-5.8542521670124484e-02,-2.2392451984865938e-01,2.3272327829331290e-02,1.1467219207141358e-01,9.1602186177682274e-02,-1.3828301171812490e-01,5.2333909756922141e-02,2.9869056524684329e-02,-4.8260613721755656e-02,-1.2061241560420149e-01,-3.9875509387135230e-03,-7.4703207544704470e-03,-1.6198886231713422e-01,4.7859962255610115e-02,-1.3028988377851053e-01,1.4446080664283895e-01,1.0760793520218261e-01,1.6179863521846418e-03,-9.4058166653278721e-02,1.7470545817532390e-01,-1.1721898301582251e-01,-1.9086590936908771e-01,-1.9971922488079374e-01,3.9906020504707707e-02,-1.6205709292586062e-01,-1.3323083067563946e-01,1.3883038820830928e-02,-6.1196312214748076e-02,-1.3527677765834406e-01,1.0641400646076493e-01,8.8610993542621808e-02,9.3245057777695262e-04,8.0069932441613090e-02,-3.7220461593565446e-01,1.1052901592461464e-01,1.0343283952000296e-01,4.8738229853152418e-02,-8.3453519169089649e-02,-2.3811030546828937e-01,-3.2051974233057078e-02,3.0577316660414092e-02,3.2713123134272215e-02,-9.6087347569284165e-02,2.2240770546999739e-01,-3.3210345153746629e-02,-8.9556340281635144e-02,1.4589297755418235e-01,1.0180859751306394e-01,1.1684053818012419e-01,2.2909574049602288e-01,-2.0031465538972067e-02,-6.7081862504222753e-02,-1.5661729825731829e-01,-1.3550819787344429e-01,-2.5695354175348528e-01,2.0447953356854945e-01,-3.7538647012121881e-02,-9.6731628613039938e-02,-2.1417798569990287e-01,-2.1103783283866318e-01,-1.3357156945499171e-01,9.8033035742718919e-02,4.8304880591750442e-03,2.2367307295876031e-02,-1.2000946080405499e-01,1.8979925485821439e-01,6.8098531722757968e-02,1.6819278548495742e-01,2.4886858974597717e-01,-2.1351867758957888e-01,2.5317222528848098e-02,1.7927809233193914e-01,4.4735343454044403e-02,-8.5718460775331892e-02,-1.4062652410790227e-01,-1.0964501531007320e-01,-2.1537947218821060e-01,-9.8604820957859093e-02,5.2302573188172958e-03,1.3780617230919165e-01,2.4578469719101650e-01,2.6481200605632322e-02,-2.4647627596729932e-01,3.3781830659520125e-02,-6.6295849632010389e-04,2.5131192855800167e-02,1.5388996851336395e-01,-1.8750543508715081e-01,1.0343347008118413e-01,-6.2179405495970425e-02,1.5386062746219223e-01,2.6024948718042928e-01,-2.3996391073723303e-01,-1.5988119317595179e-01,1.0345851313296296e-01,-1.4556151200782319e-01,1.5489726073982593e-02,1.5796490761984344e-01,-1.5866184751597229e-01,-1.3753081196231454e-01,3.2130218349962142e-01,4.3820444317679633e-02,-1.1353784154583944e-01,-1.1398725704551737e-03,2.6704456995237470e-02,-2.0745811593136587e-01,9.6784450590159415e-02,-9.6963324755606789e-02,1.6026166775947134e-01,-1.0980055611328458e-01,-3.4766135517825286e-01,-2.1123224450837291e-02,1.0680763135707570e-01,-1.0641257064811326e-01,9.7171586909846466e-02,-7.8488963156500210e-02,5.3071844946044527e-02,-6.6053801608226770e-02,2.2163671580491678e-02,-1.0464620056317660e-01,-1.0279120633028699e-01,-6.4343968331420101e-02,4.0976389747098052e-02,-1.4368076150938264e-01,3.5488245589015990e-02,1.2398813599922578e-02,-6.7133540003497055e-02,-4.2702823046400079e-02,-1.4218228725906563e-02,5.6187573723994105e-02,-1.1099041399049100e-01,-2.2976950308512767e-02,3.4619345851019605e-02,-9.9324578130809499e-02,5.2155234374186211e-02,-1.3750331514835970e-02,6.1972098769581763e-02,-1.5851651783039578e-01,1.1162245523443570e-01,1.7441587001497470e-02,-9.1433372466638255e-02,-6.9744736199826490e-02,-4.1438659470721501e-01,7.8167234657015860e-03,2.5816410200329776e-01,-8.5407875247388437e-03,-5.0622762023140769e-02,-2.4459542644141130e-02,2.2740008604674686e-01,3.2625084045794568e-02,-5.7801640811264918e-02,3.4595713451444821e-01,2.2004684162841068e-01,-2.0060556196625054e-01,1.3476317703593987e-01,2.2328797722389271e-01,8.6679873614620533e-03,-2.2872983110444589e-01,-2.7672609516114999e-01,2.0467118103438184e-01,-1.7976892733510469e-02,-6.6955963960777104e-02,5.7855256465740836e-02,-1.8539514436739474e-01,-1.3992485318509379e-01,-1.1029971550586978e-01,-3.5555375926554778e-03,-6.3322790654255397e-03,-2.2629727219460535e-01,8.3008130279661179e-03,2.1977771028143279e-02,-9.9784086026428048e-02,-7.3693012782965361e-02,4.6853368306783882e-02,3.3584241621935254e-02,2.5888861465181018e-02,1.0445947544412157e-01,-4.2144887435108047e-03,-1.5463177332162903e-01,-2.3764641094330546e-01,-1.0389837974282301e-01,-1.5430889756996086e-01,-3.7279064884319355e-02,2.9677676146209919e-02,2.3513954278557635e-02,-3.9790863241766866e-02,2.8624794671725401e-01,-3.9232111857471129e-02,9.2033613049761820e-02,1.0012945524233897e-01,3.4647966510729454e-02,-1.2863176389383960e-01,2.8045243175173745e-02,-2.4120849052583951e-01,-6.0894416033485631e-02,1.6916187923910919e-01,-1.7270553089955748e-01,1.8006328289164691e-01,-6.6961012900587119e-02,2.7327058381881769e-01,4.0153996242564077e-02,-2.4009220626624386e-01,2.0670323131613277e-01,-1.1862684599801784e-01,-3.4768330432635074e-02,-8.1253998215519235e-02,2.0020888582337845e-02,2.8468033032845244e-03,-8.0791675922402759e-02,1.1174315183396072e-01,-9.3876485521063202e-02,-7.8361670490855767e-02,-1.0036290835562338e-02,-7.5095980415129812e-02,4.4193295283927625e-02,7.0620451527401096e-02,-5.2195248514493846e-03,1.9104888727428623e-01,-1.0582147354454974e-01,-2.7570512979085710e-01,-1.4948377517864189e-01,-4.6294136772159586e-02,4.4057401682121106e-01,4.4802740578554989e-02,2.6890787865199627e-02,3.0861328267649402e-01,3.7075180041059924e-01,5.1728519694407881e-03,8.6484001429018575e-02,2.2711945012413448e-01,3.1315699374083167e-01,-8.3054018146768674e-02,1.6797735203672257e-01,-1.4482383129624918e-01,-1.0666227242144037e-01,-4.8664219683710291e-02,9.8245671012769431e-02,-1.4682370449042639e-01,1.0476301408687436e-01,-1.9175350135264105e-01,-3.2567624880847669e-02,1.5793547661444984e-01,4.9758303709717677e-02,6.2504310318310496e-02,2.5919752895960341e-02,5.8446107228390623e-02,-6.0237667162736985e-02,-9.9595850105925310e-02,5.2288950441878521e-03,-2.0768440165469554e-01,-2.1174254331703110e-01,-1.2844761644518485e-02,2.6933063257772555e-01,-3.6894363609837152e-02,1.1224028073712052e-01,-3.7706848603173394e-02,-2.0231409299362108e-01,9.6106497232163760e-02,7.3901703411714495e-02,2.0326050482176852e-02,-1.5409497610841835e-01,1.3526938473352068e-01,6.5745368718237385e-02,-8.8233649248787918e-02,9.7820753800651639e-02,2.2300570377994672e-02,4.7620194631132179e-02,1.2137105279460667e-01,1.5332548945726729e-01,-1.5905918288385948e-01,1.4861671069092874e-01,-1.5050700946655424e-01,4.1452923575341943e-02,-3.2759233184628408e-02,1.6565137625166959e-01,6.0347979668034402e-02,-1.6458195680826423e-01,-1.0600095232142276e-01,2.4395440474919242e-01,1.3323228031908729e-01,-2.3019533248678814e-01,4.2141967382982044e-02,-3.7042738047106893e-02,-4.4377699933761533e-02,-1.4579247093315234e-05,2.0960910828987073e-02,-7.6294208497673960e-02,-4.1160447519017970e-02,1.0269552520456537e-01,1.3098224981064988e-01,-1.5061726558563532e-01,3.6246291096662178e-03,6.6338276350887793e-02,-2.0729730021323131e-01,-7.7718742551761810e-02,2.4183355283380011e-02,1.4580989406751133e-01,-4.7613217738011071e-01,-1.5255052165954255e-01,-2.8599484406124209e-02,-6.5092667875065971e-02,-1.5401248162055892e-01,-1.9282268545959999e-01,-9.2676406964243646e-02,-2.0098006871832505e-01,1.3238772665503057e-01,1.3373329309540469e-02,9.8127043928177171e-02,-1.0656709211147669e-02,8.4623818050711411e-02,-2.1618505234529353e-01,-1.4448103621186850e-01,6.7988183589146295e-02,-1.3910033762055357e-01,-1.3672488971208837e-02,6.7593921761799590e-03,7.8073290153239411e-02,1.4332810248864866e-01,-3.5265243523211837e-02,-3.2958362739642649e-01,-4.6444420236864389e-02,-7.0018020498100381e-02,-1.6010428416040151e-01,-3.8571937900989124e-02,2.6120818294251877e-02,-3.8144644545201473e-01,-1.0148826054983259e-01,1.4784943631546876e-01,1.1533246744952216e-01,-1.3585937389061592e-01,-8.8360347424744329e-02,1.2250324570124785e-01,1.2509957330139398e-01,-1.8797885146915883e-01,-1.5243745921807569e-01,2.9480118544098938e-01,-2.9071882700345907e-02,-3.8155565659877294e-02,1.5564687034550012e-01,-3.1171356607978401e-03,1.2594299925982907e-01,1.1534701254552554e-01,-1.7604906626402381e-01,1.2413537996229583e-01,-6.9519288137448315e-02,1.7412897763494453e-01,-7.1564112818037026e-02,-8.8027956050965070e-02,1.0186547588468268e-02,-8.5954735710959657e-02,1.3622656478380582e-02,-2.9965745822327894e-01,1.4521635523739684e-01,6.1584657334618931e-02,1.8886648776175480e-01,-2.8156144645286148e-02,-2.7669758892367508e-01,1.2511193800550421e-02,1.1537220338575861e-01,-6.3822494097058619e-02,3.1114766111617103e-02,-1.2017756959370428e-01,-2.1419239185148348e-01,-2.9362182583404195e-01,-1.2035281159480525e-01,5.0917295276005935e-02,4.3157999993396062e-03,-1.2673122326019584e-01,2.6638992143371027e-02,-8.4343355449749604e-03,7.9534109983541101e-02,1.0884028672305107e-01,4.2469036337839751e-02,-1.3549862829941284e-01,1.6865283166215378e-01,-1.9231738653899286e-01,1.7593050887426853e-01,3.3423842377838610e-02,-1.0790851143395704e-01,3.1445700477308208e-01,-7.1246592834478498e-02,-2.1745950860308793e-02,-6.5033928124154677e-02,-1.1742967923015088e-01,-1.7665176758065856e-01,-2.1057182952005460e-01,-1.6757868926367858e-01,-9.7484612474006874e-02,-8.2159273591089016e-02,-1.0735880980745278e-02,-1.6950417701221321e-01,-2.8085608727331129e-01,5.6390659778373264e-02,-4.7679619159204309e-03,2.0157711660145772e-01,4.1681413879298343e-02,1.7881443973748168e-01,6.9668289662542182e-02,2.7813734851600930e-01,9.5022733906230603e-02,1.7091944663588132e-01,-9.8388864005909765e-02,4.6695056468505892e-02,-8.7584619047024765e-04,4.5501984839947718e-02,-4.9827611291811395e-02,9.5503810487144458e-02,-1.1046536213589893e-02,2.9805055142370812e-01,5.7408147898423394e-03,1.0900602269478184e-01,-1.0295504195458612e-01,-6.3483563301262078e-02,-1.3864731495480381e-01,2.5477584333053271e-01,-1.6256967719231261e-01,7.4183166312349155e-02,-5.9050077321542216e-02,1.4169283231237353e-01,-1.3218489570898567e-01,-1.2410660998484957e-01,9.9386398442540561e-02,3.1816182679947000e-02,-8.1002699526777855e-02,-2.3713043309070739e-01,1.4163227354776672e-01,-1.6212015469133711e-01,-1.1439608116292552e-01,-1.1877686965708265e-01,6.8300134587958333e-02,-4.4492138778621959e-02,1.0271198589289166e-01,1.2532464315048905e-01,-1.9571046909375017e-01,1.4678214607417256e-01,-1.1244389047271701e-01,9.0553498436939300e-02,2.1694414692720054e-01,3.1986185475666945e-01,-8.8768367671613668e-02,-1.8073425223219974e-01,-1.0953207204439848e-02,5.2353711834830417e-02,-1.5854975478476888e-01,-1.4690328654967105e-01,-1.6190757574948281e-01,-3.1861532142835420e-03,7.3262460177237032e-02,1.1913457193086902e-01,1.8939456195069221e-01,-1.2223443750216512e-01,1.5231898329147564e-01,5.1988620722436110e-02,1.0216067667888491e-01,-3.8150052961218602e-02,-1.5762636915672640e-01,-1.3542451979547446e-01,2.4342551702235007e-01,6.8952317202096935e-02,-6.2750943988231535e-03,-5.1878956586586193e-02,-8.9947211625595935e-02,-9.7618404613490674e-03,-5.0646585257997867e-02,9.1901343308614762e-03,-6.3197028135600686e-02,1.1862400411222028e-01,-3.0982826789197593e-01,-7.8029458313631728e-02,-1.1182656029845814e-01,1.4865414953604597e-01,3.1687407789525618e-01,1.6237882708600288e-02,-2.4188901216340170e-01,8.7332511063832663e-02,-1.4080575972111364e-01,-8.3483746561637012e-02,-1.5368791621053537e-01,8.8993372626122058e-02,-1.7695337548234591e-01,9.5211978735079972e-02,2.6594367979396949e-01,1.3087621886969272e-01,-2.7419782843180356e-02,-4.6838729457975195e-02,6.2458940396476217e-02,2.0781675604938532e-01,-2.4122662864660638e-02,-7.9532296936259794e-02,-1.1169250033657568e-01,-4.5961743312340875e-02,-2.9189814438497795e-02,2.6973685122209712e-01,7.5622639669014835e-02,2.3539913660766976e-01,1.0848226097203126e-01,8.9269016712323915e-02,-2.3552023287290440e-02,-1.9059491491636729e-01,-4.5881247193308758e-02,-1.3264862096381139e-01,2.2969641160432891e-01,-2.1519297980432917e-01,6.7700273910634726e-02,2.9991888614541751e-01,-2.6248706792029106e-03,3.8783131471392444e-02,-4.4545771685813147e-02,-1.7965128131510355e-01,9.5171500257138220e-03,1.6156030406502425e-01,-8.3504346955349626e-02,1.8502325882627603e-02,1.2394613925807749e-01,8.8915145387896452e-02,-5.5892753815559727e-02,1.6462210945654732e-01,-6.2253026614682648e-02,1.0071827084433277e-01,-2.7340226907753457e-01,5.0745113305293264e-03,-3.8488204330065591e-02,2.4094634486275193e-01,-1.3399587623788045e-01,7.9778069425849620e-03,-9.2733647062259155e-03,1.6516364686235588e-02,-7.0101644280867931e-02,-3.7109687227201787e-01,-8.6179145883735819e-02,1.0903674333883012e-01,6.7921311590769196e-02,2.5365162621048619e-02,4.8759404908337967e-02,-1.7781497873509650e-01,1.3017269226596365e-01,-1.9769240299207966e-01,6.0857742435338105e-02,3.4507889069856482e-02,-1.5509654191504230e-01,3.1542293443975238e-02,1.7185678005531024e-01,1.0276870239795531e-01,-8.5293467060745573e-02,-4.1681641198104857e-02,-2.1624764411996794e-01,-7.6959670197785282e-02,-5.9010692274948352e-02,1.0360384799724637e-01,2.4365197789133511e-01,2.2129867204499533e-02,-1.3985336617954588e-01,-1.6289680518354241e-01,-1.5823041375615937e-02,1.5280187485608926e-01,-1.1071090049969351e-01,-1.0307798454476055e-01,-2.9117492121206068e-01,7.1356491614853940e-02,2.9590174413370879e-01,9.7977898319659862e-02,1.1002510088892564e-02,1.0866227852000454e-01,-2.6838613707154974e-02,9.2281840157217881e-02,2.0551390276424397e-01,1.3354749205835535e-03,1.7863580323976999e-01,-1.5334003816169442e-01,-1.3792323299926437e-01,1.6721385000704569e-01,-1.0073038207956685e-01,-2.5104961456294905e-01,-2.0846358297452411e-01,-2.1516254528929891e-03,3.7358603737235915e-02,-1.0798487371864836e-01,4.0419904968426629e-01,-2.1724249603222712e-01,-8.1582278306426489e-02,-1.6419803679013209e-01,-7.2767407602589540e-02,-8.9059979448784368e-02,1.2242198229189365e-01,1.0335418232670037e-02,-2.6420311980902824e-03,6.7777697851012730e-02,-1.4016284170997928e-01,1.7538682091982821e-02,4.2925791218394536e-02,4.2882093110792475e-02,-3.5661475970311003e-02,3.0745697372429315e-02,2.2824037826389559e-01,-1.5329196632736183e-01,4.2594865319955669e-02,6.1163865541818650e-03,1.9052072297183789e-01,4.1795375564819985e-02,-1.9668818683015213e-01,-1.8942107687580662e-01,-3.9813156038128697e-02,-5.1995389241479034e-02,-2.7517441403099746e-01,9.1012432769487974e-03,6.8229401116044752e-02,-6.2186754539713833e-02,9.3934763421290479e-02,9.4967656581983872e-03,-4.5005724620533281e-02,-1.5246704216539633e-01,-3.2072941721308923e-01,2.6007219595115821e-01,1.6185403940935811e-01,2.1618427852289540e-01,-1.8487709895152932e-02,-1.6135117016024044e-02,-1.1502806117279248e-01,9.3518404194944657e-02,-1.0938068443828070e-01,1.6972138404945183e-01,-3.7204517702383338e-02,-1.3962323770918747e-01,4.5710627366631652e-03,1.2179638422627360e-01,6.2422772072369168e-02,2.6621494764219305e-03,1.8984314081606959e-01,-1.3046408220643801e-01,-1.5506600769963497e-01,2.6635403711976681e-02,9.4945145839677975e-02,1.7652087862276505e-01,6.4662179933150585e-02,1.5537296864815317e-01,1.1046853536566965e-01,1.2055227042167094e-02,2.5229783085022317e-01,1.1543852184031281e-01,-2.6960447947409844e-01,-1.8767962818853975e-01,-2.3094141444283017e-01,-3.0708904723700531e-01,6.2164427267113742e-02,-6.7454488020164483e-03,9.8255677666161445e-02,1.1591350290734503e-01,-7.7339469763147038e-03,8.8215851018804813e-03,-3.3812682309455344e-01,1.5710423619838507e-01,-6.8816559349652404e-02,-3.8799556237735601e-02,1.2984876752682328e-01,-1.6239687119359905e-01,-2.8970693774611363e-02,2.3221414358163592e-01,-9.3331369303276679e-02,-2.8388034217774277e-02,6.1265984113240884e-02,-9.1984123941220089e-02,2.7427155076395693e-01,-1.3554369849815939e-01,2.2208189830812190e-02,1.7803562991856561e-01,9.4709499076537237e-02,7.0933579170081550e-03,9.8999259884636412e-03,-7.4123329621399975e-02,-2.3033877026324390e-01,5.4426194429090434e-02,3.7479717567567433e-02,-1.0586727488990345e-02,-2.1961602231563445e-03,-2.1684028066013611e-01,-1.6901175887227632e-01,2.4267698729657358e-01,2.5173350618685919e-01,1.7358893552013571e-01,2.3769373656247697e-01,-7.7578391611761444e-02,-9.3042460000130143e-03,6.3530061447360286e-02,9.8515165358972626e-04,-6.1019598201693254e-02,1.0560204980738619e-01,3.5661453753552501e-02,7.9708098686677442e-02,-1.5846289692916646e-01,1.0203774927019392e-01,-1.0237758097341421e-01,7.0894115011506581e-02,9.0834620954727857e-02,-2.0588574262342191e-01,1.2003289320689657e-02,-1.2917681480198256e-01,4.4038852260836744e-02,1.4380637845404021e-01,-1.0798193927209733e-01,-3.4441981073662684e-02,-3.3089209956368784e-02,4.9273754957670113e-02,2.1509886600011474e-01,1.4507798539041036e-01,1.0687493812580896e-01,-9.0053302650049794e-02,3.5996644859483995e-01,-4.5183852532217073e-02,-1.2508924252451548e-01,-4.8426784949177494e-02,-1.2225861601214923e-02,-2.0721419214038211e-01,-5.5377617679625180e-02,4.2907165846963656e-02,-1.4471037882414650e-01,2.9945158319669790e-01,-9.7378175707594092e-02,-8.8418568485187185e-02,-1.3169113386819181e-01,-2.3074281278515918e-01,1.2010586018247300e-01,-4.6665455559788752e-02,-1.6072872197628041e-01,2.4529202593982302e-01,-8.2494756471484756e-02,1.5858926368556295e-01,-1.6648160217891564e-01,-1.7005908578213082e-02,4.7204648710396556e-02,1.8271125530697396e-01,1.1564510940424212e-01,-7.0127625050610778e-02,-4.8635197805312828e-02,1.5243509534762623e-01,3.2632167984859968e-02,3.1835964623046986e-01,4.9810377756417501e-02,2.4257181379567250e-01,1.9128357600176729e-01,6.4010171902768392e-02,1.0567740787581774e-01,-4.8412748086399835e-03,2.1517858811178137e-01,1.6506621958020501e-01,2.6186245236079508e-01,1.4256086035705223e-01,1.7480469052381462e-01,1.6629439241438979e-01,2.2819784645239422e-01,4.3643862721632606e-02,2.6398632390621163e-01,3.3256315840050378e-02,-1.9211138581745398e-02,-2.1985736645293262e-02,-3.1721265157830872e-02,1.2609673669053439e-01,-9.5191563787276584e-02,1.2951682640042589e-01,-2.8012025008133920e-02,2.1893787417200197e-01,-2.9083995226044375e-03,-2.3394459112086741e-01,-1.8178943759877284e-01,-6.4050923979068223e-03,-3.5222088802268535e-02,2.0792692051679391e-02,-2.3460394000704720e-02,4.5971281875128903e-02,9.3266401647568289e-02,-9.7787603974439863e-02,8.0120353186809740e-02,-1.7360911456257117e-01,-4.6303209781610117e-03,-7.0565918458653318e-03,5.2339751922869243e-02,-4.1603007966912811e-02,2.0788349836895058e-02,1.0485291146638896e-01,-1.0847057620383285e-01,1.6298672161605426e-01,-3.1998960569010436e-02,1.3998401801006030e-01,-2.3793453939076126e-01,1.3928932549031275e-01,-1.0099864425660704e-01,6.6873709915153179e-02,4.9647287276643533e-02,5.2031361784166348e-02,-1.2861345415617170e-01,-3.9590937896113998e-01,-6.9419208438234500e-02,2.3541722467085341e-01,-1.1409529804899453e-01,-4.5968514445823241e-02,-1.6419850177122158e-01,-1.2600397302106360e-03,9.2984532833051844e-02,-1.0088088901363323e-02,-5.6556239720633845e-02,-3.5441794117247412e-02,-1.9724452305860804e-01,9.9366379996152193e-02,1.2594126982662301e-02,-2.0003626551303461e-01,-2.4446589242877242e-01,-1.9554448999911678e-01,9.3211618727511658e-02,1.0108122075424771e-01,-1.0111419217198928e-01,1.9291209308857091e-01,2.0353854650653391e-01,-1.9284805576021574e-01,-2.4080581740359458e-01,-1.2010612402221973e-01,-1.4321865361570416e-01,-1.6214718133850389e-01,7.4159004532310946e-02,1.7388430363209401e-01,1.0231369419536826e-01,1.0265995845742890e-01,-1.6279322913773046e-03,5.1123844416784400e-02,1.7300441030243502e-01,-2.4460437856884171e-01,7.5080113535035214e-02,-8.6951558826822206e-02,-1.8194590851429943e-01,5.1149813306611364e-02,-6.8022820942341383e-02,-1.4112964094923236e-02,7.8341056144093923e-02,-2.3023827881222680e-01,1.5056177046283833e-01,2.5130551573345583e-01,-2.9856781176944788e-02,-7.7391482234023617e-02,-3.9562244249643330e-02,1.2688596309046540e-01,-5.4999057817095423e-02,-1.0299677489356436e-02,7.4605705755077439e-02,2.0193538770840622e-01,3.4747376087680110e-02,1.4744755474753560e-01,9.2232124150464806e-02,-1.0873539025534749e-01,1.2567450120737125e-01,5.2045797488167039e-03,-8.7351421498793422e-02,2.2237268843240623e-01,-1.3179254711173605e-01,-3.7892209802265563e-02,1.9163617068489869e-01,2.9335611990154398e-01,-1.1718563016905736e-01,2.5169919166020949e-01,1.5860911076670106e-01,1.5981794842997171e-01,-3.7865726812647778e-02,-2.0454389450635216e-01,-5.8333844751123659e-02,5.5276479415886266e-02,1.2932193260156940e-03,-3.2561441579774231e-01,1.7031721319369880e-01,-1.2079462969808030e-01,9.0361006231859081e-02,1.3078571898902125e-01,-1.2877523064903554e-01,3.6646536857987556e-02,1.5810056973782727e-01,-9.1180225292761513e-02,7.7594628731076642e-02,9.3162668753215133e-02,-1.8435104808882455e-01,7.9969294602468460e-02,-1.3478696999105949e-01,-8.4991258816562193e-02,-1.4778540912280523e-02,-2.0450153308247035e-01,2.5334872534436812e-02,1.3885936941756846e-01,5.6728318168861480e-02,-7.8697985546382118e-02,-6.5833389513547336e-02,-1.4208435579612838e-01,-2.5091265107567783e-02,-4.3111420509741522e-01,-9.0844022843608097e-02,-1.1627833273100059e-01,8.4702284655589100e-02,-6.7637319037960345e-02,4.0304206524520166e-02,2.1277429798010825e-02,8.9285707677784709e-02,-5.2803628483142663e-02,-2.3933103254814314e-01,-6.8018604158076139e-03,2.3919860307849228e-01,-1.1924516925330853e-01,3.6181888560028172e-02,-8.6376925856130354e-02,2.7036917955413353e-03,1.6067810016510337e-01,-3.1035878437867331e-01,-8.7239385842920819e-02,1.0750342454355787e-01,2.3048148863508605e-01,-8.8249682166390842e-02,-8.2104096781043162e-02,2.2075697942830724e-01,-1.2530068394183896e-01,-1.7085514851858394e-01,-5.4646727948329234e-02,3.2688166537117286e-02,3.5809410992428688e-02,5.5517941736241971e-02,-5.4808133406720430e-02,-1.2123144818487874e-01,-1.4908543558107476e-01,2.4695963401554999e-02,-2.9659100054763343e-01,-1.4056525681119270e-01,2.2886817341797300e-01,7.1881258768158401e-02,7.3254987741475347e-02,2.0900328047162411e-01,1.9731099690585510e-01,-4.9410809018741918e-02,-9.4267142269447990e-02,-1.2952625748489657e-01,-7.8461698104125496e-02,1.3231154891482325e-01,-2.0120857176276560e-01,-2.5272842725798175e-03,3.1322592244470870e-02,1.0466288921226059e-01,-1.7347429327717795e-02,3.5402287931420869e-02,-5.1081500863316170e-02,-9.3555272527977101e-02,1.4886853498809913e-01,-1.2160295458393676e-01,-1.8205913746094350e-02,1.2550030000036053e-01,-2.1415027301487877e-01,1.4215370347634662e-01,-1.8937803239540765e-02,-1.1278373181376149e-01,1.0978672929918638e-01,9.6248786456502228e-02,3.0945473438339095e-02,-4.1683190891216337e-01,-1.1471185625682631e-01,4.5445023344404381e-02,8.5622419379959777e-02,5.2859751388943617e-02,2.0053343582534569e-01,1.2602351035927001e-01,-2.6609289375120259e-02,1.7594551292455310e-01,-1.1641688434409551e-02,1.3830627757819614e-01,-2.2483635983178069e-01,1.6787130442779533e-02,9.0703394813327377e-03,-2.3056339326329123e-01,-2.2127331771765069e-01,-7.8739659432135581e-02,6.8767737914745317e-02,8.9617548715596226e-02,-2.3850656424968897e-01,2.1887052248608924e-01,2.8147176436162041e-01,1.1983382023316606e-02,-6.5847339807710042e-02,2.2337052770445707e-02,4.4523621449261939e-02,-2.6096089592998922e-01,1.3460334971244978e-02,2.2702660235576341e-01,8.8357670601073135e-02,-1.3058790446729074e-01,1.2587489638971256e-02,1.0923518957361013e-01,-2.1006485409507544e-01,-1.1343475927278814e-01,1.3759105768640459e-01,-9.9118990031129093e-03,1.2173177410273400e-01,2.4607923162477044e-01,5.5895480526949516e-02,-5.5424181006664179e-02,2.5459848498826394e-03,1.9773657217647714e-01,2.7072118663234102e-01,-2.1347950721955052e-02,-4.3215886818911191e-02,-2.3074744945027162e-02,-9.6164877954133213e-02,-2.6422773882700429e-01,-6.1412134982727067e-02,-6.8257657575549815e-02,-6.1546875138540645e-02,7.1111222977586541e-02,7.6225316345942581e-02,1.8814275668752617e-01,6.4586729660476766e-02,1.9279622226660792e-01,-1.9639774835798145e-02,9.1824435973832746e-02,1.3695343895214691e-02,1.6562073369722413e-01,-7.1973607316305754e-02,-3.2425566811987699e-01,-7.5612421936313984e-02,1.4958526546257089e-01,-6.2593643123653758e-02,-1.9350567726399762e-01,-2.5245697342274814e-01,3.8674434543203559e-02,1.4645695761574187e-01,-4.9105588847037460e-02,-1.8600913103807404e-01,-2.1577116401934320e-02,-2.6002039217990876e-02,2.0784302529058582e-01,-1.8191484479039940e-01,-9.2878576044553809e-02,1.5114359381274744e-02,6.3023244707815812e-02,2.8578389682014155e-01,1.5854723054613534e-04,-5.9800353697553451e-04,2.2305983407649405e-01,1.8172286768171991e-01,-1.8439688822757594e-01,1.4618267688837769e-01,-6.2279608374180208e-02,-6.1175086598699517e-02,-7.2467037475176355e-02,3.9112309727879678e-02,6.4896775517838359e-02,1.6039804817236641e-01,1.5872039448552677e-01,1.2434478214977215e-01,-2.3359267310841844e-01,-2.5104626790688445e-01,-7.2318018184865940e-02,1.3546897639486935e-01,2.0368500606908752e-01,-5.6072105205321840e-02,2.0202841787107395e-01,-3.0848076002712682e-01,-1.1907317218091454e-01,-7.9758224691572940e-02,1.3435011860594248e-01,1.2350075162721807e-01,5.2824862251754012e-03,-2.1319089105667385e-01,-1.4311306262977161e-01,-1.5825461865628479e-01,9.2239088027499416e-02,6.6820545377386256e-02,7.2588614167187704e-02,-4.0116690798628840e-02,-1.7388493890122511e-01,-1.0963121295234331e-01,-1.1334567663784997e-01,1.0230799753555854e-01,8.6734750685353537e-02,-7.3879422415802781e-02,7.2764868673913796e-02,-1.6584719671620110e-01,1.6820474111177423e-02,1.7355924168625469e-01,2.0121975393604028e-02,-1.7391593972024347e-01,3.6636832213213795e-02,-1.5059480772874667e-01,-6.1881525099960935e-02,1.1492209688969310e-01,3.0222941979219535e-02,-1.2090603938075482e-02,1.2615288822047854e-01,-1.1514026296151603e-01,-2.2874293305911765e-02,1.3851215116082127e-01,-2.1344016839104332e-01,2.6918142588624916e-01,-1.6124694258625261e-01,3.6867513187956408e-01,-2.5856804875353939e-01,-8.3060690406517951e-02,-2.2150578398430493e-01,1.5405826477247372e-01,4.8687012164063563e-02,9.2908540554432997e-02,2.0739925646727275e-01,-5.8874426780206705e-02,1.7501836141681518e-01,-5.2677947992202462e-02,7.5842339626748398e-02,7.3892806188958313e-02,9.2177506975869433e-02,1.1418939756591827e-01,1.0010021061105406e-01,2.6594118086981838e-02,1.6200797322410831e-01,8.5527074120826163e-02,1.4931957136552437e-01,-8.0089206848897823e-02,6.6640560529207540e-02,4.3109029083472430e-02,-5.2298786382034744e-02,7.1876722625651923e-02,1.9964767562552957e-01,-1.6163083546968784e-02,2.9116967150899120e-01,-3.7748937049047464e-02,1.1909018282323237e-01,-1.9352955436687502e-01,7.1748973120588283e-02,-6.2357712523455393e-02,1.3146096997098244e-01,-1.8235233270640930e-01,3.5143471150198835e-01,-1.4304183786883851e-01,-2.8602311091446779e-02,-5.2821470213679708e-02,2.8863714674422930e-01,-3.9132438053830758e-02,1.4003308830837563e-01,5.8543735612587210e-02,-4.1126566531497696e-03,-1.4678866831117840e-03,9.0874807416216688e-02,9.6511940664951737e-02,1.6758559085906058e-01,1.8267656767593583e-02,5.6683393687407428e-02,-1.2124514210776788e-01,6.2689740865166960e-02,-1.2481853842774357e-01,-3.2959795751491167e-01,1.0893713528489446e-01,6.6345235616981746e-02,6.6499213790940676e-02,1.9123461432001002e-01,-9.8561736385872636e-02,-1.8734922236612592e-02,8.5994976501998222e-02,-2.2789430877575123e-01,1.2441713567699063e-01,-2.0020031031626512e-01,6.1097790452079477e-02,-4.3192914698904496e-02,-1.9943540657667835e-01,-1.1270905214834918e-01,-1.6752113700896551e-01,-8.6380150958105195e-02,-3.3428925184487107e-01,5.5553286301998281e-02,-1.5102317297258280e-01,-1.0655778048064458e-01,-1.4322967512248286e-01,-2.2883186872588029e-03,-6.7985952716334605e-02,-6.4670488814101618e-02,1.0511344478649805e-01,-5.4216189540337412e-02,-1.5895306411623755e-01,-6.8249503287739377e-02,1.2154736588086443e-02,-2.7838804212607304e-01,-1.0673062824611122e-01,8.9469228798491174e-02,-1.1049953204820279e-01,-1.7813806378059005e-01,1.3283784430046580e-01,-1.0068088770170897e-01,1.7356592079670774e-01,3.4880352917991311e-02,2.8078804470625468e-01,-9.5282645320518597e-02,-2.5282739443160762e-01,1.7690878117642608e-01,9.2121131546238563e-02,2.8888303871163732e-02,1.7999282104292493e-02,-8.8788539515388759e-02,-1.1613801088243494e-01,-1.9942250149899872e-02,-5.6230925054715143e-02,-2.4749303363557337e-02,-1.3385241522600616e-01,-1.3637119375970169e-01,-4.4742541032999433e-02,-1.0151362823086932e-01,-2.3425772295541619e-01,1.7576705926106323e-01,1.7893618610774407e-02,-9.7414426585756261e-02,-1.8587939277449575e-01,1.7431590075697959e-01,3.6099656211457198e-01,-1.9872804726417451e-01,9.5437409407286941e-02,5.3673032498826809e-02,-2.0038146049040170e-01,6.5430098907514320e-02,-1.1096429126869610e-02,-2.1970048690973545e-01,-9.0756570034204162e-02,1.9948248789589233e-02,1.3815359268122279e-01,3.7001469991431474e-02,2.3999491556739608e-01,-4.9646982783659879e-02,1.0103041286467015e-02,8.3547773946506906e-02,3.3903877766635226e-02,1.4588600412274680e-02,1.3824957174740249e-01,2.8710206991517517e-01,1.1893601270923207e-01,-1.2405149558294583e-01,5.4648798546889851e-02,-2.4936713917308234e-01,4.5472731197244320e-02,5.1110755179092596e-02,1.3342606284041200e-01,1.2686994614449029e-01,-2.8246831645358350e-02,-3.6515642586306390e-01,1.5415460403161327e-01,-1.4691339181102392e-01,-1.6084309781714534e-01,7.0191770365588921e-02,2.8228037061133660e-01,4.4660686701930657e-02,-7.5612802602528228e-02,1.0809476353307403e-02,-1.2489197777358105e-01,-9.8934804326495956e-02,-1.3196803077756325e-01,1.8555432454760434e-02,-8.7757109617413551e-02,4.8946235128949730e-02,-9.9917311308462903e-02,2.0468719896076848e-01,1.8923316860156303e-01,8.7761227190980312e-02,4.3003380642002195e-02,1.3126562085794172e-02,-7.4336541158742497e-02,1.3055225832515083e-01,8.3698902399572839e-02,-1.3695782670349560e-01,-1.6151750201698412e-01,-5.5709004898771730e-02,-1.8975481506740194e-02,7.4824445763555431e-02,1.1632615613638939e-01,-1.2348784905389801e-01,-5.9832977806144466e-02,2.7654154560684381e-02,1.3003483509631308e-01,3.1919095159687112e-02,3.1058652577666084e-02,3.0118901934024356e-01,1.5929196822965933e-01,2.5521980353793106e-01,9.4370959374599939e-02,-1.5447993529476020e-01,-3.0290539218542155e-02,7.4233849926478449e-03,1.4811969088108970e-01,8.5658747224828385e-02,5.4829346006106915e-02,-1.0836117434813047e-01,2.6191864783553992e-01,2.6885298366274146e-01,1.8029183658676504e-01,-1.6787796163609200e-01,-1.9690582124889205e-01,1.2241717594039973e-01,1.7765270712909392e-01,-1.8660598760823641e-01,-1.8539479082400237e-02,1.8026222532926742e-01,8.4771439901743482e-04,-1.6929466392145659e-01,1.3067436246747108e-01,3.8614764141989215e-02,5.0820016253716342e-02,9.7958841448529010e-02,-1.5914711250726840e-01,1.5543948346277486e-01,8.9088925378537687e-02,1.1857740981188077e-01,5.6713308642081600e-02,2.0914574017974700e-02,1.5074852631693356e-01,-4.6442361138095800e-02,-2.5809336398456456e-01,-2.0136083020341664e-01,9.3053903405677874e-02,-1.0688928569341906e-01,8.7850974815123675e-02,-7.3242814643542847e-02,-7.1141199180607989e-02,4.2068215434978812e-01,-3.3035631553708832e-02,1.8257120307753751e-02,-5.7576955233077324e-03,-1.0344518614388928e-01,1.3316383121028741e-01,-6.8496805879960810e-03,-4.6140229158872940e-02,-2.2869721623438893e-01,3.6407449616089146e-02,1.4082831360527542e-02,4.1457947635157290e-02,-1.3227376930694920e-01,9.0528994120843240e-02,-1.2315956573430023e-01,-1.3829338018514087e-01,-8.2657320698412348e-02,3.1194323657606660e-01,-2.9240490125767127e-01,-5.0186388576767875e-02,2.4003995410333476e-01,-1.1689914659238939e-02,-1.8513772397454892e-01,3.9853673186949767e-02,-2.1360904818198391e-02,4.6477002334877907e-02,1.5123760079169803e-02,-1.9044363117223870e-01,3.0250145288262109e-01,-1.2441313671177994e-02,-2.5376353485856151e-03,7.7058357317479814e-02,-3.1038316943284427e-01,1.8336712657337156e-01,-1.7585627847020666e-01,-3.2767868181267555e-02,-4.1875550265401879e-02,9.7158965719945922e-02,-2.8651952716715931e-02,4.3534973640302121e-02,-4.8298996599329527e-02,-2.1029184739203215e-02,8.8029074894879766e-02,1.3345134934999855e-01,2.6066197809937736e-01,-1.8919329755513745e-01,1.0751385411744435e-01,-2.5942108630099284e-02,-2.0763631802064274e-02,1.1928181711053550e-01,-7.5170021473683749e-02,9.2324692735367864e-02,-5.8163662066927999e-03,-2.0215725581059490e-01,-1.0072051175493536e-01,-1.9798945626109293e-01,5.9461232849292382e-02,-1.3741400269624721e-01,-4.9898538190102579e-02,-2.1222190843085587e-01,8.1212018000036287e-02,1.1884298706351319e-02,3.6267264334124562e-02,-2.9527439014440332e-01,2.0370643046266974e-02,3.7098021193242500e-02,-4.4417479303999731e-02,1.6045866804703243e-01,1.0106386599679316e-01,-8.8205081361287171e-02,3.5254913711169185e-02,-6.5157282292416949e-02,-3.9314304952685767e-03,-3.3624461038256886e-01,1.0369233197717193e-01,-1.8311125196876357e-02,9.7621895589511364e-03,8.1790456429431252e-02,5.5880707656713824e-02,1.6960517692607252e-01,1.5271868324018755e-03,-5.2954870982136103e-02,-1.6761216130921946e-02,1.0825834577750752e-01,9.6239462761249520e-02,-1.1677328719693959e-01,-7.9537168113711337e-02,9.9551928114139064e-03,2.0516696446714228e-01,-2.1901423245902019e-01,-1.3008073568001638e-03,-5.6843457485436226e-02,-1.0092262342646334e-01,2.8148552880165900e-03,-1.2330426539872287e-01,3.7836353867594305e-02,-3.5470011111267302e-01,2.8438427200787630e-01,1.0768773350644061e-02,1.3430864205806273e-01,-1.1571316546568419e-01,2.9367560773494916e-01,1.0704963908903500e-01,-1.4173006650878325e-01,1.5220170527354249e-02,-2.5385579477708631e-01,-1.0746448751400874e-01,4.0110347372249083e-02,3.0755098973551387e-01,-5.3176963793053617e-02,1.5645737666260232e-03,1.7886397789829148e-01,-5.5385785182193926e-02,-3.6630381719008620e-02,-5.5984206585068816e-03,-1.7732490768940071e-01,1.2058141770447652e-01,5.3396064503179200e-02,-2.7228588822690331e-02,1.5106619731232387e-01,7.7981635703897989e-02,4.8457391270179700e-02,4.3780029612219988e-02,1.1019767085141394e-01,3.4406763407369471e-02,-1.6977282569955315e-01,-1.2989263431529946e-01,9.5949401713285504e-02,-1.8213683269274605e-01,-5.6283678759601663e-02,1.7545662429852460e-01,2.1847494891106878e-01,-2.7561336764772326e-01,1.2430147133128486e-01,8.0913807869521473e-02,3.0287462887950989e-01,-3.9856254435693218e-02,-2.7299173426043561e-02,7.2302397153640674e-02,-7.2763199527229178e-02,-4.4635967817103668e-02,-1.8060519154095431e-01,1.3456707095127354e-01,-1.3523720674143272e-01,1.4874097475976306e-01,8.0552179350490666e-02,-8.6541851048745594e-02,1.4970835058362444e-01,-3.9755009562444578e-02,2.1249460425129096e-01,1.5907336515316897e-01,-3.6764247644342235e-01,9.1980643336321832e-02,-1.2831477701050006e-01,1.4961831855766158e-01,5.5580901781769707e-02,-2.5058715287451322e-01,8.8744142608672763e-02,1.3385261920554328e-01,7.3064109049899351e-02,-1.1891460712596115e-01,-8.2070275028244717e-03,2.0067184289073925e-01,-2.5983302323801061e-01,1.1215602572188818e-01,9.9763936656521085e-02,-9.2585675665800740e-02,-7.6009295348580100e-02,7.4875364424199134e-02,-2.1566981582769881e-01,4.9861674803012138e-02,-1.2153745144587304e-01,-1.3189158325440775e-01,-8.7632731560568861e-02,-3.3180003442879419e-01,-2.1605780567358339e-02,-2.4577886977270857e-01,-2.9149330367533210e-01,-2.0955920780685597e-01,1.1123275290869583e-01,1.3580901807505333e-01,1.4158162713486402e-01,-3.2764004408536294e-02,2.2510814660355227e-01,-9.8600639528139494e-02,-2.1768880598867387e-02,1.0701727630478618e-01,-1.4052612371362549e-01,-1.6965964351969900e-01,-7.9798820738532839e-02,-8.3373546375885427e-02,1.8083948265825681e-01,3.1999480030068017e-01,-6.4578598025105849e-02,-1.7756016150384452e-01,-2.1030839070007683e-03,-3.4063688786320441e-02,-1.1394291592066763e-01,-3.0843012294239948e-02,-7.4436451250970884e-02,1.7035402773582231e-01,1.3755199898026239e-03,6.0155956972842949e-03,-3.2688354728192356e-02,9.5186294665361756e-02,-1.1937042883125240e-01,-5.0945682480155866e-02,-1.2332888470861909e-01,7.5038202719474534e-02,-1.7018761134364371e-02,-7.9113145355609010e-02,-2.6260005663661157e-01,3.4107856174062992e-03,1.9300488149935707e-01,-2.3153392908391776e-01,-1.0138926150888282e-02,7.5499705007790213e-02,1.4739740216493671e-01,4.1866138330112379e-02,-1.4243445985781153e-01,3.1967625735924030e-02,-4.0033212196824464e-01,6.7837516627153552e-02,-8.3168197153286744e-02,1.1522350755200389e-02,-2.0392568000732347e-01,-2.8561080321067561e-01,1.1887578497058726e-01,-1.4365672986355735e-01,9.9285820674294895e-02,2.9107270280459857e-01,1.2454050693380336e-01,1.5162843127878500e-01,-1.3983357734200727e-01,8.0050190754147751e-02,-6.8379133473558854e-02,-6.9977007832518409e-02,1.4570654523355347e-02,-1.4573329617974035e-01,1.5323851359661134e-01,1.2616107303966198e-01,-5.9784260304738705e-02,-2.8706767071448723e-02,-5.3419206785802545e-02,1.9318603795446590e-01,4.5543714340070915e-02,6.1824812134476000e-02,-3.3693921533254914e-02,-7.8502911051503782e-02,-4.0234708366265234e-02,-8.6244236890908293e-02,-1.0035523546709223e-01,2.4275157211570209e-01,1.7619060856769536e-01,-7.6208467502364416e-02,4.7549693931587984e-02,-6.3177696821313661e-03,7.6141714749260098e-02,5.7832676867197993e-02,1.7721217651057572e-01,-1.2143626531603242e-01,1.3554789457603758e-01,4.9906611822929686e-02,7.1711831587508282e-02,2.6075941292371607e-01,2.0284322178688657e-01,4.3866940606183236e-02,1.8303626749157881e-01,2.0881129001052871e-02,-3.4290141076904569e-02,-2.8556839978107029e-03,2.1172944739760380e-01,2.8903394177856218e-01,-1.2692290935614794e-01,-6.2221973724439814e-02,-2.4025574326601706e-01,8.6224756400497427e-02,5.6382400847336721e-02,-1.0501318779590385e-01,-2.0951621058689512e-01,1.1652623902306712e-01,1.0222858342197697e-01,-1.4858996845542066e-01,-2.6477708973030627e-02,1.6751226920326070e-02,-1.5511220089986238e-01,8.4424886165360730e-02,5.6424889092440568e-02,-2.4663019719536480e-02,-1.8614014444105473e-02,-9.7151266635612327e-02,-8.3234563999134661e-02,1.8265998711078760e-01,-1.2740459395318599e-01,1.0083217229906055e-01,-1.9176525563637806e-01,-1.8072585202394922e-01,1.8402917902659913e-01,-1.6621625384807831e-01,6.4487711639260578e-02,-2.6087177716056892e-01,-1.7434914406259513e-01,-4.5770668516961197e-02,1.4271060812193342e-01,2.7410196536881881e-01,1.1437451681698614e-01,-7.0567920639963005e-02,1.1603210949940483e-01,1.1294163206833593e-01,-1.1818721694154648e-01,-9.0914441416058686e-02,-5.4851255007768898e-02,5.1905235691355883e-02,8.0349261709938696e-02,1.6512573207246897e-01,-8.9529940631555074e-02,1.1164615369552341e-01,-3.9852112306408741e-02,8.2445297739085335e-02,-2.9272700775690823e-02,8.3989094944586326e-02,-1.7942720914011745e-01,-2.2415972967740901e-02,3.2226618763633741e-01,2.2214069162132494e-01,-1.1252180085842575e-01,2.9010560103745059e-03,-1.5732913221077471e-01,-4.9025606770661770e-02,-1.8469286815142069e-01,-1.3809650028310388e-01,1.8116399620504064e-01,-7.1318152382248728e-02,8.7159279240212703e-02,3.0043998021539817e-02,-1.9068196460237494e-01,2.7379280919973985e-02,-1.1460035291307684e-01,-1.1254480639921019e-01,-1.9395496267602791e-01,2.6025798489609120e-02,-2.3547261849406675e-01,-5.4170639112528307e-03,3.1626897874209242e-01,1.0666808424441389e-01,-1.1659244526101599e-03,1.0931476384795485e-01,-2.0538423042013043e-01,2.1427743903005642e-01,2.0691478873590782e-01,1.8442542190473352e-01,6.9844166141494426e-02,-1.2032414876435467e-01,2.8668446711079587e-01,1.0440566439178213e-01,5.7171180460974476e-02,-1.2765951368700512e-01,5.1303466125814129e-02,5.7302066594237797e-02,-1.1071136899504569e-01,-5.7811497533292289e-02,-2.9420644481094934e-02,-1.6863147221283883e-01,-3.0008570033569854e-02,-2.9025373023462923e-02,-7.0068001363670557e-02,-1.5380905141268056e-01,-3.8938184621109033e-02,4.4494638582471463e-02,-1.1181727453075202e-01,-1.0864174487701869e-01,-1.4627305503402380e-01,2.1867501425402397e-01,-1.6065077490687316e-01,-2.1828241432765402e-01,1.5379700641875126e-02,1.7846901864670847e-01,-1.5459939385036978e-01,-1.2206757944970036e-01,2.6913331837119275e-01,-4.1911433777283381e-02,-7.9525065844908427e-02,-2.5177381862711684e-01,1.7822733148320982e-01,2.0637828886225066e-02,1.4402345538471983e-01,-1.6176138775557475e-01,1.6414745724644245e-01,9.9587532415997659e-02,1.2154469227745635e-01,1.3270456681900658e-01,1.0836613449075883e-03,3.5014186142898841e-02,6.4422587432053993e-02,2.5650891078905830e-01,-1.3613510439599356e-02,-7.4183604470737588e-02,3.9699327829454720e-02,2.0872981358081308e-01,2.8954313068618476e-01,-8.7124011992635225e-02,9.7935789387526020e-02,-2.4938418748479693e-01,1.3283227463564479e-01,-1.3995053930777446e-01,-2.4833985681113373e-02,1.2857128436853771e-01,-1.9031505309316684e-02,-9.8550917632324458e-03,-6.2293879686247361e-02,-2.5068367985148032e-01,1.2799983813015113e-02,9.9642625132676507e-02,1.6160020451492968e-01,1.7418918942892141e-02,-1.2934522063079071e-01,1.7440781261403795e-01,-1.6891383433695675e-01,-1.1499251209546843e-01,1.0919805853532893e-01,-3.3958596235466054e-01,3.9491897262983855e-02,1.4409904627817835e-01,-1.2492613937127686e-01,6.4824216149027530e-02,-1.4500920694738677e-02,8.9482452801014439e-02,-1.1508053110648954e-01,-2.9450003310240092e-01,1.3686221064864456e-02,5.6987167531930370e-03,-1.7910622660624636e-02,-1.6422143347674914e-01,-2.9646156646225830e-01,-6.3040253334867541e-02,2.8612949797922605e-02,-4.0256684503669836e-02,-6.8867232575149040e-02,1.7232982248999054e-01,-2.0464044749442953e-01,7.1943922181842646e-02,6.8339465809922145e-02,2.0838670533672962e-01,6.1836591702641754e-04,-9.4068882281706234e-02,-1.9233586224662658e-01,1.4242758175274214e-01,-2.8115028698558305e-02,5.4713110727468747e-02,7.8138521715865508e-02,2.5068878138756701e-01,-2.1377066144009294e-02,1.3927560657716820e-01,-1.6190338893597628e-01,-1.1008694971912510e-02,5.7786074736259248e-02,-1.6875110076754386e-02,1.4133449187769936e-01,6.0268335264064103e-02,3.5697025223894885e-01,-7.6858879626359983e-02,-2.5593403524331632e-01,6.3532208969522025e-02,-1.1665576803997781e-01,8.9244290042589866e-02,-5.9847234056368021e-02,6.1197519459346594e-02,4.5622580761156467e-02,1.0890303860209163e-01,-2.4409179718533802e-01,-1.9300579515804694e-01,1.7088798959238380e-01,3.1866384763916938e-01,6.6838164155619481e-02,2.4322720914223911e-01,2.5746129093314518e-01,-3.3032378185094058e-01,-3.0263782783712577e-02,-2.9713551857765710e-02,-4.2801169099029604e-02,-5.5718500915720318e-03,-3.5768019640671000e-02,-6.4197961445444734e-02,2.3331833824508406e-02,-6.2836013114537931e-02,-1.5293851919380241e-01,-9.9290461994643558e-02,3.0099130541681751e-01,-1.8174934650833370e-02,1.8039136330541858e-01,-9.9563308382327173e-02,-1.4454139447374184e-01,9.8012832234810915e-02,-6.7947312778025737e-02,-1.0975516985169169e-01,6.6961629325357139e-02,1.4317179260376955e-01,4.7364284066685539e-02,-2.7579632896265825e-02,-3.3025783475732609e-02,4.0767484089568248e-02,-1.9916194919863139e-02,-2.1869093794790653e-01,-9.4593455012967648e-02,-1.9031459543191892e-01,1.1559444393832131e-01,-1.0612818997524591e-01,-1.4267535479715893e-01,7.7665385416730098e-02,-1.1857481858315351e-02,1.3558529752131854e-01,4.3575287007389087e-02,-9.9565749756010999e-02,1.4159555315501476e-01,-1.6803958370458214e-02,1.6711381347605292e-01,7.1989198690279727e-02,-5.3159150729021741e-02,1.5060490418853331e-01,-6.5797021842575590e-02,1.5475280397581156e-02,8.1807454238314994e-02,-6.3900730556100793e-02,-2.6635825246857853e-01,-5.6863062028526194e-02,2.8288583128880235e-01,1.9124477305891302e-01,1.7470341850708646e-01,-1.6414724138393452e-02,-6.5535911107161393e-02,2.1854023186578775e-01,3.1211172047344682e-01,3.2416713551287862e-01,3.9613003634382943e-03,4.6888168137629450e-02,2.7782612040968581e-03,-1.3929419864709577e-01,9.5014770769301649e-02,1.0234407029289395e-01,4.8421885461985559e-02,2.0661352395813162e-01,-4.2725276467542254e-02,8.7676378272400518e-02,1.6052344663411056e-01,5.9432619358566800e-02,-2.1384967179407932e-01,-1.6533181715174011e-01,-1.8184825982481254e-01,1.9495601004200069e-02,-6.8420118272245534e-02,2.3190361023570177e-01,1.6977818861874039e-01,-1.4210801515774796e-01,-1.0090484850236888e-02,3.9475026496818721e-02,7.3843965358343977e-02,-1.6523951486184840e-01,-1.5148544113763485e-01,1.0664923476293116e-01,-3.6248801448976319e-02,9.3543639502859696e-02,2.8176960807270029e-02,1.7240488384340164e-01,1.8122417088949294e-01,-1.3660645465617784e-03,2.7734844420730997e-01,-7.7246138185258287e-02,1.4182845362147015e-02,2.1398458899791217e-01,-1.1438975500164633e-01,1.7237794460100037e-01,-8.9030062257986195e-02,-1.3679781729154691e-01,6.9855804064610130e-02,1.1671601865615373e-01,1.7979053334592396e-01,1.5955849781964926e-01,-4.1468535048886333e-02,2.1135334637491435e-01,-6.3334824713811855e-02,-8.6796771940876830e-02,2.4337248899941114e-02,-1.2925550829708504e-02,2.8567138499847180e-02,1.0574375905193222e-01,7.3963744116898267e-02,1.9659831563849361e-01,3.0168166454336937e-01,-2.2312157338243521e-04,-8.3658885785446419e-02,-1.2980825395162638e-02,1.5032320152783657e-01,2.2008669400630593e-01,-2.6197738839088974e-01,-2.7143181521444178e-02,2.5742614237345373e-02,1.3446872904746979e-01,2.3154532919190110e-01,1.1764897214923253e-01,1.1622383871298282e-01,1.1178510314949100e-01,6.4799009182416240e-02,1.7584351972054055e-01,9.3639832407759221e-02,-1.9965029094454290e-01,1.7023612346940284e-01,-7.1406837740879692e-02,1.0482639343397714e-01,-7.2923306020804490e-02,1.0422128595726025e-01,-2.2679862678503626e-01,-2.9422251337841615e-01,-1.6112284642097754e-02,6.5861700861734720e-02,-3.8394497486396603e-02,-1.1227299769985119e-01,-2.7914041252818428e-01,-1.9419175219735696e-01,1.5850195837024175e-01,-1.3632537031341657e-01,-2.6069364042941995e-02,1.4651889337749338e-01,1.2249482369645077e-02,-3.9615611530573643e-02,1.9104355627441474e-01,-4.9534781886083998e-02,-1.5892356633698018e-01,4.9895640245565739e-03,2.8892623674500600e-01,1.6769480419659655e-01,-2.0555170094454459e-01,6.7062717060740240e-02,2.2144923847004366e-03,-1.0776785397125137e-01,9.1524502266084329e-02,-5.5683348700876489e-02,-1.0268816986527778e-01,-1.1667613302107396e-01,-8.3428338214271661e-02,-9.1492332678559107e-02,-1.5111072408039308e-01,1.9267559070152263e-01,1.5384837615504854e-01,8.2140044335857365e-02,8.6169910487420814e-02,-3.5527816079084829e-01,-3.1348624025251304e-01,7.1480447179652282e-03,7.8982540170237148e-02,4.5027517582005971e-03,-1.4042869412498701e-01,9.7171081519344782e-02,8.5407751623955155e-02,6.3029133498704912e-02,1.3796980485326693e-01,-7.3944308839169498e-02,4.2472273897670332e-02,4.2618940739318635e-02,-6.0648031566996830e-02,1.3140346894265284e-01,9.0999711046331352e-02,-2.6086961215012354e-02,-5.3411371907859453e-03,1.3609410579925280e-01,-1.9213989700330069e-02,-8.1468606048735515e-02,-8.1993277159820230e-02,-2.3931015729075450e-01,1.9805626823293757e-01,6.1665692316472911e-02,6.9097600556922489e-02,2.8186049815560393e-01,8.8131477029291111e-02,-4.0737590775574720e-02,-1.1865938708187337e-01,4.6718504591289810e-02,1.6257275206075963e-02,-2.3422672545761411e-01,5.4228499833985241e-02,-1.6785038972369559e-02,2.8027367543059301e-01,-2.1892962860555712e-01,-3.0501093842333057e-02,-6.1256064264947896e-02,3.3785277654279156e-01,-8.1258823348787729e-02,2.3188399518636507e-01,-1.1074105443229301e-03,-1.6701779929316196e-01,6.0430958740943459e-02,-4.4009953041768600e-02,-5.9625240134367472e-02,-3.1151692097434042e-01,-6.5614041606241236e-02,1.1423384421793491e-01,-1.2072748471862070e-01,2.2248251056047674e-01,-1.0961208541460911e-01,-1.2467203397264467e-01,-5.1024400054892421e-02,1.2894677601206381e-01,-6.2521093544394848e-02,-1.1229454578702582e-01,6.1075861749136186e-02,6.8787660460800454e-02,-1.6067305752081415e-01,-1.0899151642590231e-01,-1.0238808397569854e-01,-1.1189914735658617e-01,1.0522870932852725e-01,-1.8370185832416799e-01,2.3317188928138284e-02,1.4745339082968642e-01,-1.6334664641598526e-01,-1.8830331066361148e-02,-2.2198989797192620e-02,6.6019368700984543e-02,1.2405983907500368e-01,1.1964269010639844e-01,-1.8046572443377457e-02,7.7459601929672217e-02,1.9135128313247785e-01,1.6968716694905672e-01,-8.4035177745809236e-02,2.4997618908475724e-01,-2.0492139200860487e-02,1.3235720690497357e-02,-1.0177968974230450e-01,4.4966506961023417e-02,7.4659224146054123e-02,1.8321723347358224e-01,2.5632310470152364e-01,1.0107404359300434e-01,1.5058368715145906e-01,8.4940597515903174e-02,3.1444022146833112e-01,-1.5382662644577025e-01,3.0242672171701575e-03,-3.5624328044855644e-02,-1.7637846490425418e-01,-1.6879221458315161e-01,5.4855125659772552e-03,-2.3962563240334175e-01,1.0237229573632918e-01,-5.1805336887090166e-02,2.5750260003273473e-01,-1.1572561439522264e-01,-4.7398189465950320e-02,1.1012741142817045e-01,-7.1292499760706077e-02,8.3983191635772156e-03,-1.2603354726499651e-02,-3.8163297654920367e-02,-1.7955376067295920e-01,1.2413453886053527e-01,1.0829941354709421e-01,1.7632939874890896e-01,2.2349537137530581e-01,7.0674339227661226e-02,1.6841749164503342e-01,-2.9708375892496031e-01,1.3082767046818511e-02,1.9786496550299248e-02,-4.6489252053612831e-02,2.0498375285394549e-01,1.0253120413821297e-01,1.5612813407642762e-01,-1.1343827199912634e-01,1.6815866355912457e-01,1.2504275135946441e-01,2.0623778656268177e-01,-3.2633882424697969e-01,9.9963437464016591e-02,-2.0035322106443595e-02,-8.2150141075971739e-02,4.1974745496659677e-01,-9.2046637986965177e-02,-3.9607325853660306e-03,6.1630225630851757e-02,-2.9264261643020664e-02,3.3154250744714349e-02,-9.8550080124378880e-02,-2.4381080697713053e-01,-1.4465833592775534e-01,6.0603919721629047e-02,7.9166620038350038e-02,7.6845012277912378e-02,-1.8397759463561592e-01,1.1547666685102212e-01,1.5947188809736160e-01,-1.3669051920369532e-01,-4.9229331022794705e-03,-6.6687364055030257e-02,8.3976796226660683e-02,-8.1857591909027971e-02,-6.8332508440308776e-02,-1.2414779773332818e-01,-2.4767710519120462e-01,-6.9881103136296460e-02,1.7144664910606160e-02,-2.8618469762589788e-01,6.5501381748435755e-02,6.5894134453118279e-03,-5.7320850019067317e-02,-6.7064327648519675e-02,7.8675579756632405e-02,-6.5627807117557321e-02,2.6620177829304437e-01,1.4956340189906228e-01,7.5986830496467817e-02,3.7533831295997092e-02,1.9351642526930990e-01,1.9060496852752892e-01,1.4099865391880215e-01,4.3985184292972060e-02,-3.1460406666840629e-01,-1.3133609455704498e-01,-1.4470957770555562e-02,1.4100992566698087e-01,2.2354352078693437e-01,4.9349851672822319e-02,-4.9940744134460709e-02,5.7170594514910175e-02,7.7647690744240744e-02,2.9099454635017237e-02,1.6211223308613831e-01,-5.3329110337143243e-02,2.4706641173962562e-01,-2.1718272863309584e-02,-3.9652547903646064e-02,7.6777727102421547e-02,-1.0178112497922065e-01,8.9763287935973463e-02,1.7478219779813631e-01,-1.7583490717621339e-01,1.3229433147504802e-01,6.6670116182696720e-02,7.8264994603506693e-02,-3.6835303574258893e-01,-5.7262090395598077e-02,1.0913384224506976e-01,-1.8813981739282643e-01,2.0847056005902037e-01,1.7532938859907773e-01,-9.9068765216833790e-03,-1.6371505619905130e-01,1.1929710500479453e-02,1.4060278791079045e-01,-1.3361912774715745e-01,8.8221235510898680e-02,-9.4559876519748273e-02,3.5364830047767346e-02,2.8738813979377095e-02,-1.0632252735380478e-01,-5.3787318061712941e-02,-1.4383713928536615e-01,2.3102704029058091e-01,-1.0973424292561565e-01,1.8737814923925636e-01,7.3074986698721256e-02,-1.1086757092931293e-01,2.8663653955169819e-02,-4.6168648107137195e-02,7.4882418815896259e-02,-3.1581236637479554e-01,1.6184634791217128e-01,-4.6100190983497866e-03,5.2897746875879299e-03,8.7703631635113480e-02,9.7588842300754333e-02,3.9367886231385110e-02,1.7699805943078456e-01,5.7089418588209415e-02,4.9405434473561577e-04,-1.4028789217455218e-01,4.6083548881515078e-02,5.4349514443634547e-02,-8.2485329378892580e-02,-1.7638739128149813e-01,1.2091825984322761e-01,-3.4207248323144579e-01,1.5876329187059643e-01,4.4203944652800232e-02,3.9290478164081669e-02,-3.2665835397667470e-01,1.7490037350271298e-01,8.2433950236560860e-02,1.6998339205665158e-01,-2.5843533331846863e-01,2.2400807985122523e-01,-1.4800131396994007e-01,-7.4344879694102667e-02,-3.2447279619296741e-02,5.5800102691016207e-02,-1.0529916264709905e-02,-1.0939745303041902e-01,2.2559024647556020e-01,-2.0122271134596456e-01,1.1184089467836406e-01,-4.1317327648369373e-02,-1.0746112099032235e-01,-1.4426093453309219e-01,3.7513413105712531e-02,8.6084335007313842e-02,1.5883808746554995e-01,3.7288015648248171e-02,-1.2544048630066179e-01,1.8957359739911472e-01,-1.8341043251877326e-02,1.0606537605817583e-01,1.3714324006729559e-01,1.0195736829939657e-01,6.6402816548695506e-03,-8.5963978219561324e-02,2.2305903859598342e-01,-3.5065674246787790e-02,-3.6947716320666034e-02,-1.1130080349496578e-01,-1.5133176468460860e-01,-2.1221010239510711e-03,-2.4143934231862049e-01,-7.3731225092156530e-02,1.2833515701478337e-01,-9.3482945118938135e-02,-4.9280552894216519e-02,1.3110192568606527e-01,-8.0759033090423940e-02,-1.5935327113839094e-02,2.1474360687637889e-02,-1.6709809220201083e-01,-7.8562518894343042e-02,-1.1250681422837304e-02,7.3613566700980224e-02,-1.4341702154365915e-01,1.4165492449494372e-02,9.9629961956539712e-02,-1.3848886494126786e-02,1.4246960725746155e-01,-4.2757484328940981e-01,-2.8382180340224928e-02,1.0076627922977185e-01,3.6551720672785221e-01,-2.7179182131177082e-01,-1.3180759099538388e-02,9.1687946069680351e-02,1.2637009278931030e-02,-6.9865303575547988e-02,-1.2364468115828077e-01,6.6183933576429529e-02,8.7977287811229252e-02,6.0057062712971433e-02,-4.1610247291471551e-02,2.4237578481503383e-01,8.0908475962178400e-02,3.5192616019380271e-02,3.3274258923318067e-01,6.0394815570622457e-02,-1.0955169960771961e-01,-2.1158236990766518e-03,-2.1732633862459405e-01,1.2556106431406608e-02,-1.5355729324561432e-01,-4.4377157978771356e-02,1.8439425408559615e-01,4.2147093802748260e-02,1.0270018930432859e-01,-8.9885548348067404e-02,-1.2382699260979609e-01,-2.5021673997518279e-01,8.5703099336171554e-02,1.7826468735986467e-01,6.8377259542977964e-02,3.5357362631520825e-02,-2.2854248555608797e-01,8.3996601246205685e-02,1.4348517499568117e-01,-4.0204270091969294e-02,2.8783811433823352e-02,-6.5341275570589441e-02,1.4398378164202330e-01,8.5967464416943612e-02,-2.1922902579408493e-01,5.0394881011786886e-03,2.4082971070390594e-01,-5.9063442208003775e-02,1.0175758884232004e-02,2.6087852175976499e-02,6.8577712449988124e-03,9.4199663579229265e-02,-3.8391727742185827e-01,-2.2742639812458154e-01,-9.9517256108392377e-02,1.8180418152216929e-01,2.8013172595590934e-02,3.0176135559446093e-01,1.7208872005919615e-01,1.3182464317429293e-01,-2.0499309480071448e-01,-8.0896341258747909e-02,-8.2595018643525669e-02,-4.0015448745422580e-02,-6.5466168438474581e-02,1.0042523726176582e-01,9.4928998793189820e-02,-1.2929100541534677e-03,2.4254895081029948e-01,9.9509141936436174e-02,-8.5639023043870430e-02,-3.2131109489205046e-03,-6.4001765548616876e-02,1.4700622049146972e-01,1.2033218602774748e-01,3.3081210966193714e-01,-3.2130405745338092e-01,2.8580007924455364e-02,5.8948321646818742e-02,2.7667928025072491e-01,-2.5951185343051081e-01,1.7253196446701030e-01,1.0536843774224071e-02,-1.1103197685828020e-01,2.5110144390950030e-02,1.1363457605256291e-01,8.0650257451210614e-02,-8.1088017314015479e-02,-8.4980438894432270e-02,-3.0948670075988040e-02,2.1873343763903375e-01,9.1786002053571708e-02,2.1782707527154815e-01,-3.8459762306948225e-02,2.4554886116407489e-03,-2.1369535348719958e-02,1.5597080934310423e-01,1.1004567093061686e-01,1.1679887346337009e-02,-8.1973259283633193e-02,9.8876297574308755e-02,9.7071113836493417e-02,-7.4050182805502879e-02,2.0280870754994618e-01,-1.9482207467288876e-01,-3.6235754398845230e-02,-2.4229042803806403e-01,1.9165413799358719e-01,-8.1936461802723862e-02,1.0150802739005170e-01,-7.1002304130779542e-02,6.1307725333475359e-03,-5.7432570084354706e-02,5.7274156713296442e-03,1.6706302183628835e-01,1.9417415084448694e-01,1.4269134195883951e-01,1.1874702621326072e-01,-6.1408323366271521e-02,9.2389429302973877e-02,9.1317834274658727e-02,-1.0224391353706916e-01,-1.8911716255601417e-02,2.0302042011362928e-01,-9.6513922572327729e-02,1.2136410523621086e-01,1.4961773577663609e-01,-1.6767666446906884e-01,1.5168164217370120e-01,1.1202108366647584e-01,-6.0977752722579381e-02,-2.5924251192160397e-01,4.7319862001296509e-02,9.8286668646306134e-03,9.7380550633810653e-02,7.0643473975329912e-02,3.4254657458853713e-02,-1.3658083083745423e-01,1.0109487532633669e-01,-1.4513345237704786e-01,-7.7068411622011820e-02,2.1142008985551550e-02,-1.2559081306208411e-01,-8.6549073795353482e-02,-2.4041085527177757e-02,-1.4907882412492807e-01,2.2583034687866793e-02,3.8653207058660953e-02,6.0878947831577442e-02,-3.4347014195097378e-02,-3.6109054940894322e-02,2.1313850989628728e-02,7.5148014360791257e-02,-1.0800059789269012e-01,-1.9228914612982823e-01,-1.0944319817264332e-01,3.1938097259360268e-02,3.7743455970991636e-02,-1.2360175447668499e-01,-1.7938153957277489e-01,2.2546713563106741e-01,2.7774309076110393e-01,-3.4013968676161788e-01,1.6515106865014681e-01,1.3592973352858109e-01,2.1677666900541728e-01,8.5627303648771844e-02,-8.1883510010667140e-02,-1.4791679047846470e-01,6.6388113044456284e-02,-5.7033545651736343e-02,3.3206623340269503e-01,-2.1475536308568219e-01,-1.9341178977885662e-01,-2.2124007582140598e-01,2.0699526630678342e-01,-2.0798227511664036e-01,-1.5743292618072779e-01,1.1060530181577649e-01,-7.7771703209399690e-02,-2.9307913302818879e-02,-2.5640744526479975e-01,1.5446563336284416e-01,-1.7057995771655655e-02,-6.1045967026484710e-02,-8.5143718658236361e-02,2.4844473442898671e-01,-1.1479276858482759e-01,2.0684706380800520e-02,1.5217973946439589e-01,-8.4621737401362751e-02,-5.2779702037360134e-02,-1.0519134790533734e-01,2.4422549147967300e-02,-9.0255194588261423e-02,1.6248803509686424e-01,1.3792709221811805e-03,3.5619597330392805e-01,1.1172426228762407e-01,-1.6533899666853902e-01,2.6862882921211077e-02,-1.1084592871683864e-01,-1.0648041910553531e-01,9.6471319514749965e-02,-3.7185110677089891e-02,9.7273749801446208e-02,-7.3981337309873510e-02,-2.2306848535583040e-02,-1.3161513718271758e-01,6.0204956409950321e-03,1.9235957383769105e-02,1.0368667617206426e-01,3.6211749111085142e-02,-2.7722040550619920e-01,-1.2787798256827856e-01,-2.4996044404918411e-01,-4.3366352826380045e-02,4.6334762382560374e-02,1.9322345785248757e-01,-1.2800123466543911e-01,-1.2009441543973674e-01,2.0576638716790913e-01,2.0647133599295567e-01,7.5666363696988218e-02,-6.9356810374952171e-02,1.2690448195145235e-01,-8.2994201231126385e-02,-2.2240841844382975e-01,-2.1804587686574981e-02,1.8030765338926183e-01,3.7161060019432973e-01,-7.2100996542066254e-02,4.1773155674013490e-02,1.0935809537978559e-01,-1.2655871955128925e-01,2.1772088083265823e-01,-3.1580321399750932e-01,1.0710693479625941e-01,-3.4297567553521766e-03,-3.3409121460900894e-02,-6.1711909484471153e-02,1.1350903017683966e-01,4.9973791476116122e-02,-8.1024515673698963e-02,-1.1988422571367230e-02,-1.1062513351625340e-01,1.5315893487181534e-01,7.3248241532589214e-02,5.0019828503086207e-02,2.2249806725506535e-01,-3.6812360115646862e-02,-5.8387953279575307e-02,-2.4709493088358808e-01,1.2101168010030497e-01,7.4394821063368755e-02,-1.2209648661383854e-01,8.8950354969368234e-02,-4.5698698417254834e-03,-2.7074225457411827e-01,5.5240939694910680e-02,4.0532933319259369e-02,9.0356123237247433e-03,1.4744014736729755e-01,-1.6781411364213877e-02,5.5019604399677076e-02,4.0641475668296762e-02,-2.1921660777606156e-01,-5.7624431148138713e-02,-1.1847634813670893e-01,-3.1252146374550221e-01,-1.2003620556040621e-01,-1.1453961843087836e-01,-1.4286712278198602e-01,1.1572484324084126e-01,-7.3260659794791932e-02,-2.7192697635886817e-03,2.2564301858374952e-01,7.7935113940499311e-03,-1.3934925782820065e-01,-8.6092507802584206e-02,8.4021186687159959e-03,-9.7396286730638479e-02,-1.9131182002108638e-01,-2.5529051352592190e-03,7.5408998485775411e-02,3.1270903985008806e-03,6.8357979239204669e-02,1.7153003953918677e-01,9.7483844419712792e-02,2.6927914278336091e-02,-2.0718396266233399e-01,-1.4237485554147020e-01,-4.9067957377472868e-02,9.6818343568517602e-03,-6.9359451682250550e-02,7.8499211931694166e-02,3.1501285698415449e-01,-8.1238824556900416e-02,-1.6120732790383879e-02,8.6109595832816965e-02,-9.8697495815290956e-02,6.7018799881793240e-02,-1.1071556110093042e-04,4.6331279034399786e-01,5.8737009162224262e-02,-1.0740015039064076e-01,-2.6391392935296243e-01,-2.1559467820699330e-01,-1.6993950596849675e-01,-3.3701810646530037e-02,-1.4526434928483858e-01,-5.0468918894302779e-02,-2.0834605250060920e-01,-1.9792185052767028e-01,9.8386782732998321e-02,-2.6761703230615521e-02,4.9437732993877569e-02,2.4493755616416348e-02,8.5099504548031515e-02,9.7424952698638823e-02,2.9592903811118026e-01,3.0189974358167757e-03,-1.2746731381281720e-01,-1.4179106344919376e-02,-6.1316981578325436e-02,2.1108451373040404e-01,-1.9861067057744161e-01,-2.7461612408360114e-01,2.8217719784624406e-02,-2.5478162640596463e-01,8.1729443749075883e-02,6.3078889548082204e-02,7.1211166643096718e-03,4.1985279184413388e-02,-9.1472366436625846e-03,-1.7296158595095593e-01,-2.0091010948028162e-01,-3.1506980984118117e-02,1.3302488807635898e-01,-1.9582314456805436e-01,4.3379295599869659e-02,-5.8574054984761759e-02,-2.5254469010009672e-01,-8.6339825251215627e-02,-1.6819876745806317e-01,4.7298239386319968e-02,-1.6605358005914447e-01,-1.6317434881596049e-01,-1.9200522941037637e-01,5.4565513924541547e-03,-2.9206975793720103e-03,1.9430548976253956e-01,8.8074195302997680e-03,3.1833491955250176e-02,-2.1740932612717126e-01,-1.1056911072659027e-01,-9.2919012945739135e-02,6.7302912615455401e-02,-6.9910660965336366e-02,-2.7250006142665050e-02,-7.6288620403020049e-02,8.5988060711373222e-03,2.7835268804654323e-01,1.2249350246854082e-01,4.9470221713367839e-02,-4.5180312999735843e-02,-9.7467290860197162e-02,2.8163339615394617e-01,1.7034357862788996e-01,1.9819892305880452e-01,7.4011464712537403e-02,-6.5253330887729555e-02,-6.9832359301655184e-02,-2.0331224780963528e-01,1.1851929043877961e-01,-1.9919531683387159e-01,-1.3414299760312046e-01,-2.7066316688192044e-01,-7.4900071353634556e-03,-1.9221942238128478e-01,-1.3002887387669818e-01,5.0933407892409639e-02,1.5579478623053011e-01,-4.9764585648642959e-02,-9.1112538416445510e-02,2.6181528531955406e-01,2.1197485123716958e-01,-1.0606626451607331e-02,-9.4834039682379107e-02,4.1498406381870287e-02,-1.0696159819916878e-01,1.0501481176967059e-01,-1.0066575988437834e-01,4.6016382319506714e-02,1.9815147684950632e-01,2.5629530121154299e-02,3.9362593330253833e-02,-3.1492858086527034e-02,2.1936576550650073e-02,-1.6235016658490511e-01,-3.7537299082761919e-02,7.5980048379970258e-02,-1.2863178072830256e-01,-1.5123581399348521e-01,-1.5962883778256531e-01,8.0103930630164855e-02,-1.4879481789216145e-01,-1.2160484733749653e-01,-1.8991849143086381e-01,-6.4247539183507119e-02,-2.0878220189957447e-01,-3.0065767108040964e-01,-2.8917229703661201e-03,5.0629368865084498e-02,-3.7688354432736382e-02,1.6797098267648675e-01,-2.9298757920278092e-02,-3.1116409602062928e-01,1.4053007890036232e-01,-7.6670758269456060e-02,-4.8061796601155587e-02,-1.0668197109885016e-01,-2.0929762371237531e-01,-1.8032316147780522e-01,5.7152645599506113e-02,-1.5119809013251859e-01,-3.9844181944773613e-02,-2.0553667403949341e-01,3.5010243532031089e-02,5.9845280571937776e-02,-3.2210329478723848e-02,5.6916698236077271e-02,-1.0962402846375648e-01,-8.6884766269553868e-02,6.1982798286272352e-02,9.6895882106362768e-02,-1.8925624013292494e-02,-2.1811325562619560e-01,6.6727566211546060e-02,-5.3877177978071490e-02,1.3898655649630354e-01,-9.0851856125761993e-02,-3.7246909607121265e-02,-2.9384515752199386e-02,-1.5557977051482677e-01,4.5314487112766588e-02,-8.5084477025762342e-02,3.2561407568845270e-02,-1.8061920674112319e-01,-4.9613652432374297e-02,7.5716862244675623e-02,-9.5618313113682268e-02,-3.6309637735718792e-01,-7.0844500986270691e-03,5.1196621851240548e-02,-4.0652229018322619e-03,2.4220042001378986e-01,-2.9773543140121944e-01,1.9141151767867798e-01,7.4118392690656759e-02,1.2333350559039073e-01,-6.8637257751575170e-02,-1.0353539180741209e-01,-2.4336828380655340e-01,4.3894736621732433e-01,-1.3073813769892292e-02,2.1198881159451563e-01,7.2051053549680541e-02,4.4905240680138896e-02,-1.3953066050542487e-01,7.1380064979013530e-02,-7.8150218926557560e-02,5.9159498183044779e-02,-1.5978328406264430e-01,4.6110576011509051e-02,-1.8667723989540380e-01,-2.8603652970702474e-02,-1.6641165925307672e-01,5.0401171671945993e-02,7.6770307005710428e-02,-8.3912268671417725e-02,4.7654979816572872e-02,-3.1636962880499103e-01,-3.9566975266522642e-02,1.3147456796290372e-02,9.4758225413529684e-02,-6.5598501912051188e-02,3.6197132664756410e-02,-5.9105380845078319e-02,2.6579827054397188e-02,-1.9181653027149692e-02,3.8381539857195446e-02,-1.0252065401648416e-01,-1.6453625849762632e-01,-1.7412394810707477e-01,3.8184568397798269e-02,2.5303955993923787e-02,1.2568217593129782e-01,3.6013377425769794e-01,1.5864786530857850e-01,-3.7053533407224759e-01,-1.6920121580009809e-01,7.9932576979433206e-02,3.7133275871752650e-02,-1.9620094029841154e-01,1.0284843209006210e-01,-6.8228347591871491e-02,4.6064289448965484e-02,1.3945838892287146e-01,-8.3978407257779747e-02,1.5896782825855593e-01,-2.5637159570164070e-01,1.5644429465111725e-01,2.4458006406267174e-01,1.0097458166859757e-01,-5.2369464821063152e-02,3.6322722442018375e-02,4.3118593365544938e-02,1.7058064544494261e-01,1.7208115808234357e-02,4.9446869514681954e-02,1.8141978931534705e-01,8.2027864862716418e-02,1.8631070648428477e-01,1.2824393215527856e-02,-1.5243097423247870e-01,-1.5120865141123185e-01,-8.0926673891832196e-02,1.6399356526566861e-01,-6.5058424412138577e-02,1.0454537476615242e-01,-2.0227930452781043e-01,-2.3640974053216052e-02,-1.9346304905282638e-01,1.1937676823744055e-01,-1.9035426641811992e-01,1.7921155159975632e-01,1.3308819856492163e-01,2.6137228496168619e-01,-1.3266312282575202e-02,2.3136991136328594e-01,3.6854555562700255e-03,3.5122487553627457e-01,2.5920689147899606e-01,2.5801299347091894e-01,-2.8212425676231606e-01,-9.6414324349521546e-02,3.2950915704723985e-03,-5.6275558595530809e-02,2.1091201713178132e-01,-2.1073723955328955e-01,-1.8887699939775610e-01,-4.8206470236830445e-02,9.7093846836653584e-03,-3.7424123923037886e-02,-3.8202234704459451e-02,-3.7292351184462127e-02,4.7637810918615790e-02,-1.6235532626394100e-01,1.5819844875340264e-01,7.4482390044455241e-02,-2.9445447765310238e-03,6.6208650583013617e-02,1.6092422900633896e-02,4.7704399850154407e-02,-1.0751611224149454e-01,3.5188994846844707e-02,-8.3081130541696243e-03,1.0501042503822308e-01,1.0411448425964975e-01,7.8898227255612949e-02,1.7439910471210539e-02,-9.0577535557738009e-02,-8.8628995702482893e-02,4.5884107637648705e-02,-2.0332860609223041e-01,-6.9821826199630843e-02,7.3665315279690072e-02,3.2404442390154220e-02,-1.1110093054635925e-01,-6.4827891586744096e-02,2.2786212421720309e-01,1.7661762274097639e-01,1.9591607884219412e-03,-2.0482129592486364e-01,-4.4823220031259686e-02,-1.4773314542375743e-01,1.4264002850830154e-01,-2.2146560349995076e-01,-1.6739385453759481e-01,1.1894715558874165e-01,-2.3076847958897889e-01,1.3253528992380820e-01,-4.4125663756758901e-02,-9.2164920048261906e-02,6.1439047380948415e-02,-1.1487973189955528e-01,1.1797448020316707e-01,1.4580491227364267e-01,2.6749084095920667e-01,1.9498349797728734e-01,4.1321051457949030e-02,-2.0560684196422827e-01,-5.2462524987292834e-02,-1.1884859698441007e-01,-1.1097740573838849e-01,-1.1796304555164192e-01,-2.5220203523450513e-01,-1.5914741386415410e-01,-1.0589225336846608e-01,5.6631878938600382e-02,2.3283192359009025e-01,-2.0116527162367465e-01,1.0590846405732321e-01,-9.9748566403173797e-02,-2.3574693621392037e-01,1.1437101227257253e-01,-6.0378019278783286e-02,9.0945481258117550e-02,8.7030901732417371e-02,6.9909751173195984e-04,1.0195516649840702e-01,-9.5743918044629464e-02,1.0586636581317649e-01,2.4601649675531904e-02,3.2506380563269704e-01,1.2145153062217041e-01,4.7826941464499173e-02,-2.7941733680632116e-02,-2.6368077849442145e-01,-1.3618186187534867e-02,-1.4813750930688316e-01,1.4367081877635332e-01,7.4024800082604578e-02,3.7910650049078017e-02,-2.3495022465751251e-02,-8.9634425206674362e-02,-9.7193253906998761e-03,-1.1077916326162607e-01,5.5805459047839734e-02,-2.1210448789493816e-01,-1.3222797579499004e-02,3.5143744489381668e-01,2.6035263395705659e-02,9.3553762203441360e-02,2.7696816390389921e-02,-1.7552168055165915e-01,1.0275290865993078e-01,-9.5576569173988726e-02,-4.9479207301009534e-02,1.6568450168904300e-01,-4.4701087133808590e-02,1.0350027852316829e-01,-3.7089594443757701e-03,-1.1720734871454863e-01,-9.4084476211158646e-02,1.0449825742630728e-01,-1.6446119632133935e-01,1.3760860701080865e-01,-7.2525091679746218e-02,8.6832031851727748e-02,-2.7182540654042958e-01,1.7343749284375759e-01,1.0934848453997964e-01,2.4503238706335159e-01,1.4914711357288141e-02,3.8839303335501736e-02,-8.4960085354727682e-02,7.0444884956123305e-02,-9.7143532262617585e-02,2.2164716659615352e-01,1.8000873921820584e-01,-1.7698065710603050e-01,2.3700584019879481e-01,9.5580700992337897e-03,-1.1830259429084405e-01,-6.3629579734101563e-02,1.7034798258156317e-01,-5.5798705749117078e-02,1.9646848486572464e-02,1.0514720919740897e-01,4.7549543345618478e-02,2.9781921784539638e-02,1.8492862687880315e-01,1.2983544574850001e-01,-2.4613655074367291e-01,8.2653542632150814e-02,3.5779812004423865e-02,2.8662348082208276e-02,-1.6228431623977913e-01,-1.6158189010812582e-01,-1.3404842875635908e-01,3.0110531225891780e-03,1.8906866443686332e-01,-7.9733207646433255e-02,-1.4015942324683309e-01,-9.4530222878727258e-03,-2.6996283181400482e-01,3.0079780244345122e-01,-2.9382698925064243e-01,3.2521843741182159e-02,4.1466063217638807e-02,-7.8039084209688886e-02,2.7634945046375613e-02,-1.1408497733897426e-01,-2.0766427643346763e-01,-9.5535745198724126e-02,2.1009542495099343e-02,-1.9038172280387244e-01,-8.2697391940145679e-02,2.0709027909114203e-01,-5.0855033533879899e-02,1.1894211773160068e-01,-8.2742989832205859e-03,1.2926151580999523e-01,1.6689373982927136e-01,2.1826714771893482e-01,1.7389429277501013e-02,1.0771367283424599e-01,-2.6692264490457235e-01,-1.6887705698855923e-01,-9.6693382487655341e-02,1.8821933974056265e-01,7.6506762656859156e-02,1.6865929285515588e-01,-7.7043767561408710e-02,9.0475171995990145e-02,-7.7039652462937581e-03,-6.9487326147125578e-02,-1.1593672908691281e-01,2.9937320507949616e-01,1.8854453575005811e-01,5.6044531999702496e-02,-1.1083175054511021e-01,-5.9238373475339152e-03,-2.8918261582787486e-02,1.1725782990081603e-01,-7.3797733575606594e-02,-5.9333055770815199e-02,-7.1611715861832778e-02,1.8808782232106011e-02,2.7782686817382201e-02,-6.1550637802037997e-03,-3.9810909011305878e-02,-1.0409450215621446e-01,4.7968683938897264e-02,-4.6320986456931052e-03,-3.5886489561813124e-02,-5.9993194443681147e-02,-1.5852743606484976e-01,-5.7748152974735678e-02,3.8278623140741361e-05,-1.5098598156246554e-01,-1.6111102302928562e-01,2.3665677210011293e-01,-5.3493409390137345e-02,-3.0756357219952019e-01,3.3723311907379933e-01,-9.8368058956905882e-03,1.6761077886782255e-01,-1.4098224117766855e-01,3.8236174931687322e-02,-6.0993935285846221e-02,5.9632590502530246e-02,2.6224905965579054e-01,-1.2179343143406790e-01,-1.3327376190343282e-01,-2.0511622006495731e-02,-7.0921581122939920e-02,-1.3922504837266444e-01,1.3264760628565542e-01,4.4607577158969280e-01,-2.1993469060778283e-02,6.7201084373879241e-02,-9.3809558350396699e-02,1.2067137884130712e-02,-2.1387501740415601e-01,1.6947492028570310e-01,-7.0531951403973447e-02,3.1034558016709651e-02,1.9201500875917901e-01,-1.7104613821605041e-01,-1.3978917961081733e-01,-1.3051728089859429e-02,1.3944659529408807e-02,-6.2753797955923701e-02,-6.1915156757885732e-02,1.2213618417571064e-02,-1.5934143979841686e-01,1.4672172013670420e-01,-3.1133094598375641e-02,3.8034587592027552e-01,1.0305329634788010e-01,-2.8391758591490464e-02,-1.9786212693512878e-01,3.0697693543768417e-02,-2.6472057214392070e-01,-2.0839527711832320e-01,1.7678301513715219e-01,1.3769442570884496e-01,1.7988222956254163e-01,-7.3771323778663647e-03,2.4028269775751496e-02,1.0381580189576944e-01,-1.5565648541303584e-01,1.5089079776657513e-01,8.4102604121677291e-02,-6.6725618911604549e-03,-8.9491972441037418e-02,5.3454412846177496e-02,-3.2403950684698318e-01,-1.0862470065490230e-01,-2.4029636156538869e-01,2.7221685637285623e-02,6.3905283190682227e-02,-3.5018088644916824e-02,1.4007379111168719e-01,4.6163381413454659e-03,-5.2400202374651927e-04,-5.8187181851453919e-02,-1.9508434943642745e-02,1.4241634729800418e-01,4.9560083842655915e-02,-2.7096976602677680e-01,7.3743240727426468e-02,-1.8481356088730644e-01,5.7502045301684832e-02,-1.3113673933409540e-02,3.5537624973360765e-01,-7.6694983825849550e-02,-2.4796084255864848e-01,-1.2938415820667415e-01,8.9546273948917871e-02,1.3290446171699345e-02,-2.0981942472256049e-01,5.4637635577296416e-02,-1.3401933860604739e-01,2.1584312233934355e-01,-1.6119935974093291e-01,-6.2660134012305038e-02,-9.3061935049803424e-02,2.4667387536982513e-01,-8.4229955554131597e-02,1.3657570776860655e-02,1.0515430864278474e-01,-2.1848487528379829e-01,1.4067012261899078e-01,-1.4897900971079611e-01,-1.3769298787763942e-01,-9.0727999199068404e-02,1.4194100601449217e-01,-7.4325103417685306e-02,2.2196593889022960e-02,1.4503938355733567e-01,-2.8435936180406726e-03,-1.4221423298427502e-01,-7.7163274963893719e-02,-1.2207842649008445e-01,3.2656741426155302e-02,1.3095487796519384e-01,-8.0166250768510701e-03,-8.5854092219244713e-02,4.3812546534706287e-02,-4.6593763657868034e-02,1.5529123634632955e-01,-6.5485665655258402e-02,-1.2319318195722988e-01,2.2787405115577025e-01,-1.0639622371056437e-01,1.0898395250144145e-01,-1.9646213299288076e-01,2.1308973250453975e-01,2.6645301290460754e-01,1.9169037079115207e-02,1.7268361140075475e-01,-1.1184023450931452e-01,-2.3392481449117639e-02,2.3380116815848132e-01,2.9727576751587773e-02,-1.5605206311540495e-01,-1.8742005700755912e-01,-1.1678688337506637e-01,-1.9601729631969111e-01,1.8587809394049434e-01,-1.3131537241061120e-01,1.2183240751384995e-01,-2.4647615462475175e-03,1.8621253797172554e-02,3.7454459280016963e-02,-9.6286828279325165e-02,-2.5228663412695439e-02,-1.5793341239739116e-02,1.7234320933410405e-01,-1.1110012428424632e-01,1.8408451910114265e-03,2.6961308922073196e-01,-1.4698531508501442e-01,2.6970733012569238e-02,3.6384572967701069e-02,-1.5301372658949189e-01,-1.1721866685458761e-01,1.4271646430854962e-02,1.0325136379617062e-02,6.1521920418999870e-02,-1.7705604619795459e-01,2.4398267302201321e-02,4.1221823844368843e-02,1.0523558993335155e-01,-9.9030217325990183e-02,3.1883507266449895e-01,2.6369972210956760e-01,1.2173670755476380e-01,-1.1864202716313402e-01,-7.4135860817425875e-02,-4.3734850365723381e-02,3.6803946738611322e-02,-3.4754944608817434e-01,1.5907077834796296e-01,2.9373859753878094e-02,-2.2377248277189613e-01,9.3757306425054573e-02,-8.4889132788592503e-02,-1.6415050866676381e-01,-1.6879697384747813e-01,-1.7719252285063747e-01,-1.8998492459693986e-01,-1.7695587244026770e-01,9.3690906705936439e-02,-1.1201540380562233e-01,-5.8527727763751355e-02,1.2898472759987320e-01,1.8506690913467549e-01,1.2500527752468843e-01,2.3393650868707393e-03,-5.7434186951269110e-02,-3.8183755775790529e-02,-9.5424694097669654e-02,-2.4238856536076189e-01,1.0791414592205070e-01,1.7497256260808755e-01,-2.1223688569877613e-01,1.1633473000866859e-01,-4.2567574312151454e-02,-9.5676848206719622e-02,1.2471260756860553e-01,-1.1841481983157312e-01,4.3602662548170454e-02,-4.2380002253064888e-02,-3.0192835565319320e-01,3.0106837423198446e-03,1.4005074183777388e-02,-1.5812093409977823e-01,-1.5018827491564624e-01,1.8988790060667579e-01,-1.9157332213418982e-01,-4.4500559330486814e-02,5.2020966136900708e-02,1.6207904193684894e-01,4.4980394329571301e-02,-5.4273129517185548e-02,2.4349548146606526e-01,-3.9613508986249504e-02,-3.0600397626332865e-01,1.1420545243078364e-01,-1.1248766759704651e-01,9.6311393184618663e-02,-1.2905959213580070e-01,-8.1196133016113420e-02,1.8714515823975414e-01,1.0664365206084916e-01,1.6689998298399600e-01,-3.1620133858127966e-04,1.8927928410924882e-01,1.4774326524778578e-01,-1.3417502222189290e-01,-2.4250801523937943e-01,-2.9020708236279613e-02,1.6801079145701259e-01,1.4542592958006535e-02,-4.0084982510215354e-02,2.1160611868921408e-01,4.0921641221227670e-02,9.6313210669017296e-02,1.0232539073092001e-01,1.9729115168354416e-01,3.3028166089965033e-02,1.5678662170783567e-01,-1.0046956961777906e-01,-4.0472384551867524e-02,-1.4595258051027871e-01,-4.0827013437516102e-02,-1.8597787119014403e-01,2.5367966749962681e-02,-2.0324530730746126e-01,1.7280205872641644e-01,2.6916156847072291e-02,-1.2359935089420366e-02,3.3554885422217334e-01,8.4920463087634485e-02,2.0669288747320322e-01,1.0668043886342650e-01,2.0180547759835193e-01,8.5220735659090927e-02,1.2197073539665879e-01,-1.5562454376579387e-02,7.3748838371904921e-02,7.5434938367093918e-02,-2.1066855133394811e-02,9.7194779385869831e-04,1.2501438389426661e-01,-1.3539922338952465e-01,-7.4760201067372911e-02,1.2304760649131889e-01,-7.6460872226978394e-02,2.3609840887043795e-01,3.1988903217514197e-01,-1.5945418072557638e-01,9.4444438979590109e-02,4.9445686439324836e-02,2.2165923294190482e-01,-2.2830328206398415e-01,1.0101581164468933e-01,4.4324981991195597e-02,-4.5967160002601301e-02,8.3642373360486785e-02,2.6591217251674043e-02,3.5316365862807647e-02,6.4630019298634878e-02,-1.2216074470415139e-01,-2.1389243219089246e-01,1.0114902568973344e-01,-9.2716126616246550e-02,2.3166536199065069e-01,2.8809612814057566e-02,7.8378412154181981e-02,1.8273052589320385e-01,-1.4093413800999144e-01,-8.5867770540162605e-02,2.1148633796994371e-01,-2.3919936426928809e-01,1.3869125655116096e-01,1.7438000336698239e-01,3.5232556123222000e-02,-2.2149940233937435e-01,2.2208698227945117e-01,-2.1593400489278741e-02,-1.2274831642031345e-02,7.8517603319715967e-02,6.1015784155696001e-02,-5.7451913524819619e-02,-2.0950697882508318e-01,1.1970164756695115e-01,-5.3510285842245875e-02,2.4747320983646420e-01,-9.7357619485379104e-03,5.1324490343315113e-02,-1.8743147654323650e-01,-1.1226950858966889e-01,2.4024869769907778e-01,4.3301480643315765e-02,-1.0527216228143753e-02,2.3349451597939472e-02,5.7508564281764200e-03,8.7997121813691181e-02,-2.2052897409650082e-01,-9.5791409460264848e-02,3.7036999200149706e-01,4.7590032390341278e-02,-1.0658437252109845e-01,-1.9587720150692936e-01,-4.8316892290152853e-02,3.6784526761437550e-02,1.4507423286551432e-01,-9.2502553355486114e-02,3.4350951133244975e-02,1.8953396023380097e-02,-7.2379041734804417e-02,-6.0333984709512664e-02,1.3774538147828280e-01,2.2734577028558359e-01,1.0845202197091963e-02,4.4723227743595793e-02,-2.6845062283333887e-02,4.9729740993163479e-01,1.3183606244177520e-01,1.0925230571738780e-01,7.8749910263965869e-02,7.4312107079291187e-02,-5.4014927101679513e-03,4.0273697627256341e-02,5.7229656562249896e-02,-1.5733071751616856e-01,2.0369628974249643e-01,-2.2809705551460230e-01,-1.3388607169162564e-01,-2.5558797599351472e-02,-1.5344865487617848e-01,-2.9156191149994490e-02,-2.0200954188557760e-01,-2.5762524616157778e-01,-6.4581186996067352e-02,-1.1327807093365921e-01,-5.3491070257616680e-02,1.5726584192966536e-01,2.6037120782034556e-01,-3.6690997934054968e-02,4.7217170933229122e-04,-2.3712153387595740e-02,-1.2772302080201009e-01,-1.6084407898751974e-02,-1.2810947967322002e-02,-1.9443665084296707e-01,-1.5426566951165312e-02,1.7791707972290374e-01,-1.4655676015798297e-01,-1.3791555436336783e-01,6.1833553954073160e-02,-1.3523406477183625e-01,4.9094560794308753e-02,2.2728297055092730e-01,-9.4364853920311825e-02,1.1176983271592539e-01,-1.2061955168743999e-02,-1.2421854707617692e-01,-6.7472582949920479e-02,4.9803905522590369e-02,-1.5543182905659883e-01,-6.4358058424487066e-02,-1.4283818996574082e-01,1.6673020377184145e-01,-1.4572544953278521e-01,1.0430324313272558e-01,2.8613778155981512e-01,-8.4105063332915911e-02,-2.6557379417241959e-02,-1.7545292051875640e-02,-9.8726550423301515e-02,1.1524672305509781e-01,-4.6979524387972184e-02,-4.7646687396405169e-03,-1.5784519551538009e-01,7.2278980283402017e-02,5.6652403633938350e-02,2.2908067133028146e-03,7.1713908284461975e-02,2.3516040156165974e-01,1.2463890049013157e-01,-1.5781230555708745e-01,-5.4746824634493443e-02,1.7988483732907007e-01,-1.6608813243762277e-01,2.3470679454699184e-01,2.2135645882620475e-01,-7.3925499277449194e-02,2.6149513885067976e-01,1.3621643926927192e-02,1.1132081396023571e-01,9.6107922933839698e-02,-7.6360916919153338e-02,2.0490219737719229e-01,3.0146497425978080e-01,-1.0801490079160986e-01,-6.1572306758908284e-02,-1.0071309598857174e-01,9.7972915903270827e-02,-6.7198083029644889e-02,2.1157446419392109e-01,3.6737334003486069e-02,2.8766936961113387e-01,-1.5727547575633306e-02,-1.1930730691825409e-01,1.6600801777308033e-01,-6.4809529533677343e-02,-1.3669468779467323e-01,-2.7837661505341327e-01,-1.2829514857162178e-01,-6.6319319733541465e-02,1.2322331793137185e-01,1.9880780317808408e-01,1.1818921824810136e-02,-6.9111305869296079e-03,-3.8386199320706138e-02,2.9282974233863533e-02,-2.1629452613214975e-01,-1.2067412641342128e-01,-1.4117801483223965e-03,1.6228699208342229e-01,-8.6020816454463050e-03,1.7803318511785718e-01,-1.1380322102999261e-03,5.2861732036479488e-02,-5.3448257924889844e-02,5.7608118947433791e-02,-9.2836221289233287e-02,-9.8743045941942748e-02,2.2883701995963157e-01,1.8034512838137648e-01,-3.1560098253114663e-02,6.1864144395313597e-02,1.5243736059350626e-02,1.8649941348001345e-01,1.2316432096208019e-01,-1.4537871832937690e-01,-4.5194229179844912e-02,8.5840296637152799e-02,-1.6974417131596156e-01,1.1457130509459713e-01,2.6593349926609722e-02,-8.0845419187217549e-02,-7.4036263426896176e-02,1.2032844969718783e-01,-3.5287673201647723e-01,1.4904405247609889e-01,1.8830944481225792e-01,-2.2074437247457329e-01,5.1356701805020173e-02,5.7152231036315518e-02,1.4466440064485134e-01,-3.3101192422076270e-01,-7.8918937059495736e-02,2.4355408084472260e-01,1.0830578511628425e-01,-1.6988847959951613e-02,-1.1467146362074221e-01,3.9306909317817496e-02,-1.2090146239827339e-01,1.1390339701862823e-01,-8.0907496425026176e-02,-6.7335744651621177e-02,1.3194859912455875e-01,7.0631621589234084e-02,-1.0075346082077642e-01,-5.9889200349150231e-03,1.4667595440172007e-01,-4.1261502981427563e-02,3.2638494943257157e-01,2.9838003007164149e-01,-2.6040533733991272e-01,5.9712504367760891e-02,-9.6418799721906742e-02,-1.5370356333152929e-01,2.8674620897728331e-01,1.5101335066944391e-01,2.7962283465761634e-01,-5.3413144615769181e-02,2.1879948877668073e-01,-9.7343307748771327e-02,-1.9090586310863517e-01,-5.4150470347295754e-02,1.5961487162641347e-01,7.3096226776915435e-02,1.0607308510604399e-01,-8.7403860146969908e-02,-1.7871456335373272e-03,4.0770416416849163e-02,4.4043461434448872e-02,-6.8562144990472071e-02,-1.0413445670596809e-01,-3.3498391637656416e-02,-1.0355386300700560e-01,6.6045901232674564e-02,2.3274680188370173e-01,1.9304141223544324e-01,1.3239713468557229e-01,-2.0201606766055705e-02,-5.2681955259444538e-02,1.0963075661149194e-02,2.1354350652105303e-01,8.6842874221168917e-02,1.7725740681992533e-01,1.5404374269749258e-02,-9.3824961019751546e-03,4.3920525548111586e-02,1.9280671001465585e-01,-2.3133632618364811e-01,-3.7041369877133419e-03,1.0060963717126714e-01,1.5422403211684260e-01,1.1569075714930677e-01,1.0960934217997818e-01,-5.4684163499761379e-02,2.1088564156549375e-01,-6.4448844370392472e-02,-1.2089920513921473e-01,1.6879372853036545e-01,-9.7421301549068529e-02,-1.6880179334967163e-01,-1.6652582431246582e-01,-9.0475114509838805e-02,1.1097572991745946e-01,3.6995731760461059e-02,1.5187263649351165e-01,1.0235842196945051e-01,-8.8075695252803031e-03,-1.9555330954179211e-02,1.6458093983065739e-01,-5.4857166654404682e-04,-1.3936486769275533e-01,-7.6860507155030247e-02,-7.9541616691896411e-02,-2.4891286333499202e-01,-5.2029162350366684e-02,-1.3837536850679755e-01,1.3084175892520197e-03,-1.8267740789205061e-01,-1.6298852570079117e-01,-1.1004085894994871e-01,-2.6640486758464332e-01,1.6336483146689999e-02,1.4321574767087736e-01,-4.2242188332188277e-02,1.7236533633931095e-01,3.2612567369644679e-01,-1.9799715479245217e-01,-1.4867226812506454e-01,1.4422472856548046e-01,-4.2228110339327080e-02,-2.3555165957476912e-01,-1.0044638748196222e-02,5.0032419448359615e-02,-9.9365753608402954e-02,2.3983993263032802e-01,-1.2073242978721935e-01,-5.1901850595604697e-02,3.4773558371210211e-01,-5.0596936428325093e-02,-1.3183654443894005e-01,-1.3710522759594038e-01,-1.4608185491030223e-01,-1.4887709230376994e-01,8.3880194924734142e-02,2.1206064872006863e-02,-2.5425348507598616e-01,-2.4955330849067061e-02,-2.0549210184881851e-02,-3.7913532317222311e-02,-1.1145307900798119e-02,1.1112791747233190e-01,7.7475364920965725e-02,1.2442656743345953e-01,3.2007050079437660e-02,1.7625886725498481e-02,1.3290741073000756e-01,5.8754277846983304e-02,-1.9070385151002636e-01,-7.4967275758300797e-02,2.0473573897115438e-01,1.7376469243689679e-01,-2.2911942657207338e-01,-3.6275751325002298e-02,5.4151911925554685e-02,1.5275870690056936e-01,1.0108078264641797e-01,-6.9169456933687506e-02,-2.1977436846807447e-04,-6.2933403137656246e-02,1.9055435403797427e-01,-1.6058140637364868e-01,-8.6544645744795187e-02,1.3096324931337257e-02,-4.1870650897930982e-02,1.1003526734725781e-01,1.0351578201461879e-02,3.0337857764543622e-02,-2.8460771384812267e-01,3.4874255504060570e-01,1.1563040252059342e-01,1.1152123633704702e-01,1.0795990710220116e-01,-1.0106082894627412e-01,-7.0493980075638965e-02,3.0777466294267525e-01,1.2013107903836218e-01,6.0011872474741365e-02,2.5432237681794650e-01,8.5589352638769656e-02,2.0799018230103655e-01,1.2348428112578179e-01,9.3585245334157185e-02,1.5893199418018206e-01,1.0410824318618618e-01,-1.4204763800622344e-01,-1.9185140936363948e-02,-2.0419610955709613e-01,-4.4346093007061618e-02,-1.0226985197307775e-01,3.3884962436198075e-02,-8.8063345150273628e-02,-1.6391371422574727e-02,-1.8373159551235771e-01,-4.1735194838850818e-02,2.9953921969951881e-02,2.3099386727520563e-01,-2.6381574340773140e-01,-2.7460591558687714e-02,1.8433555376635863e-01,1.9484888714779072e-01,4.4547037867037474e-02,-1.9341845323783824e-01,9.0256048265263317e-02,-3.8291935402911030e-02,-2.0883878913636217e-02,3.2733711131750561e-02,-1.4066956067221043e-01,-1.6970765977795307e-01,-1.5204210255137676e-01,-3.8059904441378911e-02,5.9833546596639184e-02,-1.0454177700665880e-01,-2.7714132885110077e-01,-7.0596926036705837e-02,-8.2120732335671132e-02,4.9002175766039557e-04,-1.1538222866166688e-02,5.3950738952957308e-02,-1.4163514656877024e-01,-8.9538530693798357e-02,-1.4062703540030361e-01,2.1994649307115269e-01,-3.5151487164953490e-02,-1.2490646635980963e-01,-1.7523146387670246e-01,3.1292935169179398e-01,-1.9308622428489261e-01,-1.2617487854733495e-01,-1.4204186105686101e-01,-9.8570185243694319e-02,-4.6966470325269620e-03,-4.0239421635187028e-01,1.3575745167066028e-01,-2.9451242071391087e-01,-2.6495541957132746e-01,-9.1984264283356390e-02,2.8574863317772775e-01,8.3568122640033507e-02,-1.0511434077312790e-01,-7.7298272173588728e-02,-1.5185853951380862e-01,-1.0452480133452374e-01,-1.7551573039820977e-02,3.0753841623423700e-01,-2.4274186360946897e-03,-7.9510194721624933e-02,-4.2142365654223010e-02,1.8536273129673608e-01,-6.6816069415600074e-02,1.5641409186036012e-01,-1.1472360656082878e-02,-8.2494795617151423e-02,1.3929359867278707e-01,2.0683438904354112e-01,-2.2801178577216613e-02,1.0524973471148367e-02,-1.1546066695552538e-01,4.1172071400570040e-02,-7.6986226149223097e-02,-1.8590664153484251e-01,-5.2336790252090187e-03,-2.7016295541896954e-02,-5.8416521626649918e-02,-9.4789929725718775e-03,1.1365970732112372e-02,1.6420442035702940e-01,5.3745438072490714e-02,4.4062966371887426e-02,-4.2367675569518856e-02,-1.2154145182563124e-01,-6.9622513752428727e-02,7.7219498777798046e-02,-1.9333271129613772e-01,1.8161790247228776e-01,1.5934751038167727e-01,8.3333122328764206e-02,-1.0470913882642492e-01,-3.1516382264629800e-02,1.3764246862289456e-01,-7.2961281390459765e-02,-2.7020178108702182e-02,-6.1449451305610699e-02,-1.3579355809915969e-01,-9.2326945871091887e-02,2.2861216513587128e-02,-1.8364054735025340e-01,4.7383117345438860e-02,-1.0345909822118114e-01,1.8514491432577931e-01,1.1519184723965072e-01,1.2366326730470642e-01,1.5019472304691872e-01,3.2576986293548454e-01,-1.2623955779269681e-02,-2.4809843737296072e-01,7.2080016309696709e-02,-8.3442183679305740e-02,1.6022544722669022e-01,7.8105553483731147e-02,-2.2371760021145268e-01,-2.2071454444484728e-01,-6.7840233681560502e-02,2.9121333970486485e-01,-4.8512563089875164e-02,7.6983923443268945e-02,-1.3852354481149654e-01,-4.4937731856884516e-02,-6.0557252111778245e-02,-2.1178186033434984e-01,-1.8844270129319299e-01,1.5382082144976797e-01,1.6898332270156996e-01,-2.0306178262696320e-01,2.1424577175406016e-02,-2.2811487869886456e-02,-5.6497177174723225e-02,-1.5289026883637818e-01,6.8567977194611454e-02,6.6466605361653261e-02,1.2046055251517638e-02,1.5289307620046736e-02,-1.5724223037631949e-01,-8.0089569209796610e-02,-3.3454867420336853e-01,1.0660752106576629e-01,1.1056434580610716e-01,8.2228991041017538e-03,2.8521456303642972e-01,-1.0085918988630521e-01,-1.1085213280287043e-01,-6.8406927092705877e-02,-9.5920616334725595e-02,1.8736575239400408e-01,-2.1675024054452284e-02,-1.4576889556937575e-01,-1.5167650900969842e-01,1.0014850831058041e-02,2.6182687369676362e-02,-1.8028455813323785e-01,-1.9085731688784999e-01,6.7768338823336299e-02,1.6809293492868480e-01,-1.4237348318493623e-01,-3.5234877851784918e-01,2.5928447552062521e-02,-1.3712008867772574e-01,-4.6137420873484263e-02,1.9888919022131232e-01,1.7845997290262561e-01,-1.7093999600284615e-01,1.2213440856167759e-01,-1.2549641046018307e-02,-4.6021579332997317e-03,1.4693150194541410e-01,1.7071170736308577e-02,-1.6054931031834782e-01,-8.2995496782937508e-02,-7.8757506361212537e-02,5.2320678674007880e-02,-4.1494932289753032e-02,1.1623488714274569e-01,-9.3738513886289843e-02,9.9975013359036288e-02,3.3726113700399275e-02,-6.9499466794953252e-02,1.0634058268726571e-01,-2.2417500722113465e-01,-7.3976256758166714e-02,-5.4219901820905622e-02,1.8459718527242558e-01,-1.8736513057048276e-01,-2.8164875562437225e-01,2.6408026630586939e-01,8.9423955981605949e-02,7.3582324233701799e-02,9.6689632449920640e-03,1.1394220377824602e-01,2.4184836775505585e-02,-2.3137127833396801e-01,-2.2169677085193928e-01,-1.3015056071737328e-02,8.2361664775042670e-02,1.1191163741647632e-01,-2.1056076126334835e-02,-2.9370998742634893e-02,3.1887119723673429e-01,1.2163472586202526e-02,1.2308776562887404e-01,1.0935701209022418e-02,-6.6166852219372130e-02,2.8683805254520806e-01,5.7603264718055339e-02,6.7630421132106704e-03,-1.3017277399338961e-01,-9.9963025509225562e-02,9.5061628945538365e-02,7.6694661570181719e-02,-2.1788122183086650e-01,1.8740436574710281e-01,1.4341879821131623e-02,7.8985659322082687e-03,-2.1481026093513936e-01,3.8177554637762595e-02,-2.3938334590368780e-02,-2.2740837652192319e-01,1.5177214134063441e-01,1.0213121246759782e-01,-7.2432601128291613e-02,2.5843604714887936e-01,-1.6544092002162114e-01,5.6786962580462529e-02,1.7838823641574489e-01,-2.7263395260625484e-01,-6.7375758283082537e-02,2.1746264319954262e-01,1.3194833387190577e-01,-4.5920192102459345e-03,1.0301464005962062e-01,1.7142966357011749e-01,-2.4096273738410997e-02,-1.1036122258188237e-02,-1.5796667584892199e-01,-1.9887642337482600e-01,1.1387114729463320e-01,-5.0633659908808724e-03,-1.2747584263729936e-02,-1.1982225792292710e-01,2.0735269974839758e-02,-4.3308820873108569e-02,2.2199940965152304e-01,-2.0347123026018288e-01,-1.6418923218956918e-01,2.6963677978447187e-01,-1.0685778649063440e-01,1.9397353787163785e-01,2.2507837943161007e-02,-9.8243644873833941e-02,-2.4515465910118661e-02,-2.5410045773354073e-01,7.3890484948369931e-02,8.4075167924452174e-03,8.2623057576871606e-02,-8.8485927284373267e-02,-1.3366654648755796e-01,8.8957998323097462e-02,2.0071400561298078e-01,-7.6037804540328324e-02,3.5206389903136542e-02,-2.1221405504744656e-01,-1.1337704432620722e-01,4.9515757963125476e-02,7.5201499233007119e-02,-4.2131909195054329e-02,1.6946036432401962e-01,6.6492636857215237e-03,-1.2975324711347935e-01,1.3907848616361276e-01,-3.9091498092468459e-02,1.0332926847030600e-01,-7.5928920908460484e-02,2.8686541608455546e-02,2.0087013055956207e-01,-1.6300092994162579e-01,-7.7830796713711410e-03,-1.4437671397165133e-01,-3.0017273427908060e-02,-1.2080697310597906e-01,-2.1300396567141910e-01,-2.7452696383728471e-02,-1.8304707893495686e-01,3.1043072111705111e-01,9.7861359665926503e-02,-1.3563521381087468e-01,-1.4842040502392895e-01,1.0438388711774069e-01,-2.8723902921087130e-01,-1.2440810906200712e-01,-1.3788303991713274e-01,-5.8429342966838660e-02,6.3212233393595760e-02,8.6351980820987231e-02,-2.1962158654041772e-01,1.4240946700390822e-01,1.8255178670781005e-01,-5.9544235838542639e-02,5.0579224581685851e-02,4.1771934963405104e-03,-2.4807967074842510e-01,9.3323587862807426e-03,-1.3330776686126916e-01,3.9702445002041536e-02,1.7445695341892231e-01,2.9505040067362426e-01,1.5285403410881145e-03,-3.2695675459911158e-02,6.8989396371521211e-02,-8.2992427956343123e-02,2.1253919031636460e-02,3.1421956546789483e-02,3.7924972007493493e-02,1.5061011788247558e-01,-3.5633408380049435e-02,-2.3158016968099090e-01,-3.1330249279609160e-02,-1.5823964414377872e-01,1.0478374407590853e-01,-3.4772920059427509e-01,-1.0204076013193293e-01,3.7285028530580439e-02,-3.1635869289951329e-01,-2.4187707590475813e-01,-9.9547664488813165e-02,1.2120168952954080e-01,1.8505191669534297e-02,-4.5421272693045280e-02,-3.6916784501144807e-02,1.0286133710320415e-01,1.5459506292049577e-01,1.8088195008503886e-02,1.2316216997848274e-01,3.1847761747651004e-01,-3.9482212362347953e-02,1.5739452287331490e-01,-1.0920300214473963e-01,-1.2186806344866387e-01,-6.4157294531185738e-02,-3.4803170325203379e-02,1.0130615269303517e-01,-4.6939386923057796e-02,-1.1868244108221596e-01,1.5371905114774806e-01,8.0545822063824199e-02,9.2610660468357503e-02,-1.7076553346150872e-01,1.2911166010456329e-01,-1.4089898287824926e-01,-1.3709059765453530e-01,9.9792968573516508e-02,-1.8587295198899917e-01,-1.5782598646953366e-01,-4.6894303933461945e-02,-5.3969368792750050e-03,2.0992021654639453e-01,-9.7656807110963501e-02,-9.5169895033182905e-02,-2.5470957406540334e-01,-9.0180010653081982e-02,-1.3293822625608204e-01,-5.6099945249815548e-02,5.4997776607594209e-02,-4.8139705056753170e-02,1.7259202812780997e-01,1.0991931341727670e-01,2.1872817954022816e-01,-7.6025993153526955e-02,-2.7645566656183412e-01,1.2141466632529774e-01,-1.0643425254778444e-01,6.7336182101861500e-02,2.6719597516218396e-01,-5.0684755054820625e-02,-4.1082076039226423e-02,-1.6457929945287664e-01,-4.1104603376776239e-02,-7.8274876013193218e-03,-3.3904424929248028e-01,1.254152956