from paegan.cdm.dsg.collections.base.profile_collection import ProfileCollection

class Section(ProfileCollection):
    """
        A collection of profiles along a trajectory
    """

    def __init__(self, **kwargs):
        super(Section,self).__init__(**kwargs)
        self._type = "Section"

    def get_path(self):
        """
            Returns the nominal times of the profiles and the Points
            the profile was taken at.
        """
        return [[x.location, x.time] for x in self._elements]
