/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.FloatingPointType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class FloatingPointInterval<T extends Number> {
    private static final Logger log = Logger.getLogger(FloatingPointInterval.class.getCanonicalName());
    private final T lower;
    private final FloatingPointType<T> type;
    private final T upper;

    public static <U extends Number> FloatingPointInterval<U> unconstrained(FloatingPointType<U> floatingPointType) {
        return new FloatingPointInterval<U>(floatingPointType, floatingPointType.getNegativeInfinity(), floatingPointType.getPositiveInfinity());
    }

    public FloatingPointInterval(FloatingPointType<T> floatingPointType, T t) {
        if (floatingPointType == null) {
            throw new NullPointerException();
        }
        if (t == null) {
            throw new NullPointerException();
        }
        if (floatingPointType.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        this.type = floatingPointType;
        this.lower = t;
        this.upper = t;
    }

    public FloatingPointInterval(FloatingPointType<T> floatingPointType, T t, T t2) {
        if (floatingPointType == null) {
            throw new NullPointerException();
        }
        if (t == null) {
            throw new NullPointerException();
        }
        if (t2 == null) {
            throw new NullPointerException();
        }
        if (floatingPointType.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        if (floatingPointType.isNaN(t2)) {
            throw new IllegalArgumentException();
        }
        int n = ((Comparable)t).compareTo(t2);
        if (n > 0) {
            String string = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", t, t2);
            log.severe(string);
            throw new IllegalArgumentException(string);
        }
        this.type = floatingPointType;
        this.lower = t;
        this.upper = t2;
    }

    public boolean canUnionWith(FloatingPointInterval<T> floatingPointInterval) {
        int n = ((Comparable)this.lower).compareTo(floatingPointInterval.lower);
        int n2 = ((Comparable)this.upper).compareTo(floatingPointInterval.upper);
        if (n <= 0) {
            if (n2 < 0) {
                if (((Comparable)this.upper).compareTo(floatingPointInterval.lower) < 0) {
                    return this.type.increment(this.upper).equals(floatingPointInterval.lower);
                }
                return true;
            }
            return true;
        }
        if (n2 > 0) {
            if (((Comparable)this.lower).compareTo(floatingPointInterval.upper) > 0) {
                return this.type.increment(floatingPointInterval.upper).equals(this.lower);
            }
            return true;
        }
        return true;
    }

    public boolean contains(T t) {
        if (this.type.isNaN(t)) {
            return false;
        }
        int n = ((Comparable)this.getLower()).compareTo(t);
        if (n > 0) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        int n2 = ((Comparable)this.getUpper()).compareTo(t);
        return n2 >= 0;
    }

    private FloatingPointInterval<T> create(T t, T t2) {
        return new FloatingPointInterval<T>(this.type, t, t2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FloatingPointInterval floatingPointInterval = (FloatingPointInterval)object;
        if (!this.lower.equals(floatingPointInterval.lower)) {
            return false;
        }
        return this.upper.equals(floatingPointInterval.upper);
    }

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public FloatingPointInterval<T> greater(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.type.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        if (((Comparable)this.getLower()).compareTo(t) >= 0) {
            return this;
        }
        if (((Comparable)this.getUpper()).compareTo(t) <= 0) {
            return null;
        }
        return this.create(this.type.increment(t), this.getUpper());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        n = 31 * n + (this.lower == null ? 0 : this.lower.hashCode());
        n = 31 * n + (this.upper == null ? 0 : this.upper.hashCode());
        return n;
    }

    public FloatingPointInterval<T> intersection(FloatingPointInterval<T> floatingPointInterval) {
        int n = ((Comparable)this.lower).compareTo(floatingPointInterval.lower);
        int n2 = ((Comparable)this.upper).compareTo(floatingPointInterval.upper);
        if (n <= 0) {
            if (n2 < 0) {
                if (((Comparable)this.upper).compareTo(floatingPointInterval.lower) < 0) {
                    return null;
                }
                return this.create(floatingPointInterval.lower, this.upper);
            }
            return floatingPointInterval;
        }
        if (n2 > 0) {
            if (((Comparable)this.lower).compareTo(floatingPointInterval.upper) > 0) {
                return null;
            }
            return this.create(this.lower, floatingPointInterval.upper);
        }
        return this;
    }

    public FloatingPointInterval<T> less(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.type.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        if (((Comparable)this.getUpper()).compareTo(t) <= 0) {
            return this;
        }
        if (((Comparable)this.getLower()).compareTo(t) >= 0) {
            return null;
        }
        return this.create(this.getLower(), this.type.decrement(t));
    }

    public List<FloatingPointInterval<T>> remove(FloatingPointInterval<T> floatingPointInterval) {
        Object object;
        FloatingPointInterval<T> floatingPointInterval2;
        int n = ((Comparable)this.lower).compareTo(floatingPointInterval.lower);
        int n2 = ((Comparable)this.lower).compareTo(floatingPointInterval.upper);
        int n3 = ((Comparable)this.upper).compareTo(floatingPointInterval.lower);
        int n4 = ((Comparable)this.upper).compareTo(floatingPointInterval.upper);
        if (n < 0) {
            if (n3 < 0) {
                floatingPointInterval2 = this;
                object = null;
            } else {
                T t = this.type.decrement(floatingPointInterval.lower);
                floatingPointInterval2 = t.equals(this.type.getNegativeInfinity()) ? null : this.create(this.lower, t);
                object = n4 <= 0 ? null : ((t = this.type.increment(floatingPointInterval.upper)).equals(this.type.getPositiveInfinity()) ? null : super.create(this.type.increment(floatingPointInterval.upper), this.upper));
            }
        } else if (n2 > 0) {
            floatingPointInterval2 = null;
            object = this;
        } else if (n4 <= 0) {
            floatingPointInterval2 = null;
            object = null;
        } else {
            floatingPointInterval2 = null;
            T t = this.type.increment(floatingPointInterval.upper);
            object = t.equals(this.type.getPositiveInfinity()) ? super.create(this.type.increment(floatingPointInterval.upper), this.upper) : null;
        }
        if (floatingPointInterval2 == null) {
            if (object == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(object);
        }
        if (object == null) {
            return Collections.singletonList(floatingPointInterval2);
        }
        return Arrays.asList(floatingPointInterval2, object);
    }

    public Number size() {
        return this.type.intervalSize(this.lower, this.upper);
    }

    public List<FloatingPointInterval<T>> union(FloatingPointInterval<T> floatingPointInterval) {
        FloatingPointInterval<T> floatingPointInterval2;
        FloatingPointInterval<T> floatingPointInterval3;
        int n = ((Comparable)this.lower).compareTo(floatingPointInterval.lower);
        int n2 = ((Comparable)this.lower).compareTo(floatingPointInterval.upper);
        int n3 = ((Comparable)this.upper).compareTo(floatingPointInterval.lower);
        int n4 = ((Comparable)this.upper).compareTo(floatingPointInterval.upper);
        if (n < 0) {
            if (n3 < 0) {
                floatingPointInterval3 = this;
                floatingPointInterval2 = floatingPointInterval;
            } else {
                floatingPointInterval2 = null;
                floatingPointInterval3 = n4 < 0 ? super.create(this.lower, floatingPointInterval.upper) : this;
            }
        } else if (n2 > 0) {
            floatingPointInterval3 = floatingPointInterval;
            floatingPointInterval2 = this;
        } else {
            floatingPointInterval2 = null;
            floatingPointInterval3 = n4 <= 0 ? floatingPointInterval : super.create(floatingPointInterval.lower, this.upper);
        }
        if (floatingPointInterval3 == null) {
            if (floatingPointInterval2 == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(floatingPointInterval2);
        }
        if (floatingPointInterval2 == null) {
            return Collections.singletonList(floatingPointInterval3);
        }
        return Arrays.asList(floatingPointInterval3, floatingPointInterval2);
    }

    public Iterator<T> valueIterator() {
        return new ValueIterator(this, this.lower, this.upper);
    }

    public static class ValueIterator
    implements Iterator<T> {
        private final T last;
        private T next;
        final /* synthetic */ FloatingPointInterval this$0;

        public ValueIterator(T t, T t2) {
            this.this$0 = var1_1;
            if (t == null) {
                throw new NullPointerException();
            }
            if (t2 == null) {
                throw new NullPointerException();
            }
            this.next = t;
            this.last = t2;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object t = this.next;
            this.next = this.next.equals(this.last) ? null : this.this$0.type.increment(this.next);
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

