/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DynamicDatasets;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.migrate.A2;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import org.apache.jena.atlas.lib.Lib;

public class QueryEngineTDB
extends QueryEngineMain {
    private Binding initialInput;
    private boolean doingDynamicDatasetBySpecialDataset = false;
    private static QueryEngineFactory factory = new QueryEngineFactoryTDB();

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    protected QueryEngineTDB(Op op, DatasetGraphTDB dataset, Binding input, Context context) {
        super(op, (DatasetGraph)dataset, input, context);
        this.initialInput = input;
    }

    protected QueryEngineTDB(Query query, DatasetGraphTDB dataset, Binding input, Context cxt) {
        super(query, (DatasetGraph)dataset, input, cxt);
        DatasetDescription dsDesc = DatasetDescription.create((Query)query, (Context)this.context);
        if (dsDesc != null) {
            this.doingDynamicDatasetBySpecialDataset = true;
            this.dataset = DynamicDatasets.dynamicDataset((DatasetDescription)dsDesc, (DatasetGraph)dataset, (boolean)cxt.isTrue(TDB.symUnionDefaultGraph));
        }
        this.initialInput = input;
    }

    protected Op modifyOp(Op op) {
        op = Substitute.substitute((Op)op, (Binding)this.initialInput);
        op = super.modifyOp(op);
        if (!this.doingDynamicDatasetBySpecialDataset) {
            op = Algebra.toQuadForm((Op)op);
        }
        this.setOp(op);
        return op;
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context) {
        if (context.isTrue(TDB.symUnionDefaultGraph) && !this.doingDynamicDatasetBySpecialDataset) {
            op = A2.unionDefaultGraphQuads(op);
            DatasetGraphTDB ds = ((DatasetGraphTDB)dsg).duplicate();
            ds.setEffectiveDefaultGraph(new GraphNamedTDB(ds, Quad.unionGraph));
            Explain.explain((String)"REWRITE(Union default graph)", (Op)op, (Context)context);
            dsg = ds;
        }
        return super.eval(op, dsg, input, context);
    }

    public long getMillis() {
        return -1L;
    }

    private static class QueryEngineFactoryTDB
    implements QueryEngineFactory {
        private QueryEngineFactoryTDB() {
        }

        private static boolean isHandledByTDB(DatasetGraph dataset) {
            if (dataset instanceof DatasetGraphTDB) {
                return true;
            }
            return dataset instanceof DatasetGraphTransaction;
        }

        private DatasetGraphTDB dsgToQuery(DatasetGraph dataset) {
            if (dataset instanceof DatasetGraphTDB) {
                return (DatasetGraphTDB)dataset;
            }
            if (dataset instanceof DatasetGraphTransaction) {
                return ((DatasetGraphTransaction)dataset).getDatasetGraphToQuery();
            }
            throw new TDBException("Internal inconsistency: trying to execute query on unrecognized kind of DatasetGraph: " + Lib.className((Object)dataset));
        }

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        public Plan create(Query query, DatasetGraph dataset, Binding input, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(query, this.dsgToQuery(dataset), input, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(op, this.dsgToQuery(dataset), binding, context);
            return engine.getPlan();
        }
    }
}

