/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpExtBuilder;
import com.hp.hpl.jena.sparql.algebra.OpExtRegistry;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.util.FileManager;
import org.apache.jena.atlas.io.IndentedWriter;

public class OpFetch
extends OpExt {
    private static final String TagFetch = "fetch";
    private static boolean enabled = false;
    private Node node;

    public static void enable() {
        if (enabled) {
            return;
        }
        enabled = true;
        OpExtRegistry.register(new OpExtBuilder(){

            @Override
            public OpExt make(ItemList argList) {
                return new OpFetch(argList.get(0).getNode());
            }

            @Override
            public String getTagName() {
                return OpFetch.TagFetch;
            }
        });
    }

    public OpFetch(Node node) {
        super(TagFetch);
        this.node = node;
    }

    @Override
    public Op effectiveOp() {
        return OpTable.unit();
    }

    @Override
    public QueryIterator eval(QueryIterator input, ExecutionContext execCxt) {
        return new QueryIterFetch(input, execCxt);
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpFetch)) {
            return false;
        }
        return this.node.equals((Object)((OpFetch)other).node);
    }

    @Override
    public void outputArgs(IndentedWriter out, SerializationContext sCxt) {
        out.print(FmtUtils.stringForNode(this.node, sCxt));
    }

    @Override
    public int hashCode() {
        return TagFetch.hashCode() ^ this.node.hashCode();
    }

    class QueryIterFetch
    extends QueryIterRepeatApply {
        public QueryIterFetch(QueryIterator input, ExecutionContext context) {
            super(input, context);
        }

        @Override
        protected QueryIterator nextStage(Binding binding) {
            DatasetGraph ds = super.getExecContext().getDataset();
            Node n = Substitute.substitute(OpFetch.this.node, binding);
            String uri = n.getURI();
            if (ds.containsGraph(n)) {
                return IterLib.result(binding, this.getExecContext());
            }
            Model m = FileManager.get().loadModel(uri);
            Graph g = m.getGraph();
            ds.addGraph(n, g);
            return IterLib.result(binding, this.getExecContext());
        }
    }
}

