/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.model;

import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.model.Severity;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Collection;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class Lint {
    private LintPattern m_LintPattern;
    private LintFixer m_LintFixer;
    private Severity m_Severity;
    private Set<OWLClass> m_ParticipatingClasses;
    private Set<OWLClassAxiom> m_ParticipatingAxioms;
    private OWLOntology m_ParticipatingOntology;

    public Lint(LintPattern lintPattern, OWLOntology oWLOntology) {
        this.m_LintPattern = lintPattern;
        this.m_ParticipatingOntology = oWLOntology;
        this.m_ParticipatingClasses = CollectionUtil.makeSet();
        this.m_ParticipatingAxioms = CollectionUtil.makeSet();
    }

    public LintPattern getPattern() {
        return this.m_LintPattern;
    }

    public void setLintFixer(LintFixer lintFixer) {
        this.m_LintFixer = lintFixer;
    }

    public LintFixer getLintFixer() {
        return this.m_LintFixer;
    }

    public void setSeverity(Severity severity) {
        this.m_Severity = severity;
    }

    public Severity getSeverity() {
        return this.m_Severity;
    }

    public void addParticipatingClass(OWLClass oWLClass) {
        this.m_ParticipatingClasses.add(oWLClass);
    }

    public void addAllParticipatingClasses(Collection<? extends OWLClass> collection) {
        this.m_ParticipatingClasses.addAll(collection);
    }

    public Set<OWLClass> getParticipatingClasses() {
        return this.m_ParticipatingClasses;
    }

    public void addParticipatingAxiom(OWLClassAxiom oWLClassAxiom) {
        this.m_ParticipatingAxioms.add(oWLClassAxiom);
    }

    public void addAllParticipatingAxioms(Collection<? extends OWLClassAxiom> collection) {
        this.m_ParticipatingAxioms.addAll(collection);
    }

    public Set<OWLClassAxiom> getParticipatingAxioms() {
        return this.m_ParticipatingAxioms;
    }

    public OWLOntology getParticipatingOntology() {
        return this.m_ParticipatingOntology;
    }

    public boolean applyFix(OWLOntologyManager oWLOntologyManager) throws OWLOntologyChangeException {
        return this.m_LintFixer != null && this.m_LintFixer.apply(oWLOntologyManager, this.m_ParticipatingOntology);
    }

    public String toString() {
        return new SimpleLintFormat().format(this);
    }
}

