/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.MediaType;

public class MediaRange
extends MediaType {
    private double q = 1.0;

    public MediaRange(MediaRange other) {
        super(other);
        this.q = other.q;
    }

    public MediaRange(MediaType other) {
        super(other);
        this.set_q();
    }

    public MediaRange(String string) {
        super(MediaType.parse(string));
        this.set_q();
    }

    public MediaRange(String type, String subType, String charset) {
        super(type, subType, charset);
        this.set_q();
    }

    public double get_q() {
        return this.q;
    }

    private void set_q() {
        String qStr = this.getParameter("q");
        if (qStr == null) {
            return;
        }
        try {
            this.q = Double.parseDouble(qStr);
        }
        catch (NumberFormatException ex) {
            Log.warn(this, "Bad q seen: " + qStr);
        }
    }

    public boolean accepts(MediaType item) {
        if (!this.accept(this.getType(), item.getType())) {
            return false;
        }
        return this.accept(this.getSubType(), item.getSubType());
    }

    private boolean accept(String a, String b) {
        if (a == null || b == null) {
            return true;
        }
        if (a.equals("*") || b.equals("*")) {
            return true;
        }
        return a.equals(b);
    }

    public boolean moreGroundedThan(MediaType item) {
        if (this.isStar(item.getType()) && !this.isStar(this.getType())) {
            return true;
        }
        return this.isStar(item.getSubType()) && !this.isStar(this.getSubType());
    }

    private boolean isStar(String x) {
        return x == null || x.equals("*");
    }
}

