/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.POTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.SubsumptionComparator;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletTransTree
extends PelletCmdApp {
    private String propertyName;
    private boolean showClasses;
    private boolean showIndividuals;
    public Taxonomy<ATermAppl> publicTaxonomy;

    @Override
    public String getAppId() {
        return "PelletTransTree: Compute a transitive-tree closure";
    }

    @Override
    public String getAppCmd() {
        return "pellet trans-tree " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        this.showClasses = true;
        this.showIndividuals = false;
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("property");
        pelletCmdOption.setShortOption("p");
        pelletCmdOption.setType("<URI>");
        pelletCmdOption.setDescription("The part-of (transitive) property");
        pelletCmdOption.setIsMandatory(true);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("classes");
        pelletCmdOption.setShortOption("c");
        pelletCmdOption.setDescription("Show parts hierarchy for classes");
        pelletCmdOption.setDefaultValue(this.showClasses);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("individuals");
        pelletCmdOption.setShortOption("i");
        pelletCmdOption.setDescription("Show parts hierarchy for individuals");
        pelletCmdOption.setDefaultValue(this.showIndividuals);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("filter");
        pelletCmdOption.setShortOption("f");
        pelletCmdOption.setType("<URI>");
        pelletCmdOption.setDescription("The class to filter");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        Object object2;
        Object object3;
        this.propertyName = this.options.getOption("property").getValueAsString();
        OWLAPILoader oWLAPILoader = new OWLAPILoader();
        KnowledgeBase knowledgeBase = oWLAPILoader.createKB(this.getInputFiles());
        OWLEntity oWLEntity = OntologyUtils.findEntity(this.propertyName, oWLAPILoader.getAllOntologies());
        if (oWLEntity == null) {
            throw new PelletCmdException("Property not found: " + this.propertyName);
        }
        if (!(oWLEntity instanceof OWLObjectProperty)) {
            throw new PelletCmdException("Not an object property: " + this.propertyName);
        }
        if (!((OWLObjectProperty)oWLEntity).isTransitive(oWLAPILoader.getAllOntologies())) {
            throw new PelletCmdException("Not a transitive property: " + this.propertyName);
        }
        ATermAppl aTermAppl = ATermUtils.makeTermAppl(oWLEntity.getIRI().toString());
        ATermAppl aTermAppl2 = null;
        boolean bl = false;
        if (this.options.getOption("filter").exists()) {
            object3 = this.options.getOption("filter").getValueAsString();
            object2 = OntologyUtils.findEntity((String)object3, oWLAPILoader.getAllOntologies());
            if (object2 == null) {
                throw new PelletCmdException("Filter class not found: " + (String)object3);
            }
            if (!(object2 instanceof OWLClass)) {
                throw new PelletCmdException("Not a class: " + (String)object3);
            }
            aTermAppl2 = ATermUtils.makeTermAppl(object2.getIRI().toString());
            bl = true;
        }
        object3 = null;
        if (this.options.getOption("individuals").getValueAsBoolean()) {
            object3 = new POTaxonomyBuilder(knowledgeBase, new PartIndividualsComparator(knowledgeBase, aTermAppl));
            object2 = bl ? knowledgeBase.getInstances(aTermAppl2) : knowledgeBase.getIndividuals();
            Iterator object4 = object2.iterator();
            while (object4.hasNext()) {
                ATermAppl aTermAppl3 = (ATermAppl)object4.next();
                if (ATermUtils.isBnode(aTermAppl3)) continue;
                ((POTaxonomyBuilder)object3).classify(aTermAppl3);
            }
        } else {
            object3 = new POTaxonomyBuilder(knowledgeBase, new PartClassesComparator(knowledgeBase, aTermAppl));
            if (bl) {
                for (ATermAppl aTermAppl4 : this.getDistinctSubclasses(knowledgeBase, aTermAppl2)) {
                    ((POTaxonomyBuilder)object3).classify(aTermAppl4);
                }
            } else {
                ((POTaxonomyBuilder)object3).classify();
            }
        }
        object2 = ((POTaxonomyBuilder)object3).getTaxonomy();
        ClassTreePrinter classTreePrinter = new ClassTreePrinter();
        classTreePrinter.print(object2);
        this.publicTaxonomy = object2;
    }

    private Set<ATermAppl> getDistinctSubclasses(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        Set<Set<ATermAppl>> set = knowledgeBase.getSubClasses(aTermAppl);
        for (Set<ATermAppl> set2 : set) {
            hashSet.addAll(set2);
        }
        hashSet.add(aTermAppl);
        hashSet.remove(ATermUtils.negate(ATermUtils.TOP));
        return hashSet;
    }

    private static class PartIndividualsComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartIndividualsComparator(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
            super(knowledgeBase);
            this.p = aTermAppl;
        }

        @Override
        protected boolean isSubsumedBy(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
            return this.kb.hasPropertyValue(aTermAppl, this.p, aTermAppl2);
        }
    }

    private static class PartClassesComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartClassesComparator(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
            super(knowledgeBase);
            this.p = aTermAppl;
        }

        @Override
        protected boolean isSubsumedBy(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
            ATermAppl aTermAppl3 = ATermUtils.makeSomeValues((ATerm)this.p, (ATerm)aTermAppl2);
            return this.kb.isSubClassOf(aTermAppl, aTermAppl3);
        }
    }
}

