/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.shared.NoReaderForLangException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import pellet.Pellet;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public abstract class PelletCmdApp {
    public static final Logger logger = Logger.getLogger(PelletCmdApp.class.getName());
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private static final RDFReaderF READER_FACTORY = ModelFactory.createDefaultModel();
    protected String appId;
    protected String appCmd;
    protected String help;
    protected PelletCmdOptions options = this.getOptions();
    private List<String> inputFiles;
    protected KBLoader loader;
    protected boolean verbose;
    protected Timers timers;
    protected List<String> tasks;

    public PelletCmdApp() {
        this.appId = this.getAppId();
        this.appCmd = this.getAppCmd();
        this.inputFiles = new ArrayList<String>();
        this.timers = new Timers();
        this.buildHelp();
    }

    public boolean requiresInputFiles() {
        return true;
    }

    protected void verbose(String string) {
        if (this.verbose) {
            System.err.println(string);
        }
    }

    protected void output(String string) {
        System.out.println(string);
    }

    protected void output(Model model) {
        model.write((OutputStream)System.out);
    }

    public abstract String getAppId();

    public abstract String getAppCmd();

    public abstract PelletCmdOptions getOptions();

    public abstract void run();

    public void finish() {
        if (this.verbose) {
            StringWriter stringWriter = new StringWriter();
            this.timers.print(stringWriter, true, null);
            this.verbose("");
            this.verbose("Timer summary:");
            this.verbose(stringWriter.toString());
        }
    }

    protected String getMandatoryOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        Set<PelletCmdOption> set = this.options.getMandatoryOptions();
        for (PelletCmdOption pelletCmdOption : set) {
            stringBuffer.append("-" + pelletCmdOption.getShortOption() + " arg ");
        }
        return stringBuffer.toString();
    }

    public PelletCmdOption getInferPropValuesOption() {
        PelletCmdOption pelletCmdOption = new PelletCmdOption("infer-prop-values");
        pelletCmdOption.setDescription("Infer property values");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        return pelletCmdOption;
    }

    public PelletCmdOption getInferDataPropValuesOption() {
        PelletCmdOption pelletCmdOption = new PelletCmdOption("infer-data-prop-values");
        pelletCmdOption.setDescription("Infer data property values");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        return pelletCmdOption;
    }

    public PelletCmdOption getIgnoreImportsOption() {
        PelletCmdOption pelletCmdOption = new PelletCmdOption("ignore-imports");
        pelletCmdOption.setDescription("Ignore imported ontologies");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        return pelletCmdOption;
    }

    public PelletCmdOption getLoaderOption() {
        PelletCmdOption pelletCmdOption = new PelletCmdOption("loader");
        pelletCmdOption.setShortOption("l");
        pelletCmdOption.setDescription("Use Jena, OWLAPI, OWLAPIv3 or KRSS to load the ontology");
        pelletCmdOption.setType("Jena | OWLAPI | OWLAPIv3 | KRSS");
        pelletCmdOption.setDefaultValue("OWLAPIv3");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        return pelletCmdOption;
    }

    public PelletCmdOptions getGlobalOptions() {
        PelletCmdOptions pelletCmdOptions = new PelletCmdOptions();
        PelletCmdOption pelletCmdOption = new PelletCmdOption("help");
        pelletCmdOption.setShortOption("h");
        pelletCmdOption.setDescription("Print this message");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        PelletCmdOption pelletCmdOption2 = new PelletCmdOption("verbose");
        pelletCmdOption2.setShortOption("v");
        pelletCmdOption2.setDescription("Print full stack trace for errors.");
        pelletCmdOption2.setDefaultValue(false);
        pelletCmdOption2.setIsMandatory(false);
        pelletCmdOption2.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption2);
        PelletCmdOption pelletCmdOption3 = new PelletCmdOption("config");
        pelletCmdOption3.setShortOption("C");
        pelletCmdOption3.setDescription("Use the selected configuration file");
        pelletCmdOption3.setIsMandatory(false);
        pelletCmdOption3.setType("configuration file");
        pelletCmdOption3.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption3);
        return pelletCmdOptions;
    }

    public PelletCmdOption getInputFormatOption() {
        PelletCmdOption pelletCmdOption = new PelletCmdOption("input-format");
        pelletCmdOption.setDefaultValue(null);
        pelletCmdOption.setDescription("Format of the input file (valid only for the Jena loader). Default behaviour is to guess the input format based on the file extension.");
        pelletCmdOption.setType("RDF/XML | Turtle | N-Triples");
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        return pelletCmdOption;
    }

    protected KnowledgeBase getKB() {
        return this.getKB(this.getLoader());
    }

    protected KnowledgeBase getKB(KBLoader kBLoader) {
        try {
            String[] stringArray = this.getInputFiles();
            this.verbose("There are " + stringArray.length + " input files:");
            for (String string : stringArray) {
                this.verbose(string);
            }
            this.startTask("loading");
            KnowledgeBase knowledgeBase = kBLoader.createKB(stringArray);
            this.finishTask("loading");
            if (this.verbose) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Classes = " + knowledgeBase.getAllClasses().size() + ", ");
                stringBuilder.append("Properties = " + knowledgeBase.getProperties().size() + ", ");
                stringBuilder.append("Individuals = " + knowledgeBase.getIndividuals().size());
                this.verbose("Input size: " + stringBuilder);
                this.verbose("Expressivity: " + knowledgeBase.getExpressivity());
            }
            return knowledgeBase;
        }
        catch (RuntimeException runtimeException) {
            throw new PelletCmdException(runtimeException);
        }
    }

    protected KBLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        String string = this.options.getOption("loader").getValueAsString();
        return this.getLoader(string);
    }

    protected KBLoader getLoader(String string) {
        if (string.equalsIgnoreCase("Jena")) {
            this.loader = new JenaLoader();
        } else if (string.equalsIgnoreCase("OWLAPIv3") || string.equalsIgnoreCase("OWLAPI")) {
            this.loader = new OWLAPILoader();
        } else if (string.equalsIgnoreCase("KRSS")) {
            this.loader = new KRSSLoader();
        } else {
            throw new PelletCmdException("Unknown loader: " + string);
        }
        this.loader.setIgnoreImports(this.options.getOption("ignore-imports").getValueAsBoolean());
        PelletCmdOption pelletCmdOption = this.options.getOption("input-format");
        if (pelletCmdOption != null && pelletCmdOption.getValueAsString() != null && this.loader instanceof JenaLoader) {
            String string2 = pelletCmdOption.getValueAsString().toUpperCase();
            try {
                if (string2 != null) {
                    READER_FACTORY.getReader(string2.toUpperCase());
                    ((JenaLoader)this.loader).setInputFormat(string2);
                }
            }
            catch (NoReaderForLangException noReaderForLangException) {
                throw new PelletCmdException("Unrecognized input format: " + string2);
            }
        }
        return this.loader;
    }

    protected String[] getInputFiles() {
        return this.inputFiles.toArray(new String[0]);
    }

    private void buildHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        HelpTable helpTable = new HelpTable(this.options);
        stringBuffer.append(this.appId + LINE_BREAK + LINE_BREAK);
        stringBuffer.append("Usage: " + this.appCmd + LINE_BREAK + LINE_BREAK);
        stringBuffer.append(helpTable.print() + LINE_BREAK);
        this.help = stringBuffer.toString();
    }

    public void parseArgs(String[] stringArray) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        block5: for (n = 1; n < stringArray.length; ++n) {
            Object object = stringArray[n];
            if (((String)object).equals("--")) {
                return;
            }
            if (((String)object).charAt(0) != '-') break;
            PelletCmdOption pelletCmdOption = this.options.getOption((String)(object = ((String)object).charAt(1) == '-' ? ((String)object).substring(2) : ((String)object).substring(1)));
            if (pelletCmdOption == null) {
                throw new PelletCmdException("Unrecognized option: " + (String)object);
            }
            if (pelletCmdOption.getLongOption().equals("help")) {
                this.help();
            } else if (pelletCmdOption.getLongOption().equals("verbose")) {
                Pellet.exceptionFormatter.setVerbose(true);
            }
            if (hashSet.contains(pelletCmdOption.getLongOption())) {
                throw new PelletCmdException("Repeated use of option: " + (String)object);
            }
            hashSet.add(pelletCmdOption.getLongOption());
            PelletCmdOptionArg pelletCmdOptionArg = pelletCmdOption.getArg();
            boolean bl = stringArray.length > n + 1 && stringArray[n + 1].charAt(0) != '-';
            switch (pelletCmdOptionArg) {
                case NONE: {
                    pelletCmdOption.setValue(true);
                    continue block5;
                }
                case REQUIRED: {
                    if (!bl) {
                        throw new PelletCmdException("Option <" + pelletCmdOption.getLongOption() + "> requires an argument");
                    }
                    pelletCmdOption.setValue(stringArray[++n]);
                    continue block5;
                }
                case OPTIONAL: {
                    if (bl) {
                        pelletCmdOption.setValue(stringArray[++n]);
                        continue block5;
                    }
                    pelletCmdOption.setExists(true);
                    continue block5;
                }
                default: {
                    throw new PelletCmdException("Unrecognized option argument: " + (Object)((Object)pelletCmdOptionArg));
                }
            }
        }
        for (PelletCmdOption pelletCmdOption : this.options.getOptions()) {
            if (!pelletCmdOption.isMandatory() || pelletCmdOption.getValue() != null) continue;
            throw new PelletCmdException("Option <" + pelletCmdOption.getLongOption() + "> is mandatory");
        }
        this.loadConfig();
        while (n < stringArray.length) {
            this.inputFiles.add(stringArray[n]);
            ++n;
        }
        if (this.options.getOption("verbose").getValueAsBoolean()) {
            this.verbose = true;
        }
        if (this.requiresInputFiles()) {
            if (this.inputFiles.isEmpty()) {
                throw new PelletCmdException("No input file given");
            }
        } else if (!this.inputFiles.isEmpty()) {
            throw new PelletCmdException("Unexpected argument(s): " + this.inputFiles);
        }
    }

    private void loadConfig() {
        String string = this.options.getOption("config").getValueAsString();
        if (string != null) {
            try {
                URL uRL = new URL("file:" + string);
                PelletOptions.load(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new PelletCmdException("Invalid URL given for the config file: " + string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PelletCmdException("The specified configuration file cannot be found: " + string);
            }
            catch (IOException iOException) {
                throw new PelletCmdException("I/O error while reading the configuration file: " + iOException.toString());
            }
        }
    }

    public void help() {
        this.output(this.help);
        System.exit(0);
    }

    protected void startTask(String string) {
        this.verbose("Start " + string);
        this.timers.startTimer(string);
    }

    protected void finishTask(String string) {
        Timer timer = this.timers.getTimer(string);
        timer.stop();
        this.verbose("Finished " + string + " in " + timer.format());
    }

    private static class HelpTable {
        private final String LINE_BREAK = System.getProperty("line.separator");
        private PelletCmdOptions options;
        private int maxLineWidth = 80;
        private int indent = 5;

        public HelpTable(PelletCmdOptions pelletCmdOptions) {
            this.options = pelletCmdOptions;
        }

        public String print() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Argument description:" + this.LINE_BREAK + this.LINE_BREAK);
            int n = 0;
            boolean bl = false;
            for (PelletCmdOption pelletCmdOption : this.options.getOptions()) {
                if (++n == this.options.getOptions().size()) {
                    bl = true;
                }
                String string = pelletCmdOption.getLongOption();
                String string2 = pelletCmdOption.getShortOption();
                String string3 = pelletCmdOption.getType();
                PelletCmdOptionArg pelletCmdOptionArg = pelletCmdOption.getArg();
                String string4 = pelletCmdOption.getDescription();
                String string5 = "";
                if (pelletCmdOption.getDefaultValue() != null) {
                    string5 = pelletCmdOption.getDefaultValue().toString();
                }
                String string6 = this.firstLine(string2, string, string3, pelletCmdOptionArg);
                String string7 = this.secondLine(string4, string5);
                stringBuffer.append(string6);
                stringBuffer.append(this.LINE_BREAK);
                stringBuffer.append(string7);
                if (bl) continue;
                stringBuffer.append(this.LINE_BREAK + this.LINE_BREAK);
            }
            return stringBuffer.toString();
        }

        private String fill(int n) {
            return this.draw(" ", n);
        }

        private String draw(String string, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        private String firstLine(String string, String string2, String string3, PelletCmdOptionArg pelletCmdOptionArg) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("--" + string2);
            if (string != null) {
                stringBuffer.append(", -" + string);
            }
            stringBuffer.append(" ");
            if (string3 != null) {
                if (pelletCmdOptionArg.equals((Object)PelletCmdOptionArg.OPTIONAL) && !string3.startsWith("[") && !string3.startsWith("(")) {
                    stringBuffer.append("[" + string3 + "] ");
                } else if (pelletCmdOptionArg.equals((Object)PelletCmdOptionArg.REQUIRED) && !string3.startsWith("[") && !string3.startsWith("(")) {
                    stringBuffer.append("(" + string3 + ") ");
                }
            }
            return stringBuffer.toString();
        }

        private String secondLine(String string, String string2) {
            int n;
            int n2 = n = this.indent;
            StringBuffer stringBuffer = new StringBuffer();
            if (string == null && string2 == null) {
                return stringBuffer.toString();
            }
            String string3 = string2 != null && string2.length() != 0 && !string2.equals("true") && !string2.equals("false") ? string + " (Default: " + string2 + ")" : string;
            stringBuffer.append(this.fill(n));
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if ((n2 = n2 + string4.length() + 1) > this.maxLineWidth) {
                    stringBuffer.append(this.LINE_BREAK + this.fill(n));
                    n2 = n + string4.length() + 1;
                }
                stringBuffer.append(string4 + " ");
            }
            return stringBuffer.toString();
        }
    }
}

