/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.math.BigInteger;

public class PermutationGenerator {
    private int[] a;
    private BigInteger numLeft;
    private BigInteger total;

    public PermutationGenerator(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Min 1");
        }
        this.a = new int[n];
        this.total = PermutationGenerator.getFactorial(n);
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(i)));
        }
        return bigInteger;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int n = this.a.length - 2;
        while (this.a[n] > this.a[n + 1]) {
            --n;
        }
        int n2 = this.a.length - 1;
        while (this.a[n] > this.a[n2]) {
            --n2;
        }
        int n3 = this.a[n2];
        this.a[n2] = this.a[n];
        this.a[n] = n3;
        int n4 = this.a.length - 1;
        for (int i = n + 1; n4 > i; --n4, ++i) {
            n3 = this.a[i];
            this.a[i] = this.a[n4];
            this.a[n4] = n3;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }
}

