/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.HashSet;
import java.util.Map;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.cache.CachedEdge;
import org.mindswap.pellet.tableau.cache.CachedInEdge;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.CachedOutEdge;
import org.mindswap.pellet.utils.ATermUtils;

public class CachedConceptNode
implements CachedNode {
    private ATermAppl name;
    private EdgeList inEdges;
    private EdgeList outEdges;
    private Map<ATermAppl, DependencySet> types;
    private boolean isIndependent;

    public CachedConceptNode(ATermAppl aTermAppl, Individual individual) {
        this.name = aTermAppl;
        this.isIndependent = individual.getMergeDependency(true).isIndependent();
        individual = individual.getSame();
        this.outEdges = this.copyEdgeList(individual, true);
        this.inEdges = this.copyEdgeList(individual, false);
        if (individual.getABox().getKB().getExpressivity().hasNominal()) {
            this.collectComplexPropertyValues(individual);
        }
        this.types = CollectionUtils.makeIdentityMap(individual.getDepends());
        for (Map.Entry<ATermAppl, DependencySet> entry : this.types.entrySet()) {
            entry.setValue(entry.getValue().cache());
        }
    }

    private void collectComplexPropertyValues(Individual individual) {
        Role role;
        HashSet<Role> hashSet = new HashSet<Role>();
        for (Edge edge : individual.getOutEdges()) {
            role = edge.getRole();
            if (role.isSimple() || !hashSet.add(role)) continue;
            hashSet.add(role);
            this.collectComplexPropertyValues(individual, role);
        }
        for (Edge edge : individual.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role.isSimple() || !hashSet.add(role)) continue;
            this.collectComplexPropertyValues(individual, role);
        }
    }

    private void collectComplexPropertyValues(Individual individual, Role role) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        individual.getABox().getObjectPropertyValues(individual.getName(), role, hashSet, hashSet2, false);
        for (ATermAppl aTermAppl : hashSet) {
            this.outEdges.addEdge(new CachedOutEdge(role, aTermAppl, DependencySet.INDEPENDENT));
        }
        for (ATermAppl aTermAppl : hashSet2) {
            this.outEdges.addEdge(new CachedOutEdge(role, aTermAppl, DependencySet.DUMMY));
        }
    }

    private EdgeList copyEdgeList(Individual individual, boolean bl) {
        EdgeList edgeList = bl ? individual.getOutEdges() : individual.getInEdges();
        EdgeList edgeList2 = new EdgeList(edgeList.size());
        for (Edge edge : edgeList) {
            CachedEdge cachedEdge = bl ? new CachedOutEdge(edge) : new CachedInEdge(edge);
            edgeList2.addEdge(cachedEdge);
            if (!PelletOptions.CHECK_NOMINAL_EDGES) continue;
            Node node = edge.getNeighbor(individual);
            Map<Node, DependencySet> map = node.getAllMerged();
            DependencySet dependencySet = edge.getDepends();
            for (Map.Entry<Node, DependencySet> entry : map.entrySet()) {
                Node node2 = entry.getKey();
                if (!node2.isRootNominal() || node2.equals(node)) continue;
                Role role = edge.getRole();
                ATermAppl aTermAppl = node2.getName();
                DependencySet dependencySet2 = dependencySet.union(entry.getValue(), false).cache();
                CachedEdge cachedEdge2 = bl ? new CachedOutEdge(role, aTermAppl, dependencySet2) : new CachedInEdge(role, aTermAppl, dependencySet2);
                edgeList2.addEdge(cachedEdge2);
            }
        }
        return edgeList2;
    }

    @Override
    public boolean isIndependent() {
        return this.isIndependent;
    }

    @Override
    public EdgeList getInEdges() {
        return this.inEdges;
    }

    @Override
    public EdgeList getOutEdges() {
        return this.outEdges;
    }

    @Override
    public Map<ATermAppl, DependencySet> getDepends() {
        return this.types;
    }

    @Override
    public boolean hasRNeighbor(Role role) {
        return this.outEdges.hasEdge(role) || role.isObjectRole() && this.inEdges.hasEdge(role.getInverse());
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isNamedIndividual() {
        return false;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    public String toString() {
        return ATermUtils.toString(this.name);
    }
}

