/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.model;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class LintFixer {
    private Set<? extends OWLAxiom> m_AxiomsToRemove;
    private Set<? extends OWLAxiom> m_AxiomsToAdd;

    public LintFixer(Set<? extends OWLAxiom> set, Set<? extends OWLAxiom> set2) {
        this.m_AxiomsToRemove = set;
        this.m_AxiomsToAdd = set2;
    }

    public LintFixer(OWLAxiom oWLAxiom, OWLAxiom oWLAxiom2) {
        this(Collections.singleton(oWLAxiom), Collections.singleton(oWLAxiom2));
    }

    public Set<? extends OWLAxiom> getAxiomsToRemove() {
        return this.m_AxiomsToRemove;
    }

    public Set<? extends OWLAxiom> getAxiomsToAdd() {
        return this.m_AxiomsToAdd;
    }

    public boolean apply(OWLOntologyManager oWLOntologyManager, OWLOntology oWLOntology) throws OWLOntologyChangeException {
        RemoveAxiom removeAxiom;
        Set set = oWLOntology.getAxioms();
        if (!set.containsAll(this.m_AxiomsToRemove)) {
            return false;
        }
        for (OWLAxiom oWLAxiom : this.m_AxiomsToRemove) {
            removeAxiom = new RemoveAxiom(oWLOntology, oWLAxiom);
            oWLOntologyManager.applyChange((OWLOntologyChange)removeAxiom);
        }
        for (OWLAxiom oWLAxiom : this.m_AxiomsToAdd) {
            if (set.contains(oWLAxiom)) continue;
            removeAxiom = new AddAxiom(oWLOntology, oWLAxiom);
            oWLOntologyManager.applyChange((OWLOntologyChange)removeAxiom);
        }
        return true;
    }
}

