/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SortedResultSet
implements ResultSet {
    private List<Binding> sortedRows;
    private Iterator<Binding> iterator;
    private int row;
    private List<String> resultVars;

    public SortedResultSet(ResultSet resultSet, List<SortCondition> list) {
        this.resultVars = resultSet.getResultVars();
        this.sortedRows = new ArrayList<Binding>();
        while (resultSet.hasNext()) {
            this.sortedRows.add(resultSet.nextBinding());
        }
        BindingComparator bindingComparator = new BindingComparator(list);
        Collections.sort(this.sortedRows, bindingComparator);
        this.iterator = this.sortedRows.iterator();
        this.row = 0;
    }

    public List<String> getResultVars() {
        return this.resultVars;
    }

    public int getRowNumber() {
        return this.row;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public boolean isOrdered() {
        return true;
    }

    public QuerySolution next() {
        return this.nextSolution();
    }

    public Binding nextBinding() {
        return this.iterator.next();
    }

    public QuerySolution nextSolution() {
        return new ResultBinding(null, this.nextBinding());
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.sortedRows.toString();
    }

    public Model getResourceModel() {
        return null;
    }
}

