/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class ConceptConverter
extends ATermBaseVisitor
implements ATermVisitor {
    private KnowledgeBase kb;
    private OWLDataFactory factory;
    private OWLObject obj;
    private Set set;

    public ConceptConverter(KnowledgeBase knowledgeBase, OWLDataFactory oWLDataFactory) {
        this.kb = knowledgeBase;
        this.factory = oWLDataFactory;
    }

    public OWLIndividual convertIndividual(ATermAppl aTermAppl) {
        IRI iRI = null;
        if (!ATermUtils.isBnode(aTermAppl)) {
            iRI = IRI.create((String)aTermAppl.getName());
        }
        if (this.kb.isIndividual((ATerm)aTermAppl)) {
            if (ATermUtils.isBnode(aTermAppl)) {
                return this.factory.getOWLAnonymousIndividual(((ATermAppl)aTermAppl.getArgument(0)).getName());
            }
            return this.factory.getOWLNamedIndividual(iRI);
        }
        throw new InternalReasonerException("Cannot convert individual: " + aTermAppl);
    }

    public OWLObject convert(ATermAppl aTermAppl) {
        this.obj = null;
        this.visit(aTermAppl);
        return this.obj;
    }

    public OWLObject getResult() {
        return this.obj;
    }

    @Override
    public void visitTerm(ATermAppl aTermAppl) {
        this.obj = null;
        IRI iRI = null;
        if (!ATermUtils.isBnode(aTermAppl)) {
            iRI = IRI.create((String)aTermAppl.getName());
        }
        if (aTermAppl.equals(OWL_THING)) {
            this.obj = this.factory.getOWLThing();
        } else if (aTermAppl.equals(OWL_NOTHING)) {
            this.obj = this.factory.getOWLNothing();
        } else if (this.kb.isClass((ATerm)aTermAppl)) {
            this.obj = this.factory.getOWLClass(iRI);
        } else if (this.kb.isObjectProperty((ATerm)aTermAppl)) {
            this.obj = ATermUtils.TOP_OBJECT_PROPERTY.equals(aTermAppl) ? this.factory.getOWLTopDataProperty() : (ATermUtils.BOTTOM_DATA_PROPERTY.equals(aTermAppl) ? this.factory.getOWLBottomObjectProperty() : this.factory.getOWLObjectProperty(iRI));
        } else if (this.kb.isDatatypeProperty((ATerm)aTermAppl)) {
            this.obj = ATermUtils.TOP_DATA_PROPERTY.equals(aTermAppl) ? this.factory.getOWLTopDataProperty() : (ATermUtils.BOTTOM_DATA_PROPERTY.equals(aTermAppl) ? this.factory.getOWLBottomDataProperty() : this.factory.getOWLDataProperty(iRI));
        } else if (this.kb.isIndividual((ATerm)aTermAppl)) {
            this.obj = ATermUtils.isBnode(aTermAppl) ? this.factory.getOWLAnonymousIndividual(((ATermAppl)aTermAppl.getArgument(0)).getName()) : this.factory.getOWLNamedIndividual(iRI);
        } else if (this.kb.isDatatype(aTermAppl)) {
            this.obj = this.factory.getOWLDatatype(iRI);
        }
        if (this.obj == null) {
            throw new InternalReasonerException("Ontology does not contain: " + aTermAppl);
        }
    }

    @Override
    public void visitAnd(ATermAppl aTermAppl) {
        this.visitList((ATermList)aTermAppl.getArgument(0));
        if (this.obj instanceof OWLClassExpression) {
            this.obj = this.factory.getOWLObjectIntersectionOf(this.set);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataIntersectionOf(this.set);
        }
    }

    @Override
    public void visitOr(ATermAppl aTermAppl) {
        this.visitList((ATermList)aTermAppl.getArgument(0));
        if (this.obj instanceof OWLClassExpression) {
            this.obj = this.factory.getOWLObjectUnionOf(this.set);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataUnionOf(this.set);
        }
    }

    @Override
    public void visitNot(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        if (this.obj instanceof OWLClassExpression) {
            this.obj = this.factory.getOWLObjectComplementOf((OWLClassExpression)this.obj);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataComplementOf((OWLDataRange)this.obj);
        }
    }

    @Override
    public void visitSome(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLPropertyExpression oWLPropertyExpression = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)aTermAppl.getArgument(1));
        if (oWLPropertyExpression instanceof OWLObjectPropertyExpression) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.obj;
            this.obj = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)oWLPropertyExpression, oWLClassExpression);
        } else {
            OWLDataRange oWLDataRange = (OWLDataRange)this.obj;
            this.obj = this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)((OWLDataProperty)oWLPropertyExpression), oWLDataRange);
        }
    }

    @Override
    public void visitAll(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLPropertyExpression oWLPropertyExpression = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)aTermAppl.getArgument(1));
        if (oWLPropertyExpression instanceof OWLObjectPropertyExpression) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.obj;
            this.obj = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)oWLPropertyExpression, oWLClassExpression);
        } else {
            OWLDataRange oWLDataRange = (OWLDataRange)this.obj;
            this.obj = this.factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)((OWLDataProperty)oWLPropertyExpression), oWLDataRange);
        }
    }

    @Override
    public void visitMin(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLPropertyExpression oWLPropertyExpression = (OWLPropertyExpression)this.obj;
        int n = Integer.parseInt(aTermAppl.getArgument(1).toString());
        if (oWLPropertyExpression instanceof OWLObjectPropertyExpression) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.convert((ATermAppl)aTermAppl.getArgument(2));
            this.obj = this.factory.getOWLObjectMinCardinality(n, (OWLObjectPropertyExpression)oWLPropertyExpression, oWLClassExpression);
        } else {
            OWLDataRange oWLDataRange = (OWLDataRange)this.convert((ATermAppl)aTermAppl.getArgument(2));
            this.obj = this.factory.getOWLDataMinCardinality(n, (OWLDataPropertyExpression)((OWLDataProperty)oWLPropertyExpression), oWLDataRange);
        }
    }

    @Override
    public void visitCard(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLPropertyExpression oWLPropertyExpression = (OWLPropertyExpression)this.obj;
        int n = Integer.parseInt(aTermAppl.getArgument(1).toString());
        if (oWLPropertyExpression instanceof OWLObjectPropertyExpression) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.convert((ATermAppl)aTermAppl.getArgument(2));
            this.obj = this.factory.getOWLObjectExactCardinality(n, (OWLObjectPropertyExpression)oWLPropertyExpression, oWLClassExpression);
        } else {
            OWLDataRange oWLDataRange = (OWLDataRange)this.convert((ATermAppl)aTermAppl.getArgument(2));
            this.obj = this.factory.getOWLDataExactCardinality(n, (OWLDataPropertyExpression)((OWLDataProperty)oWLPropertyExpression), oWLDataRange);
        }
    }

    @Override
    public void visitMax(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLPropertyExpression oWLPropertyExpression = (OWLPropertyExpression)this.obj;
        int n = Integer.parseInt(aTermAppl.getArgument(1).toString());
        if (oWLPropertyExpression instanceof OWLObjectPropertyExpression) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.convert((ATermAppl)aTermAppl.getArgument(2));
            this.obj = this.factory.getOWLObjectMaxCardinality(n, (OWLObjectPropertyExpression)oWLPropertyExpression, oWLClassExpression);
        } else {
            OWLDataRange oWLDataRange = (OWLDataRange)this.convert((ATermAppl)aTermAppl.getArgument(2));
            this.obj = this.factory.getOWLDataMaxCardinality(n, (OWLDataPropertyExpression)((OWLDataProperty)oWLPropertyExpression), oWLDataRange);
        }
    }

    @Override
    public void visitHasValue(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLPropertyExpression oWLPropertyExpression = (OWLPropertyExpression)this.obj;
        if (oWLPropertyExpression instanceof OWLObjectProperty) {
            OWLIndividual oWLIndividual = this.convertIndividual((ATermAppl)((ATermAppl)aTermAppl.getArgument(1)).getArgument(0));
            this.obj = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)oWLPropertyExpression, oWLIndividual);
        } else {
            this.visit((ATermAppl)((ATermAppl)aTermAppl.getArgument(1)).getArgument(0));
            OWLLiteral oWLLiteral = (OWLLiteral)this.obj;
            this.obj = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)((OWLDataProperty)oWLPropertyExpression), oWLLiteral);
        }
    }

    @Override
    public void visitValue(ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        if (ATermUtils.isLiteral(aTermAppl2)) {
            this.visitLiteral(aTermAppl2);
            this.obj = this.factory.getOWLDataOneOf(new OWLLiteral[]{(OWLLiteral)this.obj});
        } else {
            this.obj = this.factory.getOWLObjectOneOf(new OWLIndividual[]{this.convertIndividual(aTermAppl2)});
        }
    }

    @Override
    public void visitSelf(ATermAppl aTermAppl) {
        this.visit((ATermAppl)aTermAppl.getArgument(0));
        OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.factory.getOWLObjectHasSelf(oWLObjectPropertyExpression);
    }

    @Override
    public void visitOneOf(ATermAppl aTermAppl) {
        ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
        if (ATermUtils.isLiteral((ATermAppl)((ATermAppl)aTermList.getFirst()).getArgument(0))) {
            HashSet<OWLLiteral> hashSet = new HashSet<OWLLiteral>();
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                if (!ATermUtils.isLiteral((ATermAppl)aTermAppl2.getArgument(0))) {
                    throw new InternalReasonerException("Conversion error, expecting literal but found: " + aTermAppl2);
                }
                this.visitLiteral((ATermAppl)aTermAppl2.getArgument(0));
                hashSet.add((OWLLiteral)this.obj);
                aTermList = aTermList.getNext();
            }
            this.obj = this.factory.getOWLDataOneOf(hashSet);
        } else {
            HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl3 = (ATermAppl)aTermList.getFirst();
                OWLIndividual oWLIndividual = this.convertIndividual((ATermAppl)aTermAppl3.getArgument(0));
                hashSet.add(oWLIndividual);
                aTermList = aTermList.getNext();
            }
            this.obj = this.factory.getOWLObjectOneOf(hashSet);
        }
    }

    @Override
    public void visitLiteral(ATermAppl aTermAppl) {
        String string = ((ATermAppl)aTermAppl.getArgument(0)).toString();
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
        ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(2);
        if (aTermAppl3.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            this.obj = aTermAppl2.equals(ATermUtils.EMPTY) ? this.factory.getOWLStringLiteral(string) : this.factory.getOWLStringLiteral(string, aTermAppl2.toString());
        } else {
            IRI iRI = IRI.create((String)aTermAppl3.toString());
            OWLDatatype oWLDatatype = this.factory.getOWLDatatype(iRI);
            this.obj = this.factory.getOWLTypedLiteral(string, oWLDatatype);
        }
    }

    @Override
    public void visitList(ATermList aTermList) {
        this.set = null;
        HashSet<OWLObject> hashSet = new HashSet<OWLObject>();
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
            this.visit(aTermAppl);
            if (this.obj == null) {
                return;
            }
            hashSet.add(this.obj);
            aTermList = aTermList.getNext();
        }
        this.set = hashSet;
    }

    @Override
    public void visitInverse(ATermAppl aTermAppl) {
        OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)this.convert((ATermAppl)aTermAppl.getArgument(0));
        this.obj = this.factory.getOWLObjectInverseOf(oWLObjectPropertyExpression);
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl aTermAppl) {
        OWLDatatype oWLDatatype = this.factory.getOWLDatatype(IRI.create((String)((ATermAppl)aTermAppl.getArgument(0)).getName()));
        HashSet<OWLFacetRestriction> hashSet = new HashSet<OWLFacetRestriction>();
        ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
        while (!aTermList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
            String string = ((ATermAppl)aTermAppl2.getArgument(0)).getName();
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl2.getArgument(1);
            this.visitLiteral(aTermAppl3);
            hashSet.add(this.factory.getOWLFacetRestriction(OWLFacet.getFacet((IRI)IRI.create((String)string)), (OWLLiteral)this.obj));
            aTermList = aTermList.getNext();
        }
        this.obj = this.factory.getOWLDatatypeRestriction(oWLDatatype, hashSet);
    }
}

