/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.expressivity;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ProfileBasedExpressivityChecker;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class DLExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private static Set<ATermAppl> TOP_SET = SetUtils.singleton(ATermUtils.TOP);
    private Visitor m_Visitor = new Visitor();
    private Expressivity m_Expressivity;

    public DLExpressivityChecker(KnowledgeBase knowledgeBase) {
        super(knowledgeBase);
    }

    @Override
    public boolean compute(Expressivity expressivity) {
        this.m_Expressivity = expressivity;
        this.processIndividuals();
        this.processClasses();
        this.processRoles();
        return true;
    }

    @Override
    public boolean updateWith(Expressivity expressivity, ATermAppl aTermAppl) {
        this.m_Expressivity = expressivity;
        this.m_Visitor.visit(aTermAppl);
        return true;
    }

    private void processIndividuals() {
        if (!this.m_KB.getABox().isEmpty()) {
            this.m_Expressivity.setHasIndividual(true);
        }
        IndividualIterator individualIterator = this.m_KB.getABox().getIndIterator();
        while (individualIterator.hasNext()) {
            Individual individual = (Individual)individualIterator.next();
            ATermAppl aTermAppl = ATermUtils.makeValue((ATerm)individual.getName());
            for (ATermAppl aTermAppl2 : individual.getTypes()) {
                if (aTermAppl2.equals(aTermAppl)) continue;
                this.m_Visitor.visit(aTermAppl2);
            }
        }
    }

    private void processClasses() {
        TBox tBox = this.m_KB.getTBox();
        for (ATermAppl aTermAppl : this.m_KB.getAllClasses()) {
            Iterator<Unfolding> iterator = tBox.unfold(aTermAppl);
            while (iterator.hasNext()) {
                Unfolding unfolding = iterator.next();
                this.m_Visitor.visit(unfolding.getResult());
            }
        }
    }

    private void processRoles() {
        for (Role role : this.m_KB.getRBox().getRoles()) {
            ATermAppl aTermAppl;
            Object object;
            Object object2;
            if (role.isBuiltin()) continue;
            if (role.isDatatypeRole()) {
                this.m_Expressivity.setHasDatatype(true);
                if (role.isInverseFunctional()) {
                    this.m_Expressivity.setHasKeys(true);
                }
            }
            if (role.isAnon()) {
                object2 = role.getSubRoles().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((Role)object).isAnon() || ((Role)object).isBottom()) continue;
                    this.m_Expressivity.setHasInverse(true);
                }
            }
            if (role.isAnon() && role.isFunctional()) {
                this.m_Expressivity.setHasInverse(true);
            }
            if (role.isFunctional()) {
                if (role.isDatatypeRole()) {
                    this.m_Expressivity.setHasFunctionalityD(true);
                } else if (role.isObjectRole()) {
                    this.m_Expressivity.setHasFunctionality(true);
                }
            }
            if (role.isTransitive()) {
                this.m_Expressivity.setHasTransitivity(true);
            }
            if (role.isReflexive()) {
                this.m_Expressivity.setHasReflexivity(true);
            }
            if (role.isIrreflexive()) {
                this.m_Expressivity.setHasIrreflexivity(true);
            }
            if (role.isAsymmetric()) {
                this.m_Expressivity.setHasAsymmetry(true);
            }
            if (!role.getDisjointRoles().isEmpty()) {
                this.m_Expressivity.setHasDisjointRoles(true);
            }
            if (role.hasComplexSubRole()) {
                this.m_Expressivity.setHasComplexSubRoles(true);
            }
            if (role.getSubRoles().size() > 1) {
                this.m_Expressivity.setHasRoleHierarchy(true);
            }
            if (!(object2 = role.getDomains()).isEmpty() && !object2.equals(TOP_SET)) {
                this.m_Expressivity.setHasDomain(true);
                object = object2.iterator();
                while (object.hasNext()) {
                    aTermAppl = (ATermAppl)object.next();
                    this.m_Visitor.visit(aTermAppl);
                }
            }
            if ((object = role.getRanges()).isEmpty() || object.equals(TOP_SET)) continue;
            this.m_Expressivity.setHasRange(true);
            aTermAppl = object.iterator();
            while (aTermAppl.hasNext()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.next();
                this.m_Visitor.visit(aTermAppl2);
            }
        }
    }

    class Visitor
    extends ATermBaseVisitor {
        Visitor() {
        }

        @Override
        public void visitTerm(ATermAppl aTermAppl) {
        }

        void visitRole(ATermAppl aTermAppl) {
            if (!ATermUtils.isPrimitive(aTermAppl)) {
                DLExpressivityChecker.this.m_Expressivity.setHasInverse(true);
                DLExpressivityChecker.this.m_Expressivity.addAnonInverse((ATermAppl)aTermAppl.getArgument(0));
            }
        }

        @Override
        public void visitAnd(ATermAppl aTermAppl) {
            this.visitList((ATermList)aTermAppl.getArgument(0));
        }

        @Override
        public void visitOr(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasNegation(true);
            this.visitList((ATermList)aTermAppl.getArgument(0));
        }

        @Override
        public void visitNot(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasNegation(true);
            this.visit((ATermAppl)aTermAppl.getArgument(0));
        }

        @Override
        public void visitSome(ATermAppl aTermAppl) {
            this.visitRole((ATermAppl)aTermAppl.getArgument(0));
            this.visit((ATermAppl)aTermAppl.getArgument(1));
        }

        @Override
        public void visitAll(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasAllValues(true);
            this.visitRole((ATermAppl)aTermAppl.getArgument(0));
            this.visit((ATermAppl)aTermAppl.getArgument(1));
        }

        @Override
        public void visitCard(ATermAppl aTermAppl) {
            this.visitMin(aTermAppl);
            this.visitMax(aTermAppl);
        }

        @Override
        public void visitMin(ATermAppl aTermAppl) {
            this.visitRole((ATermAppl)aTermAppl.getArgument(0));
            Role role = DLExpressivityChecker.this.m_KB.getRole(aTermAppl.getArgument(0));
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
            if (!ATermUtils.isTop(aTermAppl2)) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityQ(true);
                }
            } else if (role.isDatatypeRole()) {
                DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
            } else {
                DLExpressivityChecker.this.m_Expressivity.setHasCardinality(true);
            }
        }

        @Override
        public void visitMax(ATermAppl aTermAppl) {
            this.visitRole((ATermAppl)aTermAppl.getArgument(0));
            Role role = DLExpressivityChecker.this.m_KB.getRole(aTermAppl.getArgument(0));
            int n = ((ATermInt)aTermAppl.getArgument(1)).getInt();
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2);
            if (!ATermUtils.isTop(aTermAppl2)) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityQ(true);
                }
            } else if (n > 1) {
                if (role.isDatatypeRole()) {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinalityD(true);
                } else {
                    DLExpressivityChecker.this.m_Expressivity.setHasCardinality(true);
                }
            }
        }

        @Override
        public void visitHasValue(ATermAppl aTermAppl) {
            this.visitRole((ATermAppl)aTermAppl.getArgument(0));
            this.visitValue((ATermAppl)aTermAppl.getArgument(1));
        }

        @Override
        public void visitValue(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            if (!ATermUtils.isLiteral(aTermAppl2)) {
                DLExpressivityChecker.this.m_Expressivity.addNominal(aTermAppl2);
            } else {
                DLExpressivityChecker.this.m_Expressivity.setHasUserDefinedDatatype(true);
            }
        }

        @Override
        public void visitOneOf(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasNegation(true);
            this.visitList((ATermList)aTermAppl.getArgument(0));
        }

        @Override
        public void visitLiteral(ATermAppl aTermAppl) {
        }

        @Override
        public void visitSelf(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasReflexivity(true);
            DLExpressivityChecker.this.m_Expressivity.setHasIrreflexivity(true);
        }

        public void visitSubClass(ATermAppl aTermAppl) {
            throw new InternalReasonerException("This function should never be called: " + aTermAppl);
        }

        @Override
        public void visitInverse(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasInverse(true);
        }

        @Override
        public void visitRestrictedDatatype(ATermAppl aTermAppl) {
            DLExpressivityChecker.this.m_Expressivity.setHasDatatype(true);
            DLExpressivityChecker.this.m_Expressivity.setHasUserDefinedDatatype(true);
        }
    }
}

