/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.IEEEDoubleType;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedFloatingPointDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDDouble
implements Datatype<Double> {
    private static final XSDDouble instance;
    private static final Logger log;
    private final RestrictedFloatingPointDatatype<Double> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double");

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedFloatingPointDatatype<Double>(this, IEEEDoubleType.getInstance());
    }

    @Override
    public RestrictedDatatype<Double> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            Double d = DatatypeConverter.parseDouble(string);
            String string2 = DatatypeConverter.printDouble(d);
            if (string2.equals(string)) {
                return aTermAppl;
            }
            return ATermUtils.makeTypedLiteral(string2, this.name);
        }
        catch (NumberFormatException numberFormatException) {
            log.severe(String.format("Number format exception (%s) cause while parsing double %s", numberFormatException.getMessage(), string));
            throw new InvalidLiteralException(this.name, string);
        }
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (IEEEDoubleType.getInstance().isInstance(object)) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printDouble(IEEEDoubleType.getInstance().cast(object)), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            return DatatypeConverter.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.name, string);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        log = Logger.getLogger(XSDDouble.class.getCanonicalName());
        instance = new XSDDouble();
    }
}

