/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class ModelExtractor {
    public static final Filter<Triple> FILTER_NONE = new Filter<Triple>(){

        public boolean accept(Triple triple) {
            return false;
        }
    };
    private KnowledgeBase kb;
    private Filter<Triple> filter = FILTER_NONE;
    private EnumSet<StatementType> selector = StatementType.DEFAULT_STATEMENTS;

    public ModelExtractor() {
    }

    public ModelExtractor(Model model) throws ClassCastException {
        this((PelletInfGraph)model.getGraph());
    }

    public ModelExtractor(PelletInfGraph pelletInfGraph) {
        this(pelletInfGraph.getPreparedKB());
    }

    public ModelExtractor(KnowledgeBase knowledgeBase) {
        this.setKB(knowledgeBase);
    }

    private void addTriple(List<Triple> list, Node node, Node node2, Node node3) {
        Triple triple = Triple.create((Node)node, (Node)node2, (Node)node3);
        if (!this.filter.accept((Object)triple)) {
            list.add(triple);
        }
    }

    public Model extractClassModel() {
        return this.extractClassModel(ModelFactory.createDefaultModel());
    }

    public Model extractClassModel(Model model) {
        boolean bl = this.selector.contains((Object)StatementType.ALL_SUBCLASS);
        boolean bl2 = this.selector.contains((Object)StatementType.JENA_DIRECT_SUBCLASS);
        boolean bl3 = bl || bl2 || this.selector.contains((Object)StatementType.DIRECT_SUBCLASS);
        boolean bl4 = this.selector.contains((Object)StatementType.EQUIVALENT_CLASS);
        boolean bl5 = this.selector.contains((Object)StatementType.DISJOINT_CLASS);
        boolean bl6 = this.selector.contains((Object)StatementType.COMPLEMENT_CLASS);
        if (bl3 || bl4 || bl5 || bl6) {
            this.kb.classify();
        }
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        Set<ATermAppl> set = this.kb.getAllClasses();
        for (ATermAppl aTermAppl : set) {
            Iterator<Set<ATermAppl>> iterator;
            Node node;
            Set<Set<ATermAppl>> set2;
            Node node2;
            arrayList.clear();
            Node node3 = JenaUtils.makeGraphNode(aTermAppl);
            this.addTriple(arrayList, node3, RDF.type.asNode(), OWL.Class.asNode());
            if (bl3) {
                node2 = RDFS.subClassOf.asNode();
                if (bl) {
                    set2 = this.kb.getAllEquivalentClasses(aTermAppl);
                    for (ATermAppl aTermAppl2 : set2) {
                        node = JenaUtils.makeGraphNode(aTermAppl2);
                        this.addTriple(arrayList, node3, node2, node);
                    }
                }
                set2 = bl ? this.kb.getSuperClasses(aTermAppl, false) : this.kb.getSuperClasses(aTermAppl, true);
                iterator = IteratorUtils.flatten(set2.iterator());
                while (iterator.hasNext()) {
                    Node node4 = JenaUtils.makeGraphNode((ATermAppl)iterator.next());
                    this.addTriple(arrayList, node3, node2, node4);
                }
                if (bl2) {
                    node2 = ReasonerVocabulary.directSubClassOf.asNode();
                    Set<Set<ATermAppl>> set3 = bl ? this.kb.getSuperClasses(aTermAppl, true) : set2;
                    iterator = IteratorUtils.flatten(set3.iterator());
                    while (iterator.hasNext()) {
                        node = JenaUtils.makeGraphNode((ATermAppl)iterator.next());
                        this.addTriple(arrayList, node3, node2, node);
                    }
                }
            }
            if (bl4) {
                node2 = OWL.equivalentClass.asNode();
                set2 = this.kb.getAllEquivalentClasses(aTermAppl);
                for (ATermAppl aTermAppl3 : set2) {
                    node = JenaUtils.makeGraphNode(aTermAppl3);
                    this.addTriple(arrayList, node3, node2, node);
                }
            }
            if (bl5 && !(set2 = this.kb.getDisjointClasses(aTermAppl)).isEmpty()) {
                node2 = OWL.disjointWith.asNode();
                iterator = IteratorUtils.flatten(set2.iterator());
                while (iterator.hasNext()) {
                    ATermAppl aTermAppl4 = (ATermAppl)iterator.next();
                    if (!set.contains(aTermAppl4)) continue;
                    this.addTriple(arrayList, node3, node2, JenaUtils.makeGraphNode(aTermAppl4));
                }
            }
            if (bl6 && !(set2 = this.kb.getComplements(aTermAppl)).isEmpty()) {
                node2 = OWL.complementOf.asNode();
                for (ATermAppl aTermAppl5 : set2) {
                    if (!set.contains(aTermAppl5)) continue;
                    this.addTriple(arrayList, node3, node2, JenaUtils.makeGraphNode(aTermAppl5));
                }
            }
            model.getGraph().getBulkUpdateHandler().add(arrayList);
        }
        return model;
    }

    public Model extractIndividualModel() {
        return this.extractIndividualModel(ModelFactory.createDefaultModel());
    }

    public Model extractIndividualModel(Model model) {
        boolean bl = this.selector.contains((Object)StatementType.ALL_INSTANCE);
        boolean bl2 = this.selector.contains((Object)StatementType.JENA_DIRECT_INSTANCE);
        boolean bl3 = bl || bl2 || this.selector.contains((Object)StatementType.DIRECT_INSTANCE);
        boolean bl4 = this.selector.contains((Object)StatementType.SAME_AS);
        boolean bl5 = this.selector.contains((Object)StatementType.DIFFERENT_FROM);
        boolean bl6 = this.selector.contains((Object)StatementType.OBJECT_PROPERTY_VALUE);
        boolean bl7 = this.selector.contains((Object)StatementType.DATA_PROPERTY_VALUE);
        if (bl3) {
            this.kb.realize();
        }
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (ATermAppl aTermAppl : this.kb.getIndividuals()) {
            ATermAppl aTermAppl2;
            Object object;
            Node node;
            arrayList.clear();
            Node node2 = JenaUtils.makeGraphNode(aTermAppl);
            if (bl3) {
                node = RDF.type.asNode();
                Iterator<ATermAppl> iterator = this.kb.getTypes(aTermAppl, !bl);
                Iterator<ATermAppl> iterator2 = IteratorUtils.flatten(iterator.iterator());
                while (iterator2.hasNext()) {
                    object = JenaUtils.makeGraphNode(iterator2.next());
                    this.addTriple(arrayList, node2, node, (Node)object);
                }
                if (bl2) {
                    node = ReasonerVocabulary.directRDFType.asNode();
                    object = bl ? this.kb.getTypes(aTermAppl, true) : iterator;
                    Iterator iterator3 = IteratorUtils.flatten(object.iterator());
                    while (iterator3.hasNext()) {
                        aTermAppl2 = JenaUtils.makeGraphNode((ATermAppl)iterator3.next());
                        this.addTriple(arrayList, node2, node, (Node)aTermAppl2);
                    }
                }
            }
            if (bl4) {
                node = OWL.sameAs.asNode();
                this.addTriple(arrayList, node2, node, node2);
                for (ATermAppl aTermAppl3 : this.kb.getSames(aTermAppl)) {
                    this.addTriple(arrayList, node2, node, JenaUtils.makeGraphNode(aTermAppl3));
                }
            }
            if (bl5) {
                node = OWL.differentFrom.asNode();
                for (ATermAppl aTermAppl4 : this.kb.getDifferents(aTermAppl)) {
                    this.addTriple(arrayList, node2, node, JenaUtils.makeGraphNode(aTermAppl4));
                }
            }
            if (bl7 || bl6) {
                for (Role role : this.kb.getRBox().getRoles()) {
                    if (role.isAnon()) continue;
                    aTermAppl2 = role.getName();
                    if (role.isDatatypeRole()) {
                        if (!bl7) continue;
                        object = this.kb.getDataPropertyValues(aTermAppl2, aTermAppl);
                    } else {
                        if (!role.isObjectRole() || !bl6) continue;
                        object = this.kb.getObjectPropertyValues(aTermAppl2, aTermAppl);
                    }
                    if (object.isEmpty()) continue;
                    node = JenaUtils.makeGraphNode(aTermAppl2);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ATermAppl aTermAppl5 = (ATermAppl)iterator.next();
                        this.addTriple(arrayList, node2, node, JenaUtils.makeGraphNode(aTermAppl5));
                    }
                }
            }
            model.getGraph().getBulkUpdateHandler().add(arrayList);
        }
        return model;
    }

    public Model extractModel() {
        return this.extractModel(ModelFactory.createDefaultModel());
    }

    public Model extractModel(Model model) {
        this.extractClassModel(model);
        this.extractPropertyModel(model);
        this.extractIndividualModel(model);
        return model;
    }

    public Model extractPropertyModel() {
        return this.extractPropertyModel(ModelFactory.createDefaultModel());
    }

    public Model extractPropertyModel(Model model) {
        boolean bl = this.selector.contains((Object)StatementType.ALL_SUBPROPERTY);
        boolean bl2 = this.selector.contains((Object)StatementType.JENA_DIRECT_SUBPROPERTY);
        boolean bl3 = bl || bl2 || this.selector.contains((Object)StatementType.DIRECT_SUBPROPERTY);
        boolean bl4 = this.selector.contains((Object)StatementType.EQUIVALENT_PROPERTY);
        boolean bl5 = this.selector.contains((Object)StatementType.INVERSE_PROPERTY);
        boolean bl6 = this.selector.contains((Object)StatementType.DISJOINT_PROPERTY);
        this.kb.prepare();
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (Role role : this.kb.getRBox().getRoles()) {
            Object object2;
            Set<Set<ATermAppl>> set;
            arrayList.clear();
            if (role.isAnon()) continue;
            ATermAppl aTermAppl = role.getName();
            Node node = JenaUtils.makeGraphNode(aTermAppl);
            Node node2 = RDF.type.asNode();
            if (role.isDatatypeRole()) {
                this.addTriple(arrayList, node, node2, OWL.DatatypeProperty.asNode());
            } else {
                if (!role.isObjectRole()) continue;
                this.addTriple(arrayList, node, node2, OWL.ObjectProperty.asNode());
            }
            if (role.isFunctional()) {
                this.addTriple(arrayList, node, node2, OWL.FunctionalProperty.asNode());
            }
            if (role.isInverseFunctional()) {
                this.addTriple(arrayList, node, node2, OWL.InverseFunctionalProperty.asNode());
            }
            if (role.isTransitive()) {
                this.addTriple(arrayList, node, node2, OWL.TransitiveProperty.asNode());
            }
            if (role.isSymmetric()) {
                this.addTriple(arrayList, node, node2, OWL.SymmetricProperty.asNode());
            }
            if (bl4) {
                node2 = OWL.equivalentProperty.asNode();
                set = this.kb.getAllEquivalentProperties(aTermAppl).iterator();
                while (set.hasNext()) {
                    object2 = (ATermAppl)set.next();
                    Node node3 = JenaUtils.makeGraphNode((ATermAppl)object2);
                    this.addTriple(arrayList, node, node2, node3);
                    if (!bl) continue;
                    this.addTriple(arrayList, node, RDFS.subPropertyOf.asNode(), node3);
                }
            }
            if (bl5 && !(set = this.kb.getInverses((ATerm)aTermAppl)).isEmpty()) {
                node2 = OWL.inverseOf.asNode();
                for (ATermAppl aTermAppl2 : set) {
                    this.addTriple(arrayList, node, node2, JenaUtils.makeGraphNode(aTermAppl2));
                }
            }
            if (bl6 && !(set = this.kb.getDisjointProperties(aTermAppl)).isEmpty()) {
                node2 = OWL2.propertyDisjointWith.asNode();
                object2 = IteratorUtils.flatten(set.iterator());
                while (object2.hasNext()) {
                    Node node4 = JenaUtils.makeGraphNode((ATermAppl)object2.next());
                    this.addTriple(arrayList, node, node2, node4);
                }
            }
            if (bl3) {
                Node node5;
                node2 = RDFS.subPropertyOf.asNode();
                if (bl) {
                    set = this.kb.getAllEquivalentProperties(aTermAppl);
                    for (ATermAppl aTermAppl3 : set) {
                        node5 = JenaUtils.makeGraphNode(aTermAppl3);
                        this.addTriple(arrayList, node, node2, node5);
                    }
                }
                if (!(set = this.kb.getSuperProperties(aTermAppl, !bl)).isEmpty()) {
                    object2 = IteratorUtils.flatten(set.iterator());
                    while (object2.hasNext()) {
                        Node node6 = JenaUtils.makeGraphNode((ATermAppl)object2.next());
                        this.addTriple(arrayList, node, node2, node6);
                    }
                    if (bl2) {
                        node2 = ReasonerVocabulary.directSubPropertyOf.asNode();
                        Set<Set<ATermAppl>> set2 = bl ? this.kb.getSuperProperties(aTermAppl, true) : set;
                        object2 = IteratorUtils.flatten(set2.iterator());
                        while (object2.hasNext()) {
                            node5 = JenaUtils.makeGraphNode((ATermAppl)object2.next());
                            this.addTriple(arrayList, node, node2, node5);
                        }
                    }
                }
            }
            model.getGraph().getBulkUpdateHandler().add(arrayList);
        }
        return model;
    }

    public EnumSet<StatementType> getSelector() {
        return this.selector;
    }

    public void setSelector(EnumSet<StatementType> enumSet) {
        this.selector = enumSet;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public Filter<Triple> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<Triple> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null");
        }
        this.filter = filter;
    }

    public static enum StatementType {
        ALL_INSTANCE,
        ALL_SUBCLASS,
        ALL_SUBPROPERTY,
        COMPLEMENT_CLASS,
        DATA_PROPERTY_VALUE,
        DIFFERENT_FROM,
        DIRECT_INSTANCE,
        DIRECT_SUBCLASS,
        DIRECT_SUBPROPERTY,
        DISJOINT_CLASS,
        DISJOINT_PROPERTY,
        EQUIVALENT_CLASS,
        EQUIVALENT_PROPERTY,
        INVERSE_PROPERTY,
        JENA_DIRECT_INSTANCE,
        JENA_DIRECT_SUBCLASS,
        JENA_DIRECT_SUBPROPERTY,
        OBJECT_PROPERTY_VALUE,
        SAME_AS;

        public static final EnumSet<StatementType> ALL_CLASS_STATEMENTS;
        public static final EnumSet<StatementType> ALL_INDIVIDUAL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_PROPERTY_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS_INCLUDING_JENA;
        public static final EnumSet<StatementType> PROPERTY_VALUE;
        public static final EnumSet<StatementType> DEFAULT_STATEMENTS;

        static {
            ALL_CLASS_STATEMENTS = EnumSet.of(ALL_SUBCLASS, COMPLEMENT_CLASS, DIRECT_SUBCLASS, DISJOINT_CLASS, EQUIVALENT_CLASS);
            ALL_INDIVIDUAL_STATEMENTS = EnumSet.of(ALL_INSTANCE, new StatementType[]{DATA_PROPERTY_VALUE, DIFFERENT_FROM, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, SAME_AS});
            ALL_PROPERTY_STATEMENTS = EnumSet.of(ALL_SUBPROPERTY, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY, DISJOINT_PROPERTY);
            ALL_STATEMENTS = EnumSet.complementOf(EnumSet.of(JENA_DIRECT_INSTANCE, JENA_DIRECT_SUBCLASS, JENA_DIRECT_SUBPROPERTY));
            ALL_STATEMENTS_INCLUDING_JENA = EnumSet.allOf(StatementType.class);
            DEFAULT_STATEMENTS = EnumSet.of(DIRECT_SUBCLASS, new StatementType[]{EQUIVALENT_CLASS, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, DATA_PROPERTY_VALUE, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY});
            PROPERTY_VALUE = EnumSet.of(DATA_PROPERTY_VALUE, OBJECT_PROPERTY_VALUE);
        }
    }
}

