/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentityHashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable {
    private static final Object VALUE = new Object();
    private transient IdentityHashMap<T, Object> map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends T> collection) {
        this.map = new IdentityHashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public IdentityHashSet(int n) {
        this.map = new IdentityHashMap(n);
    }

    @Override
    public boolean add(T t) {
        return this.map.put(t, VALUE) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet identityHashSet = (IdentityHashSet)super.clone();
            identityHashSet.map = (IdentityHashMap)this.map.clone();
            return identityHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != VALUE;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

