/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class BindingIterator
implements Iterator<ResultBinding> {
    private final List<List<ATermAppl>> varB = new ArrayList<List<ATermAppl>>();
    private final List<ATermAppl> vars = new ArrayList<ATermAppl>();
    private int[] indices;
    private boolean more = true;

    public BindingIterator(Map<ATermAppl, Set<ATermAppl>> map) {
        this.vars.addAll(map.keySet());
        for (ATermAppl aTermAppl : this.vars) {
            Set<ATermAppl> set = map.get(aTermAppl);
            if (set.isEmpty()) {
                this.more = false;
                break;
            }
            this.varB.add(new ArrayList<ATermAppl>(set));
        }
        this.indices = new int[this.vars.size()];
    }

    private boolean incIndex(int n) {
        if (this.indices[n] + 1 >= this.varB.get(n).size()) {
            if (n == this.indices.length - 1) {
                return false;
            }
            this.indices[n] = 0;
            return this.incIndex(n + 1);
        }
        int n2 = n;
        this.indices[n2] = this.indices[n2] + 1;
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.more;
    }

    @Override
    public ResultBinding next() {
        if (!this.more) {
            return null;
        }
        ResultBindingImpl resultBindingImpl = new ResultBindingImpl();
        for (int i = 0; i < this.indices.length; ++i) {
            resultBindingImpl.setValue(this.vars.get(i), this.varB.get(i).get(this.indices[i]));
        }
        this.more = this.incIndex(0);
        return resultBindingImpl;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal from this iterator is not supported.");
    }
}

