/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class RestrictedTextDatatype
implements RestrictedDatatype<ATermAppl> {
    private static final String NCNAMESTARTCHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NCNAMECHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NCNAME = "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    private static final String NAMESTARTCHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NAMECHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NAME = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    protected static final String NMTOKEN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    protected static final String TOKEN = "([^\\s])(\\s([^\\s])|([^\\s]))*";
    protected static final String LANGUAGE = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    protected static final String NORMALIZED_STRING = "([^\\r\\n\\t])*";
    private static final Set<ATermAppl> permittedDts = new HashSet<ATermAppl>(Arrays.asList(ATermUtils.EMPTY));
    private final Set<Object> excludedValues;
    private final Set<Pattern> patterns;
    private final boolean allowLang;
    private final Datatype<ATermAppl> dt;

    public static boolean addPermittedDatatype(ATermAppl aTermAppl) {
        return permittedDts.add(aTermAppl);
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> datatype, boolean bl) {
        this(datatype, Collections.emptySet(), bl, Collections.emptySet());
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> datatype, String string) {
        this(datatype, Collections.singleton(Pattern.compile(string)), false, Collections.emptySet());
    }

    private RestrictedTextDatatype(Datatype<ATermAppl> datatype, Set<Pattern> set, boolean bl, Set<Object> set2) {
        this.dt = datatype;
        this.allowLang = bl;
        this.excludedValues = set2;
        this.patterns = set;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl aTermAppl, Object object) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof ATermAppl) {
            ATermAppl aTermAppl = (ATermAppl)object;
            if (this.excludedValues.contains(aTermAppl)) {
                return false;
            }
            if (ATermUtils.isLiteral(aTermAppl) && permittedDts.contains(aTermAppl.getArgument(2))) {
                if (!this.allowLang && !ATermUtils.EMPTY.equals(aTermAppl.getArgument(1))) {
                    return false;
                }
                if (!this.patterns.isEmpty()) {
                    String string = ((ATermAppl)aTermAppl.getArgument(0)).getName();
                    for (Pattern pattern : this.patterns) {
                        if (pattern.matcher(string).matches()) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> collection) {
        HashSet<Object> hashSet = new HashSet<Object>(collection);
        hashSet.addAll(this.excludedValues);
        return new RestrictedTextDatatype(this.dt, this.patterns, this.allowLang, hashSet);
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this.dt;
    }

    @Override
    public ATermAppl getValue(int n) {
        throw new UnsupportedOperationException();
    }

    protected <T> List<T> concatLists(List<T> list, List<T> list2) {
        if (list.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedTextDatatype) {
            RestrictedTextDatatype restrictedTextDatatype = (RestrictedTextDatatype)restrictedDatatype;
            return new RestrictedTextDatatype(this.dt, SetUtils.union(this.patterns, restrictedTextDatatype.patterns), this.allowLang && restrictedTextDatatype.allowLang, SetUtils.union(this.excludedValues, restrictedTextDatatype.excludedValues));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedTextDatatype) {
            if (!this.patterns.isEmpty() || !((RestrictedTextDatatype)restrictedDatatype).patterns.isEmpty()) {
                throw new UnsupportedOperationException();
            }
            if (this.allowLang) {
                return this;
            }
            return (RestrictedTextDatatype)restrictedDatatype;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }
}

