/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import java.io.Writer;
import java.util.ArrayList;

public class TextBlockWriter
extends BlockWriter {
    private ArrayList<Integer> blockColumns = new ArrayList();
    private int column = 0;

    public TextBlockWriter(Writer writer) {
        super(writer, " ");
    }

    @Override
    protected void startNewLine() {
        if (this.newLine) {
            this.newLine = false;
            if (!this.blockColumns.isEmpty()) {
                int n = this.blockColumns.get(this.blockColumns.size() - 1);
                this.indent(n);
                this.column = n;
            } else {
                this.column = 0;
            }
        }
    }

    @Override
    public void println() {
        super.println();
        this.column = 0;
    }

    @Override
    public void printSpace() {
        super.print(" ");
    }

    public void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.print(this.pad);
        }
    }

    @Override
    public void clearBlocks() {
        this.blockColumns.clear();
    }

    @Override
    public void startBlock() {
        this.blockColumns.add(this.column);
    }

    @Override
    public void endBlock() {
        if (this.blockColumns.isEmpty()) {
            throw new IllegalStateException("No block to end!");
        }
        this.blockColumns.remove(this.blockColumns.size() - 1);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        super.write(cArray, n, n2);
        this.column += n2;
    }

    @Override
    public void write(int n) {
        super.write(n);
        ++this.column;
    }

    @Override
    public void write(String string, int n, int n2) {
        super.write(string, n, n2);
        this.column += n2;
    }
}

