/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.incremental;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.IncrementalChangeTracker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.incremental.BranchAddDependency;
import org.mindswap.pellet.tableau.completion.incremental.ClashDependency;
import org.mindswap.pellet.tableau.completion.incremental.CloseBranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.DependencyEntry;
import org.mindswap.pellet.tableau.completion.incremental.DependencyIndex;
import org.mindswap.pellet.tableau.completion.incremental.MergeDependency;
import org.mindswap.pellet.tableau.completion.incremental.TypeDependency;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.intset.IntSet;

public class IncrementalRestore {
    private KnowledgeBase kb;

    public static void restoreDependencies(KnowledgeBase knowledgeBase) {
        IncrementalRestore incrementalRestore = new IncrementalRestore(knowledgeBase);
        incrementalRestore.restoreDependencies();
    }

    private IncrementalRestore(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    private void restoreBranchAdd(ATermAppl aTermAppl, BranchAddDependency branchAddDependency) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Removing branch add? " + branchAddDependency.getBranch());
        }
        DependencySet dependencySet = branchAddDependency.getBranch().getTermDepends();
        dependencySet.removeExplain(aTermAppl);
        if (dependencySet.getExplain().isEmpty()) {
            Object object;
            Object object2;
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removing branch!");
            }
            List<ATermAppl> list = PelletOptions.TRACK_BRANCH_EFFECTS ? this.kb.getABox().getBranchEffectTracker().getAll(branchAddDependency.getBranch().getBranch()) : this.kb.getABox().getNodeNames();
            ArrayList<IntSet> arrayList = new ArrayList<IntSet>();
            for (ATermAppl aTermAppl2 : list) {
                int n;
                Object object3;
                object2 = this.kb.getABox().getNode((ATerm)aTermAppl2);
                object = ((Node)object2).getDepends();
                for (Map.Entry<ATermAppl, DependencySet> entry : object.entrySet()) {
                    object3 = entry.getValue();
                    boolean bl = false;
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (arrayList.get(n) != ((DependencySet)object3).getDepends()) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    arrayList.add(((DependencySet)object3).getDepends());
                    if (((DependencySet)object3).getBranch() > branchAddDependency.getBranch().getBranch()) {
                        object3 = ((DependencySet)object3).copy(((DependencySet)object3).getBranch() - 1);
                    }
                    for (n = branchAddDependency.getBranch().getBranch(); n <= this.kb.getABox().getBranches().size(); ++n) {
                        if (!((DependencySet)object3).contains(n)) continue;
                        ((DependencySet)object3).remove(n);
                        ((DependencySet)object3).add(n - 1);
                    }
                    entry.setValue((DependencySet)object3);
                }
                EdgeList edgeList = ((Node)object2).getInEdges();
                Iterator<Edge> object42 = edgeList.iterator();
                while (object42.hasNext()) {
                    int n2;
                    object3 = object42.next();
                    DependencySet dependencySet2 = object3.getDepends();
                    n = 0;
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        if (arrayList.get(n2) != dependencySet2.getDepends()) continue;
                        n = 1;
                    }
                    if (n != 0) continue;
                    arrayList.add(dependencySet2.getDepends());
                    if (dependencySet2.getBranch() > branchAddDependency.getBranch().getBranch()) {
                        dependencySet2 = dependencySet2.copy(object3.getDepends().getBranch() - 1);
                    }
                    for (n2 = branchAddDependency.getBranch().getBranch(); n2 <= this.kb.getABox().getBranches().size(); ++n2) {
                        if (!dependencySet2.contains(n2)) continue;
                        dependencySet2.remove(n2);
                        dependencySet2.add(n2 - 1);
                    }
                    object3.setDepends(dependencySet2);
                }
            }
            if (PelletOptions.TRACK_BRANCH_EFFECTS) {
                this.kb.getABox().getBranchEffectTracker().remove(branchAddDependency.getBranch().getBranch() + 1);
            }
            List<Branch> list2 = this.kb.getABox().getBranches();
            for (int i = branchAddDependency.getBranch().getBranch(); i < list2.size(); ++i) {
                object2 = (Branch)list2.get(i);
                object = ((Branch)object2).getTermDepends();
                if (((DependencySet)object).getBranch() > branchAddDependency.getBranch().getBranch()) {
                    object = ((DependencySet)object).copy(((DependencySet)object).getBranch() - 1);
                }
                for (int j = branchAddDependency.getBranch().getBranch(); j < this.kb.getABox().getBranches().size(); ++j) {
                    if (!((DependencySet)object).contains(j)) continue;
                    ((DependencySet)object).remove(j);
                    ((DependencySet)object).add(j - 1);
                }
                ((Branch)object2).setBranch(((Branch)object2).getBranch() - 1);
                ((Branch)object2).setTermDepends((DependencySet)object);
            }
            list2.remove(branchAddDependency.getBranch());
            this.kb.getABox().setBranch(this.kb.getABox().getBranch() - 1);
        }
    }

    private void restoreClash(ATermAppl aTermAppl, ClashDependency clashDependency) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Restoring clash dependency clash: " + clashDependency.getClash());
        }
        clashDependency.getClash().getDepends().removeExplain(aTermAppl);
        if (clashDependency.getClash().getDepends().getExplain().isEmpty() && clashDependency.getClash().getDepends().isIndependent()) {
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removing clash!");
            }
            this.kb.getABox().setClash(null);
        }
    }

    private void restoreCloseBranch(ATermAppl aTermAppl, CloseBranchDependency closeBranchDependency) {
        if (closeBranchDependency.getTheBranch().getTryNext() > -1) {
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("    Undoing branch remove - branch " + closeBranchDependency.getBranch() + "  -  " + closeBranchDependency.getInd() + "   tryNext: " + closeBranchDependency.getTryNext());
            }
            closeBranchDependency.getTheBranch().shiftTryNext(closeBranchDependency.getTryNext());
        }
    }

    private void restoreDependencies() {
        for (ATermAppl aTermAppl : this.kb.getDeletedAssertions()) {
            DependencyEntry dependencyEntry = this.kb.getDependencyIndex().getDependencies(aTermAppl);
            if (dependencyEntry != null) {
                if (DependencyIndex.log.isLoggable(Level.FINE)) {
                    DependencyIndex.log.fine("Restoring dependencies for " + aTermAppl);
                }
                this.restoreDependency(aTermAppl, dependencyEntry);
            }
            this.kb.getDependencyIndex().removeDependencies(aTermAppl);
        }
    }

    private void restoreDependency(ATermAppl aTermAppl, DependencyEntry dependencyEntry) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Edge Dependencies:");
        }
        for (Edge object : dependencyEntry.getEdges()) {
            this.restoreEdge(aTermAppl, object);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Type Dependencies:");
        }
        for (TypeDependency typeDependency : dependencyEntry.getTypes()) {
            this.restoreType(aTermAppl, typeDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Merge Dependencies: " + dependencyEntry.getMerges());
        }
        for (MergeDependency mergeDependency : dependencyEntry.getMerges()) {
            this.restoreMerge(aTermAppl, mergeDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Branch Add Dependencies: " + dependencyEntry.getBranchAdds());
        }
        for (BranchAddDependency branchAddDependency : dependencyEntry.getBranchAdds()) {
            this.restoreBranchAdd(aTermAppl, branchAddDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring Branch Remove DS Dependencies: " + dependencyEntry.getBranchAdds());
        }
        for (CloseBranchDependency closeBranchDependency : dependencyEntry.getCloseBranches()) {
            this.restoreCloseBranch(aTermAppl, closeBranchDependency);
        }
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("  Restoring clash dependency: " + dependencyEntry.getClash());
        }
        if (dependencyEntry.getClash() != null) {
            this.restoreClash(aTermAppl, dependencyEntry.getClash());
        }
    }

    private void restoreEdge(ATermAppl aTermAppl, Edge edge) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Removing edge? " + edge);
        }
        if (edge == null) {
            return;
        }
        Individual individual = this.kb.getABox().getIndividual((ATerm)edge.getFrom().getName());
        Node node = this.kb.getABox().getNode((ATerm)edge.getTo().getName());
        Role role = this.kb.getRole((ATerm)edge.getRole().getName());
        EdgeList edgeList = individual.getEdgesTo(node, role);
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge2 = edgeList.edgeAt(i);
            if (!edge2.getRole().equals(role)) continue;
            DependencySet dependencySet = edge2.getDepends();
            dependencySet.removeExplain(aTermAppl);
            if (!dependencySet.getExplain().isEmpty()) break;
            IncrementalChangeTracker incrementalChangeTracker = this.kb.getABox().getIncrementalChangeTracker();
            individual.removeEdge(edge2);
            node.removeInEdge(edge2);
            incrementalChangeTracker.addDeletedEdge(edge2);
            incrementalChangeTracker.addUpdatedIndividual(individual);
            if (node instanceof Individual) {
                incrementalChangeTracker.addUpdatedIndividual((Individual)node);
            }
            if (!DependencyIndex.log.isLoggable(Level.FINE)) break;
            DependencyIndex.log.fine("           Actually removed edge!");
            break;
        }
    }

    private void restoreMerge(ATermAppl aTermAppl, MergeDependency mergeDependency) {
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            DependencyIndex.log.fine("    Removing merge? " + mergeDependency.getInd() + " merged to " + mergeDependency.getmergedIntoInd());
        }
        DependencySet dependencySet = this.kb.getABox().getNode((ATerm)mergeDependency.getInd()).getMergeDependency(false);
        dependencySet.removeExplain(aTermAppl);
        if (dependencySet.getExplain().isEmpty()) {
            Node node;
            Node node2;
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removing merge!");
            }
            if (!(node2 = this.kb.getABox().getNode((ATerm)mergeDependency.getInd())).isSame(node = this.kb.getABox().getNode((ATerm)mergeDependency.getmergedIntoInd()))) {
                throw new InternalReasonerException(" Restore merge error: " + node2 + " not same as " + node);
            }
            if (!node2.isPruned()) {
                throw new InternalReasonerException(" Restore merge error: " + node2 + " not pruned");
            }
            node2.unprune(node2.getPruned().getBranch());
            node2.undoSetSame();
            IncrementalChangeTracker incrementalChangeTracker = this.kb.getABox().getIncrementalChangeTracker();
            incrementalChangeTracker.addUnprunedNode(node2);
            if (node2 instanceof Individual) {
                incrementalChangeTracker.addUpdatedIndividual((Individual)node2);
            }
            if (node instanceof Individual) {
                incrementalChangeTracker.addUpdatedIndividual((Individual)node);
            }
        }
    }

    private void restoreType(ATermAppl aTermAppl, TypeDependency typeDependency) {
        DependencySet dependencySet;
        Node node = this.kb.getABox().getNode((ATerm)typeDependency.getInd());
        ATermAppl aTermAppl2 = typeDependency.getType();
        if (DependencyIndex.log.isLoggable(Level.FINE)) {
            if (node instanceof Individual) {
                DependencyIndex.log.fine("    Removing type? " + aTermAppl2 + " from " + ((Individual)node).debugString());
            } else {
                DependencyIndex.log.fine("    Removing type? " + aTermAppl2 + " from " + node);
            }
        }
        if ((dependencySet = node.getDepends((ATerm)ATermUtils.normalize(aTermAppl2))) == null || aTermAppl2 == ATermUtils.TOP) {
            return;
        }
        dependencySet.removeExplain(aTermAppl);
        if (dependencySet.getExplain().isEmpty()) {
            IncrementalChangeTracker incrementalChangeTracker = this.kb.getABox().getIncrementalChangeTracker();
            this.kb.getABox().removeType(node.getName(), aTermAppl2);
            incrementalChangeTracker.addDeletedType(node, typeDependency.getType());
            if (node instanceof Individual) {
                Individual individual = (Individual)node;
                incrementalChangeTracker.addUpdatedIndividual(individual);
                for (Edge edge : individual.getInEdges()) {
                    incrementalChangeTracker.addUpdatedIndividual(edge.getFrom());
                }
                for (Edge edge : individual.getOutEdges()) {
                    if (!(edge.getTo() instanceof Individual)) continue;
                    incrementalChangeTracker.addUpdatedIndividual((Individual)edge.getTo());
                }
            }
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("           Actually removed type!");
            }
        }
    }
}

