/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class Unfolding {
    public abstract ATermAppl getCondition();

    public abstract Set<ATermAppl> getExplanation();

    public abstract ATermAppl getResult();

    public static Unfolding create(ATermAppl aTermAppl, Set<ATermAppl> set) {
        return new Unconditional(aTermAppl, set);
    }

    public static Unfolding create(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        return new Conditional(aTermAppl, aTermAppl2, set);
    }

    private static class Conditional
    extends Unconditional {
        private ATermAppl condition;

        private Conditional(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
            super(aTermAppl, set);
            this.condition = aTermAppl2;
        }

        @Override
        public ATermAppl getCondition() {
            return this.condition;
        }

        @Override
        public String toString() {
            return ATermUtils.toString(this.condition) + " ? " + ATermUtils.toString(this.getResult());
        }
    }

    private static class Unconditional
    extends Unfolding {
        private ATermAppl result;
        private Set<ATermAppl> explanation;

        private Unconditional(ATermAppl aTermAppl, Set<ATermAppl> set) {
            this.result = aTermAppl;
            this.explanation = set;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Unfolding)) {
                return false;
            }
            Unconditional unconditional = (Unconditional)object;
            return this.getCondition().equals(unconditional.getCondition()) && this.explanation.equals(unconditional.explanation) && this.result.equals(unconditional.result);
        }

        @Override
        public ATermAppl getCondition() {
            return ATermUtils.TOP;
        }

        @Override
        public Set<ATermAppl> getExplanation() {
            return this.explanation;
        }

        @Override
        public ATermAppl getResult() {
            return this.result;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getCondition().hashCode();
            n = 31 * n + this.explanation.hashCode();
            n = 31 * n + this.result.hashCode();
            return n;
        }

        public String toString() {
            return ATermUtils.toString(this.result);
        }
    }
}

