/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.DefinitionOrder;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AbstractDefinitionOrder
implements DefinitionOrder {
    protected KnowledgeBase kb;
    protected Comparator<ATerm> comparator;
    private Set<ATermAppl> cyclicConcepts;
    private List<ATermAppl> definitionOrder;

    public AbstractDefinitionOrder(KnowledgeBase knowledgeBase, Comparator<ATerm> comparator) {
        this.kb = knowledgeBase;
        this.comparator = comparator;
        this.cyclicConcepts = CollectionUtils.makeIdentitySet();
        this.definitionOrder = new ArrayList<ATermAppl>(knowledgeBase.getClasses().size() + 2);
        this.initialize();
        this.processDefinitions();
        this.cyclicConcepts = this.computeCycles();
        this.definitionOrder = this.computeDefinitionOrder();
    }

    protected abstract void initialize();

    protected abstract Set<ATermAppl> computeCycles();

    protected abstract List<ATermAppl> computeDefinitionOrder();

    protected void processDefinitions() {
        boolean bl = this.kb.getExpressivity().hasInverse();
        TBox tBox = this.kb.getTBox();
        for (ATermAppl aTermAppl : this.kb.getClasses()) {
            Iterator<Unfolding> iterator = tBox.unfold(aTermAppl);
            while (iterator.hasNext()) {
                Unfolding unfolding = iterator.next();
                Set<ATermAppl> set = ATermUtils.findPrimitives(unfolding.getResult(), !bl, true);
                for (ATermAppl aTermAppl2 : set) {
                    if (!this.kb.getClasses().contains(aTermAppl2)) continue;
                    this.addUses(aTermAppl, aTermAppl2);
                }
            }
        }
    }

    protected abstract void addUses(ATermAppl var1, ATermAppl var2);

    @Override
    public boolean isCyclic(ATermAppl aTermAppl) {
        return this.cyclicConcepts.contains(aTermAppl);
    }

    @Override
    public Iterator<ATermAppl> iterator() {
        return this.definitionOrder.iterator();
    }
}

