/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DefaultAtomObjectVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class VariableBinding {
    private static final Logger log = Logger.getLogger(VariableBinding.class.getCanonicalName());
    private ABox abox;
    private Map<AtomDVariable, Literal> dataVars;
    private Map<AtomIVariable, Individual> instanceVars;

    public VariableBinding(ABox aBox) {
        this.abox = aBox;
        this.dataVars = new HashMap<AtomDVariable, Literal>();
        this.instanceVars = new HashMap<AtomIVariable, Individual>();
    }

    public VariableBinding(VariableBinding variableBinding) {
        this.abox = variableBinding.abox;
        this.dataVars = new HashMap<AtomDVariable, Literal>(variableBinding.dataVars);
        this.instanceVars = new HashMap<AtomIVariable, Individual>(variableBinding.instanceVars);
    }

    public boolean containsKey(AtomDVariable atomDVariable) {
        return this.dataVars.containsKey(atomDVariable);
    }

    public boolean containsKey(AtomIVariable atomIVariable) {
        return this.instanceVars.containsKey(atomIVariable);
    }

    public Set<Map.Entry<AtomDVariable, Literal>> dataEntrySet() {
        return this.dataVars.entrySet();
    }

    public Set<Map.Entry<? extends AtomVariable, ? extends Node>> entrySet() {
        HashSet<Map.Entry<? extends AtomVariable, ? extends Node>> hashSet = new HashSet<Map.Entry<? extends AtomVariable, ? extends Node>>();
        hashSet.addAll(this.dataVars.entrySet());
        hashSet.addAll(this.instanceVars.entrySet());
        return hashSet;
    }

    public boolean equals(Object object) {
        if (object instanceof VariableBinding) {
            VariableBinding variableBinding = (VariableBinding)object;
            if (this.dataVars.equals(variableBinding.dataVars) && this.instanceVars.equals(variableBinding.instanceVars)) {
                return true;
            }
        }
        return false;
    }

    public Literal get(AtomDObject atomDObject) {
        DataValueCollector dataValueCollector = new DataValueCollector();
        atomDObject.accept(dataValueCollector);
        return dataValueCollector.getValue();
    }

    public Individual get(AtomIObject atomIObject) {
        IndividualValueCollector individualValueCollector = new IndividualValueCollector();
        atomIObject.accept(individualValueCollector);
        return individualValueCollector.getValue();
    }

    public ABox getABox() {
        return this.abox;
    }

    public int hashCode() {
        return this.dataVars.hashCode() + this.instanceVars.hashCode();
    }

    public Literal set(AtomDObject atomDObject, Literal literal) {
        ValueSettingVisitor valueSettingVisitor = new ValueSettingVisitor(null, literal);
        atomDObject.accept(valueSettingVisitor);
        return valueSettingVisitor.getData();
    }

    public Literal set(AtomDVariable atomDVariable, ATermAppl aTermAppl) {
        AtomDConstant atomDConstant = new AtomDConstant(aTermAppl);
        DataValueCollector dataValueCollector = new DataValueCollector();
        atomDConstant.accept(dataValueCollector);
        return this.set((AtomDObject)atomDVariable, dataValueCollector.getValue());
    }

    public Individual set(AtomIObject atomIObject, Individual individual) {
        ValueSettingVisitor valueSettingVisitor = new ValueSettingVisitor(individual, null);
        atomIObject.accept(valueSettingVisitor);
        return valueSettingVisitor.getIndividual();
    }

    public Individual set(AtomIVariable atomIVariable, ATermAppl aTermAppl) {
        AtomIConstant atomIConstant = new AtomIConstant(aTermAppl);
        IndividualValueCollector individualValueCollector = new IndividualValueCollector();
        atomIConstant.accept(individualValueCollector);
        return this.set((AtomIObject)atomIVariable, individualValueCollector.getValue());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(this.instanceVars);
        stringBuffer.append(", ");
        stringBuffer.append(this.dataVars);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private class ValueSettingVisitor
    implements AtomObjectVisitor {
        Literal data;
        Individual individual;

        public ValueSettingVisitor(Individual individual, Literal literal) {
            this.data = literal;
            this.individual = individual;
        }

        public Literal getData() {
            return this.data;
        }

        public Individual getIndividual() {
            return this.individual;
        }

        @Override
        public void visit(AtomDConstant atomDConstant) {
            this.data = null;
        }

        @Override
        public void visit(AtomDVariable atomDVariable) {
            if (this.data != null) {
                this.data = VariableBinding.this.dataVars.put(atomDVariable, this.data);
            }
        }

        @Override
        public void visit(AtomIConstant atomIConstant) {
            this.individual = null;
        }

        @Override
        public void visit(AtomIVariable atomIVariable) {
            if (this.individual != null) {
                this.individual = VariableBinding.this.instanceVars.put(atomIVariable, this.individual);
            }
        }
    }

    private class IndividualValueCollector
    extends DefaultAtomObjectVisitor {
        Individual value = null;

        private IndividualValueCollector() {
        }

        public Individual getValue() {
            return this.value;
        }

        @Override
        public void visit(AtomIConstant atomIConstant) {
            VariableBinding.this.abox.copyOnWrite();
            this.value = VariableBinding.this.abox.getIndividual((ATerm)atomIConstant.getValue());
        }

        @Override
        public void visit(AtomIVariable atomIVariable) {
            this.value = (Individual)VariableBinding.this.instanceVars.get(atomIVariable);
        }
    }

    private class DataValueCollector
    extends DefaultAtomObjectVisitor {
        Literal value = null;

        private DataValueCollector() {
        }

        public Literal getValue() {
            return this.value;
        }

        @Override
        public void visit(AtomDConstant atomDConstant) {
            ATermAppl aTermAppl;
            ATermAppl aTermAppl2 = atomDConstant.getValue();
            try {
                aTermAppl = VariableBinding.this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(aTermAppl2);
            }
            catch (InvalidLiteralException invalidLiteralException) {
                String string = String.format("Invalid literal (%s) in SWRL data constant: %s", aTermAppl2, invalidLiteralException.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    aTermAppl = aTermAppl2;
                }
                log.severe(string);
                throw new InternalReasonerException(string, invalidLiteralException);
            }
            catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                String string = String.format("Unrecognized datatype in literal appearing (%s) in SWRL data constant: %s", aTermAppl2, unrecognizedDatatypeException.getMessage());
                log.severe(string);
                throw new InternalReasonerException(string, unrecognizedDatatypeException);
            }
            VariableBinding.this.abox.copyOnWrite();
            this.value = VariableBinding.this.abox.getLiteral((ATerm)aTermAppl);
            if (this.value == null) {
                this.value = VariableBinding.this.abox.addLiteral(aTermAppl);
            }
        }

        @Override
        public void visit(AtomDVariable atomDVariable) {
            this.value = (Literal)VariableBinding.this.dataVars.get(atomDVariable);
        }
    }
}

