/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.LimitedMapIRIMapper;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Set;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;

public class OWLAPILoader
extends KBLoader {
    private OWLOntologyManager manager;
    private PelletReasoner pellet;
    private LimitedMapIRIMapper iriMapper = new LimitedMapIRIMapper();
    private OWLOntology baseOntology;
    private boolean ignoreImports;
    private boolean loadSingleFile;

    public OWLAPILoader() {
        this.manager = OWLManager.createOWLOntologyManager();
        this.manager.setSilentMissingImportsHandling(true);
        this.manager.addMissingImportListener(new MissingImportListener(){

            public void importMissing(MissingImportEvent missingImportEvent) {
                if (!OWLAPILoader.this.ignoreImports) {
                    IRI iRI = missingImportEvent.getImportedOntologyURI();
                    System.err.println("WARNING: Cannot import " + iRI);
                    missingImportEvent.getCreationException().printStackTrace();
                }
            }
        });
        this.clear();
    }

    @Override
    public KnowledgeBase getKB() {
        return this.pellet.getKB();
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public OWLOntology getOntology() {
        return this.baseOntology;
    }

    public Set<OWLOntology> getAllOntologies() {
        return this.manager.getOntologies();
    }

    public PelletReasoner getReasoner() {
        return this.pellet;
    }

    @Override
    public void load() {
        this.pellet = new PelletReasonerFactory().createReasoner(this.baseOntology);
        this.pellet.getKB().setTaxonomyBuilderProgressMonitor(PelletOptions.USE_CLASSIFICATION_MONITOR.create());
    }

    @Override
    public void parse(String ... stringArray) {
        this.loadSingleFile = stringArray.length == 1;
        super.parse(stringArray);
    }

    @Override
    protected void parseFile(String string) {
        try {
            IRI iRI = IRI.create((String)string);
            this.iriMapper.addAllowedIRI(iRI);
            if (this.loadSingleFile) {
                this.baseOntology = this.manager.loadOntologyFromOntologyDocument(iRI);
            } else {
                OWLOntology oWLOntology = this.manager.loadOntologyFromOntologyDocument(iRI);
                OWLImportsDeclaration oWLImportsDeclaration = this.manager.getOWLDataFactory().getOWLImportsDeclaration(oWLOntology.getOntologyID().getOntologyIRI());
                this.manager.applyChange((OWLOntologyChange)new AddImport(this.baseOntology, oWLImportsDeclaration));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            throw new RuntimeException(oWLOntologyCreationException);
        }
        catch (OWLOntologyChangeException oWLOntologyChangeException) {
            throw new RuntimeException(oWLOntologyChangeException);
        }
    }

    @Override
    public void setIgnoreImports(boolean bl) {
        this.ignoreImports = bl;
        if (bl) {
            this.manager.clearIRIMappers();
            this.manager.addIRIMapper((OWLOntologyIRIMapper)this.iriMapper);
        } else {
            this.manager.clearIRIMappers();
            this.manager.addIRIMapper((OWLOntologyIRIMapper)new NonMappingOntologyIRIMapper());
        }
    }

    @Override
    public void clear() {
        this.iriMapper.clear();
        for (OWLOntology oWLOntology : this.manager.getOntologies()) {
            this.manager.removeOntology(oWLOntology);
        }
        try {
            this.baseOntology = this.manager.createOntology();
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            throw new RuntimeException(oWLOntologyCreationException);
        }
    }
}

