/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import java.math.BigDecimal;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDDecimal
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal instance;
    private static final Logger log;
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), null);

    public static XSDDecimal getInstance() {
        return instance;
    }

    private XSDDecimal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            BigDecimal bigDecimal = DatatypeConverter.parseDecimal(string);
            String string2 = DatatypeConverter.printDecimal(bigDecimal);
            if (string2.equals(string)) {
                return aTermAppl;
            }
            return ATermUtils.makeTypedLiteral(string2, this.getName());
        }
        catch (NumberFormatException numberFormatException) {
            log.severe(String.format("Number format exception (%s) cause while parsing decimal %s", numberFormatException.getMessage(), string));
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (this.dataRange.contains(object)) {
            return ATermUtils.makeTypedLiteral(OWLRealUtils.print((Number)object), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        log = Logger.getLogger(XSDDecimal.class.getCanonicalName());
        instance = new XSDDecimal();
    }
}

