/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import jjtraveler.Visitable;
import jjtraveler.graph.Graph;

public class EdgesGraph
implements Graph {
    Collection edges = new Vector();

    public void addEdge(Visitable from, Visitable to) {
        Edge edge = new Edge(from, to);
        this.edges.add(edge);
    }

    public String toDot(String name) {
        String result = "digraph " + name + " {\n";
        Iterator edgeIterator = this.edges.iterator();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            result = String.valueOf(result) + edge.toDot();
        }
        result = String.valueOf(result) + "}\n";
        return result;
    }

    public String toRSF() {
        return this.toRSF("edge");
    }

    public String toRSF(String defaultEdgeType) {
        String result = "";
        Iterator edgeIterator = this.edges.iterator();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            result = String.valueOf(result) + edge.toRSF(defaultEdgeType);
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof EdgesGraph) {
            EdgesGraph g = (EdgesGraph)o;
            result = g.edges.equals(this.edges);
        }
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        Iterator edgeIterator = this.edges.iterator();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            result += edge.hashCode();
        }
        return result;
    }

    class Edge
    implements Comparable {
        Visitable source;
        Visitable target;

        public Edge(Visitable source, Visitable target) {
            this.source = source;
            this.target = target;
        }

        public String toDot() {
            return this.source + " -> " + this.target + ";\n";
        }

        public String toRSF(String edgeType) {
            return String.valueOf(edgeType) + " " + this.source + " " + this.target + "\n";
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof Edge) {
                Edge edge = (Edge)o;
                result = edge.source.equals(this.source) && edge.target.equals(this.target);
            }
            return result;
        }

        public int hashCode() {
            return this.source.hashCode() + this.target.hashCode();
        }

        public int compareTo(Object o) {
            if (o instanceof Edge) {
                Edge edge = (Edge)o;
                return this.hashCode() - edge.hashCode();
            }
            throw new ClassCastException("Tried to compare an Edge to something that is not an edge");
        }
    }
}

