/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import pellet.PelletCmdException;
import pellet.PelletCmdOptionArg;

public class PelletCmdOption {
    private String longOption;
    private String shortOption;
    private String type;
    private String description;
    private boolean isMandatory;
    private Object value;
    private Object defaultValue;
    private boolean exists;
    private PelletCmdOptionArg arg = PelletCmdOptionArg.NONE;

    public PelletCmdOption(String string) {
        if (string == null) {
            throw new PelletCmdException("A long option must be defined for a command line option");
        }
        this.longOption = this.removeHyphen(string);
        this.defaultValue = null;
    }

    public String getShortOption() {
        return this.shortOption;
    }

    public String getLongOption() {
        return this.longOption;
    }

    public void setShortOption(String string) {
        this.shortOption = this.removeHyphen(string);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.value != null) {
            return this.value.toString();
        }
        if (this.defaultValue != null) {
            return this.defaultValue.toString();
        }
        return null;
    }

    public int getValueAsPositiveInteger() throws PelletCmdException {
        return this.getValueAsInteger(1, Integer.MAX_VALUE);
    }

    public int getValueAsNonNegativeInteger() throws PelletCmdException {
        return this.getValueAsInteger(0, Integer.MAX_VALUE);
    }

    public int getValueAsInteger() throws PelletCmdException {
        return this.getValueAsInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int getValueAsInteger(int n, int n2) throws PelletCmdException {
        String string = this.getValueAsString();
        if (string == null) {
            throw new PelletCmdException(String.format("The value for option <%s> does not exist%n", this.longOption));
        }
        try {
            int n3 = Integer.parseInt(string);
            if (n3 < n) {
                throw new PelletCmdException(String.format("The value for option <%s> should be greater than or equal to %d but was: %d%n", this.longOption, n, n3));
            }
            if (n3 > n2) {
                throw new PelletCmdException(String.format("The value for option <%s> should be less than or equal to %d but was: %d%n", this.longOption, n2, n3));
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PelletCmdException(String.format("The value for option <%s> is not a valid integer: %s%n", this.longOption, string));
        }
    }

    public boolean getValueAsBoolean() {
        String string = this.getValueAsString();
        return Boolean.parseBoolean(string);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setValue(Boolean bl) {
        this.value = bl;
    }

    public void setIsMandatory(boolean bl) {
        this.isMandatory = bl;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PelletCmdOption)) {
            return false;
        }
        PelletCmdOption pelletCmdOption = (PelletCmdOption)object;
        return (this.shortOption == null && pelletCmdOption.getShortOption() == null || this.shortOption != null && this.shortOption.equals(pelletCmdOption.getShortOption())) && this.longOption.equals(pelletCmdOption.getLongOption()) && (this.type == null && pelletCmdOption.getType() == null || this.type != null && this.type.equals(pelletCmdOption.getType())) && (this.description == null && pelletCmdOption.getDescription() == null || this.description != null && this.description.equals(pelletCmdOption.getDescription())) && this.isMandatory == pelletCmdOption.isMandatory() && (this.value == null && pelletCmdOption.getValue() == null || this.value != null && this.value.equals(pelletCmdOption.getValue())) && (this.defaultValue == null && pelletCmdOption.getDefaultValue() == null || this.defaultValue != null && this.defaultValue.equals(pelletCmdOption.getDefaultValue()));
    }

    public int hashCode() {
        int n = 0;
        if (this.shortOption != null) {
            n += this.shortOption.hashCode();
        }
        if (this.longOption != null) {
            n += this.longOption.hashCode();
        }
        return n;
    }

    public String toString() {
        return "[ " + this.longOption + ", " + this.shortOption + ", " + this.type + ", " + this.description + ", " + this.isMandatory + ", " + this.value + ", " + this.defaultValue + " ]";
    }

    private String removeHyphen(String string) {
        int n = 0;
        while (string.charAt(n) == '-') {
            ++n;
        }
        return string.substring(n);
    }

    public void setArg(PelletCmdOptionArg pelletCmdOptionArg) {
        this.arg = pelletCmdOptionArg;
    }

    public PelletCmdOptionArg getArg() {
        return this.arg;
    }

    public boolean exists() {
        return this.exists || this.value != null;
    }

    public void setExists(boolean bl) {
        this.exists = bl;
    }
}

