/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class PrimitiveTBox {
    public static final Logger log = Logger.getLogger(PrimitiveTBox.class.getName());
    private Map<ATermAppl, Unfolding> definitions = CollectionUtils.makeIdentityMap();
    private Map<ATermAppl, Set<ATermAppl>> dependencies = CollectionUtils.makeIdentityMap();

    public boolean contains(ATermAppl aTermAppl) {
        return this.definitions.containsKey(aTermAppl);
    }

    public Unfolding getDefinition(ATermAppl aTermAppl) {
        return this.definitions.get(aTermAppl);
    }

    public boolean add(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        if (!ATermUtils.isPrimitive(aTermAppl) || this.contains(aTermAppl)) {
            return false;
        }
        Set<ATermAppl> set2 = ATermUtils.findPrimitives(aTermAppl2);
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (ATermAppl aTermAppl3 : set2) {
            boolean bl = this.findTarget(aTermAppl3, aTermAppl, hashSet);
            if (!bl) continue;
            return false;
        }
        this.addDefinition(aTermAppl, aTermAppl2, set);
        this.addDefinition(TermFactory.not(aTermAppl), TermFactory.not(aTermAppl2), set);
        this.dependencies.put(aTermAppl, set2);
        return true;
    }

    protected void addDefinition(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Def: " + ATermUtils.toString(aTermAppl) + " = " + ATermUtils.toString(aTermAppl2));
        }
        this.definitions.put(aTermAppl, Unfolding.create(aTermAppl2, set));
    }

    protected boolean findTarget(ATermAppl aTermAppl, ATermAppl aTermAppl2, Set<ATermAppl> set) {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        arrayList.add(aTermAppl);
        while (!arrayList.isEmpty()) {
            ATermAppl aTermAppl3 = (ATermAppl)arrayList.remove(arrayList.size() - 1);
            if (!set.add(aTermAppl3)) continue;
            if (aTermAppl3.equals(aTermAppl2)) {
                return true;
            }
            Set<ATermAppl> set2 = this.dependencies.get(aTermAppl3);
            if (set2 == null) continue;
            if (set2.contains(aTermAppl2)) {
                return true;
            }
            arrayList.addAll(set2);
        }
        return false;
    }

    public boolean remove(ATermAppl aTermAppl) {
        return false;
    }

    public Iterator<Unfolding> unfold(ATermAppl aTermAppl) {
        Unfolding unfolding = this.definitions.get(aTermAppl);
        return unfolding == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(unfolding);
    }

    public void print(Appendable appendable) throws IOException {
        for (Map.Entry<ATermAppl, Unfolding> entry : this.definitions.entrySet()) {
            appendable.append(ATermUtils.toString(entry.getKey()));
            appendable.append(" = ");
            appendable.append(entry.getValue().toString());
            appendable.append("\n");
        }
    }
}

