/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.IndividualBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class GuessBranch
extends IndividualBranch {
    private Role r;
    private int minGuess;
    private ATermAppl qualification;

    public GuessBranch(ABox aBox, CompletionStrategy completionStrategy, Individual individual, Role role, int n, int n2, ATermAppl aTermAppl, DependencySet dependencySet) {
        super(aBox, completionStrategy, individual, dependencySet, n2 - n + 1);
        this.r = role;
        this.minGuess = n;
        this.qualification = aTermAppl;
    }

    @Override
    public IndividualBranch copyTo(ABox aBox) {
        Individual individual = aBox.getIndividual((ATerm)this.ind.getName());
        GuessBranch guessBranch = new GuessBranch(aBox, null, individual, this.r, this.minGuess, this.minGuess + this.getTryCount() - 1, this.qualification, this.getTermDepends());
        guessBranch.setAnonCount(this.getAnonCount());
        guessBranch.setNodeCount(this.nodeCount);
        guessBranch.setBranch(this.branch);
        guessBranch.setStrategy(this.strategy);
        guessBranch.setTryNext(this.tryNext);
        return guessBranch;
    }

    @Override
    protected void tryBranch() {
        this.abox.incrementBranch();
        DependencySet dependencySet = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet dependencySet2;
            int n;
            int n2 = this.minGuess + this.getTryCount() - this.getTryNext() - 1;
            if (log.isLoggable(Level.FINE)) {
                log.fine("GUES: (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") at branch (" + this.getBranch() + ") to  " + this.ind + " -> " + this.r + " -> anon" + (n2 == 1 ? "" : this.abox.getAnonCount() + 1 + " - anon") + (this.abox.getAnonCount() + n2) + " " + dependencySet);
            }
            dependencySet = dependencySet.union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            this.strategy.addType(this.ind, ATermUtils.makeMin((ATerm)this.r.getName(), n2, (ATerm)this.qualification), dependencySet);
            this.strategy.addType(this.ind, ATermUtils.makeNormalizedMax(this.r.getName(), n2, this.qualification), dependencySet);
            Individual[] individualArray = new Individual[n2];
            for (n = 0; n < n2; ++n) {
                individualArray[n] = this.strategy.createFreshIndividual(null, dependencySet);
                this.strategy.addEdge(this.ind, this.r, individualArray[n], dependencySet);
                individualArray[n] = individualArray[n].getSame();
                this.strategy.addType(individualArray[n], this.qualification, dependencySet);
                individualArray[n] = individualArray[n].getSame();
                for (int i = 0; i < n; ++i) {
                    individualArray[n].setDifferent(individualArray[i], dependencySet);
                }
            }
            n = this.abox.isClosed() ? 1 : 0;
            if (n != 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CLASH: Branch " + this.getBranch() + " " + this.abox.getClash() + "!");
                }
                if (!(dependencySet2 = this.abox.getClash().getDepends()).contains(this.getBranch())) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(dependencySet2);
            ++this.tryNext;
        }
        dependencySet = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            dependencySet.remove(this.getBranch());
        }
        this.abox.setClash(Clash.unexplained(this.ind, dependencySet));
    }

    @Override
    public String toString() {
        if (this.getTryNext() < this.getTryCount()) {
            return "Branch " + this.getBranch() + " guess rule on " + this.ind + " for role  " + this.r;
        }
        return "Branch " + this.getBranch() + " guess rule on " + this.ind + " for role  " + this.r + " exhausted merge possibilities";
    }

    @Override
    public void shiftTryNext(int n) {
    }
}

