/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.DoubtfulSet;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.jena.vocabulary.SWRL;

public class OWLEntityDatabase {
    public static final Logger log = Logger.getLogger(OWLEntityDatabase.class.getName());
    private DoubtfulSet<RDFNode> m_Ontologies = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Classes = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Datatypes = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Individuals = new DoubtfulSet();
    private Set<RDFNode> m_AllRoles = CollectionUtil.makeSet();
    private DoubtfulSet<RDFNode> m_AnnotationRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_OntologyRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_ObjectRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_DatatypeRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_SWRLVariables = new DoubtfulSet();
    private Set<RDFNode> m_RDFClasses = CollectionUtil.makeSet();
    private Set<Resource> m_Restrictions = CollectionUtil.makeSet();
    private Set<RDFNode> m_Literals = CollectionUtil.makeSet();
    private Set<Literal> m_LiteralsAsClass = CollectionUtil.makeSet();
    private Set<Literal> m_LiteralsAsIndividuals = CollectionUtil.makeSet();
    private Set<Resource> m_ResourcesAsLiterals = CollectionUtil.makeSet();

    public void addOntology(RDFNode rDFNode) {
        this.m_Ontologies.addDefinite(rDFNode);
    }

    public void assumeOntology(RDFNode rDFNode) {
        this.m_Ontologies.add(rDFNode);
    }

    public boolean containsOntology(RDFNode rDFNode) {
        return this.m_Ontologies.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulOntologies() {
        return this.m_Ontologies.getDoubtfulElements();
    }

    public void addRDFSClass(RDFNode rDFNode) {
        this.m_RDFClasses.add(rDFNode);
    }

    public Set<RDFNode> getAllRDFClasses() {
        return this.m_RDFClasses;
    }

    public void addRestriction(Resource resource) {
        this.m_Restrictions.add(resource);
    }

    public Set<Resource> getAllRestrictions() {
        return this.m_Restrictions;
    }

    public void addLiteral(RDFNode rDFNode) {
        this.m_Literals.add(rDFNode);
    }

    public void addClass(RDFNode rDFNode) {
        this.m_Classes.addDefinite(rDFNode);
    }

    public void assumeClass(RDFNode rDFNode) {
        this.m_Classes.add(rDFNode);
        if (rDFNode instanceof Literal) {
            this.m_LiteralsAsClass.add((Literal)rDFNode);
        }
    }

    public boolean containsClass(RDFNode rDFNode) {
        return this.m_Classes.contains(rDFNode) || rDFNode.isResource() && this.m_Restrictions.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulClasses() {
        Set<RDFNode> set = this.m_Classes.getDoubtfulElements();
        set.removeAll(this.m_Restrictions);
        return set;
    }

    public void addDatatype(RDFNode rDFNode) {
        this.m_Datatypes.addDefinite(rDFNode);
    }

    public void assumeDatatype(RDFNode rDFNode) {
        this.m_Datatypes.add(rDFNode);
    }

    public boolean containsDatatype(RDFNode rDFNode) {
        return this.m_Datatypes.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulDatatypes() {
        return this.m_Datatypes.getDoubtfulElements();
    }

    public void addIndividual(RDFNode rDFNode) {
        this.m_Individuals.addDefinite(rDFNode);
    }

    public void assumeIndividual(RDFNode rDFNode) {
        this.m_Individuals.add(rDFNode);
    }

    public boolean containsIndividual(RDFNode rDFNode) {
        return this.m_Individuals.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulIndividuals() {
        return this.m_Individuals.getDoubtfulElements();
    }

    public void addUntypedRole(RDFNode rDFNode) {
        this.m_AllRoles.add(rDFNode);
    }

    public boolean containsRole(RDFNode rDFNode) {
        return this.m_AllRoles.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulRoles() {
        Set<RDFNode> set = CollectionUtil.copy(this.m_AllRoles);
        set.removeAll(this.m_AnnotationRoles);
        set.removeAll(this.m_OntologyRoles);
        set.removeAll(this.m_ObjectRoles);
        set.removeAll(this.m_DatatypeRoles);
        return set;
    }

    public void addAnnotationRole(RDFNode rDFNode) {
        this.m_AllRoles.add(rDFNode);
        this.m_AnnotationRoles.addDefinite(rDFNode);
    }

    public void assumeAnnotationRole(RDFNode rDFNode) {
        this.m_AnnotationRoles.add(rDFNode);
    }

    public boolean containsAnnotaionRole(RDFNode rDFNode) {
        return this.m_AnnotationRoles.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulAnnotaionRoles() {
        return this.m_AnnotationRoles.getDoubtfulElements();
    }

    public void addOntologyRole(RDFNode rDFNode) {
        this.m_AllRoles.add(rDFNode);
        this.m_OntologyRoles.addDefinite(rDFNode);
    }

    public boolean containsOntologyRole(RDFNode rDFNode) {
        return this.m_OntologyRoles.contains(rDFNode);
    }

    public void addObjectRole(RDFNode rDFNode) {
        this.m_AllRoles.add(rDFNode);
        this.m_ObjectRoles.addDefinite(rDFNode);
    }

    public void assumeObjectRole(RDFNode rDFNode) {
        this.m_ObjectRoles.add(rDFNode);
    }

    public boolean containsObjectRole(RDFNode rDFNode) {
        return this.m_ObjectRoles.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulObjectRoles() {
        return this.m_ObjectRoles.getDoubtfulElements();
    }

    public void addInverseFunctionalRole(RDFNode rDFNode) {
        this.addObjectRole(rDFNode);
    }

    public void addTransitiveRole(RDFNode rDFNode) {
        this.addObjectRole(rDFNode);
    }

    public void addSymmetricRole(RDFNode rDFNode) {
        this.addObjectRole(rDFNode);
    }

    public void addAntiSymmetricRole(Resource resource) {
        this.addObjectRole((RDFNode)resource);
    }

    public void addReflexiveRole(Resource resource) {
        this.addObjectRole((RDFNode)resource);
    }

    public void addIrreflexiveRole(Resource resource) {
        this.addObjectRole((RDFNode)resource);
    }

    public void addDatatypeRole(RDFNode rDFNode) {
        this.m_AllRoles.add(rDFNode);
        this.m_DatatypeRoles.addDefinite(rDFNode);
    }

    public void assumeDatatypeRole(RDFNode rDFNode) {
        this.m_DatatypeRoles.add(rDFNode);
    }

    public boolean containsDatatypeRole(RDFNode rDFNode) {
        return this.m_DatatypeRoles.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulDatatypeRoles() {
        return this.m_DatatypeRoles.getDoubtfulElements();
    }

    public void addSWRLVariable(RDFNode rDFNode) {
        this.m_SWRLVariables.addDefinite(rDFNode);
    }

    public void assumeSWRLVariable(RDFNode rDFNode) {
        this.m_SWRLVariables.add(rDFNode);
    }

    public boolean containsSWRLVariable(RDFNode rDFNode) {
        return this.m_SWRLVariables.contains(rDFNode);
    }

    public Set<RDFNode> getDoubtfulSWRLVariables() {
        return this.m_SWRLVariables.getDoubtfulElements();
    }

    public Set<Literal> getLiteralsAsClass() {
        return this.m_LiteralsAsClass;
    }

    public void addLiteralAsClass(Literal literal) {
        this.m_LiteralsAsClass.add(literal);
    }

    public Set<Literal> getLiteralsAsIndividuals() {
        return this.m_LiteralsAsIndividuals;
    }

    public void addLiteralAsIndividual(Literal literal) {
        this.m_LiteralsAsIndividuals.add(literal);
    }

    public Set<Resource> getResourcesAsLiterals() {
        return this.m_ResourcesAsLiterals;
    }

    public void addResourcesAsLiteral(Resource resource) {
        this.m_ResourcesAsLiterals.add(resource);
    }

    public boolean containsResource(RDFNode rDFNode) {
        return this.m_Ontologies.contains(rDFNode) || this.m_Classes.contains(rDFNode) || this.m_Datatypes.contains(rDFNode) || this.m_Individuals.contains(rDFNode) || this.m_AllRoles.contains(rDFNode) || this.m_RDFClasses.contains(rDFNode) || rDFNode.isResource() && this.m_Restrictions.contains(rDFNode) || this.m_Literals.contains(rDFNode) || this.m_SWRLVariables.contains(rDFNode);
    }

    public Map<RDFNode, List<String>> getAllMultiTypedResources() {
        return this.getMultiTypedResources(false);
    }

    public Map<RDFNode, List<String>> getMultiTypedResources(boolean bl) {
        Map<String, Set<RDFNode>> map = CollectionUtil.makeMap();
        if (!bl) {
            map.put("Ontology", this.m_Ontologies.getDefiniteElements());
            map.put("Class", this.m_Classes.getDefiniteElements());
            map.put("Datatype", this.m_Datatypes.getDefiniteElements());
            map.put("Individual", this.m_Individuals);
            map.put("Literal", this.m_Literals);
        }
        map.put("Annotation Property", this.m_AnnotationRoles.getDefiniteElements());
        map.put("Ontology Property", this.m_OntologyRoles.getDefiniteElements());
        map.put("Datatype Property", this.m_DatatypeRoles.getDefiniteElements());
        map.put("Object Property", this.m_ObjectRoles.getDefiniteElements());
        map.put("SWRL Variable", this.m_SWRLVariables.getDefiniteElements());
        Set<Object> set = CollectionUtil.makeSet();
        for (List<String> list : map.values()) {
            set.addAll((Collection<Object>)list);
        }
        Map map2 = CollectionUtil.makeMap();
        for (Object object : set) {
            RDFNode rDFNode = CollectionUtil.makeList();
            for (Map.Entry entry : map.entrySet()) {
                if (!((Set)entry.getValue()).contains(object)) continue;
                rDFNode.add(entry.getKey());
            }
            if (rDFNode.size() <= 1) continue;
            map2.put(object, rDFNode);
        }
        if (bl) {
            List<String> list;
            list = Arrays.asList("Class", "Datatype");
            for (RDFNode rDFNode : this.m_Datatypes.getDefiniteElements()) {
                if (!this.m_Classes.getDefiniteElements().contains(rDFNode)) continue;
                map2.put(rDFNode, list);
            }
        }
        return map2;
    }

    public List<Statement> getAllTypingStatements() {
        List<Statement> list = CollectionUtil.makeList();
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulOntologies(), OWL.Ontology);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulClasses(), OWL.Class);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulDatatypes(), RDFS.Datatype);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulRoles(), OWL.ObjectProperty);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulAnnotaionRoles(), OWL.AnnotationProperty);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulObjectRoles(), OWL.ObjectProperty);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulDatatypeRoles(), OWL.DatatypeProperty);
        OWLEntityDatabase.addTypingStatements(list, this.getDoubtfulSWRLVariables(), SWRL.Variable);
        return list;
    }

    private static void addTypingStatements(List<Statement> list, Set<RDFNode> set, Resource resource) {
        Model model = ModelFactory.createDefaultModel();
        for (RDFNode rDFNode : set) {
            if (!(rDFNode instanceof Resource)) continue;
            list.add(model.createStatement((Resource)rDFNode, RDF.type, (RDFNode)resource));
        }
    }
}

