/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.utils.ATermUtils;

public class TermTuple
extends Tuple<ATermAppl> {
    private static String format(ATermAppl aTermAppl) {
        return ATermUtils.toString(aTermAppl);
    }

    public TermTuple(DependencySet dependencySet, List<ATermAppl> list) {
        super(dependencySet, list);
    }

    public TermTuple(DependencySet dependencySet, ATermAppl ... aTermApplArray) {
        super(dependencySet, aTermApplArray);
    }

    public TermTuple(ATermAppl ... aTermApplArray) {
        super(DependencySet.INDEPENDENT, aTermApplArray);
    }

    public boolean equals(Object object) {
        if (object instanceof TermTuple) {
            TermTuple termTuple = (TermTuple)object;
            return this.getElements().equals(termTuple.getElements());
        }
        return false;
    }

    public List<ATermAppl> getVars() {
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (ATermAppl aTermAppl : this.getElements()) {
            if (!ATermUtils.isVar(aTermAppl)) continue;
            arrayList.add(aTermAppl);
        }
        return arrayList;
    }

    @Override
    public String toString() {
        if (this.getElements().size() == 3) {
            ATermAppl aTermAppl = (ATermAppl)this.getElements().get(0);
            ATermAppl aTermAppl2 = (ATermAppl)this.getElements().get(1);
            ATermAppl aTermAppl3 = (ATermAppl)this.getElements().get(2);
            if (aTermAppl.equals(Compiler.TYPE)) {
                return TermTuple.format(aTermAppl3) + "(" + TermTuple.format(aTermAppl2) + ")";
            }
            if (aTermAppl.equals(Compiler.SAME_AS)) {
                return TermTuple.format(aTermAppl2) + " = " + TermTuple.format(aTermAppl3);
            }
            if (aTermAppl.equals(Compiler.DIFF_FROM)) {
                return TermTuple.format(aTermAppl2) + " != " + TermTuple.format(aTermAppl3);
            }
            return TermTuple.format(aTermAppl) + "(" + TermTuple.format(aTermAppl2) + "," + TermTuple.format(aTermAppl3) + ")";
        }
        Iterator iterator = this.getElements().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        if (iterator.hasNext()) {
            stringBuilder.append(TermTuple.format((ATermAppl)iterator.next()));
        }
        stringBuilder.append("(");
        while (iterator.hasNext()) {
            stringBuilder.append(TermTuple.format((ATermAppl)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

