/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.builtins.NoSuchBuiltIn;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.HashSet;

public class UsableRuleFilter {
    private static BodyAtomFilter bodyFilter = new BodyAtomFilter();
    private static HeadAtomFilter headFilter = new HeadAtomFilter();

    public static boolean isUsable(Rule rule) {
        return UsableRuleFilter.explainNotUsable(rule) == null;
    }

    public static String explainNotUsable(Rule rule) {
        HashSet<AtomVariable> hashSet = new HashSet<AtomVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(bodyFilter);
            if (!bodyFilter.isUsable()) {
                return bodyFilter.getMessage();
            }
            hashSet.addAll(VariableUtils.getVars(ruleAtom));
        }
        for (RuleAtom ruleAtom : rule.getHead()) {
            ruleAtom.accept(headFilter);
            if (!hashSet.containsAll(VariableUtils.getVars(ruleAtom))) {
                return "Head atom " + ruleAtom + " contains variables not found in body.";
            }
            if (headFilter.isUsable()) continue;
            return headFilter.getMessage();
        }
        return null;
    }

    private static class HeadAtomFilter
    implements RuleAtomVisitor {
        private boolean usable;
        private String usageMessage;

        private HeadAtomFilter() {
        }

        public String getMessage() {
            return this.usageMessage;
        }

        public boolean isUsable() {
            return this.usable;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            this.usable = false;
            this.usageMessage = "Builtin atoms in rule heads are not currently supported";
        }

        @Override
        public void visit(ClassAtom classAtom) {
            this.usable = true;
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            this.usable = false;
            this.usageMessage = "DataRange atoms in rule heads are not currently supported";
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            this.usable = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
            this.usable = true;
        }

        @Override
        public void visit(IndividualPropertyAtom individualPropertyAtom) {
            this.usable = true;
        }

        @Override
        public void visit(SameIndividualAtom sameIndividualAtom) {
            this.usable = true;
        }
    }

    private static class BodyAtomFilter
    implements RuleAtomVisitor {
        private boolean usable;
        private String usageMessage;

        private BodyAtomFilter() {
        }

        public String getMessage() {
            return this.usageMessage;
        }

        public boolean isUsable() {
            return this.usable;
        }

        @Override
        public void visit(BuiltInAtom builtInAtom) {
            BuiltIn builtIn = BuiltInRegistry.instance.getBuiltIn((String)builtInAtom.getPredicate());
            if (builtIn.equals(NoSuchBuiltIn.instance)) {
                this.usable = false;
                this.usageMessage = "No builtin for " + (String)builtInAtom.getPredicate();
            } else {
                this.usable = true;
            }
        }

        @Override
        public void visit(ClassAtom classAtom) {
            this.usable = true;
        }

        @Override
        public void visit(DataRangeAtom dataRangeAtom) {
            this.usable = true;
        }

        @Override
        public void visit(DatavaluedPropertyAtom datavaluedPropertyAtom) {
            this.usable = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom differentIndividualsAtom) {
            this.usable = true;
        }

        @Override
        public void visit(IndividualPropertyAtom individualPropertyAtom) {
            this.usable = true;
        }

        @Override
        public void visit(SameIndividualAtom sameIndividualAtom) {
            this.usable = true;
        }
    }
}

