/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ConceptInfo;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.el.ELTaxonomyBuilder;
import com.clarkparsia.pellet.el.RoleChainCache;
import com.clarkparsia.pellet.el.RoleRestrictionCache;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class SimplifiedELClassifier
extends CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    public static final Logger logger = Logger.getLogger(SimplifiedELClassifier.class.getName());
    public final Timers timers = new Timers();
    private static final boolean PREPROCESS_DOMAINS = false;
    private static final boolean MATERIALIZE_SUPER_PROPERTIES = false;
    private ConceptInfo TOP;
    private ConceptInfo BOTTOM;
    private boolean hasComplexRoles;
    private Queue<QueueElement> primaryQueue;
    private Map<ATermAppl, ConceptInfo> concepts;
    private MultiValueMap<ATermAppl, ConceptInfo> existentials;
    private MultiValueMap<ConceptInfo, ConceptInfo> conjunctions;
    private RoleChainCache roleChains;
    private RoleRestrictionCache roleRestrictions;

    @Override
    protected void reset() {
        super.reset();
        this.hasComplexRoles = this.kb.getExpressivity().hasTransitivity() || this.kb.getExpressivity().hasComplexSubRoles();
        this.primaryQueue = new LinkedList<QueueElement>();
        this.concepts = CollectionUtils.makeMap();
        this.existentials = new MultiValueMap();
        this.conjunctions = new MultiValueMap();
        this.roleChains = new RoleChainCache(this.kb);
        this.roleRestrictions = new RoleRestrictionCache(this.kb.getRBox());
    }

    @Override
    public boolean classify() {
        logger.fine("Reset");
        this.reset();
        Timer timer = this.timers.startTimer("createConcepts");
        logger.fine("Creating structures");
        this.createConcepts();
        logger.fine("Created structures");
        timer.stop();
        int n = this.primaryQueue.size();
        this.monitor.setProgressTitle("Classifiying");
        this.monitor.setProgressLength(n);
        this.monitor.taskStarted();
        logger.fine("Processing queue");
        timer = this.timers.startTimer("processQueue");
        this.processQueue();
        timer.stop();
        logger.fine("Processed queue");
        if (logger.isLoggable(Level.FINER)) {
            this.print();
        }
        this.monitor.setProgress(n);
        logger.fine("Building hierarchy");
        timer = this.timers.startTimer("buildHierarchy");
        this.taxonomy = new ELTaxonomyBuilder().build(this.concepts);
        timer.stop();
        logger.fine("Builded hierarchy");
        this.monitor.taskFinished();
        return true;
    }

    private void addSuccessor(ConceptInfo conceptInfo, ATermAppl aTermAppl, ConceptInfo conceptInfo2) {
        Role role;
        if (!conceptInfo.addSuccessor(aTermAppl, conceptInfo2)) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Adding " + conceptInfo + " -> " + ATermUtils.toString(aTermAppl) + " -> " + conceptInfo2);
        }
        if (conceptInfo2 == this.BOTTOM) {
            this.addToQueue(conceptInfo, this.BOTTOM);
            return;
        }
        Object object2 = conceptInfo2.getSuperClasses().iterator();
        while (object2.hasNext()) {
            ConceptInfo object3 = object2.next();
            this.addSuccessor(conceptInfo, aTermAppl, object3);
        }
        if (!this.roleChains.isAnon(aTermAppl)) {
            object2 = this.kb.getRole((ATerm)aTermAppl).getSuperRoles();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                role = (Role)iterator.next();
                if (!this.existentials.contains(role.getName(), conceptInfo2)) continue;
                ATermAppl aTermAppl2 = ATermUtils.makeSomeValues((ATerm)role.getName(), (ATerm)conceptInfo2.getConcept());
                this.addToQueue(conceptInfo, this.concepts.get(aTermAppl2));
            }
        }
        if ((object2 = this.roleRestrictions.getDomain(aTermAppl)) != null) {
            this.addToQueue(conceptInfo, this.concepts.get(object2));
        }
        if (this.hasComplexRoles) {
            for (Map.Entry entry : CollectionUtils.makeList(conceptInfo.getPredecessors().entrySet())) {
                role = (ATermAppl)entry.getKey();
                for (ATermAppl aTermAppl3 : this.roleChains.getAllSuperRoles((ATermAppl)role, aTermAppl)) {
                    for (ConceptInfo conceptInfo3 : CollectionUtils.makeList((Collection)entry.getValue())) {
                        this.addSuccessor(conceptInfo3, aTermAppl3, conceptInfo2);
                    }
                }
            }
            for (Map.Entry entry : CollectionUtils.makeList(conceptInfo2.getSuccessors().entrySet())) {
                role = (ATermAppl)entry.getKey();
                for (ATermAppl aTermAppl3 : this.roleChains.getAllSuperRoles(aTermAppl, (ATermAppl)role)) {
                    for (ConceptInfo conceptInfo3 : CollectionUtils.makeList((Collection)entry.getValue())) {
                        this.addSuccessor(conceptInfo, aTermAppl3, conceptInfo3);
                    }
                }
            }
        }
    }

    private void addToQueue(ConceptInfo conceptInfo, ConceptInfo conceptInfo2) {
        if (conceptInfo.addSuperClass(conceptInfo2)) {
            this.primaryQueue.add(new QueueElement(conceptInfo, conceptInfo2));
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Queue " + conceptInfo + " " + conceptInfo2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addSuperClass(ConceptInfo conceptInfo, ConceptInfo conceptInfo2) {
        Role role;
        ATermList aTermList;
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Adding " + conceptInfo + " < " + conceptInfo2);
        }
        if (conceptInfo2 == this.BOTTOM) {
            Iterator<ConceptInfo> iterator = conceptInfo.getPredecessors().flattenedValues();
            while (iterator.hasNext()) {
                this.addToQueue(iterator.next(), conceptInfo2);
            }
            return;
        }
        for (ConceptInfo object22 : conceptInfo2.getSuperClasses()) {
            if (object22.equals(conceptInfo2)) continue;
            this.addToQueue(conceptInfo, object22);
        }
        ATermAppl aTermAppl = conceptInfo2.getConcept();
        if (ATermUtils.isAnd(aTermAppl)) {
            void var4_7;
            ATermList aTermList2 = (ATermList)aTermAppl.getArgument(0);
            while (!var4_7.isEmpty()) {
                object = (ATermAppl)var4_7.getFirst();
                this.addToQueue(conceptInfo, this.concepts.get(object));
                ATermList aTermList3 = var4_7.getNext();
            }
        } else if (ATermUtils.isSomeValues(aTermAppl)) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            object = (ATermAppl)aTermAppl.getArgument(1);
            this.addSuccessor(conceptInfo, aTermAppl2, this.concepts.get(object));
        } else assert (ATermUtils.isPrimitive(aTermAppl));
        Set set = (Set)this.conjunctions.get(conceptInfo2);
        if (set != null) {
            for (ConceptInfo conceptInfo3 : set) {
                aTermList = (ATermList)conceptInfo3.getConcept().getArgument(0);
                while (!aTermList.isEmpty() && conceptInfo.hasSuperClass(this.concepts.get(role = (ATermAppl)aTermList.getFirst()))) {
                    aTermList = aTermList.getNext();
                }
                if (!aTermList.isEmpty()) continue;
                this.addToQueue(conceptInfo, conceptInfo3);
            }
        }
        for (Map.Entry entry : conceptInfo.getPredecessors().entrySet()) {
            aTermList = (ATermAppl)entry.getKey();
            role = this.kb.getRole((ATerm)aTermList);
            if (role == null) continue;
            Set<Role> set2 = role.getSuperRoles();
            for (Role role2 : set2) {
                if (!this.existentials.contains(role2.getName(), conceptInfo2)) continue;
                ATermAppl aTermAppl3 = ATermUtils.makeSomeValues((ATerm)role2.getName(), (ATerm)aTermAppl);
                for (ConceptInfo conceptInfo4 : (Set)entry.getValue()) {
                    this.addToQueue(conceptInfo4, this.concepts.get(aTermAppl3));
                }
            }
        }
    }

    private ConceptInfo createConcept(ATermAppl aTermAppl) {
        ConceptInfo conceptInfo = this.concepts.get(aTermAppl);
        if (conceptInfo == null) {
            conceptInfo = new ConceptInfo(aTermAppl, this.hasComplexRoles, false);
            if (ATermUtils.isAnd(aTermAppl)) {
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList.isEmpty()) {
                    ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                    ConceptInfo conceptInfo2 = this.createConcept(aTermAppl2);
                    this.addToQueue(conceptInfo, conceptInfo2);
                    this.conjunctions.add(conceptInfo2, conceptInfo);
                    aTermList = aTermList.getNext();
                }
            } else if (ATermUtils.isSomeValues(aTermAppl)) {
                ConceptInfo conceptInfo3;
                ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
                if (ATermUtils.isInv(aTermAppl3)) {
                    throw new UnsupportedOperationException("Anonmyous inverse found in restriction: " + ATermUtils.toString(aTermAppl));
                }
                ATermAppl aTermAppl5 = this.roleRestrictions.getRange(aTermAppl3);
                if (aTermAppl5 != null && !((Object)(conceptInfo3 = ATermUtils.makeSimplifiedAnd(Arrays.asList(aTermAppl5, aTermAppl4)))).equals(aTermAppl4)) {
                    ATermAppl aTermAppl6 = ATermUtils.makeSomeValues((ATerm)aTermAppl3, (ATerm)conceptInfo3);
                    conceptInfo = this.createConcept(aTermAppl6);
                    this.concepts.put(aTermAppl, conceptInfo);
                    aTermAppl = aTermAppl6;
                }
                conceptInfo3 = this.createConcept(aTermAppl4);
                this.existentials.add(aTermAppl3, conceptInfo3);
                this.addToQueue(conceptInfo, conceptInfo);
            }
            this.concepts.put(aTermAppl, conceptInfo);
            conceptInfo.addSuperClass(conceptInfo);
            if (this.TOP != null) {
                this.addToQueue(conceptInfo, this.TOP);
            }
        }
        return conceptInfo;
    }

    private void createConceptsFromAxiom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.addToQueue(this.createConcept(aTermAppl), this.createConcept(aTermAppl2));
    }

    private void createDisjointAxiom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.createConcept(aTermAppl);
        this.createConcept(aTermAppl2);
        ATermAppl aTermAppl3 = ATermUtils.makeSimplifiedAnd(Arrays.asList(aTermAppl, aTermAppl2));
        this.createConceptsFromAxiom(aTermAppl3, ATermUtils.BOTTOM);
    }

    private void processAxiom(ATermAppl aTermAppl) {
        AFun aFun = aTermAppl.getAFun();
        if (aFun.equals(ATermUtils.DISJOINTSFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            int n = aTermList.getLength();
            ATermAppl[] aTermApplArray = new ATermAppl[n];
            int n2 = 0;
            while (!aTermList.isEmpty()) {
                aTermApplArray[n2] = ELSyntaxUtils.simplify((ATermAppl)aTermList.getFirst());
                aTermList = aTermList.getNext();
                ++n2;
            }
            for (n2 = 0; n2 < n - 1; ++n2) {
                for (int i = n2 + 1; i < n; ++i) {
                    this.createDisjointAxiom(aTermApplArray[n2], aTermApplArray[i]);
                }
            }
        } else {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(1);
            aTermAppl2 = ELSyntaxUtils.simplify(aTermAppl2);
            aTermAppl3 = ELSyntaxUtils.simplify(aTermAppl3);
            if (aFun.equals(ATermUtils.SUBFUN)) {
                this.createConceptsFromAxiom(aTermAppl2, aTermAppl3);
            } else if (aFun.equals(ATermUtils.EQCLASSFUN)) {
                this.createConceptsFromAxiom(aTermAppl2, aTermAppl3);
                this.createConceptsFromAxiom(aTermAppl3, aTermAppl2);
            } else if (aFun.equals(ATermUtils.DISJOINTFUN)) {
                this.createDisjointAxiom(aTermAppl2, aTermAppl3);
            } else {
                throw new IllegalArgumentException("Axiom " + aTermAppl + " is not EL.");
            }
        }
    }

    private void processAxioms() {
        Collection<ATermAppl> collection = this.kb.getTBox().getAssertedAxioms();
        for (ATermAppl object : collection) {
            this.processAxiom(object);
        }
        for (Role role : this.kb.getRBox().getRoles()) {
            ATermAppl aTermAppl;
            if (!role.isReflexive() || (aTermAppl = this.roleRestrictions.getRange(role.getName())) == null) continue;
            this.createConceptsFromAxiom(ATermUtils.TOP, aTermAppl);
        }
    }

    private void createConcepts() {
        this.TOP = this.createConcept(ATermUtils.TOP);
        this.BOTTOM = this.createConcept(ATermUtils.BOTTOM);
        for (ATermAppl aTermAppl : this.kb.getClasses()) {
            this.createConcept(aTermAppl);
        }
        this.processAxioms();
        logger.fine("Process domain and ranges");
        for (ATermAppl aTermAppl : this.roleRestrictions.getRanges().values()) {
            this.createConcept(aTermAppl);
        }
        for (ATermAppl aTermAppl : this.roleRestrictions.getDomains().values()) {
            this.createConcept(aTermAppl);
        }
    }

    public void print() {
        for (ATermAppl aTermAppl : this.concepts.keySet()) {
            log.finer(aTermAppl + " " + this.concepts.get(aTermAppl).getSuperClasses());
        }
        log.finer("");
        this.roleChains.print();
    }

    private void processQueue() {
        int n = this.primaryQueue.size();
        while (!this.primaryQueue.isEmpty()) {
            int n2 = n - this.primaryQueue.size();
            if (this.monitor.getProgress() < n2) {
                this.monitor.setProgress(n2);
            }
            QueueElement queueElement = this.primaryQueue.remove();
            this.addSuperClass(queueElement.sub, queueElement.sup);
        }
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        return Collections.emptyMap();
    }

    @Override
    public Taxonomy<ATermAppl> getToldTaxonomy() {
        return new Taxonomy<ATermAppl>(this.kb.getTBox().getClasses(), TermFactory.TOP, TermFactory.BOTTOM);
    }

    private static class QueueElement {
        private final ConceptInfo sub;
        private final ConceptInfo sup;

        public QueueElement(ConceptInfo conceptInfo, ConceptInfo conceptInfo2) {
            this.sub = conceptInfo;
            this.sup = conceptInfo2;
        }
    }
}

