/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.datetime;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class RestrictedTimelineDatatype
implements RestrictedDatatype<XMLGregorianCalendar> {
    private static final DatatypeFactory dtFactory;
    private static final Logger log;
    private static final BigInteger SEC_PER_DAY;
    private static final BigInteger SEC_PER_YEAR;
    private static final int TZ_SHIFT;
    protected final Datatype<? extends XMLGregorianCalendar> datatype;
    protected final RestrictedDatatype<XMLGregorianCalendar> empty;
    protected final boolean enumerable;
    protected final boolean finite;
    protected final List<ContinuousRealInterval> nzIntervals;
    protected final QName schemaType;
    protected final List<ContinuousRealInterval> wzIntervals;

    private static Number calendarToReal(XMLGregorianCalendar xMLGregorianCalendar) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xMLGregorianCalendar.getEonAndYear();
        BigInteger bigInteger3 = bigInteger = bigInteger2 == null ? BigInteger.valueOf(1971L) : bigInteger2.subtract(BigInteger.ONE);
        if (bigInteger2 == null) {
            bigInteger2 = BigInteger.valueOf(1972L);
        }
        int n = xMLGregorianCalendar.getMonth() == Integer.MIN_VALUE ? 12 : xMLGregorianCalendar.getMonth();
        int n2 = xMLGregorianCalendar.getDay() == Integer.MIN_VALUE ? RestrictedTimelineDatatype.daysInMonth(bigInteger2, n) - 1 : xMLGregorianCalendar.getDay() - 1;
        int n3 = xMLGregorianCalendar.getHour() == Integer.MIN_VALUE ? 0 : xMLGregorianCalendar.getHour();
        int n4 = xMLGregorianCalendar.getMinute() == Integer.MIN_VALUE ? 0 : xMLGregorianCalendar.getMinute();
        int n5 = xMLGregorianCalendar.getSecond() == Integer.MIN_VALUE ? 0 : xMLGregorianCalendar.getSecond();
        BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
        int n6 = xMLGregorianCalendar.getTimezone();
        if (n6 != Integer.MIN_VALUE) {
            n4 -= n6;
        }
        BigInteger bigInteger4 = SEC_PER_YEAR.multiply(bigInteger);
        bigInteger4 = bigInteger4.add(SEC_PER_DAY.multiply(bigInteger.divide(BigInteger.valueOf(400L)).subtract(bigInteger.divide(BigInteger.valueOf(100L))).add(bigInteger.divide(BigInteger.valueOf(4L)))));
        int n7 = n2;
        for (int i = 1; i < n; ++i) {
            n7 += RestrictedTimelineDatatype.daysInMonth(bigInteger2, i);
        }
        bigInteger4 = bigInteger4.add(BigInteger.valueOf(86400L * (long)n7));
        bigInteger4 = bigInteger4.add(BigInteger.valueOf(3600L * (long)n3 + 60L * (long)n4 + (long)n5));
        if (bigDecimal == null || BigDecimal.ZERO.equals(bigDecimal)) {
            return OWLRealUtils.getCanonicalObject(bigInteger4);
        }
        return new BigDecimal(bigInteger4).add(bigDecimal);
    }

    private static int daysInMonth(BigInteger bigInteger, int n) {
        if (n == 2) {
            if (bigInteger.remainder(BigInteger.valueOf(4L)).equals(BigInteger.ZERO)) {
                if (bigInteger.remainder(BigInteger.valueOf(100L)).equals(BigInteger.ZERO)) {
                    if (bigInteger.remainder(BigInteger.valueOf(400L)).equals(BigInteger.ZERO)) {
                        return 29;
                    }
                    return 28;
                }
                return 29;
            }
            return 28;
        }
        switch (n) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException();
    }

    public static DatatypeFactory getDatatypeFactory() {
        return dtFactory;
    }

    private static ContinuousRealInterval zoneShrink(ContinuousRealInterval continuousRealInterval) {
        Number number;
        Number number2 = continuousRealInterval.boundLower() ? (Number)OWLRealUtils.sum(continuousRealInterval.getLower(), TZ_SHIFT) : (Number)null;
        Number number3 = number = continuousRealInterval.boundUpper() ? (Number)OWLRealUtils.sum(continuousRealInterval.getUpper(), -TZ_SHIFT) : (Number)null;
        if (number2 != null && number != null) {
            int n = OWLRealUtils.compare(number2, number);
            if (n > 0) {
                return null;
            }
            if (n == 0) {
                if (!continuousRealInterval.inclusiveLower() && !continuousRealInterval.inclusiveUpper()) {
                    return null;
                }
                return new ContinuousRealInterval(number2);
            }
        }
        return new ContinuousRealInterval(number2, number, continuousRealInterval.inclusiveLower(), continuousRealInterval.inclusiveUpper());
    }

    public RestrictedTimelineDatatype(Datatype<? extends XMLGregorianCalendar> datatype, QName qName, boolean bl) {
        this.datatype = datatype;
        this.schemaType = qName;
        this.empty = new EmptyRestrictedDatatype<XMLGregorianCalendar>(datatype);
        this.wzIntervals = Collections.singletonList(ContinuousRealInterval.allReals());
        this.nzIntervals = bl ? Collections.emptyList() : Collections.singletonList(ContinuousRealInterval.allReals());
        this.finite = false;
        this.enumerable = false;
    }

    private RestrictedTimelineDatatype(RestrictedTimelineDatatype restrictedTimelineDatatype, List<ContinuousRealInterval> list, List<ContinuousRealInterval> list2) {
        boolean bl;
        this.datatype = restrictedTimelineDatatype.datatype;
        this.empty = restrictedTimelineDatatype.empty;
        this.schemaType = restrictedTimelineDatatype.schemaType;
        this.wzIntervals = Collections.unmodifiableList(list);
        this.nzIntervals = Collections.unmodifiableList(list2);
        if (restrictedTimelineDatatype.finite) {
            this.finite = true;
        } else {
            bl = true;
            for (ContinuousRealInterval continuousRealInterval : list) {
                if (continuousRealInterval.isPoint()) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (ContinuousRealInterval continuousRealInterval : list) {
                    if (continuousRealInterval.isPoint()) continue;
                    bl = false;
                    break;
                }
            }
            this.finite = bl;
        }
        if (restrictedTimelineDatatype.enumerable) {
            this.enumerable = true;
        } else {
            bl = list2.isEmpty();
            if (bl) {
                for (ContinuousRealInterval continuousRealInterval : list) {
                    if (continuousRealInterval.isPoint()) continue;
                    bl = false;
                    break;
                }
            }
            this.enumerable = bl;
        }
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> applyConstrainingFacet(ATermAppl aTermAppl, Object object) throws InvalidConstrainingFacetException {
        ContinuousRealInterval continuousRealInterval;
        ContinuousRealInterval continuousRealInterval2;
        boolean bl;
        Number number;
        boolean bl2;
        Number number2;
        Facet facet = Facet.Registry.get(aTermAppl);
        if (facet == null) {
            String string = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), aTermAppl, object);
            log.severe(string);
            throw new InvalidConstrainingFacetException(string, aTermAppl, object);
        }
        XMLGregorianCalendar xMLGregorianCalendar = null;
        if (object instanceof XMLGregorianCalendar) {
            xMLGregorianCalendar = (XMLGregorianCalendar)object;
        }
        if (xMLGregorianCalendar == null || !this.isValidValue(xMLGregorianCalendar)) {
            String string = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), facet, object);
            log.severe(string);
            throw new InvalidConstrainingFacetException(string, aTermAppl, object);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(facet)) {
            number2 = null;
            bl2 = false;
            number = RestrictedTimelineDatatype.calendarToReal(xMLGregorianCalendar);
            bl = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(facet)) {
            number2 = null;
            bl2 = false;
            number = RestrictedTimelineDatatype.calendarToReal(xMLGregorianCalendar);
            bl = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(facet)) {
            number2 = RestrictedTimelineDatatype.calendarToReal(xMLGregorianCalendar);
            bl2 = false;
            number = null;
            bl = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(facet)) {
            number2 = RestrictedTimelineDatatype.calendarToReal(xMLGregorianCalendar);
            bl2 = true;
            number = null;
            bl = false;
        } else {
            throw new IllegalStateException();
        }
        ContinuousRealInterval continuousRealInterval3 = new ContinuousRealInterval(number2, number, bl2, bl);
        if (xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE) {
            continuousRealInterval2 = continuousRealInterval3;
            continuousRealInterval = RestrictedTimelineDatatype.zoneShrink(continuousRealInterval2);
        } else {
            continuousRealInterval = continuousRealInterval3;
            continuousRealInterval2 = RestrictedTimelineDatatype.zoneShrink(continuousRealInterval);
        }
        boolean bl3 = false;
        ArrayList<ContinuousRealInterval> arrayList = new ArrayList<ContinuousRealInterval>();
        if (continuousRealInterval == null) {
            bl3 = this.wzIntervals.isEmpty();
        } else {
            for (ContinuousRealInterval object2 : this.wzIntervals) {
                ContinuousRealInterval continuousRealInterval4 = object2.intersection(continuousRealInterval);
                if (continuousRealInterval4 != null) {
                    arrayList.add(continuousRealInterval4);
                    if (object2 == continuousRealInterval4) continue;
                    bl3 = true;
                    continue;
                }
                bl3 = true;
            }
        }
        ArrayList arrayList2 = new ArrayList();
        if (continuousRealInterval2 == null) {
            bl3 |= this.nzIntervals.isEmpty();
        } else {
            for (ContinuousRealInterval continuousRealInterval4 : this.nzIntervals) {
                ContinuousRealInterval continuousRealInterval5 = continuousRealInterval4.intersection(continuousRealInterval2);
                if (continuousRealInterval5 != null) {
                    arrayList2.add(continuousRealInterval5);
                    if (continuousRealInterval4 == continuousRealInterval5) continue;
                    bl3 = true;
                    continue;
                }
                bl3 = true;
            }
        }
        if (bl3) {
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return this.empty;
            }
            return this.create(this, arrayList, arrayList2);
        }
        return this;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)object;
            if (this.isValidValue(xMLGregorianCalendar)) {
                Number number = RestrictedTimelineDatatype.calendarToReal(xMLGregorianCalendar);
                for (ContinuousRealInterval continuousRealInterval : xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? this.nzIntervals : this.wzIntervals) {
                    if (!continuousRealInterval.contains(number)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this.finite || n <= 0) {
            return true;
        }
        Number number = 0;
        for (int i = 0; i < this.wzIntervals.size(); ++i) {
            number = OWLRealUtils.integerSum(number, 1681);
            if (OWLRealUtils.compare(n, number) > 0) continue;
            return true;
        }
        return false;
    }

    protected RestrictedTimelineDatatype create(RestrictedTimelineDatatype restrictedTimelineDatatype, List<ContinuousRealInterval> list, List<ContinuousRealInterval> list2) {
        return new RestrictedTimelineDatatype(restrictedTimelineDatatype, list, list2);
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> exclude(Collection<?> collection) {
        boolean bl = false;
        ArrayList<ContinuousRealInterval> arrayList = new ArrayList<ContinuousRealInterval>(this.nzIntervals);
        block0: for (Object obj : collection) {
            if (!(obj instanceof XMLGregorianCalendar)) continue;
            XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)obj;
            if (xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE) {
                Number number = RestrictedTimelineDatatype.calendarToReal(xMLGregorianCalendar);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ContinuousRealInterval continuousRealInterval;
                    ContinuousRealInterval continuousRealInterval2 = (ContinuousRealInterval)iterator.next();
                    if (!continuousRealInterval2.contains(number)) continue;
                    bl = true;
                    iterator.remove();
                    ContinuousRealInterval continuousRealInterval3 = continuousRealInterval2.less(number);
                    if (continuousRealInterval3 != null) {
                        arrayList.add(continuousRealInterval3);
                    }
                    if ((continuousRealInterval = continuousRealInterval2.greater(number)) == null) continue block0;
                    arrayList.add(continuousRealInterval);
                    continue block0;
                }
                continue;
            }
            log.warning("Exclusion of time zoned constants is not supported");
        }
        if (bl) {
            if (arrayList.isEmpty() && this.wzIntervals.isEmpty()) {
                return this.empty;
            }
            return this.create(this, this.wzIntervals, arrayList);
        }
        return this;
    }

    @Override
    public Datatype<? extends XMLGregorianCalendar> getDatatype() {
        return this.datatype;
    }

    @Override
    public XMLGregorianCalendar getValue(int n) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RestrictedDatatype<XMLGregorianCalendar> intersect(RestrictedDatatype<?> restrictedDatatype, boolean bl) {
        if (restrictedDatatype instanceof RestrictedTimelineDatatype) {
            Object object;
            Iterator<ContinuousRealInterval> iterator;
            Object object3;
            RestrictedTimelineDatatype restrictedTimelineDatatype = (RestrictedTimelineDatatype)restrictedDatatype;
            ArrayList<ContinuousRealInterval> arrayList2 = new ArrayList<ContinuousRealInterval>();
            if (bl) {
                object3 = new ArrayList<ContinuousRealInterval>(Arrays.asList(ContinuousRealInterval.allReals()));
                for (ContinuousRealInterval arrayList3 : restrictedTimelineDatatype.wzIntervals) {
                    iterator = new ArrayList();
                    Iterator<ContinuousRealInterval> iterator2 = object3.iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        iterator.addAll(((ContinuousRealInterval)object).remove(arrayList3));
                    }
                    object3 = iterator;
                }
            } else {
                object3 = restrictedTimelineDatatype.wzIntervals;
            }
            for (ContinuousRealInterval continuousRealInterval : this.wzIntervals) {
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    ContinuousRealInterval continuousRealInterval2 = iterator.next();
                    object = continuousRealInterval.intersection(continuousRealInterval2);
                    if (object == null) continue;
                    arrayList2.add((ContinuousRealInterval)object);
                }
            }
            Iterator<ContinuousRealInterval> iterator2 = new ArrayList();
            if (bl) {
                ArrayList<ContinuousRealInterval> arrayList = new ArrayList<ContinuousRealInterval>(Arrays.asList(ContinuousRealInterval.allReals()));
                for (ContinuousRealInterval continuousRealInterval : restrictedTimelineDatatype.nzIntervals) {
                    void var7_11;
                    object = new ArrayList<ContinuousRealInterval>();
                    for (ContinuousRealInterval continuousRealInterval3 : var7_11) {
                        object.addAll(continuousRealInterval3.remove(continuousRealInterval));
                    }
                    ArrayList<ContinuousRealInterval> arrayList3 = object;
                }
            } else {
                List<ContinuousRealInterval> list = restrictedTimelineDatatype.nzIntervals;
            }
            for (ContinuousRealInterval continuousRealInterval : this.nzIntervals) {
                void var7_14;
                for (ContinuousRealInterval continuousRealInterval4 : var7_14) {
                    ContinuousRealInterval continuousRealInterval3;
                    continuousRealInterval3 = continuousRealInterval.intersection(continuousRealInterval4);
                    if (continuousRealInterval3 == null) continue;
                    iterator2.add(continuousRealInterval3);
                }
            }
            if (arrayList2.equals(this.wzIntervals) && iterator2.equals(this.nzIntervals)) {
                return this;
            }
            if (arrayList2.isEmpty() && iterator2.isEmpty()) {
                return this.empty;
            }
            return this.create(this, (List<ContinuousRealInterval>)arrayList2, (List<ContinuousRealInterval>)((Object)iterator2));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    protected boolean isValidValue(XMLGregorianCalendar xMLGregorianCalendar) {
        return this.schemaType.equals(xMLGregorianCalendar.getXMLSchemaType());
    }

    @Override
    public int size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        Number number = 0;
        for (int i = 0; i < this.wzIntervals.size(); ++i) {
            number = OWLRealUtils.integerSum(number, 1681);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, number) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return number;
    }

    public String toString() {
        return String.format("{%s,%s,%s}", this.datatype, this.wzIntervals, this.nzIntervals);
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> union(RestrictedDatatype<?> restrictedDatatype) {
        if (restrictedDatatype instanceof RestrictedTimelineDatatype) {
            Object object;
            ArrayList<Object> arrayList;
            RestrictedTimelineDatatype restrictedTimelineDatatype = (RestrictedTimelineDatatype)restrictedDatatype;
            ArrayList<ContinuousRealInterval> arrayList2 = new ArrayList<ContinuousRealInterval>(this.wzIntervals);
            for (ContinuousRealInterval object3 : restrictedTimelineDatatype.wzIntervals) {
                ArrayList arrayList3 = new ArrayList();
                arrayList = arrayList2.iterator();
                while (arrayList.hasNext()) {
                    object = (ContinuousRealInterval)arrayList.next();
                    if (!object3.canUnionWith((ContinuousRealInterval)object)) continue;
                    arrayList.remove();
                    arrayList3.add(object);
                }
                if (arrayList3.isEmpty()) {
                    arrayList2.add(object3);
                    continue;
                }
                arrayList = new HashSet();
                for (Object object2 : arrayList3) {
                    arrayList.addAll(object3.union((ContinuousRealInterval)object2));
                }
                arrayList2.addAll(arrayList);
            }
            ArrayList<ContinuousRealInterval> arrayList3 = new ArrayList<ContinuousRealInterval>(this.nzIntervals);
            for (ContinuousRealInterval continuousRealInterval : restrictedTimelineDatatype.nzIntervals) {
                arrayList = new ArrayList<Object>();
                object = arrayList3.iterator();
                while (object.hasNext()) {
                    Object object2;
                    object2 = (ContinuousRealInterval)object.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)object2)) continue;
                    object.remove();
                    arrayList.add(object2);
                }
                if (arrayList.isEmpty()) {
                    arrayList3.add(continuousRealInterval);
                    continue;
                }
                object = new HashSet();
                for (ContinuousRealInterval continuousRealInterval2 : arrayList) {
                    object.addAll(continuousRealInterval.union(continuousRealInterval2));
                }
                arrayList3.addAll((Collection<ContinuousRealInterval>)object);
            }
            return this.create(this, arrayList2, (List<ContinuousRealInterval>)arrayList3);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<XMLGregorianCalendar> valueIterator() {
        throw new UnsupportedOperationException();
    }

    static {
        log = Logger.getLogger(RestrictedTimelineDatatype.class.getCanonicalName());
        SEC_PER_DAY = BigInteger.valueOf(86400L);
        SEC_PER_YEAR = BigInteger.valueOf(31536000L);
        TZ_SHIFT = 50400;
        try {
            dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            log.severe("Failure initializing restricted timeline datatype support.");
            throw new InternalReasonerException("Failure initializing restricted timeline datatype support.", datatypeConfigurationException);
        }
    }
}

