/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.io;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.ModuleExtractorFactory;
import com.clarkparsia.modularity.io.TaxonomyPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;

public class IncrementalClassifierPersistence {
    private static final String TAXONOMY_FILE_NAME = "Taxonomy";
    private static final String PROPERTIES_FILE_NAME = "Properties";
    private static final String PROPERTIES_FILE_COMMENT = "Properties of the IncrementalClassifier";
    private static final String REALIZED_PROPERTY = "realized";

    public static void save(IncrementalClassifier incrementalClassifier, OutputStream outputStream) throws IOException {
        IncrementalClassifier.PersistedState persistedState = new IncrementalClassifier.PersistedState(incrementalClassifier);
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        persistedState.getModuleExtractor().save(zipOutputStream);
        ZipEntry zipEntry = new ZipEntry(TAXONOMY_FILE_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        TaxonomyPersistence.save(persistedState.getTaxonomy(), new UncloseableOutputStream(zipOutputStream));
        ZipEntry zipEntry2 = new ZipEntry(PROPERTIES_FILE_NAME);
        zipOutputStream.putNextEntry(zipEntry2);
        Properties properties = new Properties();
        properties.setProperty(REALIZED_PROPERTY, String.valueOf(persistedState.isRealized()));
        properties.store(zipOutputStream, PROPERTIES_FILE_COMMENT);
        zipOutputStream.finish();
    }

    public static IncrementalClassifier load(InputStream inputStream) throws IOException {
        return IncrementalClassifierPersistence.load(inputStream, null);
    }

    public static IncrementalClassifier load(InputStream inputStream, OWLOntology oWLOntology) throws IOException {
        ModuleExtractor moduleExtractor = null;
        Taxonomy<OWLClass> taxonomy = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        moduleExtractor = ModuleExtractorFactory.createModuleExtractor();
        moduleExtractor.load(zipInputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (!TAXONOMY_FILE_NAME.equals(zipEntry.getName())) {
            throw new IOException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), TAXONOMY_FILE_NAME));
        }
        taxonomy = TaxonomyPersistence.load(zipInputStream);
        Properties properties = new Properties();
        zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null && PROPERTIES_FILE_NAME.equals(zipEntry.getName())) {
            properties.load(zipInputStream);
        }
        boolean bl = Boolean.valueOf(properties.getProperty(REALIZED_PROPERTY, "false"));
        IncrementalClassifier.PersistedState persistedState = new IncrementalClassifier.PersistedState(moduleExtractor, taxonomy, bl);
        if (oWLOntology != null) {
            return new IncrementalClassifier(persistedState, oWLOntology);
        }
        return new IncrementalClassifier(persistedState);
    }
}

