/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.OntBuilder;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.BuiltinTerm;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.PelletGraphListener;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.SimpleUnion;
import org.mindswap.pellet.jena.graph.converter.AxiomConverter;
import org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.jena.graph.query.GraphQueryHandler;
import org.mindswap.pellet.utils.ATermUtils;

public class PelletInfGraph
extends BaseInfGraph
implements InfGraph {
    public static final Logger log = Logger.getLogger(PelletInfGraph.class.getName());
    private static final Triple INCONCISTENCY_TRIPLE = Triple.create((Node)OWL.Thing.asNode(), (Node)RDFS.subClassOf.asNode(), (Node)OWL.Nothing.asNode());
    private GraphLoader loader;
    protected KnowledgeBase kb;
    private final ModelExtractor extractor;
    private PelletGraphListener graphListener;
    private Graph deductionsGraph;
    private boolean autoDetectChanges;

    public PelletInfGraph(KnowledgeBase knowledgeBase, PelletReasoner pelletReasoner, GraphLoader graphLoader) {
        this(knowledgeBase, Factory.createDefaultGraph(), pelletReasoner, graphLoader);
    }

    public PelletInfGraph(Graph graph, PelletReasoner pelletReasoner, GraphLoader graphLoader) {
        this(new KnowledgeBase(), graph, pelletReasoner, graphLoader);
    }

    private PelletInfGraph(KnowledgeBase knowledgeBase, Graph graph, PelletReasoner pelletReasoner, GraphLoader graphLoader) {
        super(graph, (Reasoner)pelletReasoner);
        this.kb = knowledgeBase;
        this.loader = graphLoader;
        this.extractor = new ModelExtractor(knowledgeBase);
        this.extractor.setSelector(ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS);
        this.graphListener = new PelletGraphListener(graph, knowledgeBase);
        graphLoader.setKB(knowledgeBase);
        this.rebind();
    }

    public GraphLoader attachTemporaryGraph(Graph graph) {
        GraphLoader graphLoader = this.loader;
        SimpleUnion simpleUnion = (SimpleUnion)graphLoader.getGraph();
        simpleUnion.addGraph(graph);
        this.loader = new DefaultGraphLoader();
        this.loader.setGraph((Graph)simpleUnion);
        this.loader.setKB(this.kb);
        this.loader.preprocess();
        return graphLoader;
    }

    public void detachTemporaryGraph(Graph graph, GraphLoader graphLoader) {
        SimpleUnion simpleUnion = (SimpleUnion)this.loader.getGraph();
        simpleUnion.removeGraph(graph);
        this.loader = graphLoader;
    }

    public ExtendedIterator<Triple> find(Node node, Node node2, Node node3, Graph graph) {
        this.prepare();
        GraphLoader graphLoader = this.attachTemporaryGraph(graph);
        ExtendedIterator extendedIterator = this.graphBaseFind(node, node2, node3);
        this.detachTemporaryGraph(graph, graphLoader);
        return extendedIterator;
    }

    public ExtendedIterator<Triple> findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.prepare();
        Node node = triplePattern.getSubject();
        Node node2 = triplePattern.getPredicate();
        Node node3 = triplePattern.getObject();
        ExtendedIterator extendedIterator = GraphQueryHandler.findTriple(this.kb, this.loader, node, node2, node3);
        if (finder != null) {
            TriplePattern triplePattern2 = new TriplePattern(node, node2, node3);
            extendedIterator = extendedIterator.andThen((Iterator)finder.find(triplePattern2));
        }
        return UniqueExtendedIterator.create(extendedIterator);
    }

    public Graph getSchemaGraph() {
        return ((PelletReasoner)this.getReasoner()).getSchema();
    }

    public boolean isPrepared() {
        return this.isPrepared && (!this.autoDetectChanges || !this.graphListener.isChanged());
    }

    private void load() {
        Set<Graph> set;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading triples");
        }
        if ((set = this.graphListener.getChangedGraphs()) == null) {
            this.reload();
        } else {
            this.load(set);
        }
    }

    public void reload() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Clearing the KB and reloading");
        }
        this.clear();
        Set<Graph> set = this.graphListener.getLeafGraphs();
        Graph graph = this.getSchemaGraph();
        if (graph != null) {
            set = new HashSet<Graph>(set);
            set.add(graph);
        }
        this.load(set);
    }

    private void load(Iterable<Graph> iterable) {
        this.loader.load(iterable);
        this.loader.setGraph((Graph)new SimpleUnion(this.graphListener.getLeafGraphs()));
        this.graphListener.reset();
        this.deductionsGraph = null;
    }

    public void prepare() {
        this.prepare(true);
    }

    public void prepare(boolean bl) {
        if (this.isPrepared()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preparing PelletInfGraph...");
        }
        this.load();
        this.kb.prepare();
        if (bl) {
            this.kb.isConsistent();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("done.");
        }
        this.isPrepared = true;
    }

    public boolean isConsistent() {
        this.prepare();
        return this.kb.isConsistent();
    }

    public boolean isClassified() {
        return this.isPrepared && this.kb.isClassified();
    }

    public boolean isRealized() {
        return this.isPrepared && this.kb.isRealized();
    }

    public void classify() {
        this.prepare();
        this.kb.classify();
    }

    public void realize() {
        this.prepare();
        this.kb.realize();
    }

    public Graph getDeductionsGraph() {
        if (!PelletOptions.RETURN_DEDUCTIONS_GRAPH) {
            return null;
        }
        this.classify();
        if (this.deductionsGraph == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Realizing PelletInfGraph...");
            }
            this.kb.realize();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Extract model...");
            }
            Model model = this.extractor.extractModel();
            this.deductionsGraph = model.getGraph();
            if (log.isLoggable(Level.FINE)) {
                log.fine("done.");
            }
        }
        return this.deductionsGraph;
    }

    protected boolean graphBaseContains(Triple triple) {
        if (this.getRawGraph().contains(triple)) {
            return true;
        }
        return this.containsTriple(triple);
    }

    public boolean entails(Triple triple) {
        this.prepare();
        if (this.isSyntaxTriple(triple)) {
            return true;
        }
        if (this.isBnodeTypeQuery(triple)) {
            return !this.containsTriple(Triple.create((Node)triple.getObject(), (Node)RDFS.subClassOf.asNode(), (Node)OWL.Nothing.asNode()));
        }
        return this.containsTriple(triple);
    }

    public Model explainInconsistency() {
        return this.explainTriple(INCONCISTENCY_TRIPLE);
    }

    public Model explain(Statement statement) {
        return this.explainTriple(statement.asTriple());
    }

    public Model explain(Resource resource, Property property, RDFNode rDFNode) {
        return this.explainTriple(Triple.create((Node)resource.asNode(), (Node)property.asNode(), (Node)rDFNode.asNode()));
    }

    private Model explainTriple(Triple triple) {
        Graph graph = this.explain(triple);
        return graph == null ? null : ModelFactory.createModelForGraph((Graph)graph);
    }

    public Graph explain(Triple triple) {
        if (!triple.equals((Object)INCONCISTENCY_TRIPLE)) {
            if (!triple.isConcrete()) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("Triple patterns with variables cannot be epxlained: " + triple);
                }
                return null;
            }
            if (this.isSyntaxTriple(triple)) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("Syntax triples cannot be explained: " + triple);
                }
                return null;
            }
        }
        this.prepare();
        Graph graph = Factory.createDefaultGraph();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explain " + triple);
        }
        if (PelletInfGraph.checkEntailment(this, triple, true)) {
            Set<ATermAppl> set = this.kb.getExplanationSet();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Explanation " + PelletInfGraph.formatAxioms(set));
            }
            Set<ATermAppl> set2 = this.pruneExplanation(triple, set);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Pruned " + PelletInfGraph.formatAxioms(set2));
            }
            AxiomConverter axiomConverter = new AxiomConverter(this.kb, graph);
            for (ATermAppl aTermAppl : set2) {
                axiomConverter.convert(aTermAppl);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explanation " + graph);
        }
        return graph;
    }

    private Set<ATermAppl> pruneExplanation(Triple triple, Set<ATermAppl> set) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>(set);
        OntBuilder ontBuilder = new OntBuilder(this.kb);
        DefaultGraphLoader defaultGraphLoader = new DefaultGraphLoader();
        for (ATermAppl aTermAppl : set) {
            hashSet.remove(aTermAppl);
            KnowledgeBase knowledgeBase = ontBuilder.build(hashSet);
            PelletInfGraph pelletInfGraph = new PelletInfGraph(knowledgeBase, (PelletReasoner)this.getReasoner(), (GraphLoader)defaultGraphLoader);
            if (!PelletInfGraph.checkEntailment(pelletInfGraph, triple, false)) {
                hashSet.add(aTermAppl);
                continue;
            }
            if (!log.isLoggable(Level.FINER)) continue;
            log.finer("Prune from explanation " + ATermUtils.toString(aTermAppl));
        }
        return hashSet;
    }

    private static boolean checkEntailment(PelletInfGraph pelletInfGraph, Triple triple, boolean bl) {
        boolean bl2 = pelletInfGraph.getKB().doExplanation();
        pelletInfGraph.getKB().setDoExplanation(bl);
        boolean bl3 = false;
        bl3 = triple.equals((Object)INCONCISTENCY_TRIPLE) ? !pelletInfGraph.isConsistent() : pelletInfGraph.containsTriple(triple);
        pelletInfGraph.getKB().setDoExplanation(bl2);
        return bl3;
    }

    private static String formatAxioms(Set<ATermAppl> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (ATermAppl aTermAppl : set) {
            stringBuilder.append(ATermUtils.toString(aTermAppl));
            stringBuilder.append(",");
        }
        if (set.isEmpty()) {
            stringBuilder.append(']');
        } else {
            stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        }
        return stringBuilder.toString();
    }

    protected boolean containsTriple(Triple triple) {
        this.prepare();
        Node node = triple.getSubject();
        Node node2 = triple.getPredicate();
        Node node3 = triple.getObject();
        return GraphQueryHandler.containsTriple(this.kb, this.loader, node, node2, node3);
    }

    private boolean isSyntaxTriple(Triple triple) {
        BuiltinTerm builtinTerm = BuiltinTerm.find(triple.getPredicate());
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                return true;
            }
            if (BuiltinTerm.isExpression(builtinTerm) && (triple.getSubject().isBlank() || triple.getObject().isBlank())) {
                return true;
            }
            if (builtinTerm.equals((Object)BuiltinTerm.RDF_type)) {
                builtinTerm = BuiltinTerm.find(triple.getObject());
                return builtinTerm != null && builtinTerm.isSyntax();
            }
        }
        return false;
    }

    private boolean isBnodeTypeQuery(Triple triple) {
        return triple.getSubject().isBlank() && triple.getPredicate().equals((Object)RDF.type.asNode()) && (BuiltinTerm.find(triple.getObject()) == null || triple.getObject().equals((Object)OWL.Thing.asNode()) || triple.getObject().equals((Object)OWL.Nothing.asNode()));
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public KnowledgeBase getPreparedKB() {
        this.prepare();
        return this.getKB();
    }

    public void performAdd(Triple triple) {
        this.fdata.getGraph().add(triple);
        this.isPrepared = false;
    }

    public void performDelete(Triple triple) {
        this.fdata.getGraph().delete(triple);
        this.isPrepared = false;
    }

    public ValidityReport validate() {
        this.checkOpen();
        this.prepare();
        StandardValidityReport standardValidityReport = new StandardValidityReport();
        this.kb.setDoExplanation(true);
        boolean bl = this.kb.isConsistent();
        this.kb.setDoExplanation(false);
        if (!bl) {
            standardValidityReport.add(true, "KB is inconsistent!", this.kb.getExplanation());
        } else {
            for (ATermAppl aTermAppl : this.kb.getUnsatisfiableClasses()) {
                String string = JenaUtils.makeGraphNode(aTermAppl).toString();
                standardValidityReport.add(false, "Unsatisfiable class", string);
            }
        }
        return standardValidityReport;
    }

    public void clear() {
        this.kb.clear();
        this.loader.clear();
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        if (this.closed) {
            return;
        }
        if (bl) {
            super.close();
        } else {
            this.closed = true;
        }
        if (this.deductionsGraph != null) {
            this.deductionsGraph.close();
            this.deductionsGraph = null;
        }
        this.clear();
        this.graphListener.dispose();
        this.graphListener = null;
        this.kb = null;
    }

    public GraphLoader getLoader() {
        return this.loader;
    }

    public boolean isAutoDetectChanges() {
        return this.autoDetectChanges;
    }

    public void setAutoDetectChanges(boolean bl) {
        this.autoDetectChanges = bl;
    }
}

