/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorByType;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformWrapper;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.optimize.ExprTransformApplyTransform;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;

public class Transformer {
    private static Transformer singleton = new Transformer();

    public static Transformer get() {
        return singleton;
    }

    public static void set(Transformer value) {
        singleton = value;
    }

    public static Op transform(Transform transform, Op op) {
        return Transformer.get().transformation(transform, op, null, null);
    }

    public static Op transform(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, op, beforeVisitor, afterVisitor);
    }

    public static Op transformSkipService(Transform transform, Op op) {
        return Transformer.transformSkipService(transform, op, null, null);
    }

    public static Op transformSkipService(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        TransformSkipService walker = new TransformSkipService(transform);
        ExprTransformApplyTransform exprTransform = new ExprTransformApplyTransform(transform, beforeVisitor, afterVisitor);
        return Transformer.transform(walker, op, beforeVisitor, afterVisitor);
    }

    public static Op transformOne(Transform transform, Op op) {
        OpTransformApplyOne visitor = new OpTransformApplyOne(transform);
        op.visit(visitor);
        return visitor.result;
    }

    protected Op transformation(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ExprTransformApplyTransform exprTransform = new ExprTransformApplyTransform(transform, beforeVisitor, afterVisitor);
        ApplyTransformVisitor v = new ApplyTransformVisitor(transform, exprTransform);
        return this.transformation(v, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            Log.warn(this, "Attempt to transform a null Op - ignored");
            return op;
        }
        return this.applyTransformation(transformApply, op, beforeVisitor, afterVisitor);
    }

    protected Op applyTransformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        OpWalker.walk(op, transformApply, beforeVisitor, afterVisitor);
        Op r = transformApply.result();
        return r;
    }

    protected Transformer() {
    }

    static class OpTransformApplyOne
    extends OpVisitorByType {
        private final Transform transform;
        Op result;

        OpTransformApplyOne(Transform transform) {
            this.transform = transform;
        }

        @Override
        protected void visitN(OpN op) {
            this.result = op.apply(this.transform, op.getElements());
        }

        @Override
        protected void visit2(Op2 op) {
            this.result = op.apply(this.transform, op.getLeft(), op.getRight());
        }

        @Override
        protected void visit1(Op1 op) {
            this.result = op.apply(this.transform, op.getSubOp());
        }

        @Override
        protected void visit0(Op0 op) {
            this.result = op.apply(this.transform);
        }

        @Override
        protected void visitFilter(OpFilter op) {
            this.result = op.apply(this.transform, op.getSubOp());
        }

        @Override
        protected void visitExt(OpExt op) {
            this.result = op.apply(this.transform);
        }
    }

    static class TransformSkipService
    extends TransformWrapper {
        public TransformSkipService(Transform transform) {
            super(transform);
        }

        @Override
        public Op transform(OpService opService, Op subOp) {
            return opService;
        }
    }

    static class WalkerVisitorSkipService
    extends OpWalker.WalkerVisitor {
        public WalkerVisitorSkipService(OpVisitor visitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
            super(visitor, beforeVisitor, afterVisitor);
        }

        public WalkerVisitorSkipService(OpVisitor visitor) {
            super(visitor);
        }

        @Override
        public void visit(OpService op) {
            this.before(op);
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }

    static class ApplyTransformVisitorServiceAsLeaf
    extends ApplyTransformVisitor {
        public ApplyTransformVisitorServiceAsLeaf(Transform transform, ExprTransform exprTransform) {
            super(transform, exprTransform);
        }

        @Override
        public void visit(OpService op) {
            this.push(op);
        }
    }

    public static class ApplyTransformVisitor
    extends OpVisitorByType {
        protected final Transform transform;
        private final ExprTransform exprTransform;
        private final Deque<Op> stack = new ArrayDeque<Op>();

        protected final Op pop() {
            return this.stack.pop();
        }

        protected final void push(Op op) {
            this.stack.push(op);
        }

        public ApplyTransformVisitor(Transform transform, ExprTransform exprTransform) {
            this.transform = transform;
            this.exprTransform = exprTransform;
        }

        final Op result() {
            if (this.stack.size() != 1) {
                Log.warn(this, "Stack is not aligned");
            }
            return this.pop();
        }

        private ExprList transform(ExprList exprList, ExprTransform exprTransform) {
            if (exprList == null || exprTransform == null) {
                return exprList;
            }
            return ExprTransformer.transform(exprTransform, exprList);
        }

        private Expr transform(Expr expr, ExprTransform exprTransform) {
            if (expr == null || exprTransform == null) {
                return expr;
            }
            return ExprTransformer.transform(exprTransform, expr);
        }

        @Override
        public void visit(OpOrder opOrder) {
            List<SortCondition> conditions = opOrder.getConditions();
            ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
            boolean changed = false;
            for (SortCondition sc : conditions) {
                Expr e2 = sc.getExpression();
                Expr e22 = this.transform(e2, this.exprTransform);
                conditions2.add(new SortCondition(e22, sc.getDirection()));
                if (e2 == e22) continue;
                changed = true;
            }
            OpOrder x = opOrder;
            if (changed) {
                x = new OpOrder(opOrder.getSubOp(), conditions2);
            }
            this.visit1(x);
        }

        @Override
        public void visit(OpAssign opAssign) {
            VarExprList varExpr = opAssign.getVarExprList();
            VarExprList varExpr2 = this.process(varExpr);
            OpAssign opAssign2 = opAssign;
            if (varExpr != varExpr2) {
                opAssign2 = OpAssign.assignDirect(opAssign.getSubOp(), varExpr2);
            }
            this.visit1(opAssign2);
        }

        @Override
        public void visit(OpExtend opExtend) {
            VarExprList varExpr = opExtend.getVarExprList();
            VarExprList varExpr2 = this.process(varExpr);
            OpExtend opExtend2 = opExtend;
            if (varExpr != varExpr2) {
                opExtend2 = OpExtend.extendDirect(opExtend.getSubOp(), varExpr2);
            }
            this.visit1(opExtend2);
        }

        private VarExprList process(VarExprList varExpr) {
            List<Var> vars = varExpr.getVars();
            VarExprList varExpr2 = new VarExprList();
            boolean changed = false;
            for (Var v : vars) {
                Expr e2;
                Expr e22 = e2 = varExpr.getExpr(v);
                if (e2 != null) {
                    e22 = this.transform(e2, this.exprTransform);
                }
                if (e22 == null) {
                    varExpr2.add(v);
                } else {
                    varExpr2.add(v, e22);
                }
                if (e2 == e22) continue;
                changed = true;
            }
            if (!changed) {
                return varExpr;
            }
            return varExpr2;
        }

        @Override
        public void visit(OpGroup opGroup) {
            List<ExprAggregator> aggs;
            VarExprList varExpr2;
            boolean changed = false;
            VarExprList varExpr = opGroup.getGroupVars();
            if (varExpr != (varExpr2 = this.process(varExpr))) {
                changed = true;
            }
            List<ExprAggregator> aggs2 = aggs = opGroup.getAggregators();
            aggs2 = new ArrayList<ExprAggregator>();
            for (ExprAggregator agg : aggs) {
                Expr e2;
                Expr eVar2;
                Aggregator aggregator = agg.getAggregator();
                Var v = agg.getVar();
                ExprVar eVar = agg.getAggVar();
                if (eVar != (eVar2 = this.transform(eVar, this.exprTransform))) {
                    changed = true;
                }
                Expr e22 = e2 = aggregator.getExpr();
                if (e2 != null) {
                    e22 = this.transform(e2, this.exprTransform);
                }
                if (e2 != e22) {
                    changed = true;
                }
                Aggregator a2 = aggregator.copy(e22);
                aggs2.add(new ExprAggregator(eVar2.asVar(), a2));
            }
            OpGroup opGroup2 = opGroup;
            if (changed) {
                opGroup2 = new OpGroup(opGroup.getSubOp(), varExpr2, aggs2);
            }
            this.visit1(opGroup2);
        }

        @Override
        protected void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        @Override
        protected void visit1(Op1 op) {
            Op subOp = null;
            if (op.getSubOp() != null) {
                subOp = this.pop();
            }
            this.push(op.apply(this.transform, subOp));
        }

        @Override
        protected void visit2(Op2 op) {
            Op left = null;
            Op right = null;
            if (op.getRight() != null) {
                right = this.pop();
            }
            if (op.getLeft() != null) {
                left = this.pop();
            }
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        @Override
        protected void visitN(OpN op) {
            ArrayList<Op> x = new ArrayList<Op>(op.size());
            Iterator<Op> iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = iter.next();
                Op r = this.pop();
                if (r == null) continue;
                x.add(0, r);
            }
            Op opX = op.apply(this.transform, x);
            this.push(opX);
        }

        @Override
        protected void visitFilter(OpFilter opFilter) {
            Op subOp = null;
            if (opFilter.getSubOp() != null) {
                subOp = this.pop();
            }
            boolean changed = opFilter.getSubOp() != subOp;
            ExprList ex = new ExprList();
            for (Expr e2 : opFilter.getExprs()) {
                Expr e22 = this.transform(e2, this.exprTransform);
                ex.add(e22);
                if (e2 == e22) continue;
                changed = true;
            }
            OpFilter f = opFilter;
            if (changed) {
                f = (OpFilter)OpFilter.filter(ex, subOp);
            }
            this.push(f.apply(this.transform, subOp));
        }

        @Override
        protected void visitExt(OpExt op) {
            this.push(this.transform.transform(op));
        }
    }
}

