/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class DataMaxCardinalityTranslator
extends AbstractClassExpressionTranslator {
    public DataMaxCardinalityTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean matchesStrict(IRI mainNode) {
        return this.isRestrictionStrict(mainNode) && this.isNonNegativeIntegerStrict(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isDataPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
    }

    @Override
    public boolean matchesLax(IRI mainNode) {
        return this.isNonNegativeIntegerLax(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY) && this.isDataPropertyLax(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY);
    }

    @Override
    public OWLDataMaxCardinality translate(IRI mainNode) {
        this.getConsumer().consumeTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        int cardi = this.translateInteger(mainNode, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
        OWLDataPropertyExpression property = this.getConsumer().translateDataPropertyExpression(propertyIRI);
        IRI fillerIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_RANGE, true);
        if (fillerIRI != null && !this.getConsumer().getConfiguration().isStrict()) {
            OWLDataRange filler = this.getConsumer().translateDataRange(fillerIRI);
            return this.getDataFactory().getOWLDataMaxCardinality(cardi, property, filler);
        }
        return this.getDataFactory().getOWLDataMaxCardinality(cardi, property);
    }
}

