/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.iterator.PairIterator;

public class CandidateSet<T> {
    private Set<T> knowns;
    private Set<T> unknowns;

    public CandidateSet() {
        this.knowns = new HashSet<T>();
        this.unknowns = new HashSet<T>();
    }

    public CandidateSet(Set<T> set) {
        this.knowns = new HashSet<T>(set);
        this.unknowns = new HashSet<T>();
    }

    public CandidateSet(Set<T> set, Set<T> set2) {
        this.knowns = new HashSet<T>(set);
        this.unknowns = new HashSet<T>(set2);
    }

    public Set<T> getKnowns() {
        return this.knowns;
    }

    public Set<T> getUnknowns() {
        return this.unknowns;
    }

    public void add(T t, Bool bool) {
        if (bool.isTrue()) {
            this.knowns.add(t);
        } else if (bool.isUnknown()) {
            this.unknowns.add(t);
        }
    }

    public void update(T t, Bool bool) {
        if (!bool.isTrue()) {
            if (bool.isFalse()) {
                this.remove(t);
            } else if (this.knowns.contains(t)) {
                this.knowns.remove(t);
                this.unknowns.add(t);
            }
        }
    }

    public boolean remove(Object object) {
        return this.knowns.remove(object) || this.unknowns.remove(object);
    }

    public boolean contains(Object object) {
        return this.knowns.contains(object) || this.unknowns.contains(object);
    }

    public int size() {
        return this.knowns.size() + this.unknowns.size();
    }

    public Iterator<T> iterator() {
        return new PairIterator<T>(this.knowns.iterator(), this.unknowns.iterator());
    }

    public String toString() {
        return "Knowns: " + this.knowns.size() + " Unknowns: " + this.unknowns.size();
    }
}

