/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TableData {
    Collection data;
    List colNames;
    boolean[] rightAligned;
    int[] colWidths = null;
    String colSep = " | ";

    public TableData(Collection collection, List list) {
        this.data = collection;
        this.colNames = list;
        int n = list.size();
        this.colWidths = new int[n];
        this.rightAligned = new boolean[n];
    }

    public TableData(List list) {
        this.data = new ArrayList();
        this.colNames = list;
        int n = list.size();
        this.colWidths = new int[n];
        this.rightAligned = new boolean[n];
    }

    public TableData(String[] stringArray) {
        this(Arrays.asList(stringArray));
    }

    public void setAlignment(boolean[] blArray) {
        if (blArray.length != this.colNames.size()) {
            throw new IllegalArgumentException("Alignment has " + blArray.length + " elements but table has " + this.colNames.size() + " columns");
        }
        this.rightAligned = blArray;
    }

    public void setrightAligned(int n, boolean bl) {
        this.rightAligned[n] = bl;
    }

    public void addRow(List list) {
        this.add(list);
    }

    public void add(List list) {
        if (list.size() != this.colNames.size()) {
            throw new IllegalArgumentException("Row has " + list.size() + " elements but table has " + this.colNames.size() + " columns");
        }
        this.data.add(list);
    }

    public void print(OutputStream outputStream) {
        this.print(new PrintWriter(outputStream));
    }

    public void print(PrintWriter printWriter) {
        this.printText(printWriter);
    }

    public void print(Writer writer) {
        this.printText(writer);
    }

    private void printText(Writer writer) {
        int n;
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.computeHeaderWidths();
        this.computeRowWidths();
        int n2 = this.computeLineWidth();
        int n3 = this.colNames.size();
        String[] stringArray = new String[n3];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.colNames.get(n).toString();
        }
        this.printRow(printWriter, stringArray);
        for (n = 0; n < n2; ++n) {
            printWriter.print('=');
        }
        printWriter.println();
        for (Collection collection : this.data) {
            Iterator iterator = collection.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                stringArray[n4] = e == null ? "<null>" : e.toString();
                ++n4;
            }
            this.printRow(printWriter, stringArray);
        }
        printWriter.flush();
    }

    private void printRow(PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = this.colWidths[i];
            StringBuffer stringBuffer = new StringBuffer(120);
            if (i > 0) {
                stringBuffer.append(this.colSep);
            }
            if (!this.rightAligned[i]) {
                stringBuffer.append(string);
            }
            for (int j = 0; j < n - string.length(); ++j) {
                stringBuffer.append(' ');
            }
            if (this.rightAligned[i]) {
                stringBuffer.append(string);
            }
            printWriter.print(stringBuffer);
        }
        printWriter.println();
    }

    private int computeLineWidth() {
        int n = this.colWidths.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.colWidths[i];
        }
        return n2 += (n - 1) * this.colSep.length();
    }

    private void computeHeaderWidths() {
        Iterator iterator = this.colNames.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = e == null ? "<null>" : e.toString();
            this.colWidths[n] = string.length();
            ++n;
        }
    }

    private void computeRowWidths() {
        for (Collection collection : this.data) {
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string;
                Object e = iterator.next();
                String string2 = string = e == null ? "<null>" : e.toString();
                if (this.colWidths[n] < string.length()) {
                    this.colWidths[n] = string.length();
                }
                ++n;
            }
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColCount() {
        return this.colNames.size();
    }

    public void sort(String string) {
        this.sort(this.colNames.indexOf(string));
    }

    public void sort(final int n) {
        Object[] objectArray = this.data.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)((List)object).get(n)).compareTo(((List)object2).get(n));
            }
        });
        this.data = Arrays.asList(objectArray);
    }

    public void sort(final int n, final Comparator comparator) {
        Object[] objectArray = this.data.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return comparator.compare(((List)object).get(n), ((List)object2).get(n));
            }
        });
        this.data = Arrays.asList(objectArray);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.printText(stringWriter);
        return stringWriter.toString();
    }
}

