/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.Tester;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;

public class TesterBuiltIn
implements BuiltIn {
    private Tester test;

    public TesterBuiltIn(Tester tester) {
        this.test = tester;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom builtInAtom) {
        return new TestHelper(builtInAtom);
    }

    private class TestHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private boolean result;

        public TestHelper(BuiltInAtom builtInAtom) {
            this.atom = builtInAtom;
            this.result = false;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> collection) {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> collection) {
            return VariableUtils.getVars(this.atom);
        }

        @Override
        public void rebind(VariableBinding variableBinding) {
            Literal[] literalArray = new Literal[this.atom.getAllArguments().size()];
            int n = 0;
            for (AtomDObject atomDObject : this.atom.getAllArguments()) {
                literalArray[n++] = variableBinding.get(atomDObject);
            }
            this.result = TesterBuiltIn.this.test.test(literalArray);
        }

        @Override
        public boolean selectNextBinding() {
            if (this.result) {
                this.result = false;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding variableBinding) {
        }
    }
}

